// ====================================================================
// @imageLoadCheck plugin
// - checks to make sure all images within an element have been loaded and
//   then executes a callback function
// - usage $().imageLoadCheck(callback)
// ====================================================================
(function($) {
    $.fn.extend({
        imageLoadCheck: function(callback) {
			
            return this.each(function() {

                var $this = $(this),
                $images = $this.find('img'),
                _numImages = $images.length,
                _imagesLoaded = 0;

                $images.each(function(index) {

                    var $img = $(this),
                   	imgURI = $img.attr('src');   

                    $img.attr('src', '');
                    $img.bind('load', _imageLoaded);
                    $img.attr('src', imgURI);

                    //console.log(index, imgURI)
                    if (imgURI == "") _numImages--;
                });

                function _imageLoaded() {    
					$(this).attr({
						 'width':this.width,
						 'height':this.height,
					})                                         
					
                    $(this).unbind('load', _imageLoaded);
                    _imagesLoaded++;


                    //console.log($(this).attr('src'), _imagesLoaded, _numImages)


                    if (_imagesLoaded == _numImages) {
                        callback($(this));
                    }
                }

            });
        }
    });
})(jQuery);