Swiper.prototype.plugins.hashNav = function (swiper, params) {
    'use strict';

    var isH = swiper.params.mode === 'horizontal';
    if (!params) return;

    function updateHash(internal) {
        document.location.hash = swiper.activeSlide().getAttribute('data-hash') || '';
        var hash = document.location.hash ;
        hash = hash.replace('#', '');
        if (hash != '') {
            // update url

            var root_raw = document.URL.split('/');
            // remove hash
            root_raw.splice(root_raw.length-1, 1);
            // remove product
            root_raw.splice(root_raw.length-1, 1);

            var newurl = root_raw.join('/') + "/" + hash  +  "/#" + hash;
            window.history.pushState("", "Pierre Katz", newurl);

        }
    }

    function swipeToHash(e) {
        var hash = document.location.hash.replace('#', '');
        if (!hash) return;
        var speed = e ? swiper.params.speed : 0;
        for (var i = 0, length = swiper.slides.length; i < length; i++) {
            var slide = swiper.slides[i];
            var slideHash = slide.getAttribute('data-hash');
            if (slideHash === hash && slide.getData('looped') !== true) {
                var index = slide.index();
                if (swiper.params.loop) index = index - swiper.loopedSlides;
                swiper.swipeTo(index, speed);
            }
        }
    }

    //Plugin Hooks
    return {
        onSwiperCreated : function (args) {
            swipeToHash();
        },
        onSlideChangeStart: function () {
            updateHash(true);
        },
        onSwipeReset: function () {
            updateHash(true);
        }
    };
};
