<?php




/*-----------------------------------------------------------------------------------*/
/* Functions
/*-----------------------------------------------------------------------------------*/


/* Add lib  */
include("functions/utils.php");


// -------------------------------------------------------------------------------------
// addjs script
add_action( 'wp_enqueue_scripts', 'katz_scripts' );

function katz_scripts() {

    wp_enqueue_style( 'swiper-master', get_stylesheet_directory_uri() . '/css/idangerous.swiper.css', array(), '2.6.1' );

    wp_dequeue_script('jquery-masonry');

	wp_enqueue_script( 'katz-main', get_stylesheet_directory_uri() . '/main.js', array( 'jquery' ));
	wp_enqueue_script( 'jquery-easing', get_stylesheet_directory_uri() . '/js/jquery.easing.1.3.js', array( 'jquery' ));
    wp_enqueue_script( 'swiper-master', get_stylesheet_directory_uri() . '/js/idangerous.swiper.js', array(), '2.6.1' );
    wp_enqueue_script( 'swiper-master-hashnav', get_stylesheet_directory_uri() . '/js/idangerous.swiper.hashnav.custom.js', array(), '1.0.0' );
    wp_enqueue_script( 'isotope', get_stylesheet_directory_uri() . '/js/isotope.pkgd.min.js' );
	//wp_enqueue_script( 'isotope', get_stylesheet_directory_uri() . '/js/isotope.pkgd.min.js',  array());


}

// remove unused style from parent theme
add_action( 'wp_enqueue_scripts', 'dequeue_style', 100 );

function dequeue_style() {
    wp_dequeue_style( 'twentyfourteen-lato' );
    wp_deregister_style( 'twentyfourteen-lato' );

}



// -------------------------------------------------------------------------------------
// THIS GIVES US SOME OPTIONS FOR STYLING THE ADMIN AREA
function custom_colors() {
   echo '<style type="text/css">
           .help {
                color: #899194;
                font-size: 12px;
                font-style: italic;
           }
         </style>';
}

add_action('admin_head', 'custom_colors');

// -------------------------------------------------------------------------------------
// Change wording, articles become Clients

function change_post_menu_label() {
    global $menu;
    global $submenu;
    $menu[5][0] = 'Clients';
    $submenu['edit.php'][5][0] = 'Clients';
    $submenu['edit.php'][10][0] = 'Add Clients';
   // $submenu['edit.php'][15][0] = 'Categories'; // Change name for categories
   // $submenu['edit.php'][16][0] = 'Labels'; // Change name for tags
    echo '';
}

function change_post_object_label() {
        global $wp_post_types;
        $labels = &$wp_post_types['post']->labels;
        $labels->name = 'Clients';
        $labels->singular_name = 'Client';
        $labels->add_new = 'Add Client';
        $labels->add_new_item = 'Add Client';
        $labels->edit_item = 'Edit Clients';
        $labels->new_item = 'Client';
        $labels->view_item = 'View Client';
        $labels->search_items = 'Search Clients';
        $labels->not_found = 'No Client found';
        $labels->not_found_in_trash = 'No Client found in Trash';
    }
    add_action( 'init', 'change_post_object_label' );
    add_action( 'admin_menu', 'change_post_menu_label' );


/*-----------------------------------------------------------------------------------*/
/*   add submenu
/*-----------------------------------------------------------------------------------*/
//

// portfolio
function headerPortfolio() {
    // portfolio
    // submenu
    $submenu = hierarchical_submenu();
    echo $submenu;

    /*
    if(is_front_page()) {
        $id = getPortfolioFirstPostId();
    } else {
        $id = get_the_ID();
    }
    */
}

function hierarchical_submenu() {
    $page_object = get_queried_object();
    $page_id     = get_queried_object_id();

    if($page_id != 9 && $page_id !=13 && $page_id != 11 ) {
        
        ?>
        <?php 
            //wp_list_categories('use_desc_for_title=1&exclude=1&title_li='); 
       

    /* <li class="cat-item cat-item-2 current-cat"><a href="category/champagne-spirits/" title="1">Champagne &amp; spirits</a>
</li><li class="cat-item cat-item-3"><a href="category/fashion-perfumes/" title="2" style="color: rgb(0, 0, 0);">Fashion &amp; perfumes</a>
</li><li class="cat-item cat-item-5"><a href="category/hotels-gastronomy/" title="3">Hotels &amp; gastronomy</a>
</li><li class="cat-item cat-item-4"><a href="category/culture-media/" title="4">Culture &amp; media</a>
</li> */
        
        if(ICL_LANGUAGE_CODE == 'en') {
         
         ?>

        <ul class="sub-categ sub-categ-en">
            <li class="cat-item cat-item-2"><a href="#" title="1">Champagne &amp; Spirits</a>
            </li><li class="cat-item cat-item-3" rel-lang="en"><a href="#" title="2">Fashion &amp; Perfumes</a>
            </li><li class="cat-item cat-item-5" rel-lang="en"><a href="#" title="3">Hotels &amp; Gastronomy</a>
            </li><li class="cat-item cat-item-4" rel-lang="en"><a href="#" title="4">Culture &amp; Media</a>
            </li> 


        <?php

        } else {

        ?>

        <ul class="sub-categ sub-categ-fr">
            <li class="cat-item cat-item-2"><a href="#" title="1">Champagne &amp; Spiritueux</a>
            </li><li class="cat-item cat-item-3" rel-lang="fr"><a href="#" title="2">Mode &amp; Parfums</a>
            </li><li class="cat-item cat-item-5" rel-lang="fr"><a href="#" title="3">Hotels &amp; Gastronomie</a>
            </li><li class="cat-item cat-item-4" rel-lang="fr"><a href="#" title="4">Culture &amp; Media</a>
            </li> 

        <?php
        
        }

        ?>

        </ul>

        <?php
    } else if ($page_id == 9 || $page_id == 11) {
        // vision and process
        if(ICL_LANGUAGE_CODE == 'en') {

         ?>

        <ul class="sub-categ-approach-en">
            <li class="cat-item-approach approach-vision">
                <a href="" rel-lang="en">How we work</a>
            </li>
            <li class="cat-item-approach approach-about">
                <a href="" rel-lang="en">Who we are</a>
            </li>


        <?php

        } else {

        ?> 
        <ul class="sub-categ-approach-fr">
            <li class="cat-item-approach approach-vision">
                <a href="" rel-lang="fr">Notre approche</a>
            </li>
            <li class="cat-item-approach approach-about">
                <a href="" rel-lang="fr">Qui nous sommes</a>
            </li>

        </ul>
        <?php
        }
    }
}

function headerPortfolio_XS() {

    $submenu = hierarchical_submenu_xs();
    echo $submenu;
}

function hierarchical_submenu_xs () {
    $page_object = get_queried_object();
    $page_id     = get_queried_object_id();
    
    $is_current_5 = "";
    $is_current_11 = "";
    $is_current_13 = "";

    //echo $page_id;

    if($page_id != 9 && $page_id != 7 && ($page_id == 5 || $page_id == 11 || $page_id == 13)) {


        switch ($page_id) {
            case 5:
                // home
                $is_current_5 = 'current-menu-item'; 
                break;
            case 11:
                // about
                $is_current_11 = 'current-menu-item'; 
                break;
            case 13:
                // contact
                $is_current_13 = 'current-menu-item'; 
                break;
        }

        ?>
        <ul class="nav-menu-xs">
            <li class="menu-item-xs menu-item-26 <?php echo $is_current_5; ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">home</a></li>
            <li class="menu-item-xs menu-item-25"><a href="portfolio/"><span class="menu-client-xs">portfolio</span>
                <span class="menu-arrow">
                    <img class="rotate-90" src="<?php echo get_stylesheet_directory_uri(); ?>/img/menu_arrow.png" alt="">
                </span></a>
            </li>
            <li class="menu-item-xs menu-item-24"><a href="approach/">approach</a></li>
            <li class="menu-item-xs menu-item-23 <?php echo $is_current_11; ?>"><a href="about/">about</a></li>
            <li class="menu-item-xs menu-item-22 <?php echo $is_current_13; ?>"><a href="contact/">contact</a></li>
        </ul>
        <?php
    } else if ($page_id == 9) {
        // vision and process
          ?>
          <ul class="nav-menu-xs">
            <li class="menu-item-xs menu-item-26"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">news</a></li>
            <li class="menu-item-xs menu-item-25"><a href="portfolio/"><span class="menu-client-xs">portfolio</span>
                <span class="menu-arrow">
                    <img class="rotate-90" src="<?php echo get_stylesheet_directory_uri(); ?>/img/menu_arrow.png" alt="">
                </span></a>
            </li>
            <li class="menu-item-xs menu-item-24 current-menu-item">
                <a href="approach/">
                    <span class="menu-client-xs">approach</span>
                    <!--<span class="menu-arrow">
                        <img class="rotate-0" src="<?php echo get_stylesheet_directory_uri(); ?>/img/menu_arrow.png" alt="">
                    </span>-->
                </a>
                <ul class="sub-categ-approach-xs">
                    <li class="cat-item-approach">
                        <a href="">Vision</a>
                    </li>
                    <li class="cat-item-approach">
                        <a href="">Process</a>
                    </li>
                </ul>
            </li>
            <li class="menu-item-xs menu-item-23 <?php echo $is_current_11; ?>"><a href="about/">about</a></li>
            <li class="menu-item-xs menu-item-22 <?php echo $is_current_13; ?>"><a href="contact/">contact</a></li>
        </ul>
        <?php
    } else {
        // clients & single
         ?>
        <ul class="nav-menu-xs">
            <li class="menu-item-xs menu-item-26"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">home</a></li>
            <li class="menu-item-xs menu-item-25 menu-item-xs-open current-menu-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>/clients/"><span class="menu-client-xs">clients</span>
                <span class="menu-arrow">
                    <img class="rotate-0" src="<?php echo get_stylesheet_directory_uri(); ?>/img/menu_arrow.png" alt="">
                </span></a>

                <ul class="sub-categ-xs">
         
                    <li class="cat-item-xs cat-item-2"><a href="#" title="1">Champagne &amp; spirits</a>
                    </li><li class="cat-item-xs cat-item-3"><a href="#" title="2">Fashion &amp; perfumes</a>
                    </li><li class="cat-item-xs cat-item-5"><a href="#" title="3">Hotels &amp; gastronomy</a>
                    </li><li class="cat-item-xs cat-item-4"><a href="#" title="4">Culture &amp; media</a>
                    </li> 

                </ul>

            </li>
            <li class="menu-item-xs menu-item-24"><a href="approach/">approach</a></li>
            <li class="menu-item-xs menu-item-23"><a href="about/">about</a></li>
            <li class="menu-item-xs menu-item-22"><a href="contact/">contact</a></li>
        </ul>
        <?php
    }
}

/*-----------------------------------------------------------------------------------*/
/*   wpml lang switcher
/*-----------------------------------------------------------------------------------*/

function wpml_getHomeLanguageLink(){
    $languages = icl_get_languages('skip_missing=1');

    // echo '<pre>';
    // print_r($languages);
    // echo '</pre>';

    echo '<a href="' . $languages[wpml_getOtherLanguage('CODE')]['url'] . '">' . strtolower(wpml_getOtherLanguage('NAME')) . '</a>';

    //echo wpml_getOtherLanguage('CODE') . " // " . $languages[wpml_getOtherLanguage('CODE')]['url'];
}

function wpml_getOtherLanguage($param) {
  
    switch ($param) {
        case 'CODE':
            $result = ICL_LANGUAGE_CODE == 'en' ? 'fr' : 'en';
            break;
        case 'NAME':
            $result = ICL_LANGUAGE_NAME == 'English' ? 'Français' : 'English';
            break;
    }

    //echo $param . ' : ' . $result;

    return $result;

}
/*-----------------------------------------------------------------------------------*/
/*   add rewrite rules
/*-----------------------------------------------------------------------------------*/
//

//add_filter( 'rewrite_rules_array','my_insert_rewrite_rules' );
//add_filter( 'query_vars','my_insert_query_vars' );
//add_action( 'wp_loaded','my_flush_rules' );
/*
// flush_rules() if our rules are not yet included
function my_flush_rules(){
    $rules = get_option( 'rewrite_rules' );

    if ( ! isset( $rules['(project)/(\d*)$'] ) ) {
        global $wp_rewrite;
        $wp_rewrite->flush_rules();
    }
}

// Adding a new rule
function my_insert_rewrite_rules( $rules )
{
    $newrules = array();
    $newrules['(category)/(\d*)$'] = 'index.php?pagename=$matches[1]&id=$matches[2]';
    return $newrules + $rules;
}

// Adding the id var so that WP recognizes it
function my_insert_query_vars( $vars )
{
    array_push($vars, 'id');
    return $vars;
}
*/

/*
function custom_rewrite_tag() {
    add_rewrite_tag('%categ%', '([^&]+)');
    add_rewrite_rule('^categ/([^/]*)/([^/]*)/?','index.php?page_id=7&categ=$matches[1]','top');
}
add_action('init', 'custom_rewrite_tag', 10, 0);
*/

?>