<?php
/**
 * The Header for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage fruitdudragon
 * @since Fruit du dragon 1.0
 */
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11"> 
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	
	<link href='http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300' rel='stylesheet' type='text/css'>

    <meta name="keywords" content="pierre katz, pierrekatz, dianealexandre, diane alexandre, Pierre Katz identité de marque et typographie, Pierre Katz brand identity and typography, brand identity, brand identity paris, brand design, brand design paris, graphic design, graphic design paris, corporate identity, corporate identity paris, packaging design, packaging design paris, packaging, packaging paris, branding, branding paris, logo designer, logo designer paris, creative design, creative design, paris, design corporate logo,corporate identity design, corporate identity design paris, graphic art design, corporate branding, brand logo, identity design, identity design paris, global design,brand strategy, global brand, design guidelines, design visual,typography paris, design paris, luxury design, luxury graphic design, luxury brand design, luxury logo paris, artisan of signs, parisian designer, luxury design paris, french design, french designer, french luxury, french brand, identité de marque, design de marque, design de logotypes, design de packaging, design créatif, marque de luxe, luxe, grandes marques, grandes maisons, maisons de luxe, luxe à la française, design français, design institutionnel, workshop, agency, agence, atelier, artisan, excellence, exception, savoir-faire, craft, drawing, letters, lettres, dessin de lettre, dessin de caractère, font design, heraldry, héraldique, blason, emblem design, modern heraldry, communication, stratégie de marque, heritage, héritage, culture, idea, idée, artwork, sur-mesure, tailor-made, precision, précision, continuity, pérrenité, lifting, lifting de marque, brand lifting, iconographie, iconography, archives, valeurs, values, brand value, technical advice, recommandation technique, disponibilité, disponibility, évidence, sens, meaning, codes, langage, légitimité, personality, luxury house, obviousness, graphic chain, sustainable, natural, legitimity, Sofitel, Château de Pommard, Dom Pérignon, Moët & Chandon, Hermès, Thierry Mugler, Lejay, Ruinart, Rémy Martin, Roger & Gallet, Favarger, Dom Ruinart, Scarlett, Cacharel, Catherine Deneuve, Sonia Rykiel, Fussigny, Le Point, Garriga, La Cuina d'en Garriga, Cinco jotas, 5j, Cointreau, Cointreau Noir, Alaïa, Azzedine Alaïa, lemonde.fr">
    <meta name="description" content="Design workshop in Paris specialized in luxury brand identity design : brand identity, art direction and design. Logotypes, graphic guidelines and packaging.">
	<link rel="canonical" href="http://www.pierrekatz.com">
    <link rel="apple-touch-icon-precomposed" href="apple-touch-icon.png">  

	<?php if (have_posts()):while(have_posts()):the_post(); endwhile; endif;?>

	<!--FACEBOOK-->
	<!--<meta property="fb:app_id" content="[FB_APP_ID]" />-->

	<meta property="og:site_name" content="PIERRE KATZ Luxury Brand Identity Design. Paris">
	<meta property="og:type" content="website" >
	<meta property="og:locale" content="fr_FR" >
	<meta property="og:locale:alternate" content="en_EN" >
	<meta property="article:author" content="https://www.facebook.com/groups/208897439144706/" />

	<!--TWITTER-->
	<meta property="twitter:card" content="summary" >
	<meta property="twitter:creator" content="Pierre Katz" >

	<!-- if page is content page -->
	<?php if (is_single()) { ?>

		<meta property="og:title" content="<?php single_post_title(''); ?>" >
		<meta property="og:url" content="<?php the_permalink() ?>" >
		<meta property="og:description" content="<?php echo strip_tags(get_the_content($post->ID)); ?>" >
		<meta property="og:image" content="<?php if (function_exists('wp_get_attachment_thumb_url')) {echo wp_get_attachment_thumb_url(get_post_thumbnail_id($post->ID)); } else { echo './pk_facebook.jpg';} ?>" >
	
		<meta property="twitter:title" content="<?php single_post_title(''); ?>" >
		<meta property="twitter:url" content="http://www.pierrekatz.com" >
		<meta property="twitter:image" content="<?php if (function_exists('wp_get_attachment_thumb_url')) {echo wp_get_attachment_thumb_url(get_post_thumbnail_id($post->ID)); } else { echo './pk_twitter.jpg';} ?>" >
		<meta property="twitter:description" content="<?php echo strip_tags(get_the_content($post->ID)); ?>" >


	<!-- if page is others -->
	<?php } else { ?>

		<meta property="og:title" content="PIERRE KATZ Luxury Brand Identity Design. Paris" >
		<meta property="og:url" content="http://www.pierrekatz.com" >
		<meta property="og:description" content="Design workshop in Paris specialized in luxury brand identity design : brand identity, art direction and design. Logotypes, graphic guidelines and packaging." >
		<meta property="og:image" content="./pk_facebook.jpg" >
	
		<meta property="twitter:title" content="PIERRE KATZ Luxury Brand Identity Design. Paris" >
		<meta property="twitter:url" content="http://www.pierrekatz.com" >
		<meta property="twitter:image" content="./pk_twitter.png" >
		<meta property="twitter:description" content="Design workshop in Paris specialized in luxury brand identity design : brand identity, art direction and design. Logotypes, graphic guidelines and packaging." >

	<?php } ?>


	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
	<script src="<?php echo get_stylesheet_directory_uri(); ?>/js/greensock/TweenMax.min.js"></script>
	<script>

	// Global Namespace
	var app = window.app || {};

	if (app) {
		app.theme_path = "<?php echo get_stylesheet_directory_uri(); ?>";
		if (app.theme_path == undefined) app.theme_path = "";
	}
	</script>


	<script async defer src="//assets.pinterest.com/js/pinit.js"></script>

	<script>
	// analytics
	  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
	  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
	  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

	  ga('create', 'UA-654256-33', 'auto');
	  ga('send', 'pageview');

	</script>


	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> rel-lang="<?php echo ICL_LANGUAGE_CODE; ?>">

	<?php

	if ( is_home() ) {
	 	// blog page -> show newsletter link

	?>

		<!-- Begin MailChimp Signup Form -->
		<!-- <link href="//cdn-images.mailchimp.com/embedcode/classic-10_7.css" rel="stylesheet" type="text/css"> -->
	

		<div id="mc_embed_signup">

			    <div id="mc_embed_signup_scroll">
		<?php 
			/*
			<form action="//pierrekatz.us13.list-manage.com/subscribe/post?u=c34c2724c4328ecbf529f4510&amp;id=bdae0093bb" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>
			    <div class="close"><a href="#">close</a></div>
			<div class="mc-field-group">
				<label for="mce-EMAIL">Email Address</label>
				<input type="email" value="" name="EMAIL" class="required email" id="mce-EMAIL">
			</div>
				<div id="mce-responses" class="clear">
					<div class="response" id="mce-error-response" style="display:none"></div>
					<div class="response" id="mce-success-response" style="display:none"></div>
				</div>    <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
			    <div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_c34c2724c4328ecbf529f4510_bdae0093bb" tabindex="-1" value=""></div>
			    <div class="clear"><input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe" class="button"></div>
			    
			</form> 
			*/
			?>
			<?php
				// mailchimp for wordpress plugin shortchode
				//echo do_shortcode('[mc4wp_form id="3406"]');

				// Easy Peasy MailChimp Ajax Form plugin
				echo do_shortcode('[epm_mailchimp]');

			?>
			</div>
		</div>

	<?php 
	}
	?>

<div id="page" class="hfeed site">
	
	<div id="site-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</div>

	<header id="masthead" class="site-header" role="banner">
		<div class="header-main">
			<div class="navigation-xs">
				<div class="btn-menu">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/menu_xs.png" alt="">
				</div>

				<?php
					// get categories
					headerPortfolio_XS();

					if (ICL_LANGUAGE_CODE == 'fr') {
						$id_home = 5;
					} else {
						$id_home = 611;
					}

					$logo_desktop = get_field('logo', $id_home);
					$logo_ipad_h = get_field('logo_ipad_h', $id_home);
					$logo_ipad_v = get_field('logo_ipad_v', $id_home);
					$logo_iphone_h_v = get_field('logo_iphone_h_v', $id_home);


				?>
			</div>
			<div class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
				<img class="logo-desktop" src="<?php echo $logo_desktop['url']; ?>">
				<img class="logo-ipad_h" src="<?php echo $logo_ipad_h['url']; ?>"/>
				<img class="logo-ipad_v" src="<?php echo $logo_ipad_v['url']; ?>"/>
				<img class="logo-iphone_h_v" src="<?php echo $logo_iphone_h_v['url']; ?>"/>
			</a></div>
	
			<nav id="primary-navigation" class="site-navigation primary-navigation" role="navigation">
		
				<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
				<?php 

				/*if (ICL_LANGUAGE_CODE == 'fr') {  
		        	// display the menu en francais 
		            wp_nav_menu( array( 'menu' => 'menu fr', 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) );       
		        } else {  
		        	// show them the menu in English
		            wp_nav_menu( array( 'menu' => 'menu en', 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) );
		        }; 
		        */
		        ?>  


			</nav>

			<div class="clear"></div>


			<?php
				
				// get categories
				headerPortfolio();
			?>

			<div class="clear"></div>
			
			<?php

			if ( is_home() ) {
			 	// blog page -> show newsletter link

				?>


				<div class="newsletter">
					<a href="#">NEWSLETTER</a>	
				</div>
				<?php
			}

			?>


			<div class="lang">
				<?php wpml_getHomeLanguageLink(); ?>
			</div>

			
			
			
		</div>

	
	</header><!-- #masthead -->


	<div id="main" class="site-main fluid">



