<?php



/*-----------------------------------------------------------------------------------*/
/* Functions
/*-----------------------------------------------------------------------------------*/


/* Add lib  */
include("functions/utils.php");


define("ID_CHAMPAGNE_FR", 2);
define("ID_CULTURE_FR", 4);
define("ID_HOTELS_FR", 5);
define("ID_MODE_FR", 3);

define("ID_CHAMPAGNE_EN", 9);
define("ID_CULTURE_EN", 12);
define("ID_MODE_EN", 14);
define("ID_HOTELS_EN", 15);


// $ID_CHAMPAGNE_FR = 2;
// $ID_CULTURE_FR = 4;
// $ID_HOTELS_FR = 5;
// $ID_MODE_FR = 3;

// $ID_CHAMPAGNE_EN = 9;
// $ID_CULTURE_EN = 12;
// $ID_HOTELS_EN = 14;
// $ID_MODE_EN = 15;


// -------------------------------------------------------------------------------------
// addjs script
add_action( 'wp_enqueue_scripts', 'katz_scripts' );

function katz_scripts() {

    wp_enqueue_style( 'swiper-master', get_stylesheet_directory_uri() . '/css/idangerous.swiper.css', array(), '2.6.1' );
    //wp_enqueue_style( 'swiper-master', get_stylesheet_directory_uri() . '/css/swiper.min.css', array(), '3.0.0' );

    wp_dequeue_script('jquery-masonry');
    wp_deregister_script('jquery');
   
    wp_register_script('jquery', "http" . ($_SERVER['SERVER_PORT'] == 443 ? "s" : "") . "://code.jquery.com/jquery-2.1.3.min.js", false, null);
    wp_enqueue_script('jquery');


	wp_enqueue_script( 'jquery-easing', get_stylesheet_directory_uri() . '/js/jquery.easing.1.3.js', array( 'jquery' ));

    wp_enqueue_script( 'swiper-master', get_stylesheet_directory_uri() . '/js/idangerous.swiper.custom.js', array(), '2.6.1' );
    wp_enqueue_script( 'swiper-master-hashnav', get_stylesheet_directory_uri() . '/js/idangerous.swiper.hashnav.custom.js', array(), '1.0.0' );
    //wp_enqueue_script( 'swiper-master', get_stylesheet_directory_uri() . '/js/swiper.jquery.min.js', array('jquery'), '3.0.0' );
    
    wp_enqueue_script( 'isotope', get_stylesheet_directory_uri() . '/js/isotope.pkgd.min.js' );
	//wp_enqueue_script( 'isotope', get_stylesheet_directory_uri() . '/js/isotope.pkgd.min.js',  array());

    wp_enqueue_script( 'imgloadcheck', get_stylesheet_directory_uri() . '/js/imageLoadCheck.js', array( 'jquery' ));

    wp_enqueue_script( 'katz-main', get_stylesheet_directory_uri() . '/main.js', array( 'jquery' ));


}

// remove unused style from parent theme
add_action( 'wp_enqueue_scripts', 'dequeue_style', 100 );

function dequeue_style() {
    wp_dequeue_style( 'twentyfourteen-lato' );
    wp_deregister_style( 'twentyfourteen-lato' );

}



// -------------------------------------------------------------------------------------
// THIS GIVES US SOME OPTIONS FOR STYLING THE ADMIN AREA
function custom_colors() {
   echo '<style type="text/css">
           .help {
                color: #899194;
                font-size: 12px;
                font-style: italic;
           }
         </style>';
}

add_action('admin_head', 'custom_colors');

// -------------------------------------------------------------------------------------
// Change wording, articles become Clients

// function change_post_menu_label() {
//     global $menu;
//     global $submenu;
//     $menu[5][0] = 'Clients';
//     $submenu['edit.php'][5][0] = 'Clients';
//     $submenu['edit.php'][10][0] = 'Add Clients';
//    // $submenu['edit.php'][15][0] = 'Categories'; // Change name for categories
//    // $submenu['edit.php'][16][0] = 'Labels'; // Change name for tags
//     echo '';
// }

// function change_post_object_label() {
//         global $wp_post_types;
//         $labels = &$wp_post_types['post']->labels;
//         $labels->name = 'Clients';
//         $labels->singular_name = 'Client';
//         $labels->add_new = 'Add Client';
//         $labels->add_new_item = 'Add Client';
//         $labels->edit_item = 'Edit Clients';
//         $labels->new_item = 'Client';
//         $labels->view_item = 'View Client';
//         $labels->search_items = 'Search Clients';
//         $labels->not_found = 'No Client found';
//         $labels->not_found_in_trash = 'No Client found in Trash';
//     }
// add_action( 'init', 'change_post_object_label' );
// add_action( 'admin_menu', 'change_post_menu_label' );


/*-----------------------------------------------------------------------------------*/
/*   add submenu
/*-----------------------------------------------------------------------------------*/
//

// portfolio
function headerPortfolio() {
    // portfolio
    // submenu
    $submenu = hierarchical_submenu();
    echo $submenu;

    /*
    if(is_front_page()) {
        $id = getPortfolioFirstPostId();
    } else {
        $id = get_the_ID();
    }
    */
}

function hierarchical_submenu() {
    $page_object = get_queried_object();
    $page_id     = get_queried_object_id();


    if($page_id != 9 && $page_id !=13 && $page_id != 11 && $page_id != 627 && $page_id != 1329
        && $page_id != 2619 && $page_id != 2624 && $page_id != 3166 && $page_id != 3332 && !is_home() && !(is_single() && get_post_type() == 'post')) { 
                
        
        ?>
        <?php 
            //wp_list_categories('use_desc_for_title=1&exclude=1&title_li='); 
       

    /* <li class="cat-item cat-item-2 current-cat"><a href="category/champagne-spirits/" title="1">Champagne &amp; spirits</a>
</li><li class="cat-item cat-item-3"><a href="category/fashion-perfumes/" title="2" style="color: rgb(0, 0, 0);">Fashion &amp; perfumes</a>
</li><li class="cat-item cat-item-5"><a href="category/hotels-gastronomy/" title="3">Hotels &amp; gastronomy</a>
</li><li class="cat-item cat-item-4"><a href="category/culture-media/" title="4">Culture &amp; media</a>
</li> */
        
        if(ICL_LANGUAGE_CODE == 'en') {
         
         ?>

        <ul class="sub-categ sub-categ-en">
            <li class="cat-item cat-item-<?php echo ID_CHAMPAGNE_EN; ?>" rel-id="<?php echo ID_CHAMPAGNE_EN; ?>" rel-lang="en"><a href="#" title="1">Wine &amp; Spirits</a>
            </li><li class="cat-item cat-item-<?php echo ID_MODE_EN; ?>" rel-id="<?php echo ID_MODE_EN; ?>" rel-lang="en"><a href="#" title="2">Fashion &amp; Perfumes</a>
            </li><li class="cat-item cat-item-<?php echo ID_HOTELS_EN; ?>" rel-id="<?php echo ID_HOTELS_EN; ?>" rel-lang="en"><a href="#" title="3">Hotels &amp; Gastronomy</a>
            </li><li class="cat-item cat-item-<?php echo ID_CULTURE_EN; ?>" rel-id="<?php echo ID_CULTURE_EN; ?>" rel-lang="en"><a href="#" title="4">Culture &amp; Media</a>
            </li> 


        <?php

        } else {

        ?>

        <ul class="sub-categ sub-categ-fr">
            <li class="cat-item cat-item-<?php echo ID_CHAMPAGNE_FR; ?>" rel-id="<?php echo ID_CHAMPAGNE_FR; ?>" rel-lang="fr"><a href="#" title="1">Vins &amp; Spiritueux</a>
            </li><li class="cat-item cat-item-<?php echo ID_MODE_FR; ?>" rel-id="<?php echo ID_MODE_FR; ?>" rel-lang="fr"><a href="#" title="2">Mode &amp; Parfums</a>
            </li><li class="cat-item cat-item-<?php echo ID_HOTELS_FR; ?>" rel-id="<?php echo ID_HOTELS_FR; ?>" rel-lang="fr"><a href="#" title="3">Hôtels &amp; Gastronomie</a>
            </li><li class="cat-item cat-item-<?php echo ID_CULTURE_FR; ?>" rel-id="<?php echo ID_CULTURE_FR; ?>" rel-lang="fr"><a href="#" title="4">Culture &amp; Médias</a>
            </li> 

        <?php
        
        }

        ?>

        </ul>

        <?php
    } else if ($page_id == 9 || $page_id == 11 || $page_id == 1329 || $page_id == 627 || $page_id == 2619 || $page_id == 2624) {
        // vision and process and liftong
        if(ICL_LANGUAGE_CODE == 'en') {
            /*
         ?>

        <ul class="sub-categ-approach-en">
            <li class="cat-item-approach approach-vision">
                <a href="" rel-lang="en">how we work</a>
            </li>
            <li class="cat-item-approach approach-about">
                <a href="" rel-lang="en">who we are</a>
            </li>


        <?php

        } else {

        ?> 
        <ul class="sub-categ-approach-fr">
            <li class="cat-item-approach approach-vision">
                <a href="" rel-lang="fr">notre approche</a>
            </li>
            <li class="cat-item-approach approach-about">
                <a href="" rel-lang="fr">qui nous sommes</a>
            </li>

        </ul>
        <?php
        */
        }
    }
}

function headerPortfolio_XS() {

    $submenu = hierarchical_submenu_xs();
    echo $submenu;
}

function hierarchical_submenu_xs () {
    $page_object = get_queried_object();
    $page_id     = get_queried_object_id();
    
    // $is_current_5 = "";
    // $is_current_11 = "";
    // $is_current_13 = "";
    // $is_current_actu = "";

    //echo $page_id;


    switch ($page_id) {
        case 5:
            // home
            //$is_current_approach = 'current-menu-item'; 
            break;
        case 9:
        case 627:
            // approach
            $is_current_approach = 'current-menu-item'; 
            break;
        case 11:
        case 1329:
            // about
            $is_current_about = 'current-menu-item'; 
            break;
        case 7:
        case 615:
            // portfolio
            $is_current_portfolio = 'current-menu-item'; 
            break;
        case 13:
        case 630:
            // contact
            $is_current_contact = 'current-menu-item'; 
            break;
        case 823:
        case 825:
            // actu
            $is_current_actu = 'current-menu-item'; 
            break;
        case 2619:
        case 2624:
            // lifting
            $is_current_lifting = 'current-menu-item'; 
            break;
        case 3330:
        case 3332:
            // blog
            $is_current_blog = 'current-menu-item'; 
            break;
    }

    if(ICL_LANGUAGE_CODE == 'fr') {
     
        ?>

        <ul class="nav-menu-xs">
          
            <li class="menu-item-xs menu-item-7 menu-item-xs-open <?php echo $is_current_portfolio; ?>">
                <a href="portfolio/">
                    <span class="inner">portfolio</span>
                    <span class="menu-arrow">
                        <img class="rotate-0" src="<?php echo get_stylesheet_directory_uri(); ?>/img/menu_arrow.png" alt="">
                    </span>
                </a>

                <ul class="sub-categ-xs">
         
                    <li class="cat-item-xs cat-item-<?php echo ID_CHAMPAGNE_FR; ?>" rel-id="<?php echo ID_CHAMPAGNE_FR; ?>"><a href="#" title="1">Vins &amp; Spiritueux</a>
                    </li><li class="cat-item-xs cat-item-<?php echo ID_MODE_FR; ?>" rel-id="<?php echo ID_MODE_FR; ?>"><a href="#" title="2">Mode &amp; Parfums</a>
                    </li><li class="cat-item-xs cat-item-<?php echo ID_HOTELS_FR; ?>" rel-id="<?php echo ID_HOTELS_FR; ?>"><a href="#" title="3">Hôtels &amp; gastronomie</a>
                    </li><li class="cat-item-xs cat-item-<?php echo ID_CULTURE_FR; ?>" rel-id="<?php echo ID_CULTURE_FR; ?>"><a href="#" title="4">Culture &amp; médias</a>
                    </li> 

                </ul>

            </li>
            <li class="menu-item-xs menu-item-24 <?php echo $is_current_approach; ?>">
                <div class="inner"><a href="approach/">notre approche</a></div>
            </li>
            <li class="menu-item-xs menu-item-3327 <?php echo $is_current_lifting; ?>">
                <div class="inner"><a href="lifting/">avant/après</a></div>
            </li>
            <li class="menu-item-xs menu-item-3328 <?php echo $is_current_about; ?>">
                <div class="inner"><a href="about/">à propos</a></div>
            </li>


            <li class="menu-item-xs menu-item-3333 <?php echo $is_current_blog; ?>">
               <!--  <div class="inner"><a href="blog/">blog</a></div> -->
                <div class="inner"><a href="/maintenance.html">blog</a></div>
            </li>
        </ul>

    <?php

    } // end lang fr

    else {
        
        // en 

        ?>

        <ul class="nav-menu-xs nav-menu-xs-en">
            
            <li class="menu-item-xs menu-item-615 menu-item-xs-open <?php echo $is_current_portfolio; ?>">
                <a href="portfolio/">
                    <span class="inner">portfolio</span>
                    <span class="menu-arrow">
                        <img class="rotate-0" src="<?php echo get_stylesheet_directory_uri(); ?>/img/menu_arrow.png" alt="">
                    </span>
                </a>

                <ul class="sub-categ-xs">
           
                    <li class="cat-item-xs cat-item-<?php echo ID_CHAMPAGNE_EN; ?>" rel-id="<?php echo ID_CHAMPAGNE_EN; ?>" rel-lang="en"><a href="#" title="1">Wine &amp; Spirits</a>
                    </li><li class="cat-item-xs cat-item-<?php echo ID_MODE_EN; ?>" rel-id="<?php echo ID_MODE_EN; ?>" rel-lang="en"><a href="#" title="2">Fashion &amp; Perfumes</a>
                    </li><li class="cat-item-xs cat-item-<?php echo ID_HOTELS_EN; ?>" rel-id="<?php echo ID_HOTELS_EN; ?>" rel-lang="en"><a href="#" title="3">Hotels &amp; Gastronomy</a>
                    </li><li class="cat-item-xs cat-item-<?php echo ID_CULTURE_EN; ?>" rel-id="<?php echo ID_CULTURE_EN; ?>" rel-lang="en"><a href="#" title="4">Culture &amp; Media</a>
                    </li> 

                </ul>

            </li>
        
            <li class="menu-item-xs menu-item-1332 <?php echo $is_current_approach; ?>">
                <div class="inner"><a href="approach/">how we work</a></div>
            </li>
            <li class="menu-item-xs menu-item-3357 <?php echo $is_current_lifting; ?>">
                <div class="inner"><a href="lifting/">before/after</a></div>
            </li>
            <li class="menu-item-xs menu-item-3358 <?php echo $is_current_about; ?>">
                <div class="inner"><a href="about/">about</a></div>
            </li>


            <li class="menu-item-xs menu-item-3356 <?php echo $is_current_blog; ?>">
                <!-- <div class="inner"><a href="blog/">blog</a></div> -->
                <div class="inner"><a href="/maintenance.html">blog</a></div>
            </li>
    </ul>

    <?php

    }
    
}

/*-----------------------------------------------------------------------------------*/
/*   wpml lang switcher
/*-----------------------------------------------------------------------------------*/

function wpml_getHomeLanguageLink(){
    $languages = icl_get_languages('skip_missing=1');

    // echo '<pre>';
    // print_r($languages);
    // echo '</pre>';

    //echo '<a href="' . $languages[wpml_getOtherLanguage('CODE')]['url'] . '">' . strtolower(wpml_getOtherLanguage('NAME')) . '</a>';

    //echo wpml_getOtherLanguage('CODE') . " // " . $languages[wpml_getOtherLanguage('CODE')]['url'];

    if(ICL_LANGUAGE_CODE == 'en')
        echo '<a href="' . $languages['fr']['url'] . '">FR</a> | <a class="active" href="' . $languages['en']['url'] . '"/>EN</a>';
    else
        echo '<a class="active" href="' . $languages['fr']['url'] . '">FR</a> | <a href="' . $languages['en']['url'] . '"/>EN</a>';
}

function wpml_getOtherLanguage($param) {
  
    switch ($param) {
        case 'CODE':
            $result = ICL_LANGUAGE_CODE == 'en' ? 'fr' : 'en';
            break;
        case 'NAME':
            $result = ICL_LANGUAGE_NAME == 'English' ? 'Français' : 'English';
            break;
    }

    //echo $param . ' : ' . $result;

    return $result;

}
/*-----------------------------------------------------------------------------------*/
/*   add shortcode for lifting
/*-----------------------------------------------------------------------------------*/

 
//[lifting anchor="foo-value" lang="fr"]My Caption[/lifting]
function lifting_func( $atts, $content = null ) {
    $a = shortcode_atts( array(
        'anchor' => '#',
        'label' => '',
        'lang' => 'fr'
    ), $atts );

    return '<a href="' . get_bloginfo('url') . ($a['lang'] == 'fr' ? '' : 'en/') . 'lifting/#' . esc_attr($a['anchor']) . '">' . $content . '</a>';
}
add_shortcode( 'lifting', 'lifting_func' );




// ----------------------------------------------------------------------------------------------------------------
// How to keep &nbsp; non-breaking spaces in the visual editor
// http://wordpress.stackexchange.com/questions/155856/how-to-keep-nbsp-non-breaking-spaces-in-the-visual-editor

function allow_nbsp_in_tinymce( $mceInit ) {
    $mceInit['entities'] = '160,nbsp,38,amp,60,lt,62,gt';   
    $mceInit['entity_encoding'] = 'named';
    return $mceInit;
}
add_filter( 'tiny_mce_before_init', 'allow_nbsp_in_tinymce' );
// ----------------------------------------------------------------------------------------------------------------
// mailchimp 

// function onEpmMailchimpSuccess($yo) {
//     //echo 'alors ? ';
// }
// add_action('epm_jquery_ajax_success_event', 'onEpmMailchimpSuccess');


// ----------------------------------------------------------------------------------------------------------------
// maintenance mode

add_action('wp_loaded', function() {
    global $pagenow;

    if(
       defined( 'IN_MAINTENANCE' )
        && IN_MAINTENANCE
       && $pagenow !== 'wp-login.php'
       && ! is_user_logged_in()
       //&& ! current_user_can('administrator')
    ) {
       header('HTTP/1.1 Service Unavailable', true, 503);
       header('Content-Type: text/html; charset=utf-8');
       if ( file_exists(WP_CONTENT_DIR . '/maintenance.php') ) {
          require_once(WP_CONTENT_DIR . '/maintenance.php' );
       }
       die();
    }

});


/*-----------------------------------------------------------------------------------*/
/*   add rewrite rules
/*-----------------------------------------------------------------------------------*/
//

//add_filter( 'rewrite_rules_array','my_insert_rewrite_rules' );
//add_filter( 'query_vars','my_insert_query_vars' );
//add_action( 'wp_loaded','my_flush_rules' );
/*
// flush_rules() if our rules are not yet included
function my_flush_rules(){
    $rules = get_option( 'rewrite_rules' );

    if ( ! isset( $rules['(project)/(\d*)$'] ) ) {
        global $wp_rewrite;
        $wp_rewrite->flush_rules();
    }
}

// Adding a new rule
function my_insert_rewrite_rules( $rules )
{
    $newrules = array();
    $newrules['(category)/(\d*)$'] = 'index.php?pagename=$matches[1]&id=$matches[2]';
    return $newrules + $rules;
}

// Adding the id var so that WP recognizes it
function my_insert_query_vars( $vars )
{
    array_push($vars, 'id');
    return $vars;
}
*/

/*
function custom_rewrite_tag() {
    add_rewrite_tag('%categ%', '([^&]+)');
    add_rewrite_rule('^categ/([^/]*)/([^/]*)/?','index.php?page_id=7&categ=$matches[1]','top');
}
add_action('init', 'custom_rewrite_tag', 10, 0);
*/

?>