<?php
/*
Plugin Name: Pierre Katz - enhance-admin
Plugin URI:
Description: remove links on admin backoffice, customize admin
Author: Fruit du dragon
Version: 0.1
Author URI: http://www.fruitdudragon.com
*/



//if(is_admin()) {
  new KatzAdmin();
//}  

//Define the class
class KatzAdmin {

		// hide or show color, toolbar, etc.
		private $show_profile_parameters = false;

    //Define the constructor
    public function __construct() {
    
      // customize logo form login page
      add_action('login_enqueue_scripts',  array($this,'my_login_logo'));
    	// remove toolbar links
      add_action('wp_head',  array($this,'favicon_link'));
      add_action('wp_before_admin_bar_render', array($this, 'remove_admin_bar_links'));
      // remove toolbar on front
      add_action('after_setup_theme', array($this,'remove_admin_bar'));

      // remove dashboard widget
      add_action('wp_dashboard_setup',  array($this,'wpc_dashboard_widgets'));  

      // customize side bar
      add_action('admin_head',  array($this,'remove_menu_pages'));

      // customize footer
      add_filter('admin_footer_text',  array($this,'remove_footer_admin'));

      // loading js script to remove some few things
      add_action('admin_print_scripts', array($this,'load_scripts'));
      add_action('admin_print_styles', array($this,'load_styles'));
    }

    
    public function load_scripts() {
      // load js script to remove things
      //if ( current_user_can( 'author' ) ) {
        wp_enqueue_script('jquery');
        $siteurl = get_option('siteurl');
        $js_url = $siteurl . '/wp-content/plugins/' . basename(dirname(__FILE__)) . '/main.js';
        wp_enqueue_script('katzEnhanceAdminJs', $js_url);
      //}
    }
    
    
    public function load_styles() {
      // load css script to remove things
      if ( current_user_can( 'author' ) ) {
        $siteurl = get_option('siteurl');
        $css_url = $siteurl . '/wp-content/plugins/' . basename(dirname(__FILE__)) . '/main.css';
        wp_enqueue_style('katzEnhanceAdminCss', $css_url);
      }
    }


  // ============================================================================================================
  /*
      :::::::::::   ::::::::   :::::::::  
          :+:      :+:    :+:  :+:    :+: 
          +:+      +:+    +:+  +:+    +:+ 
          +#+      +#+    +:+  +#++:++#+  
          +#+      +#+    +#+  +#+        
          #+#      #+#    #+#  #+#        
          ###       ########   ###        
  */
  /**
   * Remove top links
   **/
  public function remove_admin_bar_links() {
      global $wp_admin_bar;

      if($this->get_current_user_role() == 'editor') {
        /*
          $wp_admin_bar->remove_menu('updates');          // Remove the updates link
          $wp_admin_bar->remove_menu('comments');         // Remove the comments link
          $wp_admin_bar->remove_menu('new-content');      // Remove the content link
          $wp_admin_bar->remove_menu('w3tc');             // If you use w3 total cache remove the performance link
         // $wp_admin_bar->remove_menu('my-account');       // Remove the user details tab
          $wp_admin_bar->remove_menu('my-blogs');  
          $wp_admin_bar->remove_menu('my-account-with-avatar');  
          $wp_admin_bar->remove_menu('site-name');  
          $wp_admin_bar->remove_menu('dashboard');  
          $wp_admin_bar->remove_menu('view'); 
          $wp_admin_bar->remove_menu('my-sites');     // Hide My Sites menu 

					show_admin_bar(false);
          */
          $wp_admin_bar->remove_menu('wp-logo');      // Hide WordPress logo menu completely 
      }


    // branding with logo admin toolbar
      $wp_admin_bar->add_node(array(
        'id' => 'katz'
      ));
      ?>
      <style type="text/css">
		#wp-admin-bar-katz {
		  
		  background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/img/logo_xs.png) !important;
		  background-size: 126px 29px;
      background-position: 10px 10px !important;
      background-repeat: no-repeat !important;
		  width: 136px;
		  height: 39px;
      margin-right: 15px !important;
		}
        
        html { margin-top: 35px !important; }
        * html body { margin-top: 35px !important; }
        
        /*
        html { margin-top: 114px !important; }
        * html body { margin-top: 114px !important; }
        */
        li#wp-admin-bar-katz .ab-item {
          height: 0px !important;
        }
        #wpadminbar {
            height: 67px !important;
        }
       </style>
      
      <?php  
      // for admin, put logo in first position in toolbar
      if ( current_user_can( 'manage_categories' ) ) { 
        //$siteurl = get_option('siteurl');
        //$js_url = $siteurl . '/wp-content/plugins/' . basename(dirname(__FILE__)) . '/main.js';
        //echo "<script type='text/javascript' src='$js_url'></script>\n";
        
        echo "<script type='text/javascript'>jQuery(document).ready(function($) {"; 
        echo "  $('#wp-admin-bar-root-default li#wp-admin-bar-katz').insertBefore('#wp-admin-bar-root-default li#wp-admin-bar-menu-toggle');";
        echo "  });";
        echo " </script>";
     }
  }

	function remove_admin_bar() {
		if (current_user_can('manage_categories') && !is_admin()) {
		  show_admin_bar(false);
		}
	}


  // ============================================================================================================
  /*
       ::::::::   :::::::::::  :::::::::   :::::::::: 
      :+:    :+:      :+:      :+:    :+:  :+:        
      +:+             +:+      +:+    +:+  +:+        
      +#++:++#++      +#+      +#+    +:+  +#++:++#   
             +#+      +#+      +#+    +#+  +#+        
      #+#    #+#      #+#      #+#    #+#  #+#        
       ########   ###########  #########   ########## 
  */
  /**
   * Removes side links
   **/
  
  public function remove_menu_pages() {
   
      //global $user_ID;

      if($this->get_current_user_role() == 'editor') {
          
          //$this->remove_admin_menu_items(array(__('Posts')));

          //remove_menu_page('edit.php');
          //remove_submenu_page('edit.php?post_type=post','post-new.php?post_type=post');
          //remove_menu_page('upload.php'); // Media
          //remove_menu_page('index.php');    /* Hides Dashboard menu */
          

          //remove_menu_page('separator');
          //remove_menu_page('separator1');   /* Hides separator under Dashboard menu*/

          // TODO check why this line doens't work
          //unset($submenu['edit.php?post_type=reparateur'][10]);
      }
  }

  public function remove_admin_menu_items($array) {
   
    //$remove_menu_items = array(__('Posts'),__('Links'), __('Comments'));
    $remove_menu_items = $array;
    global $menu;
    end ($menu);
    while (prev($menu)){
      $item = explode(' ',$menu[key($menu)][0]);
      if(in_array($item[0] != NULL?$item[0]:"" , $remove_menu_items)){
        unset($menu[key($menu)]);
      }
    }
  }

  // ============================================================================================================
  /*
     :::       ::::::::  :::::::::::::::::::::::    ::: 
     :+:      :+:    :+::+:    :+:   :+:    :+:+:   :+: 
     +:+      +:+    +:++:+          +:+    :+:+:+  +:+ 
     +#+      +#+    +:+:#:          +#+    +#+ +:+ +#+ 
     +#+      +#+    +#++#+   +#+#   +#+    +#+  +#+#+# 
     #+#      #+#    #+##+#    #+#   #+#    #+#   #+#+# 
     ##################  ######################    #### 
  */
  // branding login to admin
  public function my_login_logo() { 

      ?>
      <style type="text/css">
          body.login div#login h1 a {
              /*background-image: url(<?php echo get_bloginfo( 'template_directory' ) ?>/images/site-login-logo.png);*/
              background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/img/logo.png);
              background-size: 126px 29px;
              width: 126px;
              height: 29px;
              padding-bottom: 0px;
          }
          body.login {
            /*background-color: #1A171B;*/
          }
       </style>
  <?php }


  // ============================================================================================================
  /*
    ::::    ::::   :::::::::::   ::::::::    ::::::::  
     +:+:+: :+:+:+      :+:      :+:    :+:  :+:    :+: 
     +:+ +:+:+ +:+      +:+      +:+         +:+        
     +#+  +:+  +#+      +#+      +#++:++#++  +#+        
     +#+       +#+      +#+             +#+  +#+        
     #+#       #+#      #+#      #+#    #+#  #+#    #+# 
     ###       ###  ###########   ########    ########  
  */
  // Favicon
  public function favicon_link() {
      echo '<link rel="shortcut icon" type="image/x-icon" href="' . get_stylesheet_directory_uri() . '/img/favicon.ico" />' . "\n";
  }

  // Custom WordPress Footer
  public function remove_footer_admin () {
    echo '&copy; 2014 - WordPress, <a href="http://www.fruitdudragon.com" target="_blank">Fruit du dragon</a>';
  }

  // dashboard
  // http://wp.smashingmagazine.com/2012/05/17/customize-wordpress-admin-easily/
  public function wpc_dashboard_widgets() {
    
    global $wp_meta_boxes;
    // Today widget
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']);
    // Last comments
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']);
    // Incoming links
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']);
    // Plugins
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']);
    
    unset($wp_meta_boxes['dashboard']['normal']['high']['dashboard_browser_nag']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
    
  }
  // ============================================================================================================
  // M I S C E L L A N E U S

  /**
   * Returns the translated role of the current user. If that user has
   * no role for the current blog, it returns false.
   *
   * @return string The name of the current role
   **/
  public function get_current_user_role() {
    global $wp_roles;
    $current_user = wp_get_current_user();
    $roles = $current_user->roles;
    $role = array_shift($roles);
    //return isset($wp_roles->role_names[$role]) ? translate_user_role($wp_roles->role_names[$role] ) : false;
    return $role;
  }
}
?>