
<table class="wp-list-table widefat sucuriscan-table sucuriscan-scanner-details">
    <thead>
        <tr>
            <th colspan="3" class="thead-with-button">
                <span>%%SUCURI.WebsiteStatus%%</span>
                <a href="https://sucuri.net/website-antivirus/" target="_blank"
                class="thead-topright-action button-primary sucuriscan-%%SUCURI.FixButtonVisibility%%">
                Request Malware Cleanup</a>
            </th>
        </tr>
    </thead>

    <tbody>
        <tr>
            <td colspan="3">
                <p>
                    To reduce the bandwidth consumption and the amount of HTTP requests sent by your
                    website to the SiteCheck API service this plugin will cache the results of every
                    scan for <strong>%%SUCURI.CacheLifeTime%% seconds</strong>. If you want to get
                    fresh results after modifications suggested by the scanner then go to the <a
                    href="%%SUCURI.URL.Settings%%#scanner">scanner settings</a> page and
                    click the button in front of the label <em>"Reset sitecheck logs"</em>, then
                    come back to this page and run a new malware scan. Note that SiteCheck may cache
                    the results of the scan as well in its own server and there is no way you can
                    refresh that information from this plugin, in this case you have to be patient.
                </p>
            </td>
        </tr>

        %%%SUCURI.MalwarePayloadList%%%

        <tr class="sucuriscan-%%SUCURI.NoMalwareRowVisibility%%">
            <td><span class="sucuriscan-label sucuriscan-label-success">CLEAN</span></td>
            <td colspan="3">Malware</td>
        </tr>

        <tr class="sucuriscan-%%SUCURI.NoMalwareRowVisibility%%">
            <td><span class="sucuriscan-label sucuriscan-label-success">CLEAN</span></td>
            <td width="220">
                <a href="https://kb.sucuri.net/malware/encoded-javascript" target="_blank">
                    Malicious javascript
                </a>
            </td>
            <td>
                <div>
                    JavaScript is a language (code) that can be executed directly by the browser and
                    many other applications that support it (PDF, email readers, etc). Because it is
                    a full programming language executed by the browser, attackers use it heavily to
                    run malicious code from the compromised sites.
                </div>
            </td>
        </tr>

        <tr class="sucuriscan-%%SUCURI.NoMalwareRowVisibility%%">
            <td><span class="sucuriscan-label sucuriscan-label-success">CLEAN</span></td>
            <td width="220">
                <a href="https://kb.sucuri.net/malware/malicious-iframes" target="_blank">
                    Malicious iframes
                </a>
            </td>
            <td>
                <div>
                    An inline frame (iframe) is used to embed another document within the current
                    HTML document. Because as the definition implies, it allows you to insert
                    another document inside the current HTML page. And the attackers use that
                    feature to insert malicious content into the compromised sites (to redirect to
                    spam, exploit kits, Fake AV, phishing, etc).
                </div>
            </td>
        </tr>

        <tr class="sucuriscan-%%SUCURI.NoMalwareRowVisibility%%">
            <td><span class="sucuriscan-label sucuriscan-label-success">CLEAN</span></td>
            <td width="220">
                <a href="https://kb.sucuri.net/malware/conditional-redirections" target="_blank">
                    Suspicious redirections (htaccess)
                </a>
            </td>
            <td>
                <div>
                    Conditional redirections are classified differently than the iframe/javascript
                    ones, because they are generally done though the HTTP headers (via .htaccess) to
                    redirect users from certain browsers or locations to malware/malicious
                    locations.
                </div>
            </td>
        </tr>

        <tr class="sucuriscan-%%SUCURI.NoMalwareRowVisibility%%">
            <td><span class="sucuriscan-label sucuriscan-label-success">CLEAN</span></td>
            <td colspan="3">Blackhat SEO Spam</td>
        </tr>

        <tr class="sucuriscan-%%SUCURI.NoMalwareRowVisibility%%">
            <td><span class="sucuriscan-label sucuriscan-label-success">CLEAN</span></td>
            <td colspan="3">Anomaly detection</td>
        </tr>

        <tr>
            <td colspan="3">
                <hr>
                <em>
                    More details at <a href="https://sitecheck.sucuri.net/results/%%SUCURI.ScannedDomainName%%"
                    target="_blank">SiteCheck/%%SUCURI.ScannedDomainName%%</a>. If our free scanner
                    did not detect any issue, you may have a more complicated and hidden problem.
                    You can <a href="https://sucuri.net/signup" target="_blank">sign up</a> with
                    Sucuri for a complete and in depth scan+cleanup <strong>(not included in the
                    free checks)</strong>.
                </em>
            </td>
        </tr>
    </tbody>
</table>
