# WordPress MySQL database backup
#
# Generated: Thursday 16. July 2015 22:04 UTC
# Hostname: localhost
# Database: `pierrekatzweb`
# --------------------------------------------------------
# --------------------------------------------------------
# Table: `wp_commentmeta`
# --------------------------------------------------------


#
# Delete any existing table `wp_commentmeta`
#

DROP TABLE IF EXISTS `wp_commentmeta`;


#
# Table structure of table `wp_commentmeta`
#

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_commentmeta`
#

#
# End of data contents of table `wp_commentmeta`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_comments`
# --------------------------------------------------------


#
# Delete any existing table `wp_comments`
#

DROP TABLE IF EXISTS `wp_comments`;


#
# Table structure of table `wp_comments`
#

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_comments`
#
 
INSERT INTO `wp_comments` VALUES (1, 1, 'Monsieur WordPress', '', 'https://wordpress.org/', '', '2014-06-01 21:05:40', '2014-06-01 21:05:40', 'Bonjour, ceci est un commentaire.\nPour supprimer un commentaire, connectez-vous et affichez les commentaires de cet article. Vous pourrez alors les modifier ou les supprimer.', 0, '1', '', '', 0, 0);
#
# End of data contents of table `wp_comments`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_links`
# --------------------------------------------------------


#
# Delete any existing table `wp_links`
#

DROP TABLE IF EXISTS `wp_links`;


#
# Table structure of table `wp_links`
#

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_links`
#

#
# End of data contents of table `wp_links`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_options`
# --------------------------------------------------------


#
# Delete any existing table `wp_options`
#

DROP TABLE IF EXISTS `wp_options`;


#
# Table structure of table `wp_options`
#

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=7006 DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_options`
#
 
INSERT INTO `wp_options` VALUES (1, 'siteurl', 'http://pierrekatz.com/temp', 'yes'); 
INSERT INTO `wp_options` VALUES (2, 'blogname', 'Pierre Katz', 'yes'); 
INSERT INTO `wp_options` VALUES (3, 'blogdescription', '', 'yes'); 
INSERT INTO `wp_options` VALUES (4, 'users_can_register', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5, 'admin_email', 'tran@fruitdudragon.com', 'yes'); 
INSERT INTO `wp_options` VALUES (6, 'start_of_week', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (7, 'use_balanceTags', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (8, 'use_smilies', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (9, 'require_name_email', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (10, 'comments_notify', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (11, 'posts_per_rss', '10', 'yes'); 
INSERT INTO `wp_options` VALUES (12, 'rss_use_excerpt', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (13, 'mailserver_url', 'mail.example.com', 'yes'); 
INSERT INTO `wp_options` VALUES (14, 'mailserver_login', 'login@example.com', 'yes'); 
INSERT INTO `wp_options` VALUES (15, 'mailserver_pass', 'password', 'yes'); 
INSERT INTO `wp_options` VALUES (16, 'mailserver_port', '110', 'yes'); 
INSERT INTO `wp_options` VALUES (17, 'default_category', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (18, 'default_comment_status', 'open', 'yes'); 
INSERT INTO `wp_options` VALUES (19, 'default_ping_status', 'open', 'yes'); 
INSERT INTO `wp_options` VALUES (20, 'default_pingback_flag', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (21, 'posts_per_page', '10', 'yes'); 
INSERT INTO `wp_options` VALUES (22, 'date_format', 'j F Y', 'yes'); 
INSERT INTO `wp_options` VALUES (23, 'time_format', 'G \\h i \\m\\i\\n', 'yes'); 
INSERT INTO `wp_options` VALUES (24, 'links_updated_date_format', 'j F Y G \\h i \\m\\i\\n', 'yes'); 
INSERT INTO `wp_options` VALUES (25, 'comment_moderation', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (26, 'moderation_notify', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (27, 'permalink_structure', '/%postname%/', 'yes'); 
INSERT INTO `wp_options` VALUES (28, 'gzipcompression', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (29, 'hack_file', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (30, 'blog_charset', 'UTF-8', 'yes'); 
INSERT INTO `wp_options` VALUES (31, 'moderation_keys', '', 'no'); 
INSERT INTO `wp_options` VALUES (32, 'active_plugins', 'a:14:{i:0;s:29:"acf-repeater/acf-repeater.php";i:1;s:33:"admin-menu-editor/menu-editor.php";i:2;s:30:"advanced-custom-fields/acf.php";i:3;s:35:"comment-control/comment-control.php";i:4;s:33:"duplicate-post/duplicate-post.php";i:5;s:27:"katz-enhance-admin/main.php";i:6;s:37:"post-types-order/post-types-order.php";i:7;s:40:"sitepress-multilingual-cms/sitepress.php";i:8;s:41:"taxonomy-converter/taxonomy-converter.php";i:9;s:114:"tinymce-and-tinymce-advanced-professsional-formats-and-styles/tinymce-advanced-professional-formats-and-styles.php";i:10;s:41:"wordpress-importer/wordpress-importer.php";i:11;s:29:"wp-db-backup/wp-db-backup.php";i:12;s:34:"wpml-string-translation/plugin.php";i:13;s:38:"wpml-translation-management/plugin.php";}', 'yes'); 
INSERT INTO `wp_options` VALUES (33, 'home', 'http://pierrekatz.com/temp', 'yes'); 
INSERT INTO `wp_options` VALUES (34, 'category_base', '', 'yes'); 
INSERT INTO `wp_options` VALUES (35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'); 
INSERT INTO `wp_options` VALUES (36, 'advanced_edit', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (37, 'comment_max_links', '2', 'yes'); 
INSERT INTO `wp_options` VALUES (38, 'gmt_offset', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (39, 'default_email_category', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (40, 'recently_edited', '', 'no'); 
INSERT INTO `wp_options` VALUES (41, 'template', 'fruitdudragon', 'yes'); 
INSERT INTO `wp_options` VALUES (42, 'stylesheet', 'katz', 'yes'); 
INSERT INTO `wp_options` VALUES (43, 'comment_whitelist', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (44, 'blacklist_keys', '', 'no'); 
INSERT INTO `wp_options` VALUES (45, 'comment_registration', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (46, 'html_type', 'text/html', 'yes'); 
INSERT INTO `wp_options` VALUES (47, 'use_trackback', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (48, 'default_role', 'subscriber', 'yes'); 
INSERT INTO `wp_options` VALUES (49, 'db_version', '27916', 'yes'); 
INSERT INTO `wp_options` VALUES (50, 'uploads_use_yearmonth_folders', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (51, 'upload_path', '', 'yes'); 
INSERT INTO `wp_options` VALUES (52, 'blog_public', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (53, 'default_link_category', '2', 'yes'); 
INSERT INTO `wp_options` VALUES (54, 'show_on_front', 'page', 'yes'); 
INSERT INTO `wp_options` VALUES (55, 'tag_base', '', 'yes'); 
INSERT INTO `wp_options` VALUES (56, 'show_avatars', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (57, 'avatar_rating', 'G', 'yes'); 
INSERT INTO `wp_options` VALUES (58, 'upload_url_path', '', 'yes'); 
INSERT INTO `wp_options` VALUES (59, 'thumbnail_size_w', '150', 'yes'); 
INSERT INTO `wp_options` VALUES (60, 'thumbnail_size_h', '150', 'yes'); 
INSERT INTO `wp_options` VALUES (61, 'thumbnail_crop', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (62, 'medium_size_w', '300', 'yes'); 
INSERT INTO `wp_options` VALUES (63, 'medium_size_h', '300', 'yes'); 
INSERT INTO `wp_options` VALUES (64, 'avatar_default', 'mystery', 'yes'); 
INSERT INTO `wp_options` VALUES (65, 'large_size_w', '1024', 'yes'); 
INSERT INTO `wp_options` VALUES (66, 'large_size_h', '1024', 'yes'); 
INSERT INTO `wp_options` VALUES (67, 'image_default_link_type', 'file', 'yes'); 
INSERT INTO `wp_options` VALUES (68, 'image_default_size', '', 'yes'); 
INSERT INTO `wp_options` VALUES (69, 'image_default_align', '', 'yes'); 
INSERT INTO `wp_options` VALUES (70, 'close_comments_for_old_posts', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (71, 'close_comments_days_old', '14', 'yes'); 
INSERT INTO `wp_options` VALUES (72, 'thread_comments', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (73, 'thread_comments_depth', '5', 'yes'); 
INSERT INTO `wp_options` VALUES (74, 'page_comments', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (75, 'comments_per_page', '50', 'yes'); 
INSERT INTO `wp_options` VALUES (76, 'default_comments_page', 'newest', 'yes'); 
INSERT INTO `wp_options` VALUES (77, 'comment_order', 'asc', 'yes'); 
INSERT INTO `wp_options` VALUES (78, 'sticky_posts', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (79, 'widget_categories', 'a:2:{i:2;a:4:{s:5:"title";s:10:"Categories";s:5:"count";i:0;s:12:"hierarchical";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (80, 'widget_text', 'a:2:{i:2;a:3:{s:5:"title";b:0;s:4:"text";s:85:"« The definition of an expert is someone who knows what not to do. » Charles Wilson";s:6:"filter";b:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (81, 'widget_rss', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (82, 'uninstall_plugins', 'a:1:{s:114:"tinymce-and-tinymce-advanced-professsional-formats-and-styles/tinymce-advanced-professional-formats-and-styles.php";s:17:"bb_taps_uninstall";}', 'no'); 
INSERT INTO `wp_options` VALUES (83, 'timezone_string', '', 'yes'); 
INSERT INTO `wp_options` VALUES (84, 'page_for_posts', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (85, 'page_on_front', '5', 'yes'); 
INSERT INTO `wp_options` VALUES (86, 'default_post_format', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (87, 'link_manager_enabled', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (88, 'initial_db_version', '27916', 'yes'); 
INSERT INTO `wp_options` VALUES (89, 'wp_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:78:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:9:"add_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:34:"wpml_manage_translation_management";b:1;s:21:"wpml_manage_languages";b:1;s:41:"wpml_manage_theme_and_plugin_localization";b:1;s:19:"wpml_manage_support";b:1;s:29:"wpml_manage_media_translation";b:1;s:22:"wpml_manage_navigation";b:1;s:24:"wpml_manage_sticky_links";b:1;s:30:"wpml_manage_string_translation";b:1;s:33:"wpml_manage_translation_analytics";b:1;s:25:"wpml_manage_wp_menus_sync";b:1;s:32:"wpml_manage_taxonomy_translation";b:1;s:27:"wpml_manage_troubleshooting";b:1;s:31:"wpml_manage_translation_options";b:1;s:36:"wpml_manage_woocommerce_multilingual";b:1;s:37:"wpml_operate_woocommerce_multilingual";b:1;s:10:"copy_posts";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:35:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:10:"copy_posts";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (90, 'widget_search', 'a:2:{i:2;a:1:{s:5:"title";s:6:"Search";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (91, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:"title";s:12:"Recent Posts";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (92, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:"title";s:15:"Recent Comments";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (93, 'widget_archives', 'a:2:{i:2;a:3:{s:5:"title";s:8:"Archives";s:5:"count";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (94, 'widget_meta', 'a:2:{i:2;a:1:{s:5:"title";s:4:"Meta";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (95, 'sidebars_widgets', 'a:5:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:7:{i:0;s:21:"icl_lang_sel_widget-1";i:1;s:8:"search-2";i:2;s:14:"recent-posts-2";i:3;s:17:"recent-comments-2";i:4;s:10:"archives-2";i:5;s:12:"categories-2";i:6;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:1:{i:0;s:6:"text-2";}s:13:"array_version";i:3;}', 'yes'); 
INSERT INTO `wp_options` VALUES (96, 'cron', 'a:6:{i:1437095503;a:1:{s:24:"update_wpml_config_index";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1437114240;a:1:{s:20:"wp_maybe_auto_update";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1437123981;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1437167266;a:1:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1437168070;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}s:7:"version";i:2;}', 'yes'); 
INSERT INTO `wp_options` VALUES (1418, 'auto_core_update_notified', 'a:4:{s:4:"type";s:6:"manual";s:5:"email";s:22:"tran@fruitdudragon.com";s:7:"version";s:5:"4.2.2";s:9:"timestamp";i:1431508014;}', 'yes'); 
INSERT INTO `wp_options` VALUES (7004, '_site_transient_timeout_theme_roots', '1437085980', 'yes'); 
INSERT INTO `wp_options` VALUES (7005, '_site_transient_theme_roots', 'a:5:{s:13:"fruitdudragon";s:7:"/themes";s:4:"katz";s:7:"/themes";s:14:"twentyfourteen";s:7:"/themes";s:14:"twentythirteen";s:7:"/themes";s:12:"twentytwelve";s:7:"/themes";}', 'yes'); 
INSERT INTO `wp_options` VALUES (106, 'can_compress_scripts', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (107, '_transient_timeout_feed_66a70e9599b658d5cc038e8074597e7c', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (108, '_transient_feed_66a70e9599b658d5cc038e8074597e7c', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:51:"\n	\n	\n	\n	\n	\n	\n		\n		\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"WordPress Francophone";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:27:"http://www.wordpress-fr.net";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:70:"La communauté francophone autour du CMS WordPress et son écosystème";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 27 May 2014 06:26:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"fr-FR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:27:"http://wordpress.org/?v=3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"L’Hebdo WordPress n°230 : WordPress 4.0 – Jetpack 3.0 – WPTech 2014";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:108:"http://www.wordpress-fr.net/2014/05/27/lhebdo-wordpress-n230-wordpress-4-0-jetpack-3-0-wptech-2014/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 27 May 2014 05:23:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:11:"Evènements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:11:"communauté";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:7:"Jetpack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7067";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:423:"WordPress 4.0 Déjà quelques précisions concernant l&#8217;internationalisation dans WordPress 4.0 (en). Jetpack 3.0 Jetpack passe en version 3.0 et se relooke en partie. WPTech 2014 WPTech est la première édition d&#8217;une manifestation consacrée à WordPress, mais uniquement du côté technique du sujet. L&#8217;idée vient d&#8217;une partie de la communauté nantaise. Bravo à elle&#8230;. et déjà [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3752:"<h3>WordPress 4.0</h3>\n<p>Déjà quelques précisions concernant l&rsquo;<a href="http://make.wordpress.org/core/2014/05/21/internationalization-goals-for-4-0/">internationalisation dans WordPress 4.0</a> (en).</p>\n<h3>Jetpack 3.0</h3>\n<p><a href="http://jetpack.me/2014/05/20/jetpack-3-0/">Jetpack passe en version 3.0</a> et se relooke en partie.</p>\n<h3>WPTech 2014</h3>\n<p><a href="http://2014.wptech.fr/">WPTech</a> est la première édition d&rsquo;une manifestation consacrée à WordPress, mais uniquement du côté technique du sujet. L&rsquo;idée vient d&rsquo;une partie de la communauté nantaise. Bravo à elle&#8230;. et déjà <a href="http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/">on en parle sur le web</a>.</p>\n<h3>Les meetups franciliens se &laquo;&nbsp;veryfrenchtripise&nbsp;&raquo;</h3>\n<p>Organisés par une bonne partie de la Very French Trip team <a href="http://veryfrenchtrip-wp.eu/meetup-wordpress-23-mai-14-paris/">les meetups franciliens cherchent à évoluer</a>.</p>\n<h3>Un superhéros WordPress, c&rsquo;est quoi ?</h3>\n<p><a href="http://www.wppourlesnuls.com/comment-devenir-un-super-heros-wordpress-infographie/">La réponse en infographie</a>.</p>\n<h3>Interview de Rodrigue Fénard</h3>\n<p><a href="http://lesdoigtsdanslenet.com/rodrigue-fenard-specialiste-wordpress/">Rodrigue </a>est interviewé par les Doigts dans le Net.</p>\n<h3>Utiliser les &laquo;&nbsp;social meta tags&nbsp;&raquo; de WordPress</h3>\n<p>Pour en savoir plus sur les social meta tags, un conseil,<a href="http://www.wpexplorer.com/setup-open-graph-twitter-cards-wordpress/"> lisez cet article </a>(en).</p>\n<h3>Le VFT Podcast n°1</h3>\n<p><a href="http://veryfrenchtrip-wp.eu/podcast-1/">Un nouveau podcast est toujours un événement </a>mais quand il est français et réalisé par une bande de joyeux lurons comme la VFT team alors on y va les yeux fermés (ça tombe bien, y a pas d&rsquo;images !)<br />\n<em><strong>Ajout :</strong></em> Pour suivre le podcast, abonnez-vous via ce flux : <a href="http://veryfrenchtrip-wp.eu/flux/podcast/feed/">http://veryfrenchtrip-wp.eu/flux/podcast/feed/</a></p>\n<h3>Google dans son site WordPress</h3>\n<p>Pour intégrer les<a href="http://premium.wpmudev.org/blog/wordpress-google-plugins/"> outils de Google dans votre site</a> (en), voici quelques idées.</p>\n<h3>Du support client embarqué</h3>\n<p>Avec <a href="http://issuepress.co/">IssuePress (en)</a>, il devient possible d&rsquo;embarquer son propre service client dans son interface d&rsquo;administrateur.</p>\n<h3>Une page de connexion personnalisée</h3>\n<p>Créer une page de connexion personnalisée est possible&#8230; <a href="http://premium.wpmudev.org/blog/create-a-custom-wordpress-login-page/">voici la méthode</a> (en).</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/P6DmqnLdfQ4" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:104:"http://www.wordpress-fr.net/2014/05/27/lhebdo-wordpress-n230-wordpress-4-0-jetpack-3-0-wptech-2014/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"6";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:99:"http://www.wordpress-fr.net/2014/05/27/lhebdo-wordpress-n230-wordpress-4-0-jetpack-3-0-wptech-2014/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:48:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"L’Hebdo WordPress n°229 : Communautés – Extensions – Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/5ZwQnV00lFY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://www.wordpress-fr.net/2014/05/20/lhebdo-wordpress-n229-communautes-extensions-astuces/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 20 May 2014 05:23:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:7:"Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:11:"communauté";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7039";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:339:"Les Communautés Bordeaux WordPress&#8217;Camp #10 Pour la 10e édition de cette réunion bordelaise, il sera question de sécurité et de maintenance. Elle aura lieu le 12 juin à 18 H 30. Meetup à Lyon Dès ce jeudi 22 mai, Lyon propose un meetup autour de WordPress et de l&#8217;extension ACF. Meetup à Paris La communauté [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3399:"<h2>Les Communautés</h2>\n<h3>Bordeaux WordPress&rsquo;Camp #10</h3>\n<p>Pour la 10e édition de cette réunion bordelaise, il sera question <a href="https://www.facebook.com/events/1485744844988525/">de sécurité et de maintenance</a>. Elle aura lieu le 12 juin à 18 H 30.</p>\n<h3>Meetup à Lyon</h3>\n<p>Dès ce jeudi 22 mai, Lyon propose un <a href="http://www.meetup.com/WordPress-Lyon-Meetup/">meetup autour de WordPress et de l&rsquo;extension ACF</a>.</p>\n<h3>Meetup à Paris</h3>\n<p>La <a href="http://www.meetup.com/wordpress-ile-de-france/">communauté parisienne se réunie le vendredi 23 mai </a>autour d&rsquo;un verre.</p>\n<h3>Meetup WordPress in Alps</h3>\n<p>La <a href="http://www.wpinalps.com/#prochaine-rencontre">communauté alpine se retrouvera le 10 juin</a>, à l&rsquo;initiative de l&rsquo;association WordPress in Alps. La réunion est prévue à Grenoble.</p>\n<h3>Faire du CRM avec WordPress</h3>\n<p>Si vous souhaitez vous lancer dans le <a href="https://kinsta.com/blog/crm-wordpress-plugins/">CRM avec WordPress</a> (en), ces extensions et conseils vous seront utiles.</p>\n<h3>Font Awsome intègre WordPress</h3>\n<p>La police de caractère <a href="http://fontawesome.io/whats-new/">Font Awsome vient d&rsquo;intégrer une icône de WordPress</a> (en) dans sa nouvelle mise à jour.</p>\n<h3>4 optimisations simples pour booster le SEO</h3>\n<p>Lumière de Lune explique comment, <a href="http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05">en 4 points, on peut optimiser un site pour le SEO.</a></p>\n<h3>Une favicon bien faite</h3>\n<p>WPChannel montre comment <a href="http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/">faire une favicon</a> digne de ce nom pour votre site sous WordPress.</p>\n<h3>Construire un job-board</h3>\n<p>WordPress peut désormais se transformer en un véritable job board grâce à cette extension : <a href="http://www.poststat.us/building-new-wp-job-manager-website/">WP Job Manager</a>.</p>\n<h3>Une communauté de traducteurs</h3>\n<p>WordPress étant international, il est logique de voir apparaitre une <a href="http://wp-translations.org/lets-create-community-together/">communauté de traducteurs</a> (en).</p>\n<h3>Bien choisir un hébergement</h3>\n<p>Quelques <a href="http://wpformation.com/choisir-hebergement-wordpress">conseils de Fabrice</a> pour choisir son hébergement pour WordPress.</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/5ZwQnV00lFY" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://www.wordpress-fr.net/2014/05/20/lhebdo-wordpress-n229-communautes-extensions-astuces/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://www.wordpress-fr.net/2014/05/20/lhebdo-wordpress-n229-communautes-extensions-astuces/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"L’Hebdo WordPress n°228 : Android – BuddyPress – Scrap";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wpCN_XlMPRo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:95:"http://www.wordpress-fr.net/2014/05/13/lhebdo-wordpress-n228-android-buddypress-scrap/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 May 2014 05:49:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:7:"Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:10:"Extensions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:7:"android";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7031";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:364:"WordPress pour Android 2.8 L&#8217;application WordPress pour Android arrive en version 2.8 (en). A noter que la mise à jour 2.8.1 est sortie. BuddyPress 2.0.1 La première mise à jour mineur de BuddyPress 2.0 (en) est arrivée. Les fichiers attachés dans BuddyPress iMath présente les fichiers attachés  (en) dans BuddyPress. Revenons sur 5 ans de [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:7358:"<h3>WordPress pour Android 2.8</h3>\n<p>L&rsquo;application <a href="https://android.wordpress.org/2014/05/01/wordpress-for-android-2-8/">WordPress pour Android</a> arrive en version 2.8 (en). A noter que la <a href="https://play.google.com/store/apps/details?id=org.wordpress.android">mise à jour 2.8.1</a> est sortie.</p>\n<h3>BuddyPress 2.0.1</h3>\n<p>La <a href="http://buddypress.org/2014/05/buddypress-2-0-1/">première mise à jour mineur de BuddyPress 2.0</a> (en) est arrivée.</p>\n<h3>Les fichiers attachés dans BuddyPress</h3>\n<p>iMath présente les <a href="https://bpdevel.wordpress.com/2014/05/08/attachments-in-buddypress/">fichiers attachés  </a>(en) dans BuddyPress.</p>\n<h3>Revenons sur 5 ans de BuddyPress</h3>\n<p>L&rsquo;<a href="http://teleogistic.net/2014/05/five-years-of-buddypress/">histoire de BuddyPress depuis 5 ans</a> (en).</p>\n<h3>Alerte au scrap sur les sites WordPress</h3>\n<p>Cette semaine de très nombreux sites utilisant WordPress se sont fait &laquo;&nbsp;scrapper&nbsp;&raquo;. <a href="http://wpformation.com/scrapping-masse-sites-wordpress/">Explications par Fabrice</a>.</p>\n<h3>Plus de 25 extensions à avoir en 2014</h3>\n<p>Voici une sélection des<a href="http://premium.wpmudev.org/blog/25-must-have-wordpress-plugins-for-2014/"> 25 extensions</a> (en) à ne pas rater en 2014.</p>\n<h3>Une extension qui fait vos badges de WordCamp</h3>\n<p>En marge du WordCamp de Miami, un passionné a réalisé une extension qui permet de créer <a href="http://wptavern.com/would-anyone-be-interested-in-a-wordcamp-badges-plugin">son propre badge du WordCamp Miami (en)</a>. Il réfléchi à la possibilité de faire en sorte de généraliser l&rsquo;extension pour n&rsquo;mporte quel WordCamp.</p>\n<h3>Découvrez BuddyPress</h3>\n<p><a href="http://wpchannel.com/re-decouvres-buddypress/">Si vous ne connaissez pas encore BuddyPress</a>, Mathieu vous explique tout sur WPChannel.</p>\n<h3>Une interview de Daniel Roch</h3>\n<p>Si comme moi vous aviez raté <a href="https://www.youtube.com/watch?v=_y9YXhAVec0">cette interview de Daniel Roch</a>, c&rsquo;est le moment de vous rattraper.</p>\n<h3>WP-Rocket s&rsquo;internationalise</h3>\n<p>L&rsquo;extension WP Rocket devient internationale, <a href="http://wptavern.com/wp-rocket-launches-commercial-caching-plugin-for-wordpress">WPTavern s&rsquo;en fait l&rsquo;écho</a> (en).</p>\n<h3>L&rsquo;API de TinyMCE</h3>\n<p>La version de 3.9 intègre beaucoup de nouveautés et notamment dans TinyMCE. Son intégration dans le core de WordPress apporte une nouvelle API&#8230;<a href="http://www.wpexplorer.com/wordpress-tinymce-tweaks/"> autorisant de nombreuses possibilités</a> (en). Et voici un <a href="http://www.tweetpress.fr/faqs/comment-ajouter-icone-bouton-tinymce-wordpress-3-9/">exemple de ce qu&rsquo;on peut faire</a>.</p>\n<h3>Les jetons de sécurité</h3>\n<p>Julio présente la question des <a href="http://boiteaweb.fr/jetons-securite-petit-plus-dont-vous-avez-besoin-8070.html">jetons de sécurité</a> et l&rsquo;applique à WordPress.</p>\n<h3>L&rsquo;effet FancyBox et WordPress</h3>\n<p>WPChannel explique <a href="http://wpchannel.com/fancybox-wordpress-galerie-image/">comment utiliser FancyBox sur un site WordPress</a>.</p>\n<h3>Organiser les types de contenus et les librairies</h3>\n<p>Voici <a href="http://tommcfarlin.com/organizing-wordpress-content-types-libraries/">une solution présentée</a> par Tom McFarlin (en).</p>\n<h3>Automattic lève 160 millions de dollars</h3>\n<p>Matt annonce qu&rsquo;Automattic<a href="http://ma.tt/2014/05/new-funding-for-automattic/"> lève 160 millions de dollars (en)</a>&#8230; et explique les <a href="http://techcrunch.com/2014/05/07/automattic-ceo-matt-mullenweg-talks-funding-investing-and-the-future-of-wordpress/">investissements et l&rsquo;avenir de WordPress</a> (en).</p>\n<h3>Protéger son wp-config</h3>\n<p>Si vous souhaitez protéger votre fichier wp-config.php via le fichier .htaccess<a href="http://wp-snippets.com/protect-wp-config-php-with-htaccess/"> voici comment procéder (en).</a></p>\n<h3>Une table ronde sur les hébergeurs de WordPress</h3>\n<p><a href="http://wpbacon.com/podcast/wordpress-hosting-panel/">WPBacon </a>a organisé une <a href="http://wptavern.com/highlights-of-the-wpbacon-wordpress-webhosting-roundtable">table ronde pour parler hébergements</a>. (en)</p>\n<h3>Matt Mullenweg est un homme dangereux</h3>\n<p>C&rsquo;est le titre accrocheur de cet article pour montrer la &laquo;&nbsp;peur&nbsp;&raquo; du gouvernement américain envers l&rsquo;open source en général et WordPress en particulier. <a href="http://joeflood.com/2014/05/07/matt/">Angle de vue décalé  </a>(en) pour montrer le ridicule d&rsquo;une situation loin d&rsquo;être erronée.</p>\n<h3>Création d&rsquo;une page de maintenance personnalisée</h3>\n<p>La page de maintenance par défaut de WordPress est triste à souhait ! <a href="http://www.gregoirenoyelle.com/wordpress-creation-page-maintenance-personnalisee/">Personnalisez-la grâce à Grégoire</a>.</p>\n<h3>WordPress n&rsquo;est pas un CMS</h3>\n<p>Mmmmhhh, <a href="http://www.screenfeed.fr/blog/wordpress-pas-cms-02223/">encore de la polémique dans l&rsquo;air</a>&#8230; mais là, l&rsquo;offensive est argumentée&#8230;</p>\n<h3>Évolution du nombre d&rsquo;extensions</h3>\n<p>Julio constate l&rsquo;<a href="http://boiteaweb.fr/combien-plugins-wordpress-8075.html">évolution du nombre d’extensions dans le répertoire officiel</a>.</p>\n<h3>Des séries d&rsquo;articles en liste déroulante</h3>\n<p>C&rsquo;est l&rsquo;extension <a href="http://www.echodesplugins.li-an.fr/plugins/wp-post-series/">WP Post Series</a> qui le permet.</p>\n<h3>60 thèmes typés business pour 2014</h3>\n<p>WPMUDEV présente une liste de <a href="http://premium.wpmudev.org/blog/free-responsive-wordpress-business-themes/">60 thèmes gratuits</a> (en) typés business et sortis en 2014.</p>\n<h3>Une extension peut disparaitre du répertoire officiel ?</h3>\n<p>Marie-Aude explique les raisons de la <a href="http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05">disparition d&rsquo;une extension du répertoire officiel </a>et les conséquences à en tirer.</p>\n<h3>Levé de rideau sur les nouveaux thèmes ElegantThemes</h3>\n<p>Rodrigue présente ce que va être l<a href="http://www.cree1site.com/eleganttheme-2/">&lsquo;avenir des thèmes ElegantThemes</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/wpCN_XlMPRo" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:91:"http://www.wordpress-fr.net/2014/05/13/lhebdo-wordpress-n228-android-buddypress-scrap/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"14";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:86:"http://www.wordpress-fr.net/2014/05/13/lhebdo-wordpress-n228-android-buddypress-scrap/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"WordPress 3.9.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/KpsKznAONCY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:64:"http://www.wordpress-fr.net/2014/05/09/wordpress-3-9-1/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 May 2014 16:36:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7020";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:379:"Trois semaines après le lancement de WordPress 3.9, et avec plus de 9 millions de téléchargements à son actif, nous sommes heureux de vous annoncer que WordPress 3.9.1 est disponible. Cette version de maintenance corrige 34 bugs présents dans la 3.9, parmi lesquels de nombreuses corrections concernant les réseaux multisites, la personnalisation des widgets lors [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4816:"<p>Trois semaines après le lancement de <a title="Sortie de WordPress 3.9" href="http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/">WordPress 3.9</a>, et avec plus de 9 millions de téléchargements à son actif, nous sommes heureux de vous annoncer que WordPress 3.9.1 est disponible.</p>\n<p>Cette version de maintenance corrige 34 bugs présents dans la 3.9, parmi lesquels de nombreuses corrections concernant les réseaux multisites, la personnalisation des widgets lors de la prévisualisation des thèmes et la mise à jour de l&rsquo;éditeur visuel. Nous avons aussi effectué quelques améliorations sur la nouvelle fonction de liste de lecture audio/vidéo et fait quelques retouches pour améliorer les performances. Pour voir la liste complète des changements vous pouvez consulter la <a href="https://core.trac.wordpress.org/query?milestone=3.9.1">liste des tickets (en)</a> et le <a href="https://core.trac.wordpress.org/log/branches/3.9?rev=28353&amp;stop_rev=28154">journal des changements (en)</a>.</p>\n<p>Si vous faites parties des millions d&rsquo;utilisateurs de WordPress 3.9, avons déployé la mise à jour en arrière-plan vers la 3.9.1 &#8211; Pour les sites qui le <a href="http://wordpress.org/plugins/background-update-tester/">supportent</a> (en), évidemment !</p>\n<p><a href="http://wordpress.org/download/">Dans tous les cas vous pouvez téléchargez WordPress 3.9.1</a> ou le faire manuellement depuis votre <strong>Tableau de bord → Mise à jour </strong>et simplement cliquer “Mettre à jour maintenant.”</p>\n<p>Merci beaucoup à toutes ces personnes incroyables qui ont participé au développement de WordPress 3.9.1 : <a href="http://profiles.wordpress.org/jorbin">Aaron Jorbin</a>, <a href="http://profiles.wordpress.org/nacin">Andrew Nacin</a>, <a href="http://profiles.wordpress.org/azaozz">Andrew Ozz</a>, <a href="http://profiles.wordpress.org/rzen">Brian Richards</a>, <a href="http://profiles.wordpress.org/ehg">Chris Blower</a>, <a href="http://profiles.wordpress.org/jupiterwise">Corey McKrill</a>, <a href="http://profiles.wordpress.org/danielbachhuber">Daniel Bachhuber</a>, <a href="http://profiles.wordpress.org/ocean90">Dominik Schilling</a>, <a href="http://profiles.wordpress.org/feedmeastraycat">feedmeastraycat</a>, <a href="http://profiles.wordpress.org/gcorne">Gregory Cornelius</a>, <a href="http://profiles.wordpress.org/helen">Helen Hou-Sandi</a>, <a href="http://profiles.wordpress.org/imath">imath</a>, <a href="http://profiles.wordpress.org/avryl">Janneke Van Dorpe</a>, <a href="http://profiles.wordpress.org/jeremyfelt">Jeremy Felt</a>, <a href="http://profiles.wordpress.org/johnbillion">John Blackbourn</a>, <a href="http://profiles.wordpress.org/obenland">Konstantin Obenland</a>, <a href="http://profiles.wordpress.org/lancewillett">Lance Willett</a>, <a href="http://profiles.wordpress.org/m_i_n">m_i_n</a>, <a href="http://profiles.wordpress.org/clorith">Marius Jensen</a>, <a href="http://profiles.wordpress.org/markjaquith">Mark Jaquith</a>, <a href="http://profiles.wordpress.org/dimadin">Milan Dinić</a>, <a href="http://profiles.wordpress.org/celloexpressions">Nick Halsey</a>, <a href="http://profiles.wordpress.org/pavelevap">pavelevap</a>, <a href="http://profiles.wordpress.org/wonderboymusic">Scott Taylor</a>, <a href="http://profiles.wordpress.org/SergeyBiryukov">Sergey Biryukov</a>, et <a href="http://profiles.wordpress.org/westonruter">Weston Ruter</a>.</p>\n<p><em><strong>NB</strong> : Cet article est une adaptation en français de l&rsquo;article original publié sur <a href="http://wordpress.org/news/2014/05/wordpress-3-9-1/">wordpress.org</a> (en).</em></p>\n<p><em><strong>NB2</strong> </em>:<em> La version française est disponible <a href="http://fr.wordpress.org">ici</a>.</em></p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KpsKznAONCY:cCR6KkyEM2I:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KpsKznAONCY:cCR6KkyEM2I:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/KpsKznAONCY" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:60:"http://www.wordpress-fr.net/2014/05/09/wordpress-3-9-1/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:55:"http://www.wordpress-fr.net/2014/05/09/wordpress-3-9-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"L’Hebdo WordPress n°227 : SupportPress – Sondage – Polémique";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/QOlL4_ZPklY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://www.wordpress-fr.net/2014/04/29/lhebdo-wordpress-n227-supportpress-sondage-polemique/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 29 Apr 2014 19:52:34 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:7:"Brèves";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:11:"communauté";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"sondage";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:12:"SupportPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7013";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:369:"Une application pour le support : SupportPress Automattic met à disposition du public une application gratuite de gestion de support, nommée SupportPress (en). Une nouvelle communauté belge Bienvenue à la communauté WordPress de Namur en Belgique. Si vous êtes du coin, rejoignez ce groupe. Un thème et une extension dédiés à Twitter Ozh a réalisé [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2630:"<h3>Une application pour le support : SupportPress</h3>\n<p>Automattic met à disposition du public une application gratuite de gestion de support, nommée <a href="http://supportpress.com/">SupportPress</a> (en).</p>\n<h3>Une nouvelle communauté belge</h3>\n<p>Bienvenue à la communauté WordPress de Namur en Belgique. <a href="http://www.meetup.com/Namur-WordPress-Meetup/">Si vous êtes du coin, rejoignez ce groupe</a>.</p>\n<h3>Un thème et une extension dédiés à Twitter</h3>\n<p><a href="http://wptavern.com/tweet-archive-a-free-wordpress-theme-to-match-the-new-twitter-profiles">Ozh a réalisé un thème et une extension</a> (en) permettant l&rsquo;archivage de ses Tweets (en). Il vient de remettre  l&rsquo;ensemble à jour suite aux dernières retouches du site Twitter.</p>\n<h3>Un sondage pour améliorer WordPress</h3>\n<p>Si vous avez quelques instants, répondez à <a href="http://wordpressdotorg.polldaddy.com/s/wordpress-contributor-experience-poll?p=1">ce sondage concernant votre expérience de WordPress</a> (en).</p>\n<h3>Les CMS c&rsquo;est le mal ?</h3>\n<p>C&rsquo;est ce que semble penser <a href="http://www.cera-interactive.fr/cera-strasbourg/actu-du-web.php?actu=140425-joomla-wordpress-site-web">Lucas K.  </a>de Cera Interactive qui tire à boulets rouges sur les CMS. La réponse d&rsquo;un indépendant ne s&rsquo;est pas faite attendre&#8230;<a href="http://wpformation.com/faut-il-eviter-wordpress-joomla/"> en la personne de Fabrice de WPFormation</a>. Et vous qu&rsquo;en pensez-vous ?<br />\nAjout : <a href="http://www.web-eau.net/blog/entry/la-guerre-du-web-aura-t-elle-lieu">Une autre réponse ici</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=QOlL4_ZPklY:laSY97JiqPg:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=QOlL4_ZPklY:laSY97JiqPg:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/QOlL4_ZPklY" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://www.wordpress-fr.net/2014/04/29/lhebdo-wordpress-n227-supportpress-sondage-polemique/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"10";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://www.wordpress-fr.net/2014/04/29/lhebdo-wordpress-n227-supportpress-sondage-polemique/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:69:"L’Hebdo WordPress n°226 : BuddyPress 2.0 – Widgets – Dashicons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/s7zcVdwx75U/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:103:"http://www.wordpress-fr.net/2014/04/22/lhebdo-wordpress-n226-buddypress-2-0-widgets-dashicons/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 22 Apr 2014 05:28:35 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:7:"Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Brèves";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:10:"automattic";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7003";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:379:"BuddyPress 2.0 : Juliana BuddyPress 2.0 débarque en version finale (en) et se nomme Juliana. Notons qu&#8217;iMath n&#8217;en est pas peu fier. (et il a bien raison). Explications concernant le gestionnaire de widget Depuis WordPress 3.9, le gestionnaire de widget a subi de grandes améliorations. Un petit récapitulatif est donc bienvenu (en) Automattic évalué à [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3850:"<h3>BuddyPress 2.0 : Juliana</h3>\n<p><a href="http://buddypress.org/2014/04/buddypress-2-0-juliana/">BuddyPress 2.0 débarque en version finale</a> (en) et se nomme Juliana. Notons qu&rsquo;iMath n&rsquo;<a href="http://imathi.eu/2014/04/21/my-very-own-buddypress/">en est pas peu fier</a>. (et il a bien raison).</p>\n<h3>Explications concernant le gestionnaire de widget</h3>\n<p>Depuis WordPress 3.9, le gestionnaire de widget a subi de grandes améliorations. <a href="http://make.wordpress.org/core/2014/04/17/live-widget-previews-widget-management-in-the-customizer-in-wordpress-3-9/">Un petit récapitulatif est donc bienvenu </a>(en)</p>\n<h3>Automattic évalué à 1 milliard de dollars</h3>\n<p><a href="http://mashable.com/2014/04/15/wordpress-automattic/">Après une levée de fonds  </a>(en) d&rsquo;environ <a href="http://tech.fortune.cnn.com/2014/04/15/exclusive-automattic-seeking-to-raise-more-than-100-million/">100 millions de dollars</a> (en), Automattic vaut autour d&rsquo;un milliard de dollars.</p>\n<h3>Le 16e hook de la semaine</h3>\n<p>Julio propose son 16e hook de la semaine avec <code><a href="http://boiteaweb.fr/theme_page_templates-hook-semaine-16-8033.html">theme_page_templates</a>.</code></p>\n<h3> Concevoir un système d&rsquo;espace membre</h3>\n<p>Willy explique comment <a href="http://wabeo.fr/espace-membre-wordpress/">concevoir un système d&rsquo;espace membre</a> dans WordPress.</p>\n<h3>La liste des dashicons</h3>\n<p><a href="http://melchoyce.github.io/dashicons/">Voici une liste des dashicons</a> avec possibilité de les copier pour les insérer chez vous. Vous trouverez aussi les <a href="http://make.wordpress.org/core/2014/04/16/dashicons-in-wordpress-3-9/">nouvelles dashicons de la version 3.9</a> (en).</p>\n<h3>Un site WordPress, ça prend du temps</h3>\n<p>Fabrice explique <a href="http://wpformation.com/site-wordpress-professionnel/">pourquoi un site WordPress prend du temps</a>.</p>\n<h3>Hueman, un thème plein de ressources</h3>\n<p>Li-An fait découvrir un thème gratuit intéressant. <a href="http://www.echodesplugins.li-an.fr/themes/hueman/">Hueman </a>est un thème responsive plein de ressources.</p>\n<h3>Corriger les erreurs 404</h3>\n<p>Les erreurs 404 peuvent être évitées sur votre site. <a href="http://wpformation.com/erreurs-404-wordpress/">Voici comment faire</a>.</p>\n<h3>Éviter le contenu dupliqué</h3>\n<p>Julio propose de montrer comment <a href="http://boiteaweb.fr/eviter-duplicate-content-archives-categories-8027.html">éviter les contenus dupliqués</a> (&laquo;&nbsp;duplicate content&nbsp;&raquo;).</p>\n<h3>Séparer la fonctionnalité de la forme</h3>\n<p>Un article qui s&rsquo;adresse surtout aux développeurs de thèmes. <a href="http://www.tweetpress.fr/screencast/plugin-fonctionnalites/">Julien leur conseille de séparer la forme des fonctionnalités</a>.</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=s7zcVdwx75U:nmUPtOjyecs:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=s7zcVdwx75U:nmUPtOjyecs:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/s7zcVdwx75U" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:99:"http://www.wordpress-fr.net/2014/04/22/lhebdo-wordpress-n226-buddypress-2-0-widgets-dashicons/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:94:"http://www.wordpress-fr.net/2014/04/22/lhebdo-wordpress-n226-buddypress-2-0-widgets-dashicons/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:48:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"À propos de la traduction française de WordPress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/3CW90ipEYuM/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://www.wordpress-fr.net/2014/04/18/a-propos-de-la-traduction-francaise-de-wordpress-3-9/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 18 Apr 2014 17:57:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:10:"Traduction";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6991";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:451:"Version courte La traduction présentait certains problèmes et erreurs. Nous vous conseillons de la mettre à jour : Soit en cliquant sur le bouton &#171;&#160;Ré-installer maintenant&#160;&#187; de votre page Tableau de bord &#62; Mises à jour. Soit en téléchargeant le fichier fr_FR.mo corrigé et en le mettant en ligne dans votre dossier /wp-content/languages/, en remplacement du fichier fr_FR.mo en place. Par ailleurs, si [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Xavier";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:7326:"<h3>Version courte</h3>\n<p>La traduction présentait certains problèmes et erreurs. Nous vous conseillons de la mettre à jour :</p>\n<ul>\n<li>Soit en cliquant sur le bouton &laquo;&nbsp;Ré-installer maintenant&nbsp;&raquo; de votre page Tableau de bord &gt; Mises à jour.</li>\n<li>Soit en téléchargeant le <a href="http://i18n.svn.wordpress.org/fr_FR/branches/3.9/messages/fr_FR.mo">fichier <code>fr_FR.mo</code> corrigé</a> et en le mettant en ligne dans votre dossier <code>/wp-content/languages/</code>, en remplacement du fichier <code>fr_FR.mo</code> en place.</li>\n</ul>\n<p>Par ailleurs, si votre éditeur visuel est cassé depuis le passage à la 3.9, ce n&rsquo;est sans doute pas dû à la traduction, mais plutôt à l&rsquo;une de vos extensions qui utilisent/étendent l&rsquo;éditeur (TinyMCE). Désactivez-les une à une !</p>\n<h3>Version longue</h3>\n<p>La traduction présentait donc des problèmes :</p>\n<ul>\n<li>L&rsquo;adresse du lien &laquo;&nbsp;Remarque&nbsp;&raquo; du menu WordPress (en haut à gauche de l&rsquo;administration) renvoyait vers &laquo;&nbsp;https://wordpress.org/support/forum/requests-and-feedback(enanglais)&nbsp;&raquo; &#8212; oui, avec &laquo;&nbsp;(en anglais)&nbsp;&raquo; dans l&rsquo;adresse !</li>\n<li>Le mot &laquo;&nbsp;PrestaShop&nbsp;&raquo; apparaissait à la place de &laquo;&nbsp;WordPress&nbsp;&raquo; dans trois chaînes de l&rsquo;outil de personnalisation des thèmes ! <a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=487408#p487408">Explication</a> : PrestaShop est mon employeur, j&rsquo;écris les documentations du logiciel, et je tape donc ce mot à longueur de journée. Je suppose que le soir venu, mes doigts ont glissé&#8230;</li>\n<li>Et surtout, les grands chiffres (supérieurs à 999) sont affichés avec une esperluette (&amp;) : 1&amp;234, 357&amp;156, etc.</li>\n</ul>\n<p>Explication de ce dernier point : <a href="http://fr.wikipedia.org/wiki/Espace_ins%C3%A9cable">en typographie française</a>, il faut utiliser une espace insécable comme séparateur de groupes de trois chiffres dans les nombres par tranches de mille pour la partie entière et la partie décimale (1 234 567 plutôt que 1234567, donc). Ce n&rsquo;est pas possible dans toutes les situations, mais ça l&rsquo;est dans WordPress grâce à une clef de traduction propre à cela :  <code>number_format_thousands_sep</code> (séparateur de milliers). Et donc nous, traducteurs, de traduire le point du standard américain en une espace insécable, qui en HTML s&rsquo;écrit avec l&rsquo;entité &laquo;&nbsp;&amp;nbsp;&nbsp;&raquo;</p>\n<p>L&rsquo;arrivée de ce séparateur (<a href="https://core.trac.wordpress.org/ticket/3677">il y a plus de sept ans</a>, avec <a href="http://codex.wordpress.org/Version_2.3#Internationalization_and_Localization">WordPress 2.3</a> !) avait déjà provoqué des problèmes une fois que la traduction l&rsquo;a pris en compte, <a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=427804">tant en français</a> (<a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=427776#p427776">explication de Guy à l&rsquo;époque de v3.5</a>) que pour <a href="http://wordpress.org/ideas/topic/multi-char-thousands-separator-french-russian-czech-etc">d&rsquo;autres locales</a> (<a href="https://core.trac.wordpress.org/ticket/10373">ticket sur le Trac WP</a>, <a href="https://core.trac.wordpress.org/ticket/10373#comment:8">possible solution</a>).</p>\n<p>Si vous voulez tester mais que vous n&rsquo;avez pas assez d&rsquo;articles, commentaires, médias ou indésirables, une astuce : faites un recherche d&rsquo;extension avec le mot-clé &laquo;&nbsp;widget&nbsp;&raquo; (<code>/wp-admin/plugin-install.php?tab=search&amp;type=tag&amp;s=widget</code>), et regardez le nombre de résultats.</p>\n<p>Le problème ne vient pas de WordPress mais de PHP : dans les versions antérieures à PHP 5.4.0, la méthode <a href="http://www.php.net/manual/en/function.number-format.php"><code>number_format()</code></a> ne prenait en compte que le premier octet, soit en français comme dans d&rsquo;autres langues nécessitant une espace insécable pour la séparation de milliers, le &laquo;&nbsp;&amp;&nbsp;&raquo; de &laquo;&nbsp;&amp;nbsp;&nbsp;&raquo; (cf. la section &laquo;&nbsp;Changelog&nbsp;&raquo; dans la page de cette fonction PHP.<br />\nC&rsquo;est pourquoi les <a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=487647#p487647">récents témoignages que nous avons reçus</a> tendent à montrer que le problème ne survient qu&rsquo;avec une version de PHP inférieure à la 5.4.</p>\n<p>Mais alors, si nous étions déjà au courant de ce problème avec &amp;nbsp; depuis (au moins) la version 3.5 de WordPress, pourquoi le retrouve-t-on dans la 3.8 et la 3.9 ? L&rsquo;explication est simplement humaine : le nombre de chaînes à traduire à chaque sortie, l&rsquo;envie de bien faire, et l&rsquo;oubli des discussions des années passées. J&rsquo;espère que cet article maintiendra le problème en mémoire, jusqu&rsquo;à mise en place d&rsquo;une solution pérenne (cf. la possible solution liée plus haut, que nous mettrons en place pour WP 3.9.1).</p>\n<p>Merci de votre compréhension, et mettez à jour votre traduction ! <img src="http://www.wordpress-fr.net/wp-includes/images/smilies/icon_smile.gif" alt=":)" class="wp-smiley" /> </p>\n<p><strong>Ajout du 22 avril</strong> : la traduction d&rsquo;Akismet 3.0 a également été corrigée ! Elle sera à jour dans la version 3.9.1 de WordPress, mais d&rsquo;ici-là, vous pouvez exporter le fichier .mo en suivant ce processus :</p>\n<ul>\n<li>Allez sur <a href="http://translate.wordpress.org/projects/wp-plugins/akismet/dev/fr/default">http://translate.wordpress.org/projects/wp-plugins/akismet/dev/fr/default</a></li>\n<li>En bas de l&rsquo;écran, sélectionnez &laquo;&nbsp;Machine Object Message catalog (.mo)&nbsp;&raquo;.</li>\n<li>Cliquez sur &laquo;&nbsp;Export&nbsp;&raquo;.</li>\n<li>Renommez le fichier téléchargé &laquo;&nbsp;<code>wp-plugins-akismet-dev-fr.mo</code>&nbsp;&raquo; en &laquo;&nbsp;<code>akismet-fr_FR.mo</code>&laquo;&nbsp;.</li>\n<li>Mettez ce fichier <code>akismet-fr_FR.mo</code> dans le dossier <code>/wp-content/languages/plugins</code> de votre installation de WordPress.</li>\n</ul>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=3CW90ipEYuM:xYH023NF7xM:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=3CW90ipEYuM:xYH023NF7xM:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/3CW90ipEYuM" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://www.wordpress-fr.net/2014/04/18/a-propos-de-la-traduction-francaise-de-wordpress-3-9/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"17";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://www.wordpress-fr.net/2014/04/18/a-propos-de-la-traduction-francaise-de-wordpress-3-9/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Sortie de WordPress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wPvO98ucIP4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:72:"http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 16 Apr 2014 22:04:10 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6978";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:393:"La version 3.9 de WordPress, baptisée &#171;&#160;Smith&#160;&#187; en l&#8217;honneur de l&#8217;organiste de jazz Jimmy Smith, est disponible  en téléchargement ou en mise à jour depuis le tableau de bord de votre site WordPress. Cette version apporte un grand nombre d’améliorations, et nous pensons que vous allez les adorer. Un processus de modification des médias plus [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Xavier";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5960:"<p>La version 3.9 de WordPress, baptisée &laquo;&nbsp;Smith&nbsp;&raquo; en l&rsquo;honneur de l&rsquo;organiste de jazz <a href="http://fr.wikipedia.org/wiki/Jimmy_Smith">Jimmy Smith</a>, est disponible  <a href="http://wordpress.org/download/">en téléchargement</a> ou en mise à jour depuis le tableau de bord de votre site WordPress. Cette version apporte un grand nombre d’améliorations, et nous pensons que vous allez les adorer.</p>\n<p><embed width="400" height="224" type="application/x-shockwave-flash" src="http://s0.videopress.com/player.swf?v=1.03" wmode="direct" seamlesstabbing="true" allowfullscreen="allowfullscreen" allowscriptaccess="always" overstretch="true" flashvars="guid=sAiXhCfV&amp;isDynamicSeeking=true"></embed></p>\n<h2 class="about-headline-callout"><em>Un processus de modification des médias plus fluide</em></h2>\n<h4>Édition visuelle améliorée</h4>\n<p><img class="alignnone wp-image-6979 size-full" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/editor1-300x233.jpg" alt="editor1-300x233" width="300" height="233" /></p>\n<p>L’éditeur visuel a été mis à jour pour gagner en vitesse, en accessibilité et en utilisation mobile. Vous pouvez coller vos écrits depuis votre éditeur de texte sans perdre de temps à nettoyer sa mise en page désordonnée (oui, c’est de toi que l’on parle, Microsoft Word).</p>\n<h4>Modifiez les images facilement</h4>\n<p><img class="alignnone size-full wp-image-6980" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/image1-300x233.jpg" alt="image1-300x233" width="300" height="233" /></p>\n<p>Avec un accès plus rapide aux outils de recadrage et de rotation, il est désormais plus facile de modifier vos images tandis que vous corrigez vos articles. Vous pouvez également changer l’échelle des images directement dans l’éditeur afin de trouver la taille qui convient.</p>\n<h4>Glissez/déposez vos images</h4>\n<p><img class="alignnone size-full wp-image-6981" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/dragdrop1-300x233.jpg" alt="dragdrop1-300x233" width="300" height="233" /></p>\n<p>La mise en ligne des images n’a jamais été aussi simple. Glissez simplement vos fichiers depuis votre ordinateur vers l’éditeur visuel.</p>\n<h4>Prévisualisation de galerie</h4>\n<p><img class="alignnone wp-image-6982 size-large" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/gallery1-500x280.jpg" alt="gallery1" width="500" height="280" /></p>\n<p>Les galeries s’affichent en de belles grilles directement dans l’éditeur, de la même manière qu’elles s’afficheront une fois l’article publié.</p>\n<h4>Faites-en plus avec l’audio et la vidéo</h4>\n<p><img class="alignnone size-large wp-image-6983" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/playliste-500x193.png" alt="playliste" width="500" height="193" /></p>\n<p>Les images ont leurs galeries, et désormais les fichiers audio et vidéo disposent de listes de lectures très simples, avec lesquelles vous pouvez présenter votre musique ou vos extraits vidéo.</p>\n<h4>Prévisualisation en direct des widgets et de l’en-tête</h4>\n<p>Ajoutez, modifiez et réarrangez vos widgets directement pendant la personnalisation du thème. Plus besoin d’enregistrer pour voir constater les problèmes : découvrez vos modifications en direct, et enregistrez-les une fois qu’elles sont validées.</p>\n<p>L’outil de gestion des images de l’en-tête a également été amélioré : vous pouvez mettre vos images en ligne, les recadre et gérer les en-têtes tout en personnalisant votre thème.</p>\n<h4>Un nouveau et superbe navigateur de thèmes</h4>\n<p><img class="alignnone size-large wp-image-6984" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/theme1-500x278.jpg" alt="theme1" width="500" height="278" /></p>\n<p>La recherche d’un nouveau thème devrait être facile et ludique. Perdez-vous dans l’offre sans fin de thèmes gratuits proposés par WordPress.org grâce au nouveau et magnifique navigateur de thèmes.</p>\n<h2 style="text-align: left;">L&rsquo;équipe</h2>\n<p>Cette version a été menée par <a href="http://nacin.com/">Andrew Nacin</a> et <a href="http://www.getsource.net/">Mike Schroder</a>, avec l&rsquo;aide de <a href="http://wordpress.org/news/2014/04/smith/">267 contributeurs</a>. Merci à eux !</p>\n<p>Maintenant que cette version est sortie, voici la manière dont vous pouvez aider la communauté pendant les prochains jours :</p>\n<ul>\n<li>Gardez un œil sur le forum d&rsquo;entraide ou sur votre réseau Twitter pour répondre aux questions ;</li>\n<li>Aidez vos amis, vos collègues, vos clients, votre groupe WordPress local et autres, à mettre à jour leurs sites ;</li>\n<li>Faites remonter tout ce qui vous semble suspect, et ne pas avoir peur d&rsquo;en parler aux responsables de l&rsquo;équipe WP (ou WPFR).</li>\n</ul>\n<p>Merci d&rsquo;avoir choisi WordPress, et à bientôt pour la version 4.0 !</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wPvO98ucIP4:I7rchQ6CsGk:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wPvO98ucIP4:I7rchQ6CsGk:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/wPvO98ucIP4" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"36";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:63:"http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:81:"L’Hebdo WordPress n°225 : WordPress 3.8.3 – WordPress 3.9 – BuddyPress 2.0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/7wegzds2MAw/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:115:"http://www.wordpress-fr.net/2014/04/15/lhebdo-wordpress-n225-wordpress-3-8-3-wordpress-3-9-buddypress-2-0/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 15 Apr 2014 05:54:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:7:"Jetpack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:13:"WordPress 3.8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6962";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:351:"2 semaines après le premier avril, je tiens à soulager toute la communauté en confirmant que l&#8217;information donnée dans le précédent hebdo était évidemment un gros poisson d&#8217;avril (juste au cas où certains y aurait cru&#8230;) Les prochaines rencontres en France A Lyon : le 22 avril. A Bayonne : WPMX remet le couvert le [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3983:"<p>2 semaines après le premier avril, je tiens à soulager toute la communauté en confirmant que l&rsquo;information donnée dans le précédent hebdo était évidemment <a title="L’Hebdo WordPress n°224 : Facebook/Automattic – Masonry – BuddyPress" href="http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/">un gros poisson d&rsquo;avril </a>(juste au cas où certains y aurait cru&#8230;)</p>\n<h3>Les prochaines rencontres en France</h3>\n<ul>\n<li><a href="http://www.meetup.com/WordPress-Lyon-Meetup/events/176385812/">A Lyon : le 22 avril.</a></li>\n<li><a href="https://www.facebook.com/events/298654000290012/">A Bayonne</a> : WPMX remet le couvert le 26 avril.</li>\n<li><a href="http://www.meetup.com/wordpress-ile-de-france/polls/1028452/">Une réflexion</a> pour un meetup parisien</li>\n</ul>\n<h3>WordPress 3.8.2 et WordPress 3.8.3</h3>\n<p>En une semaine de temps, 2 versions mineures de WordPress ont vu le jour : <a href="http://wordpress.org/news/2014/04/wordpress-3-8-2/">3.8.2</a> (en) et <a href="http://wordpress.org/news/2014/04/wordpress-3-8-3/">3.8.3 (en)</a>. La version 3.8.3 vient principalement réparer un dysfonctionnement du &laquo;&nbsp;brouillon rapide&nbsp;&raquo; apparu dans la 3.8.2.</p>\n<h3>WordPress 3.9 et MySQL</h3>\n<p>Des <a href="http://make.wordpress.org/plugins/2014/04/07/mysql-in-wordpress-3-9-implications-for-plugin-authors/">modifications (en) </a>interviennent concernant MySQL dans WordPress 3.9. <span style="text-decoration: underline;">Il est à noter que la version finale de WordPress 3.9 devrait sortir dans les tous prochains jours</span>.</p>\n<h3>BuddyPress 2.0 Beta 2 et RC1</h3>\n<p>BuddyPress 2.0 <a href="http://wptavern.com/major-milestone-for-buddypress-2-million-downloads-and-counting">progresse</a> (en), après une <a href="http://buddypress.org/2014/04/buddypress-2-0-beta2/">beta 2</a> (en), la <a href="http://buddypress.org/2014/04/buddypress-2-0-release-candidate/">première version candidate</a> (en) est sortie il y a quelques jours.</p>\n<h3>Jetpack 2.9.3</h3>\n<p>Jetpack arrive en <a href="http://jetpack.me/2014/04/10/jetpack-security-update/">version 2.9.3</a> (en) et apporte une correction d&rsquo;une faille ancienne mais découverte que récemment.</p>\n<h3>WordPress est-il le bon outil ?</h3>\n<p>Voici des éléments de réponse <a href="http://wpshout.com/wordpress-right-tool-job/">si vous vous posez parfois la question (en)</a>.</p>\n<h3>Forcer la mise à jour des extensions</h3>\n<p>Julio propose une nouvelle extension permettant de forcer la mise à jour des extensions : <a href="http://boiteaweb.fr/force-plugin-updates-re-installez-vos-plugins-rapidement-8016.html#">Force Plugin Updates</a>.</p>\n<h3>Personnaliser les colonnes d&rsquo;administration</h3>\n<p>Pour personnaliser les colonnes de votre administration, essayez cette extension : <a href="http://www.geekpress.fr/wordpress/extension/personnaliser-colonnes-administration-2004/">CodePress Admin Column</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7wegzds2MAw:LehP5y6AqGA:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7wegzds2MAw:LehP5y6AqGA:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/7wegzds2MAw" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:111:"http://www.wordpress-fr.net/2014/04/15/lhebdo-wordpress-n225-wordpress-3-8-3-wordpress-3-9-buddypress-2-0/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"4";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:106:"http://www.wordpress-fr.net/2014/04/15/lhebdo-wordpress-n225-wordpress-3-8-3-wordpress-3-9-buddypress-2-0/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:54:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:75:"L’Hebdo WordPress n°224 : Facebook/Automattic – Masonry – BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/_VCUvlt4RF4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:93:"http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 01 Apr 2014 05:44:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6941";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:412:"!! Information de dernière minute !! Automattic est racheté par Facebook Nous venons d&#8217;apprendre d&#8217;une source proche du dossier que Matt Mullenweg, le co-fondateur de WordPress et CEO d&#8217;Automattic vient de finaliser un accord d&#8217;un montant de 20 milliards de dollars pour la revente d&#8217;Automattic à Facebook. C&#8217;est ainsi, avec une somme légèrement plus importante [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4850:"<h1>!! Information de dernière minute !!</h1>\n<h3>Automattic est racheté par Facebook</h3>\n<p>Nous venons d&rsquo;apprendre d&rsquo;une source proche du dossier que Matt Mullenweg, le co-fondateur de WordPress et CEO d&rsquo;Automattic vient de finaliser un accord d&rsquo;un montant de 20 milliards de dollars pour la revente d&rsquo;Automattic à Facebook. C&rsquo;est ainsi, avec une somme légèrement plus importante que sa récente acquisition de l’application Whatsapp, qui lui avait couté &laquo;&nbsp;seulement&nbsp;&raquo; 19 milliards de dollars, que le géant des réseaux sociaux acquiert l&rsquo;univers WordPress.</p>\n<p>Facebook, en pleine recherche de croissance externe après les rachats successifs d&rsquo;Instagram, de Whatsapp et dernièrement d&rsquo;Oculus met donc la main sur la maison mère de WordPress et notamment son service communautaire WordPress.com. On suppose que l&rsquo;aspect communautaire qui se développait sur la plateforme de blogs aura convaincu Facebook de sa puissance. Pour l&rsquo;instant, il est encore trop tôt pour savoir ce qu&rsquo;en fera le Géant du Web : intégration dans le réseau social, gestion de blog directement dans Facebook ou bien fusion de l&rsquo;ensemble&#8230; ?</p>\n<p>Pour le moment, le logiciel libre WordPress, disponible sur WordPress.org, semble ne pas être concerné par cette opération. En effet, la Fondation WordPress étant indépendante est encore à l&rsquo;abri&#8230; mais pour combien de temps ? Mark Zuckerberg a de nombreuses cordes à son arc et pourrait trouver la parade pour s&rsquo;approprier l&rsquo;application qui fait tourner 20 % du Web.</p>\n<p>L&rsquo;information n&rsquo;a pas encore &laquo;&nbsp;fuitée&nbsp;&raquo;, notre contact nous ayant donné l&rsquo;exclusivité de l&rsquo;information. Vous êtes donc les premiers à lire ce scoop.</p>\n<p>Nous irons à la pêche aux informations complémentaires qui, soyons en sûr, devrait tomber dans notre chalut tout au long de la journée.</p>\n<p>Restez connectés</p>\n<p><span id="more-6941"></span></p>\n<h1>La suite de l&rsquo;Hebdo :</h1>\n<h3>WordPress 3.9 beta 3</h3>\n<p>N&rsquo;ayant pas eu le temps de faire la traduction de l&rsquo;article présentant la beta 3 de WordPress 3.9, <a href="http://wordpress.org/news/2014/03/wordpress-3-9-beta-3/">je vous glisse le lien ici</a> (en) au cas où vous l&rsquo;auriez manqué.</p>\n<h3>Masonry dans WordPress 3.9</h3>\n<p>Attention le <a href="http://make.wordpress.org/core/2014/03/27/masonry-in-wordpress-3-9/">script Masonry subi des changements</a> (en) suite à son passage à la version 3 dans WordPress 3.9.</p>\n<h3>BuddyPress 2.0</h3>\n<p>BuddyPress 2.0 arrive à la fin de son développement avec une <a href="http://buddypress.org/2014/03/buddypress-2-0-beta-1-is-now-available/">beta 1</a> (en). Pour découvrir les nouveautés <a href="http://buddydev.com/buddypress/buddypress-2-0-coming-soon-expect/">c&rsquo;est ici</a> (en).</p>\n<h3>Le futur des commentaires</h3>\n<p>Quel est l&rsquo;<a href="http://wptavern.com/what-is-the-future-of-comments-in-wordpress">avenir des commentaires </a> (en) dans WordPress ?</p>\n<h3>Une extension SEO pour les dominer tous</h3>\n<p>On pensait avoir tout vu en matière d&rsquo;extension SEO&#8230;. eh bien c&rsquo;était sans compter sur Julio et sa détermination légendaire. Il annonce dès aujourd&rsquo;hui la sortie de sa propre extension, bien plus simple que toutes les autres, mais terriblement efficace. <a href="http://boiteaweb.fr/google-1st-place-plugin-seo-7996.html">Exemple en image à l&rsquo;appui </a>!</p>\n<h3>Conserver la traduction du thème lors de la mise à jour</h3>\n<p>Si vous souhaitez conserver la traduction de votre thème lors de sa mise à jour, <a href="http://www.lumieredelune.com/encrelune/preserver-traduction-po,2014,03">vous devriez regarder cet article</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=_VCUvlt4RF4:FQdKOGKg__w:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=_VCUvlt4RF4:FQdKOGKg__w:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/_VCUvlt4RF4" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:89:"http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"23";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:84:"http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:48:"http://feeds.feedburner.com/WordpressFrancophone";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:4:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:20:"wordpressfrancophone";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:14:"emailServiceId";a:1:{i:0;a:5:{s:4:"data";s:20:"WordpressFrancophone";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:18:"feedburnerHostname";a:1:{i:0;a:5:{s:4:"data";s:28:"http://feedburner.google.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"feedFlare";a:9:{i:0;a:5:{s:4:"data";s:24:"Subscribe with NewsGator";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:112:"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:42:"http://www.newsgator.com/images/ngsub1.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:24:"Subscribe with Bloglines";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:77:"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone";s:3:"src";s:48:"http://www.bloglines.com/images/sub_modern11.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:23:"Subscribe with Netvibes";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:98:"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:44:"http://www.netvibes.com/img/add2netvibes.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:21:"Subscribe with Google";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:93:"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:51:"http://buttons.googlesyndication.com/fusion/add.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:25:"Subscribe with Pageflakes";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:101:"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:87:"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:21:"Subscribe with Plusmo";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:86:"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:43:"http://plusmo.com/res/graphics/fbplusmo.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:23:"Subscribe with Live.com";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:81:"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:141:"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:7;a:5:{s:4:"data";s:25:"Subscribe with Mon Yahoo!";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:98:"http://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:60:"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:8;a:5:{s:4:"data";s:25:"Subscribe with Excite MIX";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:89:"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:42:"http://image.excite.co.uk/mix/addtomix.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:52:"http://backend.userland.com/creativeCommonsRssModule";a:1:{s:7:"license";a:1:{i:0;a:5:{s:4:"data";s:49:"http://creativecommons.org/licenses/by-nc-sa/3.0/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:10:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:4:"etag";s:27:"s54Cswagkrpq3UJighfMKkuW/30";s:13:"last-modified";s:29:"Sun, 01 Jun 2014 20:52:48 GMT";s:4:"date";s:29:"Sun, 01 Jun 2014 21:06:45 GMT";s:7:"expires";s:29:"Sun, 01 Jun 2014 21:06:45 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:7:"80:quic";}s:5:"build";s:14:"20130911020210";}', 'no'); 
INSERT INTO `wp_options` VALUES (109, '_transient_timeout_feed_mod_66a70e9599b658d5cc038e8074597e7c', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (110, '_transient_feed_mod_66a70e9599b658d5cc038e8074597e7c', '1401656806', 'no'); 
INSERT INTO `wp_options` VALUES (111, '_transient_timeout_feed_2fb9572e3d6a42f680e36370936a57ae', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (112, '_transient_feed_2fb9572e3d6a42f680e36370936a57ae', 'a:4:{s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"feed";a:1:{i:0;a:6:{s:4:"data";s:303:"\n    \n    \n    \n    \n    \n    \n    \n  \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:27:"http://www.w3.org/2005/Atom";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"WordPress Francophone : Planet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"subtitle";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/planet/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:3:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:9:"alternate";s:4:"type";s:9:"text/html";s:4:"href";s:35:"http://www.wordpress-fr.net/planet/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:20:"application/atom+xml";s:4:"href";s:54:"http://feeds.feedburner.com/WordpressFrancophonePlanet";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"updated";a:1:{i:0;a:5:{s:4:"data";s:20:"2014-06-01T22:44:50Z";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:6:"Author";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:5:"entry";a:20:{i:0;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"WP Formation : WP Tech à Nantes le 29 Novembre 2014";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:43:"http://wpformation.com/wp-tech-nantes-2014/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:43:"http://wpformation.com/wp-tech-nantes-2014/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-31T09:13:14+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:11:"WPFormation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1341:"<div>\n<p><img width="300" height="215" src="http://wpformation.com/wp-content/uploads/2014/05/banniere-wptech-nantes-300x215.jpg" class="attachment-medium wp-post-image" alt="banniere-wptech-nantes" style="float: right; margin:0 0 10px 10px;">Fans de WordPress, r&eacute;servez vite vos places pour le 29 novembre 2014 et venez donc faire un tour &agrave; Nantes... &nbsp; WP Tech, K&eacute;sako ? Le WP Tech est le premier &eacute;v&eacute;nement technique d&eacute;di&eacute; &agrave; WordPress. Au menu des conf&eacute;rences pour&nbsp;mieux appr&eacute;hender l&rsquo;aspect technique de WordPress et&nbsp;savoir ce que l&rsquo;on peut faire avec, et surtout ...</p>\n<hr>\n<a rel="nofollow" href="http://wpformation.com/wp-tech-nantes-2014/">WP Tech &agrave; Nantes le 29 Novembre 2014</a> est un article de <a title="Formation Internet WordPress Ecommerce" href="http://wpformation.com/">WP Formation</a><br><a href="http://wpformation.com/formation-wordpress/">Formation WordPress</a> &amp; <a href="http://wpformation.com/formation-woocommerce-e-commerce/">eCommerce</a> - Retrouvez-moi sur <a title="Ajouter sur Facebook" href="http://www.facebook.com/Wibeweb">Facebook</a> - <a title="Suivre sur Twitter" href="http://twitter.com/wpformation">Twitter</a> - <a href="http://plus.google.com/+FabriceDucarme/">Google+</a><br><hr>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"L\'écho des plugins WordPress : Advanced Comments Moderation";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:72:"http://www.echodesplugins.li-an.fr/plugins/advanced-comments-moderation/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:72:"http://www.echodesplugins.li-an.fr/plugins/advanced-comments-moderation/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-30T10:11:57+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:83:"<div>Simplifiez l\'affichage de la liste de commentaires dans l\'administration</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:76:"Cree1site : Votre moteur de recherche interne peut vous aider à convertir !";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:50:"http://www.cree1site.com/moteur-recherche-interne/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:50:"http://www.cree1site.com/moteur-recherche-interne/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-28T21:17:54+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:8:"Rodrigue";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1628:"<div>\n<p>Vu sur le site de <a href="http://www.cree1site.com/">l\'agence web</a> Cree1site.com</p>\n<p>Les eComer&ccedil;ants ont pris conscience que la recherche interne est un facteur de conversion, par contre c&rsquo;est une vraie plaie sur WordPress. Pour cela je vous propose de d&eacute;couvrir une solution que je viens de mettre en place sur le eCommerce que je g&egrave;re au boulot. Le module existe pour Magento et Prestashop. Je vous montre le principe, et comment il va vous aider &agrave; convertir. Tweet Un matin au boulot je discute avec mon boss de la compl&eacute;mentarit&eacute; merdique du moteur interne de notre site (pourtant sous Sphinx). Je vous promets que c&rsquo;est un pur hasard qu&rsquo;une heure apr&egrave;s je re&ccedil;ois un appel de Matthieu (le repr&eacute;sentant de Doofinder France, module de recherche interne intelligent que je vous pr&eacute;sente plus bas). Alors nous discutons un peu et Matthieu me demande si je suis int&eacute;ress&eacute; pour tester le moteur interne que propose sa soci&eacute;t&eacute; (de base Espagnole). Et comme je crois beaucoup en ce moteur intelligent, j&rsquo;ai d&eacute;cid&eacute; d&rsquo;en parler, apr&egrave;s l&rsquo;avoir installer sur la boutique de jouets du boulot. Votre e-commerce peut-il concurrencer Amazon ? Toutes recherches depuis votre moteur interne sont des opportunit&eacute;s de ventes. Imaginez [&hellip;]</p>\n<p>Cet article <a rel="nofollow" href="http://www.cree1site.com/moteur-recherche-interne/">Votre moteur de recherche interne peut vous aider &agrave; convertir !</a> est apparu en premier sur Cree1site.com</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:98:"WordPress Francophone : L’Hebdo WordPress n°230 : WordPress 4.0 – Jetpack 3.0 – WPTech 2014";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-27T07:23:07+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:3952:"<div>\n<h3>WordPress 4.0</h3>\n<p>D&eacute;j&agrave; quelques pr&eacute;cisions concernant l&rsquo;<a href="http://make.wordpress.org/core/2014/05/21/internationalization-goals-for-4-0/">internationalisation dans WordPress 4.0</a> (en).</p>\n<h3>Jetpack 3.0</h3>\n<p><a href="http://jetpack.me/2014/05/20/jetpack-3-0/">Jetpack passe en version 3.0</a> et se relooke en partie.</p>\n<h3>WPTech 2014</h3>\n<p><a href="http://2014.wptech.fr/">WPTech</a> est la premi&egrave;re &eacute;dition d&rsquo;une manifestation consacr&eacute;e &agrave; WordPress, mais uniquement du c&ocirc;t&eacute; technique du sujet. L&rsquo;id&eacute;e vient d&rsquo;une partie de la communaut&eacute; nantaise. Bravo &agrave; elle&hellip;. et d&eacute;j&agrave; <a href="http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/">on en parle sur le web</a>.</p>\n<h3>Les meetups franciliens se &laquo;&nbsp;veryfrenchtripise&nbsp;&raquo;</h3>\n<p>Organis&eacute;s par une bonne partie de la Very French Trip team <a href="http://veryfrenchtrip-wp.eu/meetup-wordpress-23-mai-14-paris/">les meetups franciliens cherchent &agrave; &eacute;voluer</a>.</p>\n<h3>Un superh&eacute;ros WordPress, c&rsquo;est quoi ?</h3>\n<p><a href="http://www.wppourlesnuls.com/comment-devenir-un-super-heros-wordpress-infographie/">La r&eacute;ponse en infographie</a>.</p>\n<h3>Interview de Rodrigue F&eacute;nard</h3>\n<p><a href="http://lesdoigtsdanslenet.com/rodrigue-fenard-specialiste-wordpress/">Rodrigue </a>est interview&eacute; par les Doigts dans le Net.</p>\n<h3>Utiliser les &laquo;&nbsp;social meta tags&nbsp;&raquo; de WordPress</h3>\n<p>Pour en savoir plus sur les social meta tags, un conseil,<a href="http://www.wpexplorer.com/setup-open-graph-twitter-cards-wordpress/"> lisez cet article </a>(en).</p>\n<h3>Le VFT Podcast n&deg;1</h3>\n<p><a href="http://veryfrenchtrip-wp.eu/podcast-1/">Un nouveau podcast est toujours un &eacute;v&eacute;nement </a>mais quand il est fran&ccedil;ais et r&eacute;alis&eacute; par une bande de joyeux lurons comme la VFT team alors on y va les yeux ferm&eacute;s (&ccedil;a tombe bien, y a pas d&rsquo;images !)<br><em><strong>Ajout :</strong></em> Pour suivre le podcast, abonnez-vous via ce flux : <a href="http://veryfrenchtrip-wp.eu/flux/podcast/feed/">http://veryfrenchtrip-wp.eu/flux/podcast/feed/</a></p>\n<h3>Google dans son site WordPress</h3>\n<p>Pour int&eacute;grer les<a href="http://premium.wpmudev.org/blog/wordpress-google-plugins/"> outils de Google dans votre site</a> (en), voici quelques id&eacute;es.</p>\n<h3>Du support client embarqu&eacute;</h3>\n<p>Avec <a href="http://issuepress.co/">IssuePress (en)</a>, il devient possible d&rsquo;embarquer son propre service client dans son interface d&rsquo;administrateur.</p>\n<h3>Une page de connexion personnalis&eacute;e</h3>\n<p>Cr&eacute;er une page de connexion personnalis&eacute;e est possible&hellip; <a href="http://premium.wpmudev.org/blog/create-a-custom-wordpress-login-page/">voici la m&eacute;thode</a> (en).</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ" border="0"></a>\n</div>\n<img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/P6DmqnLdfQ4" height="1" width="1">\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"L\'écho des plugins WordPress : Admin Menu Tree Page View";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:69:"http://www.echodesplugins.li-an.fr/plugins/admin-menu-tree-page-view/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:69:"http://www.echodesplugins.li-an.fr/plugins/admin-menu-tree-page-view/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-26T11:30:36+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:63:"<div>Deux plugins pour simplifier la gestion de ses pages</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:53:"WP Formation : WordFence Antivirus WordPress efficace";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpformation.com/wordfence-antivirus-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:53:"http://wpformation.com/wordfence-antivirus-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-24T08:20:10+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:11:"WPFormation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1328:"<div>\n<p><img width="300" height="192" src="http://wpformation.com/wp-content/uploads/2014/05/wordfence-logo-300x192.jpg" class="attachment-medium wp-post-image" alt="wordfence" style="float: right; margin:0 0 10px 10px;">La s&eacute;curit&eacute; de votre site WordPress est primordiale. Tant de travail et d\'articles sur votre blog et tout d\'un coup, une simple attaque et... Patatra! Tout est perdu, infect&eacute;, pirat&eacute;:/ Ces derniers temps, j\'ai vu augmenter des probl&egrave;mes de s&eacute;curit&eacute; sur des sites WordPress, des probl&egrave;mes de scraping, d\'injection de codes malicieux, de banni&egrave;res publicitaires ...</p>\n<hr>\n<a rel="nofollow" href="http://wpformation.com/wordfence-antivirus-wordpress/">WordFence Antivirus WordPress efficace</a> est un article de <a title="Formation Internet WordPress Ecommerce" href="http://wpformation.com/">WP Formation</a><br><a href="http://wpformation.com/formation-wordpress/">Formation WordPress</a> &amp; <a href="http://wpformation.com/formation-woocommerce-e-commerce/">eCommerce</a> - Retrouvez-moi sur <a title="Ajouter sur Facebook" href="http://www.facebook.com/Wibeweb">Facebook</a> - <a title="Suivre sur Twitter" href="http://twitter.com/wpformation">Twitter</a> - <a href="http://plus.google.com/+FabriceDucarme/">Google+</a><br><hr>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:56:"L\'écho des plugins WordPress : Admin Management Xtended";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.echodesplugins.li-an.fr/plugins/admin-management-xtended/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:68:"http://www.echodesplugins.li-an.fr/plugins/admin-management-xtended/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-22T10:46:20+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:67:"<div>G&eacute;rez vos billets/pages directement dans la liste</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"BoiteAWeb : Comment devenir un Super Héros WordPress : Infographie";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:82:"http://boiteaweb.fr/comment-devenir-un-super-heros-wordpress-infographie-8100.html";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:82:"http://boiteaweb.fr/comment-devenir-un-super-heros-wordpress-infographie-8100.html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-22T01:22:36+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:12:"Julio Potier";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:323:"<div>\n<p>Quoi ? Je suis un H&eacute;ros WordPress ? Cool :)</p>\n<p>Cet article <a href="http://boiteaweb.fr/comment-devenir-un-super-heros-wordpress-infographie-8100.html">Comment devenir un Super H&eacute;ros WordPress : Infographie</a> est apparu en premier sur <a href="http://boiteaweb.fr/">BoiteAWeb.fr</a>.</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:46:"WordPress Channel : Jetpack 3.0 pour WordPress";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:43:"http://wpchannel.com/jetpack-3-0-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:43:"http://wpchannel.com/jetpack-3-0-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-21T11:47:45+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:780:"<div>\n<p>Le plugin Jetpack vient tout juste d&rsquo;atterrir en version 3.0 sur l&rsquo;a&eacute;roport international d&rsquo;Automattic. Le commandant de bord de WordPress Channel vous invite &agrave; la pr&eacute;sentation des nouveaut&eacute;s, grand fan du module super-puissant pour un d&eacute;collage r&eacute;ussi de votre site WordPress. Attachez vos ceintures ! A propos de Jetpack Jetpack n&rsquo;est pas un plugin WordPress&hellip;</p>\n<p><a rel="nofollow" href="http://wpchannel.com/author/aurelien-denis/">Aur&eacute;lien Denis</a> - <a rel="nofollow" href="http://wpchannel.com/">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel="nofollow" href="http://wpchannel.com/jetpack-3-0-wordpress/">Jetpack 3.0 pour WordPress</a></p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"Grégoire Noyelle : WordPress :: Very French Trip Podcast 1";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.gregoirenoyelle.com/wordpress-very-french-trip-podcast-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:68:"http://www.gregoirenoyelle.com/wordpress-very-french-trip-podcast-1/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-21T06:57:02+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:17:"Grégoire Noyelle";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:419:"<div>Apr&egrave;s le lancement du site Very French Trip, au moment du 1er WordCamp Europe, la petite &eacute;quipe a relanc&eacute; le Meet Up WordPress Ile de France. Aujourd&rsquo;hui nous vous annon&ccedil;ons la sortie de notre nouveau BB; un podcast D&eacute;di&eacute; &agrave; WordPress: #VFT Podcast. Nous traiterons de WordPress &eacute;videmment, mais pas seulement. Nous pourrons aborder: le [&hellip;]</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"Cree1site : WP Tech : Le rendez-vous WordPress 100% Technique";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:64:"http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:64:"http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-20T14:07:02+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:8:"Rodrigue";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1602:"<div>\n<p>Vu sur le site de <a href="http://www.cree1site.com/">l\'agence web</a> Cree1site.com</p>\n<p>Le 29 Novembre prochain aura lieu &agrave; Nantes le premier &eacute;v&eacute;nement de WP Tech, ce nouveau format de conf&eacute;rences sur WordPress sera r&eacute;alis&eacute; gr&acirc;ce &agrave; quatre protagonistes : Willy Bahuaud Daniel Roch Simon Janin St&eacute;phanie Vachon C&rsquo;est la premi&egrave;re fois o&ugrave; un &eacute;v&eacute;nement WordPress se d&eacute;roulera &agrave; 100% autour de la technique WordPress. Vous y apprendrez &agrave; d&eacute;velopper, et contr&ocirc;ler votre site. Fini d&rsquo;appeler votre prestataire &agrave; chaque petit probl&egrave;me, cette fois, vous aurez le contr&ocirc;le. On reste dans le partage En effet ce n&rsquo;est pas dans le but de faire du fric que s&rsquo;organise ce genre d&rsquo;&eacute;vent. On le sait bien maintenant, ce moment de partage est avant tout pour sa qualit&eacute; premi&egrave;re, l&rsquo;&eacute;change. Vous ne serez pas d&eacute;&ccedil;u car vu les organisateurs, je pense que &ccedil;a va r&eacute;unir du beau monde. Alors que vous soyez D&eacute;v, Int&eacute;, Graphistes, ou m&ecirc;me comme moi chef de projet, et souhaitez mieux appr&eacute;hender l&rsquo;outil, c&rsquo;est &agrave; WP tech qu&rsquo;il faut penser. En savoir plus sur Wp Tech ou devenir orateur : http://2014.wptech.fr/</p>\n<p>Cet article <a rel="nofollow" href="http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/">WP Tech : Le rendez-vous WordPress 100% Technique</a> est apparu en premier sur Cree1site.com</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:92:"WordPress Francophone : L’Hebdo WordPress n°229 : Communautés – Extensions – Astuces";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/5ZwQnV00lFY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/5ZwQnV00lFY/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-20T07:23:15+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:3572:"<div>\n<h2>Les Communaut&eacute;s</h2>\n<h3>Bordeaux WordPress&rsquo;Camp #10</h3>\n<p>Pour la 10e &eacute;dition de cette r&eacute;union bordelaise, il sera question <a href="https://www.facebook.com/events/1485744844988525/">de s&eacute;curit&eacute; et de maintenance</a>. Elle aura lieu le 12 juin &agrave; 18 H 30.</p>\n<h3>Meetup &agrave; Lyon</h3>\n<p>D&egrave;s ce jeudi 22 mai, Lyon propose un <a href="http://www.meetup.com/WordPress-Lyon-Meetup/">meetup autour de WordPress et de l&rsquo;extension ACF</a>.</p>\n<h3>Meetup &agrave; Paris</h3>\n<p>La <a href="http://www.meetup.com/wordpress-ile-de-france/">communaut&eacute; parisienne se r&eacute;unie le vendredi 23 mai </a>autour d&rsquo;un verre.</p>\n<h3>Meetup WordPress in Alps</h3>\n<p>La <a href="http://www.wpinalps.com/#prochaine-rencontre">communaut&eacute; alpine se retrouvera le 10 juin</a>, &agrave; l&rsquo;initiative de l&rsquo;association WordPress in Alps. La r&eacute;union est pr&eacute;vue &agrave; Grenoble.</p>\n<h3>Faire du CRM avec WordPress</h3>\n<p>Si vous souhaitez vous lancer dans le <a href="https://kinsta.com/blog/crm-wordpress-plugins/">CRM avec WordPress</a> (en), ces extensions et conseils vous seront utiles.</p>\n<h3>Font Awsome int&egrave;gre WordPress</h3>\n<p>La police de caract&egrave;re <a href="http://fontawesome.io/whats-new/">Font Awsome vient d&rsquo;int&eacute;grer une ic&ocirc;ne de WordPress</a> (en) dans sa nouvelle mise &agrave; jour.</p>\n<h3>4 optimisations simples pour booster le SEO</h3>\n<p>Lumi&egrave;re de Lune explique comment, <a href="http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05">en 4 points, on peut optimiser un site pour le SEO.</a></p>\n<h3>Une favicon bien faite</h3>\n<p>WPChannel montre comment <a href="http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/">faire une favicon</a> digne de ce nom pour votre site sous WordPress.</p>\n<h3>Construire un job-board</h3>\n<p>WordPress peut d&eacute;sormais se transformer en un v&eacute;ritable job board gr&acirc;ce &agrave; cette extension : <a href="http://www.poststat.us/building-new-wp-job-manager-website/">WP Job Manager</a>.</p>\n<h3>Une communaut&eacute; de traducteurs</h3>\n<p>WordPress &eacute;tant international, il est logique de voir apparaitre une <a href="http://wp-translations.org/lets-create-community-together/">communaut&eacute; de traducteurs</a> (en).</p>\n<h3>Bien choisir un h&eacute;bergement</h3>\n<p>Quelques <a href="http://wpformation.com/choisir-hebergement-wordpress">conseils de Fabrice</a> pour choisir son h&eacute;bergement pour WordPress.</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ" border="0"></a>\n</div>\n<img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/5ZwQnV00lFY" height="1" width="1">\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"L\'écho des plugins WordPress : Adjacent Archive Links";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.echodesplugins.li-an.fr/plugins/adjacent-archive-links-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:68:"http://www.echodesplugins.li-an.fr/plugins/adjacent-archive-links-2/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-19T17:54:59+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:55:"<div>Une navigation pour les archives temporelles</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:91:"Lumière de Lune : Quatre optimisations simples pour booster le SEO de votre site WordPress";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:76:"http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:76:"http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-15T11:36:26+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:10:"Marie-Aude";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:423:"<div>Pour un site bien optimis&eacute;, pas de secret, il faut mettre les mains dans le moteur ! A force d&rsquo;optimiser des th&egrave;mes WordPress, certaines choses reviennent tr&egrave;s souvent. Voici une liste de quelques optimisations simples, qui ne vous demandent pas de grosses connaissances en PHP. D&rsquo;autres vont &ecirc;tre nettement plus complexes&hellip; Important : travaillez toujours [&hellip;]</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:107:"WordPress Channel : Favicon by RealFaviconGenerator, une icône bien faite dans un blog WordPress bien fait";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:69:"http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:69:"http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-14T18:11:04+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:16:"Philippe Bernard";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:860:"<div>\n<p>Il est loin le temps o&ugrave; une simple ic&ocirc;ne en 16&times;16 suffisait &agrave; remplir le r&ocirc;le de favicon. Avec de plus hautes r&eacute;solutions et surtout de nouvelles plateformes mobiles, cette image s&rsquo;est diversifi&eacute;e. Un pr&eacute;c&eacute;dent article d&eacute;taillait les nouvelles formes et aspects du favicon et proposait une solution: RealFaviconGenerator. Ce site permet de concevoir un&hellip;</p>\n<p><a rel="nofollow" href="http://wpchannel.com/author/philippe/">Philippe Bernard</a> - <a rel="nofollow" href="http://wpchannel.com/">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel="nofollow" href="http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/">Favicon by RealFaviconGenerator, une ic&ocirc;ne bien faite dans un blog WordPress bien fait</a></p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:15;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:85:"WordPress Francophone : L’Hebdo WordPress n°228 : Android – BuddyPress – Scrap";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wpCN_XlMPRo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wpCN_XlMPRo/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-13T07:49:29+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:7840:"<div>\n<h3>WordPress pour Android 2.8</h3>\n<p>L&rsquo;application <a href="https://android.wordpress.org/2014/05/01/wordpress-for-android-2-8/">WordPress pour Android</a> arrive en version 2.8 (en). A noter que la <a href="https://play.google.com/store/apps/details?id=org.wordpress.android">mise &agrave; jour 2.8.1</a> est sortie.</p>\n<h3>BuddyPress 2.0.1</h3>\n<p>La <a href="http://buddypress.org/2014/05/buddypress-2-0-1/">premi&egrave;re mise &agrave; jour mineur de BuddyPress 2.0</a> (en) est arriv&eacute;e.</p>\n<h3>Les fichiers attach&eacute;s dans BuddyPress</h3>\n<p>iMath pr&eacute;sente les <a href="https://bpdevel.wordpress.com/2014/05/08/attachments-in-buddypress/">fichiers attach&eacute;s&nbsp; </a>(en) dans BuddyPress.</p>\n<h3>Revenons sur 5 ans de BuddyPress</h3>\n<p>L&rsquo;<a href="http://teleogistic.net/2014/05/five-years-of-buddypress/">histoire de BuddyPress depuis 5 ans</a> (en).</p>\n<h3>Alerte au scrap sur les sites WordPress</h3>\n<p>Cette semaine de tr&egrave;s nombreux sites utilisant WordPress se sont fait &laquo;&nbsp;scrapper&nbsp;&raquo;. <a href="http://wpformation.com/scrapping-masse-sites-wordpress/">Explications par Fabrice</a>.</p>\n<h3>Plus de 25 extensions &agrave; avoir en 2014</h3>\n<p>Voici une s&eacute;lection des<a href="http://premium.wpmudev.org/blog/25-must-have-wordpress-plugins-for-2014/"> 25 extensions</a> (en) &agrave; ne pas rater en 2014.</p>\n<h3>Une extension qui fait vos badges de WordCamp</h3>\n<p>En marge du WordCamp de Miami, un passionn&eacute; a r&eacute;alis&eacute; une extension qui permet de cr&eacute;er <a href="http://wptavern.com/would-anyone-be-interested-in-a-wordcamp-badges-plugin">son propre badge du WordCamp Miami (en)</a>. Il r&eacute;fl&eacute;chi &agrave; la possibilit&eacute; de faire en sorte de g&eacute;n&eacute;raliser l&rsquo;extension pour n&rsquo;mporte quel WordCamp.</p>\n<h3>D&eacute;couvrez BuddyPress</h3>\n<p><a href="http://wpchannel.com/re-decouvres-buddypress/">Si vous ne connaissez pas encore BuddyPress</a>, Mathieu vous explique tout sur WPChannel.</p>\n<h3>Une interview de Daniel Roch</h3>\n<p>Si comme moi vous aviez rat&eacute; <a href="https://www.youtube.com/watch?v=_y9YXhAVec0">cette interview de Daniel Roch</a>, c&rsquo;est le moment de vous rattraper.</p>\n<h3>WP-Rocket s&rsquo;internationalise</h3>\n<p>L&rsquo;extension WP Rocket devient internationale, <a href="http://wptavern.com/wp-rocket-launches-commercial-caching-plugin-for-wordpress">WPTavern s&rsquo;en fait l&rsquo;&eacute;cho</a> (en).</p>\n<h3>L&rsquo;API de TinyMCE</h3>\n<p>La version de 3.9 int&egrave;gre beaucoup de nouveaut&eacute;s et notamment dans TinyMCE. Son int&eacute;gration dans le core de WordPress apporte une nouvelle API&hellip;<a href="http://www.wpexplorer.com/wordpress-tinymce-tweaks/"> autorisant de nombreuses possibilit&eacute;s</a> (en). Et voici un <a href="http://www.tweetpress.fr/faqs/comment-ajouter-icone-bouton-tinymce-wordpress-3-9/">exemple de ce qu&rsquo;on peut faire</a>.</p>\n<h3>Les jetons de s&eacute;curit&eacute;</h3>\n<p>Julio pr&eacute;sente la question des <a href="http://boiteaweb.fr/jetons-securite-petit-plus-dont-vous-avez-besoin-8070.html">jetons de s&eacute;curit&eacute;</a> et l&rsquo;applique &agrave; WordPress.</p>\n<h3>L&rsquo;effet FancyBox et WordPress</h3>\n<p>WPChannel explique <a href="http://wpchannel.com/fancybox-wordpress-galerie-image/">comment utiliser FancyBox sur un site WordPress</a>.</p>\n<h3>Organiser les types de contenus et les librairies</h3>\n<p>Voici <a href="http://tommcfarlin.com/organizing-wordpress-content-types-libraries/">une solution pr&eacute;sent&eacute;e</a> par Tom McFarlin (en).</p>\n<h3>Automattic l&egrave;ve 160 millions de dollars</h3>\n<p>Matt annonce qu&rsquo;Automattic<a href="http://ma.tt/2014/05/new-funding-for-automattic/"> l&egrave;ve 160 millions de dollars (en)</a>&hellip; et explique les <a href="http://techcrunch.com/2014/05/07/automattic-ceo-matt-mullenweg-talks-funding-investing-and-the-future-of-wordpress/">investissements et l&rsquo;avenir de WordPress</a> (en).</p>\n<h3>Prot&eacute;ger son wp-config</h3>\n<p>Si vous souhaitez prot&eacute;ger votre fichier wp-config.php via le fichier .htaccess<a href="http://wp-snippets.com/protect-wp-config-php-with-htaccess/"> voici comment proc&eacute;der (en).</a></p>\n<h3>Une table ronde sur les h&eacute;bergeurs de WordPress</h3>\n<p><a href="http://wpbacon.com/podcast/wordpress-hosting-panel/">WPBacon </a>a organis&eacute; une <a href="http://wptavern.com/highlights-of-the-wpbacon-wordpress-webhosting-roundtable">table ronde pour parler h&eacute;bergements</a>. (en)</p>\n<h3>Matt Mullenweg est un homme dangereux</h3>\n<p>C&rsquo;est le titre accrocheur de cet article pour montrer la &laquo;&nbsp;peur&nbsp;&raquo; du gouvernement am&eacute;ricain envers l&rsquo;open source en g&eacute;n&eacute;ral et WordPress en particulier. <a href="http://joeflood.com/2014/05/07/matt/">Angle de vue d&eacute;cal&eacute;&nbsp; </a>(en) pour montrer le ridicule d&rsquo;une situation loin d&rsquo;&ecirc;tre erron&eacute;e.</p>\n<h3>Cr&eacute;ation d&rsquo;une page de maintenance personnalis&eacute;e</h3>\n<p>La page de maintenance par d&eacute;faut de WordPress est triste &agrave; souhait ! <a href="http://www.gregoirenoyelle.com/wordpress-creation-page-maintenance-personnalisee/">Personnalisez-la gr&acirc;ce &agrave; Gr&eacute;goire</a>.</p>\n<h3>WordPress n&rsquo;est pas un CMS</h3>\n<p>Mmmmhhh, <a href="http://www.screenfeed.fr/blog/wordpress-pas-cms-02223/">encore de la pol&eacute;mique dans l&rsquo;air</a>&hellip; mais l&agrave;, l&rsquo;offensive est argument&eacute;e&hellip;</p>\n<h3>&Eacute;volution du nombre d&rsquo;extensions</h3>\n<p>Julio constate l&rsquo;<a href="http://boiteaweb.fr/combien-plugins-wordpress-8075.html">&eacute;volution du nombre d&rsquo;extensions dans le r&eacute;pertoire officiel</a>.</p>\n<h3>Des s&eacute;ries d&rsquo;articles en liste d&eacute;roulante</h3>\n<p>C&rsquo;est l&rsquo;extension <a href="http://www.echodesplugins.li-an.fr/plugins/wp-post-series/">WP Post Series</a> qui le permet.</p>\n<h3>60 th&egrave;mes typ&eacute;s business pour 2014</h3>\n<p>WPMUDEV pr&eacute;sente une liste de <a href="http://premium.wpmudev.org/blog/free-responsive-wordpress-business-themes/">60 th&egrave;mes gratuits</a> (en) typ&eacute;s business et sortis en 2014.</p>\n<h3>Une extension peut disparaitre du r&eacute;pertoire officiel ?</h3>\n<p>Marie-Aude explique les raisons de la <a href="http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05">disparition d&rsquo;une extension du r&eacute;pertoire officiel </a>et les cons&eacute;quences &agrave; en tirer.</p>\n<h3>Lev&eacute; de rideau sur les nouveaux th&egrave;mes ElegantThemes</h3>\n<p>Rodrigue pr&eacute;sente ce que va &ecirc;tre l<a href="http://www.cree1site.com/eleganttheme-2/">&lsquo;avenir des th&egrave;mes ElegantThemes</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ" border="0"></a>\n</div>\n<img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/wpCN_XlMPRo" height="1" width="1">\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:16;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"Cree1site : Elegantthemes : Levé de rideau sur les nouveaux thèmes";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:40:"http://www.cree1site.com/eleganttheme-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:40:"http://www.cree1site.com/eleganttheme-2/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-12T23:47:58+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:8:"Rodrigue";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1755:"<div>\n<p>Vu sur le site de <a href="http://www.cree1site.com/">l\'agence web</a> Cree1site.com</p>\n<p>Nick Roach, le fondateur et designer de Elegantthemes annonce l&rsquo;arriv&eacute;e d&rsquo;un grand moment sur la c&eacute;l&egrave;bre plateforme de vente de th&egrave;mes premium &hellip; mais de quoi parlait t&rsquo;il ? J&rsquo;ai donc ouvert le mail r&eacute;serv&eacute; aux inscrits Elegantthemes. Avant de revenir sur l&rsquo;annonce de Nick, pour ceux qui ne connaissent pas encore, Elegantthemes c&rsquo;est un site de th&egrave;mes premium, qui a la particularit&eacute; de proposer un forfait unique pour acc&eacute;der &agrave; l&rsquo;ensemble de ces r&eacute;alisations. Loin de Themeforest qui lui vend au one shot les th&egrave;mes de cr&eacute;ateurs, en tant que VRAIE marketplace. Le site Elegantthemes, c&rsquo;est&nbsp; l&rsquo;ensemble des 87 th&egrave;mes (&agrave; ce jour) pour seulement cinquante euros. Soit un th&egrave;me &agrave; moins de 0.50 euro l&rsquo;unit&eacute;. Tout est inclus &agrave; ce prix, m&ecirc;me une interface d&rsquo;administration qui comblera les novices par sa simplicit&eacute;. Dans les chiffres, Elegantthemes c&rsquo;est donc : L&rsquo;acc&egrave;s pour un prix ridicule &agrave; des th&egrave;mes professionnels (69$) Plus de 233,869 clients qui ont acc&egrave;s &agrave; 87 th&egrave;mes Alors c&rsquo;est quoi l&rsquo;annonce de Nick Roach ? Si vous suivez l&rsquo;actu WordPress, vous n&rsquo;&ecirc;tes pas sans savoir que le designer de Elegantthemes et tout le reste [&hellip;]</p>\n<p>Cet article <a rel="nofollow" href="http://www.cree1site.com/eleganttheme-2/">Elegantthemes : Lev&eacute; de rideau sur les nouveaux th&egrave;mes</a> est apparu en premier sur Cree1site.com</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:17;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"L\'écho des plugins WordPress : WP Auto Featured Image";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:66:"http://www.echodesplugins.li-an.fr/plugins/wp-auto-featured-image/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:66:"http://www.echodesplugins.li-an.fr/plugins/wp-auto-featured-image/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-12T17:06:27+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:74:"<div>Choisir une image par d&eacute;faut comme image &agrave; la une</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:18;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:50:"WP Formation : Le Business généré par WordPress";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:42:"http://wpformation.com/business-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:42:"http://wpformation.com/business-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-12T11:45:00+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:11:"WPFormation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1376:"<div>\n<p><img width="300" height="107" src="http://wpformation.com/wp-content/uploads/2014/05/businness-wordpress-300x107.jpg" class="attachment-medium wp-post-image" alt="businness-wordpress" style="float: right; margin:0 0 10px 10px;">WordPress est aujourd&rsquo;hui le syst&egrave;me de gestion de contenu (CMS) incontournable pour toute personne souhaitant cr&eacute;er facilement et rapidement un site internet. Le logiciel est open source et accessible gratuitement par n&rsquo;importe quelle personne poss&eacute;dant une connexion internet.&nbsp;Pourtant, l&rsquo;entreprise du cr&eacute;ateur du logiciel, Automattic, est florissante et a en son sein plus de 250 employ&eacute;s. ...</p>\n<hr>\n<a rel="nofollow" href="http://wpformation.com/business-wordpress/">Le Business g&eacute;n&eacute;r&eacute; par WordPress</a> est un article de <a title="Formation Internet WordPress Ecommerce" href="http://wpformation.com/">WP Formation</a><br><a href="http://wpformation.com/formation-wordpress/">Formation WordPress</a> &amp; <a href="http://wpformation.com/formation-woocommerce-e-commerce/">eCommerce</a> - Retrouvez-moi sur <a title="Ajouter sur Facebook" href="http://www.facebook.com/Wibeweb">Facebook</a> - <a title="Suivre sur Twitter" href="http://twitter.com/wpformation">Twitter</a> - <a href="http://plus.google.com/+FabriceDucarme/">Google+</a><br><hr>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:19;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"Lumière de Lune : Pourquoi un plugin peut disparaître de WordPress.org ?";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:65:"http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:65:"http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-10T19:09:37+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:10:"Marie-Aude";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:459:"<div>La disparition soudaine d&rsquo;un plugin du r&eacute;pertoire des extensions sur WordPress.org n&rsquo;est jamais une information &agrave; prendre &agrave; la l&eacute;g&egrave;re, et quand cela arrive, d&egrave;s qu&rsquo;on s&rsquo;en aper&ccedil;oit, il faut essayer de comprendre ce qui se passe, pour d&eacute;cider si, oui ou non, ce plugin est &agrave; conserver. En r&eacute;sum&eacute;, un plugin disparait du r&eacute;pertoire [&hellip;]</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:26:"wordpressfrancophoneplanet";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}s:4:"type";i:512;s:7:"headers";a:10:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:4:"etag";s:27:"tUsgMvq+uaHnOyTM3JHsNqfL4k0";s:13:"last-modified";s:29:"Sun, 01 Jun 2014 20:44:51 GMT";s:4:"date";s:29:"Sun, 01 Jun 2014 21:06:46 GMT";s:7:"expires";s:29:"Sun, 01 Jun 2014 21:06:46 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:7:"80:quic";}s:5:"build";s:14:"20130911020210";}', 'no'); 
INSERT INTO `wp_options` VALUES (113, '_transient_timeout_feed_mod_2fb9572e3d6a42f680e36370936a57ae', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (114, '_transient_feed_mod_2fb9572e3d6a42f680e36370936a57ae', '1401656806', 'no'); 
INSERT INTO `wp_options` VALUES (115, '_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109', '1401700007', 'no'); 
INSERT INTO `wp_options` VALUES (116, '_transient_feed_b9388c83948825c1edaef0d856b7b109', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n	\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"WordPress Plugins » View: Most Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:44:"http://wordpress.org/plugins/browse/popular/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:39:"WordPress Plugins » View: Most Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 01 Jun 2014 20:56:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:25:"http://bbpress.org/?v=1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:15:{i:0;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Contact Form 7";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:54:"http://wordpress.org/plugins/contact-form-7/#post-2141";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 02 Aug 2007 12:45:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"2141@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:54:"Just another contact form plugin. Simple but flexible.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Takayuki Miyoshi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"Jetpack by WordPress.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:48:"http://wordpress.org/plugins/jetpack/#post-23862";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 Jan 2011 02:21:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"23862@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:104:"Supercharge your WordPress site with powerful features previously only available to WordPress.com users.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Tim Moore";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:7:"Akismet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"http://wordpress.org/plugins/akismet/#post-15";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:11:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"15@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:98:"Akismet checks your comments against the Akismet web service to see if they look like spam or not.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"WordPress SEO by Yoast";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wordpress.org/plugins/wordpress-seo/#post-8321";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 01 Jan 2009 20:34:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"8321@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:131:"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the WordPress SEO plugin by Yoast.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Joost de Valk";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"Google XML Sitemaps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"http://wordpress.org/plugins/google-sitemap-generator/#post-132";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:31:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"132@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:105:"This plugin will generate a special XML sitemap which will help search engines to better index your blog.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Arnee";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:58:"http://wordpress.org/plugins/all-in-one-seo-pack/#post-753";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Mar 2007 20:08:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"753@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:126:"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"uberdose";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"Wordfence Security";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:50:"http://wordpress.org/plugins/wordfence/#post-29832";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 04 Sep 2011 03:13:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"29832@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:137:"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Wordfence";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"MailPoet Newsletters";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/plugins/wysija-newsletters/#post-32629";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 02 Dec 2011 17:09:16 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"32629@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:94:"Send newsletters, post notifications or autoresponders from WordPress easily, and beautifully.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"MailPoet Staff";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WooCommerce - excelling eCommerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"http://wordpress.org/plugins/woocommerce/#post-29860";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Sep 2011 08:13:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"29860@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:97:"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"WooThemes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"NextGEN Gallery";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/plugins/nextgen-gallery/#post-1169";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Apr 2007 20:08:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"1169@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:121:"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 10 million downloads.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Alex Rabe";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"WordPress Importer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/plugins/wordpress-importer/#post-18101";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 May 2010 17:42:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"18101@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:101:"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brian Colinger";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:46:"iThemes Security (formerly Better WP Security)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/plugins/better-wp-security/#post-21738";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 22 Oct 2010 22:06:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"21738@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:63:"The easiest, most effective way to secure WordPress in seconds.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Chris Wiegman";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"WPtouch Mobile Plugin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:47:"http://wordpress.org/plugins/wptouch/#post-5468";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 01 May 2008 04:58:09 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"5468@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:63:"Create a slick mobile WordPress website with just a few clicks.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"BraveNewCode Inc.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"TinyMCE Advanced";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"http://wordpress.org/plugins/tinymce-advanced/#post-2082";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 27 Jun 2007 15:00:26 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"2082@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:71:"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Andrew Ozz";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"W3 Total Cache";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/plugins/w3-total-cache/#post-12073";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 29 Jul 2009 18:46:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"12073@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:132:"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Frederick Townes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:45:"http://wordpress.org/plugins/rss/view/popular";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:7:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Sun, 01 Jun 2014 21:06:46 GMT";s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:10:"connection";s:5:"close";s:4:"vary";s:15:"Accept-Encoding";s:13:"last-modified";s:29:"Thu, 02 Aug 2007 12:45:03 GMT";s:4:"x-nc";s:11:"HIT lax 249";}s:5:"build";s:14:"20130911020210";}', 'no'); 
INSERT INTO `wp_options` VALUES (117, '_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109', '1401700007', 'no'); 
INSERT INTO `wp_options` VALUES (118, '_transient_feed_mod_b9388c83948825c1edaef0d856b7b109', '1401656807', 'no'); 
INSERT INTO `wp_options` VALUES (119, '_transient_timeout_plugin_slugs', '1437170536', 'no'); 
INSERT INTO `wp_options` VALUES (120, '_transient_plugin_slugs', 'a:17:{i:0;s:33:"admin-menu-editor/menu-editor.php";i:1;s:30:"advanced-custom-fields/acf.php";i:2;s:29:"acf-repeater/acf-repeater.php";i:3;s:19:"akismet/akismet.php";i:4;s:35:"comment-control/comment-control.php";i:5;s:33:"duplicate-post/duplicate-post.php";i:6;s:9:"hello.php";i:7;s:27:"katz-enhance-admin/main.php";i:8;s:37:"post-types-order/post-types-order.php";i:9;s:41:"taxonomy-converter/taxonomy-converter.php";i:10;s:114:"tinymce-and-tinymce-advanced-professsional-formats-and-styles/tinymce-advanced-professional-formats-and-styles.php";i:11;s:29:"wp-db-backup/wp-db-backup.php";i:12;s:41:"wordpress-importer/wordpress-importer.php";i:13;s:51:"wpml-theme-tester/wpml-compatibility-test-tools.php";i:14;s:40:"sitepress-multilingual-cms/sitepress.php";i:15;s:34:"wpml-string-translation/plugin.php";i:16;s:38:"wpml-translation-management/plugin.php";}', 'no'); 
INSERT INTO `wp_options` VALUES (121, '_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51', '1401700007', 'no'); 
INSERT INTO `wp_options` VALUES (122, '_transient_dash_4077549d03da2e451c8b5f002294ff51', '<div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/\'>L’Hebdo WordPress n°230 : WordPress 4.0 – Jetpack 3.0 – WPTech 2014</a> <span class="rss-date">27 mai 2014</span><div class="rssSummary">WordPress 4.0 Déjà quelques précisions concernant l’internationalisation dans WordPress 4.0 (en). Jetpack 3.0 Jetpack passe en version 3.0 et se relooke en partie. WPTech 2014 WPTech est la première édition d’une manifestation consacrée à WordPress, mais uniquement du côté technique du sujet. L’idée vient d’une partie de la communauté nantaise. Bravo à elle…</div></li></ul></div><div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'http://wpformation.com/wp-tech-nantes-2014/\' title=\'Fans de WordPress, réservez vite vos places pour le 29 novembre 2014 et venez donc faire un tour à Nantes...   WP Tech, Késako ? Le WP Tech est le premier événement technique dédié à WordPress. Au menu des conférences pour mieux appréhender l’aspect technique de WordPress et savoir ce que l’on peut faire avec, et surtout ... WP Tech à Nantes le 29 Novembre 2\'>WP Formation : WP Tech à Nantes le 29 Novembre 2014</a></li><li><a class=\'rsswidget\' href=\'http://www.echodesplugins.li-an.fr/plugins/advanced-comments-moderation/\' title=\'Simplifiez l&#039;affichage de la liste de commentaires dans l&#039;administration\'>L&#039;écho des plugins WordPress : Advanced Comments Moderation</a></li><li><a class=\'rsswidget\' href=\'http://www.cree1site.com/moteur-recherche-interne/\' title=\'Vu sur le site de l&#039;agence web Cree1site.com Les eComerçants ont pris conscience que la recherche interne est un facteur de conversion, par contre c’est une vraie plaie sur WordPress. Pour cela je vous propose de découvrir une solution que je viens de mettre en place sur le eCommerce que je gère au boulot. Le module existe pour Magento et Prestashop. Je\'>Cree1site : Votre moteur de recherche interne peut vous aider à convertir !</a></li></ul></div><div class="rss-widget"><ul><li class=\'dashboard-news-plugin\'><span>Extensions populaires:</span> <a href=\'http://wordpress.org/plugins/jetpack/\' class=\'dashboard-news-plugin-link\'>Jetpack by WordPress.com</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=jetpack&amp;_wpnonce=d4b889e4f6&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Jetpack by WordPress.com\'>Installer</a>)</span></li></ul></div>', 'no'); 
INSERT INTO `wp_options` VALUES (126, 'theme_mods_twentyfourteen', 'a:1:{s:16:"sidebars_widgets";a:2:{s:4:"time";i:1401656874;s:4:"data";a:4:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:0:{}}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (127, 'current_theme', 'Pierre Katz', 'yes'); 
INSERT INTO `wp_options` VALUES (128, 'theme_mods_katz', 'a:2:{i:0;b:0;s:18:"nav_menu_locations";a:1:{s:7:"primary";s:1:"6";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (129, 'theme_switched', '', 'yes'); 
INSERT INTO `wp_options` VALUES (3816, 'widget_icl_lang_sel_widget', 'a:2:{i:1;a:1:{s:5:"title";b:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (130, 'recently_activated', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (132, 'acf_version', '4.3.8', 'yes'); 
INSERT INTO `wp_options` VALUES (133, 'ws_menu_editor', 'a:14:{s:22:"hide_advanced_settings";b:1;s:16:"show_extra_icons";b:0;s:11:"custom_menu";N;s:18:"first_install_time";i:1403088544;s:21:"display_survey_notice";b:1;s:17:"plugin_db_version";i:140;s:24:"security_logging_enabled";b:0;s:17:"menu_config_scope";s:6:"global";s:13:"plugin_access";s:14:"manage_options";s:15:"allowed_user_id";N;s:28:"plugins_page_allowed_user_id";N;s:27:"show_deprecated_hide_button";N;s:37:"dashboard_hiding_confirmation_enabled";b:1;s:23:"show_plugin_menu_notice";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (269, '_site_transient_timeout_browser_ebc347bfdf7c226e38e6eb9254ebf3ef', '1406741540', 'yes'); 
INSERT INTO `wp_options` VALUES (270, '_site_transient_browser_ebc347bfdf7c226e38e6eb9254ebf3ef', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"30.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (454, '_transient_random_seed', '238ae321c41a0559b1956164623140c3', 'yes'); 
INSERT INTO `wp_options` VALUES (522, '_site_transient_timeout_browser_b69641d2d7bcc44f549ced1604c4d328', '1408105377', 'yes'); 
INSERT INTO `wp_options` VALUES (523, '_site_transient_browser_b69641d2d7bcc44f549ced1604c4d328', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Chrome";s:7:"version";s:13:"36.0.1985.125";s:10:"update_url";s:28:"http://www.google.com/chrome";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/chrome.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/chrome.png";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3736, '_site_transient_browser_8f08344a06a0174f5157cb8b14bb5d61', 'a:9:{s:8:"platform";s:6:"iPhone";s:4:"name";s:6:"iPhone";s:7:"version";s:3:"8.0";s:10:"update_url";s:0:"";s:7:"img_src";s:0:"";s:11:"img_src_ssl";s:0:"";s:15:"current_version";s:0:"";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (2735, '_site_transient_timeout_browser_3033ae672f5030d60b69f754349863be', '1422637203', 'yes'); 
INSERT INTO `wp_options` VALUES (6976, '_transient_is_multi_author', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (890, 'comment_control_options', 'a:6:{s:17:"allow_comments_on";a:0:{}s:14:"allow_pings_on";a:0:{}s:5:"no_tb";b:0;s:19:"attachments_inherit";b:0;s:21:"attachments_nocomment";b:0;s:10:"db_version";i:3;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3810, 'icl_sitepress_version', '3.1.9.3', 'yes'); 
INSERT INTO `wp_options` VALUES (909, 'icl_sitepress_settings', 'a:70:{s:19:"hide_upgrade_notice";s:5:"3.0.1";s:21:"interview_translators";i:1;s:34:"existing_content_language_verified";i:1;s:25:"language_negotiation_type";i:1;s:23:"theme_localization_type";i:2;s:14:"icl_lso_header";i:0;s:18:"icl_lso_link_empty";i:0;s:13:"icl_lso_flags";i:1;s:19:"icl_lso_native_lang";i:0;s:20:"icl_lso_display_lang";i:0;s:18:"sync_page_ordering";i:1;s:16:"sync_page_parent";i:1;s:18:"sync_page_template";i:1;s:16:"sync_ping_status";i:1;s:19:"sync_comment_status";i:1;s:16:"sync_sticky_flag";i:1;s:17:"sync_private_flag";i:1;s:16:"sync_post_format";i:1;s:11:"sync_delete";i:0;s:15:"sync_delete_tax";i:0;s:20:"sync_post_taxonomies";i:1;s:14:"sync_post_date";i:0;s:21:"sync_taxonomy_parents";i:0;s:25:"translation_pickup_method";i:0;s:15:"notify_complete";i:1;s:26:"translated_document_status";i:1;s:17:"remote_management";i:0;s:15:"auto_adjust_ids";i:1;s:11:"alert_delay";i:0;s:12:"promote_wpml";i:0;s:23:"troubleshooting_options";a:1:{s:18:"http_communication";i:1;}s:18:"automatic_redirect";i:0;s:17:"remember_language";i:24;s:17:"icl_lang_sel_type";s:8:"dropdown";s:18:"icl_lang_sel_stype";s:7:"classic";s:24:"icl_lang_sel_orientation";s:8:"vertical";s:28:"icl_lang_sel_copy_parameters";s:0:"";s:21:"icl_widget_title_show";i:0;s:28:"translated_document_page_url";s:13:"auto-generate";s:28:"sync_comments_on_duplicates ";i:0;s:3:"seo";a:2:{s:10:"head_langs";i:1;s:27:"canonicalization_duplicates";i:1;}s:22:"posts_slug_translation";a:1:{s:2:"on";i:0;}s:15:"languages_order";a:2:{i:0;s:2:"fr";i:1;s:2:"en";}s:4:"urls";a:5:{s:30:"directory_for_default_language";i:0;s:12:"show_on_root";s:0:"";s:19:"root_html_file_path";s:0:"";s:9:"root_page";i:0;s:23:"hide_language_switchers";i:1;}s:22:"admin_default_language";s:2:"fr";s:18:"ajx_health_checked";b:1;s:17:"setup_wizard_step";i:3;s:18:"default_categories";a:2:{s:2:"fr";s:1:"1";s:2:"en";i:12;}s:16:"default_language";s:2:"fr";s:27:"dont_show_help_admin_notice";b:1;s:19:"icl_lang_sel_config";a:9:{s:19:"font-current-normal";s:7:"#444444";s:18:"font-current-hover";s:7:"#000000";s:25:"background-current-normal";s:7:"#ffffff";s:24:"background-current-hover";s:7:"#eeeeee";s:17:"font-other-normal";s:7:"#444444";s:16:"font-other-hover";s:7:"#000000";s:23:"background-other-normal";s:7:"#ffffff";s:22:"background-other-hover";s:7:"#eeeeee";s:6:"border";s:7:"#cdcdcd";}s:26:"icl_lang_sel_footer_config";a:10:{s:19:"font-current-normal";s:7:"#444444";s:18:"font-current-hover";s:7:"#000000";s:25:"background-current-normal";s:7:"#ffffff";s:24:"background-current-hover";s:7:"#eeeeee";s:17:"font-other-normal";s:7:"#444444";s:16:"font-other-hover";s:7:"#000000";s:23:"background-other-normal";s:7:"#ffffff";s:22:"background-other-hover";s:7:"#eeeeee";s:6:"border";s:7:"#cdcdcd";s:10:"background";s:7:"#ffffff";}s:29:"icl_language_switcher_sidebar";s:1:"0";s:19:"icl_lang_sel_footer";i:0;s:21:"icl_post_availability";i:0;s:30:"icl_post_availability_position";s:5:"below";s:26:"icl_post_availability_text";s:44:"Ce message est également disponible en : %s";s:29:"language_selector_initialized";i:1;s:22:"translation-management";a:7:{s:12:"notification";a:5:{s:7:"new-job";i:1;s:9:"completed";i:1;s:8:"resigned";i:1;s:9:"dashboard";b:1;s:9:"purge-old";i:7;}s:25:"custom_fields_translation";a:23:{s:11:"image_texte";i:0;s:19:"image_texte_0_texte";i:0;s:19:"image_texte_1_texte";i:0;s:12:"_image_texte";i:0;s:20:"_image_texte_0_texte";i:0;s:20:"_image_texte_1_texte";i:0;s:19:"image_texte_0_image";i:0;s:20:"_image_texte_0_image";i:0;s:19:"image_texte_1_image";i:0;s:20:"_image_texte_1_image";i:0;s:11:"footer-text";i:0;s:12:"_footer-text";i:0;s:21:"image_texte_0_image_v";i:0;s:22:"_image_texte_0_image_v";i:0;s:21:"image_texte_1_image_v";i:0;s:22:"_image_texte_1_image_v";i:0;s:37:"image_texte_0_image_iphone_horizontal";i:0;s:38:"_image_texte_0_image_iphone_horizontal";i:0;s:37:"image_texte_1_image_iphone_horizontal";i:0;s:38:"_image_texte_1_image_iphone_horizontal";i:0;s:5:"title";i:2;s:11:"description";i:2;s:8:"keywords";i:2;}s:22:"doc_translation_method";i:0;s:35:"__custom_types_readonly_config_prev";a:0:{}s:28:"custom_types_readonly_config";a:0:{}s:36:"__custom_fields_readonly_config_prev";a:0:{}s:29:"custom_fields_readonly_config";a:3:{i:0;s:5:"title";i:1;s:11:"description";i:2;s:8:"keywords";}}s:14:"setup_complete";i:1;s:18:"icl_additional_css";s:28:"                            ";s:18:"display_ls_in_menu";i:0;s:11:"menu_for_ls";i:0;s:22:"show_translations_flag";i:1;s:27:"sync_comments_on_duplicates";i:0;s:16:"just_reactivated";i:0;s:25:"icl_capabilities_verified";b:1;s:22:"taxonomy_names_checked";b:1;s:2:"st";a:4:{s:2:"sw";a:0:{}s:16:"strings_per_page";i:10;s:15:"icl_st_auto_reg";s:7:"disable";s:16:"strings_language";s:2:"en";}s:38:"hide_professional_translation_controls";s:1:"1";}', 'yes'); 
INSERT INTO `wp_options` VALUES (910, '_icl_cache', 'a:3:{s:25:"language_name_cache_class";a:18:{s:14:"in_language_fr";a:2:{i:0;a:8:{s:2:"id";s:1:"1";s:4:"code";s:2:"en";s:12:"english_name";s:7:"English";s:6:"active";s:1:"1";s:12:"display_name";s:7:"Anglais";s:10:"encode_url";s:1:"0";s:14:"default_locale";s:5:"en_US";s:3:"tag";s:5:"en-US";}i:1;a:8:{s:2:"id";s:1:"4";s:4:"code";s:2:"fr";s:12:"english_name";s:6:"French";s:6:"active";s:1:"1";s:12:"display_name";s:9:"Français";s:10:"encode_url";s:1:"0";s:14:"default_locale";s:5:"fr_FR";s:3:"tag";s:5:"fr-FR";}}s:9:"languages";a:2:{i:0;O:8:"stdClass":2:{s:13:"language_code";s:2:"en";s:4:"name";s:7:"English";}i:1;O:8:"stdClass":2:{s:13:"language_code";s:2:"fr";s:4:"name";s:9:"Français";}}s:21:"language_details_frfr";a:5:{s:4:"code";s:2:"fr";s:12:"english_name";s:6:"French";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:9:"Français";}s:4:"frfr";s:9:"Français";s:4:"enen";s:7:"English";s:4:"enfr";s:7:"Anglais";s:21:"language_details_enfr";a:5:{s:4:"code";s:2:"en";s:12:"english_name";s:7:"English";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:7:"Anglais";}s:21:"language_details_enen";a:5:{s:4:"code";s:2:"en";s:12:"english_name";s:7:"English";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:7:"English";}s:4:"fren";s:6:"French";s:19:"language_details_fr";N;s:22:"language_details_allfr";N;s:21:"language_details_fren";a:5:{s:4:"code";s:2:"fr";s:12:"english_name";s:6:"French";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:6:"French";}s:22:"language_details_frall";N;s:20:"language_details_all";N;s:22:"language_details_enall";N;s:17:"language_details_";N;s:2:"en";N;s:2:"fr";N;}s:17:"flags_cache_class";a:3:{s:2:"fr";O:8:"stdClass":2:{s:4:"flag";s:6:"fr.png";s:13:"from_template";s:1:"0";}s:2:"en";O:8:"stdClass":2:{s:4:"flag";s:6:"en.png";s:13:"from_template";s:1:"0";}s:0:"";N;}s:18:"pages_per_language";a:3:{s:3:"all";i:14;s:2:"en";s:1:"7";s:2:"fr";s:1:"7";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (1462, '_site_transient_timeout_browser_ce2653c6267d76d83d16bd34ac054f6f', '1417444677', 'yes'); 
INSERT INTO `wp_options` VALUES (1463, '_site_transient_browser_ce2653c6267d76d83d16bd34ac054f6f', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"33.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3812, 'wp_installer_settings', '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', 'yes'); 
INSERT INTO `wp_options` VALUES (3616, '_transient_feed_mod_90703ac594673efe43c980672b645276', '1426033739', 'no'); 
INSERT INTO `wp_options` VALUES (3615, '_transient_timeout_feed_mod_90703ac594673efe43c980672b645276', '1426076939', 'no'); 
INSERT INTO `wp_options` VALUES (3482, '_site_transient_timeout_browser_61df25869d74d4482336b1f94b279e7d', '1425947359', 'yes'); 
INSERT INTO `wp_options` VALUES (3483, '_site_transient_browser_61df25869d74d4482336b1f94b279e7d', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:3:"7.1";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3452, 'icl_admin_messages', 'a:2:{s:8:"messages";a:1:{s:28:"_st_default_language_warning";a:7:{s:4:"text";s:251:"Because your default language is not English, you need to enter all strings in English and translate them to  and Français. <strong><a href="https://wpml.org/faq/string-translation-default-language-not-english/" target="_blank">Read more</a></strong>";s:4:"type";s:29:"icl-admin-message-information";s:4:"hide";b:1;s:13:"text_fallback";s:161:"<a href="https://wpml.org/faq/string-translation-default-language-not-english/" target="_blank">How to translate strings when default language is not English</a>";s:13:"type_fallback";b:0;s:5:"group";s:18:"string-translation";s:12:"admin_notice";b:0;}}s:16:"instant_messages";a:0:{}}', 'yes'); 
INSERT INTO `wp_options` VALUES (5581, '_site_transient_timeout_browser_4538d203b981f4a9c6dd1fdefe1710c8', '1431962648', 'yes'); 
INSERT INTO `wp_options` VALUES (5582, '_site_transient_browser_4538d203b981f4a9c6dd1fdefe1710c8', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"37.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (134, 'cpto_options', 'a:3:{s:8:"autosort";s:1:"1";s:9:"adminsort";s:1:"1";s:10:"capability";s:13:"publish_pages";}', 'yes'); 
INSERT INTO `wp_options` VALUES (135, 'CPT_configured', 'TRUE', 'yes'); 
INSERT INTO `wp_options` VALUES (1663, '_site_transient_timeout_popular_importers_fr_FR', '1417690518', 'yes'); 
INSERT INTO `wp_options` VALUES (1664, '_site_transient_popular_importers_fr_FR', 'a:2:{s:9:"importers";a:8:{s:7:"blogger";a:4:{s:4:"name";s:7:"Blogger";s:11:"description";s:86:"Install the Blogger importer to import posts, comments, and users from a Blogger blog.";s:11:"plugin-slug";s:16:"blogger-importer";s:11:"importer-id";s:7:"blogger";}s:9:"wpcat2tag";a:4:{s:4:"name";s:29:"Categories and Tags Converter";s:11:"description";s:109:"Install the category/tag converter to convert existing categories to tags or tags to categories, selectively.";s:11:"plugin-slug";s:18:"wpcat2tag-importer";s:11:"importer-id";s:9:"wpcat2tag";}s:11:"livejournal";a:4:{s:4:"name";s:11:"LiveJournal";s:11:"description";s:82:"Install the LiveJournal importer to import posts from LiveJournal using their API.";s:11:"plugin-slug";s:20:"livejournal-importer";s:11:"importer-id";s:11:"livejournal";}s:11:"movabletype";a:4:{s:4:"name";s:24:"Movable Type and TypePad";s:11:"description";s:99:"Install the Movable Type importer to import posts and comments from a Movable Type or TypePad blog.";s:11:"plugin-slug";s:20:"movabletype-importer";s:11:"importer-id";s:2:"mt";}s:4:"opml";a:4:{s:4:"name";s:8:"Blogroll";s:11:"description";s:61:"Install the blogroll importer to import links in OPML format.";s:11:"plugin-slug";s:13:"opml-importer";s:11:"importer-id";s:4:"opml";}s:3:"rss";a:4:{s:4:"name";s:3:"RSS";s:11:"description";s:58:"Install the RSS importer to import posts from an RSS feed.";s:11:"plugin-slug";s:12:"rss-importer";s:11:"importer-id";s:3:"rss";}s:6:"tumblr";a:4:{s:4:"name";s:6:"Tumblr";s:11:"description";s:84:"Install the Tumblr importer to import posts &amp; media from Tumblr using their API.";s:11:"plugin-slug";s:15:"tumblr-importer";s:11:"importer-id";s:6:"tumblr";}s:9:"wordpress";a:4:{s:4:"name";s:9:"WordPress";s:11:"description";s:130:"Install the WordPress importer to import posts, pages, comments, custom fields, categories, and tags from a WordPress export file.";s:11:"plugin-slug";s:18:"wordpress-importer";s:11:"importer-id";s:9:"wordpress";}}s:10:"translated";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (145, 'bb_taps_addstyledrop', 'a:2:{i:0;a:7:{s:5:"title";s:10:"color gold";s:6:"inline";s:4:"span";s:7:"classes";s:4:"gold";s:6:"styles";a:1:{s:5:"color";s:8:" #BBA37D";}s:10:"attributes";a:0:{}s:5:"exact";b:0;s:7:"wrapper";b:0;}i:1;a:7:{s:5:"title";s:11:"title about";s:6:"inline";s:4:"span";s:7:"classes";s:11:"title_about";s:6:"styles";a:1:{s:9:"font-size";s:4:"21px";}s:10:"attributes";a:0:{}s:5:"exact";b:0;s:7:"wrapper";b:0;}}', 'yes'); 
INSERT INTO `wp_options` VALUES (148, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:2:{i:0;i:6;i:1;s:2:"11";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (816, '_site_transient_timeout_browser_cfe179b136503c5ffb50573558551e0b', '1409872492', 'yes'); 
INSERT INTO `wp_options` VALUES (817, '_site_transient_browser_cfe179b136503c5ffb50573558551e0b', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:5:"7.0.3";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (442, 'wp_db_backup_excs', 'a:2:{s:9:"revisions";a:1:{i:0;s:8:"wp_posts";}s:4:"spam";a:1:{i:0;s:11:"wp_comments";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (2736, '_site_transient_browser_3033ae672f5030d60b69f754349863be', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"35.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (1867, '_site_transient_timeout_browser_2dd04bb9d87bfa180059c21b3ca7cd2f', '1419873102', 'yes'); 
INSERT INTO `wp_options` VALUES (3613, '_transient_timeout_feed_90703ac594673efe43c980672b645276', '1426076939', 'no'); 
INSERT INTO `wp_options` VALUES (3614, '_transient_feed_90703ac594673efe43c980672b645276', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:49:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:4:"WPML";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:16:"http://wpml.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:52:"The Plugin for Building Multilingual WordPress Sites";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 11 Mar 2015 00:22:42 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:29:"http://wordpress.org/?v=4.1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"This week compatible – Dynamic website builder, UniTheme, Eventory, Maya";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/r5cGunVDIGs/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://wpml.org/2015/03/this-week-compatible-dynamic-website-builder-unitheme-eventory-maya/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 06 Mar 2015 15:13:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=572533";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:349:"Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are Dynamik website builder, UniTheme, Eventory, Maya If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready Themes Multilingual Ready Plugins Also, if you&#8217;re [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4923:"<p>Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are <a title="Dynamik website builder" href="http://cobaltapps.com/downloads/dynamik-website-builder/">Dynamik website builder</a>, <a title="UniTheme" href="http://themeforest.net/item/unitheme-responsive-multipurpose-theme/9518921">UniTheme</a>, <a title="Eventory" href="http://themeforest.net/item/eventory-events-responsive-wordpress-theme/6843168">Eventory</a>, <a title="Maya" href="http://themeforest.net/item/maya-smart-powerful-wp-theme/9660706">Maya</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Dynamik website builder theme</h2>\n<p style="text-align: center"><a href="http://cobaltapps.com/downloads/dynamik-website-builder/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/dynamik.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Dynamik is a Genesis Child Theme that includes hundreds of no-coding design options </p></blockquote>\n<p><a class="button download-button vt-p" href="http://cobaltapps.com/downloads/dynamik-website-builder/" target="_blank">Purchase Dynamik website builder theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">UniTheme theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/unitheme-responsive-multipurpose-theme/9518921"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/unitheme.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>UniTheme &#8211; Responsive Multi-Purpose Mega Theme</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/unitheme-responsive-multipurpose-theme/9518921">Purchase The UniTheme theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Eventory Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/eventory-events-responsive-wordpress-theme/6843168"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/eventory.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Eventory Events is WordPress theme suitable for events calendar or image gallery.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/eventory-events-responsive-wordpress-theme/6843168">Purchase Eventory theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Maya Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/maya-smart-powerful-wp-theme/9660706"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/maya.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Maya is a composable and clean wordpress template. You can create amazing homes and impressive internal pages.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/maya-smart-powerful-wp-theme/9660706">Purchase Maya theme</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=r5cGunVDIGs:m4GN5dzen9U:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=r5cGunVDIGs:m4GN5dzen9U:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=r5cGunVDIGs:m4GN5dzen9U:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=r5cGunVDIGs:m4GN5dzen9U:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=r5cGunVDIGs:m4GN5dzen9U:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=r5cGunVDIGs:m4GN5dzen9U:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/r5cGunVDIGs" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://wpml.org/2015/03/this-week-compatible-dynamic-website-builder-unitheme-eventory-maya/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://wpml.org/2015/03/this-week-compatible-dynamic-website-builder-unitheme-eventory-maya/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:71:"This Week Compatible – Bizway, The Thinker, Howes, Rich Text Excerpts";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/7f0GpHnnf-8/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:98:"http://wpml.org/2015/02/this-week-compatible-bizway-the-thinker-howes-rich-text-excerpts/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 27 Feb 2015 17:44:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=568263";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:315:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Bizway, The Thinker, Howes, and the plugin is Rich Text Excerpts If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5657:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Bizway" href="http://www.inkthemes.com/wp-themes/simple-wordpress-theme/">Bizway</a>, <a title="The Thinker" href="http://themeforest.net/item/the-thinker-simple-blogging-wordpress-theme/9712408">The Thinker</a>, <a title="Howes" href="http://themeforest.net/item/howes-responsive-multipurpose-wordpress-theme/9616552">Howes</a>, and the plugin is <a title="Rich Text Excerpts" href="https://wordpress.org/plugins/rich-text-excerpts/">Rich Text Excerpts</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Bizway theme</h2>\n<p style="text-align: center"><a href="http://www.inkthemes.com/wp-themes/simple-wordpress-theme"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/bizway.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>BizWay Pro for WordPress is one of the easiest themes to build your Web Presence in 10 Minutes. Just with in 5 Simple Steps. The Theme is highly customizable and with the presence of several background patterns and Theme Options, You can have your own branded new Website for your Business or Personal Use in Minutes. Features Templates for Blogs, Gallery, Fullwidth Page without sidebar and Contact Us Page.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.inkthemes.com/wp-themes/simple-wordpress-theme" target="_blank">Purchase Bizway theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">The Thinker theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/the-thinker-simple-blogging-wordpress-theme/9712408"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/thinker.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Perfectly simple blogging theme. It has just enough detail without being flashy and just enough features not to get complicated. Beautiful typography and clean layout are a must for any modern blogger and this is where “The Thinker” excels. It keeps readers focused on the content while creating relaxing environment for the eyes.<br />\nThis theme comes with a couple of custom page templates (including shop), color customization options and a top notch slider that will help to further customize the theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/the-thinker-simple-blogging-wordpress-theme/9712408">Purchase The Thinker theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Howes Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/howes-responsive-multipurpose-wordpress-theme/9616552"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/howes.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquoteHowes is multi-purpose responsive theme for WordPress and eCommerce</blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/howes-responsive-multipurpose-wordpress-theme/9616552">Purchase Howes theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Rich Text Excerpts</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/rich-text-excerpts/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/rich.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A WordPress plugin which enables Rich Text editing in excerpts for any post type which supports them.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/rich-text-excerpts/">Download Rich Text Excerpts</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=7f0GpHnnf-8:U_1xw8dbXr8:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=7f0GpHnnf-8:U_1xw8dbXr8:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=7f0GpHnnf-8:U_1xw8dbXr8:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=7f0GpHnnf-8:U_1xw8dbXr8:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=7f0GpHnnf-8:U_1xw8dbXr8:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=7f0GpHnnf-8:U_1xw8dbXr8:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/7f0GpHnnf-8" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:94:"http://wpml.org/2015/02/this-week-compatible-bizway-the-thinker-howes-rich-text-excerpts/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:89:"http://wpml.org/2015/02/this-week-compatible-bizway-the-thinker-howes-rich-text-excerpts/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"WPML 3.2 First Beta";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/WfRRJvoCcEQ/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpml.org/2015/02/wpml-3-2-first-beta/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Feb 2015 17:43:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"WPML versions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=565151";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:331:"We are ready with a first public beta of WPML 3.2. This release is the result of months of development and brings many new capabilities to WPML. Translation Basket The Translation Basket allows you to choose content to translation a lot more easily than before. It&#8217;s very similar to a shopping cart in an e-commerce [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:9491:"<p><strong>We are ready with a first public beta of WPML 3.2. This release is the result of months of development and brings many new capabilities to WPML.</strong></p>\n<h2>Translation Basket</h2>\n<p><div id="attachment_565163" style="width: 310px" class="wp-caption alignright"><a href="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/translation-basket.png"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/translation-basket-300x221.png" alt="Translation Basket" width="300" height="221" class="size-medium wp-image-565163" /></a><p class="wp-caption-text">Translation Basket</p></div>The Translation Basket allows you to choose content to translation a lot more easily than before. It&#8217;s very similar to a shopping cart in an e-commerce site. You can add any kind of content (including strings) to the basket. When you&#8217;re ready, send it at once to your translators.</p>\n<p>Let&#8217;s say you&#8217;re adding a showcase to your site and you want to translate it.</p>\n<p>You will start with the Translation Dashboard and select the new page, where the showcase displays. Add it to the basket.</p>\n<p>Now, change the filter and choose &#8216;showcase entry&#8217; type. Add the showcase entries you want to translate to the basket.</p>\n<p>Finally, go to the String Translation screen and locate the stings that appear in the theme for the showcase (like &#8216;visit site&#8217;, &#8216;Link&#8217;, etc.). Select all those and add to the basket.</p>\n<p>So far, nothing was actually sent to translation. Go to the Translation Basket, review everything you&#8217;ve added and send to translation in one batch. You can give the batch a name, so that you remember what it was about.</p>\n<p>Your translator will love you for collecting all relevant information and sending it together. It&#8217;s also so much easier for you to keep track of translations, when they are grouped by subject.</p>\n<p>Sending to translation became a lot better with the Translation Basket. You may never notice it, but WPML now sends the basket content in chunks, with AJAX updates. This means that you can put unlimited amounts of content into the basket and send it as one big package. You don&#8217;t need to worry about servers timing out. WPML sends it in small chunks, but your translator still gets it as one package.</p>\n<h2>Translation Services</h2>\n<p>Yes, we love our own translation service, <a href="http://www.icanlocalize.com/site/">ICanLocalize</a>, but you can choose. WPML 3.2 will allow you to select between different professional service providers. Right now, we are working with several leading translation services, integrating them with WPML.</p>\n<p>We are now (finally) ready to work with any translation service that has an API. This breakthrough is a result of our new Translation Proxy.</p>\n<p><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/wpml-tp-ts.png" alt="wpml-tp-ts" width="559" height="174" class="alignnone size-full wp-image-565174" /></p>\n<p>The Translation Proxy is our new server, which bridges between the protocols of different translation service providers and WordPress sites. It allows WPML to communicate with different translation services, without knowing their protocol.</p>\n<p>WPML sends content to the Translation Proxy. The Translation Proxy queues it and sends to the translation service, using their native API. So now, to support a new translation service, we don&#8217;t need to update WPML in every website in the world. We add the support to our Translation Proxy and everyone has access to a new translation service.</p>\n<p>Our first translation partners are the team from <a href="http://www.cloudwords.com/">Cloudwords</a>. We&#8217;ve been quietly working with Cloudwords in the past months integrating WPML and our Translation Proxy with Cloudwords API. As soon as WPML 3.2 is released in production, you will be able to receive translation work from Cloudwords.</p>\n<h2>Packages Translation</h2>\n<p>Some plugins and themes use their own tables and complex data structures to hold data. We&#8217;ve seen this with visual editors, event managers and niche-market themes.</p>\n<p>Now, WPML can handle these data structures with ease.</p>\n<p><div id="attachment_565181" style="width: 274px" class="wp-caption alignright"><a href="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/layout-example.png"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/layout-example-264x300.png" alt="A Layout, which you can translate with WPML 3.2" width="264" height="300" class="size-medium wp-image-565181" /></a><p class="wp-caption-text">A Layout, which you can translate with WPML 3.2</p></div>The &#8216;Translation Packages&#8217; support in WPML allows plugins and themes to (easily) declare their data structures and make them known to WPML.</p>\n<p>Using the new <a href="http://wpml.org/documentation/support/string-package-translation/">Translation Packages</a> is almost too easy. You just call one hook (wpml_register_string) when saving your data. This single hook tells WPML that there is a piece of information that belongs to an object. Call it as many times as you need to add fields.</p>\n<p>WPML collects all this information and constructs translatable objects. Then, it allows users to translate them using the Translation Dashboard, just like any other WordPress content.</p>\n<p>When you render, pass your data through the WPML_translate_string filter. If the object is translated, you will receive the correct string in the right language.</p>\n<p>Adding WPML support to our <a href="http://wp-types.com/home/layouts/">Layouts</a> plugin took just a few lines of PHP. We created the entire Layouts plugin without much thought over language and made it multilingual-ready in a couple of hours.</p>\n<h2>Compatibility with W3TC Object Caching</h2>\n<p>WPML 3.2 helps you run sites (a lot) faster by supporting object caching by W3TC. Object caching means that complex items don&#8217;t need to be re-computed on every page render (or often, several times inside the page render).</p>\n<p>The Object Cache engine checks if an &#8216;object&#8217; was recently computed. If so, no need to compute it again. This can greatly speed up dynamic sites, where entire pages cannot be cached.</p>\n<p>In the past, object caching would not work with WPML, because objects got mixed between languages. WPML 3.2 fixes this problem by filtering the object keys and adding languages to them.</p>\n<p>But this is just part of the improvement in WPML 3.2. We&#8217;ve also refactored the String Translation code, making it much more optimized to work with object caching.</p>\n<p>If your site has just a few stings, you&#8217;re not going to notice a great improvement. If you are running a site with loads of strings (typical to WooCommerce sites), you should feel a considerable improvement in speed &#8211; especially if you use W3TC with Object Caching.</p>\n<h2>XLIFF and Translation Analytics Merged In</h2>\n<p>WPML 3.2 includes both the XLIFF module and Translation Analytics, inside the Translation Management module. We&#8217;ve unified all three because while opening WPML to different translation services, we moved to using XLIFF files for all. So, there&#8217;s no more need for a separate XLIFF module for WPML. XLIFF rules!</p>\n<h2>Known Issues</h2>\n<p>New versions of Gravity Forms appear to be acting up with WPML. This isn&#8217;t entirely related to WPML 3.2, but we&#8217;re looking into this.</p>\n<p>Also, WPML 3.2 deprecates a call that our <a href="http://wp-types.com/home/cred/">CRED</a> plugin uses. We&#8217;ll be releasing an update to CRED to be completely compatible with WPML 3.2.</p>\n<p>This version of WPML is not intended for production sites (yet). It doesn&#8217;t support ANY professional translation, including from ICanLocalize.</p>\n<h2>Download and Give Us Feedback</h2>\n<p>You can get WPML 3.2 Beta from your <a href="https://wpml.org/account/">WPML account</a>. Log in, click on Downloads and get the recent beta. This ZIP includes ZIP files of all of WPML&#8217;s components. Unzip it locally and upload the components that you are using.</p>\n<p>If you have XLIFF or Translation Analytics installed, deactivate them to avoid conflicts. Otherwise, update all WPML components that you are using (don&#8217;t use a mix of &#8216;production&#8217; and &#8216;beta&#8217; components).</p>\n<p>Overall, WPML 3.2 beta is pretty close to our final version. We&#8217;d love it if you could take it for a spin and try it on your development sites.</p>\n<p><strong>We are looking to release WPML 3.2 in the next couple of weeks. We would love to hear your feedback. Leave your comments and we&#8217;ll get back to you.</strong></p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=WfRRJvoCcEQ:MXiI42aOkgs:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=WfRRJvoCcEQ:MXiI42aOkgs:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=WfRRJvoCcEQ:MXiI42aOkgs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=WfRRJvoCcEQ:MXiI42aOkgs:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=WfRRJvoCcEQ:MXiI42aOkgs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=WfRRJvoCcEQ:MXiI42aOkgs:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/WfRRJvoCcEQ" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:49:"http://wpml.org/2015/02/wpml-3-2-first-beta/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:44:"http://wpml.org/2015/02/wpml-3-2-first-beta/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"This Week Compatible – Regency, World Wide, Seven, SmartMag";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/f87g3O5Ualc/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:88:"http://wpml.org/2015/02/this-week-compatible-regency-world-wide-seven-smartmag/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 20 Feb 2015 16:23:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=564099";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:338:"Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are Regency, World Wide, Seven, SmartMag If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready Themes Multilingual Ready Plugins Also, if you&#8217;re a [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5249:"<p>Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are <a title="Regency" href="http://themeforest.net/item/regency-a-beautiful-modern-ecommerce-theme/9222795">Regency</a>, <a title="World Wide" href="http://themeforest.net/item/world-wide-responsive-magazine-wp-theme/4940421">World Wide</a>, <a title="Seven" href="http://themeforest.net/item/seven-stylish-wordpress-theme/9409248">Seven</a>, <a title="SmartMag" href="http://themeforest.net/item/smartmag-responsive-retina-wordpress-magazine/6652608">SmartMag</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Regency theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/regency-a-beautiful-modern-ecommerce-theme/9222795"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/regency.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Regency is Fully Responsive WooCommerce theme, which also supports portfolio</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/regency-a-beautiful-modern-ecommerce-theme/9222795 target="_blank">Purchase Regency theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">World Wide theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/world-wide-responsive-magazine-wp-theme/4940421"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/worldwide.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>World Wide is a premium magazine wordpress theme. With this theme, we include 7 blog styles + 5 styles of sidebar layout. Now you can have many possibilities for your site. Also, You can change many setting such as element’s color, Backgroumd pattern, font family etc… easily via our awesome admin panel.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/world-wide-responsive-magazine-wp-theme/4940421">Purchase World Wide theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Seven Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/seven-stylish-wordpress-theme/9409248"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/seven.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A multipurpose theme with clean design, using custom posts for portfolio items and has a built in slider.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/seven-stylish-wordpress-theme/9409248">Purchase Seven theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">SmartMag Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/smartmag-responsive-retina-wordpress-magazine/6652608"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/smartmag.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>SmartMag is a modern, clean, responsive and retina-ready (HD) WordPress theme suitable for magazines, newspapers, review sites, or blogs.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/smartmag-responsive-retina-wordpress-magazine/6652608">Purchase SmartMag theme</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=f87g3O5Ualc:pfhtj5Akfb4:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=f87g3O5Ualc:pfhtj5Akfb4:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=f87g3O5Ualc:pfhtj5Akfb4:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=f87g3O5Ualc:pfhtj5Akfb4:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=f87g3O5Ualc:pfhtj5Akfb4:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=f87g3O5Ualc:pfhtj5Akfb4:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/f87g3O5Ualc" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:84:"http://wpml.org/2015/02/this-week-compatible-regency-world-wide-seven-smartmag/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:79:"http://wpml.org/2015/02/this-week-compatible-regency-world-wide-seven-smartmag/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"This Week Compatible – Oslo, Falco, Mindig, Osmosis, Beliy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/DJmdnsa1rlo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:87:"http://wpml.org/2015/02/this-week-compatible-oslo-falco-minding-osmosis-beliy/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 13 Feb 2015 17:31:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=560553";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:337:"Today we are happy to announce that we have 5 themes to add to our compatibility list. The themes are Oslo, Falco, Mindig, Osmosis, Beliy If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready Themes Multilingual Ready Plugins Also, if you&#8217;re a [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6123:"<p>Today we are happy to announce that we have 5 themes to add to our compatibility list. The themes are <a title="Oslo" href="https://www.pixelunion.net/themes/ghost/oslo-lite/">Oslo</a>, <a title="Falco" href="http://themeforest.net/item/falco-responsive-multipurpose-wordpress-theme/5926997">Falco</a>, <a title="Mindig" href="http://themeforest.net/item/mindig-a-flat-multipurpose-ecommerce-theme/8922501">Mindig</a>, <a title="Osmosis" href="http://themeforest.net/item/osmosis-responsive-multipurpose-theme/9839949">Osmosis</a>, <a title="Beliy" href="http://themeforest.net/item/beliy-minimal-modern-multipurpose-blog-theme/9560519">Beliy</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Oslo theme</h2>\n<p style="text-align: center"><a href="https://www.pixelunion.net/themes/ghost/oslo-lite/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/oslo.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Oslo is a stunning blend of refinement and organization. It’s a mature two-column theme fit for portfolio and general blog use, built around a supremely customizable sidebar and beautiful typography.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://www.pixelunion.net/themes/ghost/oslo-lite/" target="_blank">Purchase Oslo theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Falco theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/falco-responsive-multipurpose-wordpress-theme/5926997"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/falco.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Falco theme is perfect choice for everyone. It does not matter if you are coder from website agency or just person who have own business and want to create website for own customers or yourself. With our solutions you can do everything without any php/css/html knowledge.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/falco-responsive-multipurpose-wordpress-theme/5926997" target="_blank">Purchase Falco theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Mindig Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/mindig-a-flat-multipurpose-ecommerce-theme/8922501"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/minding.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>a Flat &#038; Multipurpose Ecommerce Theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/mindig-a-flat-multipurpose-ecommerce-theme/8922501">Purchase Mindig theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Osmosis Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/osmosis-responsive-multipurpose-theme/9839949"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/osmosis.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Osmosis is an unparalleled and effortless multi-functional WordPress Theme. It offers stand-out-from-the-pack options and superior aesthetics; become the designer you have always dreamt of and impress the world simply and smartly.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/osmosis-responsive-multipurpose-theme/9839949">Purchase Osmosis theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Beliy Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/beliy-minimal-modern-multipurpose-blog-theme/9560519"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/beliy.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Beliy is a HTML5/CSS3/Bootstrap optimized Parallax powered, responsive theme perfect for multi-purpose blog themes. WPML also supported by default.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/beliy-minimal-modern-multipurpose-blog-theme/9560519">Purchase Beliy theme</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=DJmdnsa1rlo:6bQKARmTgSY:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=DJmdnsa1rlo:6bQKARmTgSY:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DJmdnsa1rlo:6bQKARmTgSY:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=DJmdnsa1rlo:6bQKARmTgSY:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DJmdnsa1rlo:6bQKARmTgSY:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=DJmdnsa1rlo:6bQKARmTgSY:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/DJmdnsa1rlo" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:83:"http://wpml.org/2015/02/this-week-compatible-oslo-falco-minding-osmosis-beliy/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:78:"http://wpml.org/2015/02/this-week-compatible-oslo-falco-minding-osmosis-beliy/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:73:"This Week Compatible – Mr. tailor, Multinews, Explorer, WP Sitemap Page";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/DdP1TeSdH8A/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:99:"http://wpml.org/2015/02/this-week-compatible-mr-tailor-multinews-explorer-wp-sitemap-page/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 06 Feb 2015 18:58:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=556241";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:322:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Mr.Tailor, Multinews, Explorer, and the plugin is WP Sitemap Page If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5550:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Mr. Tailor" href="http://themeforest.net/item/mr-tailor-responsive-woocommerce-theme/7292110">Mr.Tailor</a>, <a title="Multinews" href="http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494">Multinews</a>, <a title="Explorer" href="http://www.anarieldesign.com/themes/travel-fashion-food-wordpress-theme/">Explorer</a>, and the plugin is <a title="WP Sitemap Page" href="https://wordpress.org/plugins/wp-sitemap-page/">WP Sitemap Page</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Mr. Tailor theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/mr-tailor-responsive-woocommerce-theme/7292110"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/tailor.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Mr. Tailor is a highly customizable responsive WordPress theme. WordPress consultants are using it as a framework to quickly build powerful websites and online stores for their customers.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/mr-tailor-responsive-woocommerce-theme/7292110" target="_blank">Purchase Mr. Tailor theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Multinews theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/multinews.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Multinews is a News/Magazine wordpress theme. You can use Multinews for Magazine, newspaper and blog. Multinews has many features such as Flipping magazine, Beautiful mega menus, a lot of Layouts options, Ajax Live search, Author Timeline, popular plugins integrated ( Woocommerce, bbPress, Ad Rotate, MailPoet Newsletters, Contact form 7 and much more).</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494" target="_blank">Purchase Multinews theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Explorer Theme</h2>\n<p style="text-align: center"><a href="http://www.anarieldesign.com/themes/travel-fashion-food-wordpress-theme/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/explorer.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Modern theme that can be used as fashion or travel blog, with front page custom widgets, clean layout and easily readable typography.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.anarieldesign.com/themes/travel-fashion-food-wordpress-theme/">Purchase Explorer theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">WP Sitemap Page Plugin</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/wp-sitemap-page/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/sitemap.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>An easy way to add a sitemap on one of your pages becomes reality thanks to this WordPress plugin. Just use the shortcode [wp_sitemap_page] on any of your pages. This will automatically generate a sitemap of all your pages and posts.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/wp-sitemap-page/">Download WP Sitemap Page Plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=DdP1TeSdH8A:b3IllKrZJo8:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=DdP1TeSdH8A:b3IllKrZJo8:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DdP1TeSdH8A:b3IllKrZJo8:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=DdP1TeSdH8A:b3IllKrZJo8:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DdP1TeSdH8A:b3IllKrZJo8:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=DdP1TeSdH8A:b3IllKrZJo8:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/DdP1TeSdH8A" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:95:"http://wpml.org/2015/02/this-week-compatible-mr-tailor-multinews-explorer-wp-sitemap-page/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:90:"http://wpml.org/2015/02/this-week-compatible-mr-tailor-multinews-explorer-wp-sitemap-page/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"WooCommerce Multilingual 3.5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/BShZCm78WrQ/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:62:"http://wpml.org/2015/02/woocommerce-multilingual-3-5/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 04 Feb 2015 16:39:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"WPML versions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=551400";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:355:"This version brings in the long waited support for creating products in secondary languages without first having to exist in the default language but also several other changes and improvements. Added support for creating products in secondary languages only. Up until this version each product had to first be created in the default language in [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Mihai";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6416:"<p><strong>This version brings in the long waited support for creating products in secondary languages without first having to exist in the default language but also several other changes and improvements.</strong></p>\n<h2>Added support for creating products in secondary languages only.</h2>\n<p>Up until this version each product had to first be created in the default language in order for it to also be created in a different language (translated).</p>\n<div id="attachment_551403" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551403" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image02.png" alt="image02" width="500" height="385" /><p class="wp-caption-text">Selecting the language for a new product</p></div>\n<p>Now you can select the language of the product at the moment when it is created or change the language afterwards just like for the regular posts translation in WPML.</p>\n<p>In the example above, you can see how using the native editor it’s possible to set the language for a product to French which is not the default language.</p>\n<p>In the WooCommerce Multilingual products translation page, the interface has been changed to accommodate the fact that the original language of the products can be any language of the active languages of the site.</p>\n<div id="attachment_551406" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551406" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image01.png" alt="image01" width="500" height="332" /><p class="wp-caption-text">Products in different languages on the products translation screen.</p></div>\n<p>Along with the changes for the products, product categories, product tags and any other taxonomies associated with product can be created and exist alone in secondary languages.</p>\n<div id="attachment_551411" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551411" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image03.png" alt="Setting the language for products taxonomies" width="500" height="489" /><p class="wp-caption-text">Setting the language for products taxonomies</p></div>\n<h2>Added enhancements for the Woocommerce Multilingual products table (filter by original language, display language flag).</h2>\n<p>The new language options introduced the need to add some new design elements. At the top of the products translation screen, you can filter products to be listed by a specific language and also chose to only see translations in a specific language (useful when your site has many secondary languages).</p>\n<div id="attachment_551415" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551415" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image04.png" alt="Filtering the products by language and translations." width="500" height="386" /><p class="wp-caption-text">Filtering the products by language and translations.</p></div>\n<h2>Added option to synchronize the products and product taxonomies order.</h2>\n<p>This new option that is ‘on’ by default allows one to set a custom order for the products in the shops in each different language. This especially comes handy for a site with a mix between products in different languages that are not translation of each others and products that have translations.</p>\n<div id="attachment_551416" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551416" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image00.png" alt="The option to synchronize products and product taxonomies display order." width="500" height="238" /><p class="wp-caption-text">The option to synchronize products and product taxonomies display order.</p></div>\n<h2>Some of the bugs fixed:</h2>\n<ul>\n<li>The cart was not updating quantities for variable product (when have more than one variable in the cart).</li>\n<li>The cart total was not updating when using get_cart_total() and get_cart_subtotal() functions in other plugins or themes.</li>\n<li>Wrong price format and order total were displayed on the new order page in the WP admin.</li>\n<li>The featured image and the gallery images were overridden when updating translations.</li>\n<li>Fixed the &#8216;Keep&#8217; option (under multi-currency options) that allows keeping the same currency on the front end, when switching the language.</li>\n<li>Fixed a javascript error that was showing when changing currencies order.</li>\n<li>The decimal number was not working correctly for the default currency.</li>\n<li>Fixed a compatibility problem with WooCommerce Product Tabs.</li>\n<li>A coupon was applied incorrectly to all products in the cart when they were defined for specific product variations.</li>\n<li>WooCommerce note email language was not correct.</li>\n<li>WooCommerce reports were showing duplicate products.</li>\n<li>When using WordPress in a folder, the checkout showed an &#8216;expired session&#8217; error message.</li>\n</ul>\n<h2>A little something for the developers</h2>\n<p>Added support currency argument in raw_price_filter. This allows one to display prices in a different currency than the current currency on the page. e.g. display a custom list of prices without using a ‘list-type’ layout of the currency selector.</p>\n<h2>Download or upgrade</h2>\n<p>You can get <a href="https://downloads.wordpress.org/plugin/woocommerce-multilingual.3.5.zip">WooCommerce Multilingual 3.5</a> from the WordPress plugins directory and you are welcome to add and we’d love to hear your feedback here on any problems you may have on our <a href="http://wpml.org/forums/topic-tag/woocommerce/">support forum</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=BShZCm78WrQ:3C1vUHQL9zo:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=BShZCm78WrQ:3C1vUHQL9zo:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=BShZCm78WrQ:3C1vUHQL9zo:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=BShZCm78WrQ:3C1vUHQL9zo:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=BShZCm78WrQ:3C1vUHQL9zo:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=BShZCm78WrQ:3C1vUHQL9zo:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/BShZCm78WrQ" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:58:"http://wpml.org/2015/02/woocommerce-multilingual-3-5/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpml.org/2015/02/woocommerce-multilingual-3-5/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"Setting ACF plugin with WPML";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/OcPRYtqqo6Y/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:57:"http://wpml.org/2015/02/setting-acf-plugin-wpml/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 02 Feb 2015 18:37:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:9:"Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=553066";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:314:"Do you want to use WPML together with your Advanced Custom Fields plugin? This is how it&#8217;s done Advanced Custom Fields is used by many of our clients, it lets you add many types of fields to your posts which can later be displayed using the plugin&#8217;s API. Want to learn more? Read the tutorial [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1511:"<p><strong>Do you want to use WPML together with your <a href="https://wordpress.org/plugins/advanced-custom-fields/" title="Advanced Custom Fields Plugin" target="_blank">Advanced Custom Fields</a> plugin? This is how it&#8217;s done</strong></p>\n<p><iframe width="500" height="375" src="https://www.youtube.com/embed/osUX987d0EQ?feature=oembed" frameborder="0" allowfullscreen></iframe></p>\n<p>Advanced Custom Fields is used by many of our clients, it lets you add many types of fields to your posts which can later be displayed using the plugin&#8217;s API. </p>\n<p>Want to learn more? Read the tutorial on <a href="http://wpml.org/documentation/theme-compatibility/setting-wpml-advanced-custom-fields/" title="How to translate sites built with ACF">How to translate sites built with ACF</a> and get started.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=OcPRYtqqo6Y:krUvoWw2drA:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=OcPRYtqqo6Y:krUvoWw2drA:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=OcPRYtqqo6Y:krUvoWw2drA:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=OcPRYtqqo6Y:krUvoWw2drA:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=OcPRYtqqo6Y:krUvoWw2drA:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=OcPRYtqqo6Y:krUvoWw2drA:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/OcPRYtqqo6Y" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpml.org/2015/02/setting-acf-plugin-wpml/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:48:"http://wpml.org/2015/02/setting-acf-plugin-wpml/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:86:"This Week Compatible – Quince, Flatmarket, Frame, Grand College, Video Tab, Utilizer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/bddK4VqDsYc/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:111:"http://wpml.org/2015/01/this-week-compatible-quince-flatmarket-frame-grand-college-video-tab-utilizer/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Jan 2015 16:07:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=551830";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:340:"Today we are happy to announce that we have 4 themes, 1 WooCommerce extension and 1 plugin to add to our compatibility list. The themes are Quince, Flatmarket, Frame, Grand College Hotel, the WooCommerce extension is Product Video Tab, and the plugin is Utilizer If you want to review the entire multilingual ready list of themes [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6590:"<p>Today we are happy to announce that we have 4 themes, 1 WooCommerce extension and 1 plugin to add to our compatibility list. The themes are <a title="Quince" href="http://themeforest.net/item/quince-modern-business-theme/9299244">Quince</a>, <a title="Flatmarket" href="http://themeforest.net/item/flatmarket-multipurpose-woocommerce-theme-rtl/9185162">Flatmarket</a>, <a title="Frame" href="http://themeforest.net/item/frame-photography-minimalistic-wp-theme-/5358164">Frame</a>, <a title="Grand College" href="http://themeforest.net/item/grand-college-wordpress-theme-for-education/1865598">Grand College Hotel</a>, the WooCommerce extension is <a title="Product Video Tab" href="http://www.woo-ninja.com/shop/woocommerce-video-tab/">Product Video Tab</a>, and the plugin is <a title="Utilizer" href="http://utilizer.vuzzu.net/">Utilizer</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Quince theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/quince-modern-business-theme/9299244"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/quince.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Modern Business Theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/quince-modern-business-theme/9299244" target="_blank">Purchase Quince theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Flatmarket theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/flatmarket-multipurpose-woocommerce-theme-rtl/9185162"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/flatmarket.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Multi-Purpose Unlimited Skins Premium Responsive WordPress WooCommerce theme with visual Page Builder, powerful control panel and full RTL and WPML support!</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/flatmarket-multipurpose-woocommerce-theme-rtl/9185162" target="_blank">Purchase Flatmarket theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Frame Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/frame-photography-minimalistic-wp-theme-/5358164"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/frame.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Photography Minimalistic WP Theme</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/frame-photography-minimalistic-wp-theme-/5358164">Purchase Frame theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Grand College theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/grand-college-wordpress-theme-for-education/1865598"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/grand.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A theme for School, University, College. Clean and modern designed with well crafted. You can also translate each elements to your language via this admin panel.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/grand-college-wordpress-theme-for-education/1865598">Purchase Grand College Theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Product Video Tab</h2>\n<p style="text-align: center"><a href="http://www.woo-ninja.com/shop/woocommerce-video-tab/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/videotab.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Spice up your woocommerce product pages with product videos! This plugin allows you to add a video tab to your products in your woocommerce wordpress store.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.woo-ninja.com/shop/woocommerce-video-tab/">Product Video Tab</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Utilizer Plugin</h2>\n<p style="text-align: center"><a href="http://utilizer.vuzzu.net/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/utilizer.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Utilizer is a powerful plugin, easy to use and brand. Within few seconds be able to create your pages content using predefined elements with no development at all.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://utilizer.vuzzu.net/">Utilizer Plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=bddK4VqDsYc:pjNnl1auw2s:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=bddK4VqDsYc:pjNnl1auw2s:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=bddK4VqDsYc:pjNnl1auw2s:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=bddK4VqDsYc:pjNnl1auw2s:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=bddK4VqDsYc:pjNnl1auw2s:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=bddK4VqDsYc:pjNnl1auw2s:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/bddK4VqDsYc" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:107:"http://wpml.org/2015/01/this-week-compatible-quince-flatmarket-frame-grand-college-video-tab-utilizer/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:102:"http://wpml.org/2015/01/this-week-compatible-quince-flatmarket-frame-grand-college-video-tab-utilizer/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:87:"This week compatible – Dolly, Adrenalin, Highend, Nation Hotel, Flexible Posts Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/qfG0mnqXYr8/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:113:"http://wpml.org/2015/01/this-week-compatible-dolly-adrenalin-highend-nation-hotel-flexible-posts-widget/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 23 Jan 2015 16:26:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=548040";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:318:"Today we are happy to announce that we have 4 themes and 1 plugin to add to our compatibility list. The themes are Dolly, Adrenalin, Highend, Nation Hotel, and the plugin is Flexible Posts Widget If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6279:"<p>Today we are happy to announce that we have 4 themes and 1 plugin to add to our compatibility list. The themes are <a title="Dolly" href="http://themeforest.net/item/dolly-multipurpose-wordpress-theme/9170391">Dolly</a>, <a title="Adrenalin" href="http://themeforest.net/item/adrenalin-multipurpose-woocommerce-theme/9284771">Adrenalin</a>, <a title="Highend" href="http://hb-themes.com/home/themes/highend/">Highend</a>, <a title="Nation Hotel" href="http://themeforest.net/item/nation-hotel-responsive-wordpress-theme/6895743">Nation Hotel</a>, and the plugin is <a title="Flexible Posts Widget" href="https://wordpress.org/plugins/flexible-posts-widget/">Flexible Posts Widget</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Dolly theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/dolly-multipurpose-wordpress-theme/9170391"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/dolly.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Dolly is a clean, powerful &#038; multipurpose wordpress theme that can be used to build professional and modern websites. You can set your colors, change fonts, background patterns &#038; the layouts in different pages.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/dolly-multipurpose-wordpress-theme/9170391" target="_blank">Purchase Dolly theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Adrenalin theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/adrenalin-multipurpose-woocommerce-theme/9284771"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/adrenalin.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A multi purpose WooCommerce Theme with many features</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/adrenalin-multipurpose-woocommerce-theme/9284771" target="_blank">Purchase Adrenalin theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Highend Theme</h2>\n<p style="text-align: center"><a href="http://hb-themes.com/home/themes/highend/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/highend.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A responsive and clean multipurpose theme with a drag and drop page builder, many premium add-ons (Layer Slider, Revolution Slider, Visual Composer, Ultimate lcoMoon lcons Pack and Essential Grid) and post types (Team Members, Clients, FAQ, Pricing Tables, Testimonials, Portfolio and Gallery) to fit any purpose website.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://hb-themes.com/home/themes/highend/">Purchase Highend theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Nation Hotel theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/nation-hotel-responsive-wordpress-theme/6895743"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/nationhotel.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Nation Hotel is a responsive WordPress theme created by using latest HTML5 and CSS3 techniques and specially designed for Hotels, Motels, B&#038;B, Guest House, Hostels and any other hospitality businesses.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/nation-hotel-responsive-wordpress-theme/6895743">Purchase Nation Hotel</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Flexible Posts Widget Plugin</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/flexible-posts-widget/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/flexible.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Flexible Posts Widget (FPW) is more than just a simple alternative to the default Recent Posts widget. With many per-instance options it is highly customizable and allows advanced users to display the resulting posts virtually any way imaginable.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/flexible-posts-widget/">Download Flexible Posts Widget plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=qfG0mnqXYr8:3RPFgTTIIcw:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=qfG0mnqXYr8:3RPFgTTIIcw:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=qfG0mnqXYr8:3RPFgTTIIcw:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=qfG0mnqXYr8:3RPFgTTIIcw:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=qfG0mnqXYr8:3RPFgTTIIcw:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=qfG0mnqXYr8:3RPFgTTIIcw:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/qfG0mnqXYr8" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:109:"http://wpml.org/2015/01/this-week-compatible-dolly-adrenalin-highend-nation-hotel-flexible-posts-widget/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:104:"http://wpml.org/2015/01/this-week-compatible-dolly-adrenalin-highend-nation-hotel-flexible-posts-widget/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:32:"http://feeds.feedburner.com/wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:3:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:4:"wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:14:"emailServiceId";a:1:{i:0;a:5:{s:4:"data";s:4:"wpml";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:18:"feedburnerHostname";a:1:{i:0;a:5:{s:4:"data";s:29:"https://feedburner.google.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:11:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:13:"last-modified";s:29:"Wed, 11 Mar 2015 00:26:13 GMT";s:4:"date";s:29:"Wed, 11 Mar 2015 00:28:59 GMT";s:7:"expires";s:29:"Wed, 11 Mar 2015 00:28:59 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:14:"80:quic,p=0.08";s:13:"accept-ranges";s:4:"none";s:4:"vary";s:15:"Accept-Encoding";}s:5:"build";s:14:"20140618032821";}', 'no'); 
INSERT INTO `wp_options` VALUES (3735, '_site_transient_timeout_browser_8f08344a06a0174f5157cb8b14bb5d61', '1427204623', 'yes'); 
INSERT INTO `wp_options` VALUES (6879, '_site_transient_timeout_browser_c87684fd7cfd854f3826012e7e1f8d17', '1437060201', 'yes'); 
INSERT INTO `wp_options` VALUES (6880, '_site_transient_browser_c87684fd7cfd854f3826012e7e1f8d17', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:5:"7.1.3";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (1868, '_site_transient_browser_2dd04bb9d87bfa180059c21b3ca7cd2f', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"34.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (5482, 'wp_icl_translators_cached', 'a:2:{i:0;O:8:"stdClass":1:{s:2:"ID";s:1:"2";}i:1;O:8:"stdClass":1:{s:2:"ID";s:1:"1";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (6678, '_site_transient_browser_6697ed6c01e7487ccf95d824de796a8e', 'a:9:{s:8:"platform";s:6:"iPhone";s:4:"name";s:6:"iPhone";s:7:"version";s:3:"6.0";s:10:"update_url";s:0:"";s:7:"img_src";s:0:"";s:11:"img_src_ssl";s:0:"";s:15:"current_version";s:0:"";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (5494, 'duplicate_post_show_submitbox', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (5495, 'duplicate_post_version', '2.6', 'yes'); 
INSERT INTO `wp_options` VALUES (5493, 'duplicate_post_show_adminbar', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (5492, 'duplicate_post_show_row', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (5488, 'duplicate_post_copyattachments', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5489, 'duplicate_post_copychildren', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5490, 'duplicate_post_copystatus', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5491, 'duplicate_post_taxonomies_blacklist', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (5487, 'duplicate_post_copyexcerpt', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (3813, 'wpml_config_index', 'O:8:"stdClass":2:{s:7:"plugins";a:20:{i:0;O:8:"stdClass":5:{s:4:"name";s:38:"WooCommerce Catalog Visibility Options";s:14:"override_local";b:1;s:7:"updated";i:1408625614;s:4:"path";s:66:"wpml-config/woocommerce-catalog-visibility-options/wpml-config.xml";s:4:"hash";s:32:"d10bd6388a88521e488f7e4ba295c94c";}i:1;O:8:"stdClass":5:{s:4:"name";s:27:"WooCommerce Paymill Gateway";s:14:"override_local";b:1;s:7:"updated";i:1408626572;s:4:"path";s:55:"wpml-config/woocommerce-paymill-gateway/wpml-config.xml";s:4:"hash";s:32:"46409842584ff8df43a2aa922ad1d388";}i:2;O:8:"stdClass":5:{s:4:"name";s:26:"WooCommerce Stripe Gateway";s:14:"override_local";b:1;s:7:"updated";i:1409061503;s:4:"path";s:54:"wpml-config/woocommerce-stripe-gateway/wpml-config.xml";s:4:"hash";s:32:"4139e23bcdd0bb3e78cb079fa851ce85";}i:3;O:8:"stdClass":5:{s:4:"name";s:27:"WooCommerce Product Add-ons";s:14:"override_local";b:1;s:7:"updated";i:1409062371;s:4:"path";s:55:"wpml-config/woocommerce-product-add-ons/wpml-config.xml";s:4:"hash";s:32:"75320b24a703c55370175379c2faf22d";}i:4;O:8:"stdClass":5:{s:4:"name";s:20:"WooCommerce PostePay";s:14:"override_local";b:1;s:7:"updated";i:1409063136;s:4:"path";s:48:"wpml-config/woocommerce-postepay/wpml-config.xml";s:4:"hash";s:32:"b08722979a25b15ba4a02a16fb555ccc";}i:5;O:8:"stdClass":5:{s:4:"name";s:6:"Sensei";s:14:"override_local";b:1;s:7:"updated";i:1409063311;s:4:"path";s:34:"wpml-config/sensei/wpml-config.xml";s:4:"hash";s:32:"21fda51a99579915e92c6b22ae073a81";}i:6;O:8:"stdClass":5:{s:4:"name";s:25:"NW ADCart for WooCommerce";s:14:"override_local";b:1;s:7:"updated";i:1409734281;s:4:"path";s:53:"wpml-config/nw-adcart-for-woocommerce/wpml-config.xml";s:4:"hash";s:32:"91d62df0659fc7b561a3932a7a52de6a";}i:7;O:8:"stdClass":5:{s:4:"name";s:35:"Product Enquiry Pro for WooCommerce";s:14:"override_local";b:1;s:7:"updated";i:1409734531;s:4:"path";s:63:"wpml-config/product-enquiry-pro-for-woocommerce/wpml-config.xml";s:4:"hash";s:32:"305232f06370d52a29c346d6b711f50a";}i:8;O:8:"stdClass":5:{s:4:"name";s:17:"WooCommerce Plivo";s:14:"override_local";b:1;s:7:"updated";i:1409734705;s:4:"path";s:45:"wpml-config/woocommerce-plivo/wpml-config.xml";s:4:"hash";s:32:"539d172825c4714d69b8a42ad1826c5d";}i:9;O:8:"stdClass":5:{s:4:"name";s:24:"WooCommerce Embed Slides";s:14:"override_local";b:1;s:7:"updated";i:1409813892;s:4:"path";s:52:"wpml-config/woocommerce-embed-slides/wpml-config.xml";s:4:"hash";s:32:"f92b0578c4950e1d7ced60bbdba7ed5b";}i:10;O:8:"stdClass":5:{s:4:"name";s:22:"PayPal for WooCommerce";s:14:"override_local";b:1;s:7:"updated";i:1412841483;s:4:"path";s:54:"wpml-config/paypal-for-woocommerce/wpml-config (1).xml";s:4:"hash";s:32:"4ec8cff3c1bd61950873206196a29348";}i:11;O:8:"stdClass":5:{s:4:"name";s:27:"WooCommerce Product Bundles";s:14:"override_local";b:1;s:7:"updated";i:1414747440;s:4:"path";s:55:"wpml-config/woocommerce-product-bundles/wpml-config.xml";s:4:"hash";s:32:"81eae0e4985a54c08a2486cbc0cba690";}i:12;O:8:"stdClass":5:{s:4:"name";s:28:"WooCommerce Price by Country";s:14:"override_local";b:1;s:7:"updated";i:1415282919;s:4:"path";s:56:"wpml-config/woocommerce-price-by-country/wpml-config.xml";s:4:"hash";s:32:"9b296d64ba8afee80cb1ff4fac80144b";}i:13;O:8:"stdClass":5:{s:4:"name";s:21:"WooCommerce Video Tab";s:14:"override_local";b:1;s:7:"updated";i:1415284344;s:4:"path";s:49:"wpml-config/woocommerce-video-tab/wpml-config.xml";s:4:"hash";s:32:"7f9769bc2769e07ae730f3b4cd307741";}i:14;O:8:"stdClass":5:{s:4:"name";s:24:"WooCommerce Multilingual";s:14:"override_local";b:1;s:7:"updated";i:1435746652;s:4:"path";s:52:"wpml-config/woocommerce-multilingual/wpml-config.xml";s:4:"hash";s:32:"ac4db24282debd70520890d6832ea2f0";}i:15;O:8:"stdClass":7:{s:4:"name";s:16:"WPML Test Config";s:14:"override_local";b:1;s:7:"updated";i:1429773131;s:4:"path";s:44:"wpml-config/wpml-test-config/wpml-config.xml";s:4:"hash";s:32:"9c3bb313d5a4f028bebfa8fc8af990a3";s:4:"user";s:5:"admin";s:7:"details";s:3:"222";}i:16;O:8:"stdClass":5:{s:4:"name";s:29:"WooCommerce Product Gift Wrap";s:14:"override_local";b:1;s:7:"updated";i:1429640013;s:4:"path";s:57:"wpml-config/woocommerce-product-gift-wrap/wpml-config.xml";s:4:"hash";s:32:"dd3371d64d2ee01e6e42fd7e0bd134cf";}i:17;O:8:"stdClass":5:{s:4:"name";s:13:"WordPress SEO";s:14:"override_local";b:0;s:7:"updated";i:1435064619;s:4:"path";s:41:"wpml-config/wordpress-seo/wpml-config.xml";s:4:"hash";s:32:"6cdbcb3059702992376099699aa2f196";}i:18;O:8:"stdClass":5:{s:4:"name";s:23:"WooCommerce Tab Manager";s:14:"override_local";b:1;s:7:"updated";i:1433882104;s:4:"path";s:51:"wpml-config/woocommerce-tab-manager/wpml-config.xml";s:4:"hash";s:32:"0824e477b8f1e70d10476eebaf0ac7cb";}i:19;O:8:"stdClass":5:{s:4:"name";s:20:"WooCommerce Bookings";s:14:"override_local";b:1;s:7:"updated";i:1436527550;s:4:"path";s:48:"wpml-config/woocommerce-bookings/wpml-config.xml";s:4:"hash";s:32:"49eee5eb84c718c7bca44c59063fb58d";}}s:6:"themes";a:6:{i:0;O:8:"stdClass":5:{s:4:"name";s:6:"Canvas";s:14:"override_local";b:1;s:7:"updated";i:1425652093;s:4:"path";s:34:"wpml-config/canvas/wpml-config.xml";s:4:"hash";s:32:"9e8668255d8dd56105b67540358bae56";}i:1;O:8:"stdClass":5:{s:4:"name";s:4:"Kleo";s:14:"override_local";b:0;s:7:"updated";i:1425651882;s:4:"path";s:32:"wpml-config/kleo/wpml-config.xml";s:4:"hash";s:32:"442023138b716c2f410690eabeeab185";}i:2;O:8:"stdClass":5:{s:4:"name";s:4:"Port";s:14:"override_local";b:1;s:7:"updated";i:1426496203;s:4:"path";s:32:"wpml-config/port/wpml-config.xml";s:4:"hash";s:32:"788cce209545b94cfede660d543d7013";}i:3;O:8:"stdClass":5:{s:4:"name";s:36:"IDStore - Responsive WordPress Theme";s:14:"override_local";b:1;s:7:"updated";i:1427452920;s:4:"path";s:62:"wpml-config/idstore-responsive-wordpress-theme/wpml-config.xml";s:4:"hash";s:32:"c4ab5787cebb38c0358286626710ab37";}i:4;O:8:"stdClass":5:{s:4:"name";s:4:"Divi";s:14:"override_local";b:1;s:7:"updated";i:1430146146;s:4:"path";s:32:"wpml-config/divi/wpml-config.xml";s:4:"hash";s:32:"df3ab45b0372192108394aad7af044b4";}i:5;O:8:"stdClass":5:{s:4:"name";s:5:"Avada";s:14:"override_local";b:1;s:7:"updated";i:1430299590;s:4:"path";s:33:"wpml-config/avada/wpml-config.xml";s:4:"hash";s:32:"0dfb750d08596266d9dfda556c1bb1e1";}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (3814, 'wpml_config_index_updated', '1437059474', 'yes'); 
INSERT INTO `wp_options` VALUES (3815, 'wpml_config_files_arr', 'O:8:"stdClass":2:{s:6:"themes";a:0:{}s:7:"plugins";a:0:{}}', 'yes'); 
INSERT INTO `wp_options` VALUES (3817, 'icl_adl_settings', 'a:3:{s:10:"wp_version";s:5:"3.9.1";s:19:"last_time_xml_check";i:1426813960;s:27:"last_time_xml_check_trigger";s:9:"wp-update";}', 'yes'); 
INSERT INTO `wp_options` VALUES (3818, '_transient_WPML_ST_MO_Downloader_lang_map', 'a:105:{s:2:"an";s:2:"an";s:2:"ar";s:2:"ar";s:2:"az";s:2:"az";s:5:"az_TR";s:5:"az-tr";s:5:"bg_BG";s:2:"bg";s:5:"bn_BD";s:2:"bn";s:5:"bs_BA";s:2:"bs";s:2:"ca";s:2:"ca";s:3:"ckb";s:3:"ckb";s:2:"co";s:2:"co";s:5:"cs_CZ";s:2:"cs";s:2:"cy";s:2:"cy";s:5:"da_DK";s:2:"da";s:5:"de_DE";s:2:"de";s:2:"dv";s:2:"dv";s:2:"el";s:2:"el";s:5:"en_CA";s:5:"en-ca";s:5:"en_GB";s:5:"en-gb";s:2:"eo";s:2:"eo";s:5:"es_CL";s:5:"es-cl";s:5:"es_ES";s:2:"es";s:5:"es_PE";s:5:"es-pe";s:5:"es_VE";s:5:"es-ve";s:2:"et";s:2:"et";s:2:"eu";s:2:"eu";s:5:"fa_AF";s:5:"fa-af";s:5:"fa_IR";s:2:"fa";s:2:"fi";s:2:"fi";s:2:"fo";s:2:"fo";s:5:"fr_FR";s:2:"fr";s:2:"fy";s:2:"fy";s:2:"ga";s:2:"ga";s:2:"gd";s:2:"gd";s:5:"gl_ES";s:2:"gl";s:2:"gu";s:2:"gu";s:5:"haw_U";s:3:"haw";s:5:"he_IL";s:2:"he";s:5:"hi_IN";s:2:"hi";s:2:"hr";s:2:"hr";s:5:"hu_HU";s:2:"hu";s:2:"hy";s:2:"hy";s:5:"id_ID";s:2:"id";s:5:"is_IS";s:2:"is";s:5:"it_IT";s:2:"it";s:2:"ja";s:2:"ja";s:5:"jv_ID";s:2:"jv";s:5:"ka_GE";s:2:"ka";s:3:"kea";s:3:"kea";s:2:"kk";s:2:"kk";s:2:"kn";s:2:"kn";s:5:"ko_KR";s:2:"ko";s:2:"ku";s:2:"ku";s:5:"ky_KY";s:2:"ky";s:2:"la";s:2:"la";s:2:"li";s:2:"li";s:2:"lo";s:2:"lo";s:2:"lt";s:2:"lt";s:2:"lv";s:2:"lv";s:5:"me_ME";s:2:"me";s:5:"mg_MG";s:2:"mg";s:5:"mk_MK";s:2:"mk";s:5:"ml_IN";s:2:"ml";s:2:"mn";s:2:"mn";s:2:"mr";s:2:"mr";s:5:"ms_MY";s:2:"ms";s:5:"my_MM";s:3:"mya";s:5:"nb_NO";s:2:"nb";s:5:"ne_NP";s:2:"ne";s:2:"nl";s:2:"nl";s:5:"nl_BE";s:2:"nl";s:5:"nl_NL";s:2:"nl";s:5:"nn_NO";s:2:"nn";s:2:"os";s:2:"os";s:5:"pa_IN";s:2:"pa";s:5:"pl_PL";s:2:"pl";s:5:"pt_BR";s:5:"pt-br";s:5:"pt_PT";s:2:"pt";s:5:"ro_RO";s:2:"ro";s:5:"ru_RU";s:2:"ru";s:5:"ru_UA";s:5:"ru-ua";s:5:"sa_IN";s:5:"sa-in";s:5:"si_LK";s:2:"si";s:5:"sk_SK";s:2:"sk";s:5:"sl_SI";s:2:"sl";s:5:"so_SO";s:2:"so";s:2:"sq";s:2:"sq";s:5:"sr_RS";s:2:"sr";s:3:"srd";s:3:"srd";s:5:"su_ID";s:2:"su";s:5:"sv_SE";s:2:"sv";s:2:"sw";s:2:"sw";s:5:"ta_IN";s:2:"ta";s:5:"ta_LK";s:5:"ta-lk";s:2:"te";s:2:"te";s:2:"tg";s:2:"tg";s:2:"th";s:2:"th";s:2:"tl";s:2:"tl";s:2:"tr";s:2:"tr";s:5:"ug_CN";s:2:"ug";s:2:"uk";s:2:"uk";s:2:"ur";s:2:"ur";s:5:"uz_UZ";s:2:"uz";s:2:"vi";s:2:"vi";s:5:"zh_CN";s:5:"zh-cn";s:5:"zh_TW";s:5:"zh-tw";}', 'yes'); 
INSERT INTO `wp_options` VALUES (3862, '_transient_bcf2fa3436c5f2d7224a1e9100b2d7f0', 'en', 'yes'); 
INSERT INTO `wp_options` VALUES (3827, '_transient_90ab5827af4164115fe869d777800bc0', 'fr', 'yes'); 
INSERT INTO `wp_options` VALUES (6932, '_transient_timeout_feed_2af8eb95e685b52eda9667d663cafadb', '1436824472', 'no'); 
INSERT INTO `wp_options` VALUES (6933, '_transient_feed_2af8eb95e685b52eda9667d663cafadb', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:49:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:4:"WPML";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:16:"https://wpml.org";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:52:"The Plugin for Building Multilingual WordPress Sites";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 13 Jul 2015 09:45:52 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:29:"http://wordpress.org/?v=4.2.2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"This week compatible – Guardian, LMS, Total, Kia Subtitle";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/EUkUfp69J48/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:87:"https://wpml.org/2015/07/this-week-compatible-guardian-lms-total-kia-subtitle/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 10 Jul 2015 19:22:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=656997";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:312:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Guardian, Learning Management System, Total, and the plugin is Kia Subtitle If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5380:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Guardian" href="https://wordpress.org/themes/guardian/">Guardian</a>, <a title="Learning Management System" href="http://themeforest.net/item/lms-responsive-learning-management-system/7867581">Learning Management System</a>, <a title="Total" href="http://themeforest.net/item/total-responsive-multipurpose-wordpress-theme/6339019">Total</a>, and the plugin is <a title="Kia Subtitle" href="https://wordpress.org/plugins/kia-subtitle/">Kia Subtitle</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">Guardian theme</h2>\n<p style="text-align: center;"><a href="https://wordpress.org/themes/guardian/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/07/guardian.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Guardian is a multi-purpose responsive theme. You can use it for your business, portfolio, blogging or any type of site.Guardian is Responsive and flexible based on BOOTSTRAP CSS framework that adapts your website to mobile devices and the desktop or any other viewing environment.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/themes/guardian/" target="_blank">Download Guardian theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Learning Management System theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/lms-responsive-learning-management-system/7867581"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/07/lms.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>LMS is Powerful Learning management WordPress theme provides awesome features for creating online courses, teacher profile, extended user profiles, lesson management, quiz System, video Hosting, ranking / rating system, questions system, attachments, Tracking course progress etc.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/lms-responsive-learning-management-system/7867581">Purchase LMS theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Total theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/total-responsive-multipurpose-wordpress-theme/6339019"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/07/total.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Total makes it EASY to build awesome looking layouts via front-end drag&#038;drop editing</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/total-responsive-multipurpose-wordpress-theme/6339019">Purchase Total theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Kia Subtitle Plugin</h2>\n<p style="text-align: center;"><a href="https://wordpress.org/plugins/kia-subtitle/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/07/kia.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>The subtitle allows you to easily add a subtitle to your posts and retrieve it in the loop in the same manner as the post title. By using the_subtitle() or get_the_subtitle().</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/kia-subtitle/">Download Kia Subtitle plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=EUkUfp69J48:HbnGEL6eQKs:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=EUkUfp69J48:HbnGEL6eQKs:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=EUkUfp69J48:HbnGEL6eQKs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=EUkUfp69J48:HbnGEL6eQKs:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=EUkUfp69J48:HbnGEL6eQKs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=EUkUfp69J48:HbnGEL6eQKs:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/EUkUfp69J48" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:83:"https://wpml.org/2015/07/this-week-compatible-guardian-lms-total-kia-subtitle/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:78:"https://wpml.org/2015/07/this-week-compatible-guardian-lms-total-kia-subtitle/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:42:"Beta Version for WPML 3.2.3 Bugfix Release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/Xs5xvB482eg/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:77:"https://wpml.org/2015/07/beta-version-for-wpml-3-2-3-bugfix-release/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 10 Jul 2015 06:14:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=656560";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:313:"We are ready with a beta version for WPML 3.2.3. This release is a stability update for WPML. It closes a number of holes and includes overall improvements. WPML 3.2.3 goes into complete QA next week. We are releasing this beta, so that people who are facing problems due to resolved issues can use this [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5774:"<p><strong>We are ready with a beta version for WPML 3.2.3. This release is a stability update for WPML. It closes a number of holes and includes overall improvements. WPML 3.2.3 goes into complete QA next week. We are releasing this beta, so that people who are facing problems due to resolved issues can use this version already.</strong></p>\n<h2>WPML 3.2.3 Core</h2>\n<h3>Fixes</h3>\n<ul>\n<li>Fixed a potential security issue</li>\n<li>Fixed missing parentheses in mobile switcher</li>\n<li>Changing admin language on one site (multisite) does not sets admin language on all sites anymore</li>\n<li>When &#8216;Language as Parameter&#8217; is used, wp_link_pages() pagination produce malformed URLs</li>\n<li>Fixed WPML breaking XML-RPC calls</li>\n<li>Fixed wrong order of languages when using icl_get_languages with orderby=name</li>\n<li>Fixed several glitches and issues related to the menus synchronization</li>\n<li>Fixed redirection issues when the same slug is used in translations with hierarchical post types</li>\n<li>Fixed page template being unchangeable in translated content, after deactivating the &#8220;Synchronize page template&#8221; setting</li>\n<li>Fixed &#8220;This is a translation of&#8221; being empty when creating a new translation</li>\n<li>Removed errors when deactivating WPML for a subsite in multisite install</li>\n</ul>\n<h3>Improvements</h3>\n<ul>\n<li>Improved caching of posts, taxonomy translation data, and strings</li>\n<li>Improved performances</li>\n</ul>\n<h3>API</h3>\n<ul>\n<li>New <a href="https://wpml.org/documentation/support/wpml-coding-api/wpml-hooks-reference/">hooks</a> added WPML</li>\n</ul>\n<h4>Filters</h4>\n<ul>\n<li>wpml_permalink</li>\n<li>wpml_element_language_details</li>\n<li>wpml_element_language_code</li>\n<li>wpml_elements_without_translations</li>\n</ul>\n<h4>Actions</h4>\n<ul>\n<li>wpml_switch_language</li>\n</ul>\n<h3>Compatibility</h3>\n<h4>WooCommerce</h4>\n<ul>\n<li>When WPML is set to use languages per domain, switching languages will not lose the cart data</li>\n<li>The shop page is now properly processed as a shop page, instead of behaving as a regular custom post type archive page.</li>\n</ul>\n<h3>Access</h3>\n<ul>\n<li>Improved WPML capabilities definitions by adding descriptive labels</li>\n</ul>\n<h2>WPML String Translation</h2>\n<h3>Fixes</h3>\n<ul>\n<li>Fixed a problem with slug translation showing translated slug for English on Multilingual Content Setup when Admin language is other than English</li>\n<li>Fixed slug translation so it works with the default permalink structure.</li>\n<li>Fixed caching problem with admin texts which caused some admin texts to not update correctly.</li>\n<li>Removed PHP Fatal error: Specified key was too long; max key length is 1000 bytes caused by gettext_context_md5</li>\n<li>Fixed string scanning issues</li>\n</ul>\n<h3>New</h3>\n<ul>\n<li>Support multi-line strings when importing and exporting po files</li>\n<li>Support gettext contexts in string translation</li>\n</ul>\n<h2>WPML Translation Management</h2>\n<h3>Fixes</h3>\n<ul>\n<li>Translation Editor shows existing translated content, if there was a previous translation</li>\n<li>Editor can translate again content if he is set as a translator</li>\n<li>Translation Editor won&#8217;t changes language pairs for translators any more</li>\n<li>Titles for packages and posts won&#8217;t get mixed up in the translation jobs table any more</li>\n<li>Users set as translators can translate content again, using the translation editor, even if there is not a translation job created for that content</li>\n</ul>\n<h2>GravityForms Multilingual</h2>\n<h3>Fixes</h3>\n<ul>\n<li>Is now possible to translate price field options labels and values</li>\n</ul>\n<h2>Download and Update</h2>\n<p>This is still a beta version, so it&#8217;s not intended for everyone. If your site is impacted by a bug that&#8217;s fixed in this release, you can use this version to fix.</p>\n<p>Before installing beta versions on your site, please make complete backup. This should include the files and database.</p>\n<p>As a beta version, this update is only available by manual download and installation. To download, go to your WPML account and click on Downloads.</p>\n<p>If you have a Multilingual CMS account, you will see a <strong>CMS Beta Package</strong> download. Download it and unzip. The download includes ZIP files of all of WPML&#8217;s components. You need to update all WPML components that you are using (it&#8217;s not possible to run a site with a mixture of old and new versions).</p>\n<p>If you have a Multilingual Blog account, you will see a <strong>WPML Blog Beta</strong> download. You need to extract and upload this to your site to the plugins folder.</p>\n<h2>Schedule for the production version</h2>\n<p>WPML 3.2.3 is going into QA next week. This version received testing for all fixes, but not comprehensive testing &#8220;from scratch&#8221;. QA takes about 2 weeks to complete. Then, we will release the final WPML 3.2.3.</p>\n<h2>Feedback?</h2>\n<p>If you have questions, suggestions or ideas, please leave your comments and we will reply.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=Xs5xvB482eg:aP4XWoAqmjs:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=Xs5xvB482eg:aP4XWoAqmjs:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=Xs5xvB482eg:aP4XWoAqmjs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=Xs5xvB482eg:aP4XWoAqmjs:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=Xs5xvB482eg:aP4XWoAqmjs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=Xs5xvB482eg:aP4XWoAqmjs:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/Xs5xvB482eg" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:73:"https://wpml.org/2015/07/beta-version-for-wpml-3-2-3-bugfix-release/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:68:"https://wpml.org/2015/07/beta-version-for-wpml-3-2-3-bugfix-release/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:113:"WooCommerce Compatibility – Authorize.net Payment Gateway, EU VAT, Terms &amp; Conditions Popup, Product Filter";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/-Lvr9Fqso2M/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:135:"https://wpml.org/2015/07/woocommerce-compatibility-authorize-net-payment-gateway-eu-vat-terms-conditions-popup-product-filter/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 03 Jul 2015 15:15:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=652331";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:356:"WooCommerce Multilingual is a very important project for us, today we are happy to announce that we have 4 WooCommerce extensions to add to our compatibility list. The extensions are Authorize.net Payment Gateway, EU VAT, Terms &#038; Conditions Popup, Product Filter If you want to review the entire multilingual ready list of themes and plugins [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5126:"<p><a href="https://wordpress.org/plugins/woocommerce-multilingual/" title="WooCommerce Multilingual" target="_blank">WooCommerce Multilingual</a> is a very important project for us, today we are happy to announce that we have 4 WooCommerce extensions to add to our compatibility list. </p>\n<p>The extensions are <a title="Authorize.net Payment Gateway" href="https://yithemes.com/themes/plugins/yith-woocommerce-authorize-net-payment-gateway/">Authorize.net Payment Gateway</a>, <a title="EU VAT" href="https://yithemes.com/themes/plugins/yith-woocommerce-eu-vat/">EU VAT</a>, <a title="EU VAT" href="https://yithemes.com/themes/plugins/yith-woocommerce-terms-conditions-popup/">Terms &#038; Conditions Popup</a>, <a title="Product Filter" href="https://yithemes.com/themes/plugins/yith-woocommerce-ajax-product-filter/">Product Filter</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Authorize.net Payment Gateway</h2>\n<p style="text-align: center"><a href="https://yithemes.com/themes/plugins/yith-woocommerce-authorize-net-payment-gateway/"></a></p>\n<blockquote><p>Offering a payment gateway so popular and easy to integrate such as Authorize.net is a warranty for users in terms of reliability and accessibility.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://yithemes.com/themes/plugins/yith-woocommerce-authorize-net-payment-gateway/" target="_blank">Purchase Authorize.net Payment Gateway</a></div>\n<div class="feature">\n<h2 style="text-align: center">EU VAT</h2>\n<p style="text-align: center"><a href="https://yithemes.com/themes/plugins/yith-woocommerce-eu-vat/" ></a></p>\n<blockquote><p>28 countries mean 28 different calculations; do you think it could be confusing? Well, because with YITH WooCommerce EU VAT everything will be automatic.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://yithemes.com/themes/plugins/yith-woocommerce-eu-vat/">Purchase EU VAT</a></div>\n<div class="feature">\n<h2 style="text-align: center">Terms &#038; Conditions Popup</h2>\n<p style="text-align: center"><a href="https://yithemes.com/themes/plugins/yith-woocommerce-terms-conditions-popup/"></a></p>\n<blockquote><p>Terms and conditions are a fundamental part of each website, because they have great advantages both for users and administrators in terms of liability and security. Putting it in a pop-up window reduces probability for users to leave the page.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://yithemes.com/themes/plugins/yith-woocommerce-terms-conditions-popup/">Purchase Terms &#038; Conditions Popup</a></div>\n<div class="feature">\n<h2 style="text-align: center">Product Filter</h2>\n<p style="text-align: center"><a href="https://yithemes.com/themes/plugins/yith-woocommerce-ajax-product-filter/"></a></p>\n<blockquote><p>Allow your users to filter products following their needs, and in few seconds they will find exactly what they want to buy: a simple and powerful tool to address your customers towards their ideal product, speed the purchase processes, and improve the conversion of your online shop.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://yithemes.com/themes/plugins/yith-woocommerce-ajax-product-filter/">Purchase Product Filter</a></div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=-Lvr9Fqso2M:U-m1UQZDOuA:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=-Lvr9Fqso2M:U-m1UQZDOuA:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=-Lvr9Fqso2M:U-m1UQZDOuA:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=-Lvr9Fqso2M:U-m1UQZDOuA:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=-Lvr9Fqso2M:U-m1UQZDOuA:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=-Lvr9Fqso2M:U-m1UQZDOuA:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/-Lvr9Fqso2M" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:131:"https://wpml.org/2015/07/woocommerce-compatibility-authorize-net-payment-gateway-eu-vat-terms-conditions-popup-product-filter/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:126:"https://wpml.org/2015/07/woocommerce-compatibility-authorize-net-payment-gateway-eu-vat-terms-conditions-popup-product-filter/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:84:"This week Compatible – Legalized, Enigma, Responsive Menu, Forms Management System";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/xWQa0_5spA0/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:112:"https://wpml.org/2015/06/this-week-compatible-legalized-enigma-responsive-menu-forms-management-system/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 26 Jun 2015 15:56:46 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=647343";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:317:"Today we are happy to announce that we have 2 themes and 2 plugins to add to our compatibility list. The themes are Legalized, Enigma, and the plugins are Responsive Menu, Forms Management System If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4964:"<p>Today we are happy to announce that we have 2 themes and 2 plugins to add to our compatibility list. The themes are <a title="Legalized" href="http://themeforest.net/item/legalized-modern-business-wordpress-theme-/5147911">Legalized</a>, <a title="Enigma" href="https://wordpress.org/themes/enigma/">Enigma</a>, and the plugins are <a title="Responsive Menu" href="https://wordpress.org/plugins/responsive-menu/">Responsive Menu</a>, <a title="Forms Management System" href="http://codecanyon.net/item/forms-management-systemwordpress-frontend-plugin/8978741">Forms Management System</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">Legalized theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/legalized-modern-business-wordpress-theme-/5147911"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/legalized.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Legalized is perfect theme for lawyers and law related businesses.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/legalized-modern-business-wordpress-theme-/5147911" target="_blank">Purchase Legalized theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Enigma theme</h2>\n<p style="text-align: center;"><a href="https://wordpress.org/themes/enigma/"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/enigma.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Enigma is a responsive multi-purpose theme suitable for business, corporate office and others.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/themes/enigma/">Download Enigma theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Responsive Menu Plugin</h2>\n<p style="text-align: center;"><a href="https://wordpress.org/plugins/responsive-menu/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/responsive.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>This is a Highly Customisable Responsive Menu Plugin for WordPress</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/responsive-menu/">Download Responsive Menu plugin</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Forms Management System Plugin</h2>\n<p style="text-align: center;"><a href="http://codecanyon.net/item/forms-management-systemwordpress-frontend-plugin/8978741"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/fms.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>FMS allows you  To Build a Job board, Classified Site, News Site, Book Store, Directories, and many more Interactive Websites.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://codecanyon.net/item/forms-management-systemwordpress-frontend-plugin/8978741">Purchase Forms Management System plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=xWQa0_5spA0:Npeg1IrFEj0:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=xWQa0_5spA0:Npeg1IrFEj0:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=xWQa0_5spA0:Npeg1IrFEj0:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=xWQa0_5spA0:Npeg1IrFEj0:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=xWQa0_5spA0:Npeg1IrFEj0:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=xWQa0_5spA0:Npeg1IrFEj0:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/xWQa0_5spA0" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:108:"https://wpml.org/2015/06/this-week-compatible-legalized-enigma-responsive-menu-forms-management-system/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:103:"https://wpml.org/2015/06/this-week-compatible-legalized-enigma-responsive-menu-forms-management-system/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:84:"WooCommerce Compatibility – Checkout field editor, WooCart Pro, Product Slider Pro";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/eDmG_Qn-l0w/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:113:"https://wpml.org/2015/06/woocommerce-compatibility-checkout-field-editor-woocart-pro-product-slider-pro/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 22 Jun 2015 07:17:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=633372";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:342:"WooCommerce Multilingual is a very important project for us, today we are happy to announce that we have 3 WooCommerce extensions to add to our compatibility list. The extensions are Checkout field editor, WooCart Pro, Product Slider Pro If you want to review the entire multilingual ready list of themes and plugins you are welcome [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4056:"<p><a href="https://wordpress.org/plugins/woocommerce-multilingual/" title="WooCommerce Multilingual" target="_blank">WooCommerce Multilingual</a> is a very important project for us, today we are happy to announce that we have 3 WooCommerce extensions to add to our compatibility list. </p>\n<p>The extensions are <a title="Checkout field editor" href="http://www.woothemes.com/products/woocommerce-checkout-field-editor/">Checkout field editor</a>, <a title="WooCart Pro" href="http://codecanyon.net/item/woocommerce-cart-woocart-pro/7992078">WooCart Pro</a>, <a title="Product Slider Pro" href="https://weaveapps.com/shop/wordpress-plugins/woocommerce-product-slider-pro/">Product Slider Pro</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Checkout field editor</h2>\n<p style="text-align: center"><a href="http://www.woothemes.com/products/woocommerce-checkout-field-editor/"></a></p>\n<blockquote><p>The checkout field editor provides you with an interface to add, edit and remove fields shown on your WooCommerce checkout page.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.woothemes.com/products/woocommerce-checkout-field-editor/" target="_blank">Purchase Checkout field editor</a></div>\n<div class="feature">\n<h2 style="text-align: center">WooCart Pro</h2>\n<p style="text-align: center"><a href="http://codecanyon.net/item/woocommerce-cart-woocart-pro/7992078" ></a></p>\n<blockquote><p>WooCart Pro is powerful plugin to create and modify the cart for your online shop.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://codecanyon.net/item/woocommerce-cart-woocart-pro/7992078">Purchase WooCart Pro</a></div>\n<div class="feature">\n<h2 style="text-align: center">Product Slider Pro</h2>\n<p style="text-align: center"><a href="https://weaveapps.com/shop/wordpress-plugins/woocommerce-product-slider-pro/"></a></p>\n<blockquote><p>WooCommerce product slider is a jQuery powered and carouFredsel library based posts content slider plugin developed for WordPress.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://weaveapps.com/shop/wordpress-plugins/woocommerce-product-slider-pro/">Purchase Product Slider Pro</a></div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=eDmG_Qn-l0w:x-bWL75_PUc:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=eDmG_Qn-l0w:x-bWL75_PUc:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=eDmG_Qn-l0w:x-bWL75_PUc:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=eDmG_Qn-l0w:x-bWL75_PUc:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=eDmG_Qn-l0w:x-bWL75_PUc:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=eDmG_Qn-l0w:x-bWL75_PUc:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/eDmG_Qn-l0w" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:109:"https://wpml.org/2015/06/woocommerce-compatibility-checkout-field-editor-woocart-pro-product-slider-pro/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:104:"https://wpml.org/2015/06/woocommerce-compatibility-checkout-field-editor-woocart-pro-product-slider-pro/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:98:"This Week Compatible – Quezal, Inspirebook, Carousel content posts slider, rtMedia Photo Tagging";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/3mPDEHqmrJA/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:126:"https://wpml.org/2015/06/this-week-compatible-quezal-inspirebook-carousel-content-posts-slider-rtmedia-photo-tagging/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 12 Jun 2015 15:01:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=637263";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:322:"Today we are happy to announce that we have 2 themes and 2 plugins to add to our compatibility list. The themes are Quezal, Inspirebook, and the plugins are Carousel posts content slider, rtMedia Photo Tagging If you want to review the entire multilingual ready list of themes and plugins you are welcome to view [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5149:"<p>Today we are happy to announce that we have 2 themes and 2 plugins to add to our compatibility list. The themes are <a title="Quezal" href="http://themeforest.net/item/quezal-software-responsive-wordpress-theme/8500596">Quezal</a>, <a title="Inspirebook" href="https://rtcamp.com/products/inspirebook/">Inspirebook</a>, and the plugins are <a title="Carousel posts content slider" href="https://weaveapps.com/shop/wordpress-plugins/carousel-horizontal-posts-slider-wordpress-plugin/">Carousel posts content slider</a>, <a title="rtMedia Photo Tagging" href="https://rtcamp.com/products/rtmedia-photo-tagging/">rtMedia Photo Tagging</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">Quezal theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/quezal-software-responsive-wordpress-theme/8500596"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/quezal.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Quezal is a software Responsive WordPress Theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/quezal-software-responsive-wordpress-theme/8500596" target="_blank">Purchase Quezal theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Inspirebook theme</h2>\n<p style="text-align: center;"><a href="https://rtcamp.com/products/inspirebook/"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/inspirebook.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>InspireBook is theme, designed especially for BuddyPress and social-networks.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://rtcamp.com/products/inspirebook/">Purchase Inspirebook theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Carousel posts content slider Plugin</h2>\n<p style="text-align: center;"><a href="https://weaveapps.com/shop/wordpress-plugins/carousel-horizontal-posts-slider-wordpress-plugin/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/carousel.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Carousel posts content slider is a jQuery powered and carouFredSel library based WordPress plugin which allows you to create multiple sliders on your web site anywhere you like easily.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://weaveapps.com/shop/wordpress-plugins/carousel-horizontal-posts-slider-wordpress-plugin/">Purchase Carousel posts content slider plugin</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">rtMedia Photo Tagging Plugin</h2>\n<p style="text-align: center;"><a href="https://rtcamp.com/products/rtmedia-photo-tagging/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/phototagging.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>rtMedia Photo Tagging add-on lets your users tag themselves and their friends on each others’ photos.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://rtcamp.com/products/rtmedia-photo-tagging/">Purchase rtMedia Photo Tagging plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=3mPDEHqmrJA:PKosYTGpFJc:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=3mPDEHqmrJA:PKosYTGpFJc:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=3mPDEHqmrJA:PKosYTGpFJc:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=3mPDEHqmrJA:PKosYTGpFJc:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=3mPDEHqmrJA:PKosYTGpFJc:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=3mPDEHqmrJA:PKosYTGpFJc:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/3mPDEHqmrJA" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:122:"https://wpml.org/2015/06/this-week-compatible-quezal-inspirebook-carousel-content-posts-slider-rtmedia-photo-tagging/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:117:"https://wpml.org/2015/06/this-week-compatible-quezal-inspirebook-carousel-content-posts-slider-rtmedia-photo-tagging/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:37:"WPML 3.2 Released with Manual Updates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/0-wANxPIVjg/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wpml.org/2015/06/wpml-3-2-released/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 12 Jun 2015 06:58:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"WPML versions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=630998";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:307:"WPML 3.2 is now done with all testing and is ready to run production sites. This week, we are still not pushing it as an automated update, but you can download manually from your WPML.org account. We are doing manual updates this week, so that you can choose where to upgrade and have more control [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3148:"<p><strong>WPML 3.2 is now done with all testing and is ready to run production sites. This week, we are still not pushing it as an automated update, but you can download manually from your WPML.org account. We are doing manual updates this week, so that you can choose where to upgrade and have more control over your sites.</strong></p>\n<div style="margin:2em; padding: 1em; border: 1pt solid #80FF80; background-color: #F0FFF0;">\n<h3>Attention ICanLocalize clients</h3>\n<p>WPML 3.2 doesn&#8217;t support ICanLocalize. Please wait with your upgrade until version 3.2.1 is released. We are working to complete it ASAP. Then, WPML will arrive with automated updates.</p>\n</div>\n<p>The major new features in WPML 3.2 are listed in <a href="https://wpml.org/version/wpml-3-2/">WPML 3.2 changelog entry</a>. These include a new workflow for the Translation Management, new translation services, better taxonomy translation much improved performance and more.</p>\n<h2>Why Manual Updates?</h2>\n<p>WPML 3.2 include heavy rewrites of much of the code. It comes with new features, many fixes and a lot of overall improvements. In our testing, we tried to cover as many themes and plugins as we could. We are also running WPML 3.2 on our own sites and it&#8217;s all working smoothly.</p>\n<p>We know that such a big update may have corner cases with different code. So, we have suspended the automatic updates and are encouraging clients to update manually. This way, if your site has any issues, we can help you faster.</p>\n<h2>How to Install WPML 3.2</h2>\n<p>Please log in to your <a href="https://wpml.org/account/">WPML.org account</a> and click on Downloads. Download all of WPML&#8217;s components that you are using. Go to your site, deactivate WPML and its components, delete and the upload again. You can see how to do this in this short clip:</p>\n<p><iframe width="500" height="375" src="https://www.youtube.com/embed/4W2S7_pKOeI?feature=oembed" frameborder="0" allowfullscreen></iframe></p>\n<p>Be sure to update all the components that you are using. You should not use a mixture of old and new WPML components.</p>\n<h2>Questions? Suggestions? Feedback?</h2>\n<p>Please leave your comments here and we will reply. If you need any technical help, create new threads in our <a href="https://wpml.org/forums/forum/english-support/">technical support forum</a>. All our team is trained on the new features of WPML 3.2 and will be happy to assist.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=0-wANxPIVjg:3dxv-48qquE:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=0-wANxPIVjg:3dxv-48qquE:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=0-wANxPIVjg:3dxv-48qquE:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=0-wANxPIVjg:3dxv-48qquE:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=0-wANxPIVjg:3dxv-48qquE:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=0-wANxPIVjg:3dxv-48qquE:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/0-wANxPIVjg" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wpml.org/2015/06/wpml-3-2-released/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"13";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:43:"https://wpml.org/2015/06/wpml-3-2-released/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:83:"This Week Compatible – Grid X, Aruba Nights, AddToAny, BWL Knowledge Base Manager";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/MhCKCBJThxA/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:111:"https://wpml.org/2015/06/this-week-compatible-grid-x-aruba-nights-addtoany-bwl-knowledge-base-manager/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 06 Jun 2015 15:19:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=633357";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:307:"Today we are happy to announce that we have 2 themes and 2 plugins to add to our compatibility list. The themes are Grid X, Aruba Nights, and the plugins are AddToAny, BWL Knowledge Base Manager If you want to review the entire multilingual ready list of themes and plugins you are welcome to view [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5006:"<p>Today we are happy to announce that we have 2 themes and 2 plugins to add to our compatibility list. The themes are <a title="Grid X" href="http://themeforest.net/item/grid-x-creative-multipurpose-theme/10765043">Grid X</a>, <a title="Aruba Nights" href="http://www.pipdig.co/shop/wordpress-theme-aruba-nights/">Aruba Nights</a>, and the plugins are <a title="AddToAny" href="https://wordpress.org/plugins/add-to-any/">AddToAny</a>, <a title="BWL Knowledge Base Manager" href="http://codecanyon.net/item/bwl-knowledge-base-manager/7972812">BWL Knowledge Base Manager</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">Grid X theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/grid-x-creative-multipurpose-theme/10765043"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/gridx.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Gridx is multi-purpose WordPress Theme for suitable for portfolio sites.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/grid-x-creative-multipurpose-theme/10765043" target="_blank">Purchase Grid X theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Aruba Nights theme</h2>\n<p style="text-align: center;"><a href="http://www.pipdig.co/shop/wordpress-theme-aruba-nights/"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/aruba.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Arubanights is simplistic WordPress theme suitable for blog or e-commerce sites.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.pipdig.co/shop/wordpress-theme-aruba-nights/">Purchase Aruba Nights theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">AddToAny Plugin</h2>\n<p style="text-align: center;"><a href="https://wordpress.org/plugins/add-to-any/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/addtoany.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Share buttons for WordPress including AddToAny&#8217;s universal sharing button, Facebook, Twitter, Google+, Pinterest, WhatsApp and many more.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/add-to-any/">Download AddToAny plugin</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">BWL Knowledge Base Manager Plugin</h2>\n<p style="text-align: center;"><a href="http://codecanyon.net/item/bwl-knowledge-base-manager/7972812"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/bwlknow.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>This plugin comes with lots of unique and flexible features to create unlimited number of Knowledge Base question and answers for your website content.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://codecanyon.net/item/bwl-knowledge-base-manager/7972812">Purchase BWL Knowledge Base Manager plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=MhCKCBJThxA:wAetsj747fw:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=MhCKCBJThxA:wAetsj747fw:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=MhCKCBJThxA:wAetsj747fw:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=MhCKCBJThxA:wAetsj747fw:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=MhCKCBJThxA:wAetsj747fw:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=MhCKCBJThxA:wAetsj747fw:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/MhCKCBJThxA" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:107:"https://wpml.org/2015/06/this-week-compatible-grid-x-aruba-nights-addtoany-bwl-knowledge-base-manager/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:102:"https://wpml.org/2015/06/this-week-compatible-grid-x-aruba-nights-addtoany-bwl-knowledge-base-manager/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"This week compatible – Yama, Minshop, rtMedia FFmpeg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/alHsnJMu_Vo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:84:"https://wpml.org/2015/06/this-week-compatible-yama-minishop-rtmedia-ffmpeg/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 01 Jun 2015 19:14:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=628924";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:309:"Today we are happy to announce that we have 2 themes and 1 plugin to add to our compatibility list. The themes are Yama, Minshop, and the plugin is rtMedia FFmpeg Addon If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4462:"<p>Today we are happy to announce that we have 2 themes and 1 plugin to add to our compatibility list. The themes are <a title="Yama" href="http://themeforest.net/item/yama-retina-responsive-wordpress-portfolio-theme/10518496">Yama</a>, <a title="Minshop" href="http://themify.me/themes/minshop">Minshop</a>, and the plugin is <a title="rtMedia FFmpeg" href="https://rtcamp.com/products/rtmedia-ffmpeg-addon/">rtMedia FFmpeg Addon</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">Yama theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/yama-retina-responsive-wordpress-portfolio-theme/10518496"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/yama.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Yama is a gorgeously minimalistic WordPress theme. Quick to setup and easy to customize, thanks to a detailed manual, and the carefully structured code, Yama is the perfect theme for showcasing your work in an elegantly beautiful way.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/yama-retina-responsive-wordpress-portfolio-theme/10518496" target="_blank">Purchase Yama theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Minshop theme</h2>\n<p style="text-align: center;"><a href="http://themify.me/themes/minshop"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/minishop.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Ecommerce WordPress simple and minimalistic theme that is suitable for any general shop site. Includes an Ajax shopping cart, large panel slider and a product slider where you can feature your products.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themify.me/themes/minshop">Purchase Minshop theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">rtMedia FFmpeg add-on Plugin</h2>\n<p style="text-align: center;"><a href="https://rtcamp.com/products/rtmedia-ffmpeg-addon/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/06/ffmpeg01.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>This addon adds automatic video conversion support for the rtMedia plugin. When installed, your BuddyPress users will be able to upload videos in many more formats.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://rtcamp.com/products/rtmedia-ffmpeg-addon/">Purchase rtMedia FFmpeg add-on plugin</a></p>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=alHsnJMu_Vo:nv6trKw7FI4:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=alHsnJMu_Vo:nv6trKw7FI4:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=alHsnJMu_Vo:nv6trKw7FI4:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=alHsnJMu_Vo:nv6trKw7FI4:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=alHsnJMu_Vo:nv6trKw7FI4:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=alHsnJMu_Vo:nv6trKw7FI4:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/alHsnJMu_Vo" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:80:"https://wpml.org/2015/06/this-week-compatible-yama-minishop-rtmedia-ffmpeg/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:75:"https://wpml.org/2015/06/this-week-compatible-yama-minishop-rtmedia-ffmpeg/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:49:"We are attending WordCamp Buenos Aires, Argentina";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/HiVlep1oviU/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:83:"https://wpml.org/2015/05/we-are-attending-wordcamp-buenos-aires-argentina/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 27 May 2015 13:44:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=627063";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:338:"This Saturday, May 30th, four WPML representatives will attend Wordcamp Buenos Aires. &#160; Beda Schmid and Otto Wald, our excellent WPML Supporters will be present. Beda is currently working on the support forum for Toolset, one of our other plugins. Feel free to meet them in the event and take the opportunity to get answers [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Agnes Bury";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3837:"<p>This Saturday, May 30th, four WPML representatives will attend <a href="https://buenosaires.wordcamp.org/2015/" target="_blank">Wordcamp Buenos Aires</a>.</p>\n<div id="attachment_627096" style="width: 710px" class="wp-caption alignnone"><img class="wp-image-627096 size-full" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/wordcamp-ba-argentina.jpg" alt="WordCamp BA official site" width="968" height="567"  style="box-sizing: border-box; max-width: 100%; padding: 0 5px; height: auto;" /><p class="wp-caption-text">WordCamp BA official site (<a href="https://buenosaires.wordcamp.org/2015/">buenosaires.wordcamp.org/2015</a>)</p></div>\n<p>&nbsp;</p>\n<div style="width: 200px" class="wp-caption alignleft"><img class="" src="http://www.onthegosystems.com/wp-content/uploads/2014/12/beda1-wpcf_190x190.jpg" alt="Beda Shmid (WPML Support Team)" width="190" height="190" /><p class="wp-caption-text">Beda Shmid (Support Team)</p></div>\n<div style="width: 200px" class="wp-caption alignleft"><img class="" src="http://www.onthegosystems.com/wp-content/uploads/2015/04/otto-wpcf_190x190.jpg" alt="Otto Wald (WPML Support Team)" width="190" height="190" /><p class="wp-caption-text">Otto Wald (WPML Support Team)</p></div>\n<p><strong>Beda Schmid</strong> and <strong>Otto Wald</strong>, our excellent WPML Supporters will be present. Beda is currently working on the support forum for <a href="http://wp-types.com/" target="_blank">Toolset</a>, one of our other plugins.</p>\n<p>Feel free to meet them in the event and take the opportunity to get answers for all your WordPress and Multilingual related questions. They will be happy to answer your questions.</p>\n<div class="clearfix"></div>\n<div style="width: 200px" class="wp-caption alignright"><img class="" src="http://www.onthegosystems.com/wp-content/uploads/2014/12/mercedes-wpcf_190x190.jpg" alt="Mercedes Barreda (WPML Compatibility Team)" width="190" height="190" /><p class="wp-caption-text">Mercedes Barreda (WPML Compatibility Team)</p></div>\n<p><strong>Mercedes Barreda</strong> is in charge of our <a href="https://wpml.org/documentation/theme-compatibility/" target="_blank">WPML compatibility program</a>. If you&#8217;re a theme author and you would like to know if your public theme can be made compatible with WPML, you will be able to meet Mercedes and she will have the info you need.</p>\n<div style="width: 200px" class="wp-caption alignleft"><img class="" src="http://www.onthegosystems.com/wp-content/uploads/2013/10/Laura1-wpcf_190x190.jpg" alt="Laura de Figueiredo" width="190" height="190" /><p class="wp-caption-text">Laura de Figueiredo (OnTheGoSystems HR manager)</p></div>\n<p>You can also meet <strong>Laura de Figueiredo</strong>, our HR Manager. If interested in knowing more about our company benefits and if you&#8217;re interested in joining us, she can let you know more about our needs. You can establish a nice first contact that may lead to<a href="http://www.onthegosystems.com/team/" target="_blank"> job interview</a> later on.</p>\n<p><strong>See you on Saturday, in Buenos Aires!</strong></p>\n<div class="clearfix"></div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=HiVlep1oviU:a5qrMvVLc_Q:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=HiVlep1oviU:a5qrMvVLc_Q:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=HiVlep1oviU:a5qrMvVLc_Q:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=HiVlep1oviU:a5qrMvVLc_Q:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=HiVlep1oviU:a5qrMvVLc_Q:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=HiVlep1oviU:a5qrMvVLc_Q:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/HiVlep1oviU" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:79:"https://wpml.org/2015/05/we-are-attending-wordcamp-buenos-aires-argentina/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:74:"https://wpml.org/2015/05/we-are-attending-wordcamp-buenos-aires-argentina/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:32:"http://feeds.feedburner.com/wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:3:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:4:"wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:14:"emailServiceId";a:1:{i:0;a:5:{s:4:"data";s:4:"wpml";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:18:"feedburnerHostname";a:1:{i:0;a:5:{s:4:"data";s:29:"https://feedburner.google.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:11:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:13:"last-modified";s:29:"Mon, 13 Jul 2015 09:47:28 GMT";s:4:"date";s:29:"Mon, 13 Jul 2015 09:54:32 GMT";s:7:"expires";s:29:"Mon, 13 Jul 2015 09:54:32 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:11:"80:quic,p=0";s:13:"accept-ranges";s:4:"none";s:4:"vary";s:15:"Accept-Encoding";}s:5:"build";s:14:"20140618032821";}', 'no'); 
INSERT INTO `wp_options` VALUES (6919, '_site_transient_timeout_browser_f495d8667f3957f47e8d604cf1f965dc', '1437376413', 'yes'); 
INSERT INTO `wp_options` VALUES (6920, '_site_transient_browser_f495d8667f3957f47e8d604cf1f965dc', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Chrome";s:7:"version";s:13:"43.0.2357.132";s:10:"update_url";s:28:"http://www.google.com/chrome";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/chrome.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/chrome.png";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6921, '_site_transient_timeout_browser_9d82d9270bce22a11f2030a07103cff7', '1437379785', 'yes'); 
INSERT INTO `wp_options` VALUES (6922, '_site_transient_browser_9d82d9270bce22a11f2030a07103cff7', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"30.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6934, '_transient_timeout_feed_mod_2af8eb95e685b52eda9667d663cafadb', '1436824472', 'no'); 
INSERT INTO `wp_options` VALUES (6935, '_transient_feed_mod_2af8eb95e685b52eda9667d663cafadb', '1436781272', 'no'); 
INSERT INTO `wp_options` VALUES (6936, '_site_transient_timeout_browser_b47de53522f728d7fedea8f0228c4276', '1437387761', 'yes'); 
INSERT INTO `wp_options` VALUES (6937, '_site_transient_browser_b47de53522f728d7fedea8f0228c4276', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"39.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6938, '_site_transient_timeout_browser_701029316660bbc9ee8ebc0eb4e659e0', '1437388648', 'yes'); 
INSERT INTO `wp_options` VALUES (6939, '_site_transient_browser_701029316660bbc9ee8ebc0eb4e659e0', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:5:"8.0.7";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6940, '_site_transient_timeout_browser_f9c3059ef2bacfd862d40f2f36470319', '1437395132', 'yes'); 
INSERT INTO `wp_options` VALUES (6941, '_site_transient_browser_f9c3059ef2bacfd862d40f2f36470319', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Chrome";s:7:"version";s:13:"43.0.2357.132";s:10:"update_url";s:28:"http://www.google.com/chrome";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/chrome.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/chrome.png";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6973, 'rewrite_rules', 'a:68:{s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:38:"index.php?&page_id=5&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:20:"(.?.+?)(/[0-9]+)?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:20:"([^/]+)(/[0-9]+)?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";}', 'yes'); 
INSERT INTO `wp_options` VALUES (5583, '_site_transient_timeout_browser_ee6aeab93d0b8f4cbd561dcdb49cd594', '1431963767', 'yes'); 
INSERT INTO `wp_options` VALUES (5584, '_site_transient_browser_ee6aeab93d0b8f4cbd561dcdb49cd594', 'a:9:{s:8:"platform";s:4:"iPad";s:4:"name";s:4:"iPad";s:7:"version";s:3:"7.0";s:10:"update_url";s:0:"";s:7:"img_src";s:0:"";s:11:"img_src_ssl";s:0:"";s:15:"current_version";s:0:"";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6677, '_site_transient_timeout_browser_6697ed6c01e7487ccf95d824de796a8e', '1435757342', 'yes'); 
INSERT INTO `wp_options` VALUES (7000, '_site_transient_update_themes', 'O:8:"stdClass":4:{s:12:"last_checked";i:1437084181;s:7:"checked";a:5:{s:13:"fruitdudragon";s:3:"1.0";s:4:"katz";s:5:"1.0.0";s:14:"twentyfourteen";s:3:"1.1";s:14:"twentythirteen";s:3:"1.2";s:12:"twentytwelve";s:3:"1.4";}s:8:"response";a:3:{s:14:"twentyfourteen";a:4:{s:5:"theme";s:14:"twentyfourteen";s:11:"new_version";s:3:"1.4";s:3:"url";s:44:"https://wordpress.org/themes/twentyfourteen/";s:7:"package";s:60:"https://downloads.wordpress.org/theme/twentyfourteen.1.4.zip";}s:14:"twentythirteen";a:4:{s:5:"theme";s:14:"twentythirteen";s:11:"new_version";s:3:"1.5";s:3:"url";s:44:"https://wordpress.org/themes/twentythirteen/";s:7:"package";s:60:"https://downloads.wordpress.org/theme/twentythirteen.1.5.zip";}s:12:"twentytwelve";a:4:{s:5:"theme";s:12:"twentytwelve";s:11:"new_version";s:3:"1.7";s:3:"url";s:42:"https://wordpress.org/themes/twentytwelve/";s:7:"package";s:58:"https://downloads.wordpress.org/theme/twentytwelve.1.7.zip";}}s:12:"translations";a:1:{i:0;a:7:{s:4:"type";s:5:"theme";s:4:"slug";s:14:"twentyfourteen";s:8:"language";s:5:"fr_FR";s:7:"version";s:3:"1.1";s:7:"updated";s:19:"2014-08-15 15:06:19";s:7:"package";s:78:"https://downloads.wordpress.org/translation/theme/twentyfourteen/1.1/fr_FR.zip";s:10:"autoupdate";b:1;}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (6999, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:6:{i:0;O:8:"stdClass":10:{s:8:"response";s:7:"upgrade";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.2.2";s:7:"version";s:5:"4.2.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:1;O:8:"stdClass":10:{s:8:"response";s:7:"upgrade";s:8:"download";s:59:"https://downloads.wordpress.org/release/wordpress-4.2.2.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:59:"https://downloads.wordpress.org/release/wordpress-4.2.2.zip";s:10:"no_content";s:70:"https://downloads.wordpress.org/release/wordpress-4.2.2-no-content.zip";s:11:"new_bundled";s:71:"https://downloads.wordpress.org/release/wordpress-4.2.2-new-bundled.zip";s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.2.2";s:7:"version";s:5:"4.2.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:2;O:8:"stdClass":11:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.2.2";s:7:"version";s:5:"4.2.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";s:12:"notify_email";s:1:"1";}i:3;O:8:"stdClass":10:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.5.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.5.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.1.5";s:7:"version";s:5:"4.1.5";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:4;O:8:"stdClass":10:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.0.5.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.0.5.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.0.5";s:7:"version";s:5:"4.0.5";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:5;O:8:"stdClass":10:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-3.9.6.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-3.9.6.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"3.9.6";s:7:"version";s:5:"3.9.6";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1437084182;s:15:"version_checked";s:5:"3.9.1";s:12:"translations";a:0:{}}', 'yes'); 
INSERT INTO `wp_options` VALUES (4679, '_site_transient_timeout_browser_0dbc0bcfc3366ae7533a75620c6fae18', '1430219004', 'yes'); 
INSERT INTO `wp_options` VALUES (4680, '_site_transient_browser_0dbc0bcfc3366ae7533a75620c6fae18', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:5:"8.0.4";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (7001, '_site_transient_update_plugins', 'O:8:"stdClass":4:{s:12:"last_checked";i:1437084135;s:7:"checked";a:17:{s:33:"admin-menu-editor/menu-editor.php";s:5:"1.3.2";s:30:"advanced-custom-fields/acf.php";s:5:"4.3.8";s:29:"acf-repeater/acf-repeater.php";s:5:"1.1.1";s:19:"akismet/akismet.php";s:5:"3.0.0";s:35:"comment-control/comment-control.php";s:5:"0.4.1";s:33:"duplicate-post/duplicate-post.php";s:3:"2.6";s:9:"hello.php";s:3:"1.6";s:27:"katz-enhance-admin/main.php";s:3:"0.1";s:37:"post-types-order/post-types-order.php";s:5:"1.6.5";s:41:"taxonomy-converter/taxonomy-converter.php";s:3:"1.1";s:114:"tinymce-and-tinymce-advanced-professsional-formats-and-styles/tinymce-advanced-professional-formats-and-styles.php";s:5:"1.1.2";s:29:"wp-db-backup/wp-db-backup.php";s:5:"2.2.4";s:41:"wordpress-importer/wordpress-importer.php";s:5:"0.6.1";s:51:"wpml-theme-tester/wpml-compatibility-test-tools.php";s:5:"1.0.1";s:40:"sitepress-multilingual-cms/sitepress.php";s:7:"3.1.9.3";s:34:"wpml-string-translation/plugin.php";s:5:"2.1.1";s:38:"wpml-translation-management/plugin.php";s:6:"1.9.11";}s:8:"response";a:7:{s:33:"admin-menu-editor/menu-editor.php";O:8:"stdClass":6:{s:2:"id";s:5:"11743";s:4:"slug";s:17:"admin-menu-editor";s:6:"plugin";s:33:"admin-menu-editor/menu-editor.php";s:11:"new_version";s:5:"1.4.4";s:3:"url";s:48:"https://wordpress.org/plugins/admin-menu-editor/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/admin-menu-editor.1.4.4.zip";}s:30:"advanced-custom-fields/acf.php";O:8:"stdClass":6:{s:2:"id";s:5:"21367";s:4:"slug";s:22:"advanced-custom-fields";s:6:"plugin";s:30:"advanced-custom-fields/acf.php";s:11:"new_version";s:5:"4.4.2";s:3:"url";s:53:"https://wordpress.org/plugins/advanced-custom-fields/";s:7:"package";s:65:"https://downloads.wordpress.org/plugin/advanced-custom-fields.zip";}s:19:"akismet/akismet.php";O:8:"stdClass":6:{s:2:"id";s:2:"15";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:5:"3.1.3";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/akismet.3.1.3.zip";}s:37:"post-types-order/post-types-order.php";O:8:"stdClass":6:{s:2:"id";s:5:"17292";s:4:"slug";s:16:"post-types-order";s:6:"plugin";s:37:"post-types-order/post-types-order.php";s:11:"new_version";s:5:"1.8.2";s:3:"url";s:47:"https://wordpress.org/plugins/post-types-order/";s:7:"package";s:59:"https://downloads.wordpress.org/plugin/post-types-order.zip";}s:29:"wp-db-backup/wp-db-backup.php";O:8:"stdClass":6:{s:2:"id";s:3:"419";s:4:"slug";s:12:"wp-db-backup";s:6:"plugin";s:29:"wp-db-backup/wp-db-backup.php";s:11:"new_version";s:5:"2.3.0";s:3:"url";s:43:"https://wordpress.org/plugins/wp-db-backup/";s:7:"package";s:61:"https://downloads.wordpress.org/plugin/wp-db-backup.2.3.0.zip";}s:40:"sitepress-multilingual-cms/sitepress.php";O:8:"stdClass":6:{s:2:"id";i:0;s:4:"slug";s:26:"sitepress-multilingual-cms";s:6:"plugin";s:40:"sitepress-multilingual-cms/sitepress.php";s:11:"new_version";s:7:"3.1.9.7";s:14:"upgrade_notice";s:0:"";s:3:"url";s:47:"https://wpml.org/?download=6088&version=3.1.9.7";}s:34:"wpml-string-translation/plugin.php";O:8:"stdClass":6:{s:2:"id";i:0;s:4:"slug";s:23:"wpml-string-translation";s:6:"plugin";s:34:"wpml-string-translation/plugin.php";s:11:"new_version";s:5:"2.1.4";s:14:"upgrade_notice";s:0:"";s:3:"url";s:45:"https://wpml.org/?download=6092&version=2.1.4";}}s:12:"translations";a:1:{i:0;a:7:{s:4:"type";s:6:"plugin";s:4:"slug";s:18:"wordpress-importer";s:8:"language";s:5:"fr_FR";s:7:"version";s:5:"0.6.1";s:7:"updated";s:19:"2012-05-08 16:00:37";s:7:"package";s:85:"https://downloads.wordpress.org/translation/plugin/wordpress-importer/0.6.1/fr_FR.zip";s:10:"autoupdate";b:1;}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (6877, '_site_transient_timeout_browser_3e73bfb3599a3ca8982f1077923d94aa', '1437052178', 'yes'); 
INSERT INTO `wp_options` VALUES (6878, '_site_transient_browser_3e73bfb3599a3ca8982f1077923d94aa', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"38.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (5955, 'category_children', 'a:0:{}', 'yes');
#
# End of data contents of table `wp_options`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_postmeta`
# --------------------------------------------------------


#
# Delete any existing table `wp_postmeta`
#

DROP TABLE IF EXISTS `wp_postmeta`;


#
# Table structure of table `wp_postmeta`
#

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=127445 DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_postmeta`
#
 
INSERT INTO `wp_postmeta` VALUES (358, 45, '_edit_lock', '1406551547:2'); 
INSERT INTO `wp_postmeta` VALUES (4, 5, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (5, 5, '_edit_lock', '1436974825:2'); 
INSERT INTO `wp_postmeta` VALUES (6, 5, '_wp_page_template', 'page-home.php'); 
INSERT INTO `wp_postmeta` VALUES (7, 7, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (8, 7, '_wp_page_template', 'page-clients.php'); 
INSERT INTO `wp_postmeta` VALUES (9, 7, '_edit_lock', '1435574339:1'); 
INSERT INTO `wp_postmeta` VALUES (10, 9, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (11, 9, '_wp_page_template', 'page-approach.php'); 
INSERT INTO `wp_postmeta` VALUES (12, 9, '_edit_lock', '1435067593:2'); 
INSERT INTO `wp_postmeta` VALUES (13, 11, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (14, 11, '_wp_page_template', 'page-about.php'); 
INSERT INTO `wp_postmeta` VALUES (15, 11, '_edit_lock', '1435013536:1'); 
INSERT INTO `wp_postmeta` VALUES (16, 13, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (17, 13, '_wp_page_template', 'page-contact.php'); 
INSERT INTO `wp_postmeta` VALUES (18, 13, '_edit_lock', '1436974821:1'); 
INSERT INTO `wp_postmeta` VALUES (19, 1, '_edit_lock', '1436967699:2'); 
INSERT INTO `wp_postmeta` VALUES (20, 15, '_edit_lock', '1429632334:1'); 
INSERT INTO `wp_postmeta` VALUES (21, 15, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (75622, 15, 'rule', 'a:5:{s:5:"param";s:9:"post_type";s:8:"operator";s:2:"==";s:5:"value";s:4:"post";s:8:"order_no";i:0;s:8:"group_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (23, 15, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (24, 15, 'layout', 'default'); 
INSERT INTO `wp_postmeta` VALUES (25, 15, 'hide_on_screen', ''); 
INSERT INTO `wp_postmeta` VALUES (27, 15, 'field_538b9de882bff', 'a:13:{s:3:"key";s:19:"field_538b9de882bff";s:5:"label";s:21:"block photos légende";s:4:"name";s:20:"block_photos_legende";s:4:"type";s:8:"repeater";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:10:"sub_fields";a:10:{i:0;a:12:{s:3:"key";s:19:"field_538b9e4d82c00";s:5:"label";s:12:"photo gauche";s:4:"name";s:7:"photo_l";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}i:1;a:12:{s:3:"key";s:19:"field_53ece0b878c24";s:5:"label";s:15:"photo au centre";s:4:"name";s:7:"photo_m";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:1;}i:2;a:12:{s:3:"key";s:19:"field_538b9e7e82c01";s:5:"label";s:12:"photo droite";s:4:"name";s:7:"photo_r";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:2;}i:3;a:12:{s:3:"key";s:19:"field_55156fe993680";s:5:"label";s:19:"photo gauche Ipad H";s:4:"name";s:19:"photo_gauche_ipad_h";s:4:"type";s:5:"image";s:12:"instructions";s:35:"1824x844 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:3;}i:4;a:12:{s:3:"key";s:19:"field_5515704193683";s:5:"label";s:19:"photo gauche Ipad V";s:4:"name";s:19:"photo_gauche_ipad_v";s:4:"type";s:5:"image";s:12:"instructions";s:35:"1336x740 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:4;}i:5;a:12:{s:3:"key";s:19:"field_55157097ae085";s:5:"label";s:21:"photo gauche Iphone H";s:4:"name";s:21:"photo_gauche_iphone_h";s:4:"type";s:5:"image";s:12:"instructions";s:34:"880x420 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:5;}i:6;a:12:{s:3:"key";s:19:"field_551570dbae088";s:5:"label";s:21:"photo gauche Iphone V";s:4:"name";s:21:"photo_gauche_iphone_v";s:4:"type";s:5:"image";s:12:"instructions";s:34:"560x400 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:6;}i:7;a:14:{s:3:"key";s:19:"field_538b9ea782c02";s:5:"label";s:5:"titre";s:4:"name";s:5:"title";s:4:"type";s:8:"textarea";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:13:"default_value";s:0:"";s:11:"placeholder";s:0:"";s:9:"maxlength";s:0:"";s:4:"rows";s:0:"";s:10:"formatting";s:2:"br";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:7;}i:8;a:14:{s:3:"key";s:19:"field_538b9ebe82c03";s:5:"label";s:10:"sous titre";s:4:"name";s:8:"subtitle";s:4:"type";s:8:"textarea";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:13:"default_value";s:0:"";s:11:"placeholder";s:0:"";s:9:"maxlength";s:0:"";s:4:"rows";s:0:"";s:10:"formatting";s:2:"br";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:8;}i:9;a:14:{s:3:"key";s:19:"field_53e4df62543ef";s:5:"label";s:12:"before-after";s:4:"name";s:12:"before-after";s:4:"type";s:5:"radio";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:7:"choices";a:2:{s:4:"true";s:4:"true";s:5:"false";s:5:"false";}s:12:"other_choice";s:1:"0";s:17:"save_other_choice";s:1:"0";s:13:"default_value";s:5:"false";s:6:"layout";s:8:"vertical";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:9;}}s:7:"row_min";s:0:"";s:9:"row_limit";s:0:"";s:6:"layout";s:3:"row";s:12:"button_label";s:7:"Add Row";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:2:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (34, 16, '_edit_lock', '1403059267:1'); 
INSERT INTO `wp_postmeta` VALUES (35, 16, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (36, 16, 'field_538ba0e4f295f', 'a:14:{s:3:"key";s:19:"field_538ba0e4f295f";s:5:"label";s:10:"sous titre";s:4:"name";s:13:"subtitle_name";s:4:"type";s:4:"text";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:13:"default_value";s:0:"";s:11:"placeholder";s:0:"";s:7:"prepend";s:0:"";s:6:"append";s:0:"";s:10:"formatting";s:4:"html";s:9:"maxlength";s:0:"";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:2:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (161, 16, 'rule', 'a:5:{s:5:"param";s:9:"post_type";s:8:"operator";s:2:"==";s:5:"value";s:4:"post";s:8:"order_no";i:0;s:8:"group_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (38, 16, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (39, 16, 'layout', 'default'); 
INSERT INTO `wp_postmeta` VALUES (40, 16, 'hide_on_screen', 'a:1:{i:0;s:11:"the_content";}'); 
INSERT INTO `wp_postmeta` VALUES (43, 1, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (53, 18, '_wp_attached_file', '2014/06/a.png'); 
INSERT INTO `wp_postmeta` VALUES (45, 17, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (46, 17, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (47, 17, 'block_photos_legende', '0'); 
INSERT INTO `wp_postmeta` VALUES (48, 17, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (49, 1, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (50, 1, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (51, 1, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (52, 1, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (54, 18, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:250;s:6:"height";i:185;s:4:"file";s:13:"2014/06/a.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:13:"a-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (57, 19, '_wp_attached_file', '2014/06/bg_contact.png'); 
INSERT INTO `wp_postmeta` VALUES (58, 19, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1078;s:6:"height";i:601;s:4:"file";s:22:"2014/06/bg_contact.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"bg_contact-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"bg_contact-300x167.png";s:5:"width";i:300;s:6:"height";i:167;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"bg_contact-1024x570.png";s:5:"width";i:1024;s:6:"height";i:570;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"bg_contact-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"bg_contact-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (60, 22, '_menu_item_type', 'post_type'); 
INSERT INTO `wp_postmeta` VALUES (61, 22, '_menu_item_menu_item_parent', '0'); 
INSERT INTO `wp_postmeta` VALUES (62, 22, '_menu_item_object_id', '13'); 
INSERT INTO `wp_postmeta` VALUES (63, 22, '_menu_item_object', 'page'); 
INSERT INTO `wp_postmeta` VALUES (64, 22, '_menu_item_target', ''); 
INSERT INTO `wp_postmeta` VALUES (65, 22, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'); 
INSERT INTO `wp_postmeta` VALUES (66, 22, '_menu_item_xfn', ''); 
INSERT INTO `wp_postmeta` VALUES (67, 22, '_menu_item_url', ''); 
INSERT INTO `wp_postmeta` VALUES (10356, 624, 'image', '623'); 
INSERT INTO `wp_postmeta` VALUES (10354, 623, '_wp_attached_file', '2014/06/home-hand.jpg'); 
INSERT INTO `wp_postmeta` VALUES (10355, 623, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:325;s:4:"file";s:21:"2014/06/home-hand.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"home-hand-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"home-hand-300x203.jpg";s:5:"width";i:300;s:6:"height";i:203;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66203, 1915, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (78, 24, '_menu_item_type', 'post_type'); 
INSERT INTO `wp_postmeta` VALUES (79, 24, '_menu_item_menu_item_parent', '0'); 
INSERT INTO `wp_postmeta` VALUES (80, 24, '_menu_item_object_id', '9'); 
INSERT INTO `wp_postmeta` VALUES (81, 24, '_menu_item_object', 'page'); 
INSERT INTO `wp_postmeta` VALUES (82, 24, '_menu_item_target', ''); 
INSERT INTO `wp_postmeta` VALUES (83, 24, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'); 
INSERT INTO `wp_postmeta` VALUES (84, 24, '_menu_item_xfn', ''); 
INSERT INTO `wp_postmeta` VALUES (85, 24, '_menu_item_url', ''); 
INSERT INTO `wp_postmeta` VALUES (87, 25, '_menu_item_type', 'post_type'); 
INSERT INTO `wp_postmeta` VALUES (88, 25, '_menu_item_menu_item_parent', '0'); 
INSERT INTO `wp_postmeta` VALUES (89, 25, '_menu_item_object_id', '7'); 
INSERT INTO `wp_postmeta` VALUES (90, 25, '_menu_item_object', 'page'); 
INSERT INTO `wp_postmeta` VALUES (91, 25, '_menu_item_target', ''); 
INSERT INTO `wp_postmeta` VALUES (92, 25, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'); 
INSERT INTO `wp_postmeta` VALUES (93, 25, '_menu_item_xfn', ''); 
INSERT INTO `wp_postmeta` VALUES (94, 25, '_menu_item_url', ''); 
INSERT INTO `wp_postmeta` VALUES (66205, 1915, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (15750, 826, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (15749, 826, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (15748, 826, 'actu', '0'); 
INSERT INTO `wp_postmeta` VALUES (104733, 496, 'rule', 'a:5:{s:5:"param";s:9:"post_type";s:8:"operator";s:2:"==";s:5:"value";s:4:"post";s:8:"order_no";i:0;s:8:"group_no";i:7;}'); 
INSERT INTO `wp_postmeta` VALUES (66204, 1915, 'block_photos_legende_0_subtitle', '• Redonner ses lettres de noblesse au domaine Château de Pommard.\r\n'); 
INSERT INTO `wp_postmeta` VALUES (66202, 1915, 'block_photos_legende_0_title', 'Logo design, emblem and typography. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66201, 1915, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66200, 1915, 'block_photos_legende_0_photo_gauche_iphone_v', '1749'); 
INSERT INTO `wp_postmeta` VALUES (66199, 1915, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66198, 1915, 'block_photos_legende_0_photo_gauche_iphone_h', '1748'); 
INSERT INTO `wp_postmeta` VALUES (66171, 1914, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (139, 35, '_edit_lock', '1434029163:2'); 
INSERT INTO `wp_postmeta` VALUES (66197, 1915, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66193, 1915, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66194, 1915, 'block_photos_legende_0_photo_gauche_ipad_h', '1745'); 
INSERT INTO `wp_postmeta` VALUES (66195, 1915, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66196, 1915, 'block_photos_legende_0_photo_gauche_ipad_v', '1746'); 
INSERT INTO `wp_postmeta` VALUES (140, 35, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (141, 36, '_wp_attached_file', '2014/06/bogosse.png'); 
INSERT INTO `wp_postmeta` VALUES (142, 36, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:19:"2014/06/bogosse.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"bogosse-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"bogosse-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"bogosse-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"bogosse-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"bogosse-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (6993, 466, '_edit_lock', '1409789258:1'); 
INSERT INTO `wp_postmeta` VALUES (146, 39, 'subtitle_name', ''); 
INSERT INTO `wp_postmeta` VALUES (147, 39, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (148, 39, 'block_photos_legende', '0'); 
INSERT INTO `wp_postmeta` VALUES (149, 39, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (150, 35, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (151, 35, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (152, 35, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (153, 35, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (155, 40, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (156, 40, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (157, 40, 'block_photos_legende', '0'); 
INSERT INTO `wp_postmeta` VALUES (158, 40, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (211, 45, '_wp_attached_file', '2014/06/moet.png'); 
INSERT INTO `wp_postmeta` VALUES (212, 45, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:16:"2014/06/moet.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"moet-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"moet-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"moet-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"moet-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"moet-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (165, 42, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (166, 42, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (167, 42, 'block_photos_legende_0_photo_l', '41'); 
INSERT INTO `wp_postmeta` VALUES (168, 42, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (169, 42, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (170, 42, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (171, 42, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (172, 42, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (173, 42, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (174, 42, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (175, 42, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (176, 42, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (177, 1, 'block_photos_legende_0_photo_l', '701'); 
INSERT INTO `wp_postmeta` VALUES (178, 1, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (179, 1, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (180, 1, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (181, 1, 'block_photos_legende_0_title', 'Champagne Moët & Chandon. Design du logo. Dessin et typographie. 2002'); 
INSERT INTO `wp_postmeta` VALUES (182, 1, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (183, 1, 'block_photos_legende_0_subtitle', '• Rafraîchir la marque Moët & Chandon à l’occasion de la refonte complète de la gamme.\r\n> L’emblème de Moët & Chandon est une combinaison de la couronne impériale et de la tiare papale. Il a été redessiné, tout comme le lettrage, dont les pleins et déliés ont été accentués, pour une vibration plus harmonieuse.'); 
INSERT INTO `wp_postmeta` VALUES (184, 1, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (186, 43, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (187, 43, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (188, 43, 'block_photos_legende_0_photo_l', '41'); 
INSERT INTO `wp_postmeta` VALUES (189, 43, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (190, 43, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (191, 43, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (192, 43, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (193, 43, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (194, 43, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (195, 43, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (196, 43, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (197, 43, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (199, 44, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (200, 44, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (201, 44, 'block_photos_legende_0_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (202, 44, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (203, 44, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (204, 44, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (205, 44, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (206, 44, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (207, 44, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (208, 44, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (209, 44, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (210, 44, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (227, 47, '_wp_attached_file', '2014/06/moet_l.png'); 
INSERT INTO `wp_postmeta` VALUES (214, 46, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (215, 46, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (216, 46, 'block_photos_legende_0_photo_l', '45'); 
INSERT INTO `wp_postmeta` VALUES (217, 46, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (218, 46, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (219, 46, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (220, 46, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (221, 46, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (222, 46, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (223, 46, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (224, 46, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (225, 46, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (228, 47, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:731;s:6:"height";i:501;s:4:"file";s:18:"2014/06/moet_l.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"moet_l-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"moet_l-300x205.png";s:5:"width";i:300;s:6:"height";i:205;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"moet_l-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (229, 48, '_wp_attached_file', '2014/06/moet_p.png'); 
INSERT INTO `wp_postmeta` VALUES (230, 48, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:332;s:6:"height";i:500;s:4:"file";s:18:"2014/06/moet_p.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"moet_p-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"moet_p-199x300.png";s:5:"width";i:199;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"moet_p-332x372.png";s:5:"width";i:332;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (232, 49, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (233, 49, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (234, 49, 'block_photos_legende_0_photo_l', '45'); 
INSERT INTO `wp_postmeta` VALUES (235, 49, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (236, 49, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (237, 49, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (238, 49, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (239, 49, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (240, 49, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (241, 49, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (242, 49, 'block_photos_legende_1_photo_l', '47'); 
INSERT INTO `wp_postmeta` VALUES (243, 49, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (244, 49, 'block_photos_legende_1_photo_r', '48'); 
INSERT INTO `wp_postmeta` VALUES (245, 49, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (246, 49, 'block_photos_legende_1_title', 'Moët & Chandon. Identité visuelle & Packaging. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (247, 49, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (248, 49, 'block_photos_legende_1_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (249, 49, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (250, 49, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (251, 49, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (252, 1, 'block_photos_legende_1_photo_l', '343'); 
INSERT INTO `wp_postmeta` VALUES (253, 1, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (254, 1, 'block_photos_legende_1_photo_r', '344'); 
INSERT INTO `wp_postmeta` VALUES (255, 1, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (256, 1, 'block_photos_legende_1_title', 'Habillages de Brut Impérial et de Brut Impérial Rosé. 2002-2007'); 
INSERT INTO `wp_postmeta` VALUES (257, 1, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (258, 1, 'block_photos_legende_1_subtitle', '> L’ensemble de la gamme avec les habillages et leurs couleurs ainsi que la coupe de la cravate emblématique, ont été redessinés. Le dos de la collerette se dote d\'un médaillon ouvragé.'); 
INSERT INTO `wp_postmeta` VALUES (414, 1, 'block_photos_legende_2_photo_l', '345'); 
INSERT INTO `wp_postmeta` VALUES (259, 1, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (441, 71, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:17:"2014/06/blanc.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"blanc-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"blanc-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:18:"blanc-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"blanc-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"blanc-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (440, 71, '_wp_attached_file', '2014/06/blanc.png'); 
INSERT INTO `wp_postmeta` VALUES (438, 70, '_wp_attached_file', '2014/06/LogoDR.png'); 
INSERT INTO `wp_postmeta` VALUES (439, 70, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:18:"2014/06/LogoDR.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"LogoDR-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"LogoDR-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"LogoDR-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"LogoDR-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"LogoDR-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66192, 1915, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (66180, 1914, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (336, 57, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:900;s:4:"file";s:25:"2014/06/logos_clients.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"logos_clients-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"logos_clients-300x250.png";s:5:"width";i:300;s:6:"height";i:250;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"logos_clients-1024x853.png";s:5:"width";i:1024;s:6:"height";i:853;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"logos_clients-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"logos_clients-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (308, 55, '_wp_attached_file', '2014/07/5ca60eba384626909771e675ff0214041.jpg'); 
INSERT INTO `wp_postmeta` VALUES (309, 55, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:534;s:6:"height";i:700;s:4:"file";s:45:"2014/07/5ca60eba384626909771e675ff0214041.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-228x300.jpg";s:5:"width";i:228;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-534x372.jpg";s:5:"width";i:534;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-534x576.jpg";s:5:"width";i:534;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66181, 1914, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (66532, 1919, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66619, 1920, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66185, 1915, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (66186, 1915, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (66187, 1915, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (66188, 1915, 'block_photos_legende_0_photo_l', '1911'); 
INSERT INTO `wp_postmeta` VALUES (66189, 1915, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66190, 1915, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (66191, 1915, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66179, 1914, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66178, 1914, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66176, 1914, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (66177, 1914, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66175, 1914, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66174, 1914, 'block_photos_legende_3_title', 'Habillages des vins blancs. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66172, 1914, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (335, 57, '_wp_attached_file', '2014/06/logos_clients.png'); 
INSERT INTO `wp_postmeta` VALUES (3422, 257, 'image_1080', '251'); 
INSERT INTO `wp_postmeta` VALUES (359, 63, '_wp_attached_file', '2014/06/logo_MC2.png'); 
INSERT INTO `wp_postmeta` VALUES (360, 63, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:20:"2014/06/logo_MC2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"logo_MC2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"logo_MC2-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"logo_MC2-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"logo_MC2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"logo_MC2-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (361, 64, '_wp_attached_file', '2014/06/brut_imperial.png'); 
INSERT INTO `wp_postmeta` VALUES (362, 64, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/brut_imperial.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"brut_imperial-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"brut_imperial-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"brut_imperial-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"brut_imperial-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"brut_imperial-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (363, 65, '_wp_attached_file', '2014/06/millesime_brut.png'); 
INSERT INTO `wp_postmeta` VALUES (364, 65, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/06/millesime_brut.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"millesime_brut-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"millesime_brut-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"millesime_brut-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"millesime_brut-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"millesime_brut-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (365, 66, '_wp_attached_file', '2014/06/grands_crus01.png'); 
INSERT INTO `wp_postmeta` VALUES (366, 66, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/grands_crus01.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"grands_crus01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"grands_crus01-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"grands_crus01-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"grands_crus01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"grands_crus01-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (367, 67, '_wp_attached_file', '2014/06/vuitton_cup01.png'); 
INSERT INTO `wp_postmeta` VALUES (368, 67, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/vuitton_cup01.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"vuitton_cup01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"vuitton_cup01-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"vuitton_cup01-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"vuitton_cup01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"vuitton_cup01-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (370, 68, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (371, 68, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (372, 68, 'block_photos_legende_0_photo_l', '63'); 
INSERT INTO `wp_postmeta` VALUES (373, 68, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (374, 68, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (375, 68, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (376, 68, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (377, 68, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (378, 68, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (379, 68, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (380, 68, 'block_photos_legende_1_photo_l', '64'); 
INSERT INTO `wp_postmeta` VALUES (381, 68, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (382, 68, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (383, 68, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (384, 68, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (385, 68, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (386, 68, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (387, 68, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (388, 68, 'block_photos_legende_2_photo_l', '65'); 
INSERT INTO `wp_postmeta` VALUES (389, 68, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (390, 68, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (391, 68, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (392, 68, 'block_photos_legende_2_title', 'Moët & Chandon. Identité visuelle & Packaging. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (393, 68, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (394, 68, 'block_photos_legende_2_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (395, 68, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (396, 68, 'block_photos_legende_3_photo_l', '66'); 
INSERT INTO `wp_postmeta` VALUES (397, 68, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (398, 68, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (399, 68, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (400, 68, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (401, 68, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (402, 68, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (403, 68, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (404, 68, 'block_photos_legende_4_photo_l', '67'); 
INSERT INTO `wp_postmeta` VALUES (405, 68, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (406, 68, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (407, 68, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (408, 68, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (409, 68, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (410, 68, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (411, 68, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (412, 68, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (413, 68, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (415, 1, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (416, 1, 'block_photos_legende_2_photo_r', '346'); 
INSERT INTO `wp_postmeta` VALUES (417, 1, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (418, 1, 'block_photos_legende_2_title', 'Habillage des millésimés. 2002'); 
INSERT INTO `wp_postmeta` VALUES (419, 1, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (420, 1, 'block_photos_legende_2_subtitle', '> L’étiquette des millésimés est plus grande et plus opulente.'); 
INSERT INTO `wp_postmeta` VALUES (421, 1, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (422, 1, 'block_photos_legende_3_photo_l', '347'); 
INSERT INTO `wp_postmeta` VALUES (423, 1, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (424, 1, 'block_photos_legende_3_photo_r', '348'); 
INSERT INTO `wp_postmeta` VALUES (425, 1, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (426, 1, 'block_photos_legende_3_title', 'Habillages de la Trilogie des Grands Crus. 2002'); 
INSERT INTO `wp_postmeta` VALUES (427, 1, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (428, 1, 'block_photos_legende_3_subtitle', '• Mettre en avant le savoir-faire œnologique et viticole de la maison en proposant une édition spéciale de grands crus.\r\n> Reprenant les codes des grands vins de Bordeaux, les étiquettes traduisent le terroir de manière authentique plus que festive, sans perdre en préciosité grâce à la sophistication des détails et le numérotage des bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (429, 1, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (430, 1, 'block_photos_legende_4_photo_l', '349'); 
INSERT INTO `wp_postmeta` VALUES (431, 1, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (432, 1, 'block_photos_legende_4_photo_r', '1300'); 
INSERT INTO `wp_postmeta` VALUES (433, 1, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (434, 1, 'block_photos_legende_4_title', 'Habillage de l\'édition limitée Louis Vuitton Cup. 2004 '); 
INSERT INTO `wp_postmeta` VALUES (435, 1, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (436, 1, 'block_photos_legende_4_subtitle', '> La bouteille de Brut Impérial a été habillée aux couleurs de la Louis Vuitton Cup. '); 
INSERT INTO `wp_postmeta` VALUES (437, 1, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (442, 72, '_wp_attached_file', '2014/06/rose2.png'); 
INSERT INTO `wp_postmeta` VALUES (443, 72, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:17:"2014/06/rose2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"rose2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"rose2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:18:"rose2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"rose2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"rose2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (11162, 677, '_block_photos_legende_0_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (11161, 677, 'block_photos_legende_0_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11160, 677, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (11159, 677, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (11158, 677, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (11157, 677, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (11156, 677, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (11155, 677, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (11154, 677, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (11153, 677, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (11152, 677, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (11151, 677, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (11150, 677, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (11149, 677, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (11148, 677, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (11147, 677, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (11146, 677, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (11145, 677, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (11207, 678, '_wp_attached_file', '2014/07/lesclassiques.png'); 
INSERT INTO `wp_postmeta` VALUES (525, 74, '_edit_lock', '1434029101:2'); 
INSERT INTO `wp_postmeta` VALUES (473, 73, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (474, 73, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (475, 73, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (476, 73, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (477, 73, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (478, 73, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (479, 73, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (480, 73, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (481, 73, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (482, 73, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (483, 73, 'block_photos_legende_1_photo_l', '71'); 
INSERT INTO `wp_postmeta` VALUES (484, 73, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (485, 73, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (486, 73, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (487, 73, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (488, 73, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (489, 73, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (490, 73, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (491, 73, 'block_photos_legende_2_photo_l', '72'); 
INSERT INTO `wp_postmeta` VALUES (492, 73, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (493, 73, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (494, 73, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (495, 73, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (496, 73, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (497, 73, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (498, 73, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (499, 73, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (500, 73, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (501, 35, 'block_photos_legende_0_photo_l', '1041'); 
INSERT INTO `wp_postmeta` VALUES (502, 35, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (503, 35, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (504, 35, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (505, 35, 'block_photos_legende_0_title', 'Champagne Dom Ruinart. Design du logo. Dessin et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (506, 35, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (507, 35, 'block_photos_legende_0_subtitle', '• Traduire le caractère patrimonial du fleuron de la plus ancienne maison de champagne.\r\n \r\n      '); 
INSERT INTO `wp_postmeta` VALUES (508, 35, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (509, 35, 'block_photos_legende_1_photo_l', '1132'); 
INSERT INTO `wp_postmeta` VALUES (510, 35, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (511, 35, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (512, 35, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (513, 35, 'block_photos_legende_1_title', 'Packaging et habillages de Dom Ruinart Blanc de Blancs et Dom Ruinart Rosé. 2014'); 
INSERT INTO `wp_postmeta` VALUES (514, 35, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (515, 35, 'block_photos_legende_1_subtitle', '• Apporter de l’élégance et une silhouette contemporaine au packaging, en contraste avec la dimension historique de la marque.\r\n> Le volume du coffret a été rationalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.\r\n[lifting anchor=domruinart lang=fr]Voir l\'évolution du packaging.[/lifting]'); 
INSERT INTO `wp_postmeta` VALUES (516, 35, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (517, 35, 'block_photos_legende_2_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (518, 35, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (519, 35, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (520, 35, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (521, 35, 'block_photos_legende_2_title', 'Habillage de Dom Ruinart Blanc de Blancs. 2014'); 
INSERT INTO `wp_postmeta` VALUES (522, 35, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (523, 35, 'block_photos_legende_2_subtitle', '> Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. Un soin particulier a été apporté aux détails : la coiffe est ornée d\'un blason embossé, l\'étiquette se pare de dorures à chaud et de vernis gonflant pour plus d\'opulence. L\'assemblage de différents caractères typographiques participe de l\'expression de la richesse du goût.'); 
INSERT INTO `wp_postmeta` VALUES (524, 35, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (526, 74, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (527, 75, '_wp_attached_file', '2014/07/logo_Fussigny2.png'); 
INSERT INTO `wp_postmeta` VALUES (528, 75, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:26:"2014/07/logo_Fussigny2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"logo_Fussigny2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"logo_Fussigny2-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"logo_Fussigny2-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"logo_Fussigny2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"logo_Fussigny2-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (529, 76, '_wp_attached_file', '2014/07/bouteille_close_up.png'); 
INSERT INTO `wp_postmeta` VALUES (530, 76, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/bouteille_close_up.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"bouteille_close_up-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"bouteille_close_up-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"bouteille_close_up-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"bouteille_close_up-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"bouteille_close_up-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (531, 77, '_wp_attached_file', '2014/07/XO_1.png'); 
INSERT INTO `wp_postmeta` VALUES (532, 77, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:16:"2014/07/XO_1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"XO_1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"XO_1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"XO_1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"XO_1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"XO_1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (534, 78, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (535, 78, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (536, 78, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (537, 78, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (538, 78, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (539, 78, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (540, 78, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (541, 78, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (542, 78, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (543, 78, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (544, 78, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (545, 78, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (546, 78, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (547, 78, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (548, 78, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (549, 78, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (550, 78, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (551, 78, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (552, 78, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (553, 78, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (554, 78, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (555, 78, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (556, 78, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (557, 78, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (558, 78, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (559, 78, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (560, 78, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (561, 78, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (562, 74, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (563, 74, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (564, 74, 'block_photos_legende_0_photo_l', '2281'); 
INSERT INTO `wp_postmeta` VALUES (565, 74, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (566, 74, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (567, 74, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (568, 74, 'block_photos_legende_0_title', 'Cognac A. de Fussigny. Design du logo. Dessin et typographie. 2001'); 
INSERT INTO `wp_postmeta` VALUES (569, 74, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (570, 74, 'block_photos_legende_0_subtitle', '> Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (571, 74, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (572, 74, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (573, 74, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (574, 74, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (575, 74, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (576, 74, 'block_photos_legende_1_title', 'Placement du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (577, 74, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (578, 74, 'block_photos_legende_1_subtitle', '> Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (579, 74, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (580, 74, 'block_photos_legende_2_photo_l', '320'); 
INSERT INTO `wp_postmeta` VALUES (581, 74, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (582, 74, 'block_photos_legende_2_photo_r', '321'); 
INSERT INTO `wp_postmeta` VALUES (583, 74, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (584, 74, 'block_photos_legende_2_title', 'Exemples d\'utilisation du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (585, 74, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (586, 74, 'block_photos_legende_2_subtitle', '> Les études packaging ont été réalisées par l\'agence Farnham & Associates.'); 
INSERT INTO `wp_postmeta` VALUES (587, 74, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (588, 74, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (589, 74, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (63007, 1354, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (594, 80, '_wp_attached_file', '2014/07/logo_lejay.png'); 
INSERT INTO `wp_postmeta` VALUES (595, 80, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:22:"2014/07/logo_lejay.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"logo_lejay-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"logo_lejay-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"logo_lejay-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"logo_lejay-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"logo_lejay-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (596, 81, '_wp_attached_file', '2014/07/logo_avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (597, 81, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:28:"2014/07/logo_avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"logo_avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"logo_avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"logo_avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"logo_avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"logo_avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (598, 82, '_wp_attached_file', '2014/07/avant_apres_cassis.png'); 
INSERT INTO `wp_postmeta` VALUES (599, 82, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/avant_apres_cassis.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"avant_apres_cassis-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"avant_apres_cassis-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"avant_apres_cassis-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"avant_apres_cassis-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"avant_apres_cassis-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (600, 83, '_wp_attached_file', '2014/07/cremes.png'); 
INSERT INTO `wp_postmeta` VALUES (601, 83, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:18:"2014/07/cremes.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"cremes-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"cremes-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"cremes-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"cremes-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"cremes-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (602, 84, '_wp_attached_file', '2014/07/liqueurs.png'); 
INSERT INTO `wp_postmeta` VALUES (603, 84, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/liqueurs.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"liqueurs-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"liqueurs-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"liqueurs-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"liqueurs-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"liqueurs-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (604, 85, '_wp_attached_file', '2014/07/lejay_US.png'); 
INSERT INTO `wp_postmeta` VALUES (605, 85, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/lejay_US.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"lejay_US-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"lejay_US-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"lejay_US-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"lejay_US-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"lejay_US-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (712, 87, '_edit_lock', '1434029075:2'); 
INSERT INTO `wp_postmeta` VALUES (64471, 1895, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (64472, 1895, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (64473, 1895, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (64474, 1895, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (64475, 1895, 'block_photos_legende_0_photo_l', '1676'); 
INSERT INTO `wp_postmeta` VALUES (64476, 1895, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64773, 1898, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64772, 1898, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64771, 1898, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64770, 1898, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64769, 1898, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64768, 1898, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64767, 1898, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64766, 1898, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64765, 1898, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64764, 1898, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (64763, 1898, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64762, 1898, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64761, 1898, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64760, 1898, 'block_photos_legende_2_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (64759, 1898, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64758, 1898, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64757, 1898, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64756, 1898, 'block_photos_legende_1_subtitle', '• Apporter de l’élégance et une silhouette contemporaine au packaging, en contraste avec la dimension historique de la marque.\r\n> Le volume du coffret a été rationalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (64755, 1898, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64754, 1898, 'block_photos_legende_1_title', 'Packaging et habillages de Dom Ruinart Blanc de Blancs et Dom Ruinart Rosé. 2014'); 
INSERT INTO `wp_postmeta` VALUES (64753, 1898, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64752, 1898, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (63006, 1354, 'block_photos_legende_0_photo_gauche_ipad_h', '2154'); 
INSERT INTO `wp_postmeta` VALUES (63005, 1876, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (63004, 1876, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (63003, 1876, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62996, 1876, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62995, 1876, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62992, 1876, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62986, 1876, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62985, 1876, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62982, 1876, 'block_photos_legende_0_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62976, 1876, 'block_photos_legende_0_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62975, 1876, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62974, 1876, 'block_photos_legende_0_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62972, 1876, 'block_photos_legende_0_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62969, 1876, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62968, 1876, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62967, 1876, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62966, 1876, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62965, 1876, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62963, 1876, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (62962, 1876, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (62958, 1355, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62957, 1355, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62955, 1355, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62954, 1355, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62883, 1874, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (713, 87, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (714, 88, '_wp_attached_file', '2014/07/logo.png'); 
INSERT INTO `wp_postmeta` VALUES (715, 88, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:16:"2014/07/logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (716, 89, '_wp_attached_file', '2014/07/bouteille1.png'); 
INSERT INTO `wp_postmeta` VALUES (717, 89, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/bouteille1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"bouteille1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"bouteille1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"bouteille1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"bouteille1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"bouteille1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (718, 90, '_wp_attached_file', '2014/07/chateau.png'); 
INSERT INTO `wp_postmeta` VALUES (719, 90, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:19:"2014/07/chateau.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"chateau-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"chateau-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"chateau-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"chateau-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"chateau-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (720, 91, '_wp_attached_file', '2014/07/bouteille2.png'); 
INSERT INTO `wp_postmeta` VALUES (721, 91, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/bouteille2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"bouteille2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"bouteille2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"bouteille2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"bouteille2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"bouteille2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (722, 92, '_wp_attached_file', '2014/07/tonneau.png'); 
INSERT INTO `wp_postmeta` VALUES (723, 92, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:19:"2014/07/tonneau.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"tonneau-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"tonneau-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"tonneau-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"tonneau-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"tonneau-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (724, 93, '_wp_attached_file', '2014/07/tonneau1.png'); 
INSERT INTO `wp_postmeta` VALUES (725, 93, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/tonneau1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"tonneau1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"tonneau1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"tonneau1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"tonneau1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"tonneau1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (727, 94, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (728, 94, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (729, 94, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (730, 94, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (731, 94, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (732, 94, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (733, 94, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (734, 94, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (735, 94, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (736, 94, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (737, 94, 'block_photos_legende_1_photo_l', '89'); 
INSERT INTO `wp_postmeta` VALUES (738, 94, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (739, 94, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (740, 94, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (741, 94, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (742, 94, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (743, 94, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (744, 94, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (745, 94, 'block_photos_legende_2_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (746, 94, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (747, 94, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (748, 94, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (749, 94, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (750, 94, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (751, 94, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (752, 94, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (753, 94, 'block_photos_legende_3_photo_l', '91'); 
INSERT INTO `wp_postmeta` VALUES (754, 94, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (755, 94, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (756, 94, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (757, 94, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (758, 94, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (759, 94, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (760, 94, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (761, 94, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (762, 94, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (763, 94, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (764, 94, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (765, 94, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (766, 94, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (767, 94, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (768, 94, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (769, 94, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (770, 94, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (771, 87, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (772, 87, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (773, 87, 'block_photos_legende_0_photo_l', '1994'); 
INSERT INTO `wp_postmeta` VALUES (774, 87, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (775, 87, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (776, 87, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (777, 87, 'block_photos_legende_0_title', 'Domaine du Château de Pommard. Design du logo. Dessin et typographie. 2009'); 
INSERT INTO `wp_postmeta` VALUES (778, 87, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (779, 87, 'block_photos_legende_0_subtitle', '• Redonner ses lettres de noblesse au domaine viticole du Château de Pommard.\r\n'); 
INSERT INTO `wp_postmeta` VALUES (780, 87, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (781, 87, 'block_photos_legende_1_photo_l', '2302'); 
INSERT INTO `wp_postmeta` VALUES (782, 87, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (783, 87, 'block_photos_legende_1_photo_r', '2236'); 
INSERT INTO `wp_postmeta` VALUES (784, 87, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (785, 87, 'block_photos_legende_1_title', 'Évolution des signes'); 
INSERT INTO `wp_postmeta` VALUES (786, 87, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (787, 87, 'block_photos_legende_1_subtitle', '> Pour donner du relief à la marque, nous avons puisé dans son histoire et réinstallé comme identité visuelle un blason utilisé alors pour le marquage des fûts. \r\nLes lions se sont redressés, les armes sont mises en avant et une nouvelle devise vient orner le blason.'); 
INSERT INTO `wp_postmeta` VALUES (788, 87, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (789, 87, 'block_photos_legende_2_photo_l', '352'); 
INSERT INTO `wp_postmeta` VALUES (790, 87, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (791, 87, 'block_photos_legende_2_photo_r', '353'); 
INSERT INTO `wp_postmeta` VALUES (792, 87, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (793, 87, 'block_photos_legende_2_title', 'Habillages des vins rouges. 2009'); 
INSERT INTO `wp_postmeta` VALUES (794, 87, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (795, 87, 'block_photos_legende_2_subtitle', 'En lieu et place de la simple étiquette blanche marquant les vins provenant de cépages voisins, mais vinifiés et mis en bouteille au château, le nouveau blason permet de marquer l’empreinte «Château de Pommard» tout en apportant un supplément de noblesse aux bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (796, 87, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (11163, 677, 'block_photos_legende_1_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (11084, 676, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (11083, 676, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (11082, 676, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (11081, 676, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (11080, 676, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (11075, 676, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (11076, 676, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (813, 87, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (814, 87, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (60653, 1843, '_actu_2_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (818, 96, '_wp_attached_file', '2014/07/logo_remy_martin.png'); 
INSERT INTO `wp_postmeta` VALUES (819, 96, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:28:"2014/07/logo_remy_martin.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"logo_remy_martin-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"logo_remy_martin-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"logo_remy_martin-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"logo_remy_martin-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"logo_remy_martin-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (820, 97, '_wp_attached_file', '2014/07/XO.png'); 
INSERT INTO `wp_postmeta` VALUES (821, 97, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:14:"2014/07/XO.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:14:"XO-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:14:"XO-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:15:"XO-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:14:"XO-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:15:"XO-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (822, 98, '_wp_attached_file', '2014/07/1738_2.png'); 
INSERT INTO `wp_postmeta` VALUES (823, 98, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:18:"2014/07/1738_2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"1738_2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"1738_2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"1738_2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"1738_2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"1738_2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (824, 99, '_wp_attached_file', '2014/07/1898.png'); 
INSERT INTO `wp_postmeta` VALUES (825, 99, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:16:"2014/07/1898.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"1898-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"1898-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"1898-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"1898-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"1898-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (826, 100, '_wp_attached_file', '2014/07/coeur_cognac2.png'); 
INSERT INTO `wp_postmeta` VALUES (827, 100, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/07/coeur_cognac2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"coeur_cognac2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"coeur_cognac2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"coeur_cognac2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"coeur_cognac2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"coeur_cognac2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (62473, 1870, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62472, 1870, 'block_photos_legende_2_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62471, 1870, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62470, 1870, 'block_photos_legende_2_subtitle', '• Expressing the traditional epicurean features of the blackcurrant liquor : the historical and iconic product of the Lejay Lagoute house.\r\n> \'Crème de cassis\' was redesigned in priority over the rest of the range. The new brand identity has been applied to all the packaging elements, notably as a signature on the label, in the manner of the great spirits. Paper material, colours and graphic designs; all is about expressing more sophistication and modernity without weakening the storytelling.'); 
INSERT INTO `wp_postmeta` VALUES (62469, 1870, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62468, 1870, 'block_photos_legende_2_title', 'Crème de cassis label evolution. 2010'); 
INSERT INTO `wp_postmeta` VALUES (62467, 1870, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62466, 1870, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62465, 1870, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62464, 1870, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62463, 1870, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62462, 1870, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62461, 1870, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62460, 1870, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62459, 1870, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62458, 1870, 'block_photos_legende_2_photo_r', '1191'); 
INSERT INTO `wp_postmeta` VALUES (62457, 1870, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62456, 1870, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62455, 1870, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62454, 1870, 'block_photos_legende_2_photo_l', '1190'); 
INSERT INTO `wp_postmeta` VALUES (62453, 1870, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62452, 1870, 'block_photos_legende_1_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62451, 1870, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (60652, 1843, 'actu_2_texte', 'Logo design and typography. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60651, 1843, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60650, 1843, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60649, 1843, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60648, 1843, 'actu_2_lien', '1374'); 
INSERT INTO `wp_postmeta` VALUES (60647, 1843, '_actu_2_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60642, 1843, 'actu_1_texte', 'Visual Identity and design packaging. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60638, 1843, 'actu_1_lien', '1799'); 
INSERT INTO `wp_postmeta` VALUES (60637, 1843, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60636, 1843, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60634, 1843, 'actu_1_image', '971'); 
INSERT INTO `wp_postmeta` VALUES (60630, 1843, 'actu_0_titre', 'Dom Ruinart'); 
INSERT INTO `wp_postmeta` VALUES (60629, 1843, '_actu_0_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60622, 1842, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (60621, 1842, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (60620, 1842, 'actu', '5'); 
INSERT INTO `wp_postmeta` VALUES (60619, 1842, '_actu_4_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60618, 1842, 'actu_4_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60617, 1842, '_actu_4_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60613, 1842, '_actu_4_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60605, 1842, '_actu_3_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60604, 1842, 'actu_3_lien', '136'); 
INSERT INTO `wp_postmeta` VALUES (60603, 1842, '_actu_3_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60602, 1842, 'actu_3_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60601, 1842, '_actu_3_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60598, 1842, 'actu_2_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60590, 1842, 'actu_2_image', '972'); 
INSERT INTO `wp_postmeta` VALUES (60589, 1842, '_actu_1_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60588, 1842, 'actu_1_texte', 'Identité visuelle et design packaging. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60587, 1842, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60586, 1842, 'actu_1_titre', 'Lejay Cassis'); 
INSERT INTO `wp_postmeta` VALUES (60584, 1842, 'actu_1_lien', '1795'); 
INSERT INTO `wp_postmeta` VALUES (60583, 1842, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60573, 1842, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60572, 1842, 'actu_0_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60571, 1842, '_actu_0_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (921, 103, '_wp_attached_file', '2014/07/logoDP.png'); 
INSERT INTO `wp_postmeta` VALUES (922, 103, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:18:"2014/07/logoDP.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"logoDP-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"logoDP-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"logoDP-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"logoDP-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"logoDP-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (923, 104, '_wp_attached_file', '2014/07/etiquette_avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (924, 104, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:33:"2014/07/etiquette_avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"etiquette_avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:33:"etiquette_avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:34:"etiquette_avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:33:"etiquette_avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:34:"etiquette_avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (925, 105, '_wp_attached_file', '2014/07/etiquette_oenotheque.png'); 
INSERT INTO `wp_postmeta` VALUES (926, 105, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:32:"2014/07/etiquette_oenotheque.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:32:"etiquette_oenotheque-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:32:"etiquette_oenotheque-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:33:"etiquette_oenotheque-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:32:"etiquette_oenotheque-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:33:"etiquette_oenotheque-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (927, 106, '_wp_attached_file', '2014/07/vintage_blanc.png'); 
INSERT INTO `wp_postmeta` VALUES (928, 106, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/07/vintage_blanc.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"vintage_blanc-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"vintage_blanc-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"vintage_blanc-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"vintage_blanc-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"vintage_blanc-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66449, 1918, 'block_photos_legende_0_photo_l', '1911'); 
INSERT INTO `wp_postmeta` VALUES (66448, 1918, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (66447, 1918, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (66446, 1918, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (66445, 1918, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66443, 1917, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (66442, 1917, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (66441, 1917, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66440, 1917, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66439, 1917, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66438, 1917, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (66437, 1917, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66436, 1917, 'block_photos_legende_3_title', 'Habillages des vins blancs. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66435, 1917, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66434, 1917, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66433, 1917, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66432, 1917, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66431, 1917, '_block_photos_legende_3_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66430, 1917, 'block_photos_legende_3_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66429, 1917, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66428, 1917, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66427, 1917, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66426, 1917, 'block_photos_legende_3_photo_r', '355'); 
INSERT INTO `wp_postmeta` VALUES (66425, 1917, '_block_photos_legende_3_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66424, 1917, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64912, 1899, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64911, 1899, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64910, 1899, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64909, 1899, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64906, 1899, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64900, 1899, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64899, 1899, 'block_photos_legende_3_photo_l', '333'); 
INSERT INTO `wp_postmeta` VALUES (64897, 1899, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64896, 1899, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64894, 1899, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64893, 1899, 'block_photos_legende_2_title', 'Habillage de Dom Ruinart Blanc de Blancs. 2014'); 
INSERT INTO `wp_postmeta` VALUES (64892, 1899, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64891, 1899, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64889, 1899, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64884, 1899, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64883, 1899, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (64882, 1899, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64881, 1899, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64880, 1899, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64877, 1899, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64874, 1899, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64875, 1899, 'block_photos_legende_1_subtitle', '• Apporter de l’élégance et une silhouette contemporaine au packaging, en contraste avec la dimension historique de la marque.\r\n> Le volume du coffret a été rationalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (1011, 108, '_edit_lock', '1434029446:2'); 
INSERT INTO `wp_postmeta` VALUES (1012, 108, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1013, 109, '_wp_attached_file', '2014/07/logo_garriga.png'); 
INSERT INTO `wp_postmeta` VALUES (1014, 109, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/logo_garriga.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"logo_garriga-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"logo_garriga-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"logo_garriga-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"logo_garriga-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"logo_garriga-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1015, 110, '_wp_attached_file', '2014/07/papeterie_garriga.png'); 
INSERT INTO `wp_postmeta` VALUES (1016, 110, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:29:"2014/07/papeterie_garriga.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"papeterie_garriga-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"papeterie_garriga-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"papeterie_garriga-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"papeterie_garriga-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"papeterie_garriga-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1017, 111, '_wp_attached_file', '2014/07/photo01.png'); 
INSERT INTO `wp_postmeta` VALUES (1018, 111, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:19:"2014/07/photo01.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"photo01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"photo01-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"photo01-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"photo01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"photo01-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1078, 113, '_edit_lock', '1434029410:2'); 
INSERT INTO `wp_postmeta` VALUES (1020, 112, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1021, 112, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1022, 112, 'block_photos_legende_0_photo_l', '109'); 
INSERT INTO `wp_postmeta` VALUES (1023, 112, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1024, 112, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1025, 112, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1026, 112, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1027, 112, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1028, 112, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1029, 112, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1030, 112, 'block_photos_legende_1_photo_l', '110'); 
INSERT INTO `wp_postmeta` VALUES (1031, 112, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1032, 112, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1033, 112, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1034, 112, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1035, 112, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1036, 112, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1037, 112, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1038, 112, 'block_photos_legende_2_photo_l', '111'); 
INSERT INTO `wp_postmeta` VALUES (1039, 112, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1040, 112, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1041, 112, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1042, 112, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1043, 112, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1044, 112, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1045, 112, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1046, 112, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1047, 112, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1048, 108, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1049, 108, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1050, 108, 'block_photos_legende_0_photo_l', '769'); 
INSERT INTO `wp_postmeta` VALUES (1051, 108, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1052, 108, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1053, 108, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1054, 108, 'block_photos_legende_0_title', 'Espace gastronomique La Cuina d\'en Garriga. Design du logo. Dessin et typographie. 2008'); 
INSERT INTO `wp_postmeta` VALUES (1055, 108, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1056, 108, 'block_photos_legende_0_subtitle', '• Créer une identité pour cet espace dédié à la gastronomie et aux arts de la table, au centre de Barcelone.\r\n> L‘identité associe une lettre aux accents vintage à une capitale romaine très bistrot. L’ensemble  exprime l’ambiance vivante du lieu.  Le siphon, clin d’œil à l’histoire personnelle de la propriétaire et à la culture catalane, apporte originalité et sophistication.'); 
INSERT INTO `wp_postmeta` VALUES (1057, 108, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1058, 108, 'block_photos_legende_1_photo_l', '880'); 
INSERT INTO `wp_postmeta` VALUES (1059, 108, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1060, 108, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1061, 108, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1062, 108, 'block_photos_legende_1_title', 'Papeterie et sacs. 2008'); 
INSERT INTO `wp_postmeta` VALUES (1063, 108, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1064, 108, 'block_photos_legende_1_subtitle', 'La papeterie et les sacs mettent en scène l’emblème de la maison.'); 
INSERT INTO `wp_postmeta` VALUES (1065, 108, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1066, 108, 'block_photos_legende_2_photo_l', '580'); 
INSERT INTO `wp_postmeta` VALUES (1067, 108, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1068, 108, 'block_photos_legende_2_photo_r', '581'); 
INSERT INTO `wp_postmeta` VALUES (1069, 108, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1070, 108, 'block_photos_legende_2_title', 'Le lieu'); 
INSERT INTO `wp_postmeta` VALUES (1071, 108, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1072, 108, 'block_photos_legende_2_subtitle', 'La Cuina d’en Garriga est un espace multiple, à la fois épicerie fine, traiteur et table d’hôte.'); 
INSERT INTO `wp_postmeta` VALUES (1073, 108, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1074, 108, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (1075, 108, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1079, 113, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1080, 114, '_wp_attached_file', '2014/07/logo_favarger.png'); 
INSERT INTO `wp_postmeta` VALUES (1081, 114, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:25:"2014/07/logo_favarger.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"logo_favarger-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"logo_favarger-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"logo_favarger-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"logo_favarger-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"logo_favarger-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1082, 115, '_wp_attached_file', '2014/07/evolution_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1083, 115, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/07/evolution_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"evolution_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"evolution_logo-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"evolution_logo-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"evolution_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"evolution_logo-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1084, 116, '_wp_attached_file', '2014/07/tablette_livraison.png'); 
INSERT INTO `wp_postmeta` VALUES (1085, 116, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/tablette_livraison.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"tablette_livraison-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"tablette_livraison-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"tablette_livraison-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"tablette_livraison-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"tablette_livraison-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1144, 118, '_edit_lock', '1434029509:2'); 
INSERT INTO `wp_postmeta` VALUES (1087, 117, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1088, 117, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1089, 117, 'block_photos_legende_0_photo_l', '114'); 
INSERT INTO `wp_postmeta` VALUES (1090, 117, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1091, 117, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1092, 117, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1093, 117, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1094, 117, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1095, 117, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1096, 117, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1097, 117, 'block_photos_legende_1_photo_l', '115'); 
INSERT INTO `wp_postmeta` VALUES (1098, 117, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1099, 117, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1100, 117, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1101, 117, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1102, 117, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1103, 117, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1104, 117, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1105, 117, 'block_photos_legende_2_photo_l', '116'); 
INSERT INTO `wp_postmeta` VALUES (1106, 117, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1107, 117, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1108, 117, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1109, 117, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1110, 117, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1111, 117, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1112, 117, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1113, 117, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1114, 117, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1115, 113, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1116, 113, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1117, 113, 'block_photos_legende_0_photo_l', '767'); 
INSERT INTO `wp_postmeta` VALUES (1118, 113, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1119, 113, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1120, 113, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1121, 113, 'block_photos_legende_0_title', 'Manufacture de chocolats Favarger. Design du logo. Dessin et typographie. 2010'); 
INSERT INTO `wp_postmeta` VALUES (1122, 113, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1123, 113, 'block_photos_legende_0_subtitle', '• Faire de la plus ancienne chocolaterie de Genève une marque ancrée dans le monde du luxe traditionnel dont la ville est la capitale.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1124, 113, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1125, 113, 'block_photos_legende_1_photo_l', '1202'); 
INSERT INTO `wp_postmeta` VALUES (1126, 113, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1127, 113, 'block_photos_legende_1_photo_r', '1203'); 
INSERT INTO `wp_postmeta` VALUES (1128, 113, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1129, 113, 'block_photos_legende_1_title', 'Évolution du logo. 2010'); 
INSERT INTO `wp_postmeta` VALUES (1130, 113, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1131, 113, 'block_photos_legende_1_subtitle', 'Jusqu’alors l’identité utilisait une scripte suggérant la signature du chocolatier, en accord avec la nature familiale de l’entreprise. La typographie, l’architecture symétrique, le blason or, la mention Genève… tous ces codes donnent à la marque une stature de maison de luxe international. La mention originelle « chocolats et cacaos » a été réintroduite afin de souligner le métier de torréfacteur, que la maison a su conserver.'); 
INSERT INTO `wp_postmeta` VALUES (1132, 113, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1133, 113, 'block_photos_legende_2_photo_l', '2824'); 
INSERT INTO `wp_postmeta` VALUES (1134, 113, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1135, 113, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1136, 113, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1137, 113, 'block_photos_legende_2_title', 'Dessin de l\'emblème'); 
INSERT INTO `wp_postmeta` VALUES (1138, 113, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1139, 113, 'block_photos_legende_2_subtitle', '> La forme en cœur du blason, reprenant les armes genevoises, est un clin d’oeil bienvenu, sorte d’ «I love Genève» pour initiés.'); 
INSERT INTO `wp_postmeta` VALUES (1140, 113, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1141, 113, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (1142, 113, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1145, 118, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1146, 119, '_wp_attached_file', '2014/07/logo_cinco.png'); 
INSERT INTO `wp_postmeta` VALUES (1147, 119, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:22:"2014/07/logo_cinco.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"logo_cinco-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"logo_cinco-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"logo_cinco-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"logo_cinco-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"logo_cinco-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1148, 120, '_wp_attached_file', '2014/07/avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (1149, 120, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:23:"2014/07/avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1191, 122, '_edit_lock', '1434102187:2'); 
INSERT INTO `wp_postmeta` VALUES (1151, 121, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1152, 121, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1153, 121, 'block_photos_legende_0_photo_l', '119'); 
INSERT INTO `wp_postmeta` VALUES (1154, 121, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1155, 121, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1156, 121, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1157, 121, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1158, 121, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1159, 121, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1160, 121, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1161, 121, 'block_photos_legende_1_photo_l', '120'); 
INSERT INTO `wp_postmeta` VALUES (1162, 121, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1163, 121, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1164, 121, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1165, 121, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1166, 121, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1167, 121, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1168, 121, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1169, 121, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1170, 121, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1171, 118, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1172, 118, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1173, 118, 'block_photos_legende_0_photo_l', '1113'); 
INSERT INTO `wp_postmeta` VALUES (1174, 118, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1175, 118, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1176, 118, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1177, 118, 'block_photos_legende_0_title', 'Jambon ibérique Cinco Jotas. Design du logo. Dessin et typographie. 2013'); 
INSERT INTO `wp_postmeta` VALUES (1178, 118, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1179, 118, 'block_photos_legende_0_subtitle', 'Prestigieuse maison de jambon ibérique, la marque, très connue en Espagne, fait partie du patrimoine national. Nous avons apporté de la sophistication à l’identité de ce produit raffiné, en mettant en avant le savoir-faire traditionnel que la marque cultive depuis plus de 100 ans.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1180, 118, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1181, 118, 'block_photos_legende_1_photo_l', '1205'); 
INSERT INTO `wp_postmeta` VALUES (1182, 118, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1183, 118, 'block_photos_legende_1_photo_r', '1206'); 
INSERT INTO `wp_postmeta` VALUES (1184, 118, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1185, 118, 'block_photos_legende_1_title', 'Évolution de l\'identité visuelle'); 
INSERT INTO `wp_postmeta` VALUES (1186, 118, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1187, 118, 'block_photos_legende_1_subtitle', '> De la plaque automobile au label d’excellence gastronomique. La médaille, légère et ouvragée et la scripte énergique, traduisent la finesse du savoir-faire.'); 
INSERT INTO `wp_postmeta` VALUES (1188, 118, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1189, 118, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1190, 118, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1192, 122, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1193, 123, '_wp_attached_file', '2014/07/Logo_Scarlett.png'); 
INSERT INTO `wp_postmeta` VALUES (1194, 123, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:25:"2014/07/Logo_Scarlett.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"Logo_Scarlett-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"Logo_Scarlett-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"Logo_Scarlett-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"Logo_Scarlett-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"Logo_Scarlett-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1195, 124, '_wp_attached_file', '2014/07/Packshot2.png'); 
INSERT INTO `wp_postmeta` VALUES (1196, 124, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/Packshot2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"Packshot2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"Packshot2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"Packshot2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"Packshot2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"Packshot2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1238, 126, '_edit_lock', '1434102023:2'); 
INSERT INTO `wp_postmeta` VALUES (1198, 125, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1199, 125, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1200, 125, 'block_photos_legende_0_photo_l', '123'); 
INSERT INTO `wp_postmeta` VALUES (1201, 125, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1202, 125, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1203, 125, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1204, 125, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1205, 125, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1206, 125, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1207, 125, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1208, 125, 'block_photos_legende_1_photo_l', '124'); 
INSERT INTO `wp_postmeta` VALUES (1209, 125, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1210, 125, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1211, 125, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1212, 125, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1213, 125, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1214, 125, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1215, 125, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1216, 125, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1217, 125, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1218, 122, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1219, 122, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1220, 122, 'block_photos_legende_0_photo_l', '525'); 
INSERT INTO `wp_postmeta` VALUES (1221, 122, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1222, 122, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1223, 122, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1224, 122, 'block_photos_legende_0_title', 'Cacharel, parfum Scarlett. Dessin typographique. 2005'); 
INSERT INTO `wp_postmeta` VALUES (1225, 122, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1226, 122, 'block_photos_legende_0_subtitle', '• Donner au parfum Scarlett un caractère romantique en harmonie avec l’esprit originel du logo Cacharel.\r\n> La silhouette générale du prénom, la rondeur et le travail sur la graisse des lettres révèlent une jeune fille sans mièvrerie, plus proche de Johansson que d’O’Hara.\r\nD\'après le design conçu par Akroe.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1227, 122, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (19459, 942, 'block_photos_legende_0_subtitle', '• Création d’une identité pour un parfum signé Cathernie Deneuve.\r\n> La versatilité du rythme de la lettre reflète la vivacité et l’élégance de l’actrice. Le caractère lunaire de son visage, photographié par Avedon pour la campagne publicitaire, nous a inspiré le dessin du monogramme.'); 
INSERT INTO `wp_postmeta` VALUES (19456, 942, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (19454, 942, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (19451, 942, 'block_photos_legende_0_photo_l', '527'); 
INSERT INTO `wp_postmeta` VALUES (1236, 122, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1237, 122, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1239, 126, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1240, 127, '_wp_attached_file', '2014/07/Logo_mugler.png'); 
INSERT INTO `wp_postmeta` VALUES (1241, 127, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:23:"2014/07/Logo_mugler.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"Logo_mugler-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"Logo_mugler-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"Logo_mugler-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"Logo_mugler-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"Logo_mugler-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1242, 128, '_wp_attached_file', '2014/07/avant_apres_mugler.png'); 
INSERT INTO `wp_postmeta` VALUES (1243, 128, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/avant_apres_mugler.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"avant_apres_mugler-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"avant_apres_mugler-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"avant_apres_mugler-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"avant_apres_mugler-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"avant_apres_mugler-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1244, 129, '_wp_attached_file', '2014/07/photo_mugler.png'); 
INSERT INTO `wp_postmeta` VALUES (1245, 129, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:24:"2014/07/photo_mugler.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"photo_mugler-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"photo_mugler-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"photo_mugler-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"photo_mugler-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"photo_mugler-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1303, 131, '_edit_lock', '1434102158:2'); 
INSERT INTO `wp_postmeta` VALUES (1247, 130, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1248, 130, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1249, 130, 'block_photos_legende_0_photo_l', '127'); 
INSERT INTO `wp_postmeta` VALUES (1250, 130, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1251, 130, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1252, 130, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1253, 130, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1254, 130, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1255, 130, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1256, 130, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1257, 130, 'block_photos_legende_1_photo_l', '128'); 
INSERT INTO `wp_postmeta` VALUES (1258, 130, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1259, 130, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1260, 130, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1261, 130, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1262, 130, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1263, 130, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1264, 130, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1265, 130, 'block_photos_legende_2_photo_l', '129'); 
INSERT INTO `wp_postmeta` VALUES (1266, 130, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1267, 130, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1268, 130, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1269, 130, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1270, 130, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1271, 130, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1272, 130, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1273, 130, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1274, 130, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1275, 126, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1276, 126, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1277, 126, 'block_photos_legende_0_photo_l', '1094'); 
INSERT INTO `wp_postmeta` VALUES (1278, 126, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1279, 126, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1280, 126, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1281, 126, 'block_photos_legende_0_title', 'Thierry Mugler, mode et parfums. Dessin du logo. 2004'); 
INSERT INTO `wp_postmeta` VALUES (1282, 126, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1283, 126, 'block_photos_legende_0_subtitle', '• Améliorer la lisibilité du logo en parfumerie, compte-tenu des contraintes de merchandising.\r\n> Le dessin du logo a été tendu et profilé pour s’inscrire dans un espace horizontal standardisé.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1284, 126, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1285, 126, 'block_photos_legende_1_photo_l', '1199'); 
INSERT INTO `wp_postmeta` VALUES (1286, 126, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1287, 126, 'block_photos_legende_1_photo_r', '1200'); 
INSERT INTO `wp_postmeta` VALUES (1288, 126, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1289, 126, 'block_photos_legende_1_title', 'Évolution du logo. 2004'); 
INSERT INTO `wp_postmeta` VALUES (1290, 126, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1291, 126, 'block_photos_legende_1_subtitle', '> Le style incisif de la lettre, dessinée d’après la signature du créateur, n’a rien perdu de sa vivacité, mais le tracé a été équilibré et pérennisé.'); 
INSERT INTO `wp_postmeta` VALUES (1292, 126, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (19615, 946, 'block_photos_legende_0_subtitle', '• Lifting de l’identité à l’occasion du lancement de la première ligne de soin Sonia Rykiel.\r\n> Selon le souhait de la créatrice, cette version de sa griffe a été travaillée pour exprimer puissance et stabilité, à contre-pied de son image évanescente.'); 
INSERT INTO `wp_postmeta` VALUES (19614, 946, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (19613, 946, 'block_photos_legende_0_title', 'Design logo & typographie. 1989 (réalisé pour l’Agence Desgrippes)'); 
INSERT INTO `wp_postmeta` VALUES (19612, 946, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (19610, 946, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (19607, 946, 'block_photos_legende_0_photo_l', '745'); 
INSERT INTO `wp_postmeta` VALUES (1301, 126, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1302, 126, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1304, 131, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1305, 132, '_wp_attached_file', '2014/07/logo_rykiel.png'); 
INSERT INTO `wp_postmeta` VALUES (1306, 132, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:23:"2014/07/logo_rykiel.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"logo_rykiel-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"logo_rykiel-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"logo_rykiel-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"logo_rykiel-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"logo_rykiel-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1307, 133, '_wp_attached_file', '2014/07/logo_rykiel1.png'); 
INSERT INTO `wp_postmeta` VALUES (1308, 133, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/logo_rykiel1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"logo_rykiel1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"logo_rykiel1-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"logo_rykiel1-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"logo_rykiel1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"logo_rykiel1-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1309, 134, '_wp_attached_file', '2014/07/portrait.png'); 
INSERT INTO `wp_postmeta` VALUES (1310, 134, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/portrait.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"portrait-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"portrait-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"portrait-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"portrait-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"portrait-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1352, 136, '_edit_lock', '1434029383:2'); 
INSERT INTO `wp_postmeta` VALUES (1312, 135, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1313, 135, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1314, 135, 'block_photos_legende_0_photo_l', '132'); 
INSERT INTO `wp_postmeta` VALUES (1315, 135, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1316, 135, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1317, 135, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1318, 135, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1319, 135, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1320, 135, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1321, 135, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1322, 135, 'block_photos_legende_1_photo_l', '134'); 
INSERT INTO `wp_postmeta` VALUES (1323, 135, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1324, 135, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1325, 135, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1326, 135, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1327, 135, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1328, 135, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1329, 135, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1330, 135, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1331, 135, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1332, 131, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1333, 131, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1334, 131, 'block_photos_legende_0_photo_l', '1092'); 
INSERT INTO `wp_postmeta` VALUES (1335, 131, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1336, 131, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1337, 131, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1338, 131, 'block_photos_legende_0_title', 'Sonia Rykiel, mode et parfums. Dessin typographique. 1989 '); 
INSERT INTO `wp_postmeta` VALUES (1339, 131, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1340, 131, 'block_photos_legende_0_subtitle', '• Lifting de l’identité à l’occasion du lancement de la première ligne de soins Sonia Rykiel.\r\n> Selon le souhait de la créatrice, cette version de sa griffe a été travaillée pour exprimer force et stabilité, à contre-pied de son image évanescente.\r\nProjet réalisé pour l\'agence Desgrippes Gobé & Associés.'); 
INSERT INTO `wp_postmeta` VALUES (1341, 131, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3086, 220, 'block_photos_legende_0_title', 'Logo design & lettering. 2004'); 
INSERT INTO `wp_postmeta` VALUES (3085, 220, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3084, 220, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3083, 220, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3082, 220, 'block_photos_legende_0_photo_l', '127'); 
INSERT INTO `wp_postmeta` VALUES (3081, 220, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3080, 220, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1350, 131, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1351, 131, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1353, 136, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1354, 137, '_wp_attached_file', '2014/07/Jour_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1355, 137, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:21:"2014/07/Jour_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"Jour_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"Jour_logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"Jour_logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"Jour_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"Jour_logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1357, 138, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (1358, 138, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1359, 138, 'block_photos_legende_0_photo_l', '137'); 
INSERT INTO `wp_postmeta` VALUES (1360, 138, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1361, 138, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1362, 138, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1363, 138, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1364, 138, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1365, 138, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1366, 138, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1367, 138, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1368, 138, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1369, 136, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (1370, 136, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1371, 136, 'block_photos_legende_0_photo_l', '2471'); 
INSERT INTO `wp_postmeta` VALUES (1372, 136, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1373, 136, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1374, 136, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1375, 136, 'block_photos_legende_0_title', 'Parfum Jour d\'Hermès. Design du logo. Dessin typographique. 2012'); 
INSERT INTO `wp_postmeta` VALUES (1376, 136, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1377, 136, 'block_photos_legende_0_subtitle', '• Création d’un logo intemporel pour le nouveau grand parfum de la maison Hermès.\r\n> La typographie cursive modelée tout spécialement, traitée à la manière d’un titre littéraire, surgit naturellement, fluide et aérée.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1378, 136, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1379, 136, 'block_photos_legende', '6'); 
INSERT INTO `wp_postmeta` VALUES (1380, 136, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (58461, 1820, '_logos_5_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (1383, 141, '_wp_attached_file', '2014/07/logo_sofitel_2.png'); 
INSERT INTO `wp_postmeta` VALUES (1384, 141, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:26:"2014/07/logo_sofitel_2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"logo_sofitel_2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"logo_sofitel_2-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"logo_sofitel_2-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"logo_sofitel_2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"logo_sofitel_2-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1385, 142, '_wp_attached_file', '2014/07/signature_system.png'); 
INSERT INTO `wp_postmeta` VALUES (1386, 142, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:28:"2014/07/signature_system.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"signature_system-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"signature_system-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"signature_system-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"signature_system-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"signature_system-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1387, 143, '_wp_attached_file', '2014/07/metropole.png'); 
INSERT INTO `wp_postmeta` VALUES (1388, 143, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/metropole.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"metropole-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"metropole-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"metropole-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"metropole-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"metropole-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1389, 144, '_wp_attached_file', '2014/07/cataract.png'); 
INSERT INTO `wp_postmeta` VALUES (1390, 144, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/cataract.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"cataract-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"cataract-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"cataract-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"cataract-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"cataract-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1391, 145, '_wp_attached_file', '2014/07/the_grand.png'); 
INSERT INTO `wp_postmeta` VALUES (1392, 145, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/the_grand.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"the_grand-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"the_grand-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"the_grand-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"the_grand-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"the_grand-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1482, 147, '_wp_attached_file', '2014/07/stationery_1.png'); 
INSERT INTO `wp_postmeta` VALUES (72050, 2009, '_wp_attached_file', '2014/06/Pierre011.png'); 
INSERT INTO `wp_postmeta` VALUES (72051, 2009, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:559;s:6:"height";i:729;s:4:"file";s:21:"2014/06/Pierre011.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"Pierre011-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"Pierre011-230x300.png";s:5:"width";i:230;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"Pierre011-559x372.png";s:5:"width";i:559;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"Pierre011-559x576.png";s:5:"width";i:559;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (72049, 2008, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (72045, 2008, '_image_texte_1_texte', 'field_546535f076590'); 
INSERT INTO `wp_postmeta` VALUES (72046, 2008, 'image_texte', '2'); 
INSERT INTO `wp_postmeta` VALUES (72047, 2008, '_image_texte', 'field_546535c07658e'); 
INSERT INTO `wp_postmeta` VALUES (72048, 2008, 'footer-text', '© Pierre Katz'); 
INSERT INTO `wp_postmeta` VALUES (58460, 1820, 'logos_5_lien', '1812'); 
INSERT INTO `wp_postmeta` VALUES (58459, 1820, '_logos_5_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58458, 1820, 'logos_5_image', '712'); 
INSERT INTO `wp_postmeta` VALUES (58457, 1820, '_logos_4_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58456, 1820, 'logos_4_lien', '435'); 
INSERT INTO `wp_postmeta` VALUES (58455, 1820, '_logos_4_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58454, 1820, 'logos_4_image', '1817'); 
INSERT INTO `wp_postmeta` VALUES (58452, 1820, 'logos_3_lien', '193'); 
INSERT INTO `wp_postmeta` VALUES (58451, 1820, '_logos_3_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58445, 1820, '_logos_1_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58444, 1820, 'logos_1_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (58443, 1820, '_logos_1_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58442, 1820, 'logos_1_image', '1008'); 
INSERT INTO `wp_postmeta` VALUES (58441, 1820, '_logos_0_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58438, 1820, 'logos_0_image', '1007'); 
INSERT INTO `wp_postmeta` VALUES (58429, 1820, '_baseline-iphone_horizontal', 'field_55075abab3b74'); 
INSERT INTO `wp_postmeta` VALUES (58428, 1820, 'baseline-iphone_horizontal', '1653'); 
INSERT INTO `wp_postmeta` VALUES (58427, 1820, '_baseline-default', 'field_55075a91b3b73'); 
INSERT INTO `wp_postmeta` VALUES (58426, 1820, 'baseline-default', '1639'); 
INSERT INTO `wp_postmeta` VALUES (58425, 1820, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (58424, 1820, 'footer-text', '50, avenue Parmentier 75011 Paris • Tel +33 (0)1 43 38 04 26 • <a href="mailto:contact@pierrekatz.com">contact@pierrekatz.com</a>'); 
INSERT INTO `wp_postmeta` VALUES (58419, 1818, '_logos_22_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58418, 1818, 'logos_22_lien', '1814'); 
INSERT INTO `wp_postmeta` VALUES (58417, 1818, '_logos_22_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58415, 1818, '_logos_21_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58413, 1818, '_logos_21_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58409, 1818, '_logos_20_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58408, 1818, 'logos_20_image', '727'); 
INSERT INTO `wp_postmeta` VALUES (58407, 1818, '_logos_19_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (1483, 147, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:24:"2014/07/stationery_1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"stationery_1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"stationery_1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"stationery_1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"stationery_1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"stationery_1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1484, 148, '_wp_attached_file', '2014/07/stationery_2.png'); 
INSERT INTO `wp_postmeta` VALUES (1485, 148, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:24:"2014/07/stationery_2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"stationery_2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"stationery_2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"stationery_2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"stationery_2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"stationery_2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (57733, 1813, '_block_photos_legende_5_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (72044, 2008, 'image_texte_1_texte', '<a href="http://pierrekatz.com/temp/wp-content/uploads/2014/06/dianealexandre1.jpg"><img class="alignnone wp-image-1274 size-full" src="http://pierrekatz.com/temp/wp-content/uploads/2014/06/dianealexandre1.jpg" alt="" width="510" height="55" /></a><br style="color: #000000;" /><span style="color: #000000;">Diane Alexandre est née en 1983; elle collabore avec Pierre Katz\r\ndepuis 2012.</span>\r\n\r\n&nbsp;\r\n\r\nDiplômée de littérature moderne, elle entre ensuite à l’École nationale supérieure des Arts Décoratifs, puis complète ses études par un master\r\nen communication à Sciences Po Paris.\r\n\r\n&nbsp;\r\n\r\nSoucieuse de comprendre les enjeux marketing en amont des projets,\r\nelle effectue un stage chez L’Oréal, avant de revenir à la création.\r\nS’ouvre alors une période éclectique, pendant laquelle Diane explore une grande variété de domaines d’expression, de l’édition au web design, de\r\nla photographie à la scénographie.\r\n\r\n&nbsp;\r\n\r\nPlus encore que la curiosité naturelle de Diane Alexandre, ce parcours fourmillant traduit l’exigence, la recherche de sens derrière les apparences de la mode ou du design, l’intérêt pour le concept avant le produit, pour\r\nle message en amont de la communication, la démarche intellectuelle au-delà du simple plaisir gestuel...\r\n\r\n&nbsp;\r\n\r\nC’est sur ce terrain que Diane Alexandre et Pierre Katz se rejoignent :\r\nils partagent la même fascination pour les signes, le même enthousiasme\r\nà faire émerger l’identité d’un client, la même abnégation dans la recherche de justesse. Exigence et humilité les caractérisent l’un comme l’autre.\r\n\r\n&nbsp;\r\n\r\nLeur complémentarité est forte, aussi, par le regard neuf que porte Diane Alexandre sur ces marques patrimoniales. En multipliant les sources d’inspiration, en prise directe avec la culture contemporaine, elle contribue\r\nà assurer la pertinence, l’actualité –donc la pérennité– des marques de luxe sur lesquelles elle travaille avec Pierre Katz.'); 
INSERT INTO `wp_postmeta` VALUES (72043, 2008, '_image_texte_1_image_v', 'field_54ff8eb94ab9e'); 
INSERT INTO `wp_postmeta` VALUES (72042, 2008, 'image_texte_1_image_v', '1550'); 
INSERT INTO `wp_postmeta` VALUES (72041, 2008, '_image_texte_1_image_iphone_horizontal', 'field_55077b5f59875'); 
INSERT INTO `wp_postmeta` VALUES (72039, 2008, '_image_texte_1_image', 'field_546535dc7658f'); 
INSERT INTO `wp_postmeta` VALUES (72040, 2008, 'image_texte_1_image_iphone_horizontal', ''); 
INSERT INTO `wp_postmeta` VALUES (72037, 2008, '_image_texte_0_texte', 'field_546535f076590'); 
INSERT INTO `wp_postmeta` VALUES (72038, 2008, 'image_texte_1_image', '2007'); 
INSERT INTO `wp_postmeta` VALUES (58406, 1818, 'logos_19_lien', '563'); 
INSERT INTO `wp_postmeta` VALUES (58405, 1818, '_logos_19_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58403, 1818, '_logos_18_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58401, 1818, '_logos_18_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58400, 1818, 'logos_18_image', '725'); 
INSERT INTO `wp_postmeta` VALUES (58395, 1818, '_logos_16_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (1982, 178, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1981, 178, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (1980, 178, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1979, 178, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1977, 177, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1976, 177, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (57732, 1813, 'block_photos_legende_5_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57730, 1813, 'block_photos_legende_5_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57731, 1813, '_block_photos_legende_5_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (57728, 1813, 'block_photos_legende_5_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57729, 1813, '_block_photos_legende_5_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (57727, 1813, '_block_photos_legende_5_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (57723, 1813, '_block_photos_legende_5_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (57724, 1813, 'block_photos_legende_5_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (57721, 1813, '_block_photos_legende_4_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (57722, 1813, 'block_photos_legende_5_photo_l', '773'); 
INSERT INTO `wp_postmeta` VALUES (57726, 1813, 'block_photos_legende_5_photo_r', '774'); 
INSERT INTO `wp_postmeta` VALUES (57725, 1813, '_block_photos_legende_5_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (57720, 1813, 'block_photos_legende_4_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (57719, 1813, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (57717, 1813, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (57718, 1813, 'block_photos_legende_4_subtitle', '> Chaque logo est retravaillé sur le même principe d’architecture graphique, tout en affirmant sa personnalité géographique et historique.'); 
INSERT INTO `wp_postmeta` VALUES (57716, 1813, 'block_photos_legende_4_title', 'Système graphique des logos d\'hôtels'); 
INSERT INTO `wp_postmeta` VALUES (57715, 1813, '_block_photos_legende_4_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (57713, 1813, '_block_photos_legende_4_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (57714, 1813, 'block_photos_legende_4_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57710, 1813, 'block_photos_legende_4_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57711, 1813, '_block_photos_legende_4_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (57712, 1813, 'block_photos_legende_4_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57709, 1813, '_block_photos_legende_4_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (57708, 1813, 'block_photos_legende_4_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57707, 1813, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (57706, 1813, 'block_photos_legende_4_photo_r', '592'); 
INSERT INTO `wp_postmeta` VALUES (57705, 1813, '_block_photos_legende_4_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (57702, 1813, 'block_photos_legende_4_photo_l', '590'); 
INSERT INTO `wp_postmeta` VALUES (57703, 1813, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (57704, 1813, 'block_photos_legende_4_photo_m', '591'); 
INSERT INTO `wp_postmeta` VALUES (57701, 1813, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (57700, 1813, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (57699, 1813, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (57698, 1813, 'block_photos_legende_3_subtitle', 'La nouvelle identité propose une simplification du monogramme historique foisonnant et coloré, en conservant les particularismes de la lettre victorienne et de ses ornements arabisants.'); 
INSERT INTO `wp_postmeta` VALUES (57670, 1813, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57671, 1813, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (57672, 1813, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (1626, 152, '_wp_attached_file', '2014/07/logo_cointreau_1.png'); 
INSERT INTO `wp_postmeta` VALUES (1627, 152, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:28:"2014/07/logo_cointreau_1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"logo_cointreau_1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"logo_cointreau_1-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"logo_cointreau_1-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"logo_cointreau_1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"logo_cointreau_1-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1628, 153, '_wp_attached_file', '2014/07/Cointreau_Noir_image.png'); 
INSERT INTO `wp_postmeta` VALUES (1629, 153, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:32:"2014/07/Cointreau_Noir_image.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:32:"Cointreau_Noir_image-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:32:"Cointreau_Noir_image-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:33:"Cointreau_Noir_image-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:32:"Cointreau_Noir_image-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:33:"Cointreau_Noir_image-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1672, 155, '_edit_lock', '1434645764:2'); 
INSERT INTO `wp_postmeta` VALUES (62602, 1871, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62601, 1871, 'block_photos_legende_3_photo_l', '333'); 
INSERT INTO `wp_postmeta` VALUES (62600, 1871, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62599, 1871, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62598, 1871, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62597, 1871, 'block_photos_legende_2_subtitle', '> All the packaging elements have been redesigned. The label tends to an oval shape, and the neck wrapping has been elongated to create a slimmer impression. Particular attention has been paid to details : the neck is decorated with an embossed emblem, the label is adorned with gold and varnish for more opulence. The combination of different typefaces expresses of the richness of taste.'); 
INSERT INTO `wp_postmeta` VALUES (62596, 1871, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62595, 1871, 'block_photos_legende_2_title', 'Dom Ruinart Blanc de Blancs habillage. 2014'); 
INSERT INTO `wp_postmeta` VALUES (62531, 1870, '_block_photos_legende_5_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62530, 1870, 'block_photos_legende_5_subtitle', '• Pursuing the premiumisation and internationalisation of Lejay Crème de Cassis as a drink list must-have in the US bars and lounges.\r\n> In consistency with the brand heritage, the bottle presents a vintage look and feel inspired by the \'guinguette\' atmosphere of the French 30’s. The shape itself is adapted from a former bottle of the house, and the labels on the face and neck evoke a blazon. The label design itself has been inspired by an ancient engraving dug up from the house’s archives and framed with an ornamental frieze in the 19th century style. The arms of the Dijon city reinforce the historical and regional heritage. The choice of a satinated paper with silver details brings sophistication and brightness.'); 
INSERT INTO `wp_postmeta` VALUES (62529, 1870, '_block_photos_legende_5_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62528, 1870, 'block_photos_legende_5_title', 'Lejay Cassis. 2013'); 
INSERT INTO `wp_postmeta` VALUES (62527, 1870, '_block_photos_legende_5_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62526, 1870, 'block_photos_legende_5_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62525, 1870, '_block_photos_legende_5_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (1673, 155, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1674, 156, '_wp_attached_file', '2014/07/logo_erro.png'); 
INSERT INTO `wp_postmeta` VALUES (1675, 156, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:21:"2014/07/logo_erro.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"logo_erro-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"logo_erro-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"logo_erro-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"logo_erro-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"logo_erro-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1702, 158, '_edit_lock', '1434029815:2'); 
INSERT INTO `wp_postmeta` VALUES (1677, 157, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1678, 157, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1679, 157, 'block_photos_legende_0_photo_l', '156'); 
INSERT INTO `wp_postmeta` VALUES (1680, 157, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1681, 157, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1682, 157, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1683, 157, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1684, 157, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1685, 157, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1686, 157, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1687, 157, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1688, 157, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1689, 155, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1690, 155, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1691, 155, 'block_photos_legende_0_photo_l', '536'); 
INSERT INTO `wp_postmeta` VALUES (1692, 155, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1693, 155, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1694, 155, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1695, 155, 'block_photos_legende_0_title', 'Musée Erró. Design du logo et typographie. 1994'); 
INSERT INTO `wp_postmeta` VALUES (1696, 155, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1697, 155, 'block_photos_legende_0_subtitle', '• L’artiste islandais Erró souhaitait un logo pour la collection permanente dédiée à ses œuvres, au Musée municipal d\'art de Reykjavík.\r\n> Nous lui avons proposé d’utiliser un de ses dessins préparatoires. Une seule contrainte imposée : la reprise du logo du musée, quatre pieux en bois fichés dans le port de la ville, symbolisant la naissance de l’Islande. Ce signe devient ici un cri, une exclamation qui pourrait s’inscrire dans l’une des œuvres de l’artiste.\r\n\r\n         '); 
INSERT INTO `wp_postmeta` VALUES (1698, 155, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1699, 155, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1700, 155, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1703, 158, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1704, 159, '_wp_attached_file', '2014/07/roger_gallet_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1705, 159, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:29:"2014/07/roger_gallet_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"roger_gallet_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"roger_gallet_logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"roger_gallet_logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"roger_gallet_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"roger_gallet_logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1706, 160, '_wp_attached_file', '2014/07/roger_gallet_avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (1707, 160, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:36:"2014/07/roger_gallet_avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:36:"roger_gallet_avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:36:"roger_gallet_avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:37:"roger_gallet_avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:36:"roger_gallet_avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:37:"roger_gallet_avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1749, 162, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1709, 161, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1710, 161, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1711, 161, 'block_photos_legende_0_photo_l', '159'); 
INSERT INTO `wp_postmeta` VALUES (1712, 161, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1713, 161, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1714, 161, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1715, 161, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1716, 161, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1717, 161, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1718, 161, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1719, 161, 'block_photos_legende_1_photo_l', '160'); 
INSERT INTO `wp_postmeta` VALUES (1720, 161, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1721, 161, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1722, 161, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1723, 161, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1724, 161, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1725, 161, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1726, 161, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1727, 161, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1728, 161, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1729, 158, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1730, 158, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1731, 158, 'block_photos_legende_0_photo_l', '1100'); 
INSERT INTO `wp_postmeta` VALUES (1732, 158, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1733, 158, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1734, 158, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1735, 158, 'block_photos_legende_0_title', 'Savons et parfums Roger & Gallet. Design du logo. Dessin typographique. 2013'); 
INSERT INTO `wp_postmeta` VALUES (1736, 158, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1737, 158, 'block_photos_legende_0_subtitle', 'Le logo institutionnel de Roger & Gallet est né de la volonté de la marque de se doter d\'une nouvelle signature horizontale pour une meilleure visibilité dans les points de vente et en communication publicitaire.'); 
INSERT INTO `wp_postmeta` VALUES (1738, 158, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1739, 158, 'block_photos_legende_1_photo_l', '1208'); 
INSERT INTO `wp_postmeta` VALUES (1740, 158, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1741, 158, 'block_photos_legende_1_photo_r', '1209'); 
INSERT INTO `wp_postmeta` VALUES (1742, 158, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1743, 158, 'block_photos_legende_1_title', 'Évolution du logo institutionnel. 2013'); 
INSERT INTO `wp_postmeta` VALUES (1744, 158, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1745, 158, 'block_photos_legende_1_subtitle', 'La lettre initiale traduisait bien la personnalité de la marque. L’enjeu consistait à l’exprimer de manière contemporaine tout en conservant son caractère historique. Les lettres ont été redessinées avec une plus grande tension, de nouveaux espacements et un traitement délicat des graisses. La nouvelle signature horizontale permet de conserver une grande présence des signes, même en petite taille.'); 
INSERT INTO `wp_postmeta` VALUES (1746, 158, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1747, 158, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1748, 158, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1750, 162, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1751, 162, 'block_photos_legende_0_photo_l', '159'); 
INSERT INTO `wp_postmeta` VALUES (1752, 162, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1753, 162, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1754, 162, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1755, 162, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1756, 162, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1757, 162, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1758, 162, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1759, 162, 'block_photos_legende_1_photo_l', '160'); 
INSERT INTO `wp_postmeta` VALUES (1760, 162, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1761, 162, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1762, 162, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1763, 162, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1764, 162, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1765, 162, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1766, 162, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1767, 162, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1768, 162, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1771, 163, '_edit_lock', '1434101899:2'); 
INSERT INTO `wp_postmeta` VALUES (1772, 163, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1773, 164, '_wp_attached_file', '2014/07/bracelet-pompidou2.jpg'); 
INSERT INTO `wp_postmeta` VALUES (1774, 164, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1111;s:6:"height";i:945;s:4:"file";s:30:"2014/07/bracelet-pompidou2.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"bracelet-pompidou2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:30:"bracelet-pompidou2-300x255.jpg";s:5:"width";i:300;s:6:"height";i:255;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:31:"bracelet-pompidou2-1024x870.jpg";s:5:"width";i:1024;s:6:"height";i:870;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"bracelet-pompidou2-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"bracelet-pompidou2-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1775, 165, '_wp_attached_file', '2014/07/bracelet.png'); 
INSERT INTO `wp_postmeta` VALUES (1776, 165, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:20:"2014/07/bracelet.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"bracelet-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"bracelet-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"bracelet-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"bracelet-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"bracelet-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1803, 167, '_edit_lock', '1434101770:2'); 
INSERT INTO `wp_postmeta` VALUES (1778, 166, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1779, 166, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1780, 166, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (1781, 166, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1782, 166, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1783, 166, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1784, 166, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1785, 166, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1786, 166, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1787, 166, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1788, 166, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1789, 166, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1790, 163, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1791, 163, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1792, 163, 'block_photos_legende_0_photo_l', '796'); 
INSERT INTO `wp_postmeta` VALUES (1793, 163, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1794, 163, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1795, 163, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1796, 163, 'block_photos_legende_0_title', 'Les Amis du Centre Pompidou. Design d\'un bracelet. 1995'); 
INSERT INTO `wp_postmeta` VALUES (1797, 163, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1798, 163, 'block_photos_legende_0_subtitle', 'Un bijou né d’un projet d’identité visuelle. Nous avons  développé un logo (d\'après celui du centre dessiné par Jean Widmer) pour l’association des Amis du Centre Pompidou. Cette création a finalement abouti à l’édition d’un bracelet en argent à cinq cents exemplaires, remis aux hôtes de marque du musée.\r\n\r\n\r\n       '); 
INSERT INTO `wp_postmeta` VALUES (1799, 163, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1800, 163, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1801, 163, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1804, 167, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1805, 168, '_wp_attached_file', '2014/07/lepoint_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1806, 168, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/lepoint_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"lepoint_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"lepoint_logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"lepoint_logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"lepoint_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"lepoint_logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1834, 170, '_wp_attached_file', '2014/07/rose_oenotheque.png'); 
INSERT INTO `wp_postmeta` VALUES (1808, 169, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1809, 169, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1810, 169, 'block_photos_legende_0_photo_l', '168'); 
INSERT INTO `wp_postmeta` VALUES (1811, 169, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1812, 169, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1813, 169, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1814, 169, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1815, 169, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1816, 169, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1817, 169, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1818, 169, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1819, 169, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1820, 167, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1821, 167, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1822, 167, 'block_photos_legende_0_photo_l', '798'); 
INSERT INTO `wp_postmeta` VALUES (1823, 167, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1824, 167, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1825, 167, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1826, 167, 'block_photos_legende_0_title', 'Magazine d\'information Le Point. Design du logo. Dessin de la typographie. 2001'); 
INSERT INTO `wp_postmeta` VALUES (1827, 167, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1828, 167, 'block_photos_legende_0_subtitle', '• Actualiser l’identité du magazine Le Point à l’occasion de la refonte de sa maquette, affirmer la force et la rigueur de l’information par un « coup de poing » visuel.\r\n> Un logo dont la simplicité fait la force : un caractère puissant, inspiré des titrages presse, dont la rondeur renforce l’impact et fait entrer Le Point dans l’ère du numérique.\r\n\r\n      \r\n    '); 
INSERT INTO `wp_postmeta` VALUES (1829, 167, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1830, 167, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1831, 167, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1835, 170, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:27:"2014/07/rose_oenotheque.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:27:"rose_oenotheque-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:27:"rose_oenotheque-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:28:"rose_oenotheque-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:27:"rose_oenotheque-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:28:"rose_oenotheque-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1873, 172, '_wp_attached_file', '2014/07/oenotheque.png'); 
INSERT INTO `wp_postmeta` VALUES (66423, 1917, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66422, 1917, 'block_photos_legende_3_photo_l', '354'); 
INSERT INTO `wp_postmeta` VALUES (66421, 1917, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66420, 1917, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66419, 1917, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66418, 1917, 'block_photos_legende_2_subtitle', 'En lieu et place de la simple étiquette blanche marquant les vins provenant de cépages voisins, mais vinifiés et mis en bouteille au château, le nouveau blason permet de marquer l’empreinte «Château de Pommard» tout en apportant un supplément de noblesse aux bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (66417, 1917, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66416, 1917, 'block_photos_legende_2_title', 'Habillages des vins rouges. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66415, 1917, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66414, 1917, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66413, 1917, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66412, 1917, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66411, 1917, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66410, 1917, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66409, 1917, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66408, 1917, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66407, 1917, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66406, 1917, 'block_photos_legende_2_photo_r', '353'); 
INSERT INTO `wp_postmeta` VALUES (66405, 1917, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66404, 1917, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (1874, 172, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/oenotheque.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"oenotheque-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"oenotheque-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"oenotheque-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"oenotheque-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"oenotheque-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1913, 174, '_wp_attached_file', '2014/07/etiquette_oenotheque1.png'); 
INSERT INTO `wp_postmeta` VALUES (66403, 1917, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66402, 1917, 'block_photos_legende_2_photo_l', '352'); 
INSERT INTO `wp_postmeta` VALUES (66401, 1917, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66400, 1917, 'block_photos_legende_1_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (66399, 1917, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66398, 1917, 'block_photos_legende_1_subtitle', '> Pour donner du relief à la marque, nous avons puisé dans son histoire et réinstallé comme identité visuelle un blason utilisé alors pour le marquage des fûts. \r\nLes lions se sont redressés, les armes sont mises en avant et une nouvelle devise vient orner le blason.'); 
INSERT INTO `wp_postmeta` VALUES (66397, 1917, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66396, 1917, 'block_photos_legende_1_title', 'Évolution des signes'); 
INSERT INTO `wp_postmeta` VALUES (66395, 1917, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66394, 1917, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66393, 1917, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66392, 1917, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66391, 1917, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66390, 1917, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66389, 1917, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66388, 1917, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66387, 1917, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66386, 1917, 'block_photos_legende_1_photo_r', '1605'); 
INSERT INTO `wp_postmeta` VALUES (66385, 1917, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66384, 1917, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (1914, 174, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:33:"2014/07/etiquette_oenotheque1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"etiquette_oenotheque1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:33:"etiquette_oenotheque1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:34:"etiquette_oenotheque1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:33:"etiquette_oenotheque1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:34:"etiquette_oenotheque1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66383, 1917, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66382, 1917, 'block_photos_legende_1_photo_l', '1604'); 
INSERT INTO `wp_postmeta` VALUES (66381, 1917, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66380, 1917, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66379, 1917, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66378, 1917, 'block_photos_legende_0_subtitle', '• Bringing its full nobility to the Chateau de Pommard estate.\r\n'); 
INSERT INTO `wp_postmeta` VALUES (66377, 1917, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66376, 1917, 'block_photos_legende_0_title', 'Logo design, emblem and typography. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66375, 1917, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66374, 1917, 'block_photos_legende_0_photo_gauche_iphone_v', '1749'); 
INSERT INTO `wp_postmeta` VALUES (66373, 1917, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66372, 1917, 'block_photos_legende_0_photo_gauche_iphone_h', '1748'); 
INSERT INTO `wp_postmeta` VALUES (66371, 1917, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66370, 1917, 'block_photos_legende_0_photo_gauche_ipad_v', '1746'); 
INSERT INTO `wp_postmeta` VALUES (66369, 1917, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66368, 1917, 'block_photos_legende_0_photo_gauche_ipad_h', '1745'); 
INSERT INTO `wp_postmeta` VALUES (66367, 1917, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66366, 1917, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (66365, 1917, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66364, 1917, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (1975, 177, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1974, 177, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1973, 177, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1972, 177, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1971, 177, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1970, 177, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1969, 177, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1968, 177, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (1967, 177, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1993, 179, '_wp_attached_file', '2014/07/XO_close_up.png'); 
INSERT INTO `wp_postmeta` VALUES (1966, 177, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1983, 178, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1984, 178, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1985, 178, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1986, 178, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1987, 178, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1988, 178, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1989, 178, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1990, 178, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1994, 179, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:23:"2014/07/XO_close_up.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"XO_close_up-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"XO_close_up-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"XO_close_up-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"XO_close_up-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"XO_close_up-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2040, 181, '_wp_attached_file', '2014/07/saint_aubin.png'); 
INSERT INTO `wp_postmeta` VALUES (62450, 1870, 'block_photos_legende_1_subtitle', '> Instead of the 2 different logos once used for France and international markets, we have rebuilt a single logo with a statutory emblem. The result is a much more premium logo, strengthening the brand’s role in the spirit category whilst keeping its gourmet and friendly personality.'); 
INSERT INTO `wp_postmeta` VALUES (62449, 1870, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62448, 1870, 'block_photos_legende_1_title', 'Visual Identity evolution. 2010'); 
INSERT INTO `wp_postmeta` VALUES (62447, 1870, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62446, 1870, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62445, 1870, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62444, 1870, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62443, 1870, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62442, 1870, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62441, 1870, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62440, 1870, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62439, 1870, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62438, 1870, 'block_photos_legende_1_photo_r', '1189'); 
INSERT INTO `wp_postmeta` VALUES (62437, 1870, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62436, 1870, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62435, 1870, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62434, 1870, 'block_photos_legende_1_photo_l', '1188'); 
INSERT INTO `wp_postmeta` VALUES (62433, 1870, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62432, 1870, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62431, 1870, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62430, 1870, 'block_photos_legende_0_subtitle', '• Upgrading the French fruit liquor to an international brand used as cocktail ingredient all over the world. \r\n> The jay has been inspired by an ancient engraving and redesigned in a realistic, lively manner. Perched on a branch, it crowns the brand name written in Art Nouveau style, with the letter J evoking a bird claw.'); 
INSERT INTO `wp_postmeta` VALUES (2041, 181, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:23:"2014/07/saint_aubin.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"saint_aubin-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"saint_aubin-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"saint_aubin-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"saint_aubin-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"saint_aubin-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2087, 183, '_wp_attached_file', '2014/07/chassagne.png'); 
INSERT INTO `wp_postmeta` VALUES (2043, 182, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2044, 182, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2045, 182, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2046, 182, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2047, 182, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2048, 182, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2049, 182, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2050, 182, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2051, 182, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2052, 182, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2053, 182, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2054, 182, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2055, 182, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2056, 182, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2057, 182, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2058, 182, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2059, 182, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2060, 182, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2061, 182, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2062, 182, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2063, 182, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2064, 182, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2065, 182, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2066, 182, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2067, 182, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2068, 182, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2069, 182, 'block_photos_legende_3_photo_l', '91'); 
INSERT INTO `wp_postmeta` VALUES (2070, 182, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2071, 182, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2072, 182, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2073, 182, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2074, 182, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2075, 182, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2076, 182, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2077, 182, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2078, 182, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2079, 182, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2080, 182, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2081, 182, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2082, 182, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2083, 182, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2084, 182, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2085, 182, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2086, 182, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2088, 183, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/chassagne.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"chassagne-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"chassagne-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"chassagne-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"chassagne-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"chassagne-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2134, 185, '_wp_attached_file', '2014/07/chassagne1.png'); 
INSERT INTO `wp_postmeta` VALUES (2090, 184, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2091, 184, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2092, 184, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2093, 184, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2094, 184, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2095, 184, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2096, 184, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2097, 184, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2098, 184, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2099, 184, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2100, 184, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2101, 184, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2102, 184, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2103, 184, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2104, 184, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2105, 184, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2106, 184, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2107, 184, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2108, 184, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2109, 184, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2110, 184, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2111, 184, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2112, 184, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2113, 184, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2114, 184, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2115, 184, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2116, 184, 'block_photos_legende_3_photo_l', '183'); 
INSERT INTO `wp_postmeta` VALUES (2117, 184, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2118, 184, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2119, 184, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2120, 184, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2121, 184, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2122, 184, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2123, 184, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2124, 184, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2125, 184, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2126, 184, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2127, 184, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2128, 184, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2129, 184, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2130, 184, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2131, 184, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2132, 184, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2133, 184, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2135, 185, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/chassagne1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"chassagne1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"chassagne1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"chassagne1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"chassagne1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"chassagne1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2137, 186, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2138, 186, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2139, 186, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2140, 186, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2141, 186, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2142, 186, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2143, 186, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2144, 186, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2145, 186, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2146, 186, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2147, 186, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2148, 186, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2149, 186, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2150, 186, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2151, 186, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2152, 186, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2153, 186, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2154, 186, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2155, 186, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2156, 186, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2157, 186, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2158, 186, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2159, 186, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2160, 186, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2161, 186, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2162, 186, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2163, 186, 'block_photos_legende_3_photo_l', '185'); 
INSERT INTO `wp_postmeta` VALUES (2164, 186, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2165, 186, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2166, 186, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2167, 186, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2168, 186, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2169, 186, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2170, 186, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2171, 186, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2172, 186, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2173, 186, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2174, 186, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2175, 186, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2176, 186, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2177, 186, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2178, 186, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2179, 186, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2180, 186, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2183, 187, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2184, 187, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2185, 187, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (2186, 187, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2187, 187, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2188, 187, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2189, 187, 'block_photos_legende_0_title', 'A. de Fussigny\r\n2001'); 
INSERT INTO `wp_postmeta` VALUES (2190, 187, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2191, 187, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham.\r\nLes couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème \r\nqui vient couronner la marque à la manière d’un blason.\r\nL’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (2192, 187, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2193, 187, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (2194, 187, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2195, 187, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2196, 187, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2197, 187, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2198, 187, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2199, 187, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2200, 187, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2201, 187, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (2202, 187, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2203, 187, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2204, 187, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2205, 187, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2206, 187, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2207, 187, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2208, 187, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2209, 187, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2210, 187, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2285, 190, 'block_photos_legende_1_subtitle', 'Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (2284, 190, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2283, 190, 'block_photos_legende_1_title', 'Logo placing. 2001'); 
INSERT INTO `wp_postmeta` VALUES (2282, 190, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2278, 190, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2279, 190, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (2280, 190, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2281, 190, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2277, 190, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (2276, 190, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2275, 190, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (2274, 190, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2273, 190, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2272, 190, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2271, 190, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (2270, 190, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2269, 190, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2240, 189, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2241, 189, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2242, 189, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (2243, 189, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2244, 189, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2245, 189, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2246, 189, 'block_photos_legende_0_title', 'A. de Fussigny\r\n2001'); 
INSERT INTO `wp_postmeta` VALUES (2247, 189, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2248, 189, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (2249, 189, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2250, 189, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (2251, 189, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2252, 189, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2253, 189, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2254, 189, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2255, 189, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2256, 189, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2257, 189, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2258, 189, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (2259, 189, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2260, 189, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2261, 189, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2262, 189, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2263, 189, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2264, 189, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2265, 189, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2266, 189, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2267, 189, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2286, 190, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2287, 190, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (2288, 190, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2289, 190, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2290, 190, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2291, 190, 'block_photos_legende_2_title', 'à écrire'); 
INSERT INTO `wp_postmeta` VALUES (2292, 190, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2293, 190, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2294, 190, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2295, 190, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2296, 190, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2298, 191, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2299, 191, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2300, 191, 'block_photos_legende_0_photo_l', '123'); 
INSERT INTO `wp_postmeta` VALUES (2301, 191, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2302, 191, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2303, 191, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2304, 191, 'block_photos_legende_0_title', 'Logo design and lettering. 2005'); 
INSERT INTO `wp_postmeta` VALUES (2305, 191, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2306, 191, 'block_photos_legende_0_subtitle', 'Il s’agissait de travailler la physionomie, la graisse et la silhouette générale du nom, pour retrouver l’esprit original du logo Cacharel ; de faire naître du prénom Scarlett des lettres rondes, un caractère : celui d’une jeune fille romantique des années 2000, plus proche de Johansson que d’O’Hara.'); 
INSERT INTO `wp_postmeta` VALUES (2307, 191, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2308, 191, 'block_photos_legende_1_photo_l', '124'); 
INSERT INTO `wp_postmeta` VALUES (2309, 191, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2310, 191, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2311, 191, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2312, 191, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2313, 191, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2314, 191, 'block_photos_legende_1_subtitle', 'à préciser le nom de l\'agence responsable de la créa packaging et de la créa pub.'); 
INSERT INTO `wp_postmeta` VALUES (2315, 191, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2316, 191, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (2317, 191, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (19453, 942, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (4362, 368, '_wp_attached_file', '2014/07/scarlett02.png'); 
INSERT INTO `wp_postmeta` VALUES (4363, 368, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:384;s:6:"height";i:500;s:4:"file";s:22:"2014/07/scarlett02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"scarlett02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"scarlett02-230x300.png";s:5:"width";i:230;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"scarlett02-384x372.png";s:5:"width";i:384;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (4361, 367, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:675;s:6:"height";i:500;s:4:"file";s:22:"2014/07/scarlett01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"scarlett01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"scarlett01-300x222.png";s:5:"width";i:300;s:6:"height";i:222;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"scarlett01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (4360, 367, '_wp_attached_file', '2014/07/scarlett01.png'); 
INSERT INTO `wp_postmeta` VALUES (2338, 193, '_edit_lock', '1434032986:2'); 
INSERT INTO `wp_postmeta` VALUES (2339, 193, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (2340, 194, '_wp_attached_file', '2014/07/logo_deneuve.png'); 
INSERT INTO `wp_postmeta` VALUES (2341, 194, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/logo_deneuve.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"logo_deneuve-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"logo_deneuve-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"logo_deneuve-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"logo_deneuve-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"logo_deneuve-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2343, 195, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2344, 195, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2345, 195, 'block_photos_legende_0_photo_l', '194'); 
INSERT INTO `wp_postmeta` VALUES (2346, 195, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2347, 195, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2348, 195, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2349, 195, 'block_photos_legende_0_title', 'Logo design and lettering. 1990'); 
INSERT INTO `wp_postmeta` VALUES (2350, 195, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2351, 195, 'block_photos_legende_0_subtitle', 'La création de l’identité visuelle du parfum «Catherine Deneuve» partait d’un brief concis : Catherine Deneuve. La versatilité du rythme reflète à la fois la vivacité et l’élégance du personnage.\r\nProjet réalisé dans le cadre d’une précédente activité dans l’agence Desgrippes.'); 
INSERT INTO `wp_postmeta` VALUES (2352, 195, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2353, 195, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2354, 195, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2355, 193, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2356, 193, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2357, 193, 'block_photos_legende_0_photo_l', '1249'); 
INSERT INTO `wp_postmeta` VALUES (2358, 193, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2359, 193, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2360, 193, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2361, 193, 'block_photos_legende_0_title', 'Parfums Cathernie Deneuve. Design du logo. Dessin typographique. 1990 '); 
INSERT INTO `wp_postmeta` VALUES (2362, 193, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2363, 193, 'block_photos_legende_0_subtitle', '• Création d’une identité pour les parfums Catherine Deneuve.\r\n> La versatilité du rythme de la lettre reflète la vivacité et l’élégance de l’actrice. Le caractère lumineux de son visage, photographié par Avedon pour la campagne publicitaire, nous a inspiré le dessin du monogramme.\r\nProjet réalisé pour l\'agence Desgrippes Gobé & Associés.'); 
INSERT INTO `wp_postmeta` VALUES (2364, 193, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2365, 193, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2366, 193, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2402, 198, 'block_photos_legende_0_subtitle', 'Un bijou né d’un projet d’identité visuelle. Nous avons  développé un logo pour l’association des Amis du Centre Pompidou. Cette création a finalement abouti à l’édition d’un bracelet en argent à 500 exemplaires, remis aux hôtes de marque des amis du musée.'); 
INSERT INTO `wp_postmeta` VALUES (2401, 198, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2397, 198, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2398, 198, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2399, 198, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2400, 198, 'block_photos_legende_0_title', 'Design. 1995'); 
INSERT INTO `wp_postmeta` VALUES (2396, 198, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (2395, 198, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2394, 198, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (2380, 197, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2381, 197, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2382, 197, 'block_photos_legende_0_photo_l', '194'); 
INSERT INTO `wp_postmeta` VALUES (2383, 197, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2384, 197, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2385, 197, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2386, 197, 'block_photos_legende_0_title', 'Logo design and lettering. 1990'); 
INSERT INTO `wp_postmeta` VALUES (2387, 197, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2388, 197, 'block_photos_legende_0_subtitle', 'La création de l’identité visuelle du parfum «Catherine Deneuve» partait d’un brief concis : Catherine Deneuve. La versatilité du rythme reflète à la fois la vivacité et l’élégance du personnage. Projet réalisé dans le cadre d’une précédente activité dans l’agence Desgrippes.'); 
INSERT INTO `wp_postmeta` VALUES (2389, 197, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2390, 197, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2391, 197, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2403, 198, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2404, 198, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2405, 198, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (14552, 796, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:28:"2014/07/pompidoubracelet.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"pompidoubracelet-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"pompidoubracelet-300x138.jpg";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:29:"pompidoubracelet-1024x474.jpg";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"pompidoubracelet-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"pompidoubracelet-1038x500.jpg";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (14551, 796, '_wp_attached_file', '2014/07/pompidoubracelet.jpg'); 
INSERT INTO `wp_postmeta` VALUES (2876, 214, '_wp_attached_file', '2014/07/avant_apres_RM.png'); 
INSERT INTO `wp_postmeta` VALUES (2419, 200, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2420, 200, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2421, 200, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2422, 200, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2423, 200, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2424, 200, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2425, 200, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2009'); 
INSERT INTO `wp_postmeta` VALUES (2426, 200, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2427, 200, 'block_photos_legende_0_subtitle', 'La refonte de l’identité du domaine visait à redonner ses armes au château, à transmettre la nature baroque et bonne vivante de la Bourgogne. '); 
INSERT INTO `wp_postmeta` VALUES (2428, 200, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2429, 200, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2430, 200, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2431, 200, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2432, 200, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2433, 200, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2434, 200, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2435, 200, 'block_photos_legende_1_subtitle', 'Auparavant seule une étiquette  blanche passe-partout marquait les bouteilles des vins provenant de cépages voisins, vinifiés, mis en bouteille et commercialisés au château.'); 
INSERT INTO `wp_postmeta` VALUES (2436, 200, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2437, 200, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2438, 200, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2439, 200, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2440, 200, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2441, 200, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2442, 200, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2443, 200, 'block_photos_legende_2_subtitle', 'Le nouveau blason permet de marquer l’empreinte du château sans le nommer et de rehausser l’image des bouteilles. '); 
INSERT INTO `wp_postmeta` VALUES (2444, 200, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2445, 200, 'block_photos_legende_3_photo_l', '185'); 
INSERT INTO `wp_postmeta` VALUES (2446, 200, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2447, 200, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2448, 200, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2449, 200, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2450, 200, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2451, 200, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2452, 200, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2453, 200, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2454, 200, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2455, 200, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2456, 200, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2457, 200, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2458, 200, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2459, 200, 'block_photos_legende_4_subtitle', 'Pour donner du relief à la marque, nous avons puisé dans son histoire et réinstallé comme identité visuelle un blason utilisé alors pour le marquage des fûts. Les lions se sont redressés, les armes sont mises en avant et une nouvelle devise vient orner le blason.'); 
INSERT INTO `wp_postmeta` VALUES (2460, 200, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2461, 200, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2462, 200, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11063, 87, 'block_photos_legende_1_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11065, 87, 'block_photos_legende_2_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11066, 87, '_block_photos_legende_2_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (11077, 676, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (11078, 676, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (11079, 676, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (2464, 201, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2465, 201, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2466, 201, 'block_photos_legende_0_photo_l', '119'); 
INSERT INTO `wp_postmeta` VALUES (2467, 201, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2468, 201, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2469, 201, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2470, 201, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2471, 201, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2472, 201, 'block_photos_legende_0_subtitle', 'Prestigieuse maison de jambon ibérique, la marque, très connue en Espagne, fait partie du patrimoine local. Nous avons apporté de la sophistication à l’identité de ce produit raffiné, en mettant en avant le savoir-faire traditionnel que la marque cultive depuis plus de 100 ans.'); 
INSERT INTO `wp_postmeta` VALUES (2473, 201, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2474, 201, 'block_photos_legende_1_photo_l', '120'); 
INSERT INTO `wp_postmeta` VALUES (2475, 201, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2476, 201, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2477, 201, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2478, 201, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2479, 201, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2480, 201, 'block_photos_legende_1_subtitle', 'De la plaque automobile au label d’excellence gastronomique. La médaille, légère et ouvragée et la scripte énergique, traduisent la finesse du savoir-faire.'); 
INSERT INTO `wp_postmeta` VALUES (2481, 201, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2482, 201, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (2483, 201, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62594, 1871, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62593, 1871, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62592, 1871, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62591, 1871, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62590, 1871, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62588, 1871, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62589, 1871, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62587, 1871, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62586, 1871, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62585, 1871, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (62584, 1871, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62583, 1871, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62582, 1871, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62581, 1871, 'block_photos_legende_2_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (62580, 1871, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66363, 1917, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66362, 1917, 'block_photos_legende_0_photo_l', '1911'); 
INSERT INTO `wp_postmeta` VALUES (66361, 1917, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (66360, 1917, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (66359, 1917, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (66358, 1917, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66356, 1916, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (66352, 1916, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66353, 1916, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66354, 1916, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66355, 1916, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (66351, 1916, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (66350, 1916, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66349, 1916, 'block_photos_legende_3_title', 'Habillages des vins blancs. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66348, 1916, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66347, 1916, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66342, 1916, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66343, 1916, 'block_photos_legende_3_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66344, 1916, '_block_photos_legende_3_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66345, 1916, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66346, 1916, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66341, 1916, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66340, 1916, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66339, 1916, 'block_photos_legende_3_photo_r', '355'); 
INSERT INTO `wp_postmeta` VALUES (66338, 1916, '_block_photos_legende_3_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66337, 1916, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (66336, 1916, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66332, 1916, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66333, 1916, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66334, 1916, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66335, 1916, 'block_photos_legende_3_photo_l', '354'); 
INSERT INTO `wp_postmeta` VALUES (66331, 1916, 'block_photos_legende_2_subtitle', 'En lieu et place de la simple étiquette blanche marquant les vins provenant de cépages voisins, mais vinifiés et mis en bouteille au château, le nouveau blason permet de marquer l’empreinte «Château de Pommard» tout en apportant un supplément de noblesse aux bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (66329, 1916, 'block_photos_legende_2_title', 'Habillages des vins rouges. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66330, 1916, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66328, 1916, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66327, 1916, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64903, 1899, 'block_photos_legende_3_photo_r', '334'); 
INSERT INTO `wp_postmeta` VALUES (64904, 1899, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64905, 1899, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64895, 1899, 'block_photos_legende_2_subtitle', '> Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. Un soin particulier a été apporté aux détails : la coiffe est ornée d\'un blason embossé, l\'étiquette se pare de dorures à chaud et de vernis gonflant pour plus d\'opulence. L\'assemblage de différents caractères typographiques participe de l\'expression de la richesse du goût.'); 
INSERT INTO `wp_postmeta` VALUES (64885, 1899, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64886, 1899, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64887, 1899, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64888, 1899, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64876, 1899, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2543, 204, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2544, 204, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2545, 204, 'block_photos_legende_0_photo_l', '156'); 
INSERT INTO `wp_postmeta` VALUES (2546, 204, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2547, 204, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2548, 204, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2549, 204, 'block_photos_legende_0_title', 'Logo design. 1994'); 
INSERT INTO `wp_postmeta` VALUES (2550, 204, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2551, 204, 'block_photos_legende_0_subtitle', 'L’artiste islandais Erró souhaitait un logo pour la collection permanente dédiée à ses œuvres, au musée d’art contemporain de Reykjavík. Nous lui avons proposé d’utiliser un de ses dessins préparatoires. Une seule contrainte était imposée : la reprise du logo du musée, quatre pieux en bois fichés dans le port de la ville, symbolisant la naissance de l’Islande. Ce signe devient ici un cri, une exclamation qui pourrait  s’inscrire dans l’une des œuvres d’Erró.'); 
INSERT INTO `wp_postmeta` VALUES (2552, 204, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2553, 204, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2554, 204, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2556, 205, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2557, 205, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2558, 205, 'block_photos_legende_0_photo_l', '114'); 
INSERT INTO `wp_postmeta` VALUES (2559, 205, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2560, 205, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2561, 205, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2562, 205, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2010'); 
INSERT INTO `wp_postmeta` VALUES (2563, 205, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2564, 205, 'block_photos_legende_0_subtitle', 'Favarger est la plus ancienne fabrique de chocolat de Genève. La reprise de l’affaire familiale par un nouveau propriétaire marquait le repositionnement luxe de la marque. Le brief était succinct : Genève est la capitale mondiale du luxe, Faverger en sera une institution.'); 
INSERT INTO `wp_postmeta` VALUES (2565, 205, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2566, 205, 'block_photos_legende_1_photo_l', '115'); 
INSERT INTO `wp_postmeta` VALUES (2567, 205, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2568, 205, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2569, 205, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2570, 205, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2571, 205, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2572, 205, 'block_photos_legende_1_subtitle', 'Jusqu’alors l’identité utilisait une scripte suggérant la signature du chocolatier, en accord avec la nature familiale de l’entreprise. La marque change radicalement avec une refonte de ses processus de fabrication, de ses produits et de son image. La mention originelle «chocolats et cacaos» est réintroduite afin de souligner le métier de torréfacteur, que la maison Favarger a su conserver. La nouvelle marque s’ancre désormais dans le patrimoine du luxe genevois. '); 
INSERT INTO `wp_postmeta` VALUES (2573, 205, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2574, 205, 'block_photos_legende_2_photo_l', '116'); 
INSERT INTO `wp_postmeta` VALUES (2575, 205, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2576, 205, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2577, 205, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2578, 205, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2579, 205, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2580, 205, 'block_photos_legende_2_subtitle', 'Revisiter la forme du blason pour en en faire ressortir un cœur, tel un «I love Genève» pour initiés, fut un clin d’oeil bienvenu qui fut par la suite transposé sur les nouvelles tablettes.\r\nLa boutique Favarger est située Quai des Bergues, à quelques pas de l’adresse initiale de la manufacture. Le logo orne le fronton de la façade et circule tous les jours dans les rues de Genève.'); 
INSERT INTO `wp_postmeta` VALUES (2581, 205, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2582, 205, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2583, 205, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (30135, 113, 'block_photos_legende_3_photo_l', '390'); 
INSERT INTO `wp_postmeta` VALUES (30136, 113, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (30137, 113, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (19723, 949, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2585, 207, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2586, 207, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2587, 207, 'block_photos_legende_0_photo_l', '109'); 
INSERT INTO `wp_postmeta` VALUES (2588, 207, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2589, 207, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2590, 207, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2591, 207, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2008'); 
INSERT INTO `wp_postmeta` VALUES (2592, 207, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2593, 207, 'block_photos_legende_0_subtitle', 'La Cuina d’en Garriga est un espace dédié à la gastronomie au centre de Barcelone. La propriétaire y partage sa passion pour les produits authentiques. Le siphon fait partie de son histoire personnelle et de la culture catalane. Nous avons ensuite recherché des caractères évoquant la personnalité du lieu. L’identité associe une lettre aux accents vintage, à une capitale romaine au caractère plus rustique.'); 
INSERT INTO `wp_postmeta` VALUES (2594, 207, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2595, 207, 'block_photos_legende_1_photo_l', '110'); 
INSERT INTO `wp_postmeta` VALUES (2596, 207, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2597, 207, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2598, 207, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2599, 207, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2600, 207, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2601, 207, 'block_photos_legende_1_subtitle', 'Stationery.'); 
INSERT INTO `wp_postmeta` VALUES (2602, 207, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2603, 207, 'block_photos_legende_2_photo_l', '111'); 
INSERT INTO `wp_postmeta` VALUES (2604, 207, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2605, 207, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2606, 207, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2607, 207, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2608, 207, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2609, 207, 'block_photos_legende_2_subtitle', 'Le lieux.'); 
INSERT INTO `wp_postmeta` VALUES (2610, 207, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2611, 207, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2612, 207, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (27481, 1110, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2614, 208, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2615, 208, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2616, 208, 'block_photos_legende_0_photo_l', '137'); 
INSERT INTO `wp_postmeta` VALUES (2617, 208, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2618, 208, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2619, 208, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2620, 208, 'block_photos_legende_0_title', 'Logo design and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2621, 208, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2622, 208, 'block_photos_legende_0_subtitle', 'Pour la création de son nouveau parfum de référence, la maison Hermès souhaitait un logo intemporel. La cursive dessinée pour l’occasion, traitée à la manière d’un titre littéraire, surgit ici, fluide et aérée.'); 
INSERT INTO `wp_postmeta` VALUES (2623, 208, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2624, 208, 'block_photos_legende_1_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (2625, 208, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2626, 208, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2627, 208, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2628, 208, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2629, 208, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2630, 208, 'block_photos_legende_1_subtitle', 'Dans un second temps, nous avons défini la forme graphique et le placement des éléments, sur le flacon conçu par Pierre Hardy et l’étui pensé par Laurence Hovart. Le logo vient couronner l’ex-libris d’Emile Hermès, le fondateur de la maison. Sur l’étui d’un blanc solaire, il émerge en bas-relief, n’apparaissant que dans un jeu d’ombre et de lumière.'); 
INSERT INTO `wp_postmeta` VALUES (2631, 208, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2632, 208, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (2633, 208, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2634, 136, 'block_photos_legende_1_photo_l', '2468'); 
INSERT INTO `wp_postmeta` VALUES (2635, 136, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2636, 136, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2637, 136, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2638, 136, 'block_photos_legende_1_title', 'Mise en place du logo sur le flacon et sur l\'étui Jour d\'Hermès. 2012'); 
INSERT INTO `wp_postmeta` VALUES (2639, 136, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2640, 136, 'block_photos_legende_1_subtitle', 'Dans un second temps, nous avons défini le placement du logo sur le flacon conçu par Pierre Hardy et l’étui pensé par Laurence Hovart. Le logo vient couronner l’ex-libris d’Emile Hermès, le fondateur de la maison. Sur l’étui d’un blanc solaire, il émerge en bas-relief, n’apparaissant que dans un jeu d’ombre et de lumière.'); 
INSERT INTO `wp_postmeta` VALUES (2641, 136, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2643, 209, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2644, 209, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2645, 209, 'block_photos_legende_0_photo_l', '137'); 
INSERT INTO `wp_postmeta` VALUES (2646, 209, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2647, 209, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2648, 209, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2649, 209, 'block_photos_legende_0_title', 'Jour d\'Hermès. Logo design and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2650, 209, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2651, 209, 'block_photos_legende_0_subtitle', 'Pour la création de son nouveau parfum de référence, la maison Hermès souhaitait un logo intemporel. La cursive dessinée pour l’occasion, traitée à la manière d’un titre littéraire, surgit ici, fluide et aérée.'); 
INSERT INTO `wp_postmeta` VALUES (2652, 209, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2653, 209, 'block_photos_legende_1_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (2654, 209, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2655, 209, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2656, 209, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2657, 209, 'block_photos_legende_1_title', 'Jour d\'Hermès. Logo placing & packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2658, 209, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2659, 209, 'block_photos_legende_1_subtitle', 'Dans un second temps, nous avons défini la forme graphique et le placement des éléments, sur le flacon conçu par Pierre Hardy et l’étui pensé par Laurence Hovart. Le logo vient couronner l’ex-libris d’Emile Hermès, le fondateur de la maison. Sur l’étui d’un blanc solaire, il émerge en bas-relief, n’apparaissant que dans un jeu d’ombre et de lumière.'); 
INSERT INTO `wp_postmeta` VALUES (2660, 209, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2661, 209, 'block_photos_legende_2_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (2662, 209, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2663, 209, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2664, 209, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2665, 209, 'block_photos_legende_2_title', 'Les Classiques. Logo design and lettering. 2014'); 
INSERT INTO `wp_postmeta` VALUES (2666, 209, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2667, 209, 'block_photos_legende_2_subtitle', 'La collection des Classiques Hermès réunit les parfums historiques de la Maison. Ils sont conditionnés dans\r\nun flacon unique, dessiné par Martin Szekely. Le principe de l’étiquette permet de singulariser chaque parfum dans un contenant qui les normalise, grâce à la reprise de l’identité graphique et colorielle de chacun. L’ex-libris d’Emile Hermès, déjà présent sur Eau d’Hermès, parfum originel de la Maison, a été déployé sur l’ensemble de cette collection. Chaque étiquette présente en son verso une vignette surprise, dessinée par Philipe Dumas, patinée de colle et perçue à travers le jus du parfum. '); 
INSERT INTO `wp_postmeta` VALUES (2668, 209, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2669, 209, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2670, 209, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (18889, 932, 'block_photos_legende_1_title', 'Jour d\'Hermès. Logo placing & packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (18887, 932, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (18888, 932, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (18886, 932, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (18878, 932, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (18879, 932, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (18880, 932, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (18881, 932, 'block_photos_legende_0_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (18882, 932, '_block_photos_legende_0_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (18883, 932, 'block_photos_legende_1_photo_l', '680'); 
INSERT INTO `wp_postmeta` VALUES (18884, 932, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (18885, 932, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64751, 1898, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64750, 1898, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64749, 1898, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64748, 1898, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64747, 1898, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64746, 1898, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64742, 1898, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64743, 1898, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64744, 1898, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64745, 1898, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64741, 1898, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64740, 1898, 'block_photos_legende_1_photo_l', '1132'); 
INSERT INTO `wp_postmeta` VALUES (64739, 1898, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64738, 1898, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64735, 1898, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64736, 1898, 'block_photos_legende_0_subtitle', '• Traduire le caractère patrimonial du fleuron de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (64737, 1898, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64734, 1898, 'block_photos_legende_0_title', 'Design du logo. Dessin de l\'emblème et de la typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (64733, 1898, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64732, 1898, 'block_photos_legende_0_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64728, 1898, 'block_photos_legende_0_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64729, 1898, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64730, 1898, 'block_photos_legende_0_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64731, 1898, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64727, 1898, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64726, 1898, 'block_photos_legende_0_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64725, 1898, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64724, 1898, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64723, 1898, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64722, 1898, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64720, 1898, 'block_photos_legende_0_photo_l', '1041'); 
INSERT INTO `wp_postmeta` VALUES (64721, 1898, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64719, 1898, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (64717, 1898, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (65746, 1909, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (64718, 1898, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (64716, 1898, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (64711, 1897, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (64708, 1897, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64709, 1897, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64710, 1897, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (64707, 1897, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64706, 1897, 'block_photos_legende_2_subtitle', '> Les études packaging ont été réalisées par l\'agence Farnham & Associates.'); 
INSERT INTO `wp_postmeta` VALUES (64705, 1897, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64704, 1897, 'block_photos_legende_2_title', 'Exemples d\'utilisations du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (64695, 1897, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64696, 1897, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64697, 1897, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64698, 1897, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64699, 1897, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64700, 1897, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64701, 1897, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64702, 1897, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64703, 1897, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64694, 1897, 'block_photos_legende_2_photo_r', '321'); 
INSERT INTO `wp_postmeta` VALUES (64693, 1897, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (63002, 1876, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62999, 1876, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (63000, 1876, 'block_photos_legende_1_subtitle', '> The lettering, designed after the fashion designer’s signature, has kept its sharp style, while gaining some balance and timeless character.'); 
INSERT INTO `wp_postmeta` VALUES (62989, 1876, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62990, 1876, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62991, 1876, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62978, 1876, 'block_photos_legende_0_title', 'Logo design. 2004'); 
INSERT INTO `wp_postmeta` VALUES (62979, 1876, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62980, 1876, 'block_photos_legende_0_subtitle', '• Improving the logo legibility on shelves, taking account of the merchandising constraints. \r\n> The logo design has been straighten and outlined in order to correspond to a standard horizontal space.'); 
INSERT INTO `wp_postmeta` VALUES (62971, 1876, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62960, 1876, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (62961, 1876, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62885, 1874, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62886, 1874, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62887, 1874, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62888, 1874, 'block_photos_legende_1_title', 'Labelling and packaging. 200'); 
INSERT INTO `wp_postmeta` VALUES (62889, 1874, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62890, 1874, 'block_photos_legende_1_subtitle', '• Keeping the iconic Cointreau square bottle, magnified with a luxury twist.\r\n> The copper metallic colour of cognac alambics conveys the exclusivity of the product and brings some visibility in night premises.'); 
INSERT INTO `wp_postmeta` VALUES (62891, 1874, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62892, 1874, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62893, 1874, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62894, 1874, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (62895, 1874, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62897, 1875, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (62898, 1875, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62899, 1875, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (62900, 1875, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (62901, 1875, 'block_photos_legende_0_photo_l', '1151'); 
INSERT INTO `wp_postmeta` VALUES (62902, 1875, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62903, 1875, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62904, 1875, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62905, 1875, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62906, 1875, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62907, 1875, 'block_photos_legende_0_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62908, 1875, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62909, 1875, 'block_photos_legende_0_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62910, 1875, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62911, 1875, 'block_photos_legende_0_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62912, 1875, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62913, 1875, 'block_photos_legende_0_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62914, 1875, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62915, 1875, 'block_photos_legende_0_title', 'Logo design and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (62916, 1875, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62917, 1875, 'block_photos_legende_0_subtitle', '• Creating a truly timeless identity for the new fragrance of the Hermès House.\r\n> The cursive typography has been specially created in a very literary manner, in order to add an airy and flowing impression to the steady bottle and pack.'); 
INSERT INTO `wp_postmeta` VALUES (62918, 1875, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62919, 1875, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62920, 1875, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62921, 1875, 'block_photos_legende_1_photo_l', '680'); 
INSERT INTO `wp_postmeta` VALUES (62922, 1875, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62923, 1875, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62924, 1875, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62925, 1875, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62926, 1875, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62927, 1875, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62928, 1875, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62929, 1875, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62930, 1875, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62931, 1875, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62932, 1875, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62933, 1875, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62934, 1875, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62935, 1875, 'block_photos_legende_1_title', 'Logo placement. 2013'); 
INSERT INTO `wp_postmeta` VALUES (62936, 1875, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62937, 1875, 'block_photos_legende_1_subtitle', '> When it came to the logo placement on the bottle designed by Pierre Hardy and on the packaging by Laurence Hovart, we had to work with Emile Hermès’ ex-libris (he was the founder of the house). On the white pack, it stands out embossed, revealed by a play of light and shadows.'); 
INSERT INTO `wp_postmeta` VALUES (62938, 1875, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62939, 1875, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62940, 1875, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62941, 1875, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (62942, 1875, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62943, 1355, 'block_photos_legende_0_photo_gauche_ipad_h', '2473'); 
INSERT INTO `wp_postmeta` VALUES (62944, 1355, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62945, 1355, 'block_photos_legende_0_photo_gauche_ipad_v', '2474'); 
INSERT INTO `wp_postmeta` VALUES (62946, 1355, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62947, 1355, 'block_photos_legende_0_photo_gauche_iphone_h', '2475'); 
INSERT INTO `wp_postmeta` VALUES (62948, 1355, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62949, 1355, 'block_photos_legende_0_photo_gauche_iphone_v', '2476'); 
INSERT INTO `wp_postmeta` VALUES (62950, 1355, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66841, 1923, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62951, 1355, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62952, 1355, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62953, 1355, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (2787, 212, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2788, 212, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2789, 212, 'block_photos_legende_0_photo_l', '63'); 
INSERT INTO `wp_postmeta` VALUES (2790, 212, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2791, 212, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2792, 212, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2793, 212, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (2794, 212, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2795, 212, 'block_photos_legende_0_subtitle', 'Nous avons revisité les signes de la marque Moët & Chandon à l’occasion de la refonte complète de la gamme. L’emblème de Moët est une combinaison de la couronne impériale et de la tiare papale. Il a été redessiné, tout comme le lettrage, dont les pleins et déliés ont été accentués.'); 
INSERT INTO `wp_postmeta` VALUES (2796, 212, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2797, 212, 'block_photos_legende_1_photo_l', '64'); 
INSERT INTO `wp_postmeta` VALUES (2798, 212, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2799, 212, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2800, 212, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2801, 212, 'block_photos_legende_1_title', 'Brut Impérial. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2802, 212, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2803, 212, 'block_photos_legende_1_subtitle', 'L’ensemble de la gamme avec les habillages et leurs couleurs ainsi que la coupe de la cravate emblématique, ont été repensés.'); 
INSERT INTO `wp_postmeta` VALUES (2804, 212, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2805, 212, 'block_photos_legende_2_photo_l', '65'); 
INSERT INTO `wp_postmeta` VALUES (2806, 212, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2807, 212, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2808, 212, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2809, 212, 'block_photos_legende_2_title', 'Millésimé Vintage. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2810, 212, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2811, 212, 'block_photos_legende_2_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (2812, 212, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2813, 212, 'block_photos_legende_3_photo_l', '66'); 
INSERT INTO `wp_postmeta` VALUES (2814, 212, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2815, 212, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2816, 212, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2817, 212, 'block_photos_legende_3_title', 'Grands Crus. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2818, 212, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2819, 212, 'block_photos_legende_3_subtitle', 'L’enjeu était de mettre en avant le savoir-faire œnologique et viticole de la maison en proposant une édition spéciale de grands crus, reprenant les codes des grands vins de Bordeaux.'); 
INSERT INTO `wp_postmeta` VALUES (2820, 212, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2821, 212, 'block_photos_legende_4_photo_l', '67'); 
INSERT INTO `wp_postmeta` VALUES (2822, 212, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2823, 212, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2824, 212, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2825, 212, 'block_photos_legende_4_title', 'Louis Vuitton Cup limited edition. Labelling design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2826, 212, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2827, 212, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2828, 212, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2829, 212, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2830, 212, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2832, 213, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2833, 213, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2834, 213, 'block_photos_legende_0_photo_l', '63'); 
INSERT INTO `wp_postmeta` VALUES (2835, 213, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2836, 213, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2837, 213, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2838, 213, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (2839, 213, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2840, 213, 'block_photos_legende_0_subtitle', 'Nous avons revisité les signes de la marque Moët & Chandon à l’occasion de la refonte complète de la gamme. L’emblème de Moët est une combinaison de la couronne impériale et de la tiare papale. Il a été redessiné, tout comme le lettrage, dont les pleins et déliés ont été accentués.'); 
INSERT INTO `wp_postmeta` VALUES (2841, 213, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2842, 213, 'block_photos_legende_1_photo_l', '64'); 
INSERT INTO `wp_postmeta` VALUES (2843, 213, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2844, 213, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2845, 213, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2846, 213, 'block_photos_legende_1_title', 'Brut Impérial. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2847, 213, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2848, 213, 'block_photos_legende_1_subtitle', 'L’ensemble de la gamme avec les habillages et leurs couleurs ainsi que la coupe de la cravate emblématique, ont été repensés.'); 
INSERT INTO `wp_postmeta` VALUES (2849, 213, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2850, 213, 'block_photos_legende_2_photo_l', '65'); 
INSERT INTO `wp_postmeta` VALUES (2851, 213, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2852, 213, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2853, 213, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2854, 213, 'block_photos_legende_2_title', 'Millésimé Vintage. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2855, 213, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2856, 213, 'block_photos_legende_2_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (2857, 213, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2858, 213, 'block_photos_legende_3_photo_l', '66'); 
INSERT INTO `wp_postmeta` VALUES (2859, 213, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2860, 213, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2861, 213, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2862, 213, 'block_photos_legende_3_title', 'Grands Crus. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2863, 213, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2864, 213, 'block_photos_legende_3_subtitle', 'L’enjeu était de mettre en avant le savoir-faire œnologique et viticole de la maison en proposant une édition spéciale de grands crus, reprenant les codes des grands vins de Bordeaux.'); 
INSERT INTO `wp_postmeta` VALUES (2865, 213, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2866, 213, 'block_photos_legende_4_photo_l', '67'); 
INSERT INTO `wp_postmeta` VALUES (2867, 213, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2868, 213, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2869, 213, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2870, 213, 'block_photos_legende_4_title', 'Louis Vuitton Cup limited edition. Labelling design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2871, 213, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2872, 213, 'block_photos_legende_4_subtitle', 'Dans le cadre d’un partenariat événementiel avec Louis Vuitton,  la bouteille de Brut Impérial a été habillée aux couleurs de la Louis Vuitton Cup. '); 
INSERT INTO `wp_postmeta` VALUES (2873, 213, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2874, 213, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2875, 213, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (19284, 939, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2877, 214, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/07/avant_apres_RM.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"avant_apres_RM-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"avant_apres_RM-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"avant_apres_RM-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"avant_apres_RM-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"avant_apres_RM-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3151, 223, '_wp_attached_file', '2014/07/logo_lejay1.png'); 
INSERT INTO `wp_postmeta` VALUES (62429, 1870, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62428, 1870, 'block_photos_legende_0_title', 'Logo design, emblem drawing and lettering. 2010'); 
INSERT INTO `wp_postmeta` VALUES (62427, 1870, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62426, 1870, 'block_photos_legende_0_photo_gauche_iphone_v', '1787'); 
INSERT INTO `wp_postmeta` VALUES (62425, 1870, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62424, 1870, 'block_photos_legende_0_photo_gauche_iphone_h', '1786'); 
INSERT INTO `wp_postmeta` VALUES (62422, 1870, 'block_photos_legende_0_photo_gauche_ipad_v', '1785'); 
INSERT INTO `wp_postmeta` VALUES (62423, 1870, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62421, 1870, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62420, 1870, 'block_photos_legende_0_photo_gauche_ipad_h', '1784'); 
INSERT INTO `wp_postmeta` VALUES (62419, 1870, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62418, 1870, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62417, 1870, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62416, 1870, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62415, 1870, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62412, 1870, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (62413, 1870, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (62414, 1870, 'block_photos_legende_0_photo_l', '751'); 
INSERT INTO `wp_postmeta` VALUES (62411, 1870, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62410, 1870, 'subtitle_name', ''); 
INSERT INTO `wp_postmeta` VALUES (62408, 1869, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62407, 1869, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (62406, 1869, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62405, 1869, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62404, 1869, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62403, 1869, 'block_photos_legende_3_subtitle', '> This collection presents Dom Pérignon ancient vintages. The black and silver packaging was created under Karl Lagerfeld artistic direction.'); 
INSERT INTO `wp_postmeta` VALUES (62402, 1869, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62401, 1869, 'block_photos_legende_3_title', 'Œnothèque Vintages label. 2008'); 
INSERT INTO `wp_postmeta` VALUES (62399, 1869, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62400, 1869, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62396, 1869, '_block_photos_legende_3_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62397, 1869, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62398, 1869, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62395, 1869, 'block_photos_legende_3_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62394, 1869, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62393, 1869, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62391, 1869, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62392, 1869, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62390, 1869, '_block_photos_legende_3_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62387, 1869, 'block_photos_legende_3_photo_l', '174'); 
INSERT INTO `wp_postmeta` VALUES (62388, 1869, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62389, 1869, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62386, 1869, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62385, 1869, 'block_photos_legende_2_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62384, 1869, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62381, 1869, 'block_photos_legende_2_title', 'Label evolution. 2003-2007'); 
INSERT INTO `wp_postmeta` VALUES (62382, 1869, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62383, 1869, 'block_photos_legende_2_subtitle', '> All the different typographies have been streamlined. The vine branches and the star have been minutely redesigned. On the top of the label, Moët & Chandon has been replaced with the monk’s name and the date of his appointment at Hautvillers abbey.'); 
INSERT INTO `wp_postmeta` VALUES (62380, 1869, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (60646, 1843, 'actu_2_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60639, 1843, '_actu_1_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60640, 1843, 'actu_1_titre', 'Lejay Cassis'); 
INSERT INTO `wp_postmeta` VALUES (60641, 1843, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60633, 1843, '_actu_0_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60627, 1843, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60628, 1843, 'actu_0_lien', '1348'); 
INSERT INTO `wp_postmeta` VALUES (60610, 1842, 'actu_4_image', '974'); 
INSERT INTO `wp_postmeta` VALUES (60611, 1842, '_actu_4_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60612, 1842, 'actu_4_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60594, 1842, 'actu_2_lien', '118'); 
INSERT INTO `wp_postmeta` VALUES (60595, 1842, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60596, 1842, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60597, 1842, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60580, 1842, 'actu_1_image', '971'); 
INSERT INTO `wp_postmeta` VALUES (60581, 1842, '_actu_1_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60582, 1842, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60570, 1842, 'actu_0_image', '1179'); 
INSERT INTO `wp_postmeta` VALUES (60569, 1841, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (60568, 1841, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (60567, 1841, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (60560, 1841, 'actu_4_lien', '158'); 
INSERT INTO `wp_postmeta` VALUES (60561, 1841, '_actu_4_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60562, 1841, 'actu_4_titre', 'Roger & Gallet'); 
INSERT INTO `wp_postmeta` VALUES (60563, 1841, '_actu_4_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60564, 1841, 'actu_4_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60484, 1840, 'actu_2_image', '972'); 
INSERT INTO `wp_postmeta` VALUES (60485, 1840, '_actu_2_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60486, 1840, 'actu_2_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60487, 1840, '_actu_2_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60488, 1840, 'actu_2_lien', '1374'); 
INSERT INTO `wp_postmeta` VALUES (60489, 1840, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60490, 1840, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60491, 1840, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60492, 1840, 'actu_2_texte', 'Logo design and typography. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60493, 1840, '_actu_2_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60494, 1840, 'actu_3_image', '973'); 
INSERT INTO `wp_postmeta` VALUES (60495, 1840, '_actu_3_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60496, 1840, 'actu_3_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60497, 1840, '_actu_3_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60498, 1840, 'actu_3_lien', '1355'); 
INSERT INTO `wp_postmeta` VALUES (60499, 1840, '_actu_3_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60500, 1840, 'actu_3_titre', 'Jour d\'Hermès'); 
INSERT INTO `wp_postmeta` VALUES (60501, 1840, '_actu_3_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60502, 1840, 'actu_3_texte', 'Logo design and typography. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60503, 1840, '_actu_3_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60504, 1840, 'actu_4_image', '974'); 
INSERT INTO `wp_postmeta` VALUES (60505, 1840, '_actu_4_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60506, 1840, 'actu_4_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60507, 1840, '_actu_4_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60508, 1840, 'actu_4_lien', '1356'); 
INSERT INTO `wp_postmeta` VALUES (60509, 1840, '_actu_4_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60510, 1840, 'actu_4_titre', 'Roger & Gallet'); 
INSERT INTO `wp_postmeta` VALUES (60511, 1840, '_actu_4_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60512, 1840, 'actu_4_texte', 'Logo design and typography. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60513, 1840, '_actu_4_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60514, 1840, 'actu', '5'); 
INSERT INTO `wp_postmeta` VALUES (60515, 1840, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (60516, 1841, 'actu_0_image', '1179'); 
INSERT INTO `wp_postmeta` VALUES (60517, 1841, '_actu_0_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60518, 1841, 'actu_0_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60519, 1841, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60520, 1841, 'actu_0_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (60521, 1841, '_actu_0_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60522, 1841, 'actu_0_titre', 'Dom Ruinart'); 
INSERT INTO `wp_postmeta` VALUES (60523, 1841, '_actu_0_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60524, 1841, 'actu_0_texte', 'Identité visuelle et design packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60525, 1841, '_actu_0_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60526, 1841, 'actu_1_image', '971'); 
INSERT INTO `wp_postmeta` VALUES (60527, 1841, '_actu_1_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60528, 1841, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60529, 1841, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60530, 1841, 'actu_1_lien', '1795'); 
INSERT INTO `wp_postmeta` VALUES (60531, 1841, '_actu_1_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60532, 1841, 'actu_1_titre', 'Lejay Cassis'); 
INSERT INTO `wp_postmeta` VALUES (60533, 1841, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60534, 1841, 'actu_1_texte', 'Identité visuelle et design packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60535, 1841, '_actu_1_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60536, 1841, 'actu_2_image', '972'); 
INSERT INTO `wp_postmeta` VALUES (60537, 1841, '_actu_2_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60538, 1841, 'actu_2_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60539, 1841, '_actu_2_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60540, 1841, 'actu_2_lien', '118'); 
INSERT INTO `wp_postmeta` VALUES (60541, 1841, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60542, 1841, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60543, 1841, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60544, 1841, 'actu_2_texte', 'Design logo et typographie. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60545, 1841, '_actu_2_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60546, 1841, 'actu_3_image', '973'); 
INSERT INTO `wp_postmeta` VALUES (60547, 1841, '_actu_3_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60548, 1841, 'actu_3_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60549, 1841, '_actu_3_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60550, 1841, 'actu_3_lien', '136'); 
INSERT INTO `wp_postmeta` VALUES (60551, 1841, '_actu_3_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60552, 1841, 'actu_3_titre', 'Jour d\'Hermès'); 
INSERT INTO `wp_postmeta` VALUES (60553, 1841, '_actu_3_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60554, 1841, 'actu_3_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60555, 1841, '_actu_3_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60556, 1841, 'actu_4_image', '974'); 
INSERT INTO `wp_postmeta` VALUES (60557, 1841, '_actu_4_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60558, 1841, 'actu_4_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (2993, 217, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2994, 217, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2995, 217, 'block_photos_legende_0_photo_l', '159'); 
INSERT INTO `wp_postmeta` VALUES (2996, 217, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2997, 217, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2998, 217, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2999, 217, 'block_photos_legende_0_title', 'Logo design & lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3000, 217, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3001, 217, 'block_photos_legende_0_subtitle', 'Le logo institutionnel de Roger & Gallet est né de la volonté de la marque de se doter d’une signature horizontale et de s’affranchir du macaron des étiquettes utilisé jusqu’alors comme logo institutionnel. Son dessin et sa nouvelle structure lui confèrent une bien meilleure visibilité.'); 
INSERT INTO `wp_postmeta` VALUES (3002, 217, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3003, 217, 'block_photos_legende_1_photo_l', '160'); 
INSERT INTO `wp_postmeta` VALUES (3004, 217, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3005, 217, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3006, 217, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3007, 217, 'block_photos_legende_1_title', 'Logo design before & after. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3008, 217, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3009, 217, 'block_photos_legende_1_subtitle', 'La lettre initiale traduisait bien la personnalité de la marque. L’enjeu consistait à l’exprimer de manière contemporaine tout en conservant son historicité. Les lettres ont été redessinées avec une plus grande tension, de nouveaux espacements et un traitement délicat des graisses. La nouvelle signature horizontale permet ainsi de conserver une grande présence du signe, même en petite taille.'); 
INSERT INTO `wp_postmeta` VALUES (3010, 217, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3011, 217, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (3012, 217, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (29621, 1158, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (72036, 2008, 'image_texte_0_texte', '<a href="http://pierrekatz.com/temp/wp-content/uploads/2014/06/Un-artisan-des-signes3.jpg"><img class="alignnone wp-image-1286 size-full" src="http://pierrekatz.com/temp/wp-content/uploads/2014/06/Un-artisan-des-signes3.jpg" alt="Un-artisan-des-signes" width="510" height="55" /></a>\r\n\r\nNé à Paris en 1959, d’une famille cosmopolite, Pierre Katz est fasciné dès\r\nl’enfance par l’expression graphique et ce qu’il nommera plus tard «le\r\nmonde des signes».\r\n\r\n&nbsp;\r\n\r\nSon père médecin collectionneur d’art et sa mère chanteuse lyrique reçoivent de nombreux artistes, et c’est en observant un peintre surréaliste tracer un dessin automatique qu’il perçoit pour la première fois «l’évidence du geste révélateur du sens, comme un prolongement de l’esprit». Dès lors –il a 8 ans– il ne cesse de dessiner, laissant libre cours à son imagination et déliant son trait dans des arabesques fantasmagoriques.\r\n\r\n&nbsp;\r\n\r\nPlus tard, l’amour des lettres canalisera la compulsion du dessin. Lycéen\r\nlatiniste, passionné de littérature, il est particulièrement sensible à l’étymologie, et remontant le fil de l’humanité, se passionne pour l’histoire\r\nde l’imprimerie, de l’écriture, et l’art premier des signes qui symbolisent\r\nle monde sensible, transcrivent l’expérience commune à tous les hommes indépendamment de leur culture.\r\n\r\n&nbsp;\r\n\r\n«Choisir un mot et renforcer sa signification par un graphisme approprié». Pierre Katz se souvient de la consigne de l’épreuve de dessin du baccalauréat car elle l’ouvre au monde de la typographie.\r\nCette discipline, au sens le plus rigoureux du terme, séduit tout à la fois\r\nle littéraire, l’architecte et l’artiste. Il la définit comme «un artisanat\r\nde précision qui impose de maîtriser la forme jusqu’à son aboutissement : l’adéquation parfaite, naturelle et sans fioritures avec le fond».\r\nAlors le dessin s’efface sous la lettre, née d’un équilibre subtil et pourtant\r\nsi affirmée.\r\n\r\n&nbsp;\r\n\r\nDe sa rencontre avec Peter Knapp, directeur artistique du magazine Elle,\r\nà l\'école Penninghen, de la fréquentation des grands typographes français, américains et suisses, à ses débuts chez Carré Noir et Desgrippes, Pierre Katz retient des enseignements mais surtout l’envie de suivre sa propre voie.\r\nAutodidacte en perpétuelle recherche, il collectionne les ouvrages de typographie, explore la calligraphie de l’anglaise à la japonaise, et aborde\r\nla sémiologie, les sciences cognitives et la psychanalyse.\r\n\r\n&nbsp;\r\n\r\nMais Pierre Katz n’est pas un théoricien ni un historien des lettres. Formé\r\nà l’édition et à la signalétique, il conçoit le signe dans son environnement,\r\nen prise avec son époque, et se spécialise dans le dessin de logotypes :\r\n«ce signe qui signe la marque, révèle son identité et sa personnalité avec immédiateté, clarté et permanence». Pas d’égo d’artiste, pas de «patte»\r\nde graphiste : le logo, s’il est réussi, éclipse son dessinateur et perdure sur plusieurs décennies.\r\nQuand il crée une identité de marque ou dessine une étiquette, son approche est esthétique sans être décorative : il s’agit de formaliser du sens, par un sur-mesure qui distille la culture dans l’épure.\r\nCar, comme il aime à le rappeler, «la concision force la précision».\r\n\r\n&nbsp;\r\n\r\nCette vision de son métier, Pierre Katz la partage avec ses clients prestigieux:\r\nles grandes maisons de luxe dont l’exigence de qualité est à la mesure de son travail d’artisan.'); 
INSERT INTO `wp_postmeta` VALUES (72034, 2008, 'image_texte_0_image_v', '1548'); 
INSERT INTO `wp_postmeta` VALUES (72035, 2008, '_image_texte_0_image_v', 'field_54ff8eb94ab9e'); 
INSERT INTO `wp_postmeta` VALUES (72033, 2008, '_image_texte_0_image_iphone_horizontal', 'field_55077b5f59875'); 
INSERT INTO `wp_postmeta` VALUES (72032, 2008, 'image_texte_0_image_iphone_horizontal', '1626'); 
INSERT INTO `wp_postmeta` VALUES (72031, 2008, '_image_texte_0_image', 'field_546535dc7658f'); 
INSERT INTO `wp_postmeta` VALUES (72030, 2008, 'image_texte_0_image', '2006'); 
INSERT INTO `wp_postmeta` VALUES (60121, 1835, '_lifting', 'field_54bf183f767d6'); 
INSERT INTO `wp_postmeta` VALUES (60120, 1835, 'lifting', '11'); 
INSERT INTO `wp_postmeta` VALUES (60119, 1835, '_lifting_10_filet', 'field_54c02c5013597'); 
INSERT INTO `wp_postmeta` VALUES (60118, 1835, 'lifting_10_filet', ''); 
INSERT INTO `wp_postmeta` VALUES (60117, 1835, '_lifting_10_texte', 'field_54bf187f767da'); 
INSERT INTO `wp_postmeta` VALUES (58453, 1820, '_logos_3_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58448, 1820, 'logos_2_lien', '552'); 
INSERT INTO `wp_postmeta` VALUES (58449, 1820, '_logos_2_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58450, 1820, 'logos_3_image', '1010'); 
INSERT INTO `wp_postmeta` VALUES (6133, 457, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (6131, 457, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (6132, 457, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (58377, 1818, '_logos_12_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58396, 1818, 'logos_17_image', '724'); 
INSERT INTO `wp_postmeta` VALUES (58397, 1818, '_logos_17_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58398, 1818, 'logos_17_lien', '1810'); 
INSERT INTO `wp_postmeta` VALUES (6125, 457, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (6122, 457, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (6123, 457, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (6124, 457, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (58414, 1818, 'logos_21_lien', '1814'); 
INSERT INTO `wp_postmeta` VALUES (58410, 1818, 'logos_20_lien', '1358'); 
INSERT INTO `wp_postmeta` VALUES (58411, 1818, '_logos_20_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58412, 1818, 'logos_21_image', '728'); 
INSERT INTO `wp_postmeta` VALUES (58402, 1818, 'logos_18_lien', '1356'); 
INSERT INTO `wp_postmeta` VALUES (58399, 1818, '_logos_17_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (3067, 219, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (3068, 219, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3069, 219, 'block_photos_legende_0_photo_l', '132'); 
INSERT INTO `wp_postmeta` VALUES (3070, 219, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3071, 219, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3072, 219, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3073, 219, 'block_photos_legende_0_title', 'Logo design & lettering. 1989'); 
INSERT INTO `wp_postmeta` VALUES (3074, 219, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3075, 219, 'block_photos_legende_0_subtitle', 'L’identité visuelle Sonia Rykiel a été redessinée à l’occasion du lancement de la première ligne de soins de la marque. La créatrice voulait une expression de sa griffe puissante et stable, à contre-pied de sa personnalité évanescente. \r\nProjet réalisé dans le cadre d’une précédente activité dans l’agence Desgrippes.'); 
INSERT INTO `wp_postmeta` VALUES (3076, 219, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3077, 219, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (3078, 219, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (19624, 947, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (3087, 220, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3088, 220, 'block_photos_legende_0_subtitle', 'Pour remédier à un manque de lisibilité et de présence sur les présentoirs de parfumerie, le dessin de la marque a été tendu et profilé pour s’inscrire au mieux à l’horizontale.'); 
INSERT INTO `wp_postmeta` VALUES (3089, 220, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3090, 220, 'block_photos_legende_1_photo_l', '128'); 
INSERT INTO `wp_postmeta` VALUES (3091, 220, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3092, 220, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3093, 220, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3094, 220, 'block_photos_legende_1_title', 'Logo design before & after.'); 
INSERT INTO `wp_postmeta` VALUES (3095, 220, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3096, 220, 'block_photos_legende_1_subtitle', 'La lettre manuscrite a été dessinée d’après la signature du créateur. Le style incisif, presque électrique, de son tracé a été exacerbé.'); 
INSERT INTO `wp_postmeta` VALUES (3097, 220, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3098, 220, 'block_photos_legende_2_photo_l', '129'); 
INSERT INTO `wp_postmeta` VALUES (3099, 220, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3100, 220, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3101, 220, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3102, 220, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3103, 220, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3104, 220, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3105, 220, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3106, 220, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (3107, 220, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3110, 221, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3111, 221, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3112, 221, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3113, 221, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3114, 221, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3115, 221, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3116, 221, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3117, 221, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3118, 221, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3119, 221, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3120, 221, 'block_photos_legende_1_photo_l', '71'); 
INSERT INTO `wp_postmeta` VALUES (3121, 221, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3122, 221, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3123, 221, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3124, 221, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3125, 221, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3126, 221, 'block_photos_legende_1_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé. Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3127, 221, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3128, 221, 'block_photos_legende_2_photo_l', '72'); 
INSERT INTO `wp_postmeta` VALUES (3129, 221, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3130, 221, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3131, 221, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3132, 221, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3133, 221, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3134, 221, 'block_photos_legende_2_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3135, 221, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3136, 221, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (3137, 221, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11140, 35, '_block_photos_legende_2_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (3249, 35, 'block_photos_legende_3_photo_l', '333'); 
INSERT INTO `wp_postmeta` VALUES (3250, 35, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3251, 35, 'block_photos_legende_3_photo_r', '334'); 
INSERT INTO `wp_postmeta` VALUES (3139, 222, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (3140, 222, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3141, 222, 'block_photos_legende_0_photo_l', '168'); 
INSERT INTO `wp_postmeta` VALUES (3142, 222, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3143, 222, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3144, 222, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3145, 222, 'block_photos_legende_0_title', 'Logo design & lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (3146, 222, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3147, 222, 'block_photos_legende_0_subtitle', 'La refonte de la maquette du magazine d’information, le Point, fût également l’occasion d’actualiser son logo. Le directeur du journal voulait/ nous a demandé un coup de « poing » visuel. Nous sommes partis d’un caractère puissant tout en conservant la rondeur du poing. Les empattements rappellent la lettre d’imprimerie et les origines de la publication, tout en accompagnant son passage à l’ère numérique. / en accompagnant son évolution dans une nouvelle ère médiatique.'); 
INSERT INTO `wp_postmeta` VALUES (3148, 222, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3149, 222, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (3150, 222, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (30304, 1171, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (19923, 953, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3152, 223, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:23:"2014/07/logo_lejay1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"logo_lejay1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"logo_lejay1-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"logo_lejay1-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"logo_lejay1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"logo_lejay1-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3153, 224, '_wp_attached_file', '2014/07/logo_avant_apres1.png'); 
INSERT INTO `wp_postmeta` VALUES (3154, 224, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:29:"2014/07/logo_avant_apres1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"logo_avant_apres1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"logo_avant_apres1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"logo_avant_apres1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"logo_avant_apres1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"logo_avant_apres1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3208, 226, '_wp_attached_file', '2014/06/blanc3.png'); 
INSERT INTO `wp_postmeta` VALUES (64692, 1897, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64691, 1897, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64690, 1897, 'block_photos_legende_2_photo_l', '320'); 
INSERT INTO `wp_postmeta` VALUES (64689, 1897, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64688, 1897, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64686, 1897, 'block_photos_legende_1_subtitle', '> Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (64687, 1897, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64685, 1897, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64684, 1897, 'block_photos_legende_1_title', 'Placement du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (64683, 1897, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64682, 1897, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64679, 1897, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64680, 1897, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64681, 1897, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64678, 1897, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64677, 1897, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64676, 1897, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64675, 1897, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64674, 1897, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64669, 1897, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64670, 1897, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (64671, 1897, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64672, 1897, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64673, 1897, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64668, 1897, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64667, 1897, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64666, 1897, 'block_photos_legende_0_subtitle', '> Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (64665, 1897, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64662, 1897, 'block_photos_legende_0_photo_gauche_iphone_v', '1756'); 
INSERT INTO `wp_postmeta` VALUES (64663, 1897, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64664, 1897, 'block_photos_legende_0_title', 'Design du logo. Dessin de l\'emblème et de la typographie. 2001'); 
INSERT INTO `wp_postmeta` VALUES (64661, 1897, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64660, 1897, 'block_photos_legende_0_photo_gauche_iphone_h', '1755'); 
INSERT INTO `wp_postmeta` VALUES (64659, 1897, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64658, 1897, 'block_photos_legende_0_photo_gauche_ipad_v', '1754'); 
INSERT INTO `wp_postmeta` VALUES (64647, 1897, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (64648, 1897, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (64649, 1897, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (64650, 1897, 'block_photos_legende_0_photo_l', '548'); 
INSERT INTO `wp_postmeta` VALUES (64651, 1897, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64652, 1897, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64653, 1897, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64654, 1897, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64655, 1897, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64656, 1897, 'block_photos_legende_0_photo_gauche_ipad_h', '1753'); 
INSERT INTO `wp_postmeta` VALUES (64657, 1897, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (65639, 1908, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (65640, 1908, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (64643, 1896, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3209, 226, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:18:"2014/06/blanc3.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"blanc3-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"blanc3-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"blanc3-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"blanc3-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"blanc3-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3210, 227, '_wp_attached_file', '2014/06/close_up_blanc.png'); 
INSERT INTO `wp_postmeta` VALUES (3211, 227, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/06/close_up_blanc.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"close_up_blanc-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"close_up_blanc-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"close_up_blanc-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"close_up_blanc-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"close_up_blanc-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3257, 229, '_wp_attached_file', '2014/06/rose3.png'); 
INSERT INTO `wp_postmeta` VALUES (3213, 228, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3214, 228, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3215, 228, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3216, 228, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3217, 228, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3218, 228, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3219, 228, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3220, 228, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3221, 228, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3222, 228, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3223, 228, 'block_photos_legende_1_photo_l', '226'); 
INSERT INTO `wp_postmeta` VALUES (3224, 228, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3225, 228, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3226, 228, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3227, 228, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3228, 228, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3229, 228, 'block_photos_legende_1_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé. Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3230, 228, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3231, 228, 'block_photos_legende_2_photo_l', '227'); 
INSERT INTO `wp_postmeta` VALUES (3232, 228, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3233, 228, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3234, 228, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3235, 228, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3236, 228, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3237, 228, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3238, 228, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3239, 228, 'block_photos_legende_3_photo_l', '72'); 
INSERT INTO `wp_postmeta` VALUES (3240, 228, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3241, 228, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3242, 228, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3243, 228, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3244, 228, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3245, 228, 'block_photos_legende_3_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3246, 228, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3247, 228, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (3248, 228, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3252, 35, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3253, 35, 'block_photos_legende_3_title', 'Habillage de Dom Ruinart Rosé. 2014'); 
INSERT INTO `wp_postmeta` VALUES (3254, 35, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3255, 35, 'block_photos_legende_3_subtitle', 'L’ambiance colorielle est crème et or patiné pour le Blanc de Blancs et lie de vin et rose poudré pour le Rosé.'); 
INSERT INTO `wp_postmeta` VALUES (11168, 677, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3256, 35, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3258, 229, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:17:"2014/06/rose3.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"rose3-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"rose3-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:18:"rose3-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"rose3-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"rose3-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3259, 230, '_wp_attached_file', '2014/06/close_up_rose.png'); 
INSERT INTO `wp_postmeta` VALUES (3260, 230, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/close_up_rose.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"close_up_rose-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"close_up_rose-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"close_up_rose-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"close_up_rose-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"close_up_rose-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3262, 231, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3263, 231, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3264, 231, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3265, 231, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3266, 231, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3267, 231, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3268, 231, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3269, 231, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3270, 231, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3271, 231, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3272, 231, 'block_photos_legende_1_photo_l', '226'); 
INSERT INTO `wp_postmeta` VALUES (3273, 231, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3274, 231, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3275, 231, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3276, 231, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3277, 231, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3278, 231, 'block_photos_legende_1_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé. Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3279, 231, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3280, 231, 'block_photos_legende_2_photo_l', '227'); 
INSERT INTO `wp_postmeta` VALUES (3281, 231, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3282, 231, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3283, 231, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3284, 231, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3285, 231, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3286, 231, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3287, 231, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3288, 231, 'block_photos_legende_3_photo_l', '229'); 
INSERT INTO `wp_postmeta` VALUES (3289, 231, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3290, 231, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3291, 231, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3292, 231, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3293, 231, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3294, 231, 'block_photos_legende_3_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3295, 231, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3296, 231, 'block_photos_legende_4_photo_l', '230'); 
INSERT INTO `wp_postmeta` VALUES (3297, 231, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3298, 231, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3299, 231, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3300, 231, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3301, 231, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3302, 231, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3303, 231, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3304, 231, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (3305, 231, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11170, 677, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (11169, 677, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (11166, 677, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (3315, 232, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3316, 232, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3317, 232, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3318, 232, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3319, 232, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3320, 232, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3321, 232, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3322, 232, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3323, 232, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3324, 232, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3325, 232, 'block_photos_legende_1_photo_l', '226'); 
INSERT INTO `wp_postmeta` VALUES (3326, 232, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3327, 232, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3328, 232, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3329, 232, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3330, 232, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3331, 232, 'block_photos_legende_1_subtitle', ' Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3332, 232, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3333, 232, 'block_photos_legende_2_photo_l', '227'); 
INSERT INTO `wp_postmeta` VALUES (3334, 232, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3335, 232, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3336, 232, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3337, 232, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3338, 232, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3339, 232, 'block_photos_legende_2_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé.'); 
INSERT INTO `wp_postmeta` VALUES (3340, 232, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3341, 232, 'block_photos_legende_3_photo_l', '229'); 
INSERT INTO `wp_postmeta` VALUES (3342, 232, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3343, 232, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3344, 232, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3345, 232, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3346, 232, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3347, 232, 'block_photos_legende_3_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. '); 
INSERT INTO `wp_postmeta` VALUES (3348, 232, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3349, 232, 'block_photos_legende_4_photo_l', '230'); 
INSERT INTO `wp_postmeta` VALUES (3350, 232, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3351, 232, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3352, 232, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3353, 232, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3354, 232, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3355, 232, 'block_photos_legende_4_subtitle', 'Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3356, 232, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3357, 232, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (3358, 232, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11139, 35, 'block_photos_legende_2_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11167, 677, 'block_photos_legende_1_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (3803, 320, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:500;s:6:"height";i:500;s:4:"file";s:25:"2014/07/fussigny_xo01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"fussigny_xo01-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo01-500x372.png";s:5:"width";i:500;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3802, 320, '_wp_attached_file', '2014/07/fussigny_xo01.png'); 
INSERT INTO `wp_postmeta` VALUES (3411, 251, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:917;s:4:"file";s:24:"2014/06/clients_1080.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"clients_1080-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"clients_1080-300x254.jpg";s:5:"width";i:300;s:6:"height";i:254;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"clients_1080-1024x869.jpg";s:5:"width";i:1024;s:6:"height";i:869;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"clients_1080-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"clients_1080-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3410, 251, '_wp_attached_file', '2014/06/clients_1080.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3399, 250, 'hide_on_screen', 'a:13:{i:0;s:9:"permalink";i:1;s:11:"the_content";i:2;s:7:"excerpt";i:3;s:10:"discussion";i:4;s:8:"comments";i:5;s:9:"revisions";i:6;s:4:"slug";i:7;s:6:"author";i:8;s:6:"format";i:9;s:14:"featured_image";i:10;s:10:"categories";i:11;s:4:"tags";i:12;s:15:"send-trackbacks";}'); 
INSERT INTO `wp_postmeta` VALUES (3400, 250, 'layout', 'default'); 
INSERT INTO `wp_postmeta` VALUES (3401, 250, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (6638, 475, '_wp_attached_file', '2014/06/a.defussigny.png'); 
INSERT INTO `wp_postmeta` VALUES (6639, 475, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:270;s:6:"height";i:180;s:4:"file";s:24:"2014/06/a.defussigny.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"a.defussigny-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (6618, 453, '_edit_lock', '1435574257:1'); 
INSERT INTO `wp_postmeta` VALUES (6619, 473, 'logos', '0'); 
INSERT INTO `wp_postmeta` VALUES (3404, 250, 'field_53d9034952f1f', 'a:11:{s:3:"key";s:19:"field_53d9034952f1f";s:5:"label";s:9:"image 320";s:4:"name";s:9:"image_320";s:4:"type";s:5:"image";s:12:"instructions";s:12:"280 x 280 px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:2:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:4;}'); 
INSERT INTO `wp_postmeta` VALUES (3405, 250, 'field_53d9032c52f1e', 'a:11:{s:3:"key";s:19:"field_53d9032c52f1e";s:5:"label";s:51:"image 480  <span class="help">(441 x 186 px)</span>";s:4:"name";s:9:"image_480";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:3;}'); 
INSERT INTO `wp_postmeta` VALUES (3406, 250, 'field_53d9030152f1d', 'a:11:{s:3:"key";s:19:"field_53d9030152f1d";s:5:"label";s:51:"image_768  <span class="help">(669 x 599 px)</span>";s:4:"name";s:9:"image_768";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:2;}'); 
INSERT INTO `wp_postmeta` VALUES (9945, 611, '_wp_page_template', 'page-home.php'); 
INSERT INTO `wp_postmeta` VALUES (59212, 1827, 'baseline-default', '1645'); 
INSERT INTO `wp_postmeta` VALUES (9946, 611, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (7023, 507, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/06/mask_1080.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"mask_1080-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"mask_1080-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"mask_1080-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"mask_1080-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"mask_1080-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3408, 250, 'field_53d9028752f1b', 'a:11:{s:3:"key";s:19:"field_53d9028752f1b";s:5:"label";s:10:"image 1080";s:4:"name";s:10:"image_1080";s:4:"type";s:5:"image";s:12:"instructions";s:10:"1080x500px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (3409, 250, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (3412, 252, '_wp_attached_file', '2014/06/clients_1024.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3413, 252, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:2000;s:4:"file";s:24:"2014/06/clients_1024.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"clients_1024-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"clients_1024-153x300.jpg";s:5:"width";i:153;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"clients_1024-524x1024.jpg";s:5:"width";i:524;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"clients_1024-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"clients_1024-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3414, 253, '_wp_attached_file', '2014/06/clients_768.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3415, 253, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:768;s:6:"height";i:2000;s:4:"file";s:23:"2014/06/clients_768.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"clients_768-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"clients_768-115x300.jpg";s:5:"width";i:115;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:24:"clients_768-393x1024.jpg";s:5:"width";i:393;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"clients_768-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"clients_768-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3416, 254, '_wp_attached_file', '2014/06/clients_480.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3417, 254, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:2000;s:4:"file";s:23:"2014/06/clients_480.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"clients_480-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"clients_480-72x300.jpg";s:5:"width";i:72;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:24:"clients_480-245x1024.jpg";s:5:"width";i:245;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"clients_480-480x372.jpg";s:5:"width";i:480;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"clients_480-480x576.jpg";s:5:"width";i:480;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3418, 255, '_wp_attached_file', '2014/06/clients_320.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3419, 255, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:320;s:6:"height";i:2000;s:4:"file";s:23:"2014/06/clients_320.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"clients_320-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"clients_320-48x300.jpg";s:5:"width";i:48;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:24:"clients_320-163x1024.jpg";s:5:"width";i:163;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"clients_320-320x372.jpg";s:5:"width";i:320;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"clients_320-320x576.jpg";s:5:"width";i:320;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3440, 7, 'image_320', ''); 
INSERT INTO `wp_postmeta` VALUES (3423, 257, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3424, 257, 'image_1024', '252'); 
INSERT INTO `wp_postmeta` VALUES (3425, 257, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3426, 257, 'image_768', '253'); 
INSERT INTO `wp_postmeta` VALUES (3427, 257, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3428, 257, 'image_480', '254'); 
INSERT INTO `wp_postmeta` VALUES (3429, 257, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3430, 257, 'image_320', '255'); 
INSERT INTO `wp_postmeta` VALUES (3431, 257, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3432, 7, 'image_1080', ''); 
INSERT INTO `wp_postmeta` VALUES (3433, 7, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3434, 7, 'image_1024', ''); 
INSERT INTO `wp_postmeta` VALUES (3435, 7, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3436, 7, 'image_768', ''); 
INSERT INTO `wp_postmeta` VALUES (3437, 7, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3438, 7, 'image_480', ''); 
INSERT INTO `wp_postmeta` VALUES (3439, 7, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3441, 7, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (5090, 411, '_wp_attached_file', '2014/06/pierre.jpg'); 
INSERT INTO `wp_postmeta` VALUES (5091, 411, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:600;s:6:"height";i:903;s:4:"file";s:18:"2014/06/pierre.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"pierre-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"pierre-199x300.jpg";s:5:"width";i:199;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"pierre-600x372.jpg";s:5:"width";i:600;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"pierre-600x576.jpg";s:5:"width";i:600;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";d:5.2999999999999998;s:6:"credit";s:0:"";s:6:"camera";s:10:"NIKON D300";s:7:"caption";s:0:"";s:17:"created_timestamp";i:1223911641;s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"120";s:3:"iso";i:0;s:13:"shutter_speed";s:5:"0.005";s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (7389, 527, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/Deneuve120.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"Deneuve120-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"Deneuve120-300x138.jpg";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:23:"Deneuve120-1024x474.jpg";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"Deneuve120-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"Deneuve120-1038x500.jpg";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (7388, 527, '_wp_attached_file', '2014/07/Deneuve120.jpg'); 
INSERT INTO `wp_postmeta` VALUES (61880, 1865, 'image_iphone_vertical', '1704'); 
INSERT INTO `wp_postmeta` VALUES (61879, 1865, '_image_iphone_horizontal', 'field_5507788aaa2bb'); 
INSERT INTO `wp_postmeta` VALUES (101012, 2633, '_image_iphone_vertical', 'field_54f90f2e2bc12'); 
INSERT INTO `wp_postmeta` VALUES (101013, 2633, 'image_ipad_vertical', '2631'); 
INSERT INTO `wp_postmeta` VALUES (10733, 644, '_wp_attached_file', '2014/06/diane.jpg'); 
INSERT INTO `wp_postmeta` VALUES (10734, 644, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:400;s:6:"height";i:308;s:4:"file";s:17:"2014/06/diane.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"diane-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:17:"diane-300x231.jpg";s:5:"width";i:300;s:6:"height";i:231;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (16714, 859, '_actu_0_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (3489, 280, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:561;s:6:"height";i:500;s:4:"file";s:38:"2014/07/Cointreau_Noir_image_right.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:38:"Cointreau_Noir_image_right-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:38:"Cointreau_Noir_image_right-300x267.jpg";s:5:"width";i:300;s:6:"height";i:267;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:38:"Cointreau_Noir_image_right-561x372.jpg";s:5:"width";i:561;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (61878, 1865, 'image_iphone_horizontal', '1703'); 
INSERT INTO `wp_postmeta` VALUES (7024, 508, 'image_1080', '505'); 
INSERT INTO `wp_postmeta` VALUES (7025, 508, '_image_1080', 'field_53d92e946de9e'); 
INSERT INTO `wp_postmeta` VALUES (7026, 508, 'image_1080_rollover', '507'); 
INSERT INTO `wp_postmeta` VALUES (101007, 2633, 'image', '2257'); 
INSERT INTO `wp_postmeta` VALUES (101008, 2633, '_image', 'field_54bf181befd95'); 
INSERT INTO `wp_postmeta` VALUES (101009, 2633, 'image_iphone_horizontal', '2258'); 
INSERT INTO `wp_postmeta` VALUES (101010, 2633, '_image_iphone_horizontal', 'field_5507788aaa2bb'); 
INSERT INTO `wp_postmeta` VALUES (101011, 2633, 'image_iphone_vertical', '2259'); 
INSERT INTO `wp_postmeta` VALUES (3488, 280, '_wp_attached_file', '2014/07/Cointreau_Noir_image_right.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3482, 279, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (61877, 1865, '_image', 'field_54bf181befd95'); 
INSERT INTO `wp_postmeta` VALUES (61876, 1865, 'image', '1709'); 
INSERT INTO `wp_postmeta` VALUES (61881, 1865, '_image_iphone_vertical', 'field_54f90f2e2bc12'); 
INSERT INTO `wp_postmeta` VALUES (61865, 1863, 'logos_25_lien', '800'); 
INSERT INTO `wp_postmeta` VALUES (61866, 1863, '_logos_25_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (61867, 1863, 'logos', '26'); 
INSERT INTO `wp_postmeta` VALUES (61868, 1863, '_logos', 'field_53ffb2ef15ceb'); 
INSERT INTO `wp_postmeta` VALUES (61869, 1863, 'footer-text', '© Pierre Katz. Photo copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (61870, 1863, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (61872, 279, 'field_55247429d2a2a', 'a:11:{s:3:"key";s:19:"field_55247429d2a2a";s:5:"label";s:19:"image ipad vertical";s:4:"name";s:19:"image_ipad_vertical";s:4:"type";s:5:"image";s:12:"instructions";s:14:"1336 x 1263 px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:3;}'); 
INSERT INTO `wp_postmeta` VALUES (61875, 1864, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1336;s:6:"height";i:1263;s:4:"file";s:24:"2014/06/approach_668.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"approach_668-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"approach_668-300x283.jpg";s:5:"width";i:300;s:6:"height";i:283;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"approach_668-1024x968.jpg";s:5:"width";i:1024;s:6:"height";i:968;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"approach_668-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"approach_668-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (61858, 1863, '_logos_23_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (61859, 1863, 'logos_24_image', '1732'); 
INSERT INTO `wp_postmeta` VALUES (61864, 1863, '_logos_25_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (61863, 1863, 'logos_25_image', '1733'); 
INSERT INTO `wp_postmeta` VALUES (61862, 1863, '_logos_24_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (61861, 1863, 'logos_24_lien', '465'); 
INSERT INTO `wp_postmeta` VALUES (16723, 859, 'actu_1_texte', ''); 
INSERT INTO `wp_postmeta` VALUES (16724, 859, '_actu_1_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (16725, 859, 'actu', '2'); 
INSERT INTO `wp_postmeta` VALUES (16726, 859, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (16727, 859, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (16728, 859, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (16820, 861, '_edit_lock', '1434029172:2'); 
INSERT INTO `wp_postmeta` VALUES (16722, 859, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (16715, 859, 'actu_1_image', ''); 
INSERT INTO `wp_postmeta` VALUES (16716, 859, '_actu_1_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (16717, 859, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (16718, 859, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (16719, 859, 'actu_1_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (16720, 859, '_actu_1_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (16721, 859, 'actu_1_titre', ''); 
INSERT INTO `wp_postmeta` VALUES (16705, 859, 'actu_0_image', '828'); 
INSERT INTO `wp_postmeta` VALUES (16706, 859, '_actu_0_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (16707, 859, 'actu_0_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (16708, 859, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (16709, 859, 'actu_0_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (16710, 859, '_actu_0_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (16711, 859, 'actu_0_titre', 'Dom Ruinart'); 
INSERT INTO `wp_postmeta` VALUES (16712, 859, '_actu_0_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (10967, 606, 'field_54728f248d747', 'a:11:{s:3:"key";s:19:"field_54728f248d747";s:5:"label";s:19:"image ipad vertical";s:4:"name";s:19:"image_ipad_vertical";s:4:"type";s:5:"image";s:12:"instructions";s:12:"620 x 680 px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:8;}'); 
INSERT INTO `wp_postmeta` VALUES (125018, 279, 'rule', 'a:5:{s:5:"param";s:13:"page_template";s:8:"operator";s:2:"==";s:5:"value";s:17:"page-approach.php";s:8:"order_no";i:0;s:8:"group_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (3485, 279, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (3486, 279, 'layout', 'no_box'); 
INSERT INTO `wp_postmeta` VALUES (3487, 279, 'hide_on_screen', 'a:2:{i:0;s:11:"the_content";i:1;s:14:"featured_image";}'); 
INSERT INTO `wp_postmeta` VALUES (3490, 281, '_wp_attached_file', '2014/07/approach_2_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3491, 281, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_2_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_2_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3492, 282, '_wp_attached_file', '2014/07/approach_0.png'); 
INSERT INTO `wp_postmeta` VALUES (3493, 282, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_0.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_0-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3494, 283, '_wp_attached_file', '2014/07/approach_5_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3495, 283, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_5_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_5_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3496, 284, '_wp_attached_file', '2014/07/approach_1.png'); 
INSERT INTO `wp_postmeta` VALUES (3497, 284, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_1.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_1-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3498, 285, '_wp_attached_file', '2014/07/approach_4_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3499, 285, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_4_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_4_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3500, 286, '_wp_attached_file', '2014/07/approach_4.png'); 
INSERT INTO `wp_postmeta` VALUES (3501, 286, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_4.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_4-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3502, 287, '_wp_attached_file', '2014/07/approach_txt_2.png'); 
INSERT INTO `wp_postmeta` VALUES (3503, 287, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_2.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_2-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3504, 288, '_wp_attached_file', '2014/07/approach_2.png'); 
INSERT INTO `wp_postmeta` VALUES (3505, 288, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_2.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_2-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3506, 289, '_wp_attached_file', '2014/07/approach_0_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3507, 289, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_0_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_0_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3508, 290, '_wp_attached_file', '2014/07/about_portrait.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3509, 290, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:487;s:6:"height";i:600;s:4:"file";s:26:"2014/07/about_portrait.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"about_portrait-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:26:"about_portrait-243x300.jpg";s:5:"width";i:243;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"about_portrait-487x372.jpg";s:5:"width";i:487;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"about_portrait-487x576.jpg";s:5:"width";i:487;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3510, 291, '_wp_attached_file', '2014/07/approach_txt_1.png'); 
INSERT INTO `wp_postmeta` VALUES (3511, 291, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_1.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_1-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3512, 292, '_wp_attached_file', '2014/07/contact_768.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3513, 292, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:768;s:6:"height";i:600;s:4:"file";s:23:"2014/07/contact_768.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"contact_768-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"contact_768-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"contact_768-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"contact_768-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3514, 293, '_wp_attached_file', '2014/07/contact_768_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3515, 293, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:768;s:6:"height";i:600;s:4:"file";s:28:"2014/07/contact_768_roll.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"contact_768_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"contact_768_roll-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"contact_768_roll-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:28:"contact_768_roll-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3516, 294, '_wp_attached_file', '2014/07/approach_5.png'); 
INSERT INTO `wp_postmeta` VALUES (3517, 294, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_5.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_5-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3518, 295, '_wp_attached_file', '2014/07/clients_1024.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3519, 295, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:2000;s:4:"file";s:24:"2014/07/clients_1024.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"clients_1024-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"clients_1024-153x300.jpg";s:5:"width";i:153;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"clients_1024-524x1024.jpg";s:5:"width";i:524;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"clients_1024-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"clients_1024-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3520, 296, '_wp_attached_file', '2014/07/approach_txt_3.png'); 
INSERT INTO `wp_postmeta` VALUES (3521, 296, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_3.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_3-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3522, 297, '_wp_attached_file', '2014/07/contact_1024.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3523, 297, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:600;s:4:"file";s:24:"2014/07/contact_1024.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"contact_1024-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"contact_1024-300x175.jpg";s:5:"width";i:300;s:6:"height";i:175;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"contact_1024-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"contact_1024-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3524, 298, '_wp_attached_file', '2014/07/contact_480_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3525, 298, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:375;s:4:"file";s:28:"2014/07/contact_480_roll.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"contact_480_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"contact_480_roll-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"contact_480_roll-480x372.jpg";s:5:"width";i:480;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3526, 299, '_wp_attached_file', '2014/07/contact_320.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3527, 299, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:320;s:6:"height";i:375;s:4:"file";s:23:"2014/07/contact_320.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"contact_320-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"contact_320-256x300.jpg";s:5:"width";i:256;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"contact_320-320x372.jpg";s:5:"width";i:320;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3528, 300, '_wp_attached_file', '2014/07/approach_3_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3529, 300, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_3_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_3_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3530, 301, '_wp_attached_file', '2014/07/approach_page2.png'); 
INSERT INTO `wp_postmeta` VALUES (3531, 301, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1079;s:6:"height";i:547;s:4:"file";s:26:"2014/07/approach_page2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_page2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"approach_page2-300x152.png";s:5:"width";i:300;s:6:"height";i:152;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"approach_page2-1024x519.png";s:5:"width";i:1024;s:6:"height";i:519;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"approach_page2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"approach_page2-1038x547.png";s:5:"width";i:1038;s:6:"height";i:547;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3532, 302, '_wp_attached_file', '2014/07/contact_0.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3533, 302, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1082;s:6:"height";i:600;s:4:"file";s:21:"2014/07/contact_0.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"contact_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"contact_0-300x166.jpg";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:22:"contact_0-1024x567.jpg";s:5:"width";i:1024;s:6:"height";i:567;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"contact_0-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"contact_0-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3534, 303, '_wp_attached_file', '2014/07/approach_txt_5.png'); 
INSERT INTO `wp_postmeta` VALUES (3535, 303, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_5.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_5-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3536, 304, '_wp_attached_file', '2014/07/contact_480.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3537, 304, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:375;s:4:"file";s:23:"2014/07/contact_480.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"contact_480-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"contact_480-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"contact_480-480x372.jpg";s:5:"width";i:480;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3538, 305, '_wp_attached_file', '2014/07/approach_txt_4.png'); 
INSERT INTO `wp_postmeta` VALUES (3539, 305, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_4.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_4-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3540, 306, '_wp_attached_file', '2014/07/contact_320_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3541, 306, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:320;s:6:"height";i:375;s:4:"file";s:28:"2014/07/contact_320_roll.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"contact_320_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"contact_320_roll-256x300.jpg";s:5:"width";i:256;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"contact_320_roll-320x372.jpg";s:5:"width";i:320;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3542, 307, '_wp_attached_file', '2014/07/contact.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3543, 307, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1082;s:6:"height";i:600;s:4:"file";s:19:"2014/07/contact.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"contact-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:19:"contact-300x166.jpg";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:20:"contact-1024x567.jpg";s:5:"width";i:1024;s:6:"height";i:567;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"contact-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"contact-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3544, 308, '_wp_attached_file', '2014/07/approach_1_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3545, 308, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_1_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_1_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3546, 309, '_wp_attached_file', '2014/07/approach_txt_0.png'); 
INSERT INTO `wp_postmeta` VALUES (3547, 309, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_0.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_0-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3548, 310, '_wp_attached_file', '2014/07/contact_1024_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3549, 310, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:600;s:4:"file";s:29:"2014/07/contact_1024_roll.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"contact_1024_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:29:"contact_1024_roll-300x175.jpg";s:5:"width";i:300;s:6:"height";i:175;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"contact_1024_roll-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"contact_1024_roll-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3550, 311, '_wp_attached_file', '2014/07/Cointreau_Noir_image_left.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3551, 311, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:500;s:6:"height";i:500;s:4:"file";s:37:"2014/07/Cointreau_Noir_image_left.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:37:"Cointreau_Noir_image_left-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:37:"Cointreau_Noir_image_left-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:37:"Cointreau_Noir_image_left-500x372.jpg";s:5:"width";i:500;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3552, 312, '_wp_attached_file', '2014/07/approach_3.png'); 
INSERT INTO `wp_postmeta` VALUES (3553, 312, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_3.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_3-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3554, 313, 'image_1080', '302'); 
INSERT INTO `wp_postmeta` VALUES (3555, 313, '_image_1080', 'field_53d92e946de9e'); 
INSERT INTO `wp_postmeta` VALUES (3556, 313, 'image_1080_rollover', '307'); 
INSERT INTO `wp_postmeta` VALUES (3557, 313, '_image_1080_rollover', 'field_53d92e9f6de9f'); 
INSERT INTO `wp_postmeta` VALUES (3558, 313, 'image_1024', '297'); 
INSERT INTO `wp_postmeta` VALUES (3559, 313, '_image_1024', 'field_53d92c8386af1'); 
INSERT INTO `wp_postmeta` VALUES (3560, 313, 'image_1024_rollover', '310'); 
INSERT INTO `wp_postmeta` VALUES (3561, 313, '_image_1024_rollover', 'field_53d92ca886af2'); 
INSERT INTO `wp_postmeta` VALUES (3562, 313, 'image_768', ''); 
INSERT INTO `wp_postmeta` VALUES (3563, 313, '_image_768', 'field_53d92cb786af3'); 
INSERT INTO `wp_postmeta` VALUES (3564, 313, 'image_768_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3565, 313, '_image_768_rollover', 'field_53d92cc586af4'); 
INSERT INTO `wp_postmeta` VALUES (3566, 313, 'image_480', ''); 
INSERT INTO `wp_postmeta` VALUES (3567, 313, '_image_480', 'field_53d92cd386af5'); 
INSERT INTO `wp_postmeta` VALUES (3568, 313, 'image_480_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3569, 313, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (3570, 313, 'image_320', ''); 
INSERT INTO `wp_postmeta` VALUES (3571, 313, '_image_320', 'field_53d92cee86af7'); 
INSERT INTO `wp_postmeta` VALUES (3572, 313, 'image_320_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3573, 313, '_image_320_rollover', 'field_53d92cf686af8'); 
INSERT INTO `wp_postmeta` VALUES (3574, 13, 'image_1080', '738'); 
INSERT INTO `wp_postmeta` VALUES (3575, 13, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3576, 13, 'image_1080_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3577, 13, '_image_1080_rollover', 'field_53d92e9f6de9f'); 
INSERT INTO `wp_postmeta` VALUES (3578, 13, 'image_1024', '665'); 
INSERT INTO `wp_postmeta` VALUES (3579, 13, '_image_1024', 'field_546eb148ae4df'); 
INSERT INTO `wp_postmeta` VALUES (3580, 13, 'image_1024_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3581, 13, '_image_1024_rollover', 'field_53d92ca886af2'); 
INSERT INTO `wp_postmeta` VALUES (3582, 13, 'image_768', '671'); 
INSERT INTO `wp_postmeta` VALUES (3583, 13, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3584, 13, 'image_768_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3585, 13, '_image_768_rollover', 'field_53d92cc586af4'); 
INSERT INTO `wp_postmeta` VALUES (3586, 13, 'image_480', ''); 
INSERT INTO `wp_postmeta` VALUES (3587, 13, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3588, 13, 'image_480_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3589, 13, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (3590, 13, 'image_320', '1541'); 
INSERT INTO `wp_postmeta` VALUES (3591, 13, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3592, 13, 'image_320_rollover', '600'); 
INSERT INTO `wp_postmeta` VALUES (3593, 13, '_image_320_rollover', 'field_53d92cf686af8'); 
INSERT INTO `wp_postmeta` VALUES (3594, 314, 'image_1080', '302'); 
INSERT INTO `wp_postmeta` VALUES (3595, 314, '_image_1080', 'field_53d92e946de9e'); 
INSERT INTO `wp_postmeta` VALUES (3596, 314, 'image_1080_rollover', '307'); 
INSERT INTO `wp_postmeta` VALUES (3597, 314, '_image_1080_rollover', 'field_53d92e9f6de9f'); 
INSERT INTO `wp_postmeta` VALUES (3598, 314, 'image_1024', '297'); 
INSERT INTO `wp_postmeta` VALUES (3599, 314, '_image_1024', 'field_53d92c8386af1'); 
INSERT INTO `wp_postmeta` VALUES (3600, 314, 'image_1024_rollover', '310'); 
INSERT INTO `wp_postmeta` VALUES (3601, 314, '_image_1024_rollover', 'field_53d92ca886af2'); 
INSERT INTO `wp_postmeta` VALUES (3602, 314, 'image_768', '292'); 
INSERT INTO `wp_postmeta` VALUES (3603, 314, '_image_768', 'field_53d92cb786af3'); 
INSERT INTO `wp_postmeta` VALUES (3604, 314, 'image_768_rollover', '293'); 
INSERT INTO `wp_postmeta` VALUES (3605, 314, '_image_768_rollover', 'field_53d92cc586af4'); 
INSERT INTO `wp_postmeta` VALUES (3606, 314, 'image_480', '304'); 
INSERT INTO `wp_postmeta` VALUES (3607, 314, '_image_480', 'field_53d92cd386af5'); 
INSERT INTO `wp_postmeta` VALUES (3608, 314, 'image_480_rollover', '298'); 
INSERT INTO `wp_postmeta` VALUES (3609, 314, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (3610, 314, 'image_320', '299'); 
INSERT INTO `wp_postmeta` VALUES (3611, 314, '_image_320', 'field_53d92cee86af7'); 
INSERT INTO `wp_postmeta` VALUES (3612, 314, 'image_320_rollover', '306'); 
INSERT INTO `wp_postmeta` VALUES (3613, 314, '_image_320_rollover', 'field_53d92cf686af8'); 
INSERT INTO `wp_postmeta` VALUES (3614, 315, 'vision_0_title', '282'); 
INSERT INTO `wp_postmeta` VALUES (3615, 315, '_vision_0_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3616, 315, 'vision_0_title_rollover', '289'); 
INSERT INTO `wp_postmeta` VALUES (3617, 315, '_vision_0_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3618, 315, 'vision_0_text', '309'); 
INSERT INTO `wp_postmeta` VALUES (3619, 315, '_vision_0_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3620, 315, 'vision_1_title', '284'); 
INSERT INTO `wp_postmeta` VALUES (3621, 315, '_vision_1_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3622, 315, 'vision_1_title_rollover', '308'); 
INSERT INTO `wp_postmeta` VALUES (3623, 315, '_vision_1_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3624, 315, 'vision_1_text', '291'); 
INSERT INTO `wp_postmeta` VALUES (3625, 315, '_vision_1_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3626, 315, 'vision_2_title', '288'); 
INSERT INTO `wp_postmeta` VALUES (3627, 315, '_vision_2_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3628, 315, 'vision_2_title_rollover', '281'); 
INSERT INTO `wp_postmeta` VALUES (3629, 315, '_vision_2_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3630, 315, 'vision_2_text', '287'); 
INSERT INTO `wp_postmeta` VALUES (3631, 315, '_vision_2_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3632, 315, 'vision_3_title', '312'); 
INSERT INTO `wp_postmeta` VALUES (3633, 315, '_vision_3_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3634, 315, 'vision_3_title_rollover', '300'); 
INSERT INTO `wp_postmeta` VALUES (3635, 315, '_vision_3_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3636, 315, 'vision_3_text', '296'); 
INSERT INTO `wp_postmeta` VALUES (3637, 315, '_vision_3_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3638, 315, 'vision_4_title', '286'); 
INSERT INTO `wp_postmeta` VALUES (3639, 315, '_vision_4_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3640, 315, 'vision_4_title_rollover', '285'); 
INSERT INTO `wp_postmeta` VALUES (3641, 315, '_vision_4_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3642, 315, 'vision_4_text', '305'); 
INSERT INTO `wp_postmeta` VALUES (3643, 315, '_vision_4_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3644, 315, 'vision_5_title', '294'); 
INSERT INTO `wp_postmeta` VALUES (3645, 315, '_vision_5_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3646, 315, 'vision_5_title_rollover', '283'); 
INSERT INTO `wp_postmeta` VALUES (3647, 315, '_vision_5_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3648, 315, 'vision_5_text', '303'); 
INSERT INTO `wp_postmeta` VALUES (3649, 315, '_vision_5_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3650, 315, 'vision', '6'); 
INSERT INTO `wp_postmeta` VALUES (3651, 315, '_vision', 'field_53d9a15cbd306'); 
INSERT INTO `wp_postmeta` VALUES (3652, 9, 'vision_0_title', '852'); 
INSERT INTO `wp_postmeta` VALUES (3653, 9, '_vision_0_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3654, 9, 'vision_0_title_rollover', '289'); 
INSERT INTO `wp_postmeta` VALUES (3655, 9, '_vision_0_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3656, 9, 'vision_0_text', '840'); 
INSERT INTO `wp_postmeta` VALUES (3657, 9, '_vision_0_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3658, 9, 'vision_1_title', '651'); 
INSERT INTO `wp_postmeta` VALUES (3659, 9, '_vision_1_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3660, 9, 'vision_1_title_rollover', '308'); 
INSERT INTO `wp_postmeta` VALUES (3661, 9, '_vision_1_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3662, 9, 'vision_1_text', '841'); 
INSERT INTO `wp_postmeta` VALUES (3663, 9, '_vision_1_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3664, 9, 'vision_2_title', '653'); 
INSERT INTO `wp_postmeta` VALUES (3665, 9, '_vision_2_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3666, 9, 'vision_2_title_rollover', '281'); 
INSERT INTO `wp_postmeta` VALUES (3667, 9, '_vision_2_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3668, 9, 'vision_2_text', '842'); 
INSERT INTO `wp_postmeta` VALUES (3669, 9, '_vision_2_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3670, 9, 'vision_3_title', '848'); 
INSERT INTO `wp_postmeta` VALUES (3671, 9, '_vision_3_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3672, 9, 'vision_3_title_rollover', '300'); 
INSERT INTO `wp_postmeta` VALUES (3673, 9, '_vision_3_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3674, 9, 'vision_3_text', '843'); 
INSERT INTO `wp_postmeta` VALUES (3675, 9, '_vision_3_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3676, 9, 'vision_4_title', '849'); 
INSERT INTO `wp_postmeta` VALUES (3677, 9, '_vision_4_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3678, 9, 'vision_4_title_rollover', '285'); 
INSERT INTO `wp_postmeta` VALUES (3679, 9, '_vision_4_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3680, 9, 'vision_4_text', '844'); 
INSERT INTO `wp_postmeta` VALUES (3681, 9, '_vision_4_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3682, 9, 'vision_5_title', '659'); 
INSERT INTO `wp_postmeta` VALUES (3683, 9, '_vision_5_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3684, 9, 'vision_5_title_rollover', '283'); 
INSERT INTO `wp_postmeta` VALUES (3685, 9, '_vision_5_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3686, 9, 'vision_5_text', '845'); 
INSERT INTO `wp_postmeta` VALUES (3687, 9, '_vision_5_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3688, 9, 'vision', '6'); 
INSERT INTO `wp_postmeta` VALUES (3689, 9, '_vision', 'field_53d9a15cbd306'); 
INSERT INTO `wp_postmeta` VALUES (3690, 250, '_edit_lock', '1425609752:1'); 
INSERT INTO `wp_postmeta` VALUES (6620, 473, '_logos', 'field_53ffb2ef15ceb'); 
INSERT INTO `wp_postmeta` VALUES (3693, 316, 'vision_0_title', '282'); 
INSERT INTO `wp_postmeta` VALUES (3694, 316, '_vision_0_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3695, 316, 'vision_0_title_rollover', '289'); 
INSERT INTO `wp_postmeta` VALUES (3696, 316, '_vision_0_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3697, 316, 'vision_0_text', '309'); 
INSERT INTO `wp_postmeta` VALUES (3698, 316, '_vision_0_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3699, 316, 'vision_1_title', '284'); 
INSERT INTO `wp_postmeta` VALUES (3700, 316, '_vision_1_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3701, 316, 'vision_1_title_rollover', '308'); 
INSERT INTO `wp_postmeta` VALUES (3702, 316, '_vision_1_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3703, 316, 'vision_1_text', '291'); 
INSERT INTO `wp_postmeta` VALUES (3704, 316, '_vision_1_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3705, 316, 'vision_2_title', '288'); 
INSERT INTO `wp_postmeta` VALUES (3706, 316, '_vision_2_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3707, 316, 'vision_2_title_rollover', '281'); 
INSERT INTO `wp_postmeta` VALUES (3708, 316, '_vision_2_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3709, 316, 'vision_2_text', '287'); 
INSERT INTO `wp_postmeta` VALUES (3710, 316, '_vision_2_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3711, 316, 'vision_3_title', '312'); 
INSERT INTO `wp_postmeta` VALUES (3712, 316, '_vision_3_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3713, 316, 'vision_3_title_rollover', '300'); 
INSERT INTO `wp_postmeta` VALUES (3714, 316, '_vision_3_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3715, 316, 'vision_3_text', '296'); 
INSERT INTO `wp_postmeta` VALUES (3716, 316, '_vision_3_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3717, 316, 'vision_4_title', '286'); 
INSERT INTO `wp_postmeta` VALUES (3718, 316, '_vision_4_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3719, 316, 'vision_4_title_rollover', '285'); 
INSERT INTO `wp_postmeta` VALUES (3720, 316, '_vision_4_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3721, 316, 'vision_4_text', '305'); 
INSERT INTO `wp_postmeta` VALUES (3722, 316, '_vision_4_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3723, 316, 'vision_5_title', '294'); 
INSERT INTO `wp_postmeta` VALUES (3724, 316, '_vision_5_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3725, 316, 'vision_5_title_rollover', '283'); 
INSERT INTO `wp_postmeta` VALUES (3726, 316, '_vision_5_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3727, 316, 'vision_5_text', '303'); 
INSERT INTO `wp_postmeta` VALUES (3728, 316, '_vision_5_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3729, 316, 'vision', '6'); 
INSERT INTO `wp_postmeta` VALUES (3730, 316, '_vision', 'field_53d9a15cbd306'); 
INSERT INTO `wp_postmeta` VALUES (3731, 316, 'image_1080', '301'); 
INSERT INTO `wp_postmeta` VALUES (3732, 316, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3733, 316, 'image_1024', '301'); 
INSERT INTO `wp_postmeta` VALUES (3734, 316, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3735, 316, 'image_768', '301'); 
INSERT INTO `wp_postmeta` VALUES (3736, 316, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3737, 316, 'image_480', '301'); 
INSERT INTO `wp_postmeta` VALUES (3738, 316, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3739, 316, 'image_320', '301'); 
INSERT INTO `wp_postmeta` VALUES (3740, 316, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3741, 9, 'image_1080', '455'); 
INSERT INTO `wp_postmeta` VALUES (3742, 9, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3743, 9, 'image_1024', '301'); 
INSERT INTO `wp_postmeta` VALUES (3744, 9, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3745, 9, 'image_768', '301'); 
INSERT INTO `wp_postmeta` VALUES (3746, 9, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3747, 9, 'image_480', '301'); 
INSERT INTO `wp_postmeta` VALUES (3748, 9, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3749, 9, 'image_320', '301'); 
INSERT INTO `wp_postmeta` VALUES (3750, 9, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3751, 279, '_edit_lock', '1435013615:1'); 
INSERT INTO `wp_postmeta` VALUES (43764, 1541, '_wp_attached_file', '2014/06/contact_280.jpg'); 
INSERT INTO `wp_postmeta` VALUES (62579, 1871, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62578, 1871, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62577, 1871, 'block_photos_legende_1_subtitle', '• Bringing some elegance and a contemporary touch to the  giftbox, contrasting with the brand’s historical features.\r\n> The giftbox dimensions have been amended with a side opening and elegant fasteners. Each box is matching the corresponding label, with the contemporary outline of the bottle contrasting with the traditional champagne features.\r\n> Frederic Panaïotis, Ruinart chef de caves says: “We are really pleased with the new packaging for the Dom Ruinart Blanc de Blancs. The lighter and softer labels are more illustrative of the elegant Chardonnay style and support Dom Ruinart’s positioning as the ultimate expression of Blanc de Blancs.”'); 
INSERT INTO `wp_postmeta` VALUES (62576, 1871, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62575, 1871, 'block_photos_legende_1_title', 'Dom Ruinart Blanc de Blancs and Rosé giftboxes. 2014'); 
INSERT INTO `wp_postmeta` VALUES (62574, 1871, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62573, 1871, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62572, 1871, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62571, 1871, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62570, 1871, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62569, 1871, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (3861, 326, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:663;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_01-300x226.png";s:5:"width";i:300;s:6:"height";i:226;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_01-663x372.png";s:5:"width";i:663;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3804, 321, '_wp_attached_file', '2014/07/fussigny_xo02.png'); 
INSERT INTO `wp_postmeta` VALUES (3805, 321, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:560;s:6:"height";i:500;s:4:"file";s:25:"2014/07/fussigny_xo02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"fussigny_xo02-300x267.png";s:5:"width";i:300;s:6:"height";i:267;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo02-560x372.png";s:5:"width";i:560;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3835, 323, '_wp_attached_file', '2014/07/cointreau_01.png'); 
INSERT INTO `wp_postmeta` VALUES (3807, 322, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3808, 322, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3809, 322, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (3810, 322, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3811, 322, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3812, 322, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3813, 322, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (3814, 322, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3815, 322, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (3816, 322, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3817, 322, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (3818, 322, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3819, 322, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3820, 322, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3821, 322, 'block_photos_legende_1_title', 'Logo placing. 2001'); 
INSERT INTO `wp_postmeta` VALUES (3822, 322, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3823, 322, 'block_photos_legende_1_subtitle', 'Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (3824, 322, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3825, 322, 'block_photos_legende_2_photo_l', '320'); 
INSERT INTO `wp_postmeta` VALUES (3826, 322, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3827, 322, 'block_photos_legende_2_photo_r', '321'); 
INSERT INTO `wp_postmeta` VALUES (3828, 322, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3829, 322, 'block_photos_legende_2_title', 'à écrire'); 
INSERT INTO `wp_postmeta` VALUES (3830, 322, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3831, 322, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3832, 322, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3833, 322, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (3834, 322, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3836, 323, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:500;s:6:"height";i:500;s:4:"file";s:24:"2014/07/cointreau_01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"cointreau_01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"cointreau_01-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"cointreau_01-500x372.png";s:5:"width";i:500;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3837, 324, '_wp_attached_file', '2014/07/cointreau_02.png'); 
INSERT INTO `wp_postmeta` VALUES (3838, 324, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:561;s:6:"height";i:500;s:4:"file";s:24:"2014/07/cointreau_02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"cointreau_02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"cointreau_02-300x267.png";s:5:"width";i:300;s:6:"height";i:267;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"cointreau_02-561x372.png";s:5:"width";i:561;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3860, 326, '_wp_attached_file', '2014/07/dp_01.png'); 
INSERT INTO `wp_postmeta` VALUES (62568, 1871, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62567, 1871, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62566, 1871, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62565, 1871, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62564, 1871, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62562, 1871, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62563, 1871, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62561, 1871, 'block_photos_legende_1_photo_l', '1132'); 
INSERT INTO `wp_postmeta` VALUES (62560, 1871, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62559, 1871, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62558, 1871, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62557, 1871, 'block_photos_legende_0_subtitle', '• Expressing the brand heritage of the oldest of the great champagne houses.'); 
INSERT INTO `wp_postmeta` VALUES (62556, 1871, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3862, 327, '_wp_attached_file', '2014/07/dp_02.png'); 
INSERT INTO `wp_postmeta` VALUES (3863, 327, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:397;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_02-238x300.png";s:5:"width";i:238;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_02-397x372.png";s:5:"width";i:397;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3864, 328, '_wp_attached_file', '2014/07/dp_03.png'); 
INSERT INTO `wp_postmeta` VALUES (3865, 328, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:540;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_03.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_03-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_03-300x277.png";s:5:"width";i:300;s:6:"height";i:277;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_03-540x372.png";s:5:"width";i:540;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3866, 329, '_wp_attached_file', '2014/07/dp_04.png'); 
INSERT INTO `wp_postmeta` VALUES (3867, 329, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:540;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_04.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_04-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_04-300x277.png";s:5:"width";i:300;s:6:"height";i:277;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_04-540x372.png";s:5:"width";i:540;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3905, 331, '_wp_attached_file', '2014/06/DR01.png'); 
INSERT INTO `wp_postmeta` VALUES (66326, 1916, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66325, 1916, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66324, 1916, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66323, 1916, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66322, 1916, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66317, 1916, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (66318, 1916, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66319, 1916, 'block_photos_legende_2_photo_r', '353'); 
INSERT INTO `wp_postmeta` VALUES (66320, 1916, '_block_photos_legende_2_photo_r', 'field_5