# WordPress MySQL database backup
#
# Generated: Monday 22. June 2015 21:15 UTC
# Hostname: localhost
# Database: `pierrekatzweb`
# --------------------------------------------------------
# --------------------------------------------------------
# Table: `wp_commentmeta`
# --------------------------------------------------------


#
# Delete any existing table `wp_commentmeta`
#

DROP TABLE IF EXISTS `wp_commentmeta`;


#
# Table structure of table `wp_commentmeta`
#

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_commentmeta`
#

#
# End of data contents of table `wp_commentmeta`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_comments`
# --------------------------------------------------------


#
# Delete any existing table `wp_comments`
#

DROP TABLE IF EXISTS `wp_comments`;


#
# Table structure of table `wp_comments`
#

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_comments`
#
 
INSERT INTO `wp_comments` VALUES (1, 1, 'Monsieur WordPress', '', 'https://wordpress.org/', '', '2014-06-01 21:05:40', '2014-06-01 21:05:40', 'Bonjour, ceci est un commentaire.\nPour supprimer un commentaire, connectez-vous et affichez les commentaires de cet article. Vous pourrez alors les modifier ou les supprimer.', 0, '1', '', '', 0, 0);
#
# End of data contents of table `wp_comments`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_links`
# --------------------------------------------------------


#
# Delete any existing table `wp_links`
#

DROP TABLE IF EXISTS `wp_links`;


#
# Table structure of table `wp_links`
#

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_links`
#

#
# End of data contents of table `wp_links`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_options`
# --------------------------------------------------------


#
# Delete any existing table `wp_options`
#

DROP TABLE IF EXISTS `wp_options`;


#
# Table structure of table `wp_options`
#

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=6644 DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_options`
#
 
INSERT INTO `wp_options` VALUES (1, 'siteurl', 'http://pierrekatz.com/temp', 'yes'); 
INSERT INTO `wp_options` VALUES (2, 'blogname', 'Pierre Katz', 'yes'); 
INSERT INTO `wp_options` VALUES (3, 'blogdescription', '', 'yes'); 
INSERT INTO `wp_options` VALUES (4, 'users_can_register', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5, 'admin_email', 'tran@fruitdudragon.com', 'yes'); 
INSERT INTO `wp_options` VALUES (6, 'start_of_week', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (7, 'use_balanceTags', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (8, 'use_smilies', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (9, 'require_name_email', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (10, 'comments_notify', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (11, 'posts_per_rss', '10', 'yes'); 
INSERT INTO `wp_options` VALUES (12, 'rss_use_excerpt', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (13, 'mailserver_url', 'mail.example.com', 'yes'); 
INSERT INTO `wp_options` VALUES (14, 'mailserver_login', 'login@example.com', 'yes'); 
INSERT INTO `wp_options` VALUES (15, 'mailserver_pass', 'password', 'yes'); 
INSERT INTO `wp_options` VALUES (16, 'mailserver_port', '110', 'yes'); 
INSERT INTO `wp_options` VALUES (17, 'default_category', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (18, 'default_comment_status', 'open', 'yes'); 
INSERT INTO `wp_options` VALUES (19, 'default_ping_status', 'open', 'yes'); 
INSERT INTO `wp_options` VALUES (20, 'default_pingback_flag', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (21, 'posts_per_page', '10', 'yes'); 
INSERT INTO `wp_options` VALUES (22, 'date_format', 'j F Y', 'yes'); 
INSERT INTO `wp_options` VALUES (23, 'time_format', 'G \\h i \\m\\i\\n', 'yes'); 
INSERT INTO `wp_options` VALUES (24, 'links_updated_date_format', 'j F Y G \\h i \\m\\i\\n', 'yes'); 
INSERT INTO `wp_options` VALUES (25, 'comment_moderation', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (26, 'moderation_notify', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (27, 'permalink_structure', '/%postname%/', 'yes'); 
INSERT INTO `wp_options` VALUES (28, 'gzipcompression', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (29, 'hack_file', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (30, 'blog_charset', 'UTF-8', 'yes'); 
INSERT INTO `wp_options` VALUES (31, 'moderation_keys', '', 'no'); 
INSERT INTO `wp_options` VALUES (32, 'active_plugins', 'a:14:{i:0;s:29:"acf-repeater/acf-repeater.php";i:1;s:33:"admin-menu-editor/menu-editor.php";i:2;s:30:"advanced-custom-fields/acf.php";i:3;s:35:"comment-control/comment-control.php";i:4;s:33:"duplicate-post/duplicate-post.php";i:5;s:27:"katz-enhance-admin/main.php";i:6;s:37:"post-types-order/post-types-order.php";i:7;s:40:"sitepress-multilingual-cms/sitepress.php";i:8;s:41:"taxonomy-converter/taxonomy-converter.php";i:9;s:114:"tinymce-and-tinymce-advanced-professsional-formats-and-styles/tinymce-advanced-professional-formats-and-styles.php";i:10;s:41:"wordpress-importer/wordpress-importer.php";i:11;s:29:"wp-db-backup/wp-db-backup.php";i:12;s:34:"wpml-string-translation/plugin.php";i:13;s:38:"wpml-translation-management/plugin.php";}', 'yes'); 
INSERT INTO `wp_options` VALUES (33, 'home', 'http://pierrekatz.com/temp', 'yes'); 
INSERT INTO `wp_options` VALUES (34, 'category_base', '', 'yes'); 
INSERT INTO `wp_options` VALUES (35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'); 
INSERT INTO `wp_options` VALUES (36, 'advanced_edit', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (37, 'comment_max_links', '2', 'yes'); 
INSERT INTO `wp_options` VALUES (38, 'gmt_offset', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (39, 'default_email_category', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (40, 'recently_edited', '', 'no'); 
INSERT INTO `wp_options` VALUES (41, 'template', 'fruitdudragon', 'yes'); 
INSERT INTO `wp_options` VALUES (42, 'stylesheet', 'katz', 'yes'); 
INSERT INTO `wp_options` VALUES (43, 'comment_whitelist', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (44, 'blacklist_keys', '', 'no'); 
INSERT INTO `wp_options` VALUES (45, 'comment_registration', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (46, 'html_type', 'text/html', 'yes'); 
INSERT INTO `wp_options` VALUES (47, 'use_trackback', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (48, 'default_role', 'subscriber', 'yes'); 
INSERT INTO `wp_options` VALUES (49, 'db_version', '27916', 'yes'); 
INSERT INTO `wp_options` VALUES (50, 'uploads_use_yearmonth_folders', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (51, 'upload_path', '', 'yes'); 
INSERT INTO `wp_options` VALUES (52, 'blog_public', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (53, 'default_link_category', '2', 'yes'); 
INSERT INTO `wp_options` VALUES (54, 'show_on_front', 'page', 'yes'); 
INSERT INTO `wp_options` VALUES (55, 'tag_base', '', 'yes'); 
INSERT INTO `wp_options` VALUES (56, 'show_avatars', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (57, 'avatar_rating', 'G', 'yes'); 
INSERT INTO `wp_options` VALUES (58, 'upload_url_path', '', 'yes'); 
INSERT INTO `wp_options` VALUES (59, 'thumbnail_size_w', '150', 'yes'); 
INSERT INTO `wp_options` VALUES (60, 'thumbnail_size_h', '150', 'yes'); 
INSERT INTO `wp_options` VALUES (61, 'thumbnail_crop', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (62, 'medium_size_w', '300', 'yes'); 
INSERT INTO `wp_options` VALUES (63, 'medium_size_h', '300', 'yes'); 
INSERT INTO `wp_options` VALUES (64, 'avatar_default', 'mystery', 'yes'); 
INSERT INTO `wp_options` VALUES (65, 'large_size_w', '1024', 'yes'); 
INSERT INTO `wp_options` VALUES (66, 'large_size_h', '1024', 'yes'); 
INSERT INTO `wp_options` VALUES (67, 'image_default_link_type', 'file', 'yes'); 
INSERT INTO `wp_options` VALUES (68, 'image_default_size', '', 'yes'); 
INSERT INTO `wp_options` VALUES (69, 'image_default_align', '', 'yes'); 
INSERT INTO `wp_options` VALUES (70, 'close_comments_for_old_posts', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (71, 'close_comments_days_old', '14', 'yes'); 
INSERT INTO `wp_options` VALUES (72, 'thread_comments', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (73, 'thread_comments_depth', '5', 'yes'); 
INSERT INTO `wp_options` VALUES (74, 'page_comments', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (75, 'comments_per_page', '50', 'yes'); 
INSERT INTO `wp_options` VALUES (76, 'default_comments_page', 'newest', 'yes'); 
INSERT INTO `wp_options` VALUES (77, 'comment_order', 'asc', 'yes'); 
INSERT INTO `wp_options` VALUES (78, 'sticky_posts', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (79, 'widget_categories', 'a:2:{i:2;a:4:{s:5:"title";s:10:"Categories";s:5:"count";i:0;s:12:"hierarchical";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (80, 'widget_text', 'a:2:{i:2;a:3:{s:5:"title";b:0;s:4:"text";s:85:"« The definition of an expert is someone who knows what not to do. » Charles Wilson";s:6:"filter";b:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (81, 'widget_rss', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (82, 'uninstall_plugins', 'a:1:{s:114:"tinymce-and-tinymce-advanced-professsional-formats-and-styles/tinymce-advanced-professional-formats-and-styles.php";s:17:"bb_taps_uninstall";}', 'no'); 
INSERT INTO `wp_options` VALUES (83, 'timezone_string', '', 'yes'); 
INSERT INTO `wp_options` VALUES (84, 'page_for_posts', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (85, 'page_on_front', '5', 'yes'); 
INSERT INTO `wp_options` VALUES (86, 'default_post_format', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (87, 'link_manager_enabled', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (88, 'initial_db_version', '27916', 'yes'); 
INSERT INTO `wp_options` VALUES (89, 'wp_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:78:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:9:"add_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:34:"wpml_manage_translation_management";b:1;s:21:"wpml_manage_languages";b:1;s:41:"wpml_manage_theme_and_plugin_localization";b:1;s:19:"wpml_manage_support";b:1;s:29:"wpml_manage_media_translation";b:1;s:22:"wpml_manage_navigation";b:1;s:24:"wpml_manage_sticky_links";b:1;s:30:"wpml_manage_string_translation";b:1;s:33:"wpml_manage_translation_analytics";b:1;s:25:"wpml_manage_wp_menus_sync";b:1;s:32:"wpml_manage_taxonomy_translation";b:1;s:27:"wpml_manage_troubleshooting";b:1;s:31:"wpml_manage_translation_options";b:1;s:36:"wpml_manage_woocommerce_multilingual";b:1;s:37:"wpml_operate_woocommerce_multilingual";b:1;s:10:"copy_posts";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:35:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:10:"copy_posts";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (90, 'widget_search', 'a:2:{i:2;a:1:{s:5:"title";s:6:"Search";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (91, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:"title";s:12:"Recent Posts";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (92, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:"title";s:15:"Recent Comments";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (93, 'widget_archives', 'a:2:{i:2;a:3:{s:5:"title";s:8:"Archives";s:5:"count";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (94, 'widget_meta', 'a:2:{i:2;a:1:{s:5:"title";s:4:"Meta";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (95, 'sidebars_widgets', 'a:5:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:7:{i:0;s:21:"icl_lang_sel_widget-1";i:1;s:8:"search-2";i:2;s:14:"recent-posts-2";i:3;s:17:"recent-comments-2";i:4;s:10:"archives-2";i:5;s:12:"categories-2";i:6;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:1:{i:0;s:6:"text-2";}s:13:"array_version";i:3;}', 'yes'); 
INSERT INTO `wp_options` VALUES (96, 'cron', 'a:6:{i:1435008070;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1435021903;a:1:{s:24:"update_wpml_config_index";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1435040640;a:1:{s:20:"wp_maybe_auto_update";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1435050381;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1435093666;a:1:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}s:7:"version";i:2;}', 'yes'); 
INSERT INTO `wp_options` VALUES (1418, 'auto_core_update_notified', 'a:4:{s:4:"type";s:6:"manual";s:5:"email";s:22:"tran@fruitdudragon.com";s:7:"version";s:5:"4.2.2";s:9:"timestamp";i:1431508014;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6629, '_site_transient_timeout_theme_roots', '1435008921', 'yes'); 
INSERT INTO `wp_options` VALUES (6630, '_site_transient_theme_roots', 'a:5:{s:13:"fruitdudragon";s:7:"/themes";s:4:"katz";s:7:"/themes";s:14:"twentyfourteen";s:7:"/themes";s:14:"twentythirteen";s:7:"/themes";s:12:"twentytwelve";s:7:"/themes";}', 'yes'); 
INSERT INTO `wp_options` VALUES (106, 'can_compress_scripts', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (107, '_transient_timeout_feed_66a70e9599b658d5cc038e8074597e7c', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (108, '_transient_feed_66a70e9599b658d5cc038e8074597e7c', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:51:"\n	\n	\n	\n	\n	\n	\n		\n		\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"WordPress Francophone";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:27:"http://www.wordpress-fr.net";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:70:"La communauté francophone autour du CMS WordPress et son écosystème";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 27 May 2014 06:26:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"fr-FR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:27:"http://wordpress.org/?v=3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"L’Hebdo WordPress n°230 : WordPress 4.0 – Jetpack 3.0 – WPTech 2014";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:108:"http://www.wordpress-fr.net/2014/05/27/lhebdo-wordpress-n230-wordpress-4-0-jetpack-3-0-wptech-2014/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 27 May 2014 05:23:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:11:"Evènements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:11:"communauté";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:7:"Jetpack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7067";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:423:"WordPress 4.0 Déjà quelques précisions concernant l&#8217;internationalisation dans WordPress 4.0 (en). Jetpack 3.0 Jetpack passe en version 3.0 et se relooke en partie. WPTech 2014 WPTech est la première édition d&#8217;une manifestation consacrée à WordPress, mais uniquement du côté technique du sujet. L&#8217;idée vient d&#8217;une partie de la communauté nantaise. Bravo à elle&#8230;. et déjà [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3752:"<h3>WordPress 4.0</h3>\n<p>Déjà quelques précisions concernant l&rsquo;<a href="http://make.wordpress.org/core/2014/05/21/internationalization-goals-for-4-0/">internationalisation dans WordPress 4.0</a> (en).</p>\n<h3>Jetpack 3.0</h3>\n<p><a href="http://jetpack.me/2014/05/20/jetpack-3-0/">Jetpack passe en version 3.0</a> et se relooke en partie.</p>\n<h3>WPTech 2014</h3>\n<p><a href="http://2014.wptech.fr/">WPTech</a> est la première édition d&rsquo;une manifestation consacrée à WordPress, mais uniquement du côté technique du sujet. L&rsquo;idée vient d&rsquo;une partie de la communauté nantaise. Bravo à elle&#8230;. et déjà <a href="http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/">on en parle sur le web</a>.</p>\n<h3>Les meetups franciliens se &laquo;&nbsp;veryfrenchtripise&nbsp;&raquo;</h3>\n<p>Organisés par une bonne partie de la Very French Trip team <a href="http://veryfrenchtrip-wp.eu/meetup-wordpress-23-mai-14-paris/">les meetups franciliens cherchent à évoluer</a>.</p>\n<h3>Un superhéros WordPress, c&rsquo;est quoi ?</h3>\n<p><a href="http://www.wppourlesnuls.com/comment-devenir-un-super-heros-wordpress-infographie/">La réponse en infographie</a>.</p>\n<h3>Interview de Rodrigue Fénard</h3>\n<p><a href="http://lesdoigtsdanslenet.com/rodrigue-fenard-specialiste-wordpress/">Rodrigue </a>est interviewé par les Doigts dans le Net.</p>\n<h3>Utiliser les &laquo;&nbsp;social meta tags&nbsp;&raquo; de WordPress</h3>\n<p>Pour en savoir plus sur les social meta tags, un conseil,<a href="http://www.wpexplorer.com/setup-open-graph-twitter-cards-wordpress/"> lisez cet article </a>(en).</p>\n<h3>Le VFT Podcast n°1</h3>\n<p><a href="http://veryfrenchtrip-wp.eu/podcast-1/">Un nouveau podcast est toujours un événement </a>mais quand il est français et réalisé par une bande de joyeux lurons comme la VFT team alors on y va les yeux fermés (ça tombe bien, y a pas d&rsquo;images !)<br />\n<em><strong>Ajout :</strong></em> Pour suivre le podcast, abonnez-vous via ce flux : <a href="http://veryfrenchtrip-wp.eu/flux/podcast/feed/">http://veryfrenchtrip-wp.eu/flux/podcast/feed/</a></p>\n<h3>Google dans son site WordPress</h3>\n<p>Pour intégrer les<a href="http://premium.wpmudev.org/blog/wordpress-google-plugins/"> outils de Google dans votre site</a> (en), voici quelques idées.</p>\n<h3>Du support client embarqué</h3>\n<p>Avec <a href="http://issuepress.co/">IssuePress (en)</a>, il devient possible d&rsquo;embarquer son propre service client dans son interface d&rsquo;administrateur.</p>\n<h3>Une page de connexion personnalisée</h3>\n<p>Créer une page de connexion personnalisée est possible&#8230; <a href="http://premium.wpmudev.org/blog/create-a-custom-wordpress-login-page/">voici la méthode</a> (en).</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/P6DmqnLdfQ4" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:104:"http://www.wordpress-fr.net/2014/05/27/lhebdo-wordpress-n230-wordpress-4-0-jetpack-3-0-wptech-2014/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"6";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:99:"http://www.wordpress-fr.net/2014/05/27/lhebdo-wordpress-n230-wordpress-4-0-jetpack-3-0-wptech-2014/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:48:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"L’Hebdo WordPress n°229 : Communautés – Extensions – Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/5ZwQnV00lFY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://www.wordpress-fr.net/2014/05/20/lhebdo-wordpress-n229-communautes-extensions-astuces/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 20 May 2014 05:23:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:7:"Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:11:"communauté";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7039";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:339:"Les Communautés Bordeaux WordPress&#8217;Camp #10 Pour la 10e édition de cette réunion bordelaise, il sera question de sécurité et de maintenance. Elle aura lieu le 12 juin à 18 H 30. Meetup à Lyon Dès ce jeudi 22 mai, Lyon propose un meetup autour de WordPress et de l&#8217;extension ACF. Meetup à Paris La communauté [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3399:"<h2>Les Communautés</h2>\n<h3>Bordeaux WordPress&rsquo;Camp #10</h3>\n<p>Pour la 10e édition de cette réunion bordelaise, il sera question <a href="https://www.facebook.com/events/1485744844988525/">de sécurité et de maintenance</a>. Elle aura lieu le 12 juin à 18 H 30.</p>\n<h3>Meetup à Lyon</h3>\n<p>Dès ce jeudi 22 mai, Lyon propose un <a href="http://www.meetup.com/WordPress-Lyon-Meetup/">meetup autour de WordPress et de l&rsquo;extension ACF</a>.</p>\n<h3>Meetup à Paris</h3>\n<p>La <a href="http://www.meetup.com/wordpress-ile-de-france/">communauté parisienne se réunie le vendredi 23 mai </a>autour d&rsquo;un verre.</p>\n<h3>Meetup WordPress in Alps</h3>\n<p>La <a href="http://www.wpinalps.com/#prochaine-rencontre">communauté alpine se retrouvera le 10 juin</a>, à l&rsquo;initiative de l&rsquo;association WordPress in Alps. La réunion est prévue à Grenoble.</p>\n<h3>Faire du CRM avec WordPress</h3>\n<p>Si vous souhaitez vous lancer dans le <a href="https://kinsta.com/blog/crm-wordpress-plugins/">CRM avec WordPress</a> (en), ces extensions et conseils vous seront utiles.</p>\n<h3>Font Awsome intègre WordPress</h3>\n<p>La police de caractère <a href="http://fontawesome.io/whats-new/">Font Awsome vient d&rsquo;intégrer une icône de WordPress</a> (en) dans sa nouvelle mise à jour.</p>\n<h3>4 optimisations simples pour booster le SEO</h3>\n<p>Lumière de Lune explique comment, <a href="http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05">en 4 points, on peut optimiser un site pour le SEO.</a></p>\n<h3>Une favicon bien faite</h3>\n<p>WPChannel montre comment <a href="http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/">faire une favicon</a> digne de ce nom pour votre site sous WordPress.</p>\n<h3>Construire un job-board</h3>\n<p>WordPress peut désormais se transformer en un véritable job board grâce à cette extension : <a href="http://www.poststat.us/building-new-wp-job-manager-website/">WP Job Manager</a>.</p>\n<h3>Une communauté de traducteurs</h3>\n<p>WordPress étant international, il est logique de voir apparaitre une <a href="http://wp-translations.org/lets-create-community-together/">communauté de traducteurs</a> (en).</p>\n<h3>Bien choisir un hébergement</h3>\n<p>Quelques <a href="http://wpformation.com/choisir-hebergement-wordpress">conseils de Fabrice</a> pour choisir son hébergement pour WordPress.</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/5ZwQnV00lFY" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://www.wordpress-fr.net/2014/05/20/lhebdo-wordpress-n229-communautes-extensions-astuces/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://www.wordpress-fr.net/2014/05/20/lhebdo-wordpress-n229-communautes-extensions-astuces/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"L’Hebdo WordPress n°228 : Android – BuddyPress – Scrap";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wpCN_XlMPRo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:95:"http://www.wordpress-fr.net/2014/05/13/lhebdo-wordpress-n228-android-buddypress-scrap/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 13 May 2014 05:49:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:7:"Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:10:"Extensions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:7:"android";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7031";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:364:"WordPress pour Android 2.8 L&#8217;application WordPress pour Android arrive en version 2.8 (en). A noter que la mise à jour 2.8.1 est sortie. BuddyPress 2.0.1 La première mise à jour mineur de BuddyPress 2.0 (en) est arrivée. Les fichiers attachés dans BuddyPress iMath présente les fichiers attachés  (en) dans BuddyPress. Revenons sur 5 ans de [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:7358:"<h3>WordPress pour Android 2.8</h3>\n<p>L&rsquo;application <a href="https://android.wordpress.org/2014/05/01/wordpress-for-android-2-8/">WordPress pour Android</a> arrive en version 2.8 (en). A noter que la <a href="https://play.google.com/store/apps/details?id=org.wordpress.android">mise à jour 2.8.1</a> est sortie.</p>\n<h3>BuddyPress 2.0.1</h3>\n<p>La <a href="http://buddypress.org/2014/05/buddypress-2-0-1/">première mise à jour mineur de BuddyPress 2.0</a> (en) est arrivée.</p>\n<h3>Les fichiers attachés dans BuddyPress</h3>\n<p>iMath présente les <a href="https://bpdevel.wordpress.com/2014/05/08/attachments-in-buddypress/">fichiers attachés  </a>(en) dans BuddyPress.</p>\n<h3>Revenons sur 5 ans de BuddyPress</h3>\n<p>L&rsquo;<a href="http://teleogistic.net/2014/05/five-years-of-buddypress/">histoire de BuddyPress depuis 5 ans</a> (en).</p>\n<h3>Alerte au scrap sur les sites WordPress</h3>\n<p>Cette semaine de très nombreux sites utilisant WordPress se sont fait &laquo;&nbsp;scrapper&nbsp;&raquo;. <a href="http://wpformation.com/scrapping-masse-sites-wordpress/">Explications par Fabrice</a>.</p>\n<h3>Plus de 25 extensions à avoir en 2014</h3>\n<p>Voici une sélection des<a href="http://premium.wpmudev.org/blog/25-must-have-wordpress-plugins-for-2014/"> 25 extensions</a> (en) à ne pas rater en 2014.</p>\n<h3>Une extension qui fait vos badges de WordCamp</h3>\n<p>En marge du WordCamp de Miami, un passionné a réalisé une extension qui permet de créer <a href="http://wptavern.com/would-anyone-be-interested-in-a-wordcamp-badges-plugin">son propre badge du WordCamp Miami (en)</a>. Il réfléchi à la possibilité de faire en sorte de généraliser l&rsquo;extension pour n&rsquo;mporte quel WordCamp.</p>\n<h3>Découvrez BuddyPress</h3>\n<p><a href="http://wpchannel.com/re-decouvres-buddypress/">Si vous ne connaissez pas encore BuddyPress</a>, Mathieu vous explique tout sur WPChannel.</p>\n<h3>Une interview de Daniel Roch</h3>\n<p>Si comme moi vous aviez raté <a href="https://www.youtube.com/watch?v=_y9YXhAVec0">cette interview de Daniel Roch</a>, c&rsquo;est le moment de vous rattraper.</p>\n<h3>WP-Rocket s&rsquo;internationalise</h3>\n<p>L&rsquo;extension WP Rocket devient internationale, <a href="http://wptavern.com/wp-rocket-launches-commercial-caching-plugin-for-wordpress">WPTavern s&rsquo;en fait l&rsquo;écho</a> (en).</p>\n<h3>L&rsquo;API de TinyMCE</h3>\n<p>La version de 3.9 intègre beaucoup de nouveautés et notamment dans TinyMCE. Son intégration dans le core de WordPress apporte une nouvelle API&#8230;<a href="http://www.wpexplorer.com/wordpress-tinymce-tweaks/"> autorisant de nombreuses possibilités</a> (en). Et voici un <a href="http://www.tweetpress.fr/faqs/comment-ajouter-icone-bouton-tinymce-wordpress-3-9/">exemple de ce qu&rsquo;on peut faire</a>.</p>\n<h3>Les jetons de sécurité</h3>\n<p>Julio présente la question des <a href="http://boiteaweb.fr/jetons-securite-petit-plus-dont-vous-avez-besoin-8070.html">jetons de sécurité</a> et l&rsquo;applique à WordPress.</p>\n<h3>L&rsquo;effet FancyBox et WordPress</h3>\n<p>WPChannel explique <a href="http://wpchannel.com/fancybox-wordpress-galerie-image/">comment utiliser FancyBox sur un site WordPress</a>.</p>\n<h3>Organiser les types de contenus et les librairies</h3>\n<p>Voici <a href="http://tommcfarlin.com/organizing-wordpress-content-types-libraries/">une solution présentée</a> par Tom McFarlin (en).</p>\n<h3>Automattic lève 160 millions de dollars</h3>\n<p>Matt annonce qu&rsquo;Automattic<a href="http://ma.tt/2014/05/new-funding-for-automattic/"> lève 160 millions de dollars (en)</a>&#8230; et explique les <a href="http://techcrunch.com/2014/05/07/automattic-ceo-matt-mullenweg-talks-funding-investing-and-the-future-of-wordpress/">investissements et l&rsquo;avenir de WordPress</a> (en).</p>\n<h3>Protéger son wp-config</h3>\n<p>Si vous souhaitez protéger votre fichier wp-config.php via le fichier .htaccess<a href="http://wp-snippets.com/protect-wp-config-php-with-htaccess/"> voici comment procéder (en).</a></p>\n<h3>Une table ronde sur les hébergeurs de WordPress</h3>\n<p><a href="http://wpbacon.com/podcast/wordpress-hosting-panel/">WPBacon </a>a organisé une <a href="http://wptavern.com/highlights-of-the-wpbacon-wordpress-webhosting-roundtable">table ronde pour parler hébergements</a>. (en)</p>\n<h3>Matt Mullenweg est un homme dangereux</h3>\n<p>C&rsquo;est le titre accrocheur de cet article pour montrer la &laquo;&nbsp;peur&nbsp;&raquo; du gouvernement américain envers l&rsquo;open source en général et WordPress en particulier. <a href="http://joeflood.com/2014/05/07/matt/">Angle de vue décalé  </a>(en) pour montrer le ridicule d&rsquo;une situation loin d&rsquo;être erronée.</p>\n<h3>Création d&rsquo;une page de maintenance personnalisée</h3>\n<p>La page de maintenance par défaut de WordPress est triste à souhait ! <a href="http://www.gregoirenoyelle.com/wordpress-creation-page-maintenance-personnalisee/">Personnalisez-la grâce à Grégoire</a>.</p>\n<h3>WordPress n&rsquo;est pas un CMS</h3>\n<p>Mmmmhhh, <a href="http://www.screenfeed.fr/blog/wordpress-pas-cms-02223/">encore de la polémique dans l&rsquo;air</a>&#8230; mais là, l&rsquo;offensive est argumentée&#8230;</p>\n<h3>Évolution du nombre d&rsquo;extensions</h3>\n<p>Julio constate l&rsquo;<a href="http://boiteaweb.fr/combien-plugins-wordpress-8075.html">évolution du nombre d’extensions dans le répertoire officiel</a>.</p>\n<h3>Des séries d&rsquo;articles en liste déroulante</h3>\n<p>C&rsquo;est l&rsquo;extension <a href="http://www.echodesplugins.li-an.fr/plugins/wp-post-series/">WP Post Series</a> qui le permet.</p>\n<h3>60 thèmes typés business pour 2014</h3>\n<p>WPMUDEV présente une liste de <a href="http://premium.wpmudev.org/blog/free-responsive-wordpress-business-themes/">60 thèmes gratuits</a> (en) typés business et sortis en 2014.</p>\n<h3>Une extension peut disparaitre du répertoire officiel ?</h3>\n<p>Marie-Aude explique les raisons de la <a href="http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05">disparition d&rsquo;une extension du répertoire officiel </a>et les conséquences à en tirer.</p>\n<h3>Levé de rideau sur les nouveaux thèmes ElegantThemes</h3>\n<p>Rodrigue présente ce que va être l<a href="http://www.cree1site.com/eleganttheme-2/">&lsquo;avenir des thèmes ElegantThemes</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/wpCN_XlMPRo" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:91:"http://www.wordpress-fr.net/2014/05/13/lhebdo-wordpress-n228-android-buddypress-scrap/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"14";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:86:"http://www.wordpress-fr.net/2014/05/13/lhebdo-wordpress-n228-android-buddypress-scrap/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"WordPress 3.9.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/KpsKznAONCY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:64:"http://www.wordpress-fr.net/2014/05/09/wordpress-3-9-1/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 May 2014 16:36:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7020";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:379:"Trois semaines après le lancement de WordPress 3.9, et avec plus de 9 millions de téléchargements à son actif, nous sommes heureux de vous annoncer que WordPress 3.9.1 est disponible. Cette version de maintenance corrige 34 bugs présents dans la 3.9, parmi lesquels de nombreuses corrections concernant les réseaux multisites, la personnalisation des widgets lors [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4816:"<p>Trois semaines après le lancement de <a title="Sortie de WordPress 3.9" href="http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/">WordPress 3.9</a>, et avec plus de 9 millions de téléchargements à son actif, nous sommes heureux de vous annoncer que WordPress 3.9.1 est disponible.</p>\n<p>Cette version de maintenance corrige 34 bugs présents dans la 3.9, parmi lesquels de nombreuses corrections concernant les réseaux multisites, la personnalisation des widgets lors de la prévisualisation des thèmes et la mise à jour de l&rsquo;éditeur visuel. Nous avons aussi effectué quelques améliorations sur la nouvelle fonction de liste de lecture audio/vidéo et fait quelques retouches pour améliorer les performances. Pour voir la liste complète des changements vous pouvez consulter la <a href="https://core.trac.wordpress.org/query?milestone=3.9.1">liste des tickets (en)</a> et le <a href="https://core.trac.wordpress.org/log/branches/3.9?rev=28353&amp;stop_rev=28154">journal des changements (en)</a>.</p>\n<p>Si vous faites parties des millions d&rsquo;utilisateurs de WordPress 3.9, avons déployé la mise à jour en arrière-plan vers la 3.9.1 &#8211; Pour les sites qui le <a href="http://wordpress.org/plugins/background-update-tester/">supportent</a> (en), évidemment !</p>\n<p><a href="http://wordpress.org/download/">Dans tous les cas vous pouvez téléchargez WordPress 3.9.1</a> ou le faire manuellement depuis votre <strong>Tableau de bord → Mise à jour </strong>et simplement cliquer “Mettre à jour maintenant.”</p>\n<p>Merci beaucoup à toutes ces personnes incroyables qui ont participé au développement de WordPress 3.9.1 : <a href="http://profiles.wordpress.org/jorbin">Aaron Jorbin</a>, <a href="http://profiles.wordpress.org/nacin">Andrew Nacin</a>, <a href="http://profiles.wordpress.org/azaozz">Andrew Ozz</a>, <a href="http://profiles.wordpress.org/rzen">Brian Richards</a>, <a href="http://profiles.wordpress.org/ehg">Chris Blower</a>, <a href="http://profiles.wordpress.org/jupiterwise">Corey McKrill</a>, <a href="http://profiles.wordpress.org/danielbachhuber">Daniel Bachhuber</a>, <a href="http://profiles.wordpress.org/ocean90">Dominik Schilling</a>, <a href="http://profiles.wordpress.org/feedmeastraycat">feedmeastraycat</a>, <a href="http://profiles.wordpress.org/gcorne">Gregory Cornelius</a>, <a href="http://profiles.wordpress.org/helen">Helen Hou-Sandi</a>, <a href="http://profiles.wordpress.org/imath">imath</a>, <a href="http://profiles.wordpress.org/avryl">Janneke Van Dorpe</a>, <a href="http://profiles.wordpress.org/jeremyfelt">Jeremy Felt</a>, <a href="http://profiles.wordpress.org/johnbillion">John Blackbourn</a>, <a href="http://profiles.wordpress.org/obenland">Konstantin Obenland</a>, <a href="http://profiles.wordpress.org/lancewillett">Lance Willett</a>, <a href="http://profiles.wordpress.org/m_i_n">m_i_n</a>, <a href="http://profiles.wordpress.org/clorith">Marius Jensen</a>, <a href="http://profiles.wordpress.org/markjaquith">Mark Jaquith</a>, <a href="http://profiles.wordpress.org/dimadin">Milan Dinić</a>, <a href="http://profiles.wordpress.org/celloexpressions">Nick Halsey</a>, <a href="http://profiles.wordpress.org/pavelevap">pavelevap</a>, <a href="http://profiles.wordpress.org/wonderboymusic">Scott Taylor</a>, <a href="http://profiles.wordpress.org/SergeyBiryukov">Sergey Biryukov</a>, et <a href="http://profiles.wordpress.org/westonruter">Weston Ruter</a>.</p>\n<p><em><strong>NB</strong> : Cet article est une adaptation en français de l&rsquo;article original publié sur <a href="http://wordpress.org/news/2014/05/wordpress-3-9-1/">wordpress.org</a> (en).</em></p>\n<p><em><strong>NB2</strong> </em>:<em> La version française est disponible <a href="http://fr.wordpress.org">ici</a>.</em></p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KpsKznAONCY:cCR6KkyEM2I:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KpsKznAONCY:cCR6KkyEM2I:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KpsKznAONCY:cCR6KkyEM2I:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/KpsKznAONCY" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:60:"http://www.wordpress-fr.net/2014/05/09/wordpress-3-9-1/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:55:"http://www.wordpress-fr.net/2014/05/09/wordpress-3-9-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"L’Hebdo WordPress n°227 : SupportPress – Sondage – Polémique";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/QOlL4_ZPklY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://www.wordpress-fr.net/2014/04/29/lhebdo-wordpress-n227-supportpress-sondage-polemique/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 29 Apr 2014 19:52:34 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:7:"Brèves";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:11:"communauté";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"sondage";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:12:"SupportPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7013";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:369:"Une application pour le support : SupportPress Automattic met à disposition du public une application gratuite de gestion de support, nommée SupportPress (en). Une nouvelle communauté belge Bienvenue à la communauté WordPress de Namur en Belgique. Si vous êtes du coin, rejoignez ce groupe. Un thème et une extension dédiés à Twitter Ozh a réalisé [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2630:"<h3>Une application pour le support : SupportPress</h3>\n<p>Automattic met à disposition du public une application gratuite de gestion de support, nommée <a href="http://supportpress.com/">SupportPress</a> (en).</p>\n<h3>Une nouvelle communauté belge</h3>\n<p>Bienvenue à la communauté WordPress de Namur en Belgique. <a href="http://www.meetup.com/Namur-WordPress-Meetup/">Si vous êtes du coin, rejoignez ce groupe</a>.</p>\n<h3>Un thème et une extension dédiés à Twitter</h3>\n<p><a href="http://wptavern.com/tweet-archive-a-free-wordpress-theme-to-match-the-new-twitter-profiles">Ozh a réalisé un thème et une extension</a> (en) permettant l&rsquo;archivage de ses Tweets (en). Il vient de remettre  l&rsquo;ensemble à jour suite aux dernières retouches du site Twitter.</p>\n<h3>Un sondage pour améliorer WordPress</h3>\n<p>Si vous avez quelques instants, répondez à <a href="http://wordpressdotorg.polldaddy.com/s/wordpress-contributor-experience-poll?p=1">ce sondage concernant votre expérience de WordPress</a> (en).</p>\n<h3>Les CMS c&rsquo;est le mal ?</h3>\n<p>C&rsquo;est ce que semble penser <a href="http://www.cera-interactive.fr/cera-strasbourg/actu-du-web.php?actu=140425-joomla-wordpress-site-web">Lucas K.  </a>de Cera Interactive qui tire à boulets rouges sur les CMS. La réponse d&rsquo;un indépendant ne s&rsquo;est pas faite attendre&#8230;<a href="http://wpformation.com/faut-il-eviter-wordpress-joomla/"> en la personne de Fabrice de WPFormation</a>. Et vous qu&rsquo;en pensez-vous ?<br />\nAjout : <a href="http://www.web-eau.net/blog/entry/la-guerre-du-web-aura-t-elle-lieu">Une autre réponse ici</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=QOlL4_ZPklY:laSY97JiqPg:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=QOlL4_ZPklY:laSY97JiqPg:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=QOlL4_ZPklY:laSY97JiqPg:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/QOlL4_ZPklY" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://www.wordpress-fr.net/2014/04/29/lhebdo-wordpress-n227-supportpress-sondage-polemique/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"10";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://www.wordpress-fr.net/2014/04/29/lhebdo-wordpress-n227-supportpress-sondage-polemique/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:69:"L’Hebdo WordPress n°226 : BuddyPress 2.0 – Widgets – Dashicons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/s7zcVdwx75U/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:103:"http://www.wordpress-fr.net/2014/04/22/lhebdo-wordpress-n226-buddypress-2-0-widgets-dashicons/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 22 Apr 2014 05:28:35 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:7:"Astuces";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Brèves";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:10:"automattic";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=7003";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:379:"BuddyPress 2.0 : Juliana BuddyPress 2.0 débarque en version finale (en) et se nomme Juliana. Notons qu&#8217;iMath n&#8217;en est pas peu fier. (et il a bien raison). Explications concernant le gestionnaire de widget Depuis WordPress 3.9, le gestionnaire de widget a subi de grandes améliorations. Un petit récapitulatif est donc bienvenu (en) Automattic évalué à [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3850:"<h3>BuddyPress 2.0 : Juliana</h3>\n<p><a href="http://buddypress.org/2014/04/buddypress-2-0-juliana/">BuddyPress 2.0 débarque en version finale</a> (en) et se nomme Juliana. Notons qu&rsquo;iMath n&rsquo;<a href="http://imathi.eu/2014/04/21/my-very-own-buddypress/">en est pas peu fier</a>. (et il a bien raison).</p>\n<h3>Explications concernant le gestionnaire de widget</h3>\n<p>Depuis WordPress 3.9, le gestionnaire de widget a subi de grandes améliorations. <a href="http://make.wordpress.org/core/2014/04/17/live-widget-previews-widget-management-in-the-customizer-in-wordpress-3-9/">Un petit récapitulatif est donc bienvenu </a>(en)</p>\n<h3>Automattic évalué à 1 milliard de dollars</h3>\n<p><a href="http://mashable.com/2014/04/15/wordpress-automattic/">Après une levée de fonds  </a>(en) d&rsquo;environ <a href="http://tech.fortune.cnn.com/2014/04/15/exclusive-automattic-seeking-to-raise-more-than-100-million/">100 millions de dollars</a> (en), Automattic vaut autour d&rsquo;un milliard de dollars.</p>\n<h3>Le 16e hook de la semaine</h3>\n<p>Julio propose son 16e hook de la semaine avec <code><a href="http://boiteaweb.fr/theme_page_templates-hook-semaine-16-8033.html">theme_page_templates</a>.</code></p>\n<h3> Concevoir un système d&rsquo;espace membre</h3>\n<p>Willy explique comment <a href="http://wabeo.fr/espace-membre-wordpress/">concevoir un système d&rsquo;espace membre</a> dans WordPress.</p>\n<h3>La liste des dashicons</h3>\n<p><a href="http://melchoyce.github.io/dashicons/">Voici une liste des dashicons</a> avec possibilité de les copier pour les insérer chez vous. Vous trouverez aussi les <a href="http://make.wordpress.org/core/2014/04/16/dashicons-in-wordpress-3-9/">nouvelles dashicons de la version 3.9</a> (en).</p>\n<h3>Un site WordPress, ça prend du temps</h3>\n<p>Fabrice explique <a href="http://wpformation.com/site-wordpress-professionnel/">pourquoi un site WordPress prend du temps</a>.</p>\n<h3>Hueman, un thème plein de ressources</h3>\n<p>Li-An fait découvrir un thème gratuit intéressant. <a href="http://www.echodesplugins.li-an.fr/themes/hueman/">Hueman </a>est un thème responsive plein de ressources.</p>\n<h3>Corriger les erreurs 404</h3>\n<p>Les erreurs 404 peuvent être évitées sur votre site. <a href="http://wpformation.com/erreurs-404-wordpress/">Voici comment faire</a>.</p>\n<h3>Éviter le contenu dupliqué</h3>\n<p>Julio propose de montrer comment <a href="http://boiteaweb.fr/eviter-duplicate-content-archives-categories-8027.html">éviter les contenus dupliqués</a> (&laquo;&nbsp;duplicate content&nbsp;&raquo;).</p>\n<h3>Séparer la fonctionnalité de la forme</h3>\n<p>Un article qui s&rsquo;adresse surtout aux développeurs de thèmes. <a href="http://www.tweetpress.fr/screencast/plugin-fonctionnalites/">Julien leur conseille de séparer la forme des fonctionnalités</a>.</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=s7zcVdwx75U:nmUPtOjyecs:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=s7zcVdwx75U:nmUPtOjyecs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=s7zcVdwx75U:nmUPtOjyecs:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/s7zcVdwx75U" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:99:"http://www.wordpress-fr.net/2014/04/22/lhebdo-wordpress-n226-buddypress-2-0-widgets-dashicons/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:94:"http://www.wordpress-fr.net/2014/04/22/lhebdo-wordpress-n226-buddypress-2-0-widgets-dashicons/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:48:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"À propos de la traduction française de WordPress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/3CW90ipEYuM/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://www.wordpress-fr.net/2014/04/18/a-propos-de-la-traduction-francaise-de-wordpress-3-9/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 18 Apr 2014 17:57:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:10:"Traduction";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6991";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:451:"Version courte La traduction présentait certains problèmes et erreurs. Nous vous conseillons de la mettre à jour : Soit en cliquant sur le bouton &#171;&#160;Ré-installer maintenant&#160;&#187; de votre page Tableau de bord &#62; Mises à jour. Soit en téléchargeant le fichier fr_FR.mo corrigé et en le mettant en ligne dans votre dossier /wp-content/languages/, en remplacement du fichier fr_FR.mo en place. Par ailleurs, si [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Xavier";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:7326:"<h3>Version courte</h3>\n<p>La traduction présentait certains problèmes et erreurs. Nous vous conseillons de la mettre à jour :</p>\n<ul>\n<li>Soit en cliquant sur le bouton &laquo;&nbsp;Ré-installer maintenant&nbsp;&raquo; de votre page Tableau de bord &gt; Mises à jour.</li>\n<li>Soit en téléchargeant le <a href="http://i18n.svn.wordpress.org/fr_FR/branches/3.9/messages/fr_FR.mo">fichier <code>fr_FR.mo</code> corrigé</a> et en le mettant en ligne dans votre dossier <code>/wp-content/languages/</code>, en remplacement du fichier <code>fr_FR.mo</code> en place.</li>\n</ul>\n<p>Par ailleurs, si votre éditeur visuel est cassé depuis le passage à la 3.9, ce n&rsquo;est sans doute pas dû à la traduction, mais plutôt à l&rsquo;une de vos extensions qui utilisent/étendent l&rsquo;éditeur (TinyMCE). Désactivez-les une à une !</p>\n<h3>Version longue</h3>\n<p>La traduction présentait donc des problèmes :</p>\n<ul>\n<li>L&rsquo;adresse du lien &laquo;&nbsp;Remarque&nbsp;&raquo; du menu WordPress (en haut à gauche de l&rsquo;administration) renvoyait vers &laquo;&nbsp;https://wordpress.org/support/forum/requests-and-feedback(enanglais)&nbsp;&raquo; &#8212; oui, avec &laquo;&nbsp;(en anglais)&nbsp;&raquo; dans l&rsquo;adresse !</li>\n<li>Le mot &laquo;&nbsp;PrestaShop&nbsp;&raquo; apparaissait à la place de &laquo;&nbsp;WordPress&nbsp;&raquo; dans trois chaînes de l&rsquo;outil de personnalisation des thèmes ! <a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=487408#p487408">Explication</a> : PrestaShop est mon employeur, j&rsquo;écris les documentations du logiciel, et je tape donc ce mot à longueur de journée. Je suppose que le soir venu, mes doigts ont glissé&#8230;</li>\n<li>Et surtout, les grands chiffres (supérieurs à 999) sont affichés avec une esperluette (&amp;) : 1&amp;234, 357&amp;156, etc.</li>\n</ul>\n<p>Explication de ce dernier point : <a href="http://fr.wikipedia.org/wiki/Espace_ins%C3%A9cable">en typographie française</a>, il faut utiliser une espace insécable comme séparateur de groupes de trois chiffres dans les nombres par tranches de mille pour la partie entière et la partie décimale (1 234 567 plutôt que 1234567, donc). Ce n&rsquo;est pas possible dans toutes les situations, mais ça l&rsquo;est dans WordPress grâce à une clef de traduction propre à cela :  <code>number_format_thousands_sep</code> (séparateur de milliers). Et donc nous, traducteurs, de traduire le point du standard américain en une espace insécable, qui en HTML s&rsquo;écrit avec l&rsquo;entité &laquo;&nbsp;&amp;nbsp;&nbsp;&raquo;</p>\n<p>L&rsquo;arrivée de ce séparateur (<a href="https://core.trac.wordpress.org/ticket/3677">il y a plus de sept ans</a>, avec <a href="http://codex.wordpress.org/Version_2.3#Internationalization_and_Localization">WordPress 2.3</a> !) avait déjà provoqué des problèmes une fois que la traduction l&rsquo;a pris en compte, <a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=427804">tant en français</a> (<a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=427776#p427776">explication de Guy à l&rsquo;époque de v3.5</a>) que pour <a href="http://wordpress.org/ideas/topic/multi-char-thousands-separator-french-russian-czech-etc">d&rsquo;autres locales</a> (<a href="https://core.trac.wordpress.org/ticket/10373">ticket sur le Trac WP</a>, <a href="https://core.trac.wordpress.org/ticket/10373#comment:8">possible solution</a>).</p>\n<p>Si vous voulez tester mais que vous n&rsquo;avez pas assez d&rsquo;articles, commentaires, médias ou indésirables, une astuce : faites un recherche d&rsquo;extension avec le mot-clé &laquo;&nbsp;widget&nbsp;&raquo; (<code>/wp-admin/plugin-install.php?tab=search&amp;type=tag&amp;s=widget</code>), et regardez le nombre de résultats.</p>\n<p>Le problème ne vient pas de WordPress mais de PHP : dans les versions antérieures à PHP 5.4.0, la méthode <a href="http://www.php.net/manual/en/function.number-format.php"><code>number_format()</code></a> ne prenait en compte que le premier octet, soit en français comme dans d&rsquo;autres langues nécessitant une espace insécable pour la séparation de milliers, le &laquo;&nbsp;&amp;&nbsp;&raquo; de &laquo;&nbsp;&amp;nbsp;&nbsp;&raquo; (cf. la section &laquo;&nbsp;Changelog&nbsp;&raquo; dans la page de cette fonction PHP.<br />\nC&rsquo;est pourquoi les <a href="http://www.wordpress-fr.net/support/viewtopic.php?pid=487647#p487647">récents témoignages que nous avons reçus</a> tendent à montrer que le problème ne survient qu&rsquo;avec une version de PHP inférieure à la 5.4.</p>\n<p>Mais alors, si nous étions déjà au courant de ce problème avec &amp;nbsp; depuis (au moins) la version 3.5 de WordPress, pourquoi le retrouve-t-on dans la 3.8 et la 3.9 ? L&rsquo;explication est simplement humaine : le nombre de chaînes à traduire à chaque sortie, l&rsquo;envie de bien faire, et l&rsquo;oubli des discussions des années passées. J&rsquo;espère que cet article maintiendra le problème en mémoire, jusqu&rsquo;à mise en place d&rsquo;une solution pérenne (cf. la possible solution liée plus haut, que nous mettrons en place pour WP 3.9.1).</p>\n<p>Merci de votre compréhension, et mettez à jour votre traduction ! <img src="http://www.wordpress-fr.net/wp-includes/images/smilies/icon_smile.gif" alt=":)" class="wp-smiley" /> </p>\n<p><strong>Ajout du 22 avril</strong> : la traduction d&rsquo;Akismet 3.0 a également été corrigée ! Elle sera à jour dans la version 3.9.1 de WordPress, mais d&rsquo;ici-là, vous pouvez exporter le fichier .mo en suivant ce processus :</p>\n<ul>\n<li>Allez sur <a href="http://translate.wordpress.org/projects/wp-plugins/akismet/dev/fr/default">http://translate.wordpress.org/projects/wp-plugins/akismet/dev/fr/default</a></li>\n<li>En bas de l&rsquo;écran, sélectionnez &laquo;&nbsp;Machine Object Message catalog (.mo)&nbsp;&raquo;.</li>\n<li>Cliquez sur &laquo;&nbsp;Export&nbsp;&raquo;.</li>\n<li>Renommez le fichier téléchargé &laquo;&nbsp;<code>wp-plugins-akismet-dev-fr.mo</code>&nbsp;&raquo; en &laquo;&nbsp;<code>akismet-fr_FR.mo</code>&laquo;&nbsp;.</li>\n<li>Mettez ce fichier <code>akismet-fr_FR.mo</code> dans le dossier <code>/wp-content/languages/plugins</code> de votre installation de WordPress.</li>\n</ul>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=3CW90ipEYuM:xYH023NF7xM:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=3CW90ipEYuM:xYH023NF7xM:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=3CW90ipEYuM:xYH023NF7xM:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/3CW90ipEYuM" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://www.wordpress-fr.net/2014/04/18/a-propos-de-la-traduction-francaise-de-wordpress-3-9/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"17";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://www.wordpress-fr.net/2014/04/18/a-propos-de-la-traduction-francaise-de-wordpress-3-9/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Sortie de WordPress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wPvO98ucIP4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:72:"http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 16 Apr 2014 22:04:10 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6978";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:393:"La version 3.9 de WordPress, baptisée &#171;&#160;Smith&#160;&#187; en l&#8217;honneur de l&#8217;organiste de jazz Jimmy Smith, est disponible  en téléchargement ou en mise à jour depuis le tableau de bord de votre site WordPress. Cette version apporte un grand nombre d’améliorations, et nous pensons que vous allez les adorer. Un processus de modification des médias plus [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Xavier";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5960:"<p>La version 3.9 de WordPress, baptisée &laquo;&nbsp;Smith&nbsp;&raquo; en l&rsquo;honneur de l&rsquo;organiste de jazz <a href="http://fr.wikipedia.org/wiki/Jimmy_Smith">Jimmy Smith</a>, est disponible  <a href="http://wordpress.org/download/">en téléchargement</a> ou en mise à jour depuis le tableau de bord de votre site WordPress. Cette version apporte un grand nombre d’améliorations, et nous pensons que vous allez les adorer.</p>\n<p><embed width="400" height="224" type="application/x-shockwave-flash" src="http://s0.videopress.com/player.swf?v=1.03" wmode="direct" seamlesstabbing="true" allowfullscreen="allowfullscreen" allowscriptaccess="always" overstretch="true" flashvars="guid=sAiXhCfV&amp;isDynamicSeeking=true"></embed></p>\n<h2 class="about-headline-callout"><em>Un processus de modification des médias plus fluide</em></h2>\n<h4>Édition visuelle améliorée</h4>\n<p><img class="alignnone wp-image-6979 size-full" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/editor1-300x233.jpg" alt="editor1-300x233" width="300" height="233" /></p>\n<p>L’éditeur visuel a été mis à jour pour gagner en vitesse, en accessibilité et en utilisation mobile. Vous pouvez coller vos écrits depuis votre éditeur de texte sans perdre de temps à nettoyer sa mise en page désordonnée (oui, c’est de toi que l’on parle, Microsoft Word).</p>\n<h4>Modifiez les images facilement</h4>\n<p><img class="alignnone size-full wp-image-6980" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/image1-300x233.jpg" alt="image1-300x233" width="300" height="233" /></p>\n<p>Avec un accès plus rapide aux outils de recadrage et de rotation, il est désormais plus facile de modifier vos images tandis que vous corrigez vos articles. Vous pouvez également changer l’échelle des images directement dans l’éditeur afin de trouver la taille qui convient.</p>\n<h4>Glissez/déposez vos images</h4>\n<p><img class="alignnone size-full wp-image-6981" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/dragdrop1-300x233.jpg" alt="dragdrop1-300x233" width="300" height="233" /></p>\n<p>La mise en ligne des images n’a jamais été aussi simple. Glissez simplement vos fichiers depuis votre ordinateur vers l’éditeur visuel.</p>\n<h4>Prévisualisation de galerie</h4>\n<p><img class="alignnone wp-image-6982 size-large" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/gallery1-500x280.jpg" alt="gallery1" width="500" height="280" /></p>\n<p>Les galeries s’affichent en de belles grilles directement dans l’éditeur, de la même manière qu’elles s’afficheront une fois l’article publié.</p>\n<h4>Faites-en plus avec l’audio et la vidéo</h4>\n<p><img class="alignnone size-large wp-image-6983" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/playliste-500x193.png" alt="playliste" width="500" height="193" /></p>\n<p>Les images ont leurs galeries, et désormais les fichiers audio et vidéo disposent de listes de lectures très simples, avec lesquelles vous pouvez présenter votre musique ou vos extraits vidéo.</p>\n<h4>Prévisualisation en direct des widgets et de l’en-tête</h4>\n<p>Ajoutez, modifiez et réarrangez vos widgets directement pendant la personnalisation du thème. Plus besoin d’enregistrer pour voir constater les problèmes : découvrez vos modifications en direct, et enregistrez-les une fois qu’elles sont validées.</p>\n<p>L’outil de gestion des images de l’en-tête a également été amélioré : vous pouvez mettre vos images en ligne, les recadre et gérer les en-têtes tout en personnalisant votre thème.</p>\n<h4>Un nouveau et superbe navigateur de thèmes</h4>\n<p><img class="alignnone size-large wp-image-6984" src="http://www.wordpress-fr.net/wp-content/uploads/2014/04/theme1-500x278.jpg" alt="theme1" width="500" height="278" /></p>\n<p>La recherche d’un nouveau thème devrait être facile et ludique. Perdez-vous dans l’offre sans fin de thèmes gratuits proposés par WordPress.org grâce au nouveau et magnifique navigateur de thèmes.</p>\n<h2 style="text-align: left;">L&rsquo;équipe</h2>\n<p>Cette version a été menée par <a href="http://nacin.com/">Andrew Nacin</a> et <a href="http://www.getsource.net/">Mike Schroder</a>, avec l&rsquo;aide de <a href="http://wordpress.org/news/2014/04/smith/">267 contributeurs</a>. Merci à eux !</p>\n<p>Maintenant que cette version est sortie, voici la manière dont vous pouvez aider la communauté pendant les prochains jours :</p>\n<ul>\n<li>Gardez un œil sur le forum d&rsquo;entraide ou sur votre réseau Twitter pour répondre aux questions ;</li>\n<li>Aidez vos amis, vos collègues, vos clients, votre groupe WordPress local et autres, à mettre à jour leurs sites ;</li>\n<li>Faites remonter tout ce qui vous semble suspect, et ne pas avoir peur d&rsquo;en parler aux responsables de l&rsquo;équipe WP (ou WPFR).</li>\n</ul>\n<p>Merci d&rsquo;avoir choisi WordPress, et à bientôt pour la version 4.0 !</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wPvO98ucIP4:I7rchQ6CsGk:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wPvO98ucIP4:I7rchQ6CsGk:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wPvO98ucIP4:I7rchQ6CsGk:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/wPvO98ucIP4" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"36";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:63:"http://www.wordpress-fr.net/2014/04/17/sortie-de-wordpress-3-9/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:81:"L’Hebdo WordPress n°225 : WordPress 3.8.3 – WordPress 3.9 – BuddyPress 2.0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/7wegzds2MAw/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:115:"http://www.wordpress-fr.net/2014/04/15/lhebdo-wordpress-n225-wordpress-3-8-3-wordpress-3-9-buddypress-2-0/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 15 Apr 2014 05:54:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:7:"Jetpack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:13:"WordPress 3.8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6962";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:351:"2 semaines après le premier avril, je tiens à soulager toute la communauté en confirmant que l&#8217;information donnée dans le précédent hebdo était évidemment un gros poisson d&#8217;avril (juste au cas où certains y aurait cru&#8230;) Les prochaines rencontres en France A Lyon : le 22 avril. A Bayonne : WPMX remet le couvert le [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3983:"<p>2 semaines après le premier avril, je tiens à soulager toute la communauté en confirmant que l&rsquo;information donnée dans le précédent hebdo était évidemment <a title="L’Hebdo WordPress n°224 : Facebook/Automattic – Masonry – BuddyPress" href="http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/">un gros poisson d&rsquo;avril </a>(juste au cas où certains y aurait cru&#8230;)</p>\n<h3>Les prochaines rencontres en France</h3>\n<ul>\n<li><a href="http://www.meetup.com/WordPress-Lyon-Meetup/events/176385812/">A Lyon : le 22 avril.</a></li>\n<li><a href="https://www.facebook.com/events/298654000290012/">A Bayonne</a> : WPMX remet le couvert le 26 avril.</li>\n<li><a href="http://www.meetup.com/wordpress-ile-de-france/polls/1028452/">Une réflexion</a> pour un meetup parisien</li>\n</ul>\n<h3>WordPress 3.8.2 et WordPress 3.8.3</h3>\n<p>En une semaine de temps, 2 versions mineures de WordPress ont vu le jour : <a href="http://wordpress.org/news/2014/04/wordpress-3-8-2/">3.8.2</a> (en) et <a href="http://wordpress.org/news/2014/04/wordpress-3-8-3/">3.8.3 (en)</a>. La version 3.8.3 vient principalement réparer un dysfonctionnement du &laquo;&nbsp;brouillon rapide&nbsp;&raquo; apparu dans la 3.8.2.</p>\n<h3>WordPress 3.9 et MySQL</h3>\n<p>Des <a href="http://make.wordpress.org/plugins/2014/04/07/mysql-in-wordpress-3-9-implications-for-plugin-authors/">modifications (en) </a>interviennent concernant MySQL dans WordPress 3.9. <span style="text-decoration: underline;">Il est à noter que la version finale de WordPress 3.9 devrait sortir dans les tous prochains jours</span>.</p>\n<h3>BuddyPress 2.0 Beta 2 et RC1</h3>\n<p>BuddyPress 2.0 <a href="http://wptavern.com/major-milestone-for-buddypress-2-million-downloads-and-counting">progresse</a> (en), après une <a href="http://buddypress.org/2014/04/buddypress-2-0-beta2/">beta 2</a> (en), la <a href="http://buddypress.org/2014/04/buddypress-2-0-release-candidate/">première version candidate</a> (en) est sortie il y a quelques jours.</p>\n<h3>Jetpack 2.9.3</h3>\n<p>Jetpack arrive en <a href="http://jetpack.me/2014/04/10/jetpack-security-update/">version 2.9.3</a> (en) et apporte une correction d&rsquo;une faille ancienne mais découverte que récemment.</p>\n<h3>WordPress est-il le bon outil ?</h3>\n<p>Voici des éléments de réponse <a href="http://wpshout.com/wordpress-right-tool-job/">si vous vous posez parfois la question (en)</a>.</p>\n<h3>Forcer la mise à jour des extensions</h3>\n<p>Julio propose une nouvelle extension permettant de forcer la mise à jour des extensions : <a href="http://boiteaweb.fr/force-plugin-updates-re-installez-vos-plugins-rapidement-8016.html#">Force Plugin Updates</a>.</p>\n<h3>Personnaliser les colonnes d&rsquo;administration</h3>\n<p>Pour personnaliser les colonnes de votre administration, essayez cette extension : <a href="http://www.geekpress.fr/wordpress/extension/personnaliser-colonnes-administration-2004/">CodePress Admin Column</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7wegzds2MAw:LehP5y6AqGA:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=7wegzds2MAw:LehP5y6AqGA:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=7wegzds2MAw:LehP5y6AqGA:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/7wegzds2MAw" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:111:"http://www.wordpress-fr.net/2014/04/15/lhebdo-wordpress-n225-wordpress-3-8-3-wordpress-3-9-buddypress-2-0/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"4";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:106:"http://www.wordpress-fr.net/2014/04/15/lhebdo-wordpress-n225-wordpress-3-8-3-wordpress-3-9-buddypress-2-0/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:54:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:75:"L’Hebdo WordPress n°224 : Facebook/Automattic – Masonry – BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/_VCUvlt4RF4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:93:"http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 01 Apr 2014 05:44:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:14:"Développement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:10:"BuddyPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:5:"Hebdo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:13:"wordpress 3.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/?p=6941";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:412:"!! Information de dernière minute !! Automattic est racheté par Facebook Nous venons d&#8217;apprendre d&#8217;une source proche du dossier que Matt Mullenweg, le co-fondateur de WordPress et CEO d&#8217;Automattic vient de finaliser un accord d&#8217;un montant de 20 milliards de dollars pour la revente d&#8217;Automattic à Facebook. C&#8217;est ainsi, avec une somme légèrement plus importante [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4850:"<h1>!! Information de dernière minute !!</h1>\n<h3>Automattic est racheté par Facebook</h3>\n<p>Nous venons d&rsquo;apprendre d&rsquo;une source proche du dossier que Matt Mullenweg, le co-fondateur de WordPress et CEO d&rsquo;Automattic vient de finaliser un accord d&rsquo;un montant de 20 milliards de dollars pour la revente d&rsquo;Automattic à Facebook. C&rsquo;est ainsi, avec une somme légèrement plus importante que sa récente acquisition de l’application Whatsapp, qui lui avait couté &laquo;&nbsp;seulement&nbsp;&raquo; 19 milliards de dollars, que le géant des réseaux sociaux acquiert l&rsquo;univers WordPress.</p>\n<p>Facebook, en pleine recherche de croissance externe après les rachats successifs d&rsquo;Instagram, de Whatsapp et dernièrement d&rsquo;Oculus met donc la main sur la maison mère de WordPress et notamment son service communautaire WordPress.com. On suppose que l&rsquo;aspect communautaire qui se développait sur la plateforme de blogs aura convaincu Facebook de sa puissance. Pour l&rsquo;instant, il est encore trop tôt pour savoir ce qu&rsquo;en fera le Géant du Web : intégration dans le réseau social, gestion de blog directement dans Facebook ou bien fusion de l&rsquo;ensemble&#8230; ?</p>\n<p>Pour le moment, le logiciel libre WordPress, disponible sur WordPress.org, semble ne pas être concerné par cette opération. En effet, la Fondation WordPress étant indépendante est encore à l&rsquo;abri&#8230; mais pour combien de temps ? Mark Zuckerberg a de nombreuses cordes à son arc et pourrait trouver la parade pour s&rsquo;approprier l&rsquo;application qui fait tourner 20 % du Web.</p>\n<p>L&rsquo;information n&rsquo;a pas encore &laquo;&nbsp;fuitée&nbsp;&raquo;, notre contact nous ayant donné l&rsquo;exclusivité de l&rsquo;information. Vous êtes donc les premiers à lire ce scoop.</p>\n<p>Nous irons à la pêche aux informations complémentaires qui, soyons en sûr, devrait tomber dans notre chalut tout au long de la journée.</p>\n<p>Restez connectés</p>\n<p><span id="more-6941"></span></p>\n<h1>La suite de l&rsquo;Hebdo :</h1>\n<h3>WordPress 3.9 beta 3</h3>\n<p>N&rsquo;ayant pas eu le temps de faire la traduction de l&rsquo;article présentant la beta 3 de WordPress 3.9, <a href="http://wordpress.org/news/2014/03/wordpress-3-9-beta-3/">je vous glisse le lien ici</a> (en) au cas où vous l&rsquo;auriez manqué.</p>\n<h3>Masonry dans WordPress 3.9</h3>\n<p>Attention le <a href="http://make.wordpress.org/core/2014/03/27/masonry-in-wordpress-3-9/">script Masonry subi des changements</a> (en) suite à son passage à la version 3 dans WordPress 3.9.</p>\n<h3>BuddyPress 2.0</h3>\n<p>BuddyPress 2.0 arrive à la fin de son développement avec une <a href="http://buddypress.org/2014/03/buddypress-2-0-beta-1-is-now-available/">beta 1</a> (en). Pour découvrir les nouveautés <a href="http://buddydev.com/buddypress/buddypress-2-0-coming-soon-expect/">c&rsquo;est ici</a> (en).</p>\n<h3>Le futur des commentaires</h3>\n<p>Quel est l&rsquo;<a href="http://wptavern.com/what-is-the-future-of-comments-in-wordpress">avenir des commentaires </a> (en) dans WordPress ?</p>\n<h3>Une extension SEO pour les dominer tous</h3>\n<p>On pensait avoir tout vu en matière d&rsquo;extension SEO&#8230;. eh bien c&rsquo;était sans compter sur Julio et sa détermination légendaire. Il annonce dès aujourd&rsquo;hui la sortie de sa propre extension, bien plus simple que toutes les autres, mais terriblement efficace. <a href="http://boiteaweb.fr/google-1st-place-plugin-seo-7996.html">Exemple en image à l&rsquo;appui </a>!</p>\n<h3>Conserver la traduction du thème lors de la mise à jour</h3>\n<p>Si vous souhaitez conserver la traduction de votre thème lors de sa mise à jour, <a href="http://www.lumieredelune.com/encrelune/preserver-traduction-po,2014,03">vous devriez regarder cet article</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=_VCUvlt4RF4:FQdKOGKg__w:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=_VCUvlt4RF4:FQdKOGKg__w:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=_VCUvlt4RF4:FQdKOGKg__w:gIN9vFwOqvQ" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/_VCUvlt4RF4" height="1" width="1"/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:89:"http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"23";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:84:"http://www.wordpress-fr.net/2014/04/01/lhebdo-wordpress-n224-mange-un-poisson-clown/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:48:"http://feeds.feedburner.com/WordpressFrancophone";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:4:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:20:"wordpressfrancophone";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:14:"emailServiceId";a:1:{i:0;a:5:{s:4:"data";s:20:"WordpressFrancophone";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:18:"feedburnerHostname";a:1:{i:0;a:5:{s:4:"data";s:28:"http://feedburner.google.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"feedFlare";a:9:{i:0;a:5:{s:4:"data";s:24:"Subscribe with NewsGator";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:112:"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:42:"http://www.newsgator.com/images/ngsub1.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:24:"Subscribe with Bloglines";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:77:"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone";s:3:"src";s:48:"http://www.bloglines.com/images/sub_modern11.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:23:"Subscribe with Netvibes";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:98:"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:44:"http://www.netvibes.com/img/add2netvibes.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:21:"Subscribe with Google";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:93:"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:51:"http://buttons.googlesyndication.com/fusion/add.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:25:"Subscribe with Pageflakes";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:101:"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:87:"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:21:"Subscribe with Plusmo";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:86:"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:43:"http://plusmo.com/res/graphics/fbplusmo.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:23:"Subscribe with Live.com";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:81:"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:141:"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:7;a:5:{s:4:"data";s:25:"Subscribe with Mon Yahoo!";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:98:"http://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:60:"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:8;a:5:{s:4:"data";s:25:"Subscribe with Excite MIX";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:89:"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:42:"http://image.excite.co.uk/mix/addtomix.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:52:"http://backend.userland.com/creativeCommonsRssModule";a:1:{s:7:"license";a:1:{i:0;a:5:{s:4:"data";s:49:"http://creativecommons.org/licenses/by-nc-sa/3.0/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:10:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:4:"etag";s:27:"s54Cswagkrpq3UJighfMKkuW/30";s:13:"last-modified";s:29:"Sun, 01 Jun 2014 20:52:48 GMT";s:4:"date";s:29:"Sun, 01 Jun 2014 21:06:45 GMT";s:7:"expires";s:29:"Sun, 01 Jun 2014 21:06:45 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:7:"80:quic";}s:5:"build";s:14:"20130911020210";}', 'no'); 
INSERT INTO `wp_options` VALUES (109, '_transient_timeout_feed_mod_66a70e9599b658d5cc038e8074597e7c', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (110, '_transient_feed_mod_66a70e9599b658d5cc038e8074597e7c', '1401656806', 'no'); 
INSERT INTO `wp_options` VALUES (111, '_transient_timeout_feed_2fb9572e3d6a42f680e36370936a57ae', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (112, '_transient_feed_2fb9572e3d6a42f680e36370936a57ae', 'a:4:{s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"feed";a:1:{i:0;a:6:{s:4:"data";s:303:"\n    \n    \n    \n    \n    \n    \n    \n  \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n            \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:27:"http://www.w3.org/2005/Atom";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"WordPress Francophone : Planet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"subtitle";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:35:"http://www.wordpress-fr.net/planet/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:3:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:9:"alternate";s:4:"type";s:9:"text/html";s:4:"href";s:35:"http://www.wordpress-fr.net/planet/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:20:"application/atom+xml";s:4:"href";s:54:"http://feeds.feedburner.com/WordpressFrancophonePlanet";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"updated";a:1:{i:0;a:5:{s:4:"data";s:20:"2014-06-01T22:44:50Z";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:6:"Author";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:5:"entry";a:20:{i:0;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"WP Formation : WP Tech à Nantes le 29 Novembre 2014";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:43:"http://wpformation.com/wp-tech-nantes-2014/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:43:"http://wpformation.com/wp-tech-nantes-2014/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-31T09:13:14+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:11:"WPFormation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1341:"<div>\n<p><img width="300" height="215" src="http://wpformation.com/wp-content/uploads/2014/05/banniere-wptech-nantes-300x215.jpg" class="attachment-medium wp-post-image" alt="banniere-wptech-nantes" style="float: right; margin:0 0 10px 10px;">Fans de WordPress, r&eacute;servez vite vos places pour le 29 novembre 2014 et venez donc faire un tour &agrave; Nantes... &nbsp; WP Tech, K&eacute;sako ? Le WP Tech est le premier &eacute;v&eacute;nement technique d&eacute;di&eacute; &agrave; WordPress. Au menu des conf&eacute;rences pour&nbsp;mieux appr&eacute;hender l&rsquo;aspect technique de WordPress et&nbsp;savoir ce que l&rsquo;on peut faire avec, et surtout ...</p>\n<hr>\n<a rel="nofollow" href="http://wpformation.com/wp-tech-nantes-2014/">WP Tech &agrave; Nantes le 29 Novembre 2014</a> est un article de <a title="Formation Internet WordPress Ecommerce" href="http://wpformation.com/">WP Formation</a><br><a href="http://wpformation.com/formation-wordpress/">Formation WordPress</a> &amp; <a href="http://wpformation.com/formation-woocommerce-e-commerce/">eCommerce</a> - Retrouvez-moi sur <a title="Ajouter sur Facebook" href="http://www.facebook.com/Wibeweb">Facebook</a> - <a title="Suivre sur Twitter" href="http://twitter.com/wpformation">Twitter</a> - <a href="http://plus.google.com/+FabriceDucarme/">Google+</a><br><hr>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"L\'écho des plugins WordPress : Advanced Comments Moderation";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:72:"http://www.echodesplugins.li-an.fr/plugins/advanced-comments-moderation/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:72:"http://www.echodesplugins.li-an.fr/plugins/advanced-comments-moderation/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-30T10:11:57+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:83:"<div>Simplifiez l\'affichage de la liste de commentaires dans l\'administration</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:76:"Cree1site : Votre moteur de recherche interne peut vous aider à convertir !";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:50:"http://www.cree1site.com/moteur-recherche-interne/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:50:"http://www.cree1site.com/moteur-recherche-interne/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-28T21:17:54+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:8:"Rodrigue";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1628:"<div>\n<p>Vu sur le site de <a href="http://www.cree1site.com/">l\'agence web</a> Cree1site.com</p>\n<p>Les eComer&ccedil;ants ont pris conscience que la recherche interne est un facteur de conversion, par contre c&rsquo;est une vraie plaie sur WordPress. Pour cela je vous propose de d&eacute;couvrir une solution que je viens de mettre en place sur le eCommerce que je g&egrave;re au boulot. Le module existe pour Magento et Prestashop. Je vous montre le principe, et comment il va vous aider &agrave; convertir. Tweet Un matin au boulot je discute avec mon boss de la compl&eacute;mentarit&eacute; merdique du moteur interne de notre site (pourtant sous Sphinx). Je vous promets que c&rsquo;est un pur hasard qu&rsquo;une heure apr&egrave;s je re&ccedil;ois un appel de Matthieu (le repr&eacute;sentant de Doofinder France, module de recherche interne intelligent que je vous pr&eacute;sente plus bas). Alors nous discutons un peu et Matthieu me demande si je suis int&eacute;ress&eacute; pour tester le moteur interne que propose sa soci&eacute;t&eacute; (de base Espagnole). Et comme je crois beaucoup en ce moteur intelligent, j&rsquo;ai d&eacute;cid&eacute; d&rsquo;en parler, apr&egrave;s l&rsquo;avoir installer sur la boutique de jouets du boulot. Votre e-commerce peut-il concurrencer Amazon ? Toutes recherches depuis votre moteur interne sont des opportunit&eacute;s de ventes. Imaginez [&hellip;]</p>\n<p>Cet article <a rel="nofollow" href="http://www.cree1site.com/moteur-recherche-interne/">Votre moteur de recherche interne peut vous aider &agrave; convertir !</a> est apparu en premier sur Cree1site.com</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:98:"WordPress Francophone : L’Hebdo WordPress n°230 : WordPress 4.0 – Jetpack 3.0 – WPTech 2014";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-27T07:23:07+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:3952:"<div>\n<h3>WordPress 4.0</h3>\n<p>D&eacute;j&agrave; quelques pr&eacute;cisions concernant l&rsquo;<a href="http://make.wordpress.org/core/2014/05/21/internationalization-goals-for-4-0/">internationalisation dans WordPress 4.0</a> (en).</p>\n<h3>Jetpack 3.0</h3>\n<p><a href="http://jetpack.me/2014/05/20/jetpack-3-0/">Jetpack passe en version 3.0</a> et se relooke en partie.</p>\n<h3>WPTech 2014</h3>\n<p><a href="http://2014.wptech.fr/">WPTech</a> est la premi&egrave;re &eacute;dition d&rsquo;une manifestation consacr&eacute;e &agrave; WordPress, mais uniquement du c&ocirc;t&eacute; technique du sujet. L&rsquo;id&eacute;e vient d&rsquo;une partie de la communaut&eacute; nantaise. Bravo &agrave; elle&hellip;. et d&eacute;j&agrave; <a href="http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/">on en parle sur le web</a>.</p>\n<h3>Les meetups franciliens se &laquo;&nbsp;veryfrenchtripise&nbsp;&raquo;</h3>\n<p>Organis&eacute;s par une bonne partie de la Very French Trip team <a href="http://veryfrenchtrip-wp.eu/meetup-wordpress-23-mai-14-paris/">les meetups franciliens cherchent &agrave; &eacute;voluer</a>.</p>\n<h3>Un superh&eacute;ros WordPress, c&rsquo;est quoi ?</h3>\n<p><a href="http://www.wppourlesnuls.com/comment-devenir-un-super-heros-wordpress-infographie/">La r&eacute;ponse en infographie</a>.</p>\n<h3>Interview de Rodrigue F&eacute;nard</h3>\n<p><a href="http://lesdoigtsdanslenet.com/rodrigue-fenard-specialiste-wordpress/">Rodrigue </a>est interview&eacute; par les Doigts dans le Net.</p>\n<h3>Utiliser les &laquo;&nbsp;social meta tags&nbsp;&raquo; de WordPress</h3>\n<p>Pour en savoir plus sur les social meta tags, un conseil,<a href="http://www.wpexplorer.com/setup-open-graph-twitter-cards-wordpress/"> lisez cet article </a>(en).</p>\n<h3>Le VFT Podcast n&deg;1</h3>\n<p><a href="http://veryfrenchtrip-wp.eu/podcast-1/">Un nouveau podcast est toujours un &eacute;v&eacute;nement </a>mais quand il est fran&ccedil;ais et r&eacute;alis&eacute; par une bande de joyeux lurons comme la VFT team alors on y va les yeux ferm&eacute;s (&ccedil;a tombe bien, y a pas d&rsquo;images !)<br><em><strong>Ajout :</strong></em> Pour suivre le podcast, abonnez-vous via ce flux : <a href="http://veryfrenchtrip-wp.eu/flux/podcast/feed/">http://veryfrenchtrip-wp.eu/flux/podcast/feed/</a></p>\n<h3>Google dans son site WordPress</h3>\n<p>Pour int&eacute;grer les<a href="http://premium.wpmudev.org/blog/wordpress-google-plugins/"> outils de Google dans votre site</a> (en), voici quelques id&eacute;es.</p>\n<h3>Du support client embarqu&eacute;</h3>\n<p>Avec <a href="http://issuepress.co/">IssuePress (en)</a>, il devient possible d&rsquo;embarquer son propre service client dans son interface d&rsquo;administrateur.</p>\n<h3>Une page de connexion personnalis&eacute;e</h3>\n<p>Cr&eacute;er une page de connexion personnalis&eacute;e est possible&hellip; <a href="http://premium.wpmudev.org/blog/create-a-custom-wordpress-login-page/">voici la m&eacute;thode</a> (en).</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:V_sGLiPBpWU" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=P6DmqnLdfQ4:iglnLHqLHyo:gIN9vFwOqvQ" border="0"></a>\n</div>\n<img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/P6DmqnLdfQ4" height="1" width="1">\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"L\'écho des plugins WordPress : Admin Menu Tree Page View";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:69:"http://www.echodesplugins.li-an.fr/plugins/admin-menu-tree-page-view/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:69:"http://www.echodesplugins.li-an.fr/plugins/admin-menu-tree-page-view/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-26T11:30:36+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:63:"<div>Deux plugins pour simplifier la gestion de ses pages</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:53:"WP Formation : WordFence Antivirus WordPress efficace";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpformation.com/wordfence-antivirus-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:53:"http://wpformation.com/wordfence-antivirus-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-24T08:20:10+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:11:"WPFormation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1328:"<div>\n<p><img width="300" height="192" src="http://wpformation.com/wp-content/uploads/2014/05/wordfence-logo-300x192.jpg" class="attachment-medium wp-post-image" alt="wordfence" style="float: right; margin:0 0 10px 10px;">La s&eacute;curit&eacute; de votre site WordPress est primordiale. Tant de travail et d\'articles sur votre blog et tout d\'un coup, une simple attaque et... Patatra! Tout est perdu, infect&eacute;, pirat&eacute;:/ Ces derniers temps, j\'ai vu augmenter des probl&egrave;mes de s&eacute;curit&eacute; sur des sites WordPress, des probl&egrave;mes de scraping, d\'injection de codes malicieux, de banni&egrave;res publicitaires ...</p>\n<hr>\n<a rel="nofollow" href="http://wpformation.com/wordfence-antivirus-wordpress/">WordFence Antivirus WordPress efficace</a> est un article de <a title="Formation Internet WordPress Ecommerce" href="http://wpformation.com/">WP Formation</a><br><a href="http://wpformation.com/formation-wordpress/">Formation WordPress</a> &amp; <a href="http://wpformation.com/formation-woocommerce-e-commerce/">eCommerce</a> - Retrouvez-moi sur <a title="Ajouter sur Facebook" href="http://www.facebook.com/Wibeweb">Facebook</a> - <a title="Suivre sur Twitter" href="http://twitter.com/wpformation">Twitter</a> - <a href="http://plus.google.com/+FabriceDucarme/">Google+</a><br><hr>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:56:"L\'écho des plugins WordPress : Admin Management Xtended";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.echodesplugins.li-an.fr/plugins/admin-management-xtended/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:68:"http://www.echodesplugins.li-an.fr/plugins/admin-management-xtended/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-22T10:46:20+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:67:"<div>G&eacute;rez vos billets/pages directement dans la liste</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"BoiteAWeb : Comment devenir un Super Héros WordPress : Infographie";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:82:"http://boiteaweb.fr/comment-devenir-un-super-heros-wordpress-infographie-8100.html";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:82:"http://boiteaweb.fr/comment-devenir-un-super-heros-wordpress-infographie-8100.html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-22T01:22:36+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:12:"Julio Potier";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:323:"<div>\n<p>Quoi ? Je suis un H&eacute;ros WordPress ? Cool :)</p>\n<p>Cet article <a href="http://boiteaweb.fr/comment-devenir-un-super-heros-wordpress-infographie-8100.html">Comment devenir un Super H&eacute;ros WordPress : Infographie</a> est apparu en premier sur <a href="http://boiteaweb.fr/">BoiteAWeb.fr</a>.</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:46:"WordPress Channel : Jetpack 3.0 pour WordPress";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:43:"http://wpchannel.com/jetpack-3-0-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:43:"http://wpchannel.com/jetpack-3-0-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-21T11:47:45+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:780:"<div>\n<p>Le plugin Jetpack vient tout juste d&rsquo;atterrir en version 3.0 sur l&rsquo;a&eacute;roport international d&rsquo;Automattic. Le commandant de bord de WordPress Channel vous invite &agrave; la pr&eacute;sentation des nouveaut&eacute;s, grand fan du module super-puissant pour un d&eacute;collage r&eacute;ussi de votre site WordPress. Attachez vos ceintures ! A propos de Jetpack Jetpack n&rsquo;est pas un plugin WordPress&hellip;</p>\n<p><a rel="nofollow" href="http://wpchannel.com/author/aurelien-denis/">Aur&eacute;lien Denis</a> - <a rel="nofollow" href="http://wpchannel.com/">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel="nofollow" href="http://wpchannel.com/jetpack-3-0-wordpress/">Jetpack 3.0 pour WordPress</a></p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"Grégoire Noyelle : WordPress :: Very French Trip Podcast 1";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.gregoirenoyelle.com/wordpress-very-french-trip-podcast-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:68:"http://www.gregoirenoyelle.com/wordpress-very-french-trip-podcast-1/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-21T06:57:02+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:17:"Grégoire Noyelle";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:419:"<div>Apr&egrave;s le lancement du site Very French Trip, au moment du 1er WordCamp Europe, la petite &eacute;quipe a relanc&eacute; le Meet Up WordPress Ile de France. Aujourd&rsquo;hui nous vous annon&ccedil;ons la sortie de notre nouveau BB; un podcast D&eacute;di&eacute; &agrave; WordPress: #VFT Podcast. Nous traiterons de WordPress &eacute;videmment, mais pas seulement. Nous pourrons aborder: le [&hellip;]</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"Cree1site : WP Tech : Le rendez-vous WordPress 100% Technique";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:64:"http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:64:"http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-20T14:07:02+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:8:"Rodrigue";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1602:"<div>\n<p>Vu sur le site de <a href="http://www.cree1site.com/">l\'agence web</a> Cree1site.com</p>\n<p>Le 29 Novembre prochain aura lieu &agrave; Nantes le premier &eacute;v&eacute;nement de WP Tech, ce nouveau format de conf&eacute;rences sur WordPress sera r&eacute;alis&eacute; gr&acirc;ce &agrave; quatre protagonistes : Willy Bahuaud Daniel Roch Simon Janin St&eacute;phanie Vachon C&rsquo;est la premi&egrave;re fois o&ugrave; un &eacute;v&eacute;nement WordPress se d&eacute;roulera &agrave; 100% autour de la technique WordPress. Vous y apprendrez &agrave; d&eacute;velopper, et contr&ocirc;ler votre site. Fini d&rsquo;appeler votre prestataire &agrave; chaque petit probl&egrave;me, cette fois, vous aurez le contr&ocirc;le. On reste dans le partage En effet ce n&rsquo;est pas dans le but de faire du fric que s&rsquo;organise ce genre d&rsquo;&eacute;vent. On le sait bien maintenant, ce moment de partage est avant tout pour sa qualit&eacute; premi&egrave;re, l&rsquo;&eacute;change. Vous ne serez pas d&eacute;&ccedil;u car vu les organisateurs, je pense que &ccedil;a va r&eacute;unir du beau monde. Alors que vous soyez D&eacute;v, Int&eacute;, Graphistes, ou m&ecirc;me comme moi chef de projet, et souhaitez mieux appr&eacute;hender l&rsquo;outil, c&rsquo;est &agrave; WP tech qu&rsquo;il faut penser. En savoir plus sur Wp Tech ou devenir orateur : http://2014.wptech.fr/</p>\n<p>Cet article <a rel="nofollow" href="http://www.cree1site.com/wp-tech-rendez-wordpress-100-technique/">WP Tech : Le rendez-vous WordPress 100% Technique</a> est apparu en premier sur Cree1site.com</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:92:"WordPress Francophone : L’Hebdo WordPress n°229 : Communautés – Extensions – Astuces";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/5ZwQnV00lFY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/5ZwQnV00lFY/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-20T07:23:15+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:3572:"<div>\n<h2>Les Communaut&eacute;s</h2>\n<h3>Bordeaux WordPress&rsquo;Camp #10</h3>\n<p>Pour la 10e &eacute;dition de cette r&eacute;union bordelaise, il sera question <a href="https://www.facebook.com/events/1485744844988525/">de s&eacute;curit&eacute; et de maintenance</a>. Elle aura lieu le 12 juin &agrave; 18 H 30.</p>\n<h3>Meetup &agrave; Lyon</h3>\n<p>D&egrave;s ce jeudi 22 mai, Lyon propose un <a href="http://www.meetup.com/WordPress-Lyon-Meetup/">meetup autour de WordPress et de l&rsquo;extension ACF</a>.</p>\n<h3>Meetup &agrave; Paris</h3>\n<p>La <a href="http://www.meetup.com/wordpress-ile-de-france/">communaut&eacute; parisienne se r&eacute;unie le vendredi 23 mai </a>autour d&rsquo;un verre.</p>\n<h3>Meetup WordPress in Alps</h3>\n<p>La <a href="http://www.wpinalps.com/#prochaine-rencontre">communaut&eacute; alpine se retrouvera le 10 juin</a>, &agrave; l&rsquo;initiative de l&rsquo;association WordPress in Alps. La r&eacute;union est pr&eacute;vue &agrave; Grenoble.</p>\n<h3>Faire du CRM avec WordPress</h3>\n<p>Si vous souhaitez vous lancer dans le <a href="https://kinsta.com/blog/crm-wordpress-plugins/">CRM avec WordPress</a> (en), ces extensions et conseils vous seront utiles.</p>\n<h3>Font Awsome int&egrave;gre WordPress</h3>\n<p>La police de caract&egrave;re <a href="http://fontawesome.io/whats-new/">Font Awsome vient d&rsquo;int&eacute;grer une ic&ocirc;ne de WordPress</a> (en) dans sa nouvelle mise &agrave; jour.</p>\n<h3>4 optimisations simples pour booster le SEO</h3>\n<p>Lumi&egrave;re de Lune explique comment, <a href="http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05">en 4 points, on peut optimiser un site pour le SEO.</a></p>\n<h3>Une favicon bien faite</h3>\n<p>WPChannel montre comment <a href="http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/">faire une favicon</a> digne de ce nom pour votre site sous WordPress.</p>\n<h3>Construire un job-board</h3>\n<p>WordPress peut d&eacute;sormais se transformer en un v&eacute;ritable job board gr&acirc;ce &agrave; cette extension : <a href="http://www.poststat.us/building-new-wp-job-manager-website/">WP Job Manager</a>.</p>\n<h3>Une communaut&eacute; de traducteurs</h3>\n<p>WordPress &eacute;tant international, il est logique de voir apparaitre une <a href="http://wp-translations.org/lets-create-community-together/">communaut&eacute; de traducteurs</a> (en).</p>\n<h3>Bien choisir un h&eacute;bergement</h3>\n<p>Quelques <a href="http://wpformation.com/choisir-hebergement-wordpress">conseils de Fabrice</a> pour choisir son h&eacute;bergement pour WordPress.</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:V_sGLiPBpWU" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=5ZwQnV00lFY:YXr4PUWFirU:gIN9vFwOqvQ" border="0"></a>\n</div>\n<img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/5ZwQnV00lFY" height="1" width="1">\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"L\'écho des plugins WordPress : Adjacent Archive Links";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:68:"http://www.echodesplugins.li-an.fr/plugins/adjacent-archive-links-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:68:"http://www.echodesplugins.li-an.fr/plugins/adjacent-archive-links-2/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-19T17:54:59+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:55:"<div>Une navigation pour les archives temporelles</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:91:"Lumière de Lune : Quatre optimisations simples pour booster le SEO de votre site WordPress";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:76:"http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:76:"http://www.lumieredelune.com/encrelune/optimisations-theme-wordpress,2014,05";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-15T11:36:26+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:10:"Marie-Aude";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:423:"<div>Pour un site bien optimis&eacute;, pas de secret, il faut mettre les mains dans le moteur ! A force d&rsquo;optimiser des th&egrave;mes WordPress, certaines choses reviennent tr&egrave;s souvent. Voici une liste de quelques optimisations simples, qui ne vous demandent pas de grosses connaissances en PHP. D&rsquo;autres vont &ecirc;tre nettement plus complexes&hellip; Important : travaillez toujours [&hellip;]</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:107:"WordPress Channel : Favicon by RealFaviconGenerator, une icône bien faite dans un blog WordPress bien fait";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:69:"http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:69:"http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-14T18:11:04+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:16:"Philippe Bernard";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:860:"<div>\n<p>Il est loin le temps o&ugrave; une simple ic&ocirc;ne en 16&times;16 suffisait &agrave; remplir le r&ocirc;le de favicon. Avec de plus hautes r&eacute;solutions et surtout de nouvelles plateformes mobiles, cette image s&rsquo;est diversifi&eacute;e. Un pr&eacute;c&eacute;dent article d&eacute;taillait les nouvelles formes et aspects du favicon et proposait une solution: RealFaviconGenerator. Ce site permet de concevoir un&hellip;</p>\n<p><a rel="nofollow" href="http://wpchannel.com/author/philippe/">Philippe Bernard</a> - <a rel="nofollow" href="http://wpchannel.com/">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel="nofollow" href="http://wpchannel.com/favicon-by-realfavicongenerator-icone-wordpress/">Favicon by RealFaviconGenerator, une ic&ocirc;ne bien faite dans un blog WordPress bien fait</a></p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:15;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:85:"WordPress Francophone : L’Hebdo WordPress n°228 : Android – BuddyPress – Scrap";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wpCN_XlMPRo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/wpCN_XlMPRo/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-13T07:49:29+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:7:"Benoît";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:7840:"<div>\n<h3>WordPress pour Android 2.8</h3>\n<p>L&rsquo;application <a href="https://android.wordpress.org/2014/05/01/wordpress-for-android-2-8/">WordPress pour Android</a> arrive en version 2.8 (en). A noter que la <a href="https://play.google.com/store/apps/details?id=org.wordpress.android">mise &agrave; jour 2.8.1</a> est sortie.</p>\n<h3>BuddyPress 2.0.1</h3>\n<p>La <a href="http://buddypress.org/2014/05/buddypress-2-0-1/">premi&egrave;re mise &agrave; jour mineur de BuddyPress 2.0</a> (en) est arriv&eacute;e.</p>\n<h3>Les fichiers attach&eacute;s dans BuddyPress</h3>\n<p>iMath pr&eacute;sente les <a href="https://bpdevel.wordpress.com/2014/05/08/attachments-in-buddypress/">fichiers attach&eacute;s&nbsp; </a>(en) dans BuddyPress.</p>\n<h3>Revenons sur 5 ans de BuddyPress</h3>\n<p>L&rsquo;<a href="http://teleogistic.net/2014/05/five-years-of-buddypress/">histoire de BuddyPress depuis 5 ans</a> (en).</p>\n<h3>Alerte au scrap sur les sites WordPress</h3>\n<p>Cette semaine de tr&egrave;s nombreux sites utilisant WordPress se sont fait &laquo;&nbsp;scrapper&nbsp;&raquo;. <a href="http://wpformation.com/scrapping-masse-sites-wordpress/">Explications par Fabrice</a>.</p>\n<h3>Plus de 25 extensions &agrave; avoir en 2014</h3>\n<p>Voici une s&eacute;lection des<a href="http://premium.wpmudev.org/blog/25-must-have-wordpress-plugins-for-2014/"> 25 extensions</a> (en) &agrave; ne pas rater en 2014.</p>\n<h3>Une extension qui fait vos badges de WordCamp</h3>\n<p>En marge du WordCamp de Miami, un passionn&eacute; a r&eacute;alis&eacute; une extension qui permet de cr&eacute;er <a href="http://wptavern.com/would-anyone-be-interested-in-a-wordcamp-badges-plugin">son propre badge du WordCamp Miami (en)</a>. Il r&eacute;fl&eacute;chi &agrave; la possibilit&eacute; de faire en sorte de g&eacute;n&eacute;raliser l&rsquo;extension pour n&rsquo;mporte quel WordCamp.</p>\n<h3>D&eacute;couvrez BuddyPress</h3>\n<p><a href="http://wpchannel.com/re-decouvres-buddypress/">Si vous ne connaissez pas encore BuddyPress</a>, Mathieu vous explique tout sur WPChannel.</p>\n<h3>Une interview de Daniel Roch</h3>\n<p>Si comme moi vous aviez rat&eacute; <a href="https://www.youtube.com/watch?v=_y9YXhAVec0">cette interview de Daniel Roch</a>, c&rsquo;est le moment de vous rattraper.</p>\n<h3>WP-Rocket s&rsquo;internationalise</h3>\n<p>L&rsquo;extension WP Rocket devient internationale, <a href="http://wptavern.com/wp-rocket-launches-commercial-caching-plugin-for-wordpress">WPTavern s&rsquo;en fait l&rsquo;&eacute;cho</a> (en).</p>\n<h3>L&rsquo;API de TinyMCE</h3>\n<p>La version de 3.9 int&egrave;gre beaucoup de nouveaut&eacute;s et notamment dans TinyMCE. Son int&eacute;gration dans le core de WordPress apporte une nouvelle API&hellip;<a href="http://www.wpexplorer.com/wordpress-tinymce-tweaks/"> autorisant de nombreuses possibilit&eacute;s</a> (en). Et voici un <a href="http://www.tweetpress.fr/faqs/comment-ajouter-icone-bouton-tinymce-wordpress-3-9/">exemple de ce qu&rsquo;on peut faire</a>.</p>\n<h3>Les jetons de s&eacute;curit&eacute;</h3>\n<p>Julio pr&eacute;sente la question des <a href="http://boiteaweb.fr/jetons-securite-petit-plus-dont-vous-avez-besoin-8070.html">jetons de s&eacute;curit&eacute;</a> et l&rsquo;applique &agrave; WordPress.</p>\n<h3>L&rsquo;effet FancyBox et WordPress</h3>\n<p>WPChannel explique <a href="http://wpchannel.com/fancybox-wordpress-galerie-image/">comment utiliser FancyBox sur un site WordPress</a>.</p>\n<h3>Organiser les types de contenus et les librairies</h3>\n<p>Voici <a href="http://tommcfarlin.com/organizing-wordpress-content-types-libraries/">une solution pr&eacute;sent&eacute;e</a> par Tom McFarlin (en).</p>\n<h3>Automattic l&egrave;ve 160 millions de dollars</h3>\n<p>Matt annonce qu&rsquo;Automattic<a href="http://ma.tt/2014/05/new-funding-for-automattic/"> l&egrave;ve 160 millions de dollars (en)</a>&hellip; et explique les <a href="http://techcrunch.com/2014/05/07/automattic-ceo-matt-mullenweg-talks-funding-investing-and-the-future-of-wordpress/">investissements et l&rsquo;avenir de WordPress</a> (en).</p>\n<h3>Prot&eacute;ger son wp-config</h3>\n<p>Si vous souhaitez prot&eacute;ger votre fichier wp-config.php via le fichier .htaccess<a href="http://wp-snippets.com/protect-wp-config-php-with-htaccess/"> voici comment proc&eacute;der (en).</a></p>\n<h3>Une table ronde sur les h&eacute;bergeurs de WordPress</h3>\n<p><a href="http://wpbacon.com/podcast/wordpress-hosting-panel/">WPBacon </a>a organis&eacute; une <a href="http://wptavern.com/highlights-of-the-wpbacon-wordpress-webhosting-roundtable">table ronde pour parler h&eacute;bergements</a>. (en)</p>\n<h3>Matt Mullenweg est un homme dangereux</h3>\n<p>C&rsquo;est le titre accrocheur de cet article pour montrer la &laquo;&nbsp;peur&nbsp;&raquo; du gouvernement am&eacute;ricain envers l&rsquo;open source en g&eacute;n&eacute;ral et WordPress en particulier. <a href="http://joeflood.com/2014/05/07/matt/">Angle de vue d&eacute;cal&eacute;&nbsp; </a>(en) pour montrer le ridicule d&rsquo;une situation loin d&rsquo;&ecirc;tre erron&eacute;e.</p>\n<h3>Cr&eacute;ation d&rsquo;une page de maintenance personnalis&eacute;e</h3>\n<p>La page de maintenance par d&eacute;faut de WordPress est triste &agrave; souhait ! <a href="http://www.gregoirenoyelle.com/wordpress-creation-page-maintenance-personnalisee/">Personnalisez-la gr&acirc;ce &agrave; Gr&eacute;goire</a>.</p>\n<h3>WordPress n&rsquo;est pas un CMS</h3>\n<p>Mmmmhhh, <a href="http://www.screenfeed.fr/blog/wordpress-pas-cms-02223/">encore de la pol&eacute;mique dans l&rsquo;air</a>&hellip; mais l&agrave;, l&rsquo;offensive est argument&eacute;e&hellip;</p>\n<h3>&Eacute;volution du nombre d&rsquo;extensions</h3>\n<p>Julio constate l&rsquo;<a href="http://boiteaweb.fr/combien-plugins-wordpress-8075.html">&eacute;volution du nombre d&rsquo;extensions dans le r&eacute;pertoire officiel</a>.</p>\n<h3>Des s&eacute;ries d&rsquo;articles en liste d&eacute;roulante</h3>\n<p>C&rsquo;est l&rsquo;extension <a href="http://www.echodesplugins.li-an.fr/plugins/wp-post-series/">WP Post Series</a> qui le permet.</p>\n<h3>60 th&egrave;mes typ&eacute;s business pour 2014</h3>\n<p>WPMUDEV pr&eacute;sente une liste de <a href="http://premium.wpmudev.org/blog/free-responsive-wordpress-business-themes/">60 th&egrave;mes gratuits</a> (en) typ&eacute;s business et sortis en 2014.</p>\n<h3>Une extension peut disparaitre du r&eacute;pertoire officiel ?</h3>\n<p>Marie-Aude explique les raisons de la <a href="http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05">disparition d&rsquo;une extension du r&eacute;pertoire officiel </a>et les cons&eacute;quences &agrave; en tirer.</p>\n<h3>Lev&eacute; de rideau sur les nouveaux th&egrave;mes ElegantThemes</h3>\n<p>Rodrigue pr&eacute;sente ce que va &ecirc;tre l<a href="http://www.cree1site.com/eleganttheme-2/">&lsquo;avenir des th&egrave;mes ElegantThemes</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:V_sGLiPBpWU" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=wpCN_XlMPRo:xJLuWzsYzXw:gIN9vFwOqvQ" border="0"></a>\n</div>\n<img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/wpCN_XlMPRo" height="1" width="1">\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:16;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"Cree1site : Elegantthemes : Levé de rideau sur les nouveaux thèmes";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:40:"http://www.cree1site.com/eleganttheme-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:40:"http://www.cree1site.com/eleganttheme-2/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-12T23:47:58+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:8:"Rodrigue";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1755:"<div>\n<p>Vu sur le site de <a href="http://www.cree1site.com/">l\'agence web</a> Cree1site.com</p>\n<p>Nick Roach, le fondateur et designer de Elegantthemes annonce l&rsquo;arriv&eacute;e d&rsquo;un grand moment sur la c&eacute;l&egrave;bre plateforme de vente de th&egrave;mes premium &hellip; mais de quoi parlait t&rsquo;il ? J&rsquo;ai donc ouvert le mail r&eacute;serv&eacute; aux inscrits Elegantthemes. Avant de revenir sur l&rsquo;annonce de Nick, pour ceux qui ne connaissent pas encore, Elegantthemes c&rsquo;est un site de th&egrave;mes premium, qui a la particularit&eacute; de proposer un forfait unique pour acc&eacute;der &agrave; l&rsquo;ensemble de ces r&eacute;alisations. Loin de Themeforest qui lui vend au one shot les th&egrave;mes de cr&eacute;ateurs, en tant que VRAIE marketplace. Le site Elegantthemes, c&rsquo;est&nbsp; l&rsquo;ensemble des 87 th&egrave;mes (&agrave; ce jour) pour seulement cinquante euros. Soit un th&egrave;me &agrave; moins de 0.50 euro l&rsquo;unit&eacute;. Tout est inclus &agrave; ce prix, m&ecirc;me une interface d&rsquo;administration qui comblera les novices par sa simplicit&eacute;. Dans les chiffres, Elegantthemes c&rsquo;est donc : L&rsquo;acc&egrave;s pour un prix ridicule &agrave; des th&egrave;mes professionnels (69$) Plus de 233,869 clients qui ont acc&egrave;s &agrave; 87 th&egrave;mes Alors c&rsquo;est quoi l&rsquo;annonce de Nick Roach ? Si vous suivez l&rsquo;actu WordPress, vous n&rsquo;&ecirc;tes pas sans savoir que le designer de Elegantthemes et tout le reste [&hellip;]</p>\n<p>Cet article <a rel="nofollow" href="http://www.cree1site.com/eleganttheme-2/">Elegantthemes : Lev&eacute; de rideau sur les nouveaux th&egrave;mes</a> est apparu en premier sur Cree1site.com</p>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:17;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"L\'écho des plugins WordPress : WP Auto Featured Image";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:66:"http://www.echodesplugins.li-an.fr/plugins/wp-auto-featured-image/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:66:"http://www.echodesplugins.li-an.fr/plugins/wp-auto-featured-image/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-12T17:06:27+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:5:"Li-An";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:74:"<div>Choisir une image par d&eacute;faut comme image &agrave; la une</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:18;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:50:"WP Formation : Le Business généré par WordPress";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:42:"http://wpformation.com/business-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:42:"http://wpformation.com/business-wordpress/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-12T11:45:00+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:11:"WPFormation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:1376:"<div>\n<p><img width="300" height="107" src="http://wpformation.com/wp-content/uploads/2014/05/businness-wordpress-300x107.jpg" class="attachment-medium wp-post-image" alt="businness-wordpress" style="float: right; margin:0 0 10px 10px;">WordPress est aujourd&rsquo;hui le syst&egrave;me de gestion de contenu (CMS) incontournable pour toute personne souhaitant cr&eacute;er facilement et rapidement un site internet. Le logiciel est open source et accessible gratuitement par n&rsquo;importe quelle personne poss&eacute;dant une connexion internet.&nbsp;Pourtant, l&rsquo;entreprise du cr&eacute;ateur du logiciel, Automattic, est florissante et a en son sein plus de 250 employ&eacute;s. ...</p>\n<hr>\n<a rel="nofollow" href="http://wpformation.com/business-wordpress/">Le Business g&eacute;n&eacute;r&eacute; par WordPress</a> est un article de <a title="Formation Internet WordPress Ecommerce" href="http://wpformation.com/">WP Formation</a><br><a href="http://wpformation.com/formation-wordpress/">Formation WordPress</a> &amp; <a href="http://wpformation.com/formation-woocommerce-e-commerce/">eCommerce</a> - Retrouvez-moi sur <a title="Ajouter sur Facebook" href="http://www.facebook.com/Wibeweb">Facebook</a> - <a title="Suivre sur Twitter" href="http://twitter.com/wpformation">Twitter</a> - <a href="http://plus.google.com/+FabriceDucarme/">Google+</a><br><hr>\n</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:19;a:6:{s:4:"data";s:68:"\n        \n        \n        \n        \n        \n        \n        \n    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"Lumière de Lune : Pourquoi un plugin peut disparaître de WordPress.org ?";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:2:"id";a:1:{i:0;a:5:{s:4:"data";s:65:"http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:9:"alternate";s:4:"href";s:65:"http://www.lumieredelune.com/encrelune/disparition-plugin,2014,05";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"published";a:1:{i:0;a:5:{s:4:"data";s:25:"2014-05-10T19:09:37+00:00";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"author";a:1:{i:0;a:6:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"name";a:1:{i:0;a:5:{s:4:"data";s:10:"Marie-Aude";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:7:"content";a:1:{i:0;a:5:{s:4:"data";s:459:"<div>La disparition soudaine d&rsquo;un plugin du r&eacute;pertoire des extensions sur WordPress.org n&rsquo;est jamais une information &agrave; prendre &agrave; la l&eacute;g&egrave;re, et quand cela arrive, d&egrave;s qu&rsquo;on s&rsquo;en aper&ccedil;oit, il faut essayer de comprendre ce qui se passe, pour d&eacute;cider si, oui ou non, ce plugin est &agrave; conserver. En r&eacute;sum&eacute;, un plugin disparait du r&eacute;pertoire [&hellip;]</div>";s:7:"attribs";a:1:{s:0:"";a:1:{s:4:"type";s:4:"html";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:26:"wordpressfrancophoneplanet";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}s:4:"type";i:512;s:7:"headers";a:10:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:4:"etag";s:27:"tUsgMvq+uaHnOyTM3JHsNqfL4k0";s:13:"last-modified";s:29:"Sun, 01 Jun 2014 20:44:51 GMT";s:4:"date";s:29:"Sun, 01 Jun 2014 21:06:46 GMT";s:7:"expires";s:29:"Sun, 01 Jun 2014 21:06:46 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:7:"80:quic";}s:5:"build";s:14:"20130911020210";}', 'no'); 
INSERT INTO `wp_options` VALUES (113, '_transient_timeout_feed_mod_2fb9572e3d6a42f680e36370936a57ae', '1401700006', 'no'); 
INSERT INTO `wp_options` VALUES (114, '_transient_feed_mod_2fb9572e3d6a42f680e36370936a57ae', '1401656806', 'no'); 
INSERT INTO `wp_options` VALUES (115, '_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109', '1401700007', 'no'); 
INSERT INTO `wp_options` VALUES (116, '_transient_feed_b9388c83948825c1edaef0d856b7b109', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n	\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"WordPress Plugins » View: Most Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:44:"http://wordpress.org/plugins/browse/popular/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:39:"WordPress Plugins » View: Most Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 01 Jun 2014 20:56:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:25:"http://bbpress.org/?v=1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:15:{i:0;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Contact Form 7";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:54:"http://wordpress.org/plugins/contact-form-7/#post-2141";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 02 Aug 2007 12:45:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"2141@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:54:"Just another contact form plugin. Simple but flexible.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Takayuki Miyoshi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"Jetpack by WordPress.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:48:"http://wordpress.org/plugins/jetpack/#post-23862";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 Jan 2011 02:21:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"23862@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:104:"Supercharge your WordPress site with powerful features previously only available to WordPress.com users.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Tim Moore";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:7:"Akismet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"http://wordpress.org/plugins/akismet/#post-15";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:11:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"15@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:98:"Akismet checks your comments against the Akismet web service to see if they look like spam or not.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"WordPress SEO by Yoast";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wordpress.org/plugins/wordpress-seo/#post-8321";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 01 Jan 2009 20:34:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"8321@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:131:"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the WordPress SEO plugin by Yoast.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Joost de Valk";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"Google XML Sitemaps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"http://wordpress.org/plugins/google-sitemap-generator/#post-132";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:31:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"132@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:105:"This plugin will generate a special XML sitemap which will help search engines to better index your blog.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Arnee";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:58:"http://wordpress.org/plugins/all-in-one-seo-pack/#post-753";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Mar 2007 20:08:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"753@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:126:"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"uberdose";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"Wordfence Security";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:50:"http://wordpress.org/plugins/wordfence/#post-29832";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 04 Sep 2011 03:13:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"29832@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:137:"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Wordfence";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"MailPoet Newsletters";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/plugins/wysija-newsletters/#post-32629";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 02 Dec 2011 17:09:16 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"32629@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:94:"Send newsletters, post notifications or autoresponders from WordPress easily, and beautifully.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"MailPoet Staff";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WooCommerce - excelling eCommerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"http://wordpress.org/plugins/woocommerce/#post-29860";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Sep 2011 08:13:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"29860@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:97:"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"WooThemes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"NextGEN Gallery";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/plugins/nextgen-gallery/#post-1169";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Apr 2007 20:08:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"1169@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:121:"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 10 million downloads.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Alex Rabe";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"WordPress Importer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/plugins/wordpress-importer/#post-18101";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 May 2010 17:42:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"18101@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:101:"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brian Colinger";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:46:"iThemes Security (formerly Better WP Security)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"http://wordpress.org/plugins/better-wp-security/#post-21738";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 22 Oct 2010 22:06:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"21738@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:63:"The easiest, most effective way to secure WordPress in seconds.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Chris Wiegman";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"WPtouch Mobile Plugin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:47:"http://wordpress.org/plugins/wptouch/#post-5468";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 01 May 2008 04:58:09 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"5468@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:63:"Create a slick mobile WordPress website with just a few clicks.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"BraveNewCode Inc.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"TinyMCE Advanced";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"http://wordpress.org/plugins/tinymce-advanced/#post-2082";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 27 Jun 2007 15:00:26 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"2082@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:71:"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Andrew Ozz";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"W3 Total Cache";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"http://wordpress.org/plugins/w3-total-cache/#post-12073";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 29 Jul 2009 18:46:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"12073@http://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:132:"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Frederick Townes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:45:"http://wordpress.org/plugins/rss/view/popular";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:7:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Sun, 01 Jun 2014 21:06:46 GMT";s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:10:"connection";s:5:"close";s:4:"vary";s:15:"Accept-Encoding";s:13:"last-modified";s:29:"Thu, 02 Aug 2007 12:45:03 GMT";s:4:"x-nc";s:11:"HIT lax 249";}s:5:"build";s:14:"20130911020210";}', 'no'); 
INSERT INTO `wp_options` VALUES (117, '_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109', '1401700007', 'no'); 
INSERT INTO `wp_options` VALUES (118, '_transient_feed_mod_b9388c83948825c1edaef0d856b7b109', '1401656807', 'no'); 
INSERT INTO `wp_options` VALUES (119, '_transient_timeout_plugin_slugs', '1431188664', 'no'); 
INSERT INTO `wp_options` VALUES (120, '_transient_plugin_slugs', 'a:18:{i:0;s:33:"admin-menu-editor/menu-editor.php";i:1;s:30:"advanced-custom-fields/acf.php";i:2;s:29:"acf-repeater/acf-repeater.php";i:3;s:19:"akismet/akismet.php";i:4;s:35:"comment-control/comment-control.php";i:5;s:33:"duplicate-post/duplicate-post.php";i:6;s:41:"multi-image-upload/multi-image-upload.php";i:7;s:9:"hello.php";i:8;s:27:"katz-enhance-admin/main.php";i:9;s:37:"post-types-order/post-types-order.php";i:10;s:41:"taxonomy-converter/taxonomy-converter.php";i:11;s:114:"tinymce-and-tinymce-advanced-professsional-formats-and-styles/tinymce-advanced-professional-formats-and-styles.php";i:12;s:29:"wp-db-backup/wp-db-backup.php";i:13;s:41:"wordpress-importer/wordpress-importer.php";i:14;s:51:"wpml-theme-tester/wpml-compatibility-test-tools.php";i:15;s:40:"sitepress-multilingual-cms/sitepress.php";i:16;s:34:"wpml-string-translation/plugin.php";i:17;s:38:"wpml-translation-management/plugin.php";}', 'no'); 
INSERT INTO `wp_options` VALUES (121, '_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51', '1401700007', 'no'); 
INSERT INTO `wp_options` VALUES (122, '_transient_dash_4077549d03da2e451c8b5f002294ff51', '<div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/P6DmqnLdfQ4/\'>L’Hebdo WordPress n°230 : WordPress 4.0 – Jetpack 3.0 – WPTech 2014</a> <span class="rss-date">27 mai 2014</span><div class="rssSummary">WordPress 4.0 Déjà quelques précisions concernant l’internationalisation dans WordPress 4.0 (en). Jetpack 3.0 Jetpack passe en version 3.0 et se relooke en partie. WPTech 2014 WPTech est la première édition d’une manifestation consacrée à WordPress, mais uniquement du côté technique du sujet. L’idée vient d’une partie de la communauté nantaise. Bravo à elle…</div></li></ul></div><div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'http://wpformation.com/wp-tech-nantes-2014/\' title=\'Fans de WordPress, réservez vite vos places pour le 29 novembre 2014 et venez donc faire un tour à Nantes...   WP Tech, Késako ? Le WP Tech est le premier événement technique dédié à WordPress. Au menu des conférences pour mieux appréhender l’aspect technique de WordPress et savoir ce que l’on peut faire avec, et surtout ... WP Tech à Nantes le 29 Novembre 2\'>WP Formation : WP Tech à Nantes le 29 Novembre 2014</a></li><li><a class=\'rsswidget\' href=\'http://www.echodesplugins.li-an.fr/plugins/advanced-comments-moderation/\' title=\'Simplifiez l&#039;affichage de la liste de commentaires dans l&#039;administration\'>L&#039;écho des plugins WordPress : Advanced Comments Moderation</a></li><li><a class=\'rsswidget\' href=\'http://www.cree1site.com/moteur-recherche-interne/\' title=\'Vu sur le site de l&#039;agence web Cree1site.com Les eComerçants ont pris conscience que la recherche interne est un facteur de conversion, par contre c’est une vraie plaie sur WordPress. Pour cela je vous propose de découvrir une solution que je viens de mettre en place sur le eCommerce que je gère au boulot. Le module existe pour Magento et Prestashop. Je\'>Cree1site : Votre moteur de recherche interne peut vous aider à convertir !</a></li></ul></div><div class="rss-widget"><ul><li class=\'dashboard-news-plugin\'><span>Extensions populaires:</span> <a href=\'http://wordpress.org/plugins/jetpack/\' class=\'dashboard-news-plugin-link\'>Jetpack by WordPress.com</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=jetpack&amp;_wpnonce=d4b889e4f6&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Jetpack by WordPress.com\'>Installer</a>)</span></li></ul></div>', 'no'); 
INSERT INTO `wp_options` VALUES (126, 'theme_mods_twentyfourteen', 'a:1:{s:16:"sidebars_widgets";a:2:{s:4:"time";i:1401656874;s:4:"data";a:4:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:0:{}}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (127, 'current_theme', 'Pierre Katz', 'yes'); 
INSERT INTO `wp_options` VALUES (128, 'theme_mods_katz', 'a:2:{i:0;b:0;s:18:"nav_menu_locations";a:1:{s:7:"primary";s:1:"6";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (129, 'theme_switched', '', 'yes'); 
INSERT INTO `wp_options` VALUES (3816, 'widget_icl_lang_sel_widget', 'a:2:{i:1;a:1:{s:5:"title";b:0;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `wp_options` VALUES (130, 'recently_activated', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (132, 'acf_version', '4.3.8', 'yes'); 
INSERT INTO `wp_options` VALUES (133, 'ws_menu_editor', 'a:14:{s:22:"hide_advanced_settings";b:1;s:16:"show_extra_icons";b:0;s:11:"custom_menu";N;s:18:"first_install_time";i:1403088544;s:21:"display_survey_notice";b:1;s:17:"plugin_db_version";i:140;s:24:"security_logging_enabled";b:0;s:17:"menu_config_scope";s:6:"global";s:13:"plugin_access";s:14:"manage_options";s:15:"allowed_user_id";N;s:28:"plugins_page_allowed_user_id";N;s:27:"show_deprecated_hide_button";N;s:37:"dashboard_hiding_confirmation_enabled";b:1;s:23:"show_plugin_menu_notice";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (269, '_site_transient_timeout_browser_ebc347bfdf7c226e38e6eb9254ebf3ef', '1406741540', 'yes'); 
INSERT INTO `wp_options` VALUES (270, '_site_transient_browser_ebc347bfdf7c226e38e6eb9254ebf3ef', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"30.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (454, '_transient_random_seed', '238ae321c41a0559b1956164623140c3', 'yes'); 
INSERT INTO `wp_options` VALUES (522, '_site_transient_timeout_browser_b69641d2d7bcc44f549ced1604c4d328', '1408105377', 'yes'); 
INSERT INTO `wp_options` VALUES (523, '_site_transient_browser_b69641d2d7bcc44f549ced1604c4d328', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Chrome";s:7:"version";s:13:"36.0.1985.125";s:10:"update_url";s:28:"http://www.google.com/chrome";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/chrome.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/chrome.png";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3736, '_site_transient_browser_8f08344a06a0174f5157cb8b14bb5d61', 'a:9:{s:8:"platform";s:6:"iPhone";s:4:"name";s:6:"iPhone";s:7:"version";s:3:"8.0";s:10:"update_url";s:0:"";s:7:"img_src";s:0:"";s:11:"img_src_ssl";s:0:"";s:15:"current_version";s:0:"";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (2735, '_site_transient_timeout_browser_3033ae672f5030d60b69f754349863be', '1422637203', 'yes'); 
INSERT INTO `wp_options` VALUES (1668, 'rewrite_rules', 'a:68:{s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:38:"index.php?&page_id=5&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:20:"(.?.+?)(/[0-9]+)?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:20:"([^/]+)(/[0-9]+)?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";}', 'yes'); 
INSERT INTO `wp_options` VALUES (890, 'comment_control_options', 'a:6:{s:17:"allow_comments_on";a:0:{}s:14:"allow_pings_on";a:0:{}s:5:"no_tb";b:0;s:19:"attachments_inherit";b:0;s:21:"attachments_nocomment";b:0;s:10:"db_version";i:3;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3810, 'icl_sitepress_version', '3.1.9.3', 'yes'); 
INSERT INTO `wp_options` VALUES (909, 'icl_sitepress_settings', 'a:70:{s:19:"hide_upgrade_notice";s:5:"3.0.1";s:21:"interview_translators";i:1;s:34:"existing_content_language_verified";i:1;s:25:"language_negotiation_type";i:1;s:23:"theme_localization_type";i:2;s:14:"icl_lso_header";i:0;s:18:"icl_lso_link_empty";i:0;s:13:"icl_lso_flags";i:1;s:19:"icl_lso_native_lang";i:0;s:20:"icl_lso_display_lang";i:0;s:18:"sync_page_ordering";i:1;s:16:"sync_page_parent";i:1;s:18:"sync_page_template";i:1;s:16:"sync_ping_status";i:1;s:19:"sync_comment_status";i:1;s:16:"sync_sticky_flag";i:1;s:17:"sync_private_flag";i:1;s:16:"sync_post_format";i:1;s:11:"sync_delete";i:0;s:15:"sync_delete_tax";i:0;s:20:"sync_post_taxonomies";i:1;s:14:"sync_post_date";i:0;s:21:"sync_taxonomy_parents";i:0;s:25:"translation_pickup_method";i:0;s:15:"notify_complete";i:1;s:26:"translated_document_status";i:1;s:17:"remote_management";i:0;s:15:"auto_adjust_ids";i:1;s:11:"alert_delay";i:0;s:12:"promote_wpml";i:0;s:23:"troubleshooting_options";a:1:{s:18:"http_communication";i:1;}s:18:"automatic_redirect";i:0;s:17:"remember_language";i:24;s:17:"icl_lang_sel_type";s:8:"dropdown";s:18:"icl_lang_sel_stype";s:7:"classic";s:24:"icl_lang_sel_orientation";s:8:"vertical";s:28:"icl_lang_sel_copy_parameters";s:0:"";s:21:"icl_widget_title_show";i:0;s:28:"translated_document_page_url";s:13:"auto-generate";s:28:"sync_comments_on_duplicates ";i:0;s:3:"seo";a:2:{s:10:"head_langs";i:1;s:27:"canonicalization_duplicates";i:1;}s:22:"posts_slug_translation";a:1:{s:2:"on";i:0;}s:15:"languages_order";a:2:{i:0;s:2:"fr";i:1;s:2:"en";}s:4:"urls";a:5:{s:30:"directory_for_default_language";i:0;s:12:"show_on_root";s:0:"";s:19:"root_html_file_path";s:0:"";s:9:"root_page";i:0;s:23:"hide_language_switchers";i:1;}s:22:"admin_default_language";s:2:"fr";s:18:"ajx_health_checked";b:1;s:17:"setup_wizard_step";i:3;s:18:"default_categories";a:2:{s:2:"fr";s:1:"1";s:2:"en";i:12;}s:16:"default_language";s:2:"fr";s:27:"dont_show_help_admin_notice";b:1;s:19:"icl_lang_sel_config";a:9:{s:19:"font-current-normal";s:7:"#444444";s:18:"font-current-hover";s:7:"#000000";s:25:"background-current-normal";s:7:"#ffffff";s:24:"background-current-hover";s:7:"#eeeeee";s:17:"font-other-normal";s:7:"#444444";s:16:"font-other-hover";s:7:"#000000";s:23:"background-other-normal";s:7:"#ffffff";s:22:"background-other-hover";s:7:"#eeeeee";s:6:"border";s:7:"#cdcdcd";}s:26:"icl_lang_sel_footer_config";a:10:{s:19:"font-current-normal";s:7:"#444444";s:18:"font-current-hover";s:7:"#000000";s:25:"background-current-normal";s:7:"#ffffff";s:24:"background-current-hover";s:7:"#eeeeee";s:17:"font-other-normal";s:7:"#444444";s:16:"font-other-hover";s:7:"#000000";s:23:"background-other-normal";s:7:"#ffffff";s:22:"background-other-hover";s:7:"#eeeeee";s:6:"border";s:7:"#cdcdcd";s:10:"background";s:7:"#ffffff";}s:29:"icl_language_switcher_sidebar";s:1:"0";s:19:"icl_lang_sel_footer";i:0;s:21:"icl_post_availability";i:0;s:30:"icl_post_availability_position";s:5:"below";s:26:"icl_post_availability_text";s:44:"Ce message est également disponible en : %s";s:29:"language_selector_initialized";i:1;s:22:"translation-management";a:7:{s:12:"notification";a:5:{s:7:"new-job";i:1;s:9:"completed";i:1;s:8:"resigned";i:1;s:9:"dashboard";b:1;s:9:"purge-old";i:7;}s:25:"custom_fields_translation";a:23:{s:11:"image_texte";i:0;s:19:"image_texte_0_texte";i:0;s:19:"image_texte_1_texte";i:0;s:12:"_image_texte";i:0;s:20:"_image_texte_0_texte";i:0;s:20:"_image_texte_1_texte";i:0;s:19:"image_texte_0_image";i:0;s:20:"_image_texte_0_image";i:0;s:19:"image_texte_1_image";i:0;s:20:"_image_texte_1_image";i:0;s:11:"footer-text";i:0;s:12:"_footer-text";i:0;s:21:"image_texte_0_image_v";i:0;s:22:"_image_texte_0_image_v";i:0;s:21:"image_texte_1_image_v";i:0;s:22:"_image_texte_1_image_v";i:0;s:37:"image_texte_0_image_iphone_horizontal";i:0;s:38:"_image_texte_0_image_iphone_horizontal";i:0;s:37:"image_texte_1_image_iphone_horizontal";i:0;s:38:"_image_texte_1_image_iphone_horizontal";i:0;s:5:"title";i:2;s:11:"description";i:2;s:8:"keywords";i:2;}s:22:"doc_translation_method";i:0;s:35:"__custom_types_readonly_config_prev";a:0:{}s:28:"custom_types_readonly_config";a:0:{}s:36:"__custom_fields_readonly_config_prev";a:0:{}s:29:"custom_fields_readonly_config";a:3:{i:0;s:5:"title";i:1;s:11:"description";i:2;s:8:"keywords";}}s:14:"setup_complete";i:1;s:18:"icl_additional_css";s:28:"                            ";s:18:"display_ls_in_menu";i:0;s:11:"menu_for_ls";i:0;s:22:"show_translations_flag";i:1;s:27:"sync_comments_on_duplicates";i:0;s:16:"just_reactivated";i:0;s:25:"icl_capabilities_verified";b:1;s:22:"taxonomy_names_checked";b:1;s:2:"st";a:4:{s:2:"sw";a:0:{}s:16:"strings_per_page";i:10;s:15:"icl_st_auto_reg";s:7:"disable";s:16:"strings_language";s:2:"en";}s:38:"hide_professional_translation_controls";s:1:"1";}', 'yes'); 
INSERT INTO `wp_options` VALUES (910, '_icl_cache', 'a:3:{s:25:"language_name_cache_class";a:18:{s:14:"in_language_fr";a:2:{i:0;a:8:{s:2:"id";s:1:"1";s:4:"code";s:2:"en";s:12:"english_name";s:7:"English";s:6:"active";s:1:"1";s:12:"display_name";s:7:"Anglais";s:10:"encode_url";s:1:"0";s:14:"default_locale";s:5:"en_US";s:3:"tag";s:5:"en-US";}i:1;a:8:{s:2:"id";s:1:"4";s:4:"code";s:2:"fr";s:12:"english_name";s:6:"French";s:6:"active";s:1:"1";s:12:"display_name";s:9:"Français";s:10:"encode_url";s:1:"0";s:14:"default_locale";s:5:"fr_FR";s:3:"tag";s:5:"fr-FR";}}s:9:"languages";a:2:{i:0;O:8:"stdClass":2:{s:13:"language_code";s:2:"en";s:4:"name";s:7:"English";}i:1;O:8:"stdClass":2:{s:13:"language_code";s:2:"fr";s:4:"name";s:9:"Français";}}s:21:"language_details_frfr";a:5:{s:4:"code";s:2:"fr";s:12:"english_name";s:6:"French";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:9:"Français";}s:4:"frfr";s:9:"Français";s:4:"enen";s:7:"English";s:4:"enfr";s:7:"Anglais";s:21:"language_details_enfr";a:5:{s:4:"code";s:2:"en";s:12:"english_name";s:7:"English";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:7:"Anglais";}s:21:"language_details_enen";a:5:{s:4:"code";s:2:"en";s:12:"english_name";s:7:"English";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:7:"English";}s:4:"fren";s:6:"French";s:19:"language_details_fr";N;s:22:"language_details_allfr";N;s:21:"language_details_fren";a:5:{s:4:"code";s:2:"fr";s:12:"english_name";s:6:"French";s:5:"major";s:1:"1";s:6:"active";s:1:"1";s:12:"display_name";s:6:"French";}s:22:"language_details_frall";N;s:20:"language_details_all";N;s:22:"language_details_enall";N;s:17:"language_details_";N;s:2:"en";N;s:2:"fr";N;}s:17:"flags_cache_class";a:3:{s:2:"fr";O:8:"stdClass":2:{s:4:"flag";s:6:"fr.png";s:13:"from_template";s:1:"0";}s:2:"en";O:8:"stdClass":2:{s:4:"flag";s:6:"en.png";s:13:"from_template";s:1:"0";}s:0:"";N;}s:18:"posts_per_language";a:3:{s:3:"all";i:50;s:2:"en";s:2:"25";s:2:"fr";s:2:"25";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (1462, '_site_transient_timeout_browser_ce2653c6267d76d83d16bd34ac054f6f', '1417444677', 'yes'); 
INSERT INTO `wp_options` VALUES (1463, '_site_transient_browser_ce2653c6267d76d83d16bd34ac054f6f', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"33.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3812, 'wp_installer_settings', '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', 'yes'); 
INSERT INTO `wp_options` VALUES (3616, '_transient_feed_mod_90703ac594673efe43c980672b645276', '1426033739', 'no'); 
INSERT INTO `wp_options` VALUES (3615, '_transient_timeout_feed_mod_90703ac594673efe43c980672b645276', '1426076939', 'no'); 
INSERT INTO `wp_options` VALUES (3482, '_site_transient_timeout_browser_61df25869d74d4482336b1f94b279e7d', '1425947359', 'yes'); 
INSERT INTO `wp_options` VALUES (3483, '_site_transient_browser_61df25869d74d4482336b1f94b279e7d', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:3:"7.1";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (3452, 'icl_admin_messages', 'a:2:{s:8:"messages";a:1:{s:28:"_st_default_language_warning";a:7:{s:4:"text";s:251:"Because your default language is not English, you need to enter all strings in English and translate them to  and Français. <strong><a href="https://wpml.org/faq/string-translation-default-language-not-english/" target="_blank">Read more</a></strong>";s:4:"type";s:29:"icl-admin-message-information";s:4:"hide";b:1;s:13:"text_fallback";s:161:"<a href="https://wpml.org/faq/string-translation-default-language-not-english/" target="_blank">How to translate strings when default language is not English</a>";s:13:"type_fallback";b:0;s:5:"group";s:18:"string-translation";s:12:"admin_notice";b:0;}}s:16:"instant_messages";a:0:{}}', 'yes'); 
INSERT INTO `wp_options` VALUES (5581, '_site_transient_timeout_browser_4538d203b981f4a9c6dd1fdefe1710c8', '1431962648', 'yes'); 
INSERT INTO `wp_options` VALUES (5582, '_site_transient_browser_4538d203b981f4a9c6dd1fdefe1710c8', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"37.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (134, 'cpto_options', 'a:3:{s:8:"autosort";s:1:"1";s:9:"adminsort";s:1:"1";s:10:"capability";s:13:"publish_pages";}', 'yes'); 
INSERT INTO `wp_options` VALUES (135, 'CPT_configured', 'TRUE', 'yes'); 
INSERT INTO `wp_options` VALUES (1663, '_site_transient_timeout_popular_importers_fr_FR', '1417690518', 'yes'); 
INSERT INTO `wp_options` VALUES (1664, '_site_transient_popular_importers_fr_FR', 'a:2:{s:9:"importers";a:8:{s:7:"blogger";a:4:{s:4:"name";s:7:"Blogger";s:11:"description";s:86:"Install the Blogger importer to import posts, comments, and users from a Blogger blog.";s:11:"plugin-slug";s:16:"blogger-importer";s:11:"importer-id";s:7:"blogger";}s:9:"wpcat2tag";a:4:{s:4:"name";s:29:"Categories and Tags Converter";s:11:"description";s:109:"Install the category/tag converter to convert existing categories to tags or tags to categories, selectively.";s:11:"plugin-slug";s:18:"wpcat2tag-importer";s:11:"importer-id";s:9:"wpcat2tag";}s:11:"livejournal";a:4:{s:4:"name";s:11:"LiveJournal";s:11:"description";s:82:"Install the LiveJournal importer to import posts from LiveJournal using their API.";s:11:"plugin-slug";s:20:"livejournal-importer";s:11:"importer-id";s:11:"livejournal";}s:11:"movabletype";a:4:{s:4:"name";s:24:"Movable Type and TypePad";s:11:"description";s:99:"Install the Movable Type importer to import posts and comments from a Movable Type or TypePad blog.";s:11:"plugin-slug";s:20:"movabletype-importer";s:11:"importer-id";s:2:"mt";}s:4:"opml";a:4:{s:4:"name";s:8:"Blogroll";s:11:"description";s:61:"Install the blogroll importer to import links in OPML format.";s:11:"plugin-slug";s:13:"opml-importer";s:11:"importer-id";s:4:"opml";}s:3:"rss";a:4:{s:4:"name";s:3:"RSS";s:11:"description";s:58:"Install the RSS importer to import posts from an RSS feed.";s:11:"plugin-slug";s:12:"rss-importer";s:11:"importer-id";s:3:"rss";}s:6:"tumblr";a:4:{s:4:"name";s:6:"Tumblr";s:11:"description";s:84:"Install the Tumblr importer to import posts &amp; media from Tumblr using their API.";s:11:"plugin-slug";s:15:"tumblr-importer";s:11:"importer-id";s:6:"tumblr";}s:9:"wordpress";a:4:{s:4:"name";s:9:"WordPress";s:11:"description";s:130:"Install the WordPress importer to import posts, pages, comments, custom fields, categories, and tags from a WordPress export file.";s:11:"plugin-slug";s:18:"wordpress-importer";s:11:"importer-id";s:9:"wordpress";}}s:10:"translated";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (145, 'bb_taps_addstyledrop', 'a:2:{i:0;a:7:{s:5:"title";s:10:"color gold";s:6:"inline";s:4:"span";s:7:"classes";s:4:"gold";s:6:"styles";a:1:{s:5:"color";s:8:" #BBA37D";}s:10:"attributes";a:0:{}s:5:"exact";b:0;s:7:"wrapper";b:0;}i:1;a:7:{s:5:"title";s:11:"title about";s:6:"inline";s:4:"span";s:7:"classes";s:11:"title_about";s:6:"styles";a:1:{s:9:"font-size";s:4:"21px";}s:10:"attributes";a:0:{}s:5:"exact";b:0;s:7:"wrapper";b:0;}}', 'yes'); 
INSERT INTO `wp_options` VALUES (148, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:2:{i:0;i:6;i:1;s:2:"11";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (816, '_site_transient_timeout_browser_cfe179b136503c5ffb50573558551e0b', '1409872492', 'yes'); 
INSERT INTO `wp_options` VALUES (817, '_site_transient_browser_cfe179b136503c5ffb50573558551e0b', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:5:"7.0.3";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (442, 'wp_db_backup_excs', 'a:2:{s:9:"revisions";a:1:{i:0;s:8:"wp_posts";}s:4:"spam";a:1:{i:0;s:11:"wp_comments";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (2736, '_site_transient_browser_3033ae672f5030d60b69f754349863be', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"35.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (1867, '_site_transient_timeout_browser_2dd04bb9d87bfa180059c21b3ca7cd2f', '1419873102', 'yes'); 
INSERT INTO `wp_options` VALUES (3613, '_transient_timeout_feed_90703ac594673efe43c980672b645276', '1426076939', 'no'); 
INSERT INTO `wp_options` VALUES (3614, '_transient_feed_90703ac594673efe43c980672b645276', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:49:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:4:"WPML";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:16:"http://wpml.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:52:"The Plugin for Building Multilingual WordPress Sites";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 11 Mar 2015 00:22:42 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:29:"http://wordpress.org/?v=4.1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"This week compatible – Dynamic website builder, UniTheme, Eventory, Maya";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/r5cGunVDIGs/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"http://wpml.org/2015/03/this-week-compatible-dynamic-website-builder-unitheme-eventory-maya/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 06 Mar 2015 15:13:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=572533";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:349:"Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are Dynamik website builder, UniTheme, Eventory, Maya If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready Themes Multilingual Ready Plugins Also, if you&#8217;re [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4923:"<p>Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are <a title="Dynamik website builder" href="http://cobaltapps.com/downloads/dynamik-website-builder/">Dynamik website builder</a>, <a title="UniTheme" href="http://themeforest.net/item/unitheme-responsive-multipurpose-theme/9518921">UniTheme</a>, <a title="Eventory" href="http://themeforest.net/item/eventory-events-responsive-wordpress-theme/6843168">Eventory</a>, <a title="Maya" href="http://themeforest.net/item/maya-smart-powerful-wp-theme/9660706">Maya</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Dynamik website builder theme</h2>\n<p style="text-align: center"><a href="http://cobaltapps.com/downloads/dynamik-website-builder/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/dynamik.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Dynamik is a Genesis Child Theme that includes hundreds of no-coding design options </p></blockquote>\n<p><a class="button download-button vt-p" href="http://cobaltapps.com/downloads/dynamik-website-builder/" target="_blank">Purchase Dynamik website builder theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">UniTheme theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/unitheme-responsive-multipurpose-theme/9518921"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/unitheme.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>UniTheme &#8211; Responsive Multi-Purpose Mega Theme</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/unitheme-responsive-multipurpose-theme/9518921">Purchase The UniTheme theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Eventory Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/eventory-events-responsive-wordpress-theme/6843168"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/eventory.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Eventory Events is WordPress theme suitable for events calendar or image gallery.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/eventory-events-responsive-wordpress-theme/6843168">Purchase Eventory theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Maya Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/maya-smart-powerful-wp-theme/9660706"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/03/maya.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Maya is a composable and clean wordpress template. You can create amazing homes and impressive internal pages.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/maya-smart-powerful-wp-theme/9660706">Purchase Maya theme</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=r5cGunVDIGs:m4GN5dzen9U:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=r5cGunVDIGs:m4GN5dzen9U:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=r5cGunVDIGs:m4GN5dzen9U:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=r5cGunVDIGs:m4GN5dzen9U:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=r5cGunVDIGs:m4GN5dzen9U:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=r5cGunVDIGs:m4GN5dzen9U:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/r5cGunVDIGs" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"http://wpml.org/2015/03/this-week-compatible-dynamic-website-builder-unitheme-eventory-maya/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"http://wpml.org/2015/03/this-week-compatible-dynamic-website-builder-unitheme-eventory-maya/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:71:"This Week Compatible – Bizway, The Thinker, Howes, Rich Text Excerpts";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/7f0GpHnnf-8/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:98:"http://wpml.org/2015/02/this-week-compatible-bizway-the-thinker-howes-rich-text-excerpts/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 27 Feb 2015 17:44:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=568263";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:315:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Bizway, The Thinker, Howes, and the plugin is Rich Text Excerpts If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5657:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Bizway" href="http://www.inkthemes.com/wp-themes/simple-wordpress-theme/">Bizway</a>, <a title="The Thinker" href="http://themeforest.net/item/the-thinker-simple-blogging-wordpress-theme/9712408">The Thinker</a>, <a title="Howes" href="http://themeforest.net/item/howes-responsive-multipurpose-wordpress-theme/9616552">Howes</a>, and the plugin is <a title="Rich Text Excerpts" href="https://wordpress.org/plugins/rich-text-excerpts/">Rich Text Excerpts</a><br />\nIf you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Bizway theme</h2>\n<p style="text-align: center"><a href="http://www.inkthemes.com/wp-themes/simple-wordpress-theme"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/bizway.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>BizWay Pro for WordPress is one of the easiest themes to build your Web Presence in 10 Minutes. Just with in 5 Simple Steps. The Theme is highly customizable and with the presence of several background patterns and Theme Options, You can have your own branded new Website for your Business or Personal Use in Minutes. Features Templates for Blogs, Gallery, Fullwidth Page without sidebar and Contact Us Page.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.inkthemes.com/wp-themes/simple-wordpress-theme" target="_blank">Purchase Bizway theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">The Thinker theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/the-thinker-simple-blogging-wordpress-theme/9712408"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/thinker.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Perfectly simple blogging theme. It has just enough detail without being flashy and just enough features not to get complicated. Beautiful typography and clean layout are a must for any modern blogger and this is where “The Thinker” excels. It keeps readers focused on the content while creating relaxing environment for the eyes.<br />\nThis theme comes with a couple of custom page templates (including shop), color customization options and a top notch slider that will help to further customize the theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/the-thinker-simple-blogging-wordpress-theme/9712408">Purchase The Thinker theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Howes Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/howes-responsive-multipurpose-wordpress-theme/9616552"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/howes.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquoteHowes is multi-purpose responsive theme for WordPress and eCommerce</blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/howes-responsive-multipurpose-wordpress-theme/9616552">Purchase Howes theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Rich Text Excerpts</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/rich-text-excerpts/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/rich.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A WordPress plugin which enables Rich Text editing in excerpts for any post type which supports them.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/rich-text-excerpts/">Download Rich Text Excerpts</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=7f0GpHnnf-8:U_1xw8dbXr8:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=7f0GpHnnf-8:U_1xw8dbXr8:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=7f0GpHnnf-8:U_1xw8dbXr8:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=7f0GpHnnf-8:U_1xw8dbXr8:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=7f0GpHnnf-8:U_1xw8dbXr8:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=7f0GpHnnf-8:U_1xw8dbXr8:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/7f0GpHnnf-8" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:94:"http://wpml.org/2015/02/this-week-compatible-bizway-the-thinker-howes-rich-text-excerpts/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:89:"http://wpml.org/2015/02/this-week-compatible-bizway-the-thinker-howes-rich-text-excerpts/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"WPML 3.2 First Beta";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/WfRRJvoCcEQ/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpml.org/2015/02/wpml-3-2-first-beta/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Feb 2015 17:43:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"WPML versions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=565151";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:331:"We are ready with a first public beta of WPML 3.2. This release is the result of months of development and brings many new capabilities to WPML. Translation Basket The Translation Basket allows you to choose content to translation a lot more easily than before. It&#8217;s very similar to a shopping cart in an e-commerce [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:9491:"<p><strong>We are ready with a first public beta of WPML 3.2. This release is the result of months of development and brings many new capabilities to WPML.</strong></p>\n<h2>Translation Basket</h2>\n<p><div id="attachment_565163" style="width: 310px" class="wp-caption alignright"><a href="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/translation-basket.png"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/translation-basket-300x221.png" alt="Translation Basket" width="300" height="221" class="size-medium wp-image-565163" /></a><p class="wp-caption-text">Translation Basket</p></div>The Translation Basket allows you to choose content to translation a lot more easily than before. It&#8217;s very similar to a shopping cart in an e-commerce site. You can add any kind of content (including strings) to the basket. When you&#8217;re ready, send it at once to your translators.</p>\n<p>Let&#8217;s say you&#8217;re adding a showcase to your site and you want to translate it.</p>\n<p>You will start with the Translation Dashboard and select the new page, where the showcase displays. Add it to the basket.</p>\n<p>Now, change the filter and choose &#8216;showcase entry&#8217; type. Add the showcase entries you want to translate to the basket.</p>\n<p>Finally, go to the String Translation screen and locate the stings that appear in the theme for the showcase (like &#8216;visit site&#8217;, &#8216;Link&#8217;, etc.). Select all those and add to the basket.</p>\n<p>So far, nothing was actually sent to translation. Go to the Translation Basket, review everything you&#8217;ve added and send to translation in one batch. You can give the batch a name, so that you remember what it was about.</p>\n<p>Your translator will love you for collecting all relevant information and sending it together. It&#8217;s also so much easier for you to keep track of translations, when they are grouped by subject.</p>\n<p>Sending to translation became a lot better with the Translation Basket. You may never notice it, but WPML now sends the basket content in chunks, with AJAX updates. This means that you can put unlimited amounts of content into the basket and send it as one big package. You don&#8217;t need to worry about servers timing out. WPML sends it in small chunks, but your translator still gets it as one package.</p>\n<h2>Translation Services</h2>\n<p>Yes, we love our own translation service, <a href="http://www.icanlocalize.com/site/">ICanLocalize</a>, but you can choose. WPML 3.2 will allow you to select between different professional service providers. Right now, we are working with several leading translation services, integrating them with WPML.</p>\n<p>We are now (finally) ready to work with any translation service that has an API. This breakthrough is a result of our new Translation Proxy.</p>\n<p><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/wpml-tp-ts.png" alt="wpml-tp-ts" width="559" height="174" class="alignnone size-full wp-image-565174" /></p>\n<p>The Translation Proxy is our new server, which bridges between the protocols of different translation service providers and WordPress sites. It allows WPML to communicate with different translation services, without knowing their protocol.</p>\n<p>WPML sends content to the Translation Proxy. The Translation Proxy queues it and sends to the translation service, using their native API. So now, to support a new translation service, we don&#8217;t need to update WPML in every website in the world. We add the support to our Translation Proxy and everyone has access to a new translation service.</p>\n<p>Our first translation partners are the team from <a href="http://www.cloudwords.com/">Cloudwords</a>. We&#8217;ve been quietly working with Cloudwords in the past months integrating WPML and our Translation Proxy with Cloudwords API. As soon as WPML 3.2 is released in production, you will be able to receive translation work from Cloudwords.</p>\n<h2>Packages Translation</h2>\n<p>Some plugins and themes use their own tables and complex data structures to hold data. We&#8217;ve seen this with visual editors, event managers and niche-market themes.</p>\n<p>Now, WPML can handle these data structures with ease.</p>\n<p><div id="attachment_565181" style="width: 274px" class="wp-caption alignright"><a href="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/layout-example.png"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/layout-example-264x300.png" alt="A Layout, which you can translate with WPML 3.2" width="264" height="300" class="size-medium wp-image-565181" /></a><p class="wp-caption-text">A Layout, which you can translate with WPML 3.2</p></div>The &#8216;Translation Packages&#8217; support in WPML allows plugins and themes to (easily) declare their data structures and make them known to WPML.</p>\n<p>Using the new <a href="http://wpml.org/documentation/support/string-package-translation/">Translation Packages</a> is almost too easy. You just call one hook (wpml_register_string) when saving your data. This single hook tells WPML that there is a piece of information that belongs to an object. Call it as many times as you need to add fields.</p>\n<p>WPML collects all this information and constructs translatable objects. Then, it allows users to translate them using the Translation Dashboard, just like any other WordPress content.</p>\n<p>When you render, pass your data through the WPML_translate_string filter. If the object is translated, you will receive the correct string in the right language.</p>\n<p>Adding WPML support to our <a href="http://wp-types.com/home/layouts/">Layouts</a> plugin took just a few lines of PHP. We created the entire Layouts plugin without much thought over language and made it multilingual-ready in a couple of hours.</p>\n<h2>Compatibility with W3TC Object Caching</h2>\n<p>WPML 3.2 helps you run sites (a lot) faster by supporting object caching by W3TC. Object caching means that complex items don&#8217;t need to be re-computed on every page render (or often, several times inside the page render).</p>\n<p>The Object Cache engine checks if an &#8216;object&#8217; was recently computed. If so, no need to compute it again. This can greatly speed up dynamic sites, where entire pages cannot be cached.</p>\n<p>In the past, object caching would not work with WPML, because objects got mixed between languages. WPML 3.2 fixes this problem by filtering the object keys and adding languages to them.</p>\n<p>But this is just part of the improvement in WPML 3.2. We&#8217;ve also refactored the String Translation code, making it much more optimized to work with object caching.</p>\n<p>If your site has just a few stings, you&#8217;re not going to notice a great improvement. If you are running a site with loads of strings (typical to WooCommerce sites), you should feel a considerable improvement in speed &#8211; especially if you use W3TC with Object Caching.</p>\n<h2>XLIFF and Translation Analytics Merged In</h2>\n<p>WPML 3.2 includes both the XLIFF module and Translation Analytics, inside the Translation Management module. We&#8217;ve unified all three because while opening WPML to different translation services, we moved to using XLIFF files for all. So, there&#8217;s no more need for a separate XLIFF module for WPML. XLIFF rules!</p>\n<h2>Known Issues</h2>\n<p>New versions of Gravity Forms appear to be acting up with WPML. This isn&#8217;t entirely related to WPML 3.2, but we&#8217;re looking into this.</p>\n<p>Also, WPML 3.2 deprecates a call that our <a href="http://wp-types.com/home/cred/">CRED</a> plugin uses. We&#8217;ll be releasing an update to CRED to be completely compatible with WPML 3.2.</p>\n<p>This version of WPML is not intended for production sites (yet). It doesn&#8217;t support ANY professional translation, including from ICanLocalize.</p>\n<h2>Download and Give Us Feedback</h2>\n<p>You can get WPML 3.2 Beta from your <a href="https://wpml.org/account/">WPML account</a>. Log in, click on Downloads and get the recent beta. This ZIP includes ZIP files of all of WPML&#8217;s components. Unzip it locally and upload the components that you are using.</p>\n<p>If you have XLIFF or Translation Analytics installed, deactivate them to avoid conflicts. Otherwise, update all WPML components that you are using (don&#8217;t use a mix of &#8216;production&#8217; and &#8216;beta&#8217; components).</p>\n<p>Overall, WPML 3.2 beta is pretty close to our final version. We&#8217;d love it if you could take it for a spin and try it on your development sites.</p>\n<p><strong>We are looking to release WPML 3.2 in the next couple of weeks. We would love to hear your feedback. Leave your comments and we&#8217;ll get back to you.</strong></p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=WfRRJvoCcEQ:MXiI42aOkgs:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=WfRRJvoCcEQ:MXiI42aOkgs:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=WfRRJvoCcEQ:MXiI42aOkgs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=WfRRJvoCcEQ:MXiI42aOkgs:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=WfRRJvoCcEQ:MXiI42aOkgs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=WfRRJvoCcEQ:MXiI42aOkgs:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/WfRRJvoCcEQ" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:49:"http://wpml.org/2015/02/wpml-3-2-first-beta/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:44:"http://wpml.org/2015/02/wpml-3-2-first-beta/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"This Week Compatible – Regency, World Wide, Seven, SmartMag";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/f87g3O5Ualc/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:88:"http://wpml.org/2015/02/this-week-compatible-regency-world-wide-seven-smartmag/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 20 Feb 2015 16:23:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=564099";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:338:"Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are Regency, World Wide, Seven, SmartMag If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready Themes Multilingual Ready Plugins Also, if you&#8217;re a [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5249:"<p>Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are <a title="Regency" href="http://themeforest.net/item/regency-a-beautiful-modern-ecommerce-theme/9222795">Regency</a>, <a title="World Wide" href="http://themeforest.net/item/world-wide-responsive-magazine-wp-theme/4940421">World Wide</a>, <a title="Seven" href="http://themeforest.net/item/seven-stylish-wordpress-theme/9409248">Seven</a>, <a title="SmartMag" href="http://themeforest.net/item/smartmag-responsive-retina-wordpress-magazine/6652608">SmartMag</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Regency theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/regency-a-beautiful-modern-ecommerce-theme/9222795"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/regency.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Regency is Fully Responsive WooCommerce theme, which also supports portfolio</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/regency-a-beautiful-modern-ecommerce-theme/9222795 target="_blank">Purchase Regency theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">World Wide theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/world-wide-responsive-magazine-wp-theme/4940421"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/worldwide.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>World Wide is a premium magazine wordpress theme. With this theme, we include 7 blog styles + 5 styles of sidebar layout. Now you can have many possibilities for your site. Also, You can change many setting such as element’s color, Backgroumd pattern, font family etc… easily via our awesome admin panel.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/world-wide-responsive-magazine-wp-theme/4940421">Purchase World Wide theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Seven Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/seven-stylish-wordpress-theme/9409248"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/seven.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A multipurpose theme with clean design, using custom posts for portfolio items and has a built in slider.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/seven-stylish-wordpress-theme/9409248">Purchase Seven theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">SmartMag Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/smartmag-responsive-retina-wordpress-magazine/6652608"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/smartmag.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>SmartMag is a modern, clean, responsive and retina-ready (HD) WordPress theme suitable for magazines, newspapers, review sites, or blogs.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/smartmag-responsive-retina-wordpress-magazine/6652608">Purchase SmartMag theme</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=f87g3O5Ualc:pfhtj5Akfb4:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=f87g3O5Ualc:pfhtj5Akfb4:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=f87g3O5Ualc:pfhtj5Akfb4:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=f87g3O5Ualc:pfhtj5Akfb4:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=f87g3O5Ualc:pfhtj5Akfb4:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=f87g3O5Ualc:pfhtj5Akfb4:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/f87g3O5Ualc" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:84:"http://wpml.org/2015/02/this-week-compatible-regency-world-wide-seven-smartmag/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:79:"http://wpml.org/2015/02/this-week-compatible-regency-world-wide-seven-smartmag/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"This Week Compatible – Oslo, Falco, Mindig, Osmosis, Beliy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/DJmdnsa1rlo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:87:"http://wpml.org/2015/02/this-week-compatible-oslo-falco-minding-osmosis-beliy/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 13 Feb 2015 17:31:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=560553";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:337:"Today we are happy to announce that we have 5 themes to add to our compatibility list. The themes are Oslo, Falco, Mindig, Osmosis, Beliy If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready Themes Multilingual Ready Plugins Also, if you&#8217;re a [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6123:"<p>Today we are happy to announce that we have 5 themes to add to our compatibility list. The themes are <a title="Oslo" href="https://www.pixelunion.net/themes/ghost/oslo-lite/">Oslo</a>, <a title="Falco" href="http://themeforest.net/item/falco-responsive-multipurpose-wordpress-theme/5926997">Falco</a>, <a title="Mindig" href="http://themeforest.net/item/mindig-a-flat-multipurpose-ecommerce-theme/8922501">Mindig</a>, <a title="Osmosis" href="http://themeforest.net/item/osmosis-responsive-multipurpose-theme/9839949">Osmosis</a>, <a title="Beliy" href="http://themeforest.net/item/beliy-minimal-modern-multipurpose-blog-theme/9560519">Beliy</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Oslo theme</h2>\n<p style="text-align: center"><a href="https://www.pixelunion.net/themes/ghost/oslo-lite/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/oslo.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Oslo is a stunning blend of refinement and organization. It’s a mature two-column theme fit for portfolio and general blog use, built around a supremely customizable sidebar and beautiful typography.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://www.pixelunion.net/themes/ghost/oslo-lite/" target="_blank">Purchase Oslo theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Falco theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/falco-responsive-multipurpose-wordpress-theme/5926997"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/falco.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Falco theme is perfect choice for everyone. It does not matter if you are coder from website agency or just person who have own business and want to create website for own customers or yourself. With our solutions you can do everything without any php/css/html knowledge.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/falco-responsive-multipurpose-wordpress-theme/5926997" target="_blank">Purchase Falco theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Mindig Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/mindig-a-flat-multipurpose-ecommerce-theme/8922501"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/minding.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>a Flat &#038; Multipurpose Ecommerce Theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/mindig-a-flat-multipurpose-ecommerce-theme/8922501">Purchase Mindig theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Osmosis Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/osmosis-responsive-multipurpose-theme/9839949"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/osmosis.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Osmosis is an unparalleled and effortless multi-functional WordPress Theme. It offers stand-out-from-the-pack options and superior aesthetics; become the designer you have always dreamt of and impress the world simply and smartly.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/osmosis-responsive-multipurpose-theme/9839949">Purchase Osmosis theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Beliy Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/beliy-minimal-modern-multipurpose-blog-theme/9560519"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/beliy.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Beliy is a HTML5/CSS3/Bootstrap optimized Parallax powered, responsive theme perfect for multi-purpose blog themes. WPML also supported by default.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/beliy-minimal-modern-multipurpose-blog-theme/9560519">Purchase Beliy theme</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=DJmdnsa1rlo:6bQKARmTgSY:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=DJmdnsa1rlo:6bQKARmTgSY:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DJmdnsa1rlo:6bQKARmTgSY:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=DJmdnsa1rlo:6bQKARmTgSY:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DJmdnsa1rlo:6bQKARmTgSY:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=DJmdnsa1rlo:6bQKARmTgSY:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/DJmdnsa1rlo" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:83:"http://wpml.org/2015/02/this-week-compatible-oslo-falco-minding-osmosis-beliy/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:78:"http://wpml.org/2015/02/this-week-compatible-oslo-falco-minding-osmosis-beliy/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:73:"This Week Compatible – Mr. tailor, Multinews, Explorer, WP Sitemap Page";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/DdP1TeSdH8A/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:99:"http://wpml.org/2015/02/this-week-compatible-mr-tailor-multinews-explorer-wp-sitemap-page/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 06 Feb 2015 18:58:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=556241";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:322:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Mr.Tailor, Multinews, Explorer, and the plugin is WP Sitemap Page If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5550:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Mr. Tailor" href="http://themeforest.net/item/mr-tailor-responsive-woocommerce-theme/7292110">Mr.Tailor</a>, <a title="Multinews" href="http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494">Multinews</a>, <a title="Explorer" href="http://www.anarieldesign.com/themes/travel-fashion-food-wordpress-theme/">Explorer</a>, and the plugin is <a title="WP Sitemap Page" href="https://wordpress.org/plugins/wp-sitemap-page/">WP Sitemap Page</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Mr. Tailor theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/mr-tailor-responsive-woocommerce-theme/7292110"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/tailor.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Mr. Tailor is a highly customizable responsive WordPress theme. WordPress consultants are using it as a framework to quickly build powerful websites and online stores for their customers.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/mr-tailor-responsive-woocommerce-theme/7292110" target="_blank">Purchase Mr. Tailor theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Multinews theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/multinews.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Multinews is a News/Magazine wordpress theme. You can use Multinews for Magazine, newspaper and blog. Multinews has many features such as Flipping magazine, Beautiful mega menus, a lot of Layouts options, Ajax Live search, Author Timeline, popular plugins integrated ( Woocommerce, bbPress, Ad Rotate, MailPoet Newsletters, Contact form 7 and much more).</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494" target="_blank">Purchase Multinews theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Explorer Theme</h2>\n<p style="text-align: center"><a href="http://www.anarieldesign.com/themes/travel-fashion-food-wordpress-theme/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/explorer.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Modern theme that can be used as fashion or travel blog, with front page custom widgets, clean layout and easily readable typography.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.anarieldesign.com/themes/travel-fashion-food-wordpress-theme/">Purchase Explorer theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">WP Sitemap Page Plugin</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/wp-sitemap-page/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/02/sitemap.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>An easy way to add a sitemap on one of your pages becomes reality thanks to this WordPress plugin. Just use the shortcode [wp_sitemap_page] on any of your pages. This will automatically generate a sitemap of all your pages and posts.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/wp-sitemap-page/">Download WP Sitemap Page Plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=DdP1TeSdH8A:b3IllKrZJo8:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=DdP1TeSdH8A:b3IllKrZJo8:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DdP1TeSdH8A:b3IllKrZJo8:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=DdP1TeSdH8A:b3IllKrZJo8:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=DdP1TeSdH8A:b3IllKrZJo8:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=DdP1TeSdH8A:b3IllKrZJo8:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/DdP1TeSdH8A" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:95:"http://wpml.org/2015/02/this-week-compatible-mr-tailor-multinews-explorer-wp-sitemap-page/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:90:"http://wpml.org/2015/02/this-week-compatible-mr-tailor-multinews-explorer-wp-sitemap-page/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"WooCommerce Multilingual 3.5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/BShZCm78WrQ/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:62:"http://wpml.org/2015/02/woocommerce-multilingual-3-5/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 04 Feb 2015 16:39:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"WPML versions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=551400";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:355:"This version brings in the long waited support for creating products in secondary languages without first having to exist in the default language but also several other changes and improvements. Added support for creating products in secondary languages only. Up until this version each product had to first be created in the default language in [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Mihai";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6416:"<p><strong>This version brings in the long waited support for creating products in secondary languages without first having to exist in the default language but also several other changes and improvements.</strong></p>\n<h2>Added support for creating products in secondary languages only.</h2>\n<p>Up until this version each product had to first be created in the default language in order for it to also be created in a different language (translated).</p>\n<div id="attachment_551403" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551403" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image02.png" alt="image02" width="500" height="385" /><p class="wp-caption-text">Selecting the language for a new product</p></div>\n<p>Now you can select the language of the product at the moment when it is created or change the language afterwards just like for the regular posts translation in WPML.</p>\n<p>In the example above, you can see how using the native editor it’s possible to set the language for a product to French which is not the default language.</p>\n<p>In the WooCommerce Multilingual products translation page, the interface has been changed to accommodate the fact that the original language of the products can be any language of the active languages of the site.</p>\n<div id="attachment_551406" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551406" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image01.png" alt="image01" width="500" height="332" /><p class="wp-caption-text">Products in different languages on the products translation screen.</p></div>\n<p>Along with the changes for the products, product categories, product tags and any other taxonomies associated with product can be created and exist alone in secondary languages.</p>\n<div id="attachment_551411" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551411" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image03.png" alt="Setting the language for products taxonomies" width="500" height="489" /><p class="wp-caption-text">Setting the language for products taxonomies</p></div>\n<h2>Added enhancements for the Woocommerce Multilingual products table (filter by original language, display language flag).</h2>\n<p>The new language options introduced the need to add some new design elements. At the top of the products translation screen, you can filter products to be listed by a specific language and also chose to only see translations in a specific language (useful when your site has many secondary languages).</p>\n<div id="attachment_551415" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551415" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image04.png" alt="Filtering the products by language and translations." width="500" height="386" /><p class="wp-caption-text">Filtering the products by language and translations.</p></div>\n<h2>Added option to synchronize the products and product taxonomies order.</h2>\n<p>This new option that is ‘on’ by default allows one to set a custom order for the products in the shops in each different language. This especially comes handy for a site with a mix between products in different languages that are not translation of each others and products that have translations.</p>\n<div id="attachment_551416" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-551416" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/image00.png" alt="The option to synchronize products and product taxonomies display order." width="500" height="238" /><p class="wp-caption-text">The option to synchronize products and product taxonomies display order.</p></div>\n<h2>Some of the bugs fixed:</h2>\n<ul>\n<li>The cart was not updating quantities for variable product (when have more than one variable in the cart).</li>\n<li>The cart total was not updating when using get_cart_total() and get_cart_subtotal() functions in other plugins or themes.</li>\n<li>Wrong price format and order total were displayed on the new order page in the WP admin.</li>\n<li>The featured image and the gallery images were overridden when updating translations.</li>\n<li>Fixed the &#8216;Keep&#8217; option (under multi-currency options) that allows keeping the same currency on the front end, when switching the language.</li>\n<li>Fixed a javascript error that was showing when changing currencies order.</li>\n<li>The decimal number was not working correctly for the default currency.</li>\n<li>Fixed a compatibility problem with WooCommerce Product Tabs.</li>\n<li>A coupon was applied incorrectly to all products in the cart when they were defined for specific product variations.</li>\n<li>WooCommerce note email language was not correct.</li>\n<li>WooCommerce reports were showing duplicate products.</li>\n<li>When using WordPress in a folder, the checkout showed an &#8216;expired session&#8217; error message.</li>\n</ul>\n<h2>A little something for the developers</h2>\n<p>Added support currency argument in raw_price_filter. This allows one to display prices in a different currency than the current currency on the page. e.g. display a custom list of prices without using a ‘list-type’ layout of the currency selector.</p>\n<h2>Download or upgrade</h2>\n<p>You can get <a href="https://downloads.wordpress.org/plugin/woocommerce-multilingual.3.5.zip">WooCommerce Multilingual 3.5</a> from the WordPress plugins directory and you are welcome to add and we’d love to hear your feedback here on any problems you may have on our <a href="http://wpml.org/forums/topic-tag/woocommerce/">support forum</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=BShZCm78WrQ:3C1vUHQL9zo:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=BShZCm78WrQ:3C1vUHQL9zo:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=BShZCm78WrQ:3C1vUHQL9zo:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=BShZCm78WrQ:3C1vUHQL9zo:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=BShZCm78WrQ:3C1vUHQL9zo:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=BShZCm78WrQ:3C1vUHQL9zo:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/BShZCm78WrQ" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:58:"http://wpml.org/2015/02/woocommerce-multilingual-3-5/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpml.org/2015/02/woocommerce-multilingual-3-5/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"Setting ACF plugin with WPML";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/OcPRYtqqo6Y/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:57:"http://wpml.org/2015/02/setting-acf-plugin-wpml/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 02 Feb 2015 18:37:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:9:"Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=553066";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:314:"Do you want to use WPML together with your Advanced Custom Fields plugin? This is how it&#8217;s done Advanced Custom Fields is used by many of our clients, it lets you add many types of fields to your posts which can later be displayed using the plugin&#8217;s API. Want to learn more? Read the tutorial [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1511:"<p><strong>Do you want to use WPML together with your <a href="https://wordpress.org/plugins/advanced-custom-fields/" title="Advanced Custom Fields Plugin" target="_blank">Advanced Custom Fields</a> plugin? This is how it&#8217;s done</strong></p>\n<p><iframe width="500" height="375" src="https://www.youtube.com/embed/osUX987d0EQ?feature=oembed" frameborder="0" allowfullscreen></iframe></p>\n<p>Advanced Custom Fields is used by many of our clients, it lets you add many types of fields to your posts which can later be displayed using the plugin&#8217;s API. </p>\n<p>Want to learn more? Read the tutorial on <a href="http://wpml.org/documentation/theme-compatibility/setting-wpml-advanced-custom-fields/" title="How to translate sites built with ACF">How to translate sites built with ACF</a> and get started.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=OcPRYtqqo6Y:krUvoWw2drA:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=OcPRYtqqo6Y:krUvoWw2drA:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=OcPRYtqqo6Y:krUvoWw2drA:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=OcPRYtqqo6Y:krUvoWw2drA:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=OcPRYtqqo6Y:krUvoWw2drA:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=OcPRYtqqo6Y:krUvoWw2drA:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/OcPRYtqqo6Y" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:53:"http://wpml.org/2015/02/setting-acf-plugin-wpml/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:48:"http://wpml.org/2015/02/setting-acf-plugin-wpml/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:86:"This Week Compatible – Quince, Flatmarket, Frame, Grand College, Video Tab, Utilizer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/bddK4VqDsYc/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:111:"http://wpml.org/2015/01/this-week-compatible-quince-flatmarket-frame-grand-college-video-tab-utilizer/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Jan 2015 16:07:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=551830";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:340:"Today we are happy to announce that we have 4 themes, 1 WooCommerce extension and 1 plugin to add to our compatibility list. The themes are Quince, Flatmarket, Frame, Grand College Hotel, the WooCommerce extension is Product Video Tab, and the plugin is Utilizer If you want to review the entire multilingual ready list of themes [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6590:"<p>Today we are happy to announce that we have 4 themes, 1 WooCommerce extension and 1 plugin to add to our compatibility list. The themes are <a title="Quince" href="http://themeforest.net/item/quince-modern-business-theme/9299244">Quince</a>, <a title="Flatmarket" href="http://themeforest.net/item/flatmarket-multipurpose-woocommerce-theme-rtl/9185162">Flatmarket</a>, <a title="Frame" href="http://themeforest.net/item/frame-photography-minimalistic-wp-theme-/5358164">Frame</a>, <a title="Grand College" href="http://themeforest.net/item/grand-college-wordpress-theme-for-education/1865598">Grand College Hotel</a>, the WooCommerce extension is <a title="Product Video Tab" href="http://www.woo-ninja.com/shop/woocommerce-video-tab/">Product Video Tab</a>, and the plugin is <a title="Utilizer" href="http://utilizer.vuzzu.net/">Utilizer</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Quince theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/quince-modern-business-theme/9299244"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/quince.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Modern Business Theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/quince-modern-business-theme/9299244" target="_blank">Purchase Quince theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Flatmarket theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/flatmarket-multipurpose-woocommerce-theme-rtl/9185162"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/flatmarket.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Multi-Purpose Unlimited Skins Premium Responsive WordPress WooCommerce theme with visual Page Builder, powerful control panel and full RTL and WPML support!</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/flatmarket-multipurpose-woocommerce-theme-rtl/9185162" target="_blank">Purchase Flatmarket theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Frame Theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/frame-photography-minimalistic-wp-theme-/5358164"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/frame.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Photography Minimalistic WP Theme</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/frame-photography-minimalistic-wp-theme-/5358164">Purchase Frame theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Grand College theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/grand-college-wordpress-theme-for-education/1865598"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/grand.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A theme for School, University, College. Clean and modern designed with well crafted. You can also translate each elements to your language via this admin panel.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/grand-college-wordpress-theme-for-education/1865598">Purchase Grand College Theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Product Video Tab</h2>\n<p style="text-align: center"><a href="http://www.woo-ninja.com/shop/woocommerce-video-tab/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/videotab.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Spice up your woocommerce product pages with product videos! This plugin allows you to add a video tab to your products in your woocommerce wordpress store.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.woo-ninja.com/shop/woocommerce-video-tab/">Product Video Tab</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Utilizer Plugin</h2>\n<p style="text-align: center"><a href="http://utilizer.vuzzu.net/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/utilizer.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Utilizer is a powerful plugin, easy to use and brand. Within few seconds be able to create your pages content using predefined elements with no development at all.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://utilizer.vuzzu.net/">Utilizer Plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=bddK4VqDsYc:pjNnl1auw2s:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=bddK4VqDsYc:pjNnl1auw2s:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=bddK4VqDsYc:pjNnl1auw2s:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=bddK4VqDsYc:pjNnl1auw2s:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=bddK4VqDsYc:pjNnl1auw2s:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=bddK4VqDsYc:pjNnl1auw2s:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/bddK4VqDsYc" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:107:"http://wpml.org/2015/01/this-week-compatible-quince-flatmarket-frame-grand-college-video-tab-utilizer/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:102:"http://wpml.org/2015/01/this-week-compatible-quince-flatmarket-frame-grand-college-video-tab-utilizer/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:87:"This week compatible – Dolly, Adrenalin, Highend, Nation Hotel, Flexible Posts Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/qfG0mnqXYr8/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:113:"http://wpml.org/2015/01/this-week-compatible-dolly-adrenalin-highend-nation-hotel-flexible-posts-widget/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 23 Jan 2015 16:26:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:25:"http://wpml.org/?p=548040";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:318:"Today we are happy to announce that we have 4 themes and 1 plugin to add to our compatibility list. The themes are Dolly, Adrenalin, Highend, Nation Hotel, and the plugin is Flexible Posts Widget If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6279:"<p>Today we are happy to announce that we have 4 themes and 1 plugin to add to our compatibility list. The themes are <a title="Dolly" href="http://themeforest.net/item/dolly-multipurpose-wordpress-theme/9170391">Dolly</a>, <a title="Adrenalin" href="http://themeforest.net/item/adrenalin-multipurpose-woocommerce-theme/9284771">Adrenalin</a>, <a title="Highend" href="http://hb-themes.com/home/themes/highend/">Highend</a>, <a title="Nation Hotel" href="http://themeforest.net/item/nation-hotel-responsive-wordpress-theme/6895743">Nation Hotel</a>, and the plugin is <a title="Flexible Posts Widget" href="https://wordpress.org/plugins/flexible-posts-widget/">Flexible Posts Widget</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="http://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="http://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="http://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="http://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Dolly theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/dolly-multipurpose-wordpress-theme/9170391"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/dolly.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Dolly is a clean, powerful &#038; multipurpose wordpress theme that can be used to build professional and modern websites. You can set your colors, change fonts, background patterns &#038; the layouts in different pages.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/dolly-multipurpose-wordpress-theme/9170391" target="_blank">Purchase Dolly theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Adrenalin theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/adrenalin-multipurpose-woocommerce-theme/9284771"><img src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/adrenalin.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A multi purpose WooCommerce Theme with many features</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/adrenalin-multipurpose-woocommerce-theme/9284771" target="_blank">Purchase Adrenalin theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Highend Theme</h2>\n<p style="text-align: center"><a href="http://hb-themes.com/home/themes/highend/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/highend.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A responsive and clean multipurpose theme with a drag and drop page builder, many premium add-ons (Layer Slider, Revolution Slider, Visual Composer, Ultimate lcoMoon lcons Pack and Essential Grid) and post types (Team Members, Clients, FAQ, Pricing Tables, Testimonials, Portfolio and Gallery) to fit any purpose website.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://hb-themes.com/home/themes/highend/">Purchase Highend theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Nation Hotel theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/nation-hotel-responsive-wordpress-theme/6895743"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/nationhotel.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Nation Hotel is a responsive WordPress theme created by using latest HTML5 and CSS3 techniques and specially designed for Hotels, Motels, B&#038;B, Guest House, Hostels and any other hospitality businesses.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/nation-hotel-responsive-wordpress-theme/6895743">Purchase Nation Hotel</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center">Flexible Posts Widget Plugin</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/flexible-posts-widget/"><img class="aligncenter size-full wp-image-340493" src="http://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/01/flexible.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Flexible Posts Widget (FPW) is more than just a simple alternative to the default Recent Posts widget. With many per-instance options it is highly customizable and allows advanced users to display the resulting posts virtually any way imaginable.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/flexible-posts-widget/">Download Flexible Posts Widget plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=qfG0mnqXYr8:3RPFgTTIIcw:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=qfG0mnqXYr8:3RPFgTTIIcw:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=qfG0mnqXYr8:3RPFgTTIIcw:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=qfG0mnqXYr8:3RPFgTTIIcw:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=qfG0mnqXYr8:3RPFgTTIIcw:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=qfG0mnqXYr8:3RPFgTTIIcw:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="//feeds.feedburner.com/~r/wpml/~4/qfG0mnqXYr8" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:109:"http://wpml.org/2015/01/this-week-compatible-dolly-adrenalin-highend-nation-hotel-flexible-posts-widget/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:104:"http://wpml.org/2015/01/this-week-compatible-dolly-adrenalin-highend-nation-hotel-flexible-posts-widget/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:32:"http://feeds.feedburner.com/wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:3:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:4:"wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:14:"emailServiceId";a:1:{i:0;a:5:{s:4:"data";s:4:"wpml";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:18:"feedburnerHostname";a:1:{i:0;a:5:{s:4:"data";s:29:"https://feedburner.google.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:11:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:13:"last-modified";s:29:"Wed, 11 Mar 2015 00:26:13 GMT";s:4:"date";s:29:"Wed, 11 Mar 2015 00:28:59 GMT";s:7:"expires";s:29:"Wed, 11 Mar 2015 00:28:59 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:14:"80:quic,p=0.08";s:13:"accept-ranges";s:4:"none";s:4:"vary";s:15:"Accept-Encoding";}s:5:"build";s:14:"20140618032821";}', 'no'); 
INSERT INTO `wp_options` VALUES (3735, '_site_transient_timeout_browser_8f08344a06a0174f5157cb8b14bb5d61', '1427204623', 'yes'); 
INSERT INTO `wp_options` VALUES (5676, '_site_transient_timeout_browser_c87684fd7cfd854f3826012e7e1f8d17', '1432731054', 'yes'); 
INSERT INTO `wp_options` VALUES (5677, '_site_transient_browser_c87684fd7cfd854f3826012e7e1f8d17', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:5:"7.1.3";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (1868, '_site_transient_browser_2dd04bb9d87bfa180059c21b3ca7cd2f', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:7:"Firefox";s:7:"version";s:4:"34.0";s:10:"update_url";s:23:"http://www.firefox.com/";s:7:"img_src";s:50:"http://s.wordpress.org/images/browsers/firefox.png";s:11:"img_src_ssl";s:49:"https://wordpress.org/images/browsers/firefox.png";s:15:"current_version";s:2:"16";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (5482, 'wp_icl_translators_cached', 'a:2:{i:0;O:8:"stdClass":1:{s:2:"ID";s:1:"2";}i:1;O:8:"stdClass":1:{s:2:"ID";s:1:"1";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (5494, 'duplicate_post_show_submitbox', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (5495, 'duplicate_post_version', '2.6', 'yes'); 
INSERT INTO `wp_options` VALUES (5493, 'duplicate_post_show_adminbar', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (5492, 'duplicate_post_show_row', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (5488, 'duplicate_post_copyattachments', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5489, 'duplicate_post_copychildren', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5490, 'duplicate_post_copystatus', '0', 'yes'); 
INSERT INTO `wp_options` VALUES (5491, 'duplicate_post_taxonomies_blacklist', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (5487, 'duplicate_post_copyexcerpt', '1', 'yes'); 
INSERT INTO `wp_options` VALUES (3813, 'wpml_config_index', 'O:8:"stdClass":2:{s:7:"plugins";a:19:{i:0;O:8:"stdClass":5:{s:4:"name";s:38:"WooCommerce Catalog Visibility Options";s:14:"override_local";b:1;s:7:"updated";i:1408625614;s:4:"path";s:66:"wpml-config/woocommerce-catalog-visibility-options/wpml-config.xml";s:4:"hash";s:32:"d10bd6388a88521e488f7e4ba295c94c";}i:1;O:8:"stdClass":5:{s:4:"name";s:27:"WooCommerce Paymill Gateway";s:14:"override_local";b:1;s:7:"updated";i:1408626572;s:4:"path";s:55:"wpml-config/woocommerce-paymill-gateway/wpml-config.xml";s:4:"hash";s:32:"46409842584ff8df43a2aa922ad1d388";}i:2;O:8:"stdClass":5:{s:4:"name";s:26:"WooCommerce Stripe Gateway";s:14:"override_local";b:1;s:7:"updated";i:1409061503;s:4:"path";s:54:"wpml-config/woocommerce-stripe-gateway/wpml-config.xml";s:4:"hash";s:32:"4139e23bcdd0bb3e78cb079fa851ce85";}i:3;O:8:"stdClass":5:{s:4:"name";s:27:"WooCommerce Product Add-ons";s:14:"override_local";b:1;s:7:"updated";i:1409062371;s:4:"path";s:55:"wpml-config/woocommerce-product-add-ons/wpml-config.xml";s:4:"hash";s:32:"75320b24a703c55370175379c2faf22d";}i:4;O:8:"stdClass":5:{s:4:"name";s:20:"WooCommerce PostePay";s:14:"override_local";b:1;s:7:"updated";i:1409063136;s:4:"path";s:48:"wpml-config/woocommerce-postepay/wpml-config.xml";s:4:"hash";s:32:"b08722979a25b15ba4a02a16fb555ccc";}i:5;O:8:"stdClass":5:{s:4:"name";s:6:"Sensei";s:14:"override_local";b:1;s:7:"updated";i:1409063311;s:4:"path";s:34:"wpml-config/sensei/wpml-config.xml";s:4:"hash";s:32:"21fda51a99579915e92c6b22ae073a81";}i:6;O:8:"stdClass":5:{s:4:"name";s:25:"NW ADCart for WooCommerce";s:14:"override_local";b:1;s:7:"updated";i:1409734281;s:4:"path";s:53:"wpml-config/nw-adcart-for-woocommerce/wpml-config.xml";s:4:"hash";s:32:"91d62df0659fc7b561a3932a7a52de6a";}i:7;O:8:"stdClass":5:{s:4:"name";s:35:"Product Enquiry Pro for WooCommerce";s:14:"override_local";b:1;s:7:"updated";i:1409734531;s:4:"path";s:63:"wpml-config/product-enquiry-pro-for-woocommerce/wpml-config.xml";s:4:"hash";s:32:"305232f06370d52a29c346d6b711f50a";}i:8;O:8:"stdClass":5:{s:4:"name";s:17:"WooCommerce Plivo";s:14:"override_local";b:1;s:7:"updated";i:1409734705;s:4:"path";s:45:"wpml-config/woocommerce-plivo/wpml-config.xml";s:4:"hash";s:32:"539d172825c4714d69b8a42ad1826c5d";}i:9;O:8:"stdClass":5:{s:4:"name";s:24:"WooCommerce Embed Slides";s:14:"override_local";b:1;s:7:"updated";i:1409813892;s:4:"path";s:52:"wpml-config/woocommerce-embed-slides/wpml-config.xml";s:4:"hash";s:32:"f92b0578c4950e1d7ced60bbdba7ed5b";}i:10;O:8:"stdClass":5:{s:4:"name";s:22:"PayPal for WooCommerce";s:14:"override_local";b:1;s:7:"updated";i:1412841483;s:4:"path";s:54:"wpml-config/paypal-for-woocommerce/wpml-config (1).xml";s:4:"hash";s:32:"4ec8cff3c1bd61950873206196a29348";}i:11;O:8:"stdClass":5:{s:4:"name";s:27:"WooCommerce Product Bundles";s:14:"override_local";b:1;s:7:"updated";i:1414747440;s:4:"path";s:55:"wpml-config/woocommerce-product-bundles/wpml-config.xml";s:4:"hash";s:32:"81eae0e4985a54c08a2486cbc0cba690";}i:12;O:8:"stdClass":5:{s:4:"name";s:28:"WooCommerce Price by Country";s:14:"override_local";b:1;s:7:"updated";i:1415282919;s:4:"path";s:56:"wpml-config/woocommerce-price-by-country/wpml-config.xml";s:4:"hash";s:32:"9b296d64ba8afee80cb1ff4fac80144b";}i:13;O:8:"stdClass":5:{s:4:"name";s:21:"WooCommerce Video Tab";s:14:"override_local";b:1;s:7:"updated";i:1415284344;s:4:"path";s:49:"wpml-config/woocommerce-video-tab/wpml-config.xml";s:4:"hash";s:32:"7f9769bc2769e07ae730f3b4cd307741";}i:14;O:8:"stdClass":5:{s:4:"name";s:24:"WooCommerce Multilingual";s:14:"override_local";b:1;s:7:"updated";i:1426674188;s:4:"path";s:52:"wpml-config/woocommerce-multilingual/wpml-config.xml";s:4:"hash";s:32:"03dd5a10ac5d2ff7b7c576c4449cf7dc";}i:15;O:8:"stdClass":7:{s:4:"name";s:16:"WPML Test Config";s:14:"override_local";b:1;s:7:"updated";i:1429773131;s:4:"path";s:44:"wpml-config/wpml-test-config/wpml-config.xml";s:4:"hash";s:32:"9c3bb313d5a4f028bebfa8fc8af990a3";s:4:"user";s:5:"admin";s:7:"details";s:3:"222";}i:16;O:8:"stdClass":5:{s:4:"name";s:29:"WooCommerce Product Gift Wrap";s:14:"override_local";b:1;s:7:"updated";i:1429640013;s:4:"path";s:57:"wpml-config/woocommerce-product-gift-wrap/wpml-config.xml";s:4:"hash";s:32:"dd3371d64d2ee01e6e42fd7e0bd134cf";}i:17;O:8:"stdClass":5:{s:4:"name";s:13:"WordPress SEO";s:14:"override_local";b:1;s:7:"updated";i:1433159636;s:4:"path";s:41:"wpml-config/wordpress-seo/wpml-config.xml";s:4:"hash";s:32:"6cdbcb3059702992376099699aa2f196";}i:18;O:8:"stdClass":5:{s:4:"name";s:23:"WooCommerce Tab Manager";s:14:"override_local";b:1;s:7:"updated";i:1433882104;s:4:"path";s:51:"wpml-config/woocommerce-tab-manager/wpml-config.xml";s:4:"hash";s:32:"0824e477b8f1e70d10476eebaf0ac7cb";}}s:6:"themes";a:6:{i:0;O:8:"stdClass":5:{s:4:"name";s:6:"Canvas";s:14:"override_local";b:1;s:7:"updated";i:1425652093;s:4:"path";s:34:"wpml-config/canvas/wpml-config.xml";s:4:"hash";s:32:"9e8668255d8dd56105b67540358bae56";}i:1;O:8:"stdClass":5:{s:4:"name";s:4:"Kleo";s:14:"override_local";b:0;s:7:"updated";i:1425651882;s:4:"path";s:32:"wpml-config/kleo/wpml-config.xml";s:4:"hash";s:32:"442023138b716c2f410690eabeeab185";}i:2;O:8:"stdClass":5:{s:4:"name";s:4:"Port";s:14:"override_local";b:1;s:7:"updated";i:1426496203;s:4:"path";s:32:"wpml-config/port/wpml-config.xml";s:4:"hash";s:32:"788cce209545b94cfede660d543d7013";}i:3;O:8:"stdClass":5:{s:4:"name";s:36:"IDStore - Responsive WordPress Theme";s:14:"override_local";b:1;s:7:"updated";i:1427452920;s:4:"path";s:62:"wpml-config/idstore-responsive-wordpress-theme/wpml-config.xml";s:4:"hash";s:32:"c4ab5787cebb38c0358286626710ab37";}i:4;O:8:"stdClass":5:{s:4:"name";s:4:"Divi";s:14:"override_local";b:1;s:7:"updated";i:1430146146;s:4:"path";s:32:"wpml-config/divi/wpml-config.xml";s:4:"hash";s:32:"df3ab45b0372192108394aad7af044b4";}i:5;O:8:"stdClass":5:{s:4:"name";s:5:"Avada";s:14:"override_local";b:1;s:7:"updated";i:1430299590;s:4:"path";s:33:"wpml-config/avada/wpml-config.xml";s:4:"hash";s:32:"0dfb750d08596266d9dfda556c1bb1e1";}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (3814, 'wpml_config_index_updated', '1434967202', 'yes'); 
INSERT INTO `wp_options` VALUES (3815, 'wpml_config_files_arr', 'O:8:"stdClass":2:{s:6:"themes";a:0:{}s:7:"plugins";a:0:{}}', 'yes'); 
INSERT INTO `wp_options` VALUES (3817, 'icl_adl_settings', 'a:3:{s:10:"wp_version";s:5:"3.9.1";s:19:"last_time_xml_check";i:1426813960;s:27:"last_time_xml_check_trigger";s:9:"wp-update";}', 'yes'); 
INSERT INTO `wp_options` VALUES (3818, '_transient_WPML_ST_MO_Downloader_lang_map', 'a:105:{s:2:"an";s:2:"an";s:2:"ar";s:2:"ar";s:2:"az";s:2:"az";s:5:"az_TR";s:5:"az-tr";s:5:"bg_BG";s:2:"bg";s:5:"bn_BD";s:2:"bn";s:5:"bs_BA";s:2:"bs";s:2:"ca";s:2:"ca";s:3:"ckb";s:3:"ckb";s:2:"co";s:2:"co";s:5:"cs_CZ";s:2:"cs";s:2:"cy";s:2:"cy";s:5:"da_DK";s:2:"da";s:5:"de_DE";s:2:"de";s:2:"dv";s:2:"dv";s:2:"el";s:2:"el";s:5:"en_CA";s:5:"en-ca";s:5:"en_GB";s:5:"en-gb";s:2:"eo";s:2:"eo";s:5:"es_CL";s:5:"es-cl";s:5:"es_ES";s:2:"es";s:5:"es_PE";s:5:"es-pe";s:5:"es_VE";s:5:"es-ve";s:2:"et";s:2:"et";s:2:"eu";s:2:"eu";s:5:"fa_AF";s:5:"fa-af";s:5:"fa_IR";s:2:"fa";s:2:"fi";s:2:"fi";s:2:"fo";s:2:"fo";s:5:"fr_FR";s:2:"fr";s:2:"fy";s:2:"fy";s:2:"ga";s:2:"ga";s:2:"gd";s:2:"gd";s:5:"gl_ES";s:2:"gl";s:2:"gu";s:2:"gu";s:5:"haw_U";s:3:"haw";s:5:"he_IL";s:2:"he";s:5:"hi_IN";s:2:"hi";s:2:"hr";s:2:"hr";s:5:"hu_HU";s:2:"hu";s:2:"hy";s:2:"hy";s:5:"id_ID";s:2:"id";s:5:"is_IS";s:2:"is";s:5:"it_IT";s:2:"it";s:2:"ja";s:2:"ja";s:5:"jv_ID";s:2:"jv";s:5:"ka_GE";s:2:"ka";s:3:"kea";s:3:"kea";s:2:"kk";s:2:"kk";s:2:"kn";s:2:"kn";s:5:"ko_KR";s:2:"ko";s:2:"ku";s:2:"ku";s:5:"ky_KY";s:2:"ky";s:2:"la";s:2:"la";s:2:"li";s:2:"li";s:2:"lo";s:2:"lo";s:2:"lt";s:2:"lt";s:2:"lv";s:2:"lv";s:5:"me_ME";s:2:"me";s:5:"mg_MG";s:2:"mg";s:5:"mk_MK";s:2:"mk";s:5:"ml_IN";s:2:"ml";s:2:"mn";s:2:"mn";s:2:"mr";s:2:"mr";s:5:"ms_MY";s:2:"ms";s:5:"my_MM";s:3:"mya";s:5:"nb_NO";s:2:"nb";s:5:"ne_NP";s:2:"ne";s:2:"nl";s:2:"nl";s:5:"nl_BE";s:2:"nl";s:5:"nl_NL";s:2:"nl";s:5:"nn_NO";s:2:"nn";s:2:"os";s:2:"os";s:5:"pa_IN";s:2:"pa";s:5:"pl_PL";s:2:"pl";s:5:"pt_BR";s:5:"pt-br";s:5:"pt_PT";s:2:"pt";s:5:"ro_RO";s:2:"ro";s:5:"ru_RU";s:2:"ru";s:5:"ru_UA";s:5:"ru-ua";s:5:"sa_IN";s:5:"sa-in";s:5:"si_LK";s:2:"si";s:5:"sk_SK";s:2:"sk";s:5:"sl_SI";s:2:"sl";s:5:"so_SO";s:2:"so";s:2:"sq";s:2:"sq";s:5:"sr_RS";s:2:"sr";s:3:"srd";s:3:"srd";s:5:"su_ID";s:2:"su";s:5:"sv_SE";s:2:"sv";s:2:"sw";s:2:"sw";s:5:"ta_IN";s:2:"ta";s:5:"ta_LK";s:5:"ta-lk";s:2:"te";s:2:"te";s:2:"tg";s:2:"tg";s:2:"th";s:2:"th";s:2:"tl";s:2:"tl";s:2:"tr";s:2:"tr";s:5:"ug_CN";s:2:"ug";s:2:"uk";s:2:"uk";s:2:"ur";s:2:"ur";s:5:"uz_UZ";s:2:"uz";s:2:"vi";s:2:"vi";s:5:"zh_CN";s:5:"zh-cn";s:5:"zh_TW";s:5:"zh-tw";}', 'yes'); 
INSERT INTO `wp_options` VALUES (3862, '_transient_bcf2fa3436c5f2d7224a1e9100b2d7f0', 'fr', 'yes'); 
INSERT INTO `wp_options` VALUES (5678, '_transient_timeout_feed_2af8eb95e685b52eda9667d663cafadb', '1432169456', 'no'); 
INSERT INTO `wp_options` VALUES (3827, '_transient_90ab5827af4164115fe869d777800bc0', 'fr', 'yes'); 
INSERT INTO `wp_options` VALUES (5680, '_transient_timeout_feed_mod_2af8eb95e685b52eda9667d663cafadb', '1432169456', 'no'); 
INSERT INTO `wp_options` VALUES (5681, '_transient_feed_mod_2af8eb95e685b52eda9667d663cafadb', '1432126256', 'no'); 
INSERT INTO `wp_options` VALUES (5679, '_transient_feed_2af8eb95e685b52eda9667d663cafadb', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:49:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:4:"WPML";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:17:"https://wpml.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:52:"The Plugin for Building Multilingual WordPress Sites";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 20 May 2015 12:24:58 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:29:"http://wordpress.org/?v=4.2.2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"This week compatible – Chillout, Okean, Spider, rtMedia Instagram";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/K5N3G9oAlhM/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:95:"https://wpml.org/2015/05/this-week-compatible-chillout-okean-spider-rtmedia-instagram/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 15 May 2015 20:25:22 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=619886";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:316:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Chillout, Okean, Spider, and the plugin is rtMedia Instagram If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5202:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Chillout" href="http://themeforest.net/item/chillout-parallax-onepage-wordpress-theme-/9825415">Chillout</a>, <a title="Okean" href="http://themeforest.net/item/okean-multipurpose-minimal-multiscroll-blogportfolio-theme/10131493">Okean</a>, <a title="Spider" href="http://themeforest.net/item/spider-flat-creative-portfolio-wordpress-theme/8923142">Spider</a>, and the plugin is <a title="rtMedia Instagram" href="https://rtcamp.com/products/rtmedia-instagram/">rtMedia Instagram</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">Chillout theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/chillout-parallax-onepage-wordpress-theme-/9825415"><img class="aligncenter size-full wp-image-340493"  src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/chillout.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Chillout is a WordPress Theme for everyone who likes minimalism and clarity. It will perfectly work out as a private and corporate website but also as a portfolio.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/chillout-parallax-onepage-wordpress-theme-/9825415" target="_blank">Purchase Chillout theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Okean theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/okean-multipurpose-minimal-multiscroll-blogportfolio-theme/10131493"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/okean.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Okean is a HTML5/CSS3/Bootstrap optimized Parallax powered, responsive theme perfect for multi-purpose blog themes. It’s also perfect for Minimal Portfolio. WPML is also supported by default.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/okean-multipurpose-minimal-multiscroll-blogportfolio-theme/10131493">Purchase Okean theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Spider theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/spider-flat-creative-portfolio-wordpress-theme/8923142"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/spider.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Flat, creative portfolio WordPress Theme for agency business or creative people.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/spider-flat-creative-portfolio-wordpress-theme/8923142">Purchase Spider theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">rtMedia Instagram plugin</h2>\n<p style="text-align: center;"><a href="https://rtcamp.com/products/rtmedia-instagram/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/rtinstagram.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>rtMedia Instagram adds Instagram like effects to rtMedia.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://rtcamp.com/products/rtmedia-instagram/">Purchase rtMedia Instagram plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=K5N3G9oAlhM:FICjgjOSCWE:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=K5N3G9oAlhM:FICjgjOSCWE:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=K5N3G9oAlhM:FICjgjOSCWE:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=K5N3G9oAlhM:FICjgjOSCWE:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=K5N3G9oAlhM:FICjgjOSCWE:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=K5N3G9oAlhM:FICjgjOSCWE:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/K5N3G9oAlhM" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:91:"https://wpml.org/2015/05/this-week-compatible-chillout-okean-spider-rtmedia-instagram/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:86:"https://wpml.org/2015/05/this-week-compatible-chillout-okean-spider-rtmedia-instagram/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"This week compatible – HG Restaurant, Reviver, Slider Image";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/yM3XdieylkY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:90:"https://wpml.org/2015/05/this-week-compatible-hg-restaurant-reviver-slider-image/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 08 May 2015 14:30:10 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=615132";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:310:"Today we are happy to announce that we have 2 themes and 1 plugin to add to our compatibility list. The themes are HG Restaurant, Reviver, and the plugin is Slider Image If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4429:"<p>Today we are happy to announce that we have 2 themes and 1 plugin to add to our compatibility list. The themes are <a title="HG Restaurant" href="http://themeforest.net/item/hg-restaurant-responsive-wordpress-theme/9910041">HG Restaurant</a>, <a title="Reviver" href="http://themeforest.net/item/reviver-multipurpose-responsive-wordpress-theme/10257595">Reviver</a>, and the plugin is <a title="Slider Image" href="https://wordpress.org/plugins/slider-image/">Slider Image</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">HG Restaurant theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/hg-restaurant-responsive-wordpress-theme/9910041"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/HG.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p> HG Restaurant is an attractive and easy-to-use responsive WordPress theme created especially for restaurants, bakeries, bars and coffee shops.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/hg-restaurant-responsive-wordpress-theme/9910041" target="_blank">Purchase HG Restaurant theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Reviver theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/reviver-multipurpose-responsive-wordpress-theme/10257595"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/reviver.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Reviver is a premium responsive multipurpose VirtueMart theme which perfectly fits for any e-commerce website.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/reviver-multipurpose-responsive-wordpress-theme/10257595">Purchase Reviver theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Slider Image plugin</h2>\n<p style="text-align: center;"><a href="https://wordpress.org/plugins/slider-image/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/slider.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Huge-IT Slider is a quick and easy way to add custom sliders to the WordPress websites (both to templates and posts/pages). The slider allows having unlimited amount of images with their titles and descriptions.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/slider-image/">Download Slider Image plugin</a>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=yM3XdieylkY:P5UsaYrybGU:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=yM3XdieylkY:P5UsaYrybGU:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=yM3XdieylkY:P5UsaYrybGU:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=yM3XdieylkY:P5UsaYrybGU:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=yM3XdieylkY:P5UsaYrybGU:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=yM3XdieylkY:P5UsaYrybGU:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/yM3XdieylkY" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:86:"https://wpml.org/2015/05/this-week-compatible-hg-restaurant-reviver-slider-image/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:81:"https://wpml.org/2015/05/this-week-compatible-hg-restaurant-reviver-slider-image/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:26:"WPML 3.2 Release Candidate";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/3fDubQ-YRKQ/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:61:"https://wpml.org/2015/05/wpml-3-2-release-candidate/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 06 May 2015 06:50:23 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"WPML versions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=612335";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:349:"We&#8217;re ready with a Release Candidate for WPML 3.2. An RC, besides sounding nice, also means that we&#8217;re almost ready to push this update to everyone. In fact, we&#8217;re moving to WPML 3.2 on some of our own sites. Since previous betas, the content of WPML 3.2 hasn&#8217;t changed. In this update, we&#8217;ve further improved [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5334:"<p><strong>We&#8217;re ready with a Release Candidate for WPML 3.2. An RC, besides sounding nice, also means that we&#8217;re almost ready to push this update to everyone. In fact, we&#8217;re moving to WPML 3.2 on some of our own sites.</strong></p>\n<p>Since <a href="https://wpml.org/2015/02/wpml-3-2-first-beta/">previous betas</a>, the content of WPML 3.2 hasn&#8217;t changed.</p>\n<p>In this update, we&#8217;ve further improved performance, closed remaining issues and updated taxonomy translation and String scanning.</p>\n<h2>Taxonomy Translation News</h2>\n<p>WPML 3.2 adds a new admin screen (tab under the Taxonomy Translation) to synchronize the hierarchies of taxonomies. Previously, this task was done automatically, as you translate. The problem is, it was hard to control what it does and what you get.</p>\n<p>The new taxonomy hierarchy sync lets you set the same hierarchies for taxonomy for all languages. It works by:</p>\n<ol>\n<li>Selecting the language to use as reference (previously, this was assumed to be the site&#8217;s default language)</li>\n<li>Seeing what changes will happen to the taxonomy trees in all translated languages</li>\n<li>Applying these changes</li>\n</ol>\n<p>We separated this from the normal &#8216;content translation&#8217; workflow to (greatly) improve performance, accuracy and control. Most sites that use complex taxonomy hierarchies will usually edit the taxonomy tree a lot less than editing posts. From our experience, the taxonomy tree is a lot like the site&#8217;s menu. You update it once in a while.</p>\n<div id="attachment_612578" style="width: 310px" class="wp-caption alignnone"><a href="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/taxonomy-translation-1.png"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/taxonomy-translation-1-300x130.png" alt="Taxonomy hierarchy sync in WPML 3.2" width="300" height="130" class="size-medium wp-image-612578" /></a><p class="wp-caption-text">Taxonomy hierarchy sync in WPML 3.2</p></div>\n<p>The new taxonomy sync reads the entire tree and adjusts all languages together. It&#8217;s way more accurate than what we ran in previous WPML versions. To avoid this from running on every translation job, we allow you to run it only when you want. This helps reduce load and puts you in control over the taxonomy of your site.</p>\n<h2>Improved String Scanning in Plugins and Themes</h2>\n<p>WPML 3.2 greatly improves the accuracy of scanning plugins and themes for translatable strings. Now, we also register strings under a slightly different context. No fear, when you upgrade, WPML will check if you have strings with the &#8216;old&#8217; contexts. If so, you will see a message about how to update. The update process will move strings to the new context, make sure that all strings in the code are available for translation and also clean up &#8216;phantom&#8217; strings (untranslated strings, no longer in use).</p>\n<h2>Yes, Better Performance</h2>\n<p>During this entire development cycle, we test WPML&#8217;s load on your server together with every change we make. Our goal is to cut any fat that we see and make sure that both CPU load and DB queries go down.</p>\n<p>This release candidate is no exception. We managed to find pockets of queries which could be eliminated. As a result, our testing shows superior performance over production and previous WPML 3.2 dev versions. Instead of boasting with numbers, we leave this to you to evaluate.</p>\n<h2>Other Changes in This Update</h2>\n<ul>\n<li>Fixed compatibility issues with Windows servers</li>\n<li>Fixed email notifications</li>\n<li>Fixed issues with WPSEO sitemaps when using languages in domain</li>\n<li>Updated localized strings translations</li>\n<li>Several other bug fixes</li>\n<li>Improved API and its documentation</li>\n<li>Improved compatibility with Gravity forms</li>\n</ul>\n<h2>Download</h2>\n<p>This version of WPML is only available from your <a href="https://wpml.org/account/">WPML account</a>. Log in and click on Downloads. Download the CMS Beta package and unzip it. This ZIP contains ZIP files of all of WPML&#8217;s components.</p>\n<p>WPML 3.2 has already completed a round of QA. Now, after all recent changes, we&#8217;re starting another full QA cycle. We expect to release the final version in two weeks from now.</p>\n<h2>Feedback?</h2>\n<p>We&#8217;d love to hear your opinion. For questions, suggestions and ideas, leave your comments here. To report technical problems (and get help from our supporters), please use our <a href="https://wpml.org/forums/forum/english-support/">technical support forum</a>.</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=3fDubQ-YRKQ:ObbA4Q4doNY:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=3fDubQ-YRKQ:ObbA4Q4doNY:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=3fDubQ-YRKQ:ObbA4Q4doNY:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=3fDubQ-YRKQ:ObbA4Q4doNY:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=3fDubQ-YRKQ:ObbA4Q4doNY:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=3fDubQ-YRKQ:ObbA4Q4doNY:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/3fDubQ-YRKQ" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:57:"https://wpml.org/2015/05/wpml-3-2-release-candidate/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wpml.org/2015/05/wpml-3-2-release-candidate/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"This week compatible – MH Magazine, LSX, Loma, Nice Hotel";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/17r2Og6jT7A/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:87:"https://wpml.org/2015/05/this-week-compatible-mh-magazine-lsx-loma-nice-hotel/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 01 May 2015 18:07:24 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=610415";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:320:"Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are MH Magazine, LSX, Loma, Nice Hotel If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready Themes Multilingual Ready Plugins Also, if [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4703:"<p>Today we are happy to announce that we have 4 themes to add to our compatibility list. The themes are <a title="MH Magazine" href="http://www.mhthemes.com/">MH Magazine</a>, <a title="LSX" href="https://www.lsdev.biz/portfolio/lsx/">LSX</a>, <a title="Loma" href="http://themeforest.net/item/loma-the-ultimate-wp-blog-theme/9930474">Loma</a>, <a title="Nice Hotel" href="http://themeforest.net/item/nice-hotel-wordpress-theme/2661854">Nice Hotel</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">MH Magazine theme</h2>\n<p style="text-align: center;"><a href="http://www.mhthemes.com/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/mh.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Theme for online magazines, dynamic news websites and other editorial related projects.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.mhthemes.com/" target="_blank">Purchase MH Magazine theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">LSX theme</h2>\n<p style="text-align: center;"><a href="https://www.lsdev.biz/portfolio/lsx/"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/lsx.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>LSX is a clean, modern, minimal and fully responsive parent theme. This theme is ideal for developers looking for a Bootstrap parent theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://www.lsdev.biz/portfolio/lsx/">Download LSX theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Loma theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/loma-the-ultimate-wp-blog-theme/9930474"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/loma.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Loma is a responsive WordPress blog theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/loma-the-ultimate-wp-blog-theme/9930474">Purchase Loma theme</a>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Nice Hotel theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/nice-hotel-wordpress-theme/2661854"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/05/nh.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Nice hotel is a WordPress theme designed for hotels, hostels, resorts, spas and any other type of service which requires a booking type system.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/nice-hotel-wordpress-theme/2661854">Purchase Nice Hotel theme</a></p>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=17r2Og6jT7A:Ft8g0qXcBzA:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=17r2Og6jT7A:Ft8g0qXcBzA:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=17r2Og6jT7A:Ft8g0qXcBzA:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=17r2Og6jT7A:Ft8g0qXcBzA:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=17r2Og6jT7A:Ft8g0qXcBzA:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=17r2Og6jT7A:Ft8g0qXcBzA:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/17r2Og6jT7A" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:83:"https://wpml.org/2015/05/this-week-compatible-mh-magazine-lsx-loma-nice-hotel/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:78:"https://wpml.org/2015/05/this-week-compatible-mh-magazine-lsx-loma-nice-hotel/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"WPML representative speaking at WordPress MeetUp Cadiz, Spain";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/EkaDSwWzfic/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:95:"https://wpml.org/2015/04/wpml-representative-speaking-at-wordpress-meetup-cadiz-spain/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 29 Apr 2015 10:02:26 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=608606";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:341:"This Thursday, April 30, Amit Kvint, from the WPML compatibility team  will lead a WooCoomerce and Multilingual related session at the WordPress MeetUp in Cadiz, Spain. If you live nearby join the MeetUp to listen and watch a live demo. If you don’t plan to attend, stay with us to find out why “Multilingual online stores” [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1954:"<div id="attachment_608634" style="width: 270px" class="wp-caption alignright"><img class="wp-image-608634 size-medium" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/profile_oct14-260x300.jpg" alt="Amit Kvint" width="260" height="300" /><p class="wp-caption-text">Amit Kvint</p></div>\n<p>This Thursday, April 30, Amit Kvint, from the WPML compatibility team  will lead a WooCoomerce and Multilingual related session at the <a title="MeetUp Cadiz " href="http://www.meetup.com/Cadiz-WordPress-Meetup/events/220947378/" target="_blank">WordPress MeetUp in Cadiz</a>, Spain.</p>\n<p>If you live nearby join the MeetUp to listen and watch a live demo. If you don’t plan to attend, stay with us to find out why “Multilingual online stores” is a hot topic these days.</p>\n<p>Este Jueves, 30 de Abril, Amit Kvint del equipo de compatibilidad de WPML va a dar una charla sobre WooCommerce Multilingual en el <a title="MeetUp Cadiz" href="http://www.meetup.com/Cadiz-WordPress-Meetup/events/220947378/" target="_blank">WordPress MeetUp de la provincia de Cadiz</a>.</p>\n<p>Si estás cerca ven, participa y verás la demostración. Puedes seguir aquí las novedades acerca de cómo crear tiendas usando WooCommerce Multilingual</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=EkaDSwWzfic:27JS8KAp6-8:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=EkaDSwWzfic:27JS8KAp6-8:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=EkaDSwWzfic:27JS8KAp6-8:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=EkaDSwWzfic:27JS8KAp6-8:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=EkaDSwWzfic:27JS8KAp6-8:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=EkaDSwWzfic:27JS8KAp6-8:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/EkaDSwWzfic" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:91:"https://wpml.org/2015/04/wpml-representative-speaking-at-wordpress-meetup-cadiz-spain/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:86:"https://wpml.org/2015/04/wpml-representative-speaking-at-wordpress-meetup-cadiz-spain/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:73:"This week compatible – Everything, Cube, Foodie Pro, Business Directory";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/UtbPM28clKo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:101:"https://wpml.org/2015/04/this-week-compatible-everything-cube-foodie-pro-business-directory/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 24 Apr 2015 22:05:52 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=606032";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:316:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Everything, Cube, Foodie Pro, and the plugin is Business Directory If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5146:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Everything" href="http://themeforest.net/item/everything-responsive-wordpress-theme/8661152">Everything</a>, <a title="Cube" href="http://themeforest.net/item/cube-multipurpose-simple-reviews-wordpress-magazine/7534092">Cube</a>, <a title="Foodie Pro" href="http://shaybocks.com/foodie/">Foodie Pro</a>, and the plugin is <a title="Business Directory" href="https://wordpress.org/plugins/business-directory-plugin/">Business Directory</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center;">Everything theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/everything-responsive-wordpress-theme/8661152"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/everything.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Multipurpose responsive theme suitable for a variety of site types: creative portfolio, big corporate site, personal blog, product-oriented site, video &amp; photo album.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/everything-responsive-wordpress-theme/8661152" target="_blank">Purchase Everything theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Cube theme</h2>\n<p style="text-align: center;"><a href="http://themeforest.net/item/cube-multipurpose-simple-reviews-wordpress-magazine/7534092"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/cube.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Cube is an extremely easy to use Responsive Grid Multipurpose Magazine WordPress Theme, it adapts to any device(try resizing your browser), designed to present your news in a cool, minimal and creative way.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/cube-multipurpose-simple-reviews-wordpress-magazine/7534092">Purchase Cube theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Foodie Pro theme</h2>\n<p style="text-align: center;"><a href="http://shaybocks.com/foodie/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/foodie.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Foodie Pro is simple and elegant food blogging theme.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://shaybocks.com/foodie/">Purchase Foodie Pro theme</a></p>\n</div>\n<div class="feature">\n<h2 style="text-align: center;">Business Directory plugin</h2>\n<p style="text-align: center;"><a href="https://wordpress.org/plugins/business-directory-plugin/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/bd.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Adds the ability to put a directory listings on a WordPress site. Adds similar functionality as Yelp, Yellow Pages, or a provider listing directory.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/business-directory-plugin/">Download Business Directory plugin</a></p>\n</div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=UtbPM28clKo:DOFCrPfjThA:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=UtbPM28clKo:DOFCrPfjThA:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=UtbPM28clKo:DOFCrPfjThA:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=UtbPM28clKo:DOFCrPfjThA:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=UtbPM28clKo:DOFCrPfjThA:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=UtbPM28clKo:DOFCrPfjThA:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/UtbPM28clKo" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:97:"https://wpml.org/2015/04/this-week-compatible-everything-cube-foodie-pro-business-directory/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:92:"https://wpml.org/2015/04/this-week-compatible-everything-cube-foodie-pro-business-directory/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"WPML representative speaking at WordCamp Barcelona, Spain";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/9NnK86yFxg4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:91:"https://wpml.org/2015/04/wpml-representative-speaking-at-wordcamp-barcelona-spain/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 24 Apr 2015 07:15:50 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=605277";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:331:"This Saturday, April 25, a WPML representative will lead a WooCoomerce and Multilingual related session at WordCamp Barcelona in Spain. If you live nearby join WordCamp to listen and watch a live demo. If you don’t plan to attend, stay with us to find out why “Multilingual online stores” is a hot topic these days. [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Agnes Bury";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4903:"<p><strong>This Saturday, April 25, a WPML representative will lead a WooCoomerce and Multilingual related session at <a href="http://barcelona.wordcamp.org/2015/" target="_blank">WordCamp Barcelona </a>in Spain. </strong></p>\n<p>If you live nearby join WordCamp to listen and watch a live demo. If you don’t plan to attend, stay with us to find out why “Multilingual online stores” is a hot topic these days.</p>\n<h2>About Bernat Torras</h2>\n<div id="attachment_290850" style="width: 240px" class="wp-caption alignleft"><img class="size-medium wp-image-290850" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2013/11/BernatTorras_1-230x300.jpg" alt="Bernat Torras" width="230" height="300" /><p class="wp-caption-text">Bernat Torras</p></div>\n<p><strong>Bernat Torras</strong> is currently working in the Quality Assurance Team testing WPML. In the past, he was involved in WooCommerce Multilingual plugin development and also worked as a WPML supporter.</p>\n<p class="clearfix">Living in Catalonia, 45 minutes from Barcelona, he took the opportunity to apply as a speaker at the first WordCamp in this beautiful city. He was accepted and this Saturday is looking forward to impressing local WordPress fans with a short talk combined with a live demo!</p>\n<h2>About the session</h2>\n<p>Bernat&#8217;s session is entitled<strong> “Start selling globally! Building a multilingual e-commerce site.”</strong> It will be part of the <a href="http://barcelona.wordcamp.org/2015/programa/" target="_blank">event agenda</a> for Track A, on Saturday afternoon, at 4:30pm.</p>\n<div id="attachment_605292" style="width: 710px" class="wp-caption aligncenter"><img class="size-full wp-image-605292" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/bernats-slides-woocommerce-multilingual.jpg" alt="A cover slide coming from Bernat’s presentation" width="700" height="523" /><p class="wp-caption-text">A cover slide coming from Bernat’s presentation</p></div>\n<p>Bernat will start with a short theoretical part and will answer these two questions:</p>\n<ul>\n<li>Is WordPress good enough for e-commerce sites? (yep, we know there are other solutions as Magento, Prestashop, etc)</li>\n<li>Is it worthwhile to make your store multilingual?</li>\n</ul>\n<p><strong>Then he will run a demo.</strong> He has prepared a sample shop in his localhost running WooCommerce with some products.</p>\n<p>Bernat will demonstrate:</p>\n<ul>\n<li>how to setup WPML with a few languages,</li>\n<li>how to use the free WooCommerce Multilingual plugin to setup currencies (with formatting, and rounding options),</li>\n<li>how to translate products together with categories, attributes and custom fields,</li>\n<li>how the WooCommerce Multilingual plugin works with other third-parties plugins.</li>\n</ul>\n<h2>Why WooCommerce Multilingual related session are needed</h2>\n<p>Asked why sessions like this one are important to share during WordCamp events, Bernat explains:</p>\n<blockquote><p>“Here, in Barcelona, Spain, we live in a pretty multicultural and multilingual society. That’s why it is so important to make our websites and e-commerce stores multilingual as well.</p>\n<p>Anybody can expand their business globally by simply adding additional languages to their site. In my session I’ll help entrepreneurs, developers and site owners get a better idea of what is required providing best tools and live examples to achieve top results.”</p></blockquote>\n<h2>Who else is attending WordCamp Barcelona</h2>\n<div id="attachment_531703" style="width: 150px" class="wp-caption alignleft"><img class="size-full wp-image-531703" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2014/12/Yvette_page-wpcf_140x138.jpg" alt="Yvette Oliveau" width="140" height="138" /><p class="wp-caption-text">Yvette Oliveau</p></div>\n<p><strong>Yvette Oliveau</strong>, our excellent WPML Supporter, is also attending the event. Take this unique opportunity to get answers for all your WordPress and Multilingual related questions. Yvette together with Bernat will he happy to answer all your doubts. </p>\n<p><strong>See you on Saturday, in Barcelona!</strong></p>\n<div class="clearfix"></div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=9NnK86yFxg4:WpCu1dUahIg:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=9NnK86yFxg4:WpCu1dUahIg:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=9NnK86yFxg4:WpCu1dUahIg:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=9NnK86yFxg4:WpCu1dUahIg:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=9NnK86yFxg4:WpCu1dUahIg:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=9NnK86yFxg4:WpCu1dUahIg:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/9NnK86yFxg4" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:87:"https://wpml.org/2015/04/wpml-representative-speaking-at-wordcamp-barcelona-spain/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:82:"https://wpml.org/2015/04/wpml-representative-speaking-at-wordcamp-barcelona-spain/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"WooCommerce Multilingual 3.6";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/EzEfFoSv0cw/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wpml.org/2015/04/woocommerce-multilingual-3-6/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 22 Apr 2015 16:16:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"WPML versions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=604204";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:354:"WooCommerce Multilingual 3.6 packs some nice new features and it is also faster. We added new product options that reflect multiple currencies and the plugin is up to 40% faster, especially on large sites. Translating product slugs WordPress automatically uses the title to generate the slugs for the translated products by default. You can now [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Mihai";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5646:"<p><strong>WooCommerce Multilingual 3.6 packs some nice new features and it is also faster. We added new product options that reflect multiple currencies and the plugin is up to 40% faster, especially on large sites.</strong></p>\n<h2>Translating product slugs</h2>\n<p>WordPress automatically uses the title to generate the slugs for the translated products by default. You can now enter custom values for slugs under the product title, after saving a translation.</p>\n<div id="attachment_604209" style="width: 710px" class="wp-caption aligncenter"><a href="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/image001.png"><img class="wp-image-604209" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/image001-1024x559.png" alt="image00" width="700" height="382" /></a><p class="wp-caption-text">Adding custom slugs for product translations</p></div>\n<h2>Show only products with custom prices for each currency</h2>\n<p>In WooCommerce Multilingual, you can set prices for your products in two ways: by using the exchange rate or by manually entering prices in the secondary currencies on the product editor page.</p>\n<p>In version 3.6 of WooCommerce Multilingual we added a new option that allows you to configure your shop such that switching to any secondary currency will only display the products for which the custom price is set in that currency.</p>\n<div id="attachment_604210" style="width: 710px" class="wp-caption aligncenter"><a href="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/image011.png"><img class=" wp-image-604210" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/image011-1024x679.png" alt="Option to show only products with custom prices" width="700" height="464" /></a><p class="wp-caption-text">Option to show only products with custom prices</p></div>\n<p>Essentially, this option allows you to sell the products only in the currency in which they were meant to be sold and avoid prices being determined automatically using the exchange rate.</p>\n<h2>Performance boost</h2>\n<p>We worked hard to reduce the number of queries needed, made them faster, added caching and also improved the code to optimize everything in terms of load time. The results: <strong>page load times are up to 40% faster</strong>. This is a big improvement especially for large sites with a large number of products displaying on a single page.</p>\n<h2>Support for the language parameter of the WooCommerce REST API</h2>\n<p>To ensure that products in a specific language use the <code>get_products()</code> API call, you can now set the parameter lang as the value of the language by which the products should be filtered.</p>\n<h2>Option to hide the default currency selector on the products page</h2>\n<p>There are different ways in which you can add a currency selector to a product page as described on the <a href="https://wpml.org/documentation/related-projects/woocommerce-multilingual/multi-currency-support-woocommerce/">main documentation page</a>. WooCommerce Multilingual shows a currency selector on the product page by default, under the ‘Add to cart’ button on the default theme.<br />\nAs of version 3.6 it is possible to hide this selector and add a different one (e.g., as a widget) somewhere else on the page..</p>\n<div id="attachment_604211" style="width: 687px" class="wp-caption aligncenter"><a href="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/image021.png"><img class="wp-image-604211 size-full" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/image021.png" alt="image02" width="677" height="489" /></a><p class="wp-caption-text">Hide the default currency swithcer</p></div>\n<h2>Bugs fixed</h2>\n<ul>\n<li>Fixed a design issue on the &#8216;connect with translation&#8217; pop-up on products.</li>\n<li>Accessing the source content in the WooCommerce Multilingual product translation content editor was sometimes not possible.</li>\n<li>‘Invisible’ products were showing as links in the cart instead of just showing as names.</li>\n<li>The cart_widget.js code was always loaded.</li>\n<li>Screen Options &amp; Check All not working on WooCommerce Orders page</li>\n<li>Sometimes the IPN Url sent to Paypal was wrong causing a 404 error after the payment was complete</li>\n<li>Translated endpoint pages were sometimes returning 404 errors.</li>\n<li>When using a default language different than English, the product permalink base was not in English.</li>\n</ul>\n<h2>Download or upgrade</h2>\n<p>You can get <a href="https://downloads.wordpress.org/plugin/woocommerce-multilingual.3.6.zip">WooCommerce Multilingual 3.6</a> from the WordPress plugins directory. We would love to hear your feedback on this release and we’re also looking forward to addressing any questions or problems you may have on our <a href="http://wpml.org/forums/topic-tag/woocommerce/">support forum</a>.</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=EzEfFoSv0cw:Ph-NevdBtwE:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=EzEfFoSv0cw:Ph-NevdBtwE:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=EzEfFoSv0cw:Ph-NevdBtwE:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=EzEfFoSv0cw:Ph-NevdBtwE:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=EzEfFoSv0cw:Ph-NevdBtwE:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=EzEfFoSv0cw:Ph-NevdBtwE:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/EzEfFoSv0cw" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wpml.org/2015/04/woocommerce-multilingual-3-6/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:54:"https://wpml.org/2015/04/woocommerce-multilingual-3-6/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:93:"WooCommerce compatibility – One Page Checkout, Tab Manager, EU Vat Number, YITH Ajax Search";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/YQRgYvAuflg/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:145:"https://wpml.org/2015/04/woocommerce-compatibility-one-page-checkout-woocommerce-tab-manager-eu-vat-number-yith-woocommerce-ajax-search/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 17 Apr 2015 16:41:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=601620";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:338:"WooCommerce Multilingual is a very important project for us, today we are happy to announce that we have 3 WooCommerce extensions and 1 WooCommerce plugin to add to our compatibility list. The extensions are One Page Checkout, WooCommerce Tab Manager, EU Vat Number, and the plugin is YITH WooCommerce Ajax Search If you want to [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4614:"<p><a href="https://wordpress.org/plugins/woocommerce-multilingual/" title="WooCommerce Multilingual" target="_blank">WooCommerce Multilingual</a> is a very important project for us, today we are happy to announce that we have 3 WooCommerce extensions and 1 WooCommerce plugin to add to our compatibility list. </p>\n<p>The extensions are <a title="One Page Checkout" href="http://www.woothemes.com/products/woocommerce-one-page-checkout/">One Page Checkout</a>, <a title="Tab Manager" href="http://www.woothemes.com/products/woocommerce-tab-manager/">WooCommerce Tab Manager</a>, <a title="EU Vat Number" href="http://www.woothemes.com/products/eu-vat-number/">EU Vat Number</a>, and the plugin is <a title="WooCommerce Ajax search" href="https://wordpress.org/plugins/yith-woocommerce-ajax-search/">YITH WooCommerce Ajax Search</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">One Page Checkout Extension</h2>\n<p style="text-align: center"><a href="http://www.woothemes.com/products/woocommerce-one-page-checkout/"></a></p>\n<blockquote><p>Make it super fast for customers to purchase with your store. Create special pages where customers can choose products, checkout &#038; pay all on the one page!</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.woothemes.com/products/woocommerce-one-page-checkout/" target="_blank">Purchase One Page Checkout</a></div>\n<div class="feature">\n<h2 style="text-align: center">Tab Manager</h2>\n<p style="text-align: center"><a href="http://www.woothemes.com/products/woocommerce-tab-manager/" ></a></p>\n<blockquote><p>Gives you complete control over your product page tabs, create local and global tabs using a visual drag-and-drop interface, and more.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.woothemes.com/products/woocommerce-tab-manager/">Purchase Tab Manager</a></div>\n<div class="feature">\n<h2 style="text-align: center">EU Vat Number</h2>\n<p style="text-align: center"><a href="http://www.woothemes.com/products/eu-vat-number/"></a></p>\n<blockquote><p>Collect VAT numbers at checkout and remove the VAT charge for eligible EU businesses.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.woothemes.com/products/eu-vat-number/">Purchase EU Vat Number</a></div>\n<div class="feature">\n<h2 style="text-align: center">YITH WooCommerce Ajax Search</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/yith-woocommerce-ajax-search/"></a></p>\n<blockquote><p>YITH WooCommerce Ajax Search allows your users to search products in real time.</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/yith-woocommerce-ajax-search/">Download YITH WooCommerce Ajax Search</a></div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=YQRgYvAuflg:yvwhP2DHm1Y:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=YQRgYvAuflg:yvwhP2DHm1Y:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=YQRgYvAuflg:yvwhP2DHm1Y:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=YQRgYvAuflg:yvwhP2DHm1Y:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=YQRgYvAuflg:yvwhP2DHm1Y:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=YQRgYvAuflg:yvwhP2DHm1Y:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/YQRgYvAuflg" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:141:"https://wpml.org/2015/04/woocommerce-compatibility-one-page-checkout-woocommerce-tab-manager-eu-vat-number-yith-woocommerce-ajax-search/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:136:"https://wpml.org/2015/04/woocommerce-compatibility-one-page-checkout-woocommerce-tab-manager-eu-vat-number-yith-woocommerce-ajax-search/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:6:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:59:"This Week Compatible – Solo, Reznor, Patti, Store Locator";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpml/~3/pH9LBCt0Pfk/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:90:"https://wpml.org/2015/04/this-week-compatible-solo-reznor-patti-wp-store-locator/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 17 Apr 2015 12:29:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:22:"Compatibility Bulletin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wpml.org/?p=601375";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:308:"Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are Solo, Reznor, Patti, and the plugin is Store Locator If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here: Multilingual Ready [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Amit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4850:"<p>Today we are happy to announce that we have 3 themes and 1 plugin to add to our compatibility list. The themes are <a title="Solo" href="http://themetrust.com/themes/solo/">Solo</a>, <a title="Reznor" href="http://www.templateexpress.com/reznor-theme/">Reznor</a>, <a title="Patti" href="http://themeforest.net/item/patti-parallax-one-page-wordpress-theme/7068682">Patti</a>, and the plugin is <a title="WP Store Locator" href="https://wordpress.org/plugins/store-locator/">Store Locator</a></p>\n<p>If you want to review the entire multilingual ready list of themes and plugins you are welcome to view it here:</p>\n<ul>\n<li><a title="Multilingual Ready Themes " href="https://wpml.org/documentation/theme-compatibility/">Multilingual Ready Themes</a></li>\n<li><a title="Multilingual Ready Plugins " href="https://wpml.org/documentation/plugins-compatibility/">Multilingual Ready Plugins</a></li>\n</ul>\n<p>Also, if you&#8217;re a theme or a plugin author and you want to make it compatible with WPML, we welcome you and ready to help: You are welcome to contact us at <a href="https://wpml.org/documentation/theme-compatibility/go-global-program/">go global program page</a>.</p>\n<p>In order to expedite the process we strongly recommend that you test your theme or plugin with our <a title="Achieving WPML compatibility for your themes and plugins" href="https://wpml.org/documentation/support/achieving-wpml-compatibility-for-your-themes-and-plugins/">Achieving WPML compatibility for your themes and plugins</a>. It easily tests compatibility with WPML and helps you quickly make your theme or plugin <strong>Multilingual Ready</strong>.</p>\n<div class="feature">\n<h2 style="text-align: center">Solo theme</h2>\n<p style="text-align: center"><a href="http://themetrust.com/themes/solo/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/solo.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A clean, single page portfolio theme with automatic scrolling and expanding project display.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themetrust.com/themes/solo/" target="_blank">Purchase Solo theme</a></div>\n<div class="feature">\n<h2 style="text-align: center">Reznor theme</h2>\n<p style="text-align: center"><a href="http://www.templateexpress.com/reznor-theme/"><img src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/reznor.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Reznor is a multi-purpose WordPress Theme with a focus on easy customization and beautiful design.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://www.templateexpress.com/reznor-theme/">Purchase Reznor theme</a></div>\n<div class="feature">\n<h2 style="text-align: center">Patti theme</h2>\n<p style="text-align: center"><a href="http://themeforest.net/item/patti-parallax-one-page-wordpress-theme/7068682"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/patti.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>Patti is a modern and elegant One-Page WordPress Theme, perfect for creative people, suitable for any type of business, built for any needs.</p></blockquote>\n<p><a class="button download-button vt-p" href="http://themeforest.net/item/patti-parallax-one-page-wordpress-theme/7068682">Purchase Patti theme</a></div>\n<div class="feature">\n<h2 style="text-align: center">WordPress Store Locator plugin</h2>\n<p style="text-align: center"><a href="https://wordpress.org/plugins/store-locator/"><img class="aligncenter size-full wp-image-340493" src="https://d2salfytceyqoe.cloudfront.net/wp-content/uploads/2015/04/storelocator.png" alt="ekho" width="590" height="300" /></a></p>\n<blockquote><p>A WordPress-integrated map &#038; location management interface. Quickly create store locator maps &#8212; provides several top-level addon features</p></blockquote>\n<p><a class="button download-button vt-p" href="https://wordpress.org/plugins/store-locator/">Download WordPress Store Locator plugin</a></div>\n<div class="feedflare">\n<a href="http://feeds.feedburner.com/~ff/wpml?a=pH9LBCt0Pfk:ZvjzIA__E4Q:D7DqB2pKExk"><img src="http://feeds.feedburner.com/~ff/wpml?i=pH9LBCt0Pfk:ZvjzIA__E4Q:D7DqB2pKExk" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=pH9LBCt0Pfk:ZvjzIA__E4Q:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/wpml?i=pH9LBCt0Pfk:ZvjzIA__E4Q:gIN9vFwOqvQ" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/wpml?a=pH9LBCt0Pfk:ZvjzIA__E4Q:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/wpml?i=pH9LBCt0Pfk:ZvjzIA__E4Q:V_sGLiPBpWU" border="0"></img></a>\n</div><img src="http://feeds.feedburner.com/~r/wpml/~4/pH9LBCt0Pfk" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:86:"https://wpml.org/2015/04/this-week-compatible-solo-reznor-patti-wp-store-locator/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:81:"https://wpml.org/2015/04/this-week-compatible-solo-reznor-patti-wp-store-locator/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:32:"http://feeds.feedburner.com/wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:3:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:4:"wpml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:14:"emailServiceId";a:1:{i:0;a:5:{s:4:"data";s:4:"wpml";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:18:"feedburnerHostname";a:1:{i:0;a:5:{s:4:"data";s:29:"https://feedburner.google.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:11:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:13:"last-modified";s:29:"Wed, 20 May 2015 12:25:58 GMT";s:4:"date";s:29:"Wed, 20 May 2015 12:50:56 GMT";s:7:"expires";s:29:"Wed, 20 May 2015 12:50:56 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:18:"alternate-protocol";s:11:"80:quic,p=0";s:13:"accept-ranges";s:4:"none";s:4:"vary";s:15:"Accept-Encoding";}s:5:"build";s:14:"20140618032821";}', 'no'); 
INSERT INTO `wp_options` VALUES (5583, '_site_transient_timeout_browser_ee6aeab93d0b8f4cbd561dcdb49cd594', '1431963767', 'yes'); 
INSERT INTO `wp_options` VALUES (5584, '_site_transient_browser_ee6aeab93d0b8f4cbd561dcdb49cd594', 'a:9:{s:8:"platform";s:4:"iPad";s:4:"name";s:4:"iPad";s:7:"version";s:3:"7.0";s:10:"update_url";s:0:"";s:7:"img_src";s:0:"";s:11:"img_src_ssl";s:0:"";s:15:"current_version";s:0:"";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6640, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:6:{i:0;O:8:"stdClass":10:{s:8:"response";s:7:"upgrade";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.2.2";s:7:"version";s:5:"4.2.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:1;O:8:"stdClass":10:{s:8:"response";s:7:"upgrade";s:8:"download";s:59:"https://downloads.wordpress.org/release/wordpress-4.2.2.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:59:"https://downloads.wordpress.org/release/wordpress-4.2.2.zip";s:10:"no_content";s:70:"https://downloads.wordpress.org/release/wordpress-4.2.2-no-content.zip";s:11:"new_bundled";s:71:"https://downloads.wordpress.org/release/wordpress-4.2.2-new-bundled.zip";s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.2.2";s:7:"version";s:5:"4.2.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:2;O:8:"stdClass":11:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.2.2.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.2.2";s:7:"version";s:5:"4.2.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";s:12:"notify_email";s:1:"1";}i:3;O:8:"stdClass":10:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.5.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.5.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.1.5";s:7:"version";s:5:"4.1.5";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:4;O:8:"stdClass":10:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.0.5.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.0.5.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.0.5";s:7:"version";s:5:"4.0.5";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}i:5;O:8:"stdClass":10:{s:8:"response";s:10:"autoupdate";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-3.9.6.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-3.9.6.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"3.9.6";s:7:"version";s:5:"3.9.6";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.1";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1435007225;s:15:"version_checked";s:5:"3.9.1";s:12:"translations";a:0:{}}', 'yes'); 
INSERT INTO `wp_options` VALUES (6641, '_site_transient_update_themes', 'O:8:"stdClass":4:{s:12:"last_checked";i:1435007235;s:7:"checked";a:5:{s:13:"fruitdudragon";s:3:"1.0";s:4:"katz";s:5:"1.0.0";s:14:"twentyfourteen";s:3:"1.1";s:14:"twentythirteen";s:3:"1.2";s:12:"twentytwelve";s:3:"1.4";}s:8:"response";a:3:{s:14:"twentyfourteen";a:4:{s:5:"theme";s:14:"twentyfourteen";s:11:"new_version";s:3:"1.4";s:3:"url";s:44:"https://wordpress.org/themes/twentyfourteen/";s:7:"package";s:60:"https://downloads.wordpress.org/theme/twentyfourteen.1.4.zip";}s:14:"twentythirteen";a:4:{s:5:"theme";s:14:"twentythirteen";s:11:"new_version";s:3:"1.5";s:3:"url";s:44:"https://wordpress.org/themes/twentythirteen/";s:7:"package";s:60:"https://downloads.wordpress.org/theme/twentythirteen.1.5.zip";}s:12:"twentytwelve";a:4:{s:5:"theme";s:12:"twentytwelve";s:11:"new_version";s:3:"1.7";s:3:"url";s:42:"https://wordpress.org/themes/twentytwelve/";s:7:"package";s:58:"https://downloads.wordpress.org/theme/twentytwelve.1.7.zip";}}s:12:"translations";a:1:{i:0;a:7:{s:4:"type";s:5:"theme";s:4:"slug";s:14:"twentyfourteen";s:8:"language";s:5:"fr_FR";s:7:"version";s:3:"1.1";s:7:"updated";s:19:"2014-08-15 15:06:19";s:7:"package";s:78:"https://downloads.wordpress.org/translation/theme/twentyfourteen/1.1/fr_FR.zip";s:10:"autoupdate";b:1;}}}', 'yes'); 
INSERT INTO `wp_options` VALUES (4679, '_site_transient_timeout_browser_0dbc0bcfc3366ae7533a75620c6fae18', '1430219004', 'yes'); 
INSERT INTO `wp_options` VALUES (4680, '_site_transient_browser_0dbc0bcfc3366ae7533a75620c6fae18', 'a:9:{s:8:"platform";s:9:"Macintosh";s:4:"name";s:6:"Safari";s:7:"version";s:5:"8.0.4";s:10:"update_url";s:28:"http://www.apple.com/safari/";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/safari.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/safari.png";s:15:"current_version";s:1:"5";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'yes'); 
INSERT INTO `wp_options` VALUES (6642, '_site_transient_update_plugins', 'O:8:"stdClass":4:{s:12:"last_checked";i:1435007229;s:8:"response";a:7:{s:33:"admin-menu-editor/menu-editor.php";O:8:"stdClass":6:{s:2:"id";s:5:"11743";s:4:"slug";s:17:"admin-menu-editor";s:6:"plugin";s:33:"admin-menu-editor/menu-editor.php";s:11:"new_version";s:5:"1.4.4";s:3:"url";s:48:"https://wordpress.org/plugins/admin-menu-editor/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/admin-menu-editor.1.4.4.zip";}s:30:"advanced-custom-fields/acf.php";O:8:"stdClass":6:{s:2:"id";s:5:"21367";s:4:"slug";s:22:"advanced-custom-fields";s:6:"plugin";s:30:"advanced-custom-fields/acf.php";s:11:"new_version";s:5:"4.4.2";s:3:"url";s:53:"https://wordpress.org/plugins/advanced-custom-fields/";s:7:"package";s:65:"https://downloads.wordpress.org/plugin/advanced-custom-fields.zip";}s:19:"akismet/akismet.php";O:8:"stdClass":6:{s:2:"id";s:2:"15";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:5:"3.1.2";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/akismet.3.1.2.zip";}s:41:"multi-image-upload/multi-image-upload.php";O:8:"stdClass":6:{s:2:"id";s:5:"45538";s:4:"slug";s:18:"multi-image-upload";s:6:"plugin";s:41:"multi-image-upload/multi-image-upload.php";s:11:"new_version";s:3:"1.1";s:3:"url";s:49:"https://wordpress.org/plugins/multi-image-upload/";s:7:"package";s:65:"https://downloads.wordpress.org/plugin/multi-image-upload.1.1.zip";}s:37:"post-types-order/post-types-order.php";O:8:"stdClass":6:{s:2:"id";s:5:"17292";s:4:"slug";s:16:"post-types-order";s:6:"plugin";s:37:"post-types-order/post-types-order.php";s:11:"new_version";s:5:"1.8.1";s:3:"url";s:47:"https://wordpress.org/plugins/post-types-order/";s:7:"package";s:59:"https://downloads.wordpress.org/plugin/post-types-order.zip";}s:40:"sitepress-multilingual-cms/sitepress.php";O:8:"stdClass":6:{s:2:"id";i:0;s:4:"slug";s:26:"sitepress-multilingual-cms";s:6:"plugin";s:40:"sitepress-multilingual-cms/sitepress.php";s:11:"new_version";s:7:"3.1.9.7";s:14:"upgrade_notice";s:0:"";s:3:"url";s:47:"https://wpml.org/?download=6088&version=3.1.9.7";}s:34:"wpml-string-translation/plugin.php";O:8:"stdClass":6:{s:2:"id";i:0;s:4:"slug";s:23:"wpml-string-translation";s:6:"plugin";s:34:"wpml-string-translation/plugin.php";s:11:"new_version";s:5:"2.1.4";s:14:"upgrade_notice";s:0:"";s:3:"url";s:45:"https://wpml.org/?download=6092&version=2.1.4";}}s:12:"translations";a:1:{i:0;a:7:{s:4:"type";s:6:"plugin";s:4:"slug";s:18:"wordpress-importer";s:8:"language";s:5:"fr_FR";s:7:"version";s:5:"0.6.1";s:7:"updated";s:19:"2012-05-08 16:00:37";s:7:"package";s:85:"https://downloads.wordpress.org/translation/plugin/wordpress-importer/0.6.1/fr_FR.zip";s:10:"autoupdate";b:1;}}s:7:"checked";a:2:{s:40:"sitepress-multilingual-cms/sitepress.php";s:7:"3.1.9.3";s:34:"wpml-string-translation/plugin.php";s:5:"2.1.1";}}', 'yes'); 
INSERT INTO `wp_options` VALUES (5955, 'category_children', 'a:0:{}', 'yes'); 
INSERT INTO `wp_options` VALUES (6590, '_transient_is_multi_author', '1', 'yes');
#
# End of data contents of table `wp_options`
# --------------------------------------------------------

# --------------------------------------------------------
# Table: `wp_postmeta`
# --------------------------------------------------------


#
# Delete any existing table `wp_postmeta`
#

DROP TABLE IF EXISTS `wp_postmeta`;


#
# Table structure of table `wp_postmeta`
#

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=124752 DEFAULT CHARSET=utf8 ;

#
# Data contents of table `wp_postmeta`
#
 
INSERT INTO `wp_postmeta` VALUES (358, 45, '_edit_lock', '1406551547:2'); 
INSERT INTO `wp_postmeta` VALUES (4, 5, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (5, 5, '_edit_lock', '1434632779:2'); 
INSERT INTO `wp_postmeta` VALUES (6, 5, '_wp_page_template', 'page-home.php'); 
INSERT INTO `wp_postmeta` VALUES (7, 7, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (8, 7, '_wp_page_template', 'page-clients.php'); 
INSERT INTO `wp_postmeta` VALUES (9, 7, '_edit_lock', '1433174468:2'); 
INSERT INTO `wp_postmeta` VALUES (10, 9, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (11, 9, '_wp_page_template', 'page-approach.php'); 
INSERT INTO `wp_postmeta` VALUES (12, 9, '_edit_lock', '1433343031:2'); 
INSERT INTO `wp_postmeta` VALUES (13, 11, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (14, 11, '_wp_page_template', 'page-about.php'); 
INSERT INTO `wp_postmeta` VALUES (15, 11, '_edit_lock', '1433770493:2'); 
INSERT INTO `wp_postmeta` VALUES (16, 13, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (17, 13, '_wp_page_template', 'page-contact.php'); 
INSERT INTO `wp_postmeta` VALUES (18, 13, '_edit_lock', '1432136098:1'); 
INSERT INTO `wp_postmeta` VALUES (19, 1, '_edit_lock', '1434029134:2'); 
INSERT INTO `wp_postmeta` VALUES (20, 15, '_edit_lock', '1429632334:1'); 
INSERT INTO `wp_postmeta` VALUES (21, 15, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (75622, 15, 'rule', 'a:5:{s:5:"param";s:9:"post_type";s:8:"operator";s:2:"==";s:5:"value";s:4:"post";s:8:"order_no";i:0;s:8:"group_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (23, 15, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (24, 15, 'layout', 'default'); 
INSERT INTO `wp_postmeta` VALUES (25, 15, 'hide_on_screen', ''); 
INSERT INTO `wp_postmeta` VALUES (27, 15, 'field_538b9de882bff', 'a:13:{s:3:"key";s:19:"field_538b9de882bff";s:5:"label";s:21:"block photos légende";s:4:"name";s:20:"block_photos_legende";s:4:"type";s:8:"repeater";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:10:"sub_fields";a:10:{i:0;a:12:{s:3:"key";s:19:"field_538b9e4d82c00";s:5:"label";s:12:"photo gauche";s:4:"name";s:7:"photo_l";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}i:1;a:12:{s:3:"key";s:19:"field_53ece0b878c24";s:5:"label";s:15:"photo au centre";s:4:"name";s:7:"photo_m";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:1;}i:2;a:12:{s:3:"key";s:19:"field_538b9e7e82c01";s:5:"label";s:12:"photo droite";s:4:"name";s:7:"photo_r";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:2;}i:3;a:12:{s:3:"key";s:19:"field_55156fe993680";s:5:"label";s:19:"photo gauche Ipad H";s:4:"name";s:19:"photo_gauche_ipad_h";s:4:"type";s:5:"image";s:12:"instructions";s:35:"1824x844 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:3;}i:4;a:12:{s:3:"key";s:19:"field_5515704193683";s:5:"label";s:19:"photo gauche Ipad V";s:4:"name";s:19:"photo_gauche_ipad_v";s:4:"type";s:5:"image";s:12:"instructions";s:35:"1336x740 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:4;}i:5;a:12:{s:3:"key";s:19:"field_55157097ae085";s:5:"label";s:21:"photo gauche Iphone H";s:4:"name";s:21:"photo_gauche_iphone_h";s:4:"type";s:5:"image";s:12:"instructions";s:34:"880x420 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:5;}i:6;a:12:{s:3:"key";s:19:"field_551570dbae088";s:5:"label";s:21:"photo gauche Iphone V";s:4:"name";s:21:"photo_gauche_iphone_v";s:4:"type";s:5:"image";s:12:"instructions";s:34:"560x400 px pour une largeur totale";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:19:"field_53e4df62543ef";s:8:"operator";s:2:"==";s:5:"value";s:4:"true";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:6;}i:7;a:14:{s:3:"key";s:19:"field_538b9ea782c02";s:5:"label";s:5:"titre";s:4:"name";s:5:"title";s:4:"type";s:8:"textarea";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:13:"default_value";s:0:"";s:11:"placeholder";s:0:"";s:9:"maxlength";s:0:"";s:4:"rows";s:0:"";s:10:"formatting";s:2:"br";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:7;}i:8;a:14:{s:3:"key";s:19:"field_538b9ebe82c03";s:5:"label";s:10:"sous titre";s:4:"name";s:8:"subtitle";s:4:"type";s:8:"textarea";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:13:"default_value";s:0:"";s:11:"placeholder";s:0:"";s:9:"maxlength";s:0:"";s:4:"rows";s:0:"";s:10:"formatting";s:2:"br";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:8;}i:9;a:14:{s:3:"key";s:19:"field_53e4df62543ef";s:5:"label";s:12:"before-after";s:4:"name";s:12:"before-after";s:4:"type";s:5:"radio";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:12:"column_width";s:0:"";s:7:"choices";a:2:{s:4:"true";s:4:"true";s:5:"false";s:5:"false";}s:12:"other_choice";s:1:"0";s:17:"save_other_choice";s:1:"0";s:13:"default_value";s:5:"false";s:6:"layout";s:8:"vertical";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:9;}}s:7:"row_min";s:0:"";s:9:"row_limit";s:0:"";s:6:"layout";s:3:"row";s:12:"button_label";s:7:"Add Row";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:2:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (34, 16, '_edit_lock', '1403059267:1'); 
INSERT INTO `wp_postmeta` VALUES (35, 16, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (36, 16, 'field_538ba0e4f295f', 'a:14:{s:3:"key";s:19:"field_538ba0e4f295f";s:5:"label";s:10:"sous titre";s:4:"name";s:13:"subtitle_name";s:4:"type";s:4:"text";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:13:"default_value";s:0:"";s:11:"placeholder";s:0:"";s:7:"prepend";s:0:"";s:6:"append";s:0:"";s:10:"formatting";s:4:"html";s:9:"maxlength";s:0:"";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:2:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (161, 16, 'rule', 'a:5:{s:5:"param";s:9:"post_type";s:8:"operator";s:2:"==";s:5:"value";s:4:"post";s:8:"order_no";i:0;s:8:"group_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (38, 16, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (39, 16, 'layout', 'default'); 
INSERT INTO `wp_postmeta` VALUES (40, 16, 'hide_on_screen', 'a:1:{i:0;s:11:"the_content";}'); 
INSERT INTO `wp_postmeta` VALUES (43, 1, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (53, 18, '_wp_attached_file', '2014/06/a.png'); 
INSERT INTO `wp_postmeta` VALUES (45, 17, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (46, 17, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (47, 17, 'block_photos_legende', '0'); 
INSERT INTO `wp_postmeta` VALUES (48, 17, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (49, 1, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (50, 1, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (51, 1, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (52, 1, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (54, 18, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:250;s:6:"height";i:185;s:4:"file";s:13:"2014/06/a.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:13:"a-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (57, 19, '_wp_attached_file', '2014/06/bg_contact.png'); 
INSERT INTO `wp_postmeta` VALUES (58, 19, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1078;s:6:"height";i:601;s:4:"file";s:22:"2014/06/bg_contact.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"bg_contact-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"bg_contact-300x167.png";s:5:"width";i:300;s:6:"height";i:167;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"bg_contact-1024x570.png";s:5:"width";i:1024;s:6:"height";i:570;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"bg_contact-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"bg_contact-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (60, 22, '_menu_item_type', 'post_type'); 
INSERT INTO `wp_postmeta` VALUES (61, 22, '_menu_item_menu_item_parent', '0'); 
INSERT INTO `wp_postmeta` VALUES (62, 22, '_menu_item_object_id', '13'); 
INSERT INTO `wp_postmeta` VALUES (63, 22, '_menu_item_object', 'page'); 
INSERT INTO `wp_postmeta` VALUES (64, 22, '_menu_item_target', ''); 
INSERT INTO `wp_postmeta` VALUES (65, 22, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'); 
INSERT INTO `wp_postmeta` VALUES (66, 22, '_menu_item_xfn', ''); 
INSERT INTO `wp_postmeta` VALUES (67, 22, '_menu_item_url', ''); 
INSERT INTO `wp_postmeta` VALUES (10356, 624, 'image', '623'); 
INSERT INTO `wp_postmeta` VALUES (10354, 623, '_wp_attached_file', '2014/06/home-hand.jpg'); 
INSERT INTO `wp_postmeta` VALUES (10355, 623, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:325;s:4:"file";s:21:"2014/06/home-hand.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"home-hand-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"home-hand-300x203.jpg";s:5:"width";i:300;s:6:"height";i:203;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66203, 1915, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (78, 24, '_menu_item_type', 'post_type'); 
INSERT INTO `wp_postmeta` VALUES (79, 24, '_menu_item_menu_item_parent', '0'); 
INSERT INTO `wp_postmeta` VALUES (80, 24, '_menu_item_object_id', '9'); 
INSERT INTO `wp_postmeta` VALUES (81, 24, '_menu_item_object', 'page'); 
INSERT INTO `wp_postmeta` VALUES (82, 24, '_menu_item_target', ''); 
INSERT INTO `wp_postmeta` VALUES (83, 24, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'); 
INSERT INTO `wp_postmeta` VALUES (84, 24, '_menu_item_xfn', ''); 
INSERT INTO `wp_postmeta` VALUES (85, 24, '_menu_item_url', ''); 
INSERT INTO `wp_postmeta` VALUES (87, 25, '_menu_item_type', 'post_type'); 
INSERT INTO `wp_postmeta` VALUES (88, 25, '_menu_item_menu_item_parent', '0'); 
INSERT INTO `wp_postmeta` VALUES (89, 25, '_menu_item_object_id', '7'); 
INSERT INTO `wp_postmeta` VALUES (90, 25, '_menu_item_object', 'page'); 
INSERT INTO `wp_postmeta` VALUES (91, 25, '_menu_item_target', ''); 
INSERT INTO `wp_postmeta` VALUES (92, 25, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'); 
INSERT INTO `wp_postmeta` VALUES (93, 25, '_menu_item_xfn', ''); 
INSERT INTO `wp_postmeta` VALUES (94, 25, '_menu_item_url', ''); 
INSERT INTO `wp_postmeta` VALUES (66205, 1915, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (15750, 826, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (15749, 826, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (15748, 826, 'actu', '0'); 
INSERT INTO `wp_postmeta` VALUES (104733, 496, 'rule', 'a:5:{s:5:"param";s:9:"post_type";s:8:"operator";s:2:"==";s:5:"value";s:4:"post";s:8:"order_no";i:0;s:8:"group_no";i:7;}'); 
INSERT INTO `wp_postmeta` VALUES (66204, 1915, 'block_photos_legende_0_subtitle', '• Redonner ses lettres de noblesse au domaine Château de Pommard.\r\n'); 
INSERT INTO `wp_postmeta` VALUES (66202, 1915, 'block_photos_legende_0_title', 'Logo design, emblem and typography. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66201, 1915, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66200, 1915, 'block_photos_legende_0_photo_gauche_iphone_v', '1749'); 
INSERT INTO `wp_postmeta` VALUES (66199, 1915, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66198, 1915, 'block_photos_legende_0_photo_gauche_iphone_h', '1748'); 
INSERT INTO `wp_postmeta` VALUES (66171, 1914, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (139, 35, '_edit_lock', '1434029163:2'); 
INSERT INTO `wp_postmeta` VALUES (66197, 1915, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66193, 1915, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66194, 1915, 'block_photos_legende_0_photo_gauche_ipad_h', '1745'); 
INSERT INTO `wp_postmeta` VALUES (66195, 1915, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66196, 1915, 'block_photos_legende_0_photo_gauche_ipad_v', '1746'); 
INSERT INTO `wp_postmeta` VALUES (140, 35, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (141, 36, '_wp_attached_file', '2014/06/bogosse.png'); 
INSERT INTO `wp_postmeta` VALUES (142, 36, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:19:"2014/06/bogosse.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"bogosse-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"bogosse-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"bogosse-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"bogosse-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"bogosse-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (6993, 466, '_edit_lock', '1409789258:1'); 
INSERT INTO `wp_postmeta` VALUES (146, 39, 'subtitle_name', ''); 
INSERT INTO `wp_postmeta` VALUES (147, 39, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (148, 39, 'block_photos_legende', '0'); 
INSERT INTO `wp_postmeta` VALUES (149, 39, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (150, 35, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (151, 35, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (152, 35, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (153, 35, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (155, 40, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (156, 40, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (157, 40, 'block_photos_legende', '0'); 
INSERT INTO `wp_postmeta` VALUES (158, 40, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (211, 45, '_wp_attached_file', '2014/06/moet.png'); 
INSERT INTO `wp_postmeta` VALUES (212, 45, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:16:"2014/06/moet.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"moet-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"moet-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"moet-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"moet-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"moet-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (165, 42, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (166, 42, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (167, 42, 'block_photos_legende_0_photo_l', '41'); 
INSERT INTO `wp_postmeta` VALUES (168, 42, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (169, 42, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (170, 42, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (171, 42, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (172, 42, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (173, 42, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (174, 42, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (175, 42, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (176, 42, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (177, 1, 'block_photos_legende_0_photo_l', '701'); 
INSERT INTO `wp_postmeta` VALUES (178, 1, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (179, 1, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (180, 1, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (181, 1, 'block_photos_legende_0_title', 'Champagne Moët & Chandon. Design du logo. Dessin et typographie. 2002'); 
INSERT INTO `wp_postmeta` VALUES (182, 1, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (183, 1, 'block_photos_legende_0_subtitle', '• Rafraîchir la marque Moët & Chandon à l’occasion de la refonte complète de la gamme.\r\n> L’emblème de Moët & Chandon est une combinaison de la couronne impériale et de la tiare papale. Il a été redessiné, tout comme le lettrage, dont les pleins et déliés ont été accentués, pour une vibration plus harmonieuse.'); 
INSERT INTO `wp_postmeta` VALUES (184, 1, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (186, 43, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (187, 43, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (188, 43, 'block_photos_legende_0_photo_l', '41'); 
INSERT INTO `wp_postmeta` VALUES (189, 43, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (190, 43, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (191, 43, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (192, 43, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (193, 43, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (194, 43, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (195, 43, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (196, 43, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (197, 43, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (199, 44, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (200, 44, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (201, 44, 'block_photos_legende_0_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (202, 44, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (203, 44, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (204, 44, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (205, 44, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (206, 44, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (207, 44, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (208, 44, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (209, 44, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (210, 44, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (227, 47, '_wp_attached_file', '2014/06/moet_l.png'); 
INSERT INTO `wp_postmeta` VALUES (214, 46, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (215, 46, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (216, 46, 'block_photos_legende_0_photo_l', '45'); 
INSERT INTO `wp_postmeta` VALUES (217, 46, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (218, 46, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (219, 46, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (220, 46, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (221, 46, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (222, 46, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (223, 46, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (224, 46, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (225, 46, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (228, 47, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:731;s:6:"height";i:501;s:4:"file";s:18:"2014/06/moet_l.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"moet_l-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"moet_l-300x205.png";s:5:"width";i:300;s:6:"height";i:205;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"moet_l-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (229, 48, '_wp_attached_file', '2014/06/moet_p.png'); 
INSERT INTO `wp_postmeta` VALUES (230, 48, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:332;s:6:"height";i:500;s:4:"file";s:18:"2014/06/moet_p.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"moet_p-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"moet_p-199x300.png";s:5:"width";i:199;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"moet_p-332x372.png";s:5:"width";i:332;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (232, 49, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (233, 49, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (234, 49, 'block_photos_legende_0_photo_l', '45'); 
INSERT INTO `wp_postmeta` VALUES (235, 49, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (236, 49, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (237, 49, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (238, 49, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (239, 49, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (240, 49, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (241, 49, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (242, 49, 'block_photos_legende_1_photo_l', '47'); 
INSERT INTO `wp_postmeta` VALUES (243, 49, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (244, 49, 'block_photos_legende_1_photo_r', '48'); 
INSERT INTO `wp_postmeta` VALUES (245, 49, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (246, 49, 'block_photos_legende_1_title', 'Moët & Chandon. Identité visuelle & Packaging. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (247, 49, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (248, 49, 'block_photos_legende_1_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (249, 49, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (250, 49, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (251, 49, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (252, 1, 'block_photos_legende_1_photo_l', '343'); 
INSERT INTO `wp_postmeta` VALUES (253, 1, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (254, 1, 'block_photos_legende_1_photo_r', '344'); 
INSERT INTO `wp_postmeta` VALUES (255, 1, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (256, 1, 'block_photos_legende_1_title', 'Habillages de Brut Impérial et de Brut Impérial Rosé. 2002-2007'); 
INSERT INTO `wp_postmeta` VALUES (257, 1, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (258, 1, 'block_photos_legende_1_subtitle', '> L’ensemble de la gamme avec les habillages et leurs couleurs ainsi que la coupe de la cravate emblématique, ont été redessinés. Le dos de la collerette se dote d\'un médaillon ouvragé.'); 
INSERT INTO `wp_postmeta` VALUES (414, 1, 'block_photos_legende_2_photo_l', '345'); 
INSERT INTO `wp_postmeta` VALUES (259, 1, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (441, 71, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:17:"2014/06/blanc.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"blanc-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"blanc-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:18:"blanc-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"blanc-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"blanc-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (440, 71, '_wp_attached_file', '2014/06/blanc.png'); 
INSERT INTO `wp_postmeta` VALUES (438, 70, '_wp_attached_file', '2014/06/LogoDR.png'); 
INSERT INTO `wp_postmeta` VALUES (439, 70, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:18:"2014/06/LogoDR.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"LogoDR-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"LogoDR-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"LogoDR-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"LogoDR-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"LogoDR-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66192, 1915, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (66180, 1914, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (336, 57, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:900;s:4:"file";s:25:"2014/06/logos_clients.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"logos_clients-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"logos_clients-300x250.png";s:5:"width";i:300;s:6:"height";i:250;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"logos_clients-1024x853.png";s:5:"width";i:1024;s:6:"height";i:853;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"logos_clients-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"logos_clients-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (308, 55, '_wp_attached_file', '2014/07/5ca60eba384626909771e675ff0214041.jpg'); 
INSERT INTO `wp_postmeta` VALUES (309, 55, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:534;s:6:"height";i:700;s:4:"file";s:45:"2014/07/5ca60eba384626909771e675ff0214041.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-228x300.jpg";s:5:"width";i:228;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-534x372.jpg";s:5:"width";i:534;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:45:"5ca60eba384626909771e675ff0214041-534x576.jpg";s:5:"width";i:534;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66181, 1914, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (66532, 1919, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66619, 1920, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66185, 1915, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (66186, 1915, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (66187, 1915, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (66188, 1915, 'block_photos_legende_0_photo_l', '1911'); 
INSERT INTO `wp_postmeta` VALUES (66189, 1915, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66190, 1915, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (66191, 1915, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66179, 1914, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66178, 1914, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66176, 1914, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (66177, 1914, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66175, 1914, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66174, 1914, 'block_photos_legende_3_title', 'Habillages des vins blancs. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66172, 1914, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (335, 57, '_wp_attached_file', '2014/06/logos_clients.png'); 
INSERT INTO `wp_postmeta` VALUES (3422, 257, 'image_1080', '251'); 
INSERT INTO `wp_postmeta` VALUES (359, 63, '_wp_attached_file', '2014/06/logo_MC2.png'); 
INSERT INTO `wp_postmeta` VALUES (360, 63, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:20:"2014/06/logo_MC2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"logo_MC2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"logo_MC2-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"logo_MC2-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"logo_MC2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"logo_MC2-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (361, 64, '_wp_attached_file', '2014/06/brut_imperial.png'); 
INSERT INTO `wp_postmeta` VALUES (362, 64, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/brut_imperial.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"brut_imperial-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"brut_imperial-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"brut_imperial-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"brut_imperial-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"brut_imperial-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (363, 65, '_wp_attached_file', '2014/06/millesime_brut.png'); 
INSERT INTO `wp_postmeta` VALUES (364, 65, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/06/millesime_brut.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"millesime_brut-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"millesime_brut-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"millesime_brut-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"millesime_brut-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"millesime_brut-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (365, 66, '_wp_attached_file', '2014/06/grands_crus01.png'); 
INSERT INTO `wp_postmeta` VALUES (366, 66, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/grands_crus01.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"grands_crus01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"grands_crus01-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"grands_crus01-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"grands_crus01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"grands_crus01-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (367, 67, '_wp_attached_file', '2014/06/vuitton_cup01.png'); 
INSERT INTO `wp_postmeta` VALUES (368, 67, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/vuitton_cup01.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"vuitton_cup01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"vuitton_cup01-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"vuitton_cup01-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"vuitton_cup01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"vuitton_cup01-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (370, 68, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (371, 68, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (372, 68, 'block_photos_legende_0_photo_l', '63'); 
INSERT INTO `wp_postmeta` VALUES (373, 68, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (374, 68, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (375, 68, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (376, 68, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (377, 68, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (378, 68, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (379, 68, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (380, 68, 'block_photos_legende_1_photo_l', '64'); 
INSERT INTO `wp_postmeta` VALUES (381, 68, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (382, 68, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (383, 68, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (384, 68, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (385, 68, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (386, 68, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (387, 68, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (388, 68, 'block_photos_legende_2_photo_l', '65'); 
INSERT INTO `wp_postmeta` VALUES (389, 68, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (390, 68, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (391, 68, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (392, 68, 'block_photos_legende_2_title', 'Moët & Chandon. Identité visuelle & Packaging. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (393, 68, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (394, 68, 'block_photos_legende_2_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (395, 68, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (396, 68, 'block_photos_legende_3_photo_l', '66'); 
INSERT INTO `wp_postmeta` VALUES (397, 68, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (398, 68, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (399, 68, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (400, 68, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (401, 68, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (402, 68, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (403, 68, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (404, 68, 'block_photos_legende_4_photo_l', '67'); 
INSERT INTO `wp_postmeta` VALUES (405, 68, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (406, 68, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (407, 68, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (408, 68, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (409, 68, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (410, 68, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (411, 68, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (412, 68, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (413, 68, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (415, 1, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (416, 1, 'block_photos_legende_2_photo_r', '346'); 
INSERT INTO `wp_postmeta` VALUES (417, 1, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (418, 1, 'block_photos_legende_2_title', 'Habillage des millésimés. 2002'); 
INSERT INTO `wp_postmeta` VALUES (419, 1, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (420, 1, 'block_photos_legende_2_subtitle', '> L’étiquette des millésimés est plus grande et plus opulente.'); 
INSERT INTO `wp_postmeta` VALUES (421, 1, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (422, 1, 'block_photos_legende_3_photo_l', '347'); 
INSERT INTO `wp_postmeta` VALUES (423, 1, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (424, 1, 'block_photos_legende_3_photo_r', '348'); 
INSERT INTO `wp_postmeta` VALUES (425, 1, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (426, 1, 'block_photos_legende_3_title', 'Habillages de la Trilogie des Grands Crus. 2002'); 
INSERT INTO `wp_postmeta` VALUES (427, 1, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (428, 1, 'block_photos_legende_3_subtitle', '• Mettre en avant le savoir-faire œnologique et viticole de la maison en proposant une édition spéciale de grands crus.\r\n> Reprenant les codes des grands vins de Bordeaux, les étiquettes traduisent le terroir de manière authentique plus que festive, sans perdre en préciosité grâce à la sophistication des détails et le numérotage des bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (429, 1, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (430, 1, 'block_photos_legende_4_photo_l', '349'); 
INSERT INTO `wp_postmeta` VALUES (431, 1, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (432, 1, 'block_photos_legende_4_photo_r', '1300'); 
INSERT INTO `wp_postmeta` VALUES (433, 1, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (434, 1, 'block_photos_legende_4_title', 'Habillage de l\'édition limitée Louis Vuitton Cup. 2004 '); 
INSERT INTO `wp_postmeta` VALUES (435, 1, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (436, 1, 'block_photos_legende_4_subtitle', '> La bouteille de Brut Impérial a été habillée aux couleurs de la Louis Vuitton Cup. '); 
INSERT INTO `wp_postmeta` VALUES (437, 1, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (442, 72, '_wp_attached_file', '2014/06/rose2.png'); 
INSERT INTO `wp_postmeta` VALUES (443, 72, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:17:"2014/06/rose2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"rose2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"rose2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:18:"rose2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"rose2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"rose2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (11162, 677, '_block_photos_legende_0_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (11161, 677, 'block_photos_legende_0_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11160, 677, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (11159, 677, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (11158, 677, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (11157, 677, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (11156, 677, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (11155, 677, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (11154, 677, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (11153, 677, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (11152, 677, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (11151, 677, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (11150, 677, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (11149, 677, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (11148, 677, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (11147, 677, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (11146, 677, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (11145, 677, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (11207, 678, '_wp_attached_file', '2014/07/lesclassiques.png'); 
INSERT INTO `wp_postmeta` VALUES (525, 74, '_edit_lock', '1434029101:2'); 
INSERT INTO `wp_postmeta` VALUES (473, 73, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (474, 73, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (475, 73, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (476, 73, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (477, 73, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (478, 73, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (479, 73, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (480, 73, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (481, 73, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (482, 73, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (483, 73, 'block_photos_legende_1_photo_l', '71'); 
INSERT INTO `wp_postmeta` VALUES (484, 73, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (485, 73, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (486, 73, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (487, 73, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (488, 73, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (489, 73, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (490, 73, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (491, 73, 'block_photos_legende_2_photo_l', '72'); 
INSERT INTO `wp_postmeta` VALUES (492, 73, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (493, 73, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (494, 73, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (495, 73, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (496, 73, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (497, 73, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (498, 73, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (499, 73, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (500, 73, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (501, 35, 'block_photos_legende_0_photo_l', '1041'); 
INSERT INTO `wp_postmeta` VALUES (502, 35, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (503, 35, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (504, 35, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (505, 35, 'block_photos_legende_0_title', 'Champagne Dom Ruinart. Design du logo. Dessin et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (506, 35, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (507, 35, 'block_photos_legende_0_subtitle', '• Traduire le caractère patrimonial du fleuron de la plus ancienne maison de champagne.\r\n \r\n      '); 
INSERT INTO `wp_postmeta` VALUES (508, 35, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (509, 35, 'block_photos_legende_1_photo_l', '1132'); 
INSERT INTO `wp_postmeta` VALUES (510, 35, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (511, 35, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (512, 35, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (513, 35, 'block_photos_legende_1_title', 'Packaging et habillages de Dom Ruinart Blanc de Blancs et Dom Ruinart Rosé. 2014'); 
INSERT INTO `wp_postmeta` VALUES (514, 35, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (515, 35, 'block_photos_legende_1_subtitle', '• Apporter de l’élégance et une silhouette contemporaine au packaging, en contraste avec la dimension historique de la marque.\r\n> Le volume du coffret a été rationalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.\r\n[lifting anchor=domruinart lang=fr]Voir l\'évolution du packaging.[/lifting]'); 
INSERT INTO `wp_postmeta` VALUES (516, 35, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (517, 35, 'block_photos_legende_2_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (518, 35, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (519, 35, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (520, 35, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (521, 35, 'block_photos_legende_2_title', 'Habillage de Dom Ruinart Blanc de Blancs. 2014'); 
INSERT INTO `wp_postmeta` VALUES (522, 35, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (523, 35, 'block_photos_legende_2_subtitle', '> Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. Un soin particulier a été apporté aux détails : la coiffe est ornée d\'un blason embossé, l\'étiquette se pare de dorures à chaud et de vernis gonflant pour plus d\'opulence. L\'assemblage de différents caractères typographiques participe de l\'expression de la richesse du goût.'); 
INSERT INTO `wp_postmeta` VALUES (524, 35, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (526, 74, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (527, 75, '_wp_attached_file', '2014/07/logo_Fussigny2.png'); 
INSERT INTO `wp_postmeta` VALUES (528, 75, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:26:"2014/07/logo_Fussigny2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"logo_Fussigny2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"logo_Fussigny2-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"logo_Fussigny2-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"logo_Fussigny2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"logo_Fussigny2-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (529, 76, '_wp_attached_file', '2014/07/bouteille_close_up.png'); 
INSERT INTO `wp_postmeta` VALUES (530, 76, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/bouteille_close_up.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"bouteille_close_up-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"bouteille_close_up-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"bouteille_close_up-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"bouteille_close_up-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"bouteille_close_up-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (531, 77, '_wp_attached_file', '2014/07/XO_1.png'); 
INSERT INTO `wp_postmeta` VALUES (532, 77, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:16:"2014/07/XO_1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"XO_1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"XO_1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"XO_1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"XO_1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"XO_1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (534, 78, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (535, 78, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (536, 78, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (537, 78, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (538, 78, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (539, 78, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (540, 78, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (541, 78, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (542, 78, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (543, 78, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (544, 78, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (545, 78, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (546, 78, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (547, 78, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (548, 78, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (549, 78, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (550, 78, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (551, 78, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (552, 78, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (553, 78, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (554, 78, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (555, 78, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (556, 78, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (557, 78, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (558, 78, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (559, 78, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (560, 78, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (561, 78, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (562, 74, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (563, 74, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (564, 74, 'block_photos_legende_0_photo_l', '2281'); 
INSERT INTO `wp_postmeta` VALUES (565, 74, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (566, 74, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (567, 74, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (568, 74, 'block_photos_legende_0_title', 'Cognac A. de Fussigny. Design du logo. Dessin et typographie. 2001'); 
INSERT INTO `wp_postmeta` VALUES (569, 74, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (570, 74, 'block_photos_legende_0_subtitle', '> Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (571, 74, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (572, 74, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (573, 74, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (574, 74, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (575, 74, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (576, 74, 'block_photos_legende_1_title', 'Placement du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (577, 74, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (578, 74, 'block_photos_legende_1_subtitle', '> Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (579, 74, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (580, 74, 'block_photos_legende_2_photo_l', '320'); 
INSERT INTO `wp_postmeta` VALUES (581, 74, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (582, 74, 'block_photos_legende_2_photo_r', '321'); 
INSERT INTO `wp_postmeta` VALUES (583, 74, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (584, 74, 'block_photos_legende_2_title', 'Exemples d\'utilisation du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (585, 74, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (586, 74, 'block_photos_legende_2_subtitle', '> Les études packaging ont été réalisées par l\'agence Farnham & Associates.'); 
INSERT INTO `wp_postmeta` VALUES (587, 74, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (588, 74, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (589, 74, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (63007, 1354, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (594, 80, '_wp_attached_file', '2014/07/logo_lejay.png'); 
INSERT INTO `wp_postmeta` VALUES (595, 80, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:22:"2014/07/logo_lejay.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"logo_lejay-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"logo_lejay-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"logo_lejay-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"logo_lejay-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"logo_lejay-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (596, 81, '_wp_attached_file', '2014/07/logo_avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (597, 81, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:28:"2014/07/logo_avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"logo_avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"logo_avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"logo_avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"logo_avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"logo_avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (598, 82, '_wp_attached_file', '2014/07/avant_apres_cassis.png'); 
INSERT INTO `wp_postmeta` VALUES (599, 82, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/avant_apres_cassis.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"avant_apres_cassis-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"avant_apres_cassis-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"avant_apres_cassis-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"avant_apres_cassis-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"avant_apres_cassis-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (600, 83, '_wp_attached_file', '2014/07/cremes.png'); 
INSERT INTO `wp_postmeta` VALUES (601, 83, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:18:"2014/07/cremes.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"cremes-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"cremes-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"cremes-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"cremes-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"cremes-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (602, 84, '_wp_attached_file', '2014/07/liqueurs.png'); 
INSERT INTO `wp_postmeta` VALUES (603, 84, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/liqueurs.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"liqueurs-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"liqueurs-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"liqueurs-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"liqueurs-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"liqueurs-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (604, 85, '_wp_attached_file', '2014/07/lejay_US.png'); 
INSERT INTO `wp_postmeta` VALUES (605, 85, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/lejay_US.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"lejay_US-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"lejay_US-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"lejay_US-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"lejay_US-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"lejay_US-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (712, 87, '_edit_lock', '1434029075:2'); 
INSERT INTO `wp_postmeta` VALUES (64471, 1895, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (64472, 1895, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (64473, 1895, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (64474, 1895, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (64475, 1895, 'block_photos_legende_0_photo_l', '1676'); 
INSERT INTO `wp_postmeta` VALUES (64476, 1895, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64773, 1898, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64772, 1898, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64771, 1898, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64770, 1898, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64769, 1898, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64768, 1898, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64767, 1898, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64766, 1898, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64765, 1898, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64764, 1898, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (64763, 1898, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64762, 1898, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64761, 1898, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64760, 1898, 'block_photos_legende_2_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (64759, 1898, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64758, 1898, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64757, 1898, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64756, 1898, 'block_photos_legende_1_subtitle', '• Apporter de l’élégance et une silhouette contemporaine au packaging, en contraste avec la dimension historique de la marque.\r\n> Le volume du coffret a été rationalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (64755, 1898, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64754, 1898, 'block_photos_legende_1_title', 'Packaging et habillages de Dom Ruinart Blanc de Blancs et Dom Ruinart Rosé. 2014'); 
INSERT INTO `wp_postmeta` VALUES (64753, 1898, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64752, 1898, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (63006, 1354, 'block_photos_legende_0_photo_gauche_ipad_h', '2154'); 
INSERT INTO `wp_postmeta` VALUES (63005, 1876, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (63004, 1876, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (63003, 1876, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62996, 1876, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62995, 1876, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62992, 1876, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62986, 1876, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62985, 1876, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62982, 1876, 'block_photos_legende_0_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62976, 1876, 'block_photos_legende_0_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62975, 1876, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62974, 1876, 'block_photos_legende_0_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62972, 1876, 'block_photos_legende_0_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62969, 1876, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62968, 1876, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62967, 1876, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62966, 1876, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62965, 1876, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62963, 1876, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (62962, 1876, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (62958, 1355, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62957, 1355, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62955, 1355, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62954, 1355, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62883, 1874, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (713, 87, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (714, 88, '_wp_attached_file', '2014/07/logo.png'); 
INSERT INTO `wp_postmeta` VALUES (715, 88, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:16:"2014/07/logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (716, 89, '_wp_attached_file', '2014/07/bouteille1.png'); 
INSERT INTO `wp_postmeta` VALUES (717, 89, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/bouteille1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"bouteille1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"bouteille1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"bouteille1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"bouteille1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"bouteille1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (718, 90, '_wp_attached_file', '2014/07/chateau.png'); 
INSERT INTO `wp_postmeta` VALUES (719, 90, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:19:"2014/07/chateau.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"chateau-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"chateau-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"chateau-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"chateau-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"chateau-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (720, 91, '_wp_attached_file', '2014/07/bouteille2.png'); 
INSERT INTO `wp_postmeta` VALUES (721, 91, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/bouteille2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"bouteille2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"bouteille2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"bouteille2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"bouteille2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"bouteille2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (722, 92, '_wp_attached_file', '2014/07/tonneau.png'); 
INSERT INTO `wp_postmeta` VALUES (723, 92, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:19:"2014/07/tonneau.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"tonneau-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"tonneau-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"tonneau-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"tonneau-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"tonneau-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (724, 93, '_wp_attached_file', '2014/07/tonneau1.png'); 
INSERT INTO `wp_postmeta` VALUES (725, 93, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/tonneau1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"tonneau1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"tonneau1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"tonneau1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"tonneau1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"tonneau1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (727, 94, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (728, 94, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (729, 94, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (730, 94, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (731, 94, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (732, 94, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (733, 94, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (734, 94, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (735, 94, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (736, 94, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (737, 94, 'block_photos_legende_1_photo_l', '89'); 
INSERT INTO `wp_postmeta` VALUES (738, 94, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (739, 94, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (740, 94, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (741, 94, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (742, 94, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (743, 94, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (744, 94, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (745, 94, 'block_photos_legende_2_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (746, 94, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (747, 94, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (748, 94, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (749, 94, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (750, 94, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (751, 94, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (752, 94, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (753, 94, 'block_photos_legende_3_photo_l', '91'); 
INSERT INTO `wp_postmeta` VALUES (754, 94, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (755, 94, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (756, 94, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (757, 94, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (758, 94, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (759, 94, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (760, 94, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (761, 94, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (762, 94, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (763, 94, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (764, 94, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (765, 94, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (766, 94, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (767, 94, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (768, 94, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (769, 94, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (770, 94, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (771, 87, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (772, 87, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (773, 87, 'block_photos_legende_0_photo_l', '1994'); 
INSERT INTO `wp_postmeta` VALUES (774, 87, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (775, 87, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (776, 87, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (777, 87, 'block_photos_legende_0_title', 'Domaine du Château de Pommard. Design du logo. Dessin et typographie. 2009'); 
INSERT INTO `wp_postmeta` VALUES (778, 87, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (779, 87, 'block_photos_legende_0_subtitle', '• Redonner ses lettres de noblesse au domaine viticole du Château de Pommard.\r\n'); 
INSERT INTO `wp_postmeta` VALUES (780, 87, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (781, 87, 'block_photos_legende_1_photo_l', '2302'); 
INSERT INTO `wp_postmeta` VALUES (782, 87, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (783, 87, 'block_photos_legende_1_photo_r', '2236'); 
INSERT INTO `wp_postmeta` VALUES (784, 87, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (785, 87, 'block_photos_legende_1_title', 'Évolution des signes'); 
INSERT INTO `wp_postmeta` VALUES (786, 87, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (787, 87, 'block_photos_legende_1_subtitle', '> Pour donner du relief à la marque, nous avons puisé dans son histoire et réinstallé comme identité visuelle un blason utilisé alors pour le marquage des fûts. \r\nLes lions se sont redressés, les armes sont mises en avant et une nouvelle devise vient orner le blason.'); 
INSERT INTO `wp_postmeta` VALUES (788, 87, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (789, 87, 'block_photos_legende_2_photo_l', '352'); 
INSERT INTO `wp_postmeta` VALUES (790, 87, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (791, 87, 'block_photos_legende_2_photo_r', '353'); 
INSERT INTO `wp_postmeta` VALUES (792, 87, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (793, 87, 'block_photos_legende_2_title', 'Habillages des vins rouges. 2009'); 
INSERT INTO `wp_postmeta` VALUES (794, 87, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (795, 87, 'block_photos_legende_2_subtitle', 'En lieu et place de la simple étiquette blanche marquant les vins provenant de cépages voisins, mais vinifiés et mis en bouteille au château, le nouveau blason permet de marquer l’empreinte «Château de Pommard» tout en apportant un supplément de noblesse aux bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (796, 87, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (11163, 677, 'block_photos_legende_1_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (11084, 676, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (11083, 676, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (11082, 676, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (11081, 676, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (11080, 676, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (11075, 676, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (11076, 676, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (813, 87, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (814, 87, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (60653, 1843, '_actu_2_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (818, 96, '_wp_attached_file', '2014/07/logo_remy_martin.png'); 
INSERT INTO `wp_postmeta` VALUES (819, 96, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:28:"2014/07/logo_remy_martin.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"logo_remy_martin-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"logo_remy_martin-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"logo_remy_martin-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"logo_remy_martin-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"logo_remy_martin-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (820, 97, '_wp_attached_file', '2014/07/XO.png'); 
INSERT INTO `wp_postmeta` VALUES (821, 97, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:14:"2014/07/XO.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:14:"XO-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:14:"XO-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:15:"XO-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:14:"XO-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:15:"XO-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (822, 98, '_wp_attached_file', '2014/07/1738_2.png'); 
INSERT INTO `wp_postmeta` VALUES (823, 98, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:18:"2014/07/1738_2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"1738_2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"1738_2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"1738_2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"1738_2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"1738_2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (824, 99, '_wp_attached_file', '2014/07/1898.png'); 
INSERT INTO `wp_postmeta` VALUES (825, 99, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:16:"2014/07/1898.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"1898-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"1898-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:17:"1898-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"1898-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:17:"1898-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (826, 100, '_wp_attached_file', '2014/07/coeur_cognac2.png'); 
INSERT INTO `wp_postmeta` VALUES (827, 100, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/07/coeur_cognac2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"coeur_cognac2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"coeur_cognac2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"coeur_cognac2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"coeur_cognac2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"coeur_cognac2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (62473, 1870, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62472, 1870, 'block_photos_legende_2_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62471, 1870, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62470, 1870, 'block_photos_legende_2_subtitle', '• Expressing the traditional epicurean features of the blackcurrant liquor : the historical and iconic product of the Lejay Lagoute house.\r\n> \'Crème de cassis\' was redesigned in priority over the rest of the range. The new brand identity has been applied to all the packaging elements, notably as a signature on the label, in the manner of the great spirits. Paper material, colours and graphic designs; all is about expressing more sophistication and modernity without weakening the storytelling.'); 
INSERT INTO `wp_postmeta` VALUES (62469, 1870, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62468, 1870, 'block_photos_legende_2_title', 'Crème de cassis label evolution. 2010'); 
INSERT INTO `wp_postmeta` VALUES (62467, 1870, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62466, 1870, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62465, 1870, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62464, 1870, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62463, 1870, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62462, 1870, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62461, 1870, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62460, 1870, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62459, 1870, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62458, 1870, 'block_photos_legende_2_photo_r', '1191'); 
INSERT INTO `wp_postmeta` VALUES (62457, 1870, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62456, 1870, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62455, 1870, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62454, 1870, 'block_photos_legende_2_photo_l', '1190'); 
INSERT INTO `wp_postmeta` VALUES (62453, 1870, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62452, 1870, 'block_photos_legende_1_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62451, 1870, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (60652, 1843, 'actu_2_texte', 'Logo design and typography. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60651, 1843, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60650, 1843, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60649, 1843, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60648, 1843, 'actu_2_lien', '1374'); 
INSERT INTO `wp_postmeta` VALUES (60647, 1843, '_actu_2_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60642, 1843, 'actu_1_texte', 'Visual Identity and design packaging. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60638, 1843, 'actu_1_lien', '1799'); 
INSERT INTO `wp_postmeta` VALUES (60637, 1843, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60636, 1843, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60634, 1843, 'actu_1_image', '971'); 
INSERT INTO `wp_postmeta` VALUES (60630, 1843, 'actu_0_titre', 'Dom Ruinart'); 
INSERT INTO `wp_postmeta` VALUES (60629, 1843, '_actu_0_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60622, 1842, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (60621, 1842, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (60620, 1842, 'actu', '5'); 
INSERT INTO `wp_postmeta` VALUES (60619, 1842, '_actu_4_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60618, 1842, 'actu_4_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60617, 1842, '_actu_4_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60613, 1842, '_actu_4_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60605, 1842, '_actu_3_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60604, 1842, 'actu_3_lien', '136'); 
INSERT INTO `wp_postmeta` VALUES (60603, 1842, '_actu_3_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60602, 1842, 'actu_3_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60601, 1842, '_actu_3_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60598, 1842, 'actu_2_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60590, 1842, 'actu_2_image', '972'); 
INSERT INTO `wp_postmeta` VALUES (60589, 1842, '_actu_1_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60588, 1842, 'actu_1_texte', 'Identité visuelle et design packaging. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60587, 1842, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60586, 1842, 'actu_1_titre', 'Lejay Cassis'); 
INSERT INTO `wp_postmeta` VALUES (60584, 1842, 'actu_1_lien', '1795'); 
INSERT INTO `wp_postmeta` VALUES (60583, 1842, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60573, 1842, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60572, 1842, 'actu_0_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60571, 1842, '_actu_0_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (921, 103, '_wp_attached_file', '2014/07/logoDP.png'); 
INSERT INTO `wp_postmeta` VALUES (922, 103, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:18:"2014/07/logoDP.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"logoDP-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"logoDP-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"logoDP-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"logoDP-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"logoDP-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (923, 104, '_wp_attached_file', '2014/07/etiquette_avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (924, 104, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:33:"2014/07/etiquette_avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"etiquette_avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:33:"etiquette_avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:34:"etiquette_avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:33:"etiquette_avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:34:"etiquette_avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (925, 105, '_wp_attached_file', '2014/07/etiquette_oenotheque.png'); 
INSERT INTO `wp_postmeta` VALUES (926, 105, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:32:"2014/07/etiquette_oenotheque.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:32:"etiquette_oenotheque-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:32:"etiquette_oenotheque-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:33:"etiquette_oenotheque-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:32:"etiquette_oenotheque-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:33:"etiquette_oenotheque-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (927, 106, '_wp_attached_file', '2014/07/vintage_blanc.png'); 
INSERT INTO `wp_postmeta` VALUES (928, 106, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/07/vintage_blanc.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"vintage_blanc-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"vintage_blanc-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"vintage_blanc-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"vintage_blanc-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"vintage_blanc-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66449, 1918, 'block_photos_legende_0_photo_l', '1911'); 
INSERT INTO `wp_postmeta` VALUES (66448, 1918, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (66447, 1918, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (66446, 1918, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (66445, 1918, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66443, 1917, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (66442, 1917, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (66441, 1917, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66440, 1917, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66439, 1917, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66438, 1917, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (66437, 1917, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66436, 1917, 'block_photos_legende_3_title', 'Habillages des vins blancs. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66435, 1917, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66434, 1917, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66433, 1917, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66432, 1917, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66431, 1917, '_block_photos_legende_3_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66430, 1917, 'block_photos_legende_3_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66429, 1917, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66428, 1917, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66427, 1917, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66426, 1917, 'block_photos_legende_3_photo_r', '355'); 
INSERT INTO `wp_postmeta` VALUES (66425, 1917, '_block_photos_legende_3_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66424, 1917, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64912, 1899, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64911, 1899, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64910, 1899, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64909, 1899, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64906, 1899, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64900, 1899, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64899, 1899, 'block_photos_legende_3_photo_l', '333'); 
INSERT INTO `wp_postmeta` VALUES (64897, 1899, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64896, 1899, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64894, 1899, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64893, 1899, 'block_photos_legende_2_title', 'Habillage de Dom Ruinart Blanc de Blancs. 2014'); 
INSERT INTO `wp_postmeta` VALUES (64892, 1899, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64891, 1899, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64889, 1899, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64884, 1899, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64883, 1899, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (64882, 1899, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64881, 1899, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64880, 1899, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64877, 1899, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64874, 1899, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64875, 1899, 'block_photos_legende_1_subtitle', '• Apporter de l’élégance et une silhouette contemporaine au packaging, en contraste avec la dimension historique de la marque.\r\n> Le volume du coffret a été rationalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (1011, 108, '_edit_lock', '1434029446:2'); 
INSERT INTO `wp_postmeta` VALUES (1012, 108, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1013, 109, '_wp_attached_file', '2014/07/logo_garriga.png'); 
INSERT INTO `wp_postmeta` VALUES (1014, 109, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/logo_garriga.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"logo_garriga-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"logo_garriga-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"logo_garriga-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"logo_garriga-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"logo_garriga-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1015, 110, '_wp_attached_file', '2014/07/papeterie_garriga.png'); 
INSERT INTO `wp_postmeta` VALUES (1016, 110, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:29:"2014/07/papeterie_garriga.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"papeterie_garriga-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"papeterie_garriga-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"papeterie_garriga-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"papeterie_garriga-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"papeterie_garriga-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1017, 111, '_wp_attached_file', '2014/07/photo01.png'); 
INSERT INTO `wp_postmeta` VALUES (1018, 111, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:19:"2014/07/photo01.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"photo01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:19:"photo01-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:20:"photo01-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"photo01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"photo01-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1078, 113, '_edit_lock', '1434029410:2'); 
INSERT INTO `wp_postmeta` VALUES (1020, 112, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1021, 112, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1022, 112, 'block_photos_legende_0_photo_l', '109'); 
INSERT INTO `wp_postmeta` VALUES (1023, 112, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1024, 112, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1025, 112, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1026, 112, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1027, 112, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1028, 112, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1029, 112, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1030, 112, 'block_photos_legende_1_photo_l', '110'); 
INSERT INTO `wp_postmeta` VALUES (1031, 112, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1032, 112, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1033, 112, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1034, 112, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1035, 112, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1036, 112, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1037, 112, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1038, 112, 'block_photos_legende_2_photo_l', '111'); 
INSERT INTO `wp_postmeta` VALUES (1039, 112, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1040, 112, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1041, 112, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1042, 112, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1043, 112, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1044, 112, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1045, 112, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1046, 112, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1047, 112, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1048, 108, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1049, 108, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1050, 108, 'block_photos_legende_0_photo_l', '769'); 
INSERT INTO `wp_postmeta` VALUES (1051, 108, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1052, 108, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1053, 108, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1054, 108, 'block_photos_legende_0_title', 'Espace gastronomique La Cuina d\'en Garriga. Design du logo. Dessin et typographie. 2008'); 
INSERT INTO `wp_postmeta` VALUES (1055, 108, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1056, 108, 'block_photos_legende_0_subtitle', '• Créer une identité pour cet espace dédié à la gastronomie et aux arts de la table, au centre de Barcelone.\r\n> L‘identité associe une lettre aux accents vintage à une capitale romaine très bistrot. L’ensemble  exprime l’ambiance vivante du lieu.  Le siphon, clin d’œil à l’histoire personnelle de la propriétaire et à la culture catalane, apporte originalité et sophistication.'); 
INSERT INTO `wp_postmeta` VALUES (1057, 108, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1058, 108, 'block_photos_legende_1_photo_l', '880'); 
INSERT INTO `wp_postmeta` VALUES (1059, 108, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1060, 108, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1061, 108, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1062, 108, 'block_photos_legende_1_title', 'Papeterie et sacs. 2008'); 
INSERT INTO `wp_postmeta` VALUES (1063, 108, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1064, 108, 'block_photos_legende_1_subtitle', 'La papeterie et les sacs mettent en scène l’emblème de la maison.'); 
INSERT INTO `wp_postmeta` VALUES (1065, 108, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1066, 108, 'block_photos_legende_2_photo_l', '580'); 
INSERT INTO `wp_postmeta` VALUES (1067, 108, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1068, 108, 'block_photos_legende_2_photo_r', '581'); 
INSERT INTO `wp_postmeta` VALUES (1069, 108, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1070, 108, 'block_photos_legende_2_title', 'Le lieu'); 
INSERT INTO `wp_postmeta` VALUES (1071, 108, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1072, 108, 'block_photos_legende_2_subtitle', 'La Cuina d’en Garriga est un espace multiple, à la fois épicerie fine, traiteur et table d’hôte.'); 
INSERT INTO `wp_postmeta` VALUES (1073, 108, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1074, 108, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (1075, 108, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1079, 113, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1080, 114, '_wp_attached_file', '2014/07/logo_favarger.png'); 
INSERT INTO `wp_postmeta` VALUES (1081, 114, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:25:"2014/07/logo_favarger.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"logo_favarger-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"logo_favarger-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"logo_favarger-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"logo_favarger-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"logo_favarger-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1082, 115, '_wp_attached_file', '2014/07/evolution_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1083, 115, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/07/evolution_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"evolution_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"evolution_logo-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"evolution_logo-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"evolution_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"evolution_logo-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1084, 116, '_wp_attached_file', '2014/07/tablette_livraison.png'); 
INSERT INTO `wp_postmeta` VALUES (1085, 116, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/tablette_livraison.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"tablette_livraison-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"tablette_livraison-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"tablette_livraison-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"tablette_livraison-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"tablette_livraison-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1144, 118, '_edit_lock', '1434029509:2'); 
INSERT INTO `wp_postmeta` VALUES (1087, 117, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1088, 117, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1089, 117, 'block_photos_legende_0_photo_l', '114'); 
INSERT INTO `wp_postmeta` VALUES (1090, 117, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1091, 117, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1092, 117, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1093, 117, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1094, 117, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1095, 117, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1096, 117, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1097, 117, 'block_photos_legende_1_photo_l', '115'); 
INSERT INTO `wp_postmeta` VALUES (1098, 117, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1099, 117, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1100, 117, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1101, 117, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1102, 117, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1103, 117, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1104, 117, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1105, 117, 'block_photos_legende_2_photo_l', '116'); 
INSERT INTO `wp_postmeta` VALUES (1106, 117, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1107, 117, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1108, 117, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1109, 117, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1110, 117, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1111, 117, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1112, 117, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1113, 117, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1114, 117, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1115, 113, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1116, 113, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1117, 113, 'block_photos_legende_0_photo_l', '767'); 
INSERT INTO `wp_postmeta` VALUES (1118, 113, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1119, 113, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1120, 113, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1121, 113, 'block_photos_legende_0_title', 'Manufacture de chocolats Favarger. Design du logo. Dessin et typographie. 2010'); 
INSERT INTO `wp_postmeta` VALUES (1122, 113, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1123, 113, 'block_photos_legende_0_subtitle', '• Faire de la plus ancienne chocolaterie de Genève une marque ancrée dans le monde du luxe traditionnel dont la ville est la capitale.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1124, 113, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1125, 113, 'block_photos_legende_1_photo_l', '1202'); 
INSERT INTO `wp_postmeta` VALUES (1126, 113, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1127, 113, 'block_photos_legende_1_photo_r', '1203'); 
INSERT INTO `wp_postmeta` VALUES (1128, 113, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1129, 113, 'block_photos_legende_1_title', 'Évolution du logo. 2010'); 
INSERT INTO `wp_postmeta` VALUES (1130, 113, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1131, 113, 'block_photos_legende_1_subtitle', 'Jusqu’alors l’identité utilisait une scripte suggérant la signature du chocolatier, en accord avec la nature familiale de l’entreprise. La typographie, l’architecture symétrique, le blason or, la mention Genève… tous ces codes donnent à la marque une stature de maison de luxe international. La mention originelle « chocolats et cacaos » a été réintroduite afin de souligner le métier de torréfacteur, que la maison a su conserver.'); 
INSERT INTO `wp_postmeta` VALUES (1132, 113, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1133, 113, 'block_photos_legende_2_photo_l', '2824'); 
INSERT INTO `wp_postmeta` VALUES (1134, 113, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1135, 113, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1136, 113, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1137, 113, 'block_photos_legende_2_title', 'Dessin de l\'emblème'); 
INSERT INTO `wp_postmeta` VALUES (1138, 113, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1139, 113, 'block_photos_legende_2_subtitle', '> La forme en cœur du blason, reprenant les armes genevoises, est un clin d’oeil bienvenu, sorte d’ «I love Genève» pour initiés.'); 
INSERT INTO `wp_postmeta` VALUES (1140, 113, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1141, 113, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (1142, 113, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1145, 118, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1146, 119, '_wp_attached_file', '2014/07/logo_cinco.png'); 
INSERT INTO `wp_postmeta` VALUES (1147, 119, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:22:"2014/07/logo_cinco.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"logo_cinco-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"logo_cinco-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"logo_cinco-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"logo_cinco-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"logo_cinco-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1148, 120, '_wp_attached_file', '2014/07/avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (1149, 120, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:23:"2014/07/avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1191, 122, '_edit_lock', '1434102187:2'); 
INSERT INTO `wp_postmeta` VALUES (1151, 121, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1152, 121, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1153, 121, 'block_photos_legende_0_photo_l', '119'); 
INSERT INTO `wp_postmeta` VALUES (1154, 121, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1155, 121, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1156, 121, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1157, 121, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1158, 121, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1159, 121, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1160, 121, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1161, 121, 'block_photos_legende_1_photo_l', '120'); 
INSERT INTO `wp_postmeta` VALUES (1162, 121, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1163, 121, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1164, 121, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1165, 121, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1166, 121, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1167, 121, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1168, 121, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1169, 121, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1170, 121, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1171, 118, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1172, 118, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1173, 118, 'block_photos_legende_0_photo_l', '1113'); 
INSERT INTO `wp_postmeta` VALUES (1174, 118, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1175, 118, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1176, 118, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1177, 118, 'block_photos_legende_0_title', 'Jambon ibérique Cinco Jotas. Design du logo. Dessin et typographie. 2013'); 
INSERT INTO `wp_postmeta` VALUES (1178, 118, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1179, 118, 'block_photos_legende_0_subtitle', 'Prestigieuse maison de jambon ibérique, la marque, très connue en Espagne, fait partie du patrimoine national. Nous avons apporté de la sophistication à l’identité de ce produit raffiné, en mettant en avant le savoir-faire traditionnel que la marque cultive depuis plus de 100 ans.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1180, 118, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1181, 118, 'block_photos_legende_1_photo_l', '1205'); 
INSERT INTO `wp_postmeta` VALUES (1182, 118, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1183, 118, 'block_photos_legende_1_photo_r', '1206'); 
INSERT INTO `wp_postmeta` VALUES (1184, 118, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1185, 118, 'block_photos_legende_1_title', 'Évolution de l\'identité visuelle'); 
INSERT INTO `wp_postmeta` VALUES (1186, 118, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1187, 118, 'block_photos_legende_1_subtitle', '> De la plaque automobile au label d’excellence gastronomique. La médaille, légère et ouvragée et la scripte énergique, traduisent la finesse du savoir-faire.'); 
INSERT INTO `wp_postmeta` VALUES (1188, 118, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1189, 118, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1190, 118, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1192, 122, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1193, 123, '_wp_attached_file', '2014/07/Logo_Scarlett.png'); 
INSERT INTO `wp_postmeta` VALUES (1194, 123, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:25:"2014/07/Logo_Scarlett.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"Logo_Scarlett-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"Logo_Scarlett-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"Logo_Scarlett-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"Logo_Scarlett-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"Logo_Scarlett-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1195, 124, '_wp_attached_file', '2014/07/Packshot2.png'); 
INSERT INTO `wp_postmeta` VALUES (1196, 124, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/Packshot2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"Packshot2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"Packshot2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"Packshot2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"Packshot2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"Packshot2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1238, 126, '_edit_lock', '1434102023:2'); 
INSERT INTO `wp_postmeta` VALUES (1198, 125, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1199, 125, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1200, 125, 'block_photos_legende_0_photo_l', '123'); 
INSERT INTO `wp_postmeta` VALUES (1201, 125, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1202, 125, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1203, 125, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1204, 125, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1205, 125, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1206, 125, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1207, 125, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1208, 125, 'block_photos_legende_1_photo_l', '124'); 
INSERT INTO `wp_postmeta` VALUES (1209, 125, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1210, 125, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1211, 125, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1212, 125, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1213, 125, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1214, 125, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1215, 125, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1216, 125, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1217, 125, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1218, 122, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1219, 122, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1220, 122, 'block_photos_legende_0_photo_l', '525'); 
INSERT INTO `wp_postmeta` VALUES (1221, 122, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1222, 122, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1223, 122, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1224, 122, 'block_photos_legende_0_title', 'Cacharel, parfum Scarlett. Dessin typographique. 2005'); 
INSERT INTO `wp_postmeta` VALUES (1225, 122, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1226, 122, 'block_photos_legende_0_subtitle', '• Donner au parfum Scarlett un caractère romantique en harmonie avec l’esprit originel du logo Cacharel.\r\n> La silhouette générale du prénom, la rondeur et le travail sur la graisse des lettres révèlent une jeune fille sans mièvrerie, plus proche de Johansson que d’O’Hara.\r\nD\'après le design conçu par Akroe.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1227, 122, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (19459, 942, 'block_photos_legende_0_subtitle', '• Création d’une identité pour un parfum signé Cathernie Deneuve.\r\n> La versatilité du rythme de la lettre reflète la vivacité et l’élégance de l’actrice. Le caractère lunaire de son visage, photographié par Avedon pour la campagne publicitaire, nous a inspiré le dessin du monogramme.'); 
INSERT INTO `wp_postmeta` VALUES (19456, 942, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (19454, 942, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (19451, 942, 'block_photos_legende_0_photo_l', '527'); 
INSERT INTO `wp_postmeta` VALUES (1236, 122, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1237, 122, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1239, 126, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1240, 127, '_wp_attached_file', '2014/07/Logo_mugler.png'); 
INSERT INTO `wp_postmeta` VALUES (1241, 127, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:23:"2014/07/Logo_mugler.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"Logo_mugler-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"Logo_mugler-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"Logo_mugler-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"Logo_mugler-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"Logo_mugler-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1242, 128, '_wp_attached_file', '2014/07/avant_apres_mugler.png'); 
INSERT INTO `wp_postmeta` VALUES (1243, 128, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:30:"2014/07/avant_apres_mugler.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"avant_apres_mugler-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"avant_apres_mugler-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"avant_apres_mugler-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"avant_apres_mugler-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"avant_apres_mugler-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1244, 129, '_wp_attached_file', '2014/07/photo_mugler.png'); 
INSERT INTO `wp_postmeta` VALUES (1245, 129, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:24:"2014/07/photo_mugler.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"photo_mugler-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"photo_mugler-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"photo_mugler-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"photo_mugler-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"photo_mugler-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1303, 131, '_edit_lock', '1434102158:2'); 
INSERT INTO `wp_postmeta` VALUES (1247, 130, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1248, 130, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1249, 130, 'block_photos_legende_0_photo_l', '127'); 
INSERT INTO `wp_postmeta` VALUES (1250, 130, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1251, 130, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1252, 130, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1253, 130, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1254, 130, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1255, 130, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1256, 130, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1257, 130, 'block_photos_legende_1_photo_l', '128'); 
INSERT INTO `wp_postmeta` VALUES (1258, 130, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1259, 130, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1260, 130, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1261, 130, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1262, 130, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1263, 130, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1264, 130, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1265, 130, 'block_photos_legende_2_photo_l', '129'); 
INSERT INTO `wp_postmeta` VALUES (1266, 130, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1267, 130, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1268, 130, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1269, 130, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1270, 130, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1271, 130, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1272, 130, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1273, 130, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (1274, 130, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1275, 126, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1276, 126, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1277, 126, 'block_photos_legende_0_photo_l', '1094'); 
INSERT INTO `wp_postmeta` VALUES (1278, 126, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1279, 126, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1280, 126, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1281, 126, 'block_photos_legende_0_title', 'Thierry Mugler, mode et parfums. Dessin du logo. 2004'); 
INSERT INTO `wp_postmeta` VALUES (1282, 126, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1283, 126, 'block_photos_legende_0_subtitle', '• Améliorer la lisibilité du logo en parfumerie, compte-tenu des contraintes de merchandising.\r\n> Le dessin du logo a été tendu et profilé pour s’inscrire dans un espace horizontal standardisé.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1284, 126, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1285, 126, 'block_photos_legende_1_photo_l', '1199'); 
INSERT INTO `wp_postmeta` VALUES (1286, 126, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1287, 126, 'block_photos_legende_1_photo_r', '1200'); 
INSERT INTO `wp_postmeta` VALUES (1288, 126, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1289, 126, 'block_photos_legende_1_title', 'Évolution du logo. 2004'); 
INSERT INTO `wp_postmeta` VALUES (1290, 126, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1291, 126, 'block_photos_legende_1_subtitle', '> Le style incisif de la lettre, dessinée d’après la signature du créateur, n’a rien perdu de sa vivacité, mais le tracé a été équilibré et pérennisé.'); 
INSERT INTO `wp_postmeta` VALUES (1292, 126, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (19615, 946, 'block_photos_legende_0_subtitle', '• Lifting de l’identité à l’occasion du lancement de la première ligne de soin Sonia Rykiel.\r\n> Selon le souhait de la créatrice, cette version de sa griffe a été travaillée pour exprimer puissance et stabilité, à contre-pied de son image évanescente.'); 
INSERT INTO `wp_postmeta` VALUES (19614, 946, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (19613, 946, 'block_photos_legende_0_title', 'Design logo & typographie. 1989 (réalisé pour l’Agence Desgrippes)'); 
INSERT INTO `wp_postmeta` VALUES (19612, 946, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (19610, 946, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (19607, 946, 'block_photos_legende_0_photo_l', '745'); 
INSERT INTO `wp_postmeta` VALUES (1301, 126, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1302, 126, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1304, 131, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1305, 132, '_wp_attached_file', '2014/07/logo_rykiel.png'); 
INSERT INTO `wp_postmeta` VALUES (1306, 132, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:23:"2014/07/logo_rykiel.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"logo_rykiel-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"logo_rykiel-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"logo_rykiel-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"logo_rykiel-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"logo_rykiel-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1307, 133, '_wp_attached_file', '2014/07/logo_rykiel1.png'); 
INSERT INTO `wp_postmeta` VALUES (1308, 133, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/logo_rykiel1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"logo_rykiel1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"logo_rykiel1-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"logo_rykiel1-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"logo_rykiel1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"logo_rykiel1-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1309, 134, '_wp_attached_file', '2014/07/portrait.png'); 
INSERT INTO `wp_postmeta` VALUES (1310, 134, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/portrait.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"portrait-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"portrait-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"portrait-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"portrait-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"portrait-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1352, 136, '_edit_lock', '1434029383:2'); 
INSERT INTO `wp_postmeta` VALUES (1312, 135, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1313, 135, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1314, 135, 'block_photos_legende_0_photo_l', '132'); 
INSERT INTO `wp_postmeta` VALUES (1315, 135, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1316, 135, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1317, 135, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1318, 135, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1319, 135, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1320, 135, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1321, 135, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1322, 135, 'block_photos_legende_1_photo_l', '134'); 
INSERT INTO `wp_postmeta` VALUES (1323, 135, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1324, 135, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1325, 135, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1326, 135, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1327, 135, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1328, 135, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1329, 135, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1330, 135, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1331, 135, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1332, 131, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1333, 131, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1334, 131, 'block_photos_legende_0_photo_l', '1092'); 
INSERT INTO `wp_postmeta` VALUES (1335, 131, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1336, 131, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1337, 131, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1338, 131, 'block_photos_legende_0_title', 'Sonia Rykiel, mode et parfums. Dessin typographique. 1989 '); 
INSERT INTO `wp_postmeta` VALUES (1339, 131, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1340, 131, 'block_photos_legende_0_subtitle', '• Lifting de l’identité à l’occasion du lancement de la première ligne de soins Sonia Rykiel.\r\n> Selon le souhait de la créatrice, cette version de sa griffe a été travaillée pour exprimer force et stabilité, à contre-pied de son image évanescente.\r\nProjet réalisé pour l\'agence Desgrippes Gobé & Associés.'); 
INSERT INTO `wp_postmeta` VALUES (1341, 131, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3086, 220, 'block_photos_legende_0_title', 'Logo design & lettering. 2004'); 
INSERT INTO `wp_postmeta` VALUES (3085, 220, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3084, 220, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3083, 220, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3082, 220, 'block_photos_legende_0_photo_l', '127'); 
INSERT INTO `wp_postmeta` VALUES (3081, 220, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3080, 220, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1350, 131, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1351, 131, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1353, 136, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1354, 137, '_wp_attached_file', '2014/07/Jour_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1355, 137, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:21:"2014/07/Jour_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"Jour_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"Jour_logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"Jour_logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"Jour_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"Jour_logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1357, 138, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (1358, 138, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1359, 138, 'block_photos_legende_0_photo_l', '137'); 
INSERT INTO `wp_postmeta` VALUES (1360, 138, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1361, 138, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1362, 138, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1363, 138, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1364, 138, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1365, 138, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1366, 138, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1367, 138, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1368, 138, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1369, 136, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (1370, 136, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1371, 136, 'block_photos_legende_0_photo_l', '2471'); 
INSERT INTO `wp_postmeta` VALUES (1372, 136, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1373, 136, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1374, 136, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1375, 136, 'block_photos_legende_0_title', 'Parfum Jour d\'Hermès. Design du logo. Dessin typographique. 2012'); 
INSERT INTO `wp_postmeta` VALUES (1376, 136, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1377, 136, 'block_photos_legende_0_subtitle', '• Création d’un logo intemporel pour le nouveau grand parfum de la maison Hermès.\r\n> La typographie cursive modelée tout spécialement, traitée à la manière d’un titre littéraire, surgit naturellement, fluide et aérée.\r\n\r\n'); 
INSERT INTO `wp_postmeta` VALUES (1378, 136, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1379, 136, 'block_photos_legende', '6'); 
INSERT INTO `wp_postmeta` VALUES (1380, 136, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (58461, 1820, '_logos_5_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (1383, 141, '_wp_attached_file', '2014/07/logo_sofitel_2.png'); 
INSERT INTO `wp_postmeta` VALUES (1384, 141, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:26:"2014/07/logo_sofitel_2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"logo_sofitel_2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"logo_sofitel_2-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"logo_sofitel_2-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"logo_sofitel_2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"logo_sofitel_2-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1385, 142, '_wp_attached_file', '2014/07/signature_system.png'); 
INSERT INTO `wp_postmeta` VALUES (1386, 142, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:28:"2014/07/signature_system.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"signature_system-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"signature_system-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"signature_system-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"signature_system-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"signature_system-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1387, 143, '_wp_attached_file', '2014/07/metropole.png'); 
INSERT INTO `wp_postmeta` VALUES (1388, 143, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/metropole.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"metropole-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"metropole-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"metropole-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"metropole-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"metropole-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1389, 144, '_wp_attached_file', '2014/07/cataract.png'); 
INSERT INTO `wp_postmeta` VALUES (1390, 144, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:20:"2014/07/cataract.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"cataract-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"cataract-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"cataract-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"cataract-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"cataract-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1391, 145, '_wp_attached_file', '2014/07/the_grand.png'); 
INSERT INTO `wp_postmeta` VALUES (1392, 145, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/the_grand.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"the_grand-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"the_grand-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"the_grand-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"the_grand-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"the_grand-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1482, 147, '_wp_attached_file', '2014/07/stationery_1.png'); 
INSERT INTO `wp_postmeta` VALUES (72050, 2009, '_wp_attached_file', '2014/06/Pierre011.png'); 
INSERT INTO `wp_postmeta` VALUES (72051, 2009, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:559;s:6:"height";i:729;s:4:"file";s:21:"2014/06/Pierre011.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"Pierre011-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"Pierre011-230x300.png";s:5:"width";i:230;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"Pierre011-559x372.png";s:5:"width";i:559;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"Pierre011-559x576.png";s:5:"width";i:559;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (72049, 2008, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (72045, 2008, '_image_texte_1_texte', 'field_546535f076590'); 
INSERT INTO `wp_postmeta` VALUES (72046, 2008, 'image_texte', '2'); 
INSERT INTO `wp_postmeta` VALUES (72047, 2008, '_image_texte', 'field_546535c07658e'); 
INSERT INTO `wp_postmeta` VALUES (72048, 2008, 'footer-text', '© Pierre Katz'); 
INSERT INTO `wp_postmeta` VALUES (58460, 1820, 'logos_5_lien', '1812'); 
INSERT INTO `wp_postmeta` VALUES (58459, 1820, '_logos_5_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58458, 1820, 'logos_5_image', '712'); 
INSERT INTO `wp_postmeta` VALUES (58457, 1820, '_logos_4_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58456, 1820, 'logos_4_lien', '435'); 
INSERT INTO `wp_postmeta` VALUES (58455, 1820, '_logos_4_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58454, 1820, 'logos_4_image', '1817'); 
INSERT INTO `wp_postmeta` VALUES (58452, 1820, 'logos_3_lien', '193'); 
INSERT INTO `wp_postmeta` VALUES (58451, 1820, '_logos_3_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58445, 1820, '_logos_1_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58444, 1820, 'logos_1_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (58443, 1820, '_logos_1_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58442, 1820, 'logos_1_image', '1008'); 
INSERT INTO `wp_postmeta` VALUES (58441, 1820, '_logos_0_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58438, 1820, 'logos_0_image', '1007'); 
INSERT INTO `wp_postmeta` VALUES (58429, 1820, '_baseline-iphone_horizontal', 'field_55075abab3b74'); 
INSERT INTO `wp_postmeta` VALUES (58428, 1820, 'baseline-iphone_horizontal', '1653'); 
INSERT INTO `wp_postmeta` VALUES (58427, 1820, '_baseline-default', 'field_55075a91b3b73'); 
INSERT INTO `wp_postmeta` VALUES (58426, 1820, 'baseline-default', '1639'); 
INSERT INTO `wp_postmeta` VALUES (58425, 1820, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (58424, 1820, 'footer-text', '50, avenue Parmentier 75011 Paris • Tel +33 (0)1 43 38 04 26 • <a href="mailto:contact@pierrekatz.com">contact@pierrekatz.com</a>'); 
INSERT INTO `wp_postmeta` VALUES (58419, 1818, '_logos_22_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58418, 1818, 'logos_22_lien', '1814'); 
INSERT INTO `wp_postmeta` VALUES (58417, 1818, '_logos_22_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58415, 1818, '_logos_21_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58413, 1818, '_logos_21_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58409, 1818, '_logos_20_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58408, 1818, 'logos_20_image', '727'); 
INSERT INTO `wp_postmeta` VALUES (58407, 1818, '_logos_19_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (1483, 147, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:24:"2014/07/stationery_1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"stationery_1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"stationery_1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"stationery_1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"stationery_1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"stationery_1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1484, 148, '_wp_attached_file', '2014/07/stationery_2.png'); 
INSERT INTO `wp_postmeta` VALUES (1485, 148, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:24:"2014/07/stationery_2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"stationery_2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"stationery_2-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"stationery_2-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"stationery_2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"stationery_2-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (57733, 1813, '_block_photos_legende_5_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (72044, 2008, 'image_texte_1_texte', '<a href="http://pierrekatz.com/temp/wp-content/uploads/2014/06/dianealexandre1.jpg"><img class="alignnone wp-image-1274 size-full" src="http://pierrekatz.com/temp/wp-content/uploads/2014/06/dianealexandre1.jpg" alt="" width="510" height="55" /></a><br style="color: #000000;" /><span style="color: #000000;">Diane Alexandre est née en 1983; elle collabore avec Pierre Katz\r\ndepuis 2012.</span>\r\n\r\n&nbsp;\r\n\r\nDiplômée de littérature moderne, elle entre ensuite à l’École nationale supérieure des Arts Décoratifs, puis complète ses études par un master\r\nen communication à Sciences Po Paris.\r\n\r\n&nbsp;\r\n\r\nSoucieuse de comprendre les enjeux marketing en amont des projets,\r\nelle effectue un stage chez L’Oréal, avant de revenir à la création.\r\nS’ouvre alors une période éclectique, pendant laquelle Diane explore une grande variété de domaines d’expression, de l’édition au web design, de\r\nla photographie à la scénographie.\r\n\r\n&nbsp;\r\n\r\nPlus encore que la curiosité naturelle de Diane Alexandre, ce parcours fourmillant traduit l’exigence, la recherche de sens derrière les apparences de la mode ou du design, l’intérêt pour le concept avant le produit, pour\r\nle message en amont de la communication, la démarche intellectuelle au-delà du simple plaisir gestuel...\r\n\r\n&nbsp;\r\n\r\nC’est sur ce terrain que Diane Alexandre et Pierre Katz se rejoignent :\r\nils partagent la même fascination pour les signes, le même enthousiasme\r\nà faire émerger l’identité d’un client, la même abnégation dans la recherche de justesse. Exigence et humilité les caractérisent l’un comme l’autre.\r\n\r\n&nbsp;\r\n\r\nLeur complémentarité est forte, aussi, par le regard neuf que porte Diane Alexandre sur ces marques patrimoniales. En multipliant les sources d’inspiration, en prise directe avec la culture contemporaine, elle contribue\r\nà assurer la pertinence, l’actualité –donc la pérennité– des marques de luxe sur lesquelles elle travaille avec Pierre Katz.'); 
INSERT INTO `wp_postmeta` VALUES (72043, 2008, '_image_texte_1_image_v', 'field_54ff8eb94ab9e'); 
INSERT INTO `wp_postmeta` VALUES (72042, 2008, 'image_texte_1_image_v', '1550'); 
INSERT INTO `wp_postmeta` VALUES (72041, 2008, '_image_texte_1_image_iphone_horizontal', 'field_55077b5f59875'); 
INSERT INTO `wp_postmeta` VALUES (72039, 2008, '_image_texte_1_image', 'field_546535dc7658f'); 
INSERT INTO `wp_postmeta` VALUES (72040, 2008, 'image_texte_1_image_iphone_horizontal', ''); 
INSERT INTO `wp_postmeta` VALUES (72037, 2008, '_image_texte_0_texte', 'field_546535f076590'); 
INSERT INTO `wp_postmeta` VALUES (72038, 2008, 'image_texte_1_image', '2007'); 
INSERT INTO `wp_postmeta` VALUES (58406, 1818, 'logos_19_lien', '563'); 
INSERT INTO `wp_postmeta` VALUES (58405, 1818, '_logos_19_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58403, 1818, '_logos_18_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58401, 1818, '_logos_18_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58400, 1818, 'logos_18_image', '725'); 
INSERT INTO `wp_postmeta` VALUES (58395, 1818, '_logos_16_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (1982, 178, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1981, 178, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (1980, 178, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1979, 178, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1977, 177, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1976, 177, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (57732, 1813, 'block_photos_legende_5_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57730, 1813, 'block_photos_legende_5_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57731, 1813, '_block_photos_legende_5_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (57728, 1813, 'block_photos_legende_5_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57729, 1813, '_block_photos_legende_5_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (57727, 1813, '_block_photos_legende_5_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (57723, 1813, '_block_photos_legende_5_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (57724, 1813, 'block_photos_legende_5_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (57721, 1813, '_block_photos_legende_4_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (57722, 1813, 'block_photos_legende_5_photo_l', '773'); 
INSERT INTO `wp_postmeta` VALUES (57726, 1813, 'block_photos_legende_5_photo_r', '774'); 
INSERT INTO `wp_postmeta` VALUES (57725, 1813, '_block_photos_legende_5_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (57720, 1813, 'block_photos_legende_4_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (57719, 1813, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (57717, 1813, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (57718, 1813, 'block_photos_legende_4_subtitle', '> Chaque logo est retravaillé sur le même principe d’architecture graphique, tout en affirmant sa personnalité géographique et historique.'); 
INSERT INTO `wp_postmeta` VALUES (57716, 1813, 'block_photos_legende_4_title', 'Système graphique des logos d\'hôtels'); 
INSERT INTO `wp_postmeta` VALUES (57715, 1813, '_block_photos_legende_4_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (57713, 1813, '_block_photos_legende_4_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (57714, 1813, 'block_photos_legende_4_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57710, 1813, 'block_photos_legende_4_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57711, 1813, '_block_photos_legende_4_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (57712, 1813, 'block_photos_legende_4_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57709, 1813, '_block_photos_legende_4_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (57708, 1813, 'block_photos_legende_4_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (57707, 1813, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (57706, 1813, 'block_photos_legende_4_photo_r', '592'); 
INSERT INTO `wp_postmeta` VALUES (57705, 1813, '_block_photos_legende_4_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (57702, 1813, 'block_photos_legende_4_photo_l', '590'); 
INSERT INTO `wp_postmeta` VALUES (57703, 1813, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (57704, 1813, 'block_photos_legende_4_photo_m', '591'); 
INSERT INTO `wp_postmeta` VALUES (57701, 1813, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (57700, 1813, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (57699, 1813, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (57698, 1813, 'block_photos_legende_3_subtitle', 'La nouvelle identité propose une simplification du monogramme historique foisonnant et coloré, en conservant les particularismes de la lettre victorienne et de ses ornements arabisants.'); 
INSERT INTO `wp_postmeta` VALUES (57670, 1813, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (57671, 1813, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (57672, 1813, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (1626, 152, '_wp_attached_file', '2014/07/logo_cointreau_1.png'); 
INSERT INTO `wp_postmeta` VALUES (1627, 152, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:28:"2014/07/logo_cointreau_1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"logo_cointreau_1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"logo_cointreau_1-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"logo_cointreau_1-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"logo_cointreau_1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"logo_cointreau_1-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1628, 153, '_wp_attached_file', '2014/07/Cointreau_Noir_image.png'); 
INSERT INTO `wp_postmeta` VALUES (1629, 153, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:32:"2014/07/Cointreau_Noir_image.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:32:"Cointreau_Noir_image-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:32:"Cointreau_Noir_image-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:33:"Cointreau_Noir_image-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:32:"Cointreau_Noir_image-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:33:"Cointreau_Noir_image-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1672, 155, '_edit_lock', '1434645764:2'); 
INSERT INTO `wp_postmeta` VALUES (62602, 1871, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62601, 1871, 'block_photos_legende_3_photo_l', '333'); 
INSERT INTO `wp_postmeta` VALUES (62600, 1871, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62599, 1871, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62598, 1871, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62597, 1871, 'block_photos_legende_2_subtitle', '> All the packaging elements have been redesigned. The label tends to an oval shape, and the neck wrapping has been elongated to create a slimmer impression. Particular attention has been paid to details : the neck is decorated with an embossed emblem, the label is adorned with gold and varnish for more opulence. The combination of different typefaces expresses of the richness of taste.'); 
INSERT INTO `wp_postmeta` VALUES (62596, 1871, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62595, 1871, 'block_photos_legende_2_title', 'Dom Ruinart Blanc de Blancs habillage. 2014'); 
INSERT INTO `wp_postmeta` VALUES (62531, 1870, '_block_photos_legende_5_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62530, 1870, 'block_photos_legende_5_subtitle', '• Pursuing the premiumisation and internationalisation of Lejay Crème de Cassis as a drink list must-have in the US bars and lounges.\r\n> In consistency with the brand heritage, the bottle presents a vintage look and feel inspired by the \'guinguette\' atmosphere of the French 30’s. The shape itself is adapted from a former bottle of the house, and the labels on the face and neck evoke a blazon. The label design itself has been inspired by an ancient engraving dug up from the house’s archives and framed with an ornamental frieze in the 19th century style. The arms of the Dijon city reinforce the historical and regional heritage. The choice of a satinated paper with silver details brings sophistication and brightness.'); 
INSERT INTO `wp_postmeta` VALUES (62529, 1870, '_block_photos_legende_5_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62528, 1870, 'block_photos_legende_5_title', 'Lejay Cassis. 2013'); 
INSERT INTO `wp_postmeta` VALUES (62527, 1870, '_block_photos_legende_5_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62526, 1870, 'block_photos_legende_5_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62525, 1870, '_block_photos_legende_5_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (1673, 155, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1674, 156, '_wp_attached_file', '2014/07/logo_erro.png'); 
INSERT INTO `wp_postmeta` VALUES (1675, 156, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:21:"2014/07/logo_erro.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"logo_erro-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"logo_erro-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"logo_erro-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"logo_erro-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"logo_erro-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1702, 158, '_edit_lock', '1434029815:2'); 
INSERT INTO `wp_postmeta` VALUES (1677, 157, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1678, 157, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1679, 157, 'block_photos_legende_0_photo_l', '156'); 
INSERT INTO `wp_postmeta` VALUES (1680, 157, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1681, 157, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1682, 157, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1683, 157, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1684, 157, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1685, 157, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1686, 157, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1687, 157, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1688, 157, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1689, 155, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1690, 155, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1691, 155, 'block_photos_legende_0_photo_l', '536'); 
INSERT INTO `wp_postmeta` VALUES (1692, 155, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1693, 155, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1694, 155, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1695, 155, 'block_photos_legende_0_title', 'Musée Erró. Design du logo et typographie. 1994'); 
INSERT INTO `wp_postmeta` VALUES (1696, 155, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1697, 155, 'block_photos_legende_0_subtitle', '• L’artiste islandais Erró souhaitait un logo pour la collection permanente dédiée à ses œuvres, au Musée municipal d\'art de Reykjavík.\r\n> Nous lui avons proposé d’utiliser un de ses dessins préparatoires. Une seule contrainte imposée : la reprise du logo du musée, quatre pieux en bois fichés dans le port de la ville, symbolisant la naissance de l’Islande. Ce signe devient ici un cri, une exclamation qui pourrait s’inscrire dans l’une des œuvres de l’artiste.\r\n\r\n         '); 
INSERT INTO `wp_postmeta` VALUES (1698, 155, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1699, 155, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1700, 155, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1703, 158, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1704, 159, '_wp_attached_file', '2014/07/roger_gallet_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1705, 159, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:29:"2014/07/roger_gallet_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"roger_gallet_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"roger_gallet_logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"roger_gallet_logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"roger_gallet_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"roger_gallet_logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1706, 160, '_wp_attached_file', '2014/07/roger_gallet_avant_apres.png'); 
INSERT INTO `wp_postmeta` VALUES (1707, 160, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:36:"2014/07/roger_gallet_avant_apres.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:36:"roger_gallet_avant_apres-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:36:"roger_gallet_avant_apres-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:37:"roger_gallet_avant_apres-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:36:"roger_gallet_avant_apres-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:37:"roger_gallet_avant_apres-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1749, 162, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1709, 161, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1710, 161, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1711, 161, 'block_photos_legende_0_photo_l', '159'); 
INSERT INTO `wp_postmeta` VALUES (1712, 161, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1713, 161, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1714, 161, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1715, 161, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1716, 161, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1717, 161, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1718, 161, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1719, 161, 'block_photos_legende_1_photo_l', '160'); 
INSERT INTO `wp_postmeta` VALUES (1720, 161, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1721, 161, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1722, 161, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1723, 161, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1724, 161, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1725, 161, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1726, 161, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1727, 161, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1728, 161, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1729, 158, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1730, 158, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1731, 158, 'block_photos_legende_0_photo_l', '1100'); 
INSERT INTO `wp_postmeta` VALUES (1732, 158, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1733, 158, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1734, 158, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1735, 158, 'block_photos_legende_0_title', 'Savons et parfums Roger & Gallet. Design du logo. Dessin typographique. 2013'); 
INSERT INTO `wp_postmeta` VALUES (1736, 158, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1737, 158, 'block_photos_legende_0_subtitle', 'Le logo institutionnel de Roger & Gallet est né de la volonté de la marque de se doter d\'une nouvelle signature horizontale pour une meilleure visibilité dans les points de vente et en communication publicitaire.'); 
INSERT INTO `wp_postmeta` VALUES (1738, 158, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1739, 158, 'block_photos_legende_1_photo_l', '1208'); 
INSERT INTO `wp_postmeta` VALUES (1740, 158, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1741, 158, 'block_photos_legende_1_photo_r', '1209'); 
INSERT INTO `wp_postmeta` VALUES (1742, 158, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1743, 158, 'block_photos_legende_1_title', 'Évolution du logo institutionnel. 2013'); 
INSERT INTO `wp_postmeta` VALUES (1744, 158, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1745, 158, 'block_photos_legende_1_subtitle', 'La lettre initiale traduisait bien la personnalité de la marque. L’enjeu consistait à l’exprimer de manière contemporaine tout en conservant son caractère historique. Les lettres ont été redessinées avec une plus grande tension, de nouveaux espacements et un traitement délicat des graisses. La nouvelle signature horizontale permet de conserver une grande présence des signes, même en petite taille.'); 
INSERT INTO `wp_postmeta` VALUES (1746, 158, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1747, 158, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1748, 158, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1750, 162, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1751, 162, 'block_photos_legende_0_photo_l', '159'); 
INSERT INTO `wp_postmeta` VALUES (1752, 162, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1753, 162, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1754, 162, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1755, 162, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1756, 162, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1757, 162, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1758, 162, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1759, 162, 'block_photos_legende_1_photo_l', '160'); 
INSERT INTO `wp_postmeta` VALUES (1760, 162, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1761, 162, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1762, 162, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1763, 162, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1764, 162, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1765, 162, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1766, 162, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1767, 162, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (1768, 162, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1771, 163, '_edit_lock', '1434101899:2'); 
INSERT INTO `wp_postmeta` VALUES (1772, 163, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1773, 164, '_wp_attached_file', '2014/07/bracelet-pompidou2.jpg'); 
INSERT INTO `wp_postmeta` VALUES (1774, 164, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1111;s:6:"height";i:945;s:4:"file";s:30:"2014/07/bracelet-pompidou2.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"bracelet-pompidou2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:30:"bracelet-pompidou2-300x255.jpg";s:5:"width";i:300;s:6:"height";i:255;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:31:"bracelet-pompidou2-1024x870.jpg";s:5:"width";i:1024;s:6:"height";i:870;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"bracelet-pompidou2-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:31:"bracelet-pompidou2-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1775, 165, '_wp_attached_file', '2014/07/bracelet.png'); 
INSERT INTO `wp_postmeta` VALUES (1776, 165, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:20:"2014/07/bracelet.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"bracelet-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"bracelet-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"bracelet-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"bracelet-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:21:"bracelet-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1803, 167, '_edit_lock', '1434101770:2'); 
INSERT INTO `wp_postmeta` VALUES (1778, 166, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1779, 166, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1780, 166, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (1781, 166, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1782, 166, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1783, 166, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1784, 166, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1785, 166, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1786, 166, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1787, 166, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1788, 166, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1789, 166, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1790, 163, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1791, 163, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1792, 163, 'block_photos_legende_0_photo_l', '796'); 
INSERT INTO `wp_postmeta` VALUES (1793, 163, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1794, 163, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1795, 163, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1796, 163, 'block_photos_legende_0_title', 'Les Amis du Centre Pompidou. Design d\'un bracelet. 1995'); 
INSERT INTO `wp_postmeta` VALUES (1797, 163, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1798, 163, 'block_photos_legende_0_subtitle', 'Un bijou né d’un projet d’identité visuelle. Nous avons  développé un logo (d\'après celui du centre dessiné par Jean Widmer) pour l’association des Amis du Centre Pompidou. Cette création a finalement abouti à l’édition d’un bracelet en argent à cinq cents exemplaires, remis aux hôtes de marque du musée.\r\n\r\n\r\n       '); 
INSERT INTO `wp_postmeta` VALUES (1799, 163, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1800, 163, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1801, 163, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1804, 167, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (1805, 168, '_wp_attached_file', '2014/07/lepoint_logo.png'); 
INSERT INTO `wp_postmeta` VALUES (1806, 168, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/lepoint_logo.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"lepoint_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"lepoint_logo-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"lepoint_logo-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"lepoint_logo-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"lepoint_logo-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1834, 170, '_wp_attached_file', '2014/07/rose_oenotheque.png'); 
INSERT INTO `wp_postmeta` VALUES (1808, 169, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1809, 169, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1810, 169, 'block_photos_legende_0_photo_l', '168'); 
INSERT INTO `wp_postmeta` VALUES (1811, 169, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1812, 169, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1813, 169, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1814, 169, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1815, 169, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1816, 169, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1817, 169, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1818, 169, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1819, 169, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1820, 167, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (1821, 167, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1822, 167, 'block_photos_legende_0_photo_l', '798'); 
INSERT INTO `wp_postmeta` VALUES (1823, 167, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1824, 167, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1825, 167, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1826, 167, 'block_photos_legende_0_title', 'Magazine d\'information Le Point. Design du logo. Dessin de la typographie. 2001'); 
INSERT INTO `wp_postmeta` VALUES (1827, 167, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1828, 167, 'block_photos_legende_0_subtitle', '• Actualiser l’identité du magazine Le Point à l’occasion de la refonte de sa maquette, affirmer la force et la rigueur de l’information par un « coup de poing » visuel.\r\n> Un logo dont la simplicité fait la force : un caractère puissant, inspiré des titrages presse, dont la rondeur renforce l’impact et fait entrer Le Point dans l’ère du numérique.\r\n\r\n      \r\n    '); 
INSERT INTO `wp_postmeta` VALUES (1829, 167, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1830, 167, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1831, 167, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1835, 170, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:27:"2014/07/rose_oenotheque.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:27:"rose_oenotheque-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:27:"rose_oenotheque-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:28:"rose_oenotheque-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:27:"rose_oenotheque-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:28:"rose_oenotheque-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1873, 172, '_wp_attached_file', '2014/07/oenotheque.png'); 
INSERT INTO `wp_postmeta` VALUES (66423, 1917, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66422, 1917, 'block_photos_legende_3_photo_l', '354'); 
INSERT INTO `wp_postmeta` VALUES (66421, 1917, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66420, 1917, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66419, 1917, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66418, 1917, 'block_photos_legende_2_subtitle', 'En lieu et place de la simple étiquette blanche marquant les vins provenant de cépages voisins, mais vinifiés et mis en bouteille au château, le nouveau blason permet de marquer l’empreinte «Château de Pommard» tout en apportant un supplément de noblesse aux bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (66417, 1917, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66416, 1917, 'block_photos_legende_2_title', 'Habillages des vins rouges. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66415, 1917, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66414, 1917, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66413, 1917, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66412, 1917, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66411, 1917, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66410, 1917, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66409, 1917, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66408, 1917, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66407, 1917, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66406, 1917, 'block_photos_legende_2_photo_r', '353'); 
INSERT INTO `wp_postmeta` VALUES (66405, 1917, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66404, 1917, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (1874, 172, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/oenotheque.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"oenotheque-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"oenotheque-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"oenotheque-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"oenotheque-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"oenotheque-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (1913, 174, '_wp_attached_file', '2014/07/etiquette_oenotheque1.png'); 
INSERT INTO `wp_postmeta` VALUES (66403, 1917, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66402, 1917, 'block_photos_legende_2_photo_l', '352'); 
INSERT INTO `wp_postmeta` VALUES (66401, 1917, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66400, 1917, 'block_photos_legende_1_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (66399, 1917, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66398, 1917, 'block_photos_legende_1_subtitle', '> Pour donner du relief à la marque, nous avons puisé dans son histoire et réinstallé comme identité visuelle un blason utilisé alors pour le marquage des fûts. \r\nLes lions se sont redressés, les armes sont mises en avant et une nouvelle devise vient orner le blason.'); 
INSERT INTO `wp_postmeta` VALUES (66397, 1917, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66396, 1917, 'block_photos_legende_1_title', 'Évolution des signes'); 
INSERT INTO `wp_postmeta` VALUES (66395, 1917, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66394, 1917, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66393, 1917, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66392, 1917, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66391, 1917, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66390, 1917, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66389, 1917, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66388, 1917, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66387, 1917, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66386, 1917, 'block_photos_legende_1_photo_r', '1605'); 
INSERT INTO `wp_postmeta` VALUES (66385, 1917, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66384, 1917, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (1914, 174, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:33:"2014/07/etiquette_oenotheque1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"etiquette_oenotheque1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:33:"etiquette_oenotheque1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:34:"etiquette_oenotheque1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:33:"etiquette_oenotheque1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:34:"etiquette_oenotheque1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (66383, 1917, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66382, 1917, 'block_photos_legende_1_photo_l', '1604'); 
INSERT INTO `wp_postmeta` VALUES (66381, 1917, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66380, 1917, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66379, 1917, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66378, 1917, 'block_photos_legende_0_subtitle', '• Bringing its full nobility to the Chateau de Pommard estate.\r\n'); 
INSERT INTO `wp_postmeta` VALUES (66377, 1917, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66376, 1917, 'block_photos_legende_0_title', 'Logo design, emblem and typography. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66375, 1917, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66374, 1917, 'block_photos_legende_0_photo_gauche_iphone_v', '1749'); 
INSERT INTO `wp_postmeta` VALUES (66373, 1917, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66372, 1917, 'block_photos_legende_0_photo_gauche_iphone_h', '1748'); 
INSERT INTO `wp_postmeta` VALUES (66371, 1917, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66370, 1917, 'block_photos_legende_0_photo_gauche_ipad_v', '1746'); 
INSERT INTO `wp_postmeta` VALUES (66369, 1917, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66368, 1917, 'block_photos_legende_0_photo_gauche_ipad_h', '1745'); 
INSERT INTO `wp_postmeta` VALUES (66367, 1917, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66366, 1917, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (66365, 1917, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66364, 1917, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (1975, 177, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1974, 177, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1973, 177, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1972, 177, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1971, 177, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1970, 177, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1969, 177, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (1968, 177, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (1967, 177, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (1993, 179, '_wp_attached_file', '2014/07/XO_close_up.png'); 
INSERT INTO `wp_postmeta` VALUES (1966, 177, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (1983, 178, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (1984, 178, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (1985, 178, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (1986, 178, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (1987, 178, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (1988, 178, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (1989, 178, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (1990, 178, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (1994, 179, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:23:"2014/07/XO_close_up.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"XO_close_up-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"XO_close_up-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"XO_close_up-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"XO_close_up-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"XO_close_up-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2040, 181, '_wp_attached_file', '2014/07/saint_aubin.png'); 
INSERT INTO `wp_postmeta` VALUES (62450, 1870, 'block_photos_legende_1_subtitle', '> Instead of the 2 different logos once used for France and international markets, we have rebuilt a single logo with a statutory emblem. The result is a much more premium logo, strengthening the brand’s role in the spirit category whilst keeping its gourmet and friendly personality.'); 
INSERT INTO `wp_postmeta` VALUES (62449, 1870, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62448, 1870, 'block_photos_legende_1_title', 'Visual Identity evolution. 2010'); 
INSERT INTO `wp_postmeta` VALUES (62447, 1870, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62446, 1870, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62445, 1870, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62444, 1870, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62443, 1870, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62442, 1870, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62441, 1870, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62440, 1870, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62439, 1870, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62438, 1870, 'block_photos_legende_1_photo_r', '1189'); 
INSERT INTO `wp_postmeta` VALUES (62437, 1870, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62436, 1870, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62435, 1870, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62434, 1870, 'block_photos_legende_1_photo_l', '1188'); 
INSERT INTO `wp_postmeta` VALUES (62433, 1870, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62432, 1870, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62431, 1870, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62430, 1870, 'block_photos_legende_0_subtitle', '• Upgrading the French fruit liquor to an international brand used as cocktail ingredient all over the world. \r\n> The jay has been inspired by an ancient engraving and redesigned in a realistic, lively manner. Perched on a branch, it crowns the brand name written in Art Nouveau style, with the letter J evoking a bird claw.'); 
INSERT INTO `wp_postmeta` VALUES (2041, 181, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:23:"2014/07/saint_aubin.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"saint_aubin-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"saint_aubin-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"saint_aubin-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"saint_aubin-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"saint_aubin-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2087, 183, '_wp_attached_file', '2014/07/chassagne.png'); 
INSERT INTO `wp_postmeta` VALUES (2043, 182, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2044, 182, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2045, 182, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2046, 182, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2047, 182, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2048, 182, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2049, 182, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2050, 182, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2051, 182, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2052, 182, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2053, 182, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2054, 182, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2055, 182, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2056, 182, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2057, 182, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2058, 182, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2059, 182, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2060, 182, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2061, 182, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2062, 182, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2063, 182, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2064, 182, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2065, 182, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2066, 182, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2067, 182, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2068, 182, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2069, 182, 'block_photos_legende_3_photo_l', '91'); 
INSERT INTO `wp_postmeta` VALUES (2070, 182, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2071, 182, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2072, 182, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2073, 182, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2074, 182, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2075, 182, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2076, 182, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2077, 182, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2078, 182, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2079, 182, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2080, 182, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2081, 182, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2082, 182, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2083, 182, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2084, 182, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2085, 182, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2086, 182, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2088, 183, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/07/chassagne.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"chassagne-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"chassagne-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"chassagne-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"chassagne-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"chassagne-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2134, 185, '_wp_attached_file', '2014/07/chassagne1.png'); 
INSERT INTO `wp_postmeta` VALUES (2090, 184, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2091, 184, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2092, 184, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2093, 184, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2094, 184, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2095, 184, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2096, 184, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2097, 184, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2098, 184, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2099, 184, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2100, 184, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2101, 184, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2102, 184, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2103, 184, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2104, 184, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2105, 184, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2106, 184, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2107, 184, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2108, 184, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2109, 184, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2110, 184, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2111, 184, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2112, 184, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2113, 184, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2114, 184, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2115, 184, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2116, 184, 'block_photos_legende_3_photo_l', '183'); 
INSERT INTO `wp_postmeta` VALUES (2117, 184, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2118, 184, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2119, 184, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2120, 184, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2121, 184, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2122, 184, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2123, 184, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2124, 184, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2125, 184, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2126, 184, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2127, 184, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2128, 184, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2129, 184, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2130, 184, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2131, 184, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2132, 184, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2133, 184, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2135, 185, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/chassagne1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"chassagne1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"chassagne1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"chassagne1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"chassagne1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"chassagne1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2137, 186, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2138, 186, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2139, 186, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2140, 186, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2141, 186, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2142, 186, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2143, 186, 'block_photos_legende_0_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2144, 186, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2145, 186, 'block_photos_legende_0_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2146, 186, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2147, 186, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2148, 186, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2149, 186, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2150, 186, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2151, 186, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2152, 186, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2153, 186, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2154, 186, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2155, 186, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2156, 186, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2157, 186, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2158, 186, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2159, 186, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2160, 186, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2161, 186, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2162, 186, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2163, 186, 'block_photos_legende_3_photo_l', '185'); 
INSERT INTO `wp_postmeta` VALUES (2164, 186, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2165, 186, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2166, 186, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2167, 186, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2168, 186, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2169, 186, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2170, 186, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2171, 186, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2172, 186, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2173, 186, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2174, 186, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2175, 186, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2176, 186, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2177, 186, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2178, 186, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2179, 186, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2180, 186, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2183, 187, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2184, 187, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2185, 187, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (2186, 187, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2187, 187, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2188, 187, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2189, 187, 'block_photos_legende_0_title', 'A. de Fussigny\r\n2001'); 
INSERT INTO `wp_postmeta` VALUES (2190, 187, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2191, 187, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham.\r\nLes couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème \r\nqui vient couronner la marque à la manière d’un blason.\r\nL’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (2192, 187, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2193, 187, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (2194, 187, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2195, 187, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2196, 187, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2197, 187, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2198, 187, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2199, 187, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2200, 187, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2201, 187, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (2202, 187, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2203, 187, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2204, 187, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2205, 187, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2206, 187, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2207, 187, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2208, 187, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2209, 187, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2210, 187, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2285, 190, 'block_photos_legende_1_subtitle', 'Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (2284, 190, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2283, 190, 'block_photos_legende_1_title', 'Logo placing. 2001'); 
INSERT INTO `wp_postmeta` VALUES (2282, 190, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2278, 190, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2279, 190, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (2280, 190, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2281, 190, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2277, 190, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (2276, 190, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2275, 190, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (2274, 190, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2273, 190, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2272, 190, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2271, 190, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (2270, 190, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2269, 190, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2240, 189, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2241, 189, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2242, 189, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (2243, 189, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2244, 189, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2245, 189, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2246, 189, 'block_photos_legende_0_title', 'A. de Fussigny\r\n2001'); 
INSERT INTO `wp_postmeta` VALUES (2247, 189, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2248, 189, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (2249, 189, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2250, 189, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (2251, 189, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2252, 189, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2253, 189, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2254, 189, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2255, 189, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2256, 189, 'block_photos_legende_1_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2257, 189, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2258, 189, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (2259, 189, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2260, 189, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2261, 189, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2262, 189, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2263, 189, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2264, 189, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2265, 189, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2266, 189, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2267, 189, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2286, 190, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2287, 190, 'block_photos_legende_2_photo_l', '77'); 
INSERT INTO `wp_postmeta` VALUES (2288, 190, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2289, 190, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2290, 190, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2291, 190, 'block_photos_legende_2_title', 'à écrire'); 
INSERT INTO `wp_postmeta` VALUES (2292, 190, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2293, 190, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2294, 190, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2295, 190, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2296, 190, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2298, 191, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2299, 191, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2300, 191, 'block_photos_legende_0_photo_l', '123'); 
INSERT INTO `wp_postmeta` VALUES (2301, 191, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2302, 191, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2303, 191, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2304, 191, 'block_photos_legende_0_title', 'Logo design and lettering. 2005'); 
INSERT INTO `wp_postmeta` VALUES (2305, 191, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2306, 191, 'block_photos_legende_0_subtitle', 'Il s’agissait de travailler la physionomie, la graisse et la silhouette générale du nom, pour retrouver l’esprit original du logo Cacharel ; de faire naître du prénom Scarlett des lettres rondes, un caractère : celui d’une jeune fille romantique des années 2000, plus proche de Johansson que d’O’Hara.'); 
INSERT INTO `wp_postmeta` VALUES (2307, 191, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2308, 191, 'block_photos_legende_1_photo_l', '124'); 
INSERT INTO `wp_postmeta` VALUES (2309, 191, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2310, 191, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2311, 191, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2312, 191, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2313, 191, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2314, 191, 'block_photos_legende_1_subtitle', 'à préciser le nom de l\'agence responsable de la créa packaging et de la créa pub.'); 
INSERT INTO `wp_postmeta` VALUES (2315, 191, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2316, 191, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (2317, 191, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (19453, 942, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (4362, 368, '_wp_attached_file', '2014/07/scarlett02.png'); 
INSERT INTO `wp_postmeta` VALUES (4363, 368, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:384;s:6:"height";i:500;s:4:"file";s:22:"2014/07/scarlett02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"scarlett02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"scarlett02-230x300.png";s:5:"width";i:230;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"scarlett02-384x372.png";s:5:"width";i:384;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (4361, 367, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:675;s:6:"height";i:500;s:4:"file";s:22:"2014/07/scarlett01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"scarlett01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:22:"scarlett01-300x222.png";s:5:"width";i:300;s:6:"height";i:222;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"scarlett01-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (4360, 367, '_wp_attached_file', '2014/07/scarlett01.png'); 
INSERT INTO `wp_postmeta` VALUES (2338, 193, '_edit_lock', '1434032986:2'); 
INSERT INTO `wp_postmeta` VALUES (2339, 193, '_edit_last', '2'); 
INSERT INTO `wp_postmeta` VALUES (2340, 194, '_wp_attached_file', '2014/07/logo_deneuve.png'); 
INSERT INTO `wp_postmeta` VALUES (2341, 194, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:24:"2014/07/logo_deneuve.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"logo_deneuve-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"logo_deneuve-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:25:"logo_deneuve-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"logo_deneuve-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"logo_deneuve-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (2343, 195, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2344, 195, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2345, 195, 'block_photos_legende_0_photo_l', '194'); 
INSERT INTO `wp_postmeta` VALUES (2346, 195, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2347, 195, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2348, 195, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2349, 195, 'block_photos_legende_0_title', 'Logo design and lettering. 1990'); 
INSERT INTO `wp_postmeta` VALUES (2350, 195, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2351, 195, 'block_photos_legende_0_subtitle', 'La création de l’identité visuelle du parfum «Catherine Deneuve» partait d’un brief concis : Catherine Deneuve. La versatilité du rythme reflète à la fois la vivacité et l’élégance du personnage.\r\nProjet réalisé dans le cadre d’une précédente activité dans l’agence Desgrippes.'); 
INSERT INTO `wp_postmeta` VALUES (2352, 195, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2353, 195, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2354, 195, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2355, 193, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2356, 193, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2357, 193, 'block_photos_legende_0_photo_l', '1249'); 
INSERT INTO `wp_postmeta` VALUES (2358, 193, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2359, 193, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2360, 193, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2361, 193, 'block_photos_legende_0_title', 'Parfums Cathernie Deneuve. Design du logo. Dessin typographique. 1990 '); 
INSERT INTO `wp_postmeta` VALUES (2362, 193, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2363, 193, 'block_photos_legende_0_subtitle', '• Création d’une identité pour les parfums Catherine Deneuve.\r\n> La versatilité du rythme de la lettre reflète la vivacité et l’élégance de l’actrice. Le caractère lumineux de son visage, photographié par Avedon pour la campagne publicitaire, nous a inspiré le dessin du monogramme.\r\nProjet réalisé pour l\'agence Desgrippes Gobé & Associés.'); 
INSERT INTO `wp_postmeta` VALUES (2364, 193, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2365, 193, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2366, 193, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2402, 198, 'block_photos_legende_0_subtitle', 'Un bijou né d’un projet d’identité visuelle. Nous avons  développé un logo pour l’association des Amis du Centre Pompidou. Cette création a finalement abouti à l’édition d’un bracelet en argent à 500 exemplaires, remis aux hôtes de marque des amis du musée.'); 
INSERT INTO `wp_postmeta` VALUES (2401, 198, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2397, 198, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2398, 198, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2399, 198, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2400, 198, 'block_photos_legende_0_title', 'Design. 1995'); 
INSERT INTO `wp_postmeta` VALUES (2396, 198, 'block_photos_legende_0_photo_l', '165'); 
INSERT INTO `wp_postmeta` VALUES (2395, 198, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2394, 198, 'subtitle_name', 'design'); 
INSERT INTO `wp_postmeta` VALUES (2380, 197, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2381, 197, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2382, 197, 'block_photos_legende_0_photo_l', '194'); 
INSERT INTO `wp_postmeta` VALUES (2383, 197, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2384, 197, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2385, 197, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2386, 197, 'block_photos_legende_0_title', 'Logo design and lettering. 1990'); 
INSERT INTO `wp_postmeta` VALUES (2387, 197, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2388, 197, 'block_photos_legende_0_subtitle', 'La création de l’identité visuelle du parfum «Catherine Deneuve» partait d’un brief concis : Catherine Deneuve. La versatilité du rythme reflète à la fois la vivacité et l’élégance du personnage. Projet réalisé dans le cadre d’une précédente activité dans l’agence Desgrippes.'); 
INSERT INTO `wp_postmeta` VALUES (2389, 197, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2390, 197, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2391, 197, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2403, 198, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2404, 198, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2405, 198, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (14552, 796, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:28:"2014/07/pompidoubracelet.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"pompidoubracelet-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"pompidoubracelet-300x138.jpg";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:29:"pompidoubracelet-1024x474.jpg";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"pompidoubracelet-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:29:"pompidoubracelet-1038x500.jpg";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (14551, 796, '_wp_attached_file', '2014/07/pompidoubracelet.jpg'); 
INSERT INTO `wp_postmeta` VALUES (2876, 214, '_wp_attached_file', '2014/07/avant_apres_RM.png'); 
INSERT INTO `wp_postmeta` VALUES (2419, 200, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2420, 200, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2421, 200, 'block_photos_legende_0_photo_l', '88'); 
INSERT INTO `wp_postmeta` VALUES (2422, 200, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2423, 200, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2424, 200, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2425, 200, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2009'); 
INSERT INTO `wp_postmeta` VALUES (2426, 200, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2427, 200, 'block_photos_legende_0_subtitle', 'La refonte de l’identité du domaine visait à redonner ses armes au château, à transmettre la nature baroque et bonne vivante de la Bourgogne. '); 
INSERT INTO `wp_postmeta` VALUES (2428, 200, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2429, 200, 'block_photos_legende_1_photo_l', '90'); 
INSERT INTO `wp_postmeta` VALUES (2430, 200, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2431, 200, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2432, 200, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2433, 200, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2434, 200, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2435, 200, 'block_photos_legende_1_subtitle', 'Auparavant seule une étiquette  blanche passe-partout marquait les bouteilles des vins provenant de cépages voisins, vinifiés, mis en bouteille et commercialisés au château.'); 
INSERT INTO `wp_postmeta` VALUES (2436, 200, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2437, 200, 'block_photos_legende_2_photo_l', '181'); 
INSERT INTO `wp_postmeta` VALUES (2438, 200, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2439, 200, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2440, 200, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2441, 200, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2442, 200, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2443, 200, 'block_photos_legende_2_subtitle', 'Le nouveau blason permet de marquer l’empreinte du château sans le nommer et de rehausser l’image des bouteilles. '); 
INSERT INTO `wp_postmeta` VALUES (2444, 200, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2445, 200, 'block_photos_legende_3_photo_l', '185'); 
INSERT INTO `wp_postmeta` VALUES (2446, 200, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2447, 200, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2448, 200, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2449, 200, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2450, 200, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2451, 200, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2452, 200, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2453, 200, 'block_photos_legende_4_photo_l', '92'); 
INSERT INTO `wp_postmeta` VALUES (2454, 200, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2455, 200, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2456, 200, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2457, 200, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2458, 200, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2459, 200, 'block_photos_legende_4_subtitle', 'Pour donner du relief à la marque, nous avons puisé dans son histoire et réinstallé comme identité visuelle un blason utilisé alors pour le marquage des fûts. Les lions se sont redressés, les armes sont mises en avant et une nouvelle devise vient orner le blason.'); 
INSERT INTO `wp_postmeta` VALUES (2460, 200, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2461, 200, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2462, 200, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11063, 87, 'block_photos_legende_1_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11065, 87, 'block_photos_legende_2_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11066, 87, '_block_photos_legende_2_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (11077, 676, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (11078, 676, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (11079, 676, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (2464, 201, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2465, 201, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2466, 201, 'block_photos_legende_0_photo_l', '119'); 
INSERT INTO `wp_postmeta` VALUES (2467, 201, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2468, 201, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2469, 201, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2470, 201, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2471, 201, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2472, 201, 'block_photos_legende_0_subtitle', 'Prestigieuse maison de jambon ibérique, la marque, très connue en Espagne, fait partie du patrimoine local. Nous avons apporté de la sophistication à l’identité de ce produit raffiné, en mettant en avant le savoir-faire traditionnel que la marque cultive depuis plus de 100 ans.'); 
INSERT INTO `wp_postmeta` VALUES (2473, 201, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2474, 201, 'block_photos_legende_1_photo_l', '120'); 
INSERT INTO `wp_postmeta` VALUES (2475, 201, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2476, 201, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2477, 201, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2478, 201, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2479, 201, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2480, 201, 'block_photos_legende_1_subtitle', 'De la plaque automobile au label d’excellence gastronomique. La médaille, légère et ouvragée et la scripte énergique, traduisent la finesse du savoir-faire.'); 
INSERT INTO `wp_postmeta` VALUES (2481, 201, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2482, 201, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (2483, 201, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62594, 1871, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62593, 1871, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62592, 1871, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62591, 1871, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62590, 1871, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62588, 1871, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62589, 1871, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62587, 1871, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62586, 1871, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62585, 1871, 'block_photos_legende_2_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (62584, 1871, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62583, 1871, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62582, 1871, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62581, 1871, 'block_photos_legende_2_photo_l', '331'); 
INSERT INTO `wp_postmeta` VALUES (62580, 1871, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66363, 1917, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66362, 1917, 'block_photos_legende_0_photo_l', '1911'); 
INSERT INTO `wp_postmeta` VALUES (66361, 1917, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (66360, 1917, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (66359, 1917, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (66358, 1917, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (66356, 1916, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (66352, 1916, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66353, 1916, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66354, 1916, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66355, 1916, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (66351, 1916, 'block_photos_legende_3_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (66350, 1916, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66349, 1916, 'block_photos_legende_3_title', 'Habillages des vins blancs. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66348, 1916, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66347, 1916, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66342, 1916, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66343, 1916, 'block_photos_legende_3_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66344, 1916, '_block_photos_legende_3_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66345, 1916, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66346, 1916, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66341, 1916, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66340, 1916, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66339, 1916, 'block_photos_legende_3_photo_r', '355'); 
INSERT INTO `wp_postmeta` VALUES (66338, 1916, '_block_photos_legende_3_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66337, 1916, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (66336, 1916, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66332, 1916, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66333, 1916, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66334, 1916, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66335, 1916, 'block_photos_legende_3_photo_l', '354'); 
INSERT INTO `wp_postmeta` VALUES (66331, 1916, 'block_photos_legende_2_subtitle', 'En lieu et place de la simple étiquette blanche marquant les vins provenant de cépages voisins, mais vinifiés et mis en bouteille au château, le nouveau blason permet de marquer l’empreinte «Château de Pommard» tout en apportant un supplément de noblesse aux bouteilles.'); 
INSERT INTO `wp_postmeta` VALUES (66329, 1916, 'block_photos_legende_2_title', 'Habillages des vins rouges. 2009'); 
INSERT INTO `wp_postmeta` VALUES (66330, 1916, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66328, 1916, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66327, 1916, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64903, 1899, 'block_photos_legende_3_photo_r', '334'); 
INSERT INTO `wp_postmeta` VALUES (64904, 1899, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64905, 1899, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64895, 1899, 'block_photos_legende_2_subtitle', '> Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. Un soin particulier a été apporté aux détails : la coiffe est ornée d\'un blason embossé, l\'étiquette se pare de dorures à chaud et de vernis gonflant pour plus d\'opulence. L\'assemblage de différents caractères typographiques participe de l\'expression de la richesse du goût.'); 
INSERT INTO `wp_postmeta` VALUES (64885, 1899, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64886, 1899, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64887, 1899, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64888, 1899, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64876, 1899, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2543, 204, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2544, 204, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2545, 204, 'block_photos_legende_0_photo_l', '156'); 
INSERT INTO `wp_postmeta` VALUES (2546, 204, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2547, 204, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2548, 204, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2549, 204, 'block_photos_legende_0_title', 'Logo design. 1994'); 
INSERT INTO `wp_postmeta` VALUES (2550, 204, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2551, 204, 'block_photos_legende_0_subtitle', 'L’artiste islandais Erró souhaitait un logo pour la collection permanente dédiée à ses œuvres, au musée d’art contemporain de Reykjavík. Nous lui avons proposé d’utiliser un de ses dessins préparatoires. Une seule contrainte était imposée : la reprise du logo du musée, quatre pieux en bois fichés dans le port de la ville, symbolisant la naissance de l’Islande. Ce signe devient ici un cri, une exclamation qui pourrait  s’inscrire dans l’une des œuvres d’Erró.'); 
INSERT INTO `wp_postmeta` VALUES (2552, 204, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2553, 204, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (2554, 204, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2556, 205, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2557, 205, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2558, 205, 'block_photos_legende_0_photo_l', '114'); 
INSERT INTO `wp_postmeta` VALUES (2559, 205, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2560, 205, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2561, 205, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2562, 205, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2010'); 
INSERT INTO `wp_postmeta` VALUES (2563, 205, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2564, 205, 'block_photos_legende_0_subtitle', 'Favarger est la plus ancienne fabrique de chocolat de Genève. La reprise de l’affaire familiale par un nouveau propriétaire marquait le repositionnement luxe de la marque. Le brief était succinct : Genève est la capitale mondiale du luxe, Faverger en sera une institution.'); 
INSERT INTO `wp_postmeta` VALUES (2565, 205, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2566, 205, 'block_photos_legende_1_photo_l', '115'); 
INSERT INTO `wp_postmeta` VALUES (2567, 205, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2568, 205, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2569, 205, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2570, 205, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2571, 205, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2572, 205, 'block_photos_legende_1_subtitle', 'Jusqu’alors l’identité utilisait une scripte suggérant la signature du chocolatier, en accord avec la nature familiale de l’entreprise. La marque change radicalement avec une refonte de ses processus de fabrication, de ses produits et de son image. La mention originelle «chocolats et cacaos» est réintroduite afin de souligner le métier de torréfacteur, que la maison Favarger a su conserver. La nouvelle marque s’ancre désormais dans le patrimoine du luxe genevois. '); 
INSERT INTO `wp_postmeta` VALUES (2573, 205, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2574, 205, 'block_photos_legende_2_photo_l', '116'); 
INSERT INTO `wp_postmeta` VALUES (2575, 205, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2576, 205, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2577, 205, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2578, 205, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2579, 205, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2580, 205, 'block_photos_legende_2_subtitle', 'Revisiter la forme du blason pour en en faire ressortir un cœur, tel un «I love Genève» pour initiés, fut un clin d’oeil bienvenu qui fut par la suite transposé sur les nouvelles tablettes.\r\nLa boutique Favarger est située Quai des Bergues, à quelques pas de l’adresse initiale de la manufacture. Le logo orne le fronton de la façade et circule tous les jours dans les rues de Genève.'); 
INSERT INTO `wp_postmeta` VALUES (2581, 205, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2582, 205, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2583, 205, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (30135, 113, 'block_photos_legende_3_photo_l', '390'); 
INSERT INTO `wp_postmeta` VALUES (30136, 113, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (30137, 113, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (19723, 949, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2585, 207, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2586, 207, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2587, 207, 'block_photos_legende_0_photo_l', '109'); 
INSERT INTO `wp_postmeta` VALUES (2588, 207, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2589, 207, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2590, 207, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2591, 207, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2008'); 
INSERT INTO `wp_postmeta` VALUES (2592, 207, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2593, 207, 'block_photos_legende_0_subtitle', 'La Cuina d’en Garriga est un espace dédié à la gastronomie au centre de Barcelone. La propriétaire y partage sa passion pour les produits authentiques. Le siphon fait partie de son histoire personnelle et de la culture catalane. Nous avons ensuite recherché des caractères évoquant la personnalité du lieu. L’identité associe une lettre aux accents vintage, à une capitale romaine au caractère plus rustique.'); 
INSERT INTO `wp_postmeta` VALUES (2594, 207, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2595, 207, 'block_photos_legende_1_photo_l', '110'); 
INSERT INTO `wp_postmeta` VALUES (2596, 207, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2597, 207, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2598, 207, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2599, 207, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2600, 207, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2601, 207, 'block_photos_legende_1_subtitle', 'Stationery.'); 
INSERT INTO `wp_postmeta` VALUES (2602, 207, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2603, 207, 'block_photos_legende_2_photo_l', '111'); 
INSERT INTO `wp_postmeta` VALUES (2604, 207, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2605, 207, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2606, 207, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2607, 207, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2608, 207, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2609, 207, 'block_photos_legende_2_subtitle', 'Le lieux.'); 
INSERT INTO `wp_postmeta` VALUES (2610, 207, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2611, 207, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2612, 207, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (27481, 1110, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2614, 208, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2615, 208, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2616, 208, 'block_photos_legende_0_photo_l', '137'); 
INSERT INTO `wp_postmeta` VALUES (2617, 208, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2618, 208, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2619, 208, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2620, 208, 'block_photos_legende_0_title', 'Logo design and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2621, 208, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2622, 208, 'block_photos_legende_0_subtitle', 'Pour la création de son nouveau parfum de référence, la maison Hermès souhaitait un logo intemporel. La cursive dessinée pour l’occasion, traitée à la manière d’un titre littéraire, surgit ici, fluide et aérée.'); 
INSERT INTO `wp_postmeta` VALUES (2623, 208, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2624, 208, 'block_photos_legende_1_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (2625, 208, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2626, 208, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2627, 208, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2628, 208, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (2629, 208, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2630, 208, 'block_photos_legende_1_subtitle', 'Dans un second temps, nous avons défini la forme graphique et le placement des éléments, sur le flacon conçu par Pierre Hardy et l’étui pensé par Laurence Hovart. Le logo vient couronner l’ex-libris d’Emile Hermès, le fondateur de la maison. Sur l’étui d’un blanc solaire, il émerge en bas-relief, n’apparaissant que dans un jeu d’ombre et de lumière.'); 
INSERT INTO `wp_postmeta` VALUES (2631, 208, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2632, 208, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (2633, 208, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2634, 136, 'block_photos_legende_1_photo_l', '2468'); 
INSERT INTO `wp_postmeta` VALUES (2635, 136, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2636, 136, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2637, 136, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2638, 136, 'block_photos_legende_1_title', 'Mise en place du logo sur le flacon et sur l\'étui Jour d\'Hermès. 2012'); 
INSERT INTO `wp_postmeta` VALUES (2639, 136, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2640, 136, 'block_photos_legende_1_subtitle', 'Dans un second temps, nous avons défini le placement du logo sur le flacon conçu par Pierre Hardy et l’étui pensé par Laurence Hovart. Le logo vient couronner l’ex-libris d’Emile Hermès, le fondateur de la maison. Sur l’étui d’un blanc solaire, il émerge en bas-relief, n’apparaissant que dans un jeu d’ombre et de lumière.'); 
INSERT INTO `wp_postmeta` VALUES (2641, 136, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2643, 209, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2644, 209, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2645, 209, 'block_photos_legende_0_photo_l', '137'); 
INSERT INTO `wp_postmeta` VALUES (2646, 209, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2647, 209, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2648, 209, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2649, 209, 'block_photos_legende_0_title', 'Jour d\'Hermès. Logo design and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2650, 209, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2651, 209, 'block_photos_legende_0_subtitle', 'Pour la création de son nouveau parfum de référence, la maison Hermès souhaitait un logo intemporel. La cursive dessinée pour l’occasion, traitée à la manière d’un titre littéraire, surgit ici, fluide et aérée.'); 
INSERT INTO `wp_postmeta` VALUES (2652, 209, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2653, 209, 'block_photos_legende_1_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (2654, 209, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2655, 209, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2656, 209, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2657, 209, 'block_photos_legende_1_title', 'Jour d\'Hermès. Logo placing & packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (2658, 209, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2659, 209, 'block_photos_legende_1_subtitle', 'Dans un second temps, nous avons défini la forme graphique et le placement des éléments, sur le flacon conçu par Pierre Hardy et l’étui pensé par Laurence Hovart. Le logo vient couronner l’ex-libris d’Emile Hermès, le fondateur de la maison. Sur l’étui d’un blanc solaire, il émerge en bas-relief, n’apparaissant que dans un jeu d’ombre et de lumière.'); 
INSERT INTO `wp_postmeta` VALUES (2660, 209, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2661, 209, 'block_photos_legende_2_photo_l', ''); 
INSERT INTO `wp_postmeta` VALUES (2662, 209, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2663, 209, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2664, 209, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2665, 209, 'block_photos_legende_2_title', 'Les Classiques. Logo design and lettering. 2014'); 
INSERT INTO `wp_postmeta` VALUES (2666, 209, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2667, 209, 'block_photos_legende_2_subtitle', 'La collection des Classiques Hermès réunit les parfums historiques de la Maison. Ils sont conditionnés dans\r\nun flacon unique, dessiné par Martin Szekely. Le principe de l’étiquette permet de singulariser chaque parfum dans un contenant qui les normalise, grâce à la reprise de l’identité graphique et colorielle de chacun. L’ex-libris d’Emile Hermès, déjà présent sur Eau d’Hermès, parfum originel de la Maison, a été déployé sur l’ensemble de cette collection. Chaque étiquette présente en son verso une vignette surprise, dessinée par Philipe Dumas, patinée de colle et perçue à travers le jus du parfum. '); 
INSERT INTO `wp_postmeta` VALUES (2668, 209, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2669, 209, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (2670, 209, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (18889, 932, 'block_photos_legende_1_title', 'Jour d\'Hermès. Logo placing & packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (18887, 932, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (18888, 932, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (18886, 932, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (18878, 932, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (18879, 932, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (18880, 932, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (18881, 932, 'block_photos_legende_0_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (18882, 932, '_block_photos_legende_0_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (18883, 932, 'block_photos_legende_1_photo_l', '680'); 
INSERT INTO `wp_postmeta` VALUES (18884, 932, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (18885, 932, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64751, 1898, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64750, 1898, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64749, 1898, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64748, 1898, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64747, 1898, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64746, 1898, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64742, 1898, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64743, 1898, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64744, 1898, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64745, 1898, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64741, 1898, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64740, 1898, 'block_photos_legende_1_photo_l', '1132'); 
INSERT INTO `wp_postmeta` VALUES (64739, 1898, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64738, 1898, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64735, 1898, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64736, 1898, 'block_photos_legende_0_subtitle', '• Traduire le caractère patrimonial du fleuron de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (64737, 1898, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64734, 1898, 'block_photos_legende_0_title', 'Design du logo. Dessin de l\'emblème et de la typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (64733, 1898, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64732, 1898, 'block_photos_legende_0_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64728, 1898, 'block_photos_legende_0_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64729, 1898, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64730, 1898, 'block_photos_legende_0_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64731, 1898, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64727, 1898, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64726, 1898, 'block_photos_legende_0_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64725, 1898, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64724, 1898, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64723, 1898, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64722, 1898, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64720, 1898, 'block_photos_legende_0_photo_l', '1041'); 
INSERT INTO `wp_postmeta` VALUES (64721, 1898, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64719, 1898, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (64717, 1898, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (65746, 1909, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (64718, 1898, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (64716, 1898, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (64711, 1897, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (64708, 1897, 'block_photos_legende_2_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64709, 1897, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64710, 1897, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (64707, 1897, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64706, 1897, 'block_photos_legende_2_subtitle', '> Les études packaging ont été réalisées par l\'agence Farnham & Associates.'); 
INSERT INTO `wp_postmeta` VALUES (64705, 1897, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64704, 1897, 'block_photos_legende_2_title', 'Exemples d\'utilisations du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (64695, 1897, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64696, 1897, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64697, 1897, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64698, 1897, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64699, 1897, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64700, 1897, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64701, 1897, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64702, 1897, 'block_photos_legende_2_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64703, 1897, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64694, 1897, 'block_photos_legende_2_photo_r', '321'); 
INSERT INTO `wp_postmeta` VALUES (64693, 1897, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (63002, 1876, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62999, 1876, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (63000, 1876, 'block_photos_legende_1_subtitle', '> The lettering, designed after the fashion designer’s signature, has kept its sharp style, while gaining some balance and timeless character.'); 
INSERT INTO `wp_postmeta` VALUES (62989, 1876, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62990, 1876, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62991, 1876, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62978, 1876, 'block_photos_legende_0_title', 'Logo design. 2004'); 
INSERT INTO `wp_postmeta` VALUES (62979, 1876, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62980, 1876, 'block_photos_legende_0_subtitle', '• Improving the logo legibility on shelves, taking account of the merchandising constraints. \r\n> The logo design has been straighten and outlined in order to correspond to a standard horizontal space.'); 
INSERT INTO `wp_postmeta` VALUES (62971, 1876, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62960, 1876, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (62961, 1876, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62885, 1874, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62886, 1874, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62887, 1874, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62888, 1874, 'block_photos_legende_1_title', 'Labelling and packaging. 200'); 
INSERT INTO `wp_postmeta` VALUES (62889, 1874, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62890, 1874, 'block_photos_legende_1_subtitle', '• Keeping the iconic Cointreau square bottle, magnified with a luxury twist.\r\n> The copper metallic colour of cognac alambics conveys the exclusivity of the product and brings some visibility in night premises.'); 
INSERT INTO `wp_postmeta` VALUES (62891, 1874, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62892, 1874, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62893, 1874, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62894, 1874, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (62895, 1874, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62897, 1875, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (62898, 1875, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62899, 1875, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (62900, 1875, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (62901, 1875, 'block_photos_legende_0_photo_l', '1151'); 
INSERT INTO `wp_postmeta` VALUES (62902, 1875, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62903, 1875, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62904, 1875, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62905, 1875, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62906, 1875, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62907, 1875, 'block_photos_legende_0_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62908, 1875, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62909, 1875, 'block_photos_legende_0_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62910, 1875, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62911, 1875, 'block_photos_legende_0_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62912, 1875, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62913, 1875, 'block_photos_legende_0_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62914, 1875, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62915, 1875, 'block_photos_legende_0_title', 'Logo design and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (62916, 1875, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62917, 1875, 'block_photos_legende_0_subtitle', '• Creating a truly timeless identity for the new fragrance of the Hermès House.\r\n> The cursive typography has been specially created in a very literary manner, in order to add an airy and flowing impression to the steady bottle and pack.'); 
INSERT INTO `wp_postmeta` VALUES (62918, 1875, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62919, 1875, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62920, 1875, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62921, 1875, 'block_photos_legende_1_photo_l', '680'); 
INSERT INTO `wp_postmeta` VALUES (62922, 1875, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62923, 1875, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62924, 1875, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62925, 1875, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62926, 1875, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62927, 1875, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62928, 1875, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62929, 1875, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62930, 1875, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62931, 1875, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62932, 1875, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62933, 1875, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62934, 1875, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62935, 1875, 'block_photos_legende_1_title', 'Logo placement. 2013'); 
INSERT INTO `wp_postmeta` VALUES (62936, 1875, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62937, 1875, 'block_photos_legende_1_subtitle', '> When it came to the logo placement on the bottle designed by Pierre Hardy and on the packaging by Laurence Hovart, we had to work with Emile Hermès’ ex-libris (he was the founder of the house). On the white pack, it stands out embossed, revealed by a play of light and shadows.'); 
INSERT INTO `wp_postmeta` VALUES (62938, 1875, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62939, 1875, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62940, 1875, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62941, 1875, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (62942, 1875, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62943, 1355, 'block_photos_legende_0_photo_gauche_ipad_h', '2473'); 
INSERT INTO `wp_postmeta` VALUES (62944, 1355, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62945, 1355, 'block_photos_legende_0_photo_gauche_ipad_v', '2474'); 
INSERT INTO `wp_postmeta` VALUES (62946, 1355, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62947, 1355, 'block_photos_legende_0_photo_gauche_iphone_h', '2475'); 
INSERT INTO `wp_postmeta` VALUES (62948, 1355, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62949, 1355, 'block_photos_legende_0_photo_gauche_iphone_v', '2476'); 
INSERT INTO `wp_postmeta` VALUES (62950, 1355, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66841, 1923, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62951, 1355, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62952, 1355, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62953, 1355, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (2787, 212, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2788, 212, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2789, 212, 'block_photos_legende_0_photo_l', '63'); 
INSERT INTO `wp_postmeta` VALUES (2790, 212, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2791, 212, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2792, 212, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2793, 212, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (2794, 212, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2795, 212, 'block_photos_legende_0_subtitle', 'Nous avons revisité les signes de la marque Moët & Chandon à l’occasion de la refonte complète de la gamme. L’emblème de Moët est une combinaison de la couronne impériale et de la tiare papale. Il a été redessiné, tout comme le lettrage, dont les pleins et déliés ont été accentués.'); 
INSERT INTO `wp_postmeta` VALUES (2796, 212, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2797, 212, 'block_photos_legende_1_photo_l', '64'); 
INSERT INTO `wp_postmeta` VALUES (2798, 212, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2799, 212, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2800, 212, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2801, 212, 'block_photos_legende_1_title', 'Brut Impérial. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2802, 212, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2803, 212, 'block_photos_legende_1_subtitle', 'L’ensemble de la gamme avec les habillages et leurs couleurs ainsi que la coupe de la cravate emblématique, ont été repensés.'); 
INSERT INTO `wp_postmeta` VALUES (2804, 212, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2805, 212, 'block_photos_legende_2_photo_l', '65'); 
INSERT INTO `wp_postmeta` VALUES (2806, 212, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2807, 212, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2808, 212, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2809, 212, 'block_photos_legende_2_title', 'Millésimé Vintage. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2810, 212, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2811, 212, 'block_photos_legende_2_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (2812, 212, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2813, 212, 'block_photos_legende_3_photo_l', '66'); 
INSERT INTO `wp_postmeta` VALUES (2814, 212, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2815, 212, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2816, 212, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2817, 212, 'block_photos_legende_3_title', 'Grands Crus. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2818, 212, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2819, 212, 'block_photos_legende_3_subtitle', 'L’enjeu était de mettre en avant le savoir-faire œnologique et viticole de la maison en proposant une édition spéciale de grands crus, reprenant les codes des grands vins de Bordeaux.'); 
INSERT INTO `wp_postmeta` VALUES (2820, 212, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2821, 212, 'block_photos_legende_4_photo_l', '67'); 
INSERT INTO `wp_postmeta` VALUES (2822, 212, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2823, 212, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2824, 212, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2825, 212, 'block_photos_legende_4_title', 'Louis Vuitton Cup limited edition. Labelling design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2826, 212, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2827, 212, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (2828, 212, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2829, 212, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2830, 212, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (2832, 213, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2833, 213, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2834, 213, 'block_photos_legende_0_photo_l', '63'); 
INSERT INTO `wp_postmeta` VALUES (2835, 213, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2836, 213, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2837, 213, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2838, 213, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2002'); 
INSERT INTO `wp_postmeta` VALUES (2839, 213, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2840, 213, 'block_photos_legende_0_subtitle', 'Nous avons revisité les signes de la marque Moët & Chandon à l’occasion de la refonte complète de la gamme. L’emblème de Moët est une combinaison de la couronne impériale et de la tiare papale. Il a été redessiné, tout comme le lettrage, dont les pleins et déliés ont été accentués.'); 
INSERT INTO `wp_postmeta` VALUES (2841, 213, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2842, 213, 'block_photos_legende_1_photo_l', '64'); 
INSERT INTO `wp_postmeta` VALUES (2843, 213, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2844, 213, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2845, 213, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2846, 213, 'block_photos_legende_1_title', 'Brut Impérial. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2847, 213, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2848, 213, 'block_photos_legende_1_subtitle', 'L’ensemble de la gamme avec les habillages et leurs couleurs ainsi que la coupe de la cravate emblématique, ont été repensés.'); 
INSERT INTO `wp_postmeta` VALUES (2849, 213, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2850, 213, 'block_photos_legende_2_photo_l', '65'); 
INSERT INTO `wp_postmeta` VALUES (2851, 213, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2852, 213, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2853, 213, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2854, 213, 'block_photos_legende_2_title', 'Millésimé Vintage. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2855, 213, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2856, 213, 'block_photos_legende_2_subtitle', 'L’habillage des Millésimes est plus sombre et plus opulent.'); 
INSERT INTO `wp_postmeta` VALUES (2857, 213, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2858, 213, 'block_photos_legende_3_photo_l', '66'); 
INSERT INTO `wp_postmeta` VALUES (2859, 213, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2860, 213, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2861, 213, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2862, 213, 'block_photos_legende_3_title', 'Grands Crus. Labelling & Packaging design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2863, 213, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2864, 213, 'block_photos_legende_3_subtitle', 'L’enjeu était de mettre en avant le savoir-faire œnologique et viticole de la maison en proposant une édition spéciale de grands crus, reprenant les codes des grands vins de Bordeaux.'); 
INSERT INTO `wp_postmeta` VALUES (2865, 213, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2866, 213, 'block_photos_legende_4_photo_l', '67'); 
INSERT INTO `wp_postmeta` VALUES (2867, 213, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2868, 213, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2869, 213, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2870, 213, 'block_photos_legende_4_title', 'Louis Vuitton Cup limited edition. Labelling design. 2002-2006'); 
INSERT INTO `wp_postmeta` VALUES (2871, 213, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (2872, 213, 'block_photos_legende_4_subtitle', 'Dans le cadre d’un partenariat événementiel avec Louis Vuitton,  la bouteille de Brut Impérial a été habillée aux couleurs de la Louis Vuitton Cup. '); 
INSERT INTO `wp_postmeta` VALUES (2873, 213, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (2874, 213, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (2875, 213, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (19284, 939, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (2877, 214, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/07/avant_apres_RM.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"avant_apres_RM-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"avant_apres_RM-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"avant_apres_RM-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"avant_apres_RM-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"avant_apres_RM-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3151, 223, '_wp_attached_file', '2014/07/logo_lejay1.png'); 
INSERT INTO `wp_postmeta` VALUES (62429, 1870, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62428, 1870, 'block_photos_legende_0_title', 'Logo design, emblem drawing and lettering. 2010'); 
INSERT INTO `wp_postmeta` VALUES (62427, 1870, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62426, 1870, 'block_photos_legende_0_photo_gauche_iphone_v', '1787'); 
INSERT INTO `wp_postmeta` VALUES (62425, 1870, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62424, 1870, 'block_photos_legende_0_photo_gauche_iphone_h', '1786'); 
INSERT INTO `wp_postmeta` VALUES (62422, 1870, 'block_photos_legende_0_photo_gauche_ipad_v', '1785'); 
INSERT INTO `wp_postmeta` VALUES (62423, 1870, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62421, 1870, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62420, 1870, 'block_photos_legende_0_photo_gauche_ipad_h', '1784'); 
INSERT INTO `wp_postmeta` VALUES (62419, 1870, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62418, 1870, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62417, 1870, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62416, 1870, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62415, 1870, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62412, 1870, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (62413, 1870, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (62414, 1870, 'block_photos_legende_0_photo_l', '751'); 
INSERT INTO `wp_postmeta` VALUES (62411, 1870, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (62410, 1870, 'subtitle_name', ''); 
INSERT INTO `wp_postmeta` VALUES (62408, 1869, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (62407, 1869, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (62406, 1869, '_block_photos_legende_3_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62405, 1869, 'block_photos_legende_3_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62404, 1869, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62403, 1869, 'block_photos_legende_3_subtitle', '> This collection presents Dom Pérignon ancient vintages. The black and silver packaging was created under Karl Lagerfeld artistic direction.'); 
INSERT INTO `wp_postmeta` VALUES (62402, 1869, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62401, 1869, 'block_photos_legende_3_title', 'Œnothèque Vintages label. 2008'); 
INSERT INTO `wp_postmeta` VALUES (62399, 1869, 'block_photos_legende_3_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62400, 1869, '_block_photos_legende_3_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62396, 1869, '_block_photos_legende_3_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62397, 1869, 'block_photos_legende_3_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62398, 1869, '_block_photos_legende_3_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62395, 1869, 'block_photos_legende_3_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62394, 1869, '_block_photos_legende_3_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62393, 1869, 'block_photos_legende_3_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62391, 1869, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62392, 1869, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62390, 1869, '_block_photos_legende_3_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62387, 1869, 'block_photos_legende_3_photo_l', '174'); 
INSERT INTO `wp_postmeta` VALUES (62388, 1869, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62389, 1869, 'block_photos_legende_3_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62386, 1869, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62385, 1869, 'block_photos_legende_2_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (62384, 1869, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62381, 1869, 'block_photos_legende_2_title', 'Label evolution. 2003-2007'); 
INSERT INTO `wp_postmeta` VALUES (62382, 1869, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62383, 1869, 'block_photos_legende_2_subtitle', '> All the different typographies have been streamlined. The vine branches and the star have been minutely redesigned. On the top of the label, Moët & Chandon has been replaced with the monk’s name and the date of his appointment at Hautvillers abbey.'); 
INSERT INTO `wp_postmeta` VALUES (62380, 1869, '_block_photos_legende_2_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (60646, 1843, 'actu_2_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60639, 1843, '_actu_1_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60640, 1843, 'actu_1_titre', 'Lejay Cassis'); 
INSERT INTO `wp_postmeta` VALUES (60641, 1843, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60633, 1843, '_actu_0_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60627, 1843, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60628, 1843, 'actu_0_lien', '1348'); 
INSERT INTO `wp_postmeta` VALUES (60610, 1842, 'actu_4_image', '974'); 
INSERT INTO `wp_postmeta` VALUES (60611, 1842, '_actu_4_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60612, 1842, 'actu_4_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60594, 1842, 'actu_2_lien', '118'); 
INSERT INTO `wp_postmeta` VALUES (60595, 1842, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60596, 1842, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60597, 1842, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60580, 1842, 'actu_1_image', '971'); 
INSERT INTO `wp_postmeta` VALUES (60581, 1842, '_actu_1_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60582, 1842, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60570, 1842, 'actu_0_image', '1179'); 
INSERT INTO `wp_postmeta` VALUES (60569, 1841, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (60568, 1841, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (60567, 1841, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (60560, 1841, 'actu_4_lien', '158'); 
INSERT INTO `wp_postmeta` VALUES (60561, 1841, '_actu_4_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60562, 1841, 'actu_4_titre', 'Roger & Gallet'); 
INSERT INTO `wp_postmeta` VALUES (60563, 1841, '_actu_4_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60564, 1841, 'actu_4_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60484, 1840, 'actu_2_image', '972'); 
INSERT INTO `wp_postmeta` VALUES (60485, 1840, '_actu_2_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60486, 1840, 'actu_2_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60487, 1840, '_actu_2_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60488, 1840, 'actu_2_lien', '1374'); 
INSERT INTO `wp_postmeta` VALUES (60489, 1840, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60490, 1840, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60491, 1840, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60492, 1840, 'actu_2_texte', 'Logo design and typography. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60493, 1840, '_actu_2_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60494, 1840, 'actu_3_image', '973'); 
INSERT INTO `wp_postmeta` VALUES (60495, 1840, '_actu_3_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60496, 1840, 'actu_3_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60497, 1840, '_actu_3_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60498, 1840, 'actu_3_lien', '1355'); 
INSERT INTO `wp_postmeta` VALUES (60499, 1840, '_actu_3_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60500, 1840, 'actu_3_titre', 'Jour d\'Hermès'); 
INSERT INTO `wp_postmeta` VALUES (60501, 1840, '_actu_3_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60502, 1840, 'actu_3_texte', 'Logo design and typography. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60503, 1840, '_actu_3_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60504, 1840, 'actu_4_image', '974'); 
INSERT INTO `wp_postmeta` VALUES (60505, 1840, '_actu_4_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60506, 1840, 'actu_4_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60507, 1840, '_actu_4_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60508, 1840, 'actu_4_lien', '1356'); 
INSERT INTO `wp_postmeta` VALUES (60509, 1840, '_actu_4_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60510, 1840, 'actu_4_titre', 'Roger & Gallet'); 
INSERT INTO `wp_postmeta` VALUES (60511, 1840, '_actu_4_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60512, 1840, 'actu_4_texte', 'Logo design and typography. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60513, 1840, '_actu_4_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60514, 1840, 'actu', '5'); 
INSERT INTO `wp_postmeta` VALUES (60515, 1840, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (60516, 1841, 'actu_0_image', '1179'); 
INSERT INTO `wp_postmeta` VALUES (60517, 1841, '_actu_0_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60518, 1841, 'actu_0_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60519, 1841, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60520, 1841, 'actu_0_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (60521, 1841, '_actu_0_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60522, 1841, 'actu_0_titre', 'Dom Ruinart'); 
INSERT INTO `wp_postmeta` VALUES (60523, 1841, '_actu_0_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60524, 1841, 'actu_0_texte', 'Identité visuelle et design packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60525, 1841, '_actu_0_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60526, 1841, 'actu_1_image', '971'); 
INSERT INTO `wp_postmeta` VALUES (60527, 1841, '_actu_1_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60528, 1841, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60529, 1841, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60530, 1841, 'actu_1_lien', '1795'); 
INSERT INTO `wp_postmeta` VALUES (60531, 1841, '_actu_1_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60532, 1841, 'actu_1_titre', 'Lejay Cassis'); 
INSERT INTO `wp_postmeta` VALUES (60533, 1841, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60534, 1841, 'actu_1_texte', 'Identité visuelle et design packaging. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60535, 1841, '_actu_1_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60536, 1841, 'actu_2_image', '972'); 
INSERT INTO `wp_postmeta` VALUES (60537, 1841, '_actu_2_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60538, 1841, 'actu_2_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60539, 1841, '_actu_2_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60540, 1841, 'actu_2_lien', '118'); 
INSERT INTO `wp_postmeta` VALUES (60541, 1841, '_actu_2_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60542, 1841, 'actu_2_titre', 'Cinco Jotas'); 
INSERT INTO `wp_postmeta` VALUES (60543, 1841, '_actu_2_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60544, 1841, 'actu_2_texte', 'Design logo et typographie. 2013'); 
INSERT INTO `wp_postmeta` VALUES (60545, 1841, '_actu_2_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60546, 1841, 'actu_3_image', '973'); 
INSERT INTO `wp_postmeta` VALUES (60547, 1841, '_actu_3_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60548, 1841, 'actu_3_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (60549, 1841, '_actu_3_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (60550, 1841, 'actu_3_lien', '136'); 
INSERT INTO `wp_postmeta` VALUES (60551, 1841, '_actu_3_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (60552, 1841, 'actu_3_titre', 'Jour d\'Hermès'); 
INSERT INTO `wp_postmeta` VALUES (60553, 1841, '_actu_3_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (60554, 1841, 'actu_3_texte', 'Design logo et typographie. 2014'); 
INSERT INTO `wp_postmeta` VALUES (60555, 1841, '_actu_3_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (60556, 1841, 'actu_4_image', '974'); 
INSERT INTO `wp_postmeta` VALUES (60557, 1841, '_actu_4_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (60558, 1841, 'actu_4_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (2993, 217, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (2994, 217, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (2995, 217, 'block_photos_legende_0_photo_l', '159'); 
INSERT INTO `wp_postmeta` VALUES (2996, 217, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (2997, 217, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (2998, 217, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (2999, 217, 'block_photos_legende_0_title', 'Logo design & lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3000, 217, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3001, 217, 'block_photos_legende_0_subtitle', 'Le logo institutionnel de Roger & Gallet est né de la volonté de la marque de se doter d’une signature horizontale et de s’affranchir du macaron des étiquettes utilisé jusqu’alors comme logo institutionnel. Son dessin et sa nouvelle structure lui confèrent une bien meilleure visibilité.'); 
INSERT INTO `wp_postmeta` VALUES (3002, 217, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3003, 217, 'block_photos_legende_1_photo_l', '160'); 
INSERT INTO `wp_postmeta` VALUES (3004, 217, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3005, 217, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3006, 217, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3007, 217, 'block_photos_legende_1_title', 'Logo design before & after. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3008, 217, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3009, 217, 'block_photos_legende_1_subtitle', 'La lettre initiale traduisait bien la personnalité de la marque. L’enjeu consistait à l’exprimer de manière contemporaine tout en conservant son historicité. Les lettres ont été redessinées avec une plus grande tension, de nouveaux espacements et un traitement délicat des graisses. La nouvelle signature horizontale permet ainsi de conserver une grande présence du signe, même en petite taille.'); 
INSERT INTO `wp_postmeta` VALUES (3010, 217, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3011, 217, 'block_photos_legende', '2'); 
INSERT INTO `wp_postmeta` VALUES (3012, 217, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (29621, 1158, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (72036, 2008, 'image_texte_0_texte', '<a href="http://pierrekatz.com/temp/wp-content/uploads/2014/06/Un-artisan-des-signes3.jpg"><img class="alignnone wp-image-1286 size-full" src="http://pierrekatz.com/temp/wp-content/uploads/2014/06/Un-artisan-des-signes3.jpg" alt="Un-artisan-des-signes" width="510" height="55" /></a>\r\n\r\nNé à Paris en 1959, d’une famille cosmopolite, Pierre Katz est fasciné dès\r\nl’enfance par l’expression graphique et ce qu’il nommera plus tard «le\r\nmonde des signes».\r\n\r\n&nbsp;\r\n\r\nSon père médecin collectionneur d’art et sa mère chanteuse lyrique reçoivent de nombreux artistes, et c’est en observant un peintre surréaliste tracer un dessin automatique qu’il perçoit pour la première fois «l’évidence du geste révélateur du sens, comme un prolongement de l’esprit». Dès lors –il a 8 ans– il ne cesse de dessiner, laissant libre cours à son imagination et déliant son trait dans des arabesques fantasmagoriques.\r\n\r\n&nbsp;\r\n\r\nPlus tard, l’amour des lettres canalisera la compulsion du dessin. Lycéen\r\nlatiniste, passionné de littérature, il est particulièrement sensible à l’étymologie, et remontant le fil de l’humanité, se passionne pour l’histoire\r\nde l’imprimerie, de l’écriture, et l’art premier des signes qui symbolisent\r\nle monde sensible, transcrivent l’expérience commune à tous les hommes indépendamment de leur culture.\r\n\r\n&nbsp;\r\n\r\n«Choisir un mot et renforcer sa signification par un graphisme approprié». Pierre Katz se souvient de la consigne de l’épreuve de dessin du baccalauréat car elle l’ouvre au monde de la typographie.\r\nCette discipline, au sens le plus rigoureux du terme, séduit tout à la fois\r\nle littéraire, l’architecte et l’artiste. Il la définit comme «un artisanat\r\nde précision qui impose de maîtriser la forme jusqu’à son aboutissement : l’adéquation parfaite, naturelle et sans fioritures avec le fond».\r\nAlors le dessin s’efface sous la lettre, née d’un équilibre subtil et pourtant\r\nsi affirmée.\r\n\r\n&nbsp;\r\n\r\nDe sa rencontre avec Peter Knapp, directeur artistique du magazine Elle,\r\nà l\'école Penninghen, de la fréquentation des grands typographes français, américains et suisses, à ses débuts chez Carré Noir et Desgrippes, Pierre Katz retient des enseignements mais surtout l’envie de suivre sa propre voie.\r\nAutodidacte en perpétuelle recherche, il collectionne les ouvrages de typographie, explore la calligraphie de l’anglaise à la japonaise, et aborde\r\nla sémiologie, les sciences cognitives et la psychanalyse.\r\n\r\n&nbsp;\r\n\r\nMais Pierre Katz n’est pas un théoricien ni un historien des lettres. Formé\r\nà l’édition et à la signalétique, il conçoit le signe dans son environnement,\r\nen prise avec son époque, et se spécialise dans le dessin de logotypes :\r\n«ce signe qui signe la marque, révèle son identité et sa personnalité avec immédiateté, clarté et permanence». Pas d’égo d’artiste, pas de «patte»\r\nde graphiste : le logo, s’il est réussi, éclipse son dessinateur et perdure sur plusieurs décennies.\r\nQuand il crée une identité de marque ou dessine une étiquette, son approche est esthétique sans être décorative : il s’agit de formaliser du sens, par un sur-mesure qui distille la culture dans l’épure.\r\nCar, comme il aime à le rappeler, «la concision force la précision».\r\n\r\n&nbsp;\r\n\r\nCette vision de son métier, Pierre Katz la partage avec ses clients prestigieux:\r\nles grandes maisons de luxe dont l’exigence de qualité est à la mesure de son travail d’artisan.'); 
INSERT INTO `wp_postmeta` VALUES (72034, 2008, 'image_texte_0_image_v', '1548'); 
INSERT INTO `wp_postmeta` VALUES (72035, 2008, '_image_texte_0_image_v', 'field_54ff8eb94ab9e'); 
INSERT INTO `wp_postmeta` VALUES (72033, 2008, '_image_texte_0_image_iphone_horizontal', 'field_55077b5f59875'); 
INSERT INTO `wp_postmeta` VALUES (72032, 2008, 'image_texte_0_image_iphone_horizontal', '1626'); 
INSERT INTO `wp_postmeta` VALUES (72031, 2008, '_image_texte_0_image', 'field_546535dc7658f'); 
INSERT INTO `wp_postmeta` VALUES (72030, 2008, 'image_texte_0_image', '2006'); 
INSERT INTO `wp_postmeta` VALUES (60121, 1835, '_lifting', 'field_54bf183f767d6'); 
INSERT INTO `wp_postmeta` VALUES (60120, 1835, 'lifting', '11'); 
INSERT INTO `wp_postmeta` VALUES (60119, 1835, '_lifting_10_filet', 'field_54c02c5013597'); 
INSERT INTO `wp_postmeta` VALUES (60118, 1835, 'lifting_10_filet', ''); 
INSERT INTO `wp_postmeta` VALUES (60117, 1835, '_lifting_10_texte', 'field_54bf187f767da'); 
INSERT INTO `wp_postmeta` VALUES (58453, 1820, '_logos_3_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58448, 1820, 'logos_2_lien', '552'); 
INSERT INTO `wp_postmeta` VALUES (58449, 1820, '_logos_2_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58450, 1820, 'logos_3_image', '1010'); 
INSERT INTO `wp_postmeta` VALUES (6133, 457, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (6131, 457, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (6132, 457, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (58377, 1818, '_logos_12_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58396, 1818, 'logos_17_image', '724'); 
INSERT INTO `wp_postmeta` VALUES (58397, 1818, '_logos_17_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (58398, 1818, 'logos_17_lien', '1810'); 
INSERT INTO `wp_postmeta` VALUES (6125, 457, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (6122, 457, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (6123, 457, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (6124, 457, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (58414, 1818, 'logos_21_lien', '1814'); 
INSERT INTO `wp_postmeta` VALUES (58410, 1818, 'logos_20_lien', '1358'); 
INSERT INTO `wp_postmeta` VALUES (58411, 1818, '_logos_20_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (58412, 1818, 'logos_21_image', '728'); 
INSERT INTO `wp_postmeta` VALUES (58402, 1818, 'logos_18_lien', '1356'); 
INSERT INTO `wp_postmeta` VALUES (58399, 1818, '_logos_17_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (3067, 219, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (3068, 219, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3069, 219, 'block_photos_legende_0_photo_l', '132'); 
INSERT INTO `wp_postmeta` VALUES (3070, 219, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3071, 219, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3072, 219, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3073, 219, 'block_photos_legende_0_title', 'Logo design & lettering. 1989'); 
INSERT INTO `wp_postmeta` VALUES (3074, 219, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3075, 219, 'block_photos_legende_0_subtitle', 'L’identité visuelle Sonia Rykiel a été redessinée à l’occasion du lancement de la première ligne de soins de la marque. La créatrice voulait une expression de sa griffe puissante et stable, à contre-pied de sa personnalité évanescente. \r\nProjet réalisé dans le cadre d’une précédente activité dans l’agence Desgrippes.'); 
INSERT INTO `wp_postmeta` VALUES (3076, 219, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3077, 219, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (3078, 219, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (19624, 947, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (3087, 220, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3088, 220, 'block_photos_legende_0_subtitle', 'Pour remédier à un manque de lisibilité et de présence sur les présentoirs de parfumerie, le dessin de la marque a été tendu et profilé pour s’inscrire au mieux à l’horizontale.'); 
INSERT INTO `wp_postmeta` VALUES (3089, 220, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3090, 220, 'block_photos_legende_1_photo_l', '128'); 
INSERT INTO `wp_postmeta` VALUES (3091, 220, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3092, 220, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3093, 220, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3094, 220, 'block_photos_legende_1_title', 'Logo design before & after.'); 
INSERT INTO `wp_postmeta` VALUES (3095, 220, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3096, 220, 'block_photos_legende_1_subtitle', 'La lettre manuscrite a été dessinée d’après la signature du créateur. Le style incisif, presque électrique, de son tracé a été exacerbé.'); 
INSERT INTO `wp_postmeta` VALUES (3097, 220, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3098, 220, 'block_photos_legende_2_photo_l', '129'); 
INSERT INTO `wp_postmeta` VALUES (3099, 220, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3100, 220, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3101, 220, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3102, 220, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3103, 220, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3104, 220, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3105, 220, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3106, 220, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (3107, 220, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3110, 221, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3111, 221, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3112, 221, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3113, 221, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3114, 221, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3115, 221, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3116, 221, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3117, 221, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3118, 221, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3119, 221, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3120, 221, 'block_photos_legende_1_photo_l', '71'); 
INSERT INTO `wp_postmeta` VALUES (3121, 221, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3122, 221, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3123, 221, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3124, 221, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3125, 221, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3126, 221, 'block_photos_legende_1_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé. Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3127, 221, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3128, 221, 'block_photos_legende_2_photo_l', '72'); 
INSERT INTO `wp_postmeta` VALUES (3129, 221, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3130, 221, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3131, 221, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3132, 221, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3133, 221, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3134, 221, 'block_photos_legende_2_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3135, 221, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3136, 221, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (3137, 221, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11140, 35, '_block_photos_legende_2_img_iphone_vert', 'field_541640dbe26fe'); 
INSERT INTO `wp_postmeta` VALUES (3249, 35, 'block_photos_legende_3_photo_l', '333'); 
INSERT INTO `wp_postmeta` VALUES (3250, 35, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3251, 35, 'block_photos_legende_3_photo_r', '334'); 
INSERT INTO `wp_postmeta` VALUES (3139, 222, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (3140, 222, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3141, 222, 'block_photos_legende_0_photo_l', '168'); 
INSERT INTO `wp_postmeta` VALUES (3142, 222, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3143, 222, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3144, 222, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3145, 222, 'block_photos_legende_0_title', 'Logo design & lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (3146, 222, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3147, 222, 'block_photos_legende_0_subtitle', 'La refonte de la maquette du magazine d’information, le Point, fût également l’occasion d’actualiser son logo. Le directeur du journal voulait/ nous a demandé un coup de « poing » visuel. Nous sommes partis d’un caractère puissant tout en conservant la rondeur du poing. Les empattements rappellent la lettre d’imprimerie et les origines de la publication, tout en accompagnant son passage à l’ère numérique. / en accompagnant son évolution dans une nouvelle ère médiatique.'); 
INSERT INTO `wp_postmeta` VALUES (3148, 222, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3149, 222, 'block_photos_legende', '1'); 
INSERT INTO `wp_postmeta` VALUES (3150, 222, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (30304, 1171, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (19923, 953, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3152, 223, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:600;s:4:"file";s:23:"2014/07/logo_lejay1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"logo_lejay1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"logo_lejay1-300x166.png";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"logo_lejay1-1024x568.png";s:5:"width";i:1024;s:6:"height";i:568;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"logo_lejay1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:24:"logo_lejay1-1038x576.png";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3153, 224, '_wp_attached_file', '2014/07/logo_avant_apres1.png'); 
INSERT INTO `wp_postmeta` VALUES (3154, 224, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:29:"2014/07/logo_avant_apres1.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"logo_avant_apres1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"logo_avant_apres1-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"logo_avant_apres1-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"logo_avant_apres1-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"logo_avant_apres1-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3208, 226, '_wp_attached_file', '2014/06/blanc3.png'); 
INSERT INTO `wp_postmeta` VALUES (64692, 1897, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64691, 1897, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64690, 1897, 'block_photos_legende_2_photo_l', '320'); 
INSERT INTO `wp_postmeta` VALUES (64689, 1897, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64688, 1897, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64686, 1897, 'block_photos_legende_1_subtitle', '> Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (64687, 1897, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64685, 1897, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64684, 1897, 'block_photos_legende_1_title', 'Placement du logo. 2001'); 
INSERT INTO `wp_postmeta` VALUES (64683, 1897, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64682, 1897, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64679, 1897, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64680, 1897, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64681, 1897, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64678, 1897, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (64677, 1897, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (64676, 1897, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (64675, 1897, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64674, 1897, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64669, 1897, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (64670, 1897, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (64671, 1897, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64672, 1897, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64673, 1897, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64668, 1897, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (64667, 1897, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (64666, 1897, 'block_photos_legende_0_subtitle', '> Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (64665, 1897, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (64662, 1897, 'block_photos_legende_0_photo_gauche_iphone_v', '1756'); 
INSERT INTO `wp_postmeta` VALUES (64663, 1897, '_block_photos_legende_0_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (64664, 1897, 'block_photos_legende_0_title', 'Design du logo. Dessin de l\'emblème et de la typographie. 2001'); 
INSERT INTO `wp_postmeta` VALUES (64661, 1897, '_block_photos_legende_0_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (64660, 1897, 'block_photos_legende_0_photo_gauche_iphone_h', '1755'); 
INSERT INTO `wp_postmeta` VALUES (64659, 1897, '_block_photos_legende_0_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (64658, 1897, 'block_photos_legende_0_photo_gauche_ipad_v', '1754'); 
INSERT INTO `wp_postmeta` VALUES (64647, 1897, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (64648, 1897, 'images', '0'); 
INSERT INTO `wp_postmeta` VALUES (64649, 1897, '_images', 'field_53f3601c99c3b'); 
INSERT INTO `wp_postmeta` VALUES (64650, 1897, 'block_photos_legende_0_photo_l', '548'); 
INSERT INTO `wp_postmeta` VALUES (64651, 1897, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (64652, 1897, 'block_photos_legende_0_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (64653, 1897, '_block_photos_legende_0_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (64654, 1897, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (64655, 1897, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (64656, 1897, 'block_photos_legende_0_photo_gauche_ipad_h', '1753'); 
INSERT INTO `wp_postmeta` VALUES (64657, 1897, '_block_photos_legende_0_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (65639, 1908, 'subtitle_name', 'visual identity'); 
INSERT INTO `wp_postmeta` VALUES (65640, 1908, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (64643, 1896, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3209, 226, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:18:"2014/06/blanc3.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"blanc3-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"blanc3-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:19:"blanc3-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"blanc3-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:19:"blanc3-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3210, 227, '_wp_attached_file', '2014/06/close_up_blanc.png'); 
INSERT INTO `wp_postmeta` VALUES (3211, 227, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:26:"2014/06/close_up_blanc.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"close_up_blanc-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"close_up_blanc-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"close_up_blanc-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"close_up_blanc-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"close_up_blanc-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3257, 229, '_wp_attached_file', '2014/06/rose3.png'); 
INSERT INTO `wp_postmeta` VALUES (3213, 228, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3214, 228, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3215, 228, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3216, 228, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3217, 228, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3218, 228, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3219, 228, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3220, 228, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3221, 228, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3222, 228, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3223, 228, 'block_photos_legende_1_photo_l', '226'); 
INSERT INTO `wp_postmeta` VALUES (3224, 228, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3225, 228, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3226, 228, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3227, 228, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3228, 228, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3229, 228, 'block_photos_legende_1_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé. Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3230, 228, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3231, 228, 'block_photos_legende_2_photo_l', '227'); 
INSERT INTO `wp_postmeta` VALUES (3232, 228, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3233, 228, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3234, 228, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3235, 228, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3236, 228, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3237, 228, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3238, 228, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3239, 228, 'block_photos_legende_3_photo_l', '72'); 
INSERT INTO `wp_postmeta` VALUES (3240, 228, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3241, 228, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3242, 228, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3243, 228, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3244, 228, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3245, 228, 'block_photos_legende_3_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3246, 228, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3247, 228, 'block_photos_legende', '4'); 
INSERT INTO `wp_postmeta` VALUES (3248, 228, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3252, 35, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3253, 35, 'block_photos_legende_3_title', 'Habillage de Dom Ruinart Rosé. 2014'); 
INSERT INTO `wp_postmeta` VALUES (3254, 35, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3255, 35, 'block_photos_legende_3_subtitle', 'L’ambiance colorielle est crème et or patiné pour le Blanc de Blancs et lie de vin et rose poudré pour le Rosé.'); 
INSERT INTO `wp_postmeta` VALUES (11168, 677, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3256, 35, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3258, 229, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:17:"2014/06/rose3.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"rose3-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"rose3-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:18:"rose3-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"rose3-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"rose3-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3259, 230, '_wp_attached_file', '2014/06/close_up_rose.png'); 
INSERT INTO `wp_postmeta` VALUES (3260, 230, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:25:"2014/06/close_up_rose.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"close_up_rose-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"close_up_rose-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"close_up_rose-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"close_up_rose-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"close_up_rose-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3262, 231, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3263, 231, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3264, 231, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3265, 231, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3266, 231, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3267, 231, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3268, 231, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3269, 231, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3270, 231, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3271, 231, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3272, 231, 'block_photos_legende_1_photo_l', '226'); 
INSERT INTO `wp_postmeta` VALUES (3273, 231, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3274, 231, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3275, 231, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3276, 231, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3277, 231, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3278, 231, 'block_photos_legende_1_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé. Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3279, 231, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3280, 231, 'block_photos_legende_2_photo_l', '227'); 
INSERT INTO `wp_postmeta` VALUES (3281, 231, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3282, 231, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3283, 231, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3284, 231, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3285, 231, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3286, 231, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3287, 231, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3288, 231, 'block_photos_legende_3_photo_l', '229'); 
INSERT INTO `wp_postmeta` VALUES (3289, 231, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3290, 231, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3291, 231, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3292, 231, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3293, 231, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3294, 231, 'block_photos_legende_3_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3295, 231, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3296, 231, 'block_photos_legende_4_photo_l', '230'); 
INSERT INTO `wp_postmeta` VALUES (3297, 231, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3298, 231, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3299, 231, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3300, 231, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3301, 231, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3302, 231, 'block_photos_legende_4_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3303, 231, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3304, 231, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (3305, 231, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11170, 677, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (11169, 677, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (11166, 677, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (3315, 232, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3316, 232, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3317, 232, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3318, 232, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3319, 232, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3320, 232, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3321, 232, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3322, 232, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3323, 232, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3324, 232, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3325, 232, 'block_photos_legende_1_photo_l', '226'); 
INSERT INTO `wp_postmeta` VALUES (3326, 232, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3327, 232, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3328, 232, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3329, 232, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3330, 232, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3331, 232, 'block_photos_legende_1_subtitle', ' Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSERT INTO `wp_postmeta` VALUES (3332, 232, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3333, 232, 'block_photos_legende_2_photo_l', '227'); 
INSERT INTO `wp_postmeta` VALUES (3334, 232, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3335, 232, 'block_photos_legende_2_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3336, 232, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3337, 232, 'block_photos_legende_2_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3338, 232, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3339, 232, 'block_photos_legende_2_subtitle', 'Nous avons entièrement revu les formes de l’habillage des bouteilles. L’étiquette évolue vers l’ovale, la coiffe est rallongée pour élancer le volume du flacon. L’ambiance colorielle est crème et or patiné pour le Blanc de blancs et rose poudré pour le Brut Rosé.'); 
INSERT INTO `wp_postmeta` VALUES (3340, 232, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3341, 232, 'block_photos_legende_3_photo_l', '229'); 
INSERT INTO `wp_postmeta` VALUES (3342, 232, '_block_photos_legende_3_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3343, 232, 'block_photos_legende_3_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3344, 232, '_block_photos_legende_3_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3345, 232, 'block_photos_legende_3_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3346, 232, '_block_photos_legende_3_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3347, 232, 'block_photos_legende_3_subtitle', 'Les deux coffrets affichent les couleurs de l’étiquette et un large tracé, expression graphique de la bouteille. '); 
INSERT INTO `wp_postmeta` VALUES (3348, 232, '_block_photos_legende_3_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3349, 232, 'block_photos_legende_4_photo_l', '230'); 
INSERT INTO `wp_postmeta` VALUES (3350, 232, '_block_photos_legende_4_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3351, 232, 'block_photos_legende_4_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3352, 232, '_block_photos_legende_4_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3353, 232, 'block_photos_legende_4_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3354, 232, '_block_photos_legende_4_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3355, 232, 'block_photos_legende_4_subtitle', 'Le geste se veut contemporain et contraste avec la dimension historique et traditionnelle du champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3356, 232, '_block_photos_legende_4_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3357, 232, 'block_photos_legende', '5'); 
INSERT INTO `wp_postmeta` VALUES (3358, 232, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (11139, 35, 'block_photos_legende_2_img_iphone_vert', ''); 
INSERT INTO `wp_postmeta` VALUES (11167, 677, 'block_photos_legende_1_photo_r', '332'); 
INSERT INTO `wp_postmeta` VALUES (3803, 320, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:500;s:6:"height";i:500;s:4:"file";s:25:"2014/07/fussigny_xo01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"fussigny_xo01-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo01-500x372.png";s:5:"width";i:500;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3802, 320, '_wp_attached_file', '2014/07/fussigny_xo01.png'); 
INSERT INTO `wp_postmeta` VALUES (3411, 251, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:917;s:4:"file";s:24:"2014/06/clients_1080.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"clients_1080-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"clients_1080-300x254.jpg";s:5:"width";i:300;s:6:"height";i:254;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"clients_1080-1024x869.jpg";s:5:"width";i:1024;s:6:"height";i:869;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"clients_1080-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"clients_1080-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3410, 251, '_wp_attached_file', '2014/06/clients_1080.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3399, 250, 'hide_on_screen', 'a:13:{i:0;s:9:"permalink";i:1;s:11:"the_content";i:2;s:7:"excerpt";i:3;s:10:"discussion";i:4;s:8:"comments";i:5;s:9:"revisions";i:6;s:4:"slug";i:7;s:6:"author";i:8;s:6:"format";i:9;s:14:"featured_image";i:10;s:10:"categories";i:11;s:4:"tags";i:12;s:15:"send-trackbacks";}'); 
INSERT INTO `wp_postmeta` VALUES (3400, 250, 'layout', 'default'); 
INSERT INTO `wp_postmeta` VALUES (3401, 250, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (6638, 475, '_wp_attached_file', '2014/06/a.defussigny.png'); 
INSERT INTO `wp_postmeta` VALUES (6639, 475, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:270;s:6:"height";i:180;s:4:"file";s:24:"2014/06/a.defussigny.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"a.defussigny-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (6618, 453, '_edit_lock', '1429627075:1'); 
INSERT INTO `wp_postmeta` VALUES (6619, 473, 'logos', '0'); 
INSERT INTO `wp_postmeta` VALUES (3404, 250, 'field_53d9034952f1f', 'a:11:{s:3:"key";s:19:"field_53d9034952f1f";s:5:"label";s:9:"image 320";s:4:"name";s:9:"image_320";s:4:"type";s:5:"image";s:12:"instructions";s:12:"280 x 280 px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:2:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:4;}'); 
INSERT INTO `wp_postmeta` VALUES (3405, 250, 'field_53d9032c52f1e', 'a:11:{s:3:"key";s:19:"field_53d9032c52f1e";s:5:"label";s:51:"image 480  <span class="help">(441 x 186 px)</span>";s:4:"name";s:9:"image_480";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:3;}'); 
INSERT INTO `wp_postmeta` VALUES (3406, 250, 'field_53d9030152f1d', 'a:11:{s:3:"key";s:19:"field_53d9030152f1d";s:5:"label";s:51:"image_768  <span class="help">(669 x 599 px)</span>";s:4:"name";s:9:"image_768";s:4:"type";s:5:"image";s:12:"instructions";s:0:"";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:2;}'); 
INSERT INTO `wp_postmeta` VALUES (9945, 611, '_wp_page_template', 'page-home.php'); 
INSERT INTO `wp_postmeta` VALUES (59212, 1827, 'baseline-default', '1645'); 
INSERT INTO `wp_postmeta` VALUES (9946, 611, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (7023, 507, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:21:"2014/06/mask_1080.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"mask_1080-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"mask_1080-300x138.png";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:22:"mask_1080-1024x474.png";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"mask_1080-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"mask_1080-1038x500.png";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3408, 250, 'field_53d9028752f1b', 'a:11:{s:3:"key";s:19:"field_53d9028752f1b";s:5:"label";s:10:"image 1080";s:4:"name";s:10:"image_1080";s:4:"type";s:5:"image";s:12:"instructions";s:10:"1080x500px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (3409, 250, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (3412, 252, '_wp_attached_file', '2014/06/clients_1024.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3413, 252, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:2000;s:4:"file";s:24:"2014/06/clients_1024.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"clients_1024-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"clients_1024-153x300.jpg";s:5:"width";i:153;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"clients_1024-524x1024.jpg";s:5:"width";i:524;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"clients_1024-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"clients_1024-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3414, 253, '_wp_attached_file', '2014/06/clients_768.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3415, 253, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:768;s:6:"height";i:2000;s:4:"file";s:23:"2014/06/clients_768.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"clients_768-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"clients_768-115x300.jpg";s:5:"width";i:115;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:24:"clients_768-393x1024.jpg";s:5:"width";i:393;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"clients_768-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"clients_768-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3416, 254, '_wp_attached_file', '2014/06/clients_480.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3417, 254, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:2000;s:4:"file";s:23:"2014/06/clients_480.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"clients_480-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"clients_480-72x300.jpg";s:5:"width";i:72;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:24:"clients_480-245x1024.jpg";s:5:"width";i:245;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"clients_480-480x372.jpg";s:5:"width";i:480;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"clients_480-480x576.jpg";s:5:"width";i:480;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3418, 255, '_wp_attached_file', '2014/06/clients_320.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3419, 255, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:320;s:6:"height";i:2000;s:4:"file";s:23:"2014/06/clients_320.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"clients_320-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"clients_320-48x300.jpg";s:5:"width";i:48;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:24:"clients_320-163x1024.jpg";s:5:"width";i:163;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"clients_320-320x372.jpg";s:5:"width";i:320;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"clients_320-320x576.jpg";s:5:"width";i:320;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3440, 7, 'image_320', ''); 
INSERT INTO `wp_postmeta` VALUES (3423, 257, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3424, 257, 'image_1024', '252'); 
INSERT INTO `wp_postmeta` VALUES (3425, 257, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3426, 257, 'image_768', '253'); 
INSERT INTO `wp_postmeta` VALUES (3427, 257, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3428, 257, 'image_480', '254'); 
INSERT INTO `wp_postmeta` VALUES (3429, 257, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3430, 257, 'image_320', '255'); 
INSERT INTO `wp_postmeta` VALUES (3431, 257, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3432, 7, 'image_1080', ''); 
INSERT INTO `wp_postmeta` VALUES (3433, 7, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3434, 7, 'image_1024', ''); 
INSERT INTO `wp_postmeta` VALUES (3435, 7, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3436, 7, 'image_768', ''); 
INSERT INTO `wp_postmeta` VALUES (3437, 7, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3438, 7, 'image_480', ''); 
INSERT INTO `wp_postmeta` VALUES (3439, 7, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3441, 7, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (5090, 411, '_wp_attached_file', '2014/06/pierre.jpg'); 
INSERT INTO `wp_postmeta` VALUES (5091, 411, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:600;s:6:"height";i:903;s:4:"file";s:18:"2014/06/pierre.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"pierre-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"pierre-199x300.jpg";s:5:"width";i:199;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"pierre-600x372.jpg";s:5:"width";i:600;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:18:"pierre-600x576.jpg";s:5:"width";i:600;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";d:5.2999999999999998;s:6:"credit";s:0:"";s:6:"camera";s:10:"NIKON D300";s:7:"caption";s:0:"";s:17:"created_timestamp";i:1223911641;s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"120";s:3:"iso";i:0;s:13:"shutter_speed";s:5:"0.005";s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (7389, 527, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1080;s:6:"height";i:500;s:4:"file";s:22:"2014/07/Deneuve120.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"Deneuve120-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"Deneuve120-300x138.jpg";s:5:"width";i:300;s:6:"height";i:138;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:23:"Deneuve120-1024x474.jpg";s:5:"width";i:1024;s:6:"height";i:474;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"Deneuve120-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"Deneuve120-1038x500.jpg";s:5:"width";i:1038;s:6:"height";i:500;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (7388, 527, '_wp_attached_file', '2014/07/Deneuve120.jpg'); 
INSERT INTO `wp_postmeta` VALUES (61880, 1865, 'image_iphone_vertical', '1704'); 
INSERT INTO `wp_postmeta` VALUES (61879, 1865, '_image_iphone_horizontal', 'field_5507788aaa2bb'); 
INSERT INTO `wp_postmeta` VALUES (101012, 2633, '_image_iphone_vertical', 'field_54f90f2e2bc12'); 
INSERT INTO `wp_postmeta` VALUES (101013, 2633, 'image_ipad_vertical', '2631'); 
INSERT INTO `wp_postmeta` VALUES (10733, 644, '_wp_attached_file', '2014/06/diane.jpg'); 
INSERT INTO `wp_postmeta` VALUES (10734, 644, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:400;s:6:"height";i:308;s:4:"file";s:17:"2014/06/diane.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"diane-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:17:"diane-300x231.jpg";s:5:"width";i:300;s:6:"height";i:231;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (16714, 859, '_actu_0_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (3489, 280, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:561;s:6:"height";i:500;s:4:"file";s:38:"2014/07/Cointreau_Noir_image_right.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:38:"Cointreau_Noir_image_right-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:38:"Cointreau_Noir_image_right-300x267.jpg";s:5:"width";i:300;s:6:"height";i:267;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:38:"Cointreau_Noir_image_right-561x372.jpg";s:5:"width";i:561;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (61878, 1865, 'image_iphone_horizontal', '1703'); 
INSERT INTO `wp_postmeta` VALUES (7024, 508, 'image_1080', '505'); 
INSERT INTO `wp_postmeta` VALUES (7025, 508, '_image_1080', 'field_53d92e946de9e'); 
INSERT INTO `wp_postmeta` VALUES (7026, 508, 'image_1080_rollover', '507'); 
INSERT INTO `wp_postmeta` VALUES (101007, 2633, 'image', '2257'); 
INSERT INTO `wp_postmeta` VALUES (101008, 2633, '_image', 'field_54bf181befd95'); 
INSERT INTO `wp_postmeta` VALUES (101009, 2633, 'image_iphone_horizontal', '2258'); 
INSERT INTO `wp_postmeta` VALUES (101010, 2633, '_image_iphone_horizontal', 'field_5507788aaa2bb'); 
INSERT INTO `wp_postmeta` VALUES (101011, 2633, 'image_iphone_vertical', '2259'); 
INSERT INTO `wp_postmeta` VALUES (3488, 280, '_wp_attached_file', '2014/07/Cointreau_Noir_image_right.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3482, 279, '_edit_last', '1'); 
INSERT INTO `wp_postmeta` VALUES (61877, 1865, '_image', 'field_54bf181befd95'); 
INSERT INTO `wp_postmeta` VALUES (61876, 1865, 'image', '1709'); 
INSERT INTO `wp_postmeta` VALUES (61881, 1865, '_image_iphone_vertical', 'field_54f90f2e2bc12'); 
INSERT INTO `wp_postmeta` VALUES (61865, 1863, 'logos_25_lien', '800'); 
INSERT INTO `wp_postmeta` VALUES (61866, 1863, '_logos_25_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (61867, 1863, 'logos', '26'); 
INSERT INTO `wp_postmeta` VALUES (61868, 1863, '_logos', 'field_53ffb2ef15ceb'); 
INSERT INTO `wp_postmeta` VALUES (61869, 1863, 'footer-text', '© Pierre Katz. Photo copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (61870, 1863, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (61872, 279, 'field_55247429d2a2a', 'a:11:{s:3:"key";s:19:"field_55247429d2a2a";s:5:"label";s:19:"image ipad vertical";s:4:"name";s:19:"image_ipad_vertical";s:4:"type";s:5:"image";s:12:"instructions";s:14:"1336 x 1263 px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:3:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";s:5:"value";s:0:"";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:3;}'); 
INSERT INTO `wp_postmeta` VALUES (61875, 1864, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1336;s:6:"height";i:1263;s:4:"file";s:24:"2014/06/approach_668.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"approach_668-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"approach_668-300x283.jpg";s:5:"width";i:300;s:6:"height";i:283;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"approach_668-1024x968.jpg";s:5:"width";i:1024;s:6:"height";i:968;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"approach_668-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"approach_668-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (61858, 1863, '_logos_23_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (61859, 1863, 'logos_24_image', '1732'); 
INSERT INTO `wp_postmeta` VALUES (61864, 1863, '_logos_25_image', 'field_53ffb2fd15cec'); 
INSERT INTO `wp_postmeta` VALUES (61863, 1863, 'logos_25_image', '1733'); 
INSERT INTO `wp_postmeta` VALUES (61862, 1863, '_logos_24_lien', 'field_53ffdbd1db836'); 
INSERT INTO `wp_postmeta` VALUES (61861, 1863, 'logos_24_lien', '465'); 
INSERT INTO `wp_postmeta` VALUES (16723, 859, 'actu_1_texte', ''); 
INSERT INTO `wp_postmeta` VALUES (16724, 859, '_actu_1_texte', 'field_547fb49882bc5'); 
INSERT INTO `wp_postmeta` VALUES (16725, 859, 'actu', '2'); 
INSERT INTO `wp_postmeta` VALUES (16726, 859, '_actu', 'field_547d99d8f2b81'); 
INSERT INTO `wp_postmeta` VALUES (16727, 859, 'footer-text', '© Pierre Katz. Photos copyright reserved'); 
INSERT INTO `wp_postmeta` VALUES (16728, 859, '_footer-text', 'field_545fbc462465c'); 
INSERT INTO `wp_postmeta` VALUES (16820, 861, '_edit_lock', '1434029172:2'); 
INSERT INTO `wp_postmeta` VALUES (16722, 859, '_actu_1_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (16715, 859, 'actu_1_image', ''); 
INSERT INTO `wp_postmeta` VALUES (16716, 859, '_actu_1_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (16717, 859, 'actu_1_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (16718, 859, '_actu_1_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (16719, 859, 'actu_1_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (16720, 859, '_actu_1_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (16721, 859, 'actu_1_titre', ''); 
INSERT INTO `wp_postmeta` VALUES (16705, 859, 'actu_0_image', '828'); 
INSERT INTO `wp_postmeta` VALUES (16706, 859, '_actu_0_image', 'field_547d99f0f2b82'); 
INSERT INTO `wp_postmeta` VALUES (16707, 859, 'actu_0_image_verticale', ''); 
INSERT INTO `wp_postmeta` VALUES (16708, 859, '_actu_0_image_verticale', 'field_547d9a0ff2b83'); 
INSERT INTO `wp_postmeta` VALUES (16709, 859, 'actu_0_lien', '35'); 
INSERT INTO `wp_postmeta` VALUES (16710, 859, '_actu_0_lien', 'field_547d9d102aa95'); 
INSERT INTO `wp_postmeta` VALUES (16711, 859, 'actu_0_titre', 'Dom Ruinart'); 
INSERT INTO `wp_postmeta` VALUES (16712, 859, '_actu_0_titre', 'field_547fb49182bc4'); 
INSERT INTO `wp_postmeta` VALUES (10967, 606, 'field_54728f248d747', 'a:11:{s:3:"key";s:19:"field_54728f248d747";s:5:"label";s:19:"image ipad vertical";s:4:"name";s:19:"image_ipad_vertical";s:4:"type";s:5:"image";s:12:"instructions";s:12:"620 x 680 px";s:8:"required";s:1:"0";s:11:"save_format";s:6:"object";s:12:"preview_size";s:9:"thumbnail";s:7:"library";s:3:"all";s:17:"conditional_logic";a:3:{s:6:"status";s:1:"0";s:5:"rules";a:1:{i:0;a:2:{s:5:"field";s:4:"null";s:8:"operator";s:2:"==";}}s:8:"allorany";s:3:"all";}s:8:"order_no";i:4;}'); 
INSERT INTO `wp_postmeta` VALUES (100995, 279, 'rule', 'a:5:{s:5:"param";s:13:"page_template";s:8:"operator";s:2:"==";s:5:"value";s:17:"page-approach.php";s:8:"order_no";i:0;s:8:"group_no";i:0;}'); 
INSERT INTO `wp_postmeta` VALUES (3485, 279, 'position', 'normal'); 
INSERT INTO `wp_postmeta` VALUES (3486, 279, 'layout', 'no_box'); 
INSERT INTO `wp_postmeta` VALUES (3487, 279, 'hide_on_screen', 'a:2:{i:0;s:11:"the_content";i:1;s:14:"featured_image";}'); 
INSERT INTO `wp_postmeta` VALUES (3490, 281, '_wp_attached_file', '2014/07/approach_2_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3491, 281, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_2_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_2_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3492, 282, '_wp_attached_file', '2014/07/approach_0.png'); 
INSERT INTO `wp_postmeta` VALUES (3493, 282, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_0.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_0-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3494, 283, '_wp_attached_file', '2014/07/approach_5_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3495, 283, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_5_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_5_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3496, 284, '_wp_attached_file', '2014/07/approach_1.png'); 
INSERT INTO `wp_postmeta` VALUES (3497, 284, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_1.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_1-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3498, 285, '_wp_attached_file', '2014/07/approach_4_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3499, 285, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_4_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_4_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3500, 286, '_wp_attached_file', '2014/07/approach_4.png'); 
INSERT INTO `wp_postmeta` VALUES (3501, 286, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_4.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_4-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3502, 287, '_wp_attached_file', '2014/07/approach_txt_2.png'); 
INSERT INTO `wp_postmeta` VALUES (3503, 287, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_2.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_2-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3504, 288, '_wp_attached_file', '2014/07/approach_2.png'); 
INSERT INTO `wp_postmeta` VALUES (3505, 288, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_2.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_2-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3506, 289, '_wp_attached_file', '2014/07/approach_0_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3507, 289, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_0_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_0_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3508, 290, '_wp_attached_file', '2014/07/about_portrait.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3509, 290, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:487;s:6:"height";i:600;s:4:"file";s:26:"2014/07/about_portrait.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"about_portrait-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:26:"about_portrait-243x300.jpg";s:5:"width";i:243;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"about_portrait-487x372.jpg";s:5:"width";i:487;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:26:"about_portrait-487x576.jpg";s:5:"width";i:487;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3510, 291, '_wp_attached_file', '2014/07/approach_txt_1.png'); 
INSERT INTO `wp_postmeta` VALUES (3511, 291, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_1.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_1-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3512, 292, '_wp_attached_file', '2014/07/contact_768.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3513, 292, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:768;s:6:"height";i:600;s:4:"file";s:23:"2014/07/contact_768.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"contact_768-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"contact_768-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"contact_768-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:23:"contact_768-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3514, 293, '_wp_attached_file', '2014/07/contact_768_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3515, 293, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:768;s:6:"height";i:600;s:4:"file";s:28:"2014/07/contact_768_roll.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"contact_768_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"contact_768_roll-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"contact_768_roll-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:28:"contact_768_roll-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3516, 294, '_wp_attached_file', '2014/07/approach_5.png'); 
INSERT INTO `wp_postmeta` VALUES (3517, 294, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_5.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_5-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3518, 295, '_wp_attached_file', '2014/07/clients_1024.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3519, 295, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:2000;s:4:"file";s:24:"2014/07/clients_1024.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"clients_1024-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"clients_1024-153x300.jpg";s:5:"width";i:153;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"clients_1024-524x1024.jpg";s:5:"width";i:524;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"clients_1024-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"clients_1024-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3520, 296, '_wp_attached_file', '2014/07/approach_txt_3.png'); 
INSERT INTO `wp_postmeta` VALUES (3521, 296, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_3.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_3-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3522, 297, '_wp_attached_file', '2014/07/contact_1024.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3523, 297, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:600;s:4:"file";s:24:"2014/07/contact_1024.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"contact_1024-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"contact_1024-300x175.jpg";s:5:"width";i:300;s:6:"height";i:175;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"contact_1024-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:25:"contact_1024-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3524, 298, '_wp_attached_file', '2014/07/contact_480_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3525, 298, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:375;s:4:"file";s:28:"2014/07/contact_480_roll.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"contact_480_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"contact_480_roll-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"contact_480_roll-480x372.jpg";s:5:"width";i:480;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3526, 299, '_wp_attached_file', '2014/07/contact_320.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3527, 299, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:320;s:6:"height";i:375;s:4:"file";s:23:"2014/07/contact_320.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"contact_320-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"contact_320-256x300.jpg";s:5:"width";i:256;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"contact_320-320x372.jpg";s:5:"width";i:320;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3528, 300, '_wp_attached_file', '2014/07/approach_3_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3529, 300, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_3_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_3_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3530, 301, '_wp_attached_file', '2014/07/approach_page2.png'); 
INSERT INTO `wp_postmeta` VALUES (3531, 301, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1079;s:6:"height";i:547;s:4:"file";s:26:"2014/07/approach_page2.png";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_page2-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"approach_page2-300x152.png";s:5:"width";i:300;s:6:"height";i:152;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:27:"approach_page2-1024x519.png";s:5:"width";i:1024;s:6:"height";i:519;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:26:"approach_page2-672x372.png";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:27:"approach_page2-1038x547.png";s:5:"width";i:1038;s:6:"height";i:547;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3532, 302, '_wp_attached_file', '2014/07/contact_0.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3533, 302, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1082;s:6:"height";i:600;s:4:"file";s:21:"2014/07/contact_0.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"contact_0-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"contact_0-300x166.jpg";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:22:"contact_0-1024x567.jpg";s:5:"width";i:1024;s:6:"height";i:567;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"contact_0-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:22:"contact_0-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3534, 303, '_wp_attached_file', '2014/07/approach_txt_5.png'); 
INSERT INTO `wp_postmeta` VALUES (3535, 303, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_5.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_5-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3536, 304, '_wp_attached_file', '2014/07/contact_480.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3537, 304, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:375;s:4:"file";s:23:"2014/07/contact_480.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"contact_480-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"contact_480-300x234.jpg";s:5:"width";i:300;s:6:"height";i:234;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"contact_480-480x372.jpg";s:5:"width";i:480;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3538, 305, '_wp_attached_file', '2014/07/approach_txt_4.png'); 
INSERT INTO `wp_postmeta` VALUES (3539, 305, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_4.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_4-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3540, 306, '_wp_attached_file', '2014/07/contact_320_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3541, 306, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:320;s:6:"height";i:375;s:4:"file";s:28:"2014/07/contact_320_roll.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"contact_320_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"contact_320_roll-256x300.jpg";s:5:"width";i:256;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:28:"contact_320_roll-320x372.jpg";s:5:"width";i:320;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3542, 307, '_wp_attached_file', '2014/07/contact.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3543, 307, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1082;s:6:"height";i:600;s:4:"file";s:19:"2014/07/contact.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"contact-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:19:"contact-300x166.jpg";s:5:"width";i:300;s:6:"height";i:166;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:20:"contact-1024x567.jpg";s:5:"width";i:1024;s:6:"height";i:567;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"contact-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:20:"contact-1038x576.jpg";s:5:"width";i:1038;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3544, 308, '_wp_attached_file', '2014/07/approach_1_roll.png'); 
INSERT INTO `wp_postmeta` VALUES (3545, 308, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:27:"2014/07/approach_1_roll.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_1_roll-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3546, 309, '_wp_attached_file', '2014/07/approach_txt_0.png'); 
INSERT INTO `wp_postmeta` VALUES (3547, 309, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:252;s:6:"height";i:100;s:4:"file";s:26:"2014/07/approach_txt_0.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"approach_txt_0-150x100.png";s:5:"width";i:150;s:6:"height";i:100;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3548, 310, '_wp_attached_file', '2014/07/contact_1024_roll.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3549, 310, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1024;s:6:"height";i:600;s:4:"file";s:29:"2014/07/contact_1024_roll.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"contact_1024_roll-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:29:"contact_1024_roll-300x175.jpg";s:5:"width";i:300;s:6:"height";i:175;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"contact_1024_roll-672x372.jpg";s:5:"width";i:672;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}s:25:"twentyfourteen-full-width";a:4:{s:4:"file";s:30:"contact_1024_roll-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3550, 311, '_wp_attached_file', '2014/07/Cointreau_Noir_image_left.jpg'); 
INSERT INTO `wp_postmeta` VALUES (3551, 311, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:500;s:6:"height";i:500;s:4:"file";s:37:"2014/07/Cointreau_Noir_image_left.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:37:"Cointreau_Noir_image_left-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:37:"Cointreau_Noir_image_left-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:37:"Cointreau_Noir_image_left-500x372.jpg";s:5:"width";i:500;s:6:"height";i:372;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3552, 312, '_wp_attached_file', '2014/07/approach_3.png'); 
INSERT INTO `wp_postmeta` VALUES (3553, 312, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:292;s:6:"height";i:38;s:4:"file";s:22:"2014/07/approach_3.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"approach_3-150x38.png";s:5:"width";i:150;s:6:"height";i:38;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3554, 313, 'image_1080', '302'); 
INSERT INTO `wp_postmeta` VALUES (3555, 313, '_image_1080', 'field_53d92e946de9e'); 
INSERT INTO `wp_postmeta` VALUES (3556, 313, 'image_1080_rollover', '307'); 
INSERT INTO `wp_postmeta` VALUES (3557, 313, '_image_1080_rollover', 'field_53d92e9f6de9f'); 
INSERT INTO `wp_postmeta` VALUES (3558, 313, 'image_1024', '297'); 
INSERT INTO `wp_postmeta` VALUES (3559, 313, '_image_1024', 'field_53d92c8386af1'); 
INSERT INTO `wp_postmeta` VALUES (3560, 313, 'image_1024_rollover', '310'); 
INSERT INTO `wp_postmeta` VALUES (3561, 313, '_image_1024_rollover', 'field_53d92ca886af2'); 
INSERT INTO `wp_postmeta` VALUES (3562, 313, 'image_768', ''); 
INSERT INTO `wp_postmeta` VALUES (3563, 313, '_image_768', 'field_53d92cb786af3'); 
INSERT INTO `wp_postmeta` VALUES (3564, 313, 'image_768_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3565, 313, '_image_768_rollover', 'field_53d92cc586af4'); 
INSERT INTO `wp_postmeta` VALUES (3566, 313, 'image_480', ''); 
INSERT INTO `wp_postmeta` VALUES (3567, 313, '_image_480', 'field_53d92cd386af5'); 
INSERT INTO `wp_postmeta` VALUES (3568, 313, 'image_480_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3569, 313, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (3570, 313, 'image_320', ''); 
INSERT INTO `wp_postmeta` VALUES (3571, 313, '_image_320', 'field_53d92cee86af7'); 
INSERT INTO `wp_postmeta` VALUES (3572, 313, 'image_320_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3573, 313, '_image_320_rollover', 'field_53d92cf686af8'); 
INSERT INTO `wp_postmeta` VALUES (3574, 13, 'image_1080', '738'); 
INSERT INTO `wp_postmeta` VALUES (3575, 13, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3576, 13, 'image_1080_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3577, 13, '_image_1080_rollover', 'field_53d92e9f6de9f'); 
INSERT INTO `wp_postmeta` VALUES (3578, 13, 'image_1024', '665'); 
INSERT INTO `wp_postmeta` VALUES (3579, 13, '_image_1024', 'field_546eb148ae4df'); 
INSERT INTO `wp_postmeta` VALUES (3580, 13, 'image_1024_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3581, 13, '_image_1024_rollover', 'field_53d92ca886af2'); 
INSERT INTO `wp_postmeta` VALUES (3582, 13, 'image_768', '671'); 
INSERT INTO `wp_postmeta` VALUES (3583, 13, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3584, 13, 'image_768_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3585, 13, '_image_768_rollover', 'field_53d92cc586af4'); 
INSERT INTO `wp_postmeta` VALUES (3586, 13, 'image_480', ''); 
INSERT INTO `wp_postmeta` VALUES (3587, 13, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3588, 13, 'image_480_rollover', ''); 
INSERT INTO `wp_postmeta` VALUES (3589, 13, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (3590, 13, 'image_320', '1541'); 
INSERT INTO `wp_postmeta` VALUES (3591, 13, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3592, 13, 'image_320_rollover', '600'); 
INSERT INTO `wp_postmeta` VALUES (3593, 13, '_image_320_rollover', 'field_53d92cf686af8'); 
INSERT INTO `wp_postmeta` VALUES (3594, 314, 'image_1080', '302'); 
INSERT INTO `wp_postmeta` VALUES (3595, 314, '_image_1080', 'field_53d92e946de9e'); 
INSERT INTO `wp_postmeta` VALUES (3596, 314, 'image_1080_rollover', '307'); 
INSERT INTO `wp_postmeta` VALUES (3597, 314, '_image_1080_rollover', 'field_53d92e9f6de9f'); 
INSERT INTO `wp_postmeta` VALUES (3598, 314, 'image_1024', '297'); 
INSERT INTO `wp_postmeta` VALUES (3599, 314, '_image_1024', 'field_53d92c8386af1'); 
INSERT INTO `wp_postmeta` VALUES (3600, 314, 'image_1024_rollover', '310'); 
INSERT INTO `wp_postmeta` VALUES (3601, 314, '_image_1024_rollover', 'field_53d92ca886af2'); 
INSERT INTO `wp_postmeta` VALUES (3602, 314, 'image_768', '292'); 
INSERT INTO `wp_postmeta` VALUES (3603, 314, '_image_768', 'field_53d92cb786af3'); 
INSERT INTO `wp_postmeta` VALUES (3604, 314, 'image_768_rollover', '293'); 
INSERT INTO `wp_postmeta` VALUES (3605, 314, '_image_768_rollover', 'field_53d92cc586af4'); 
INSERT INTO `wp_postmeta` VALUES (3606, 314, 'image_480', '304'); 
INSERT INTO `wp_postmeta` VALUES (3607, 314, '_image_480', 'field_53d92cd386af5'); 
INSERT INTO `wp_postmeta` VALUES (3608, 314, 'image_480_rollover', '298'); 
INSERT INTO `wp_postmeta` VALUES (3609, 314, '_image_480_rollover', 'field_53d92ce286af6'); 
INSERT INTO `wp_postmeta` VALUES (3610, 314, 'image_320', '299'); 
INSERT INTO `wp_postmeta` VALUES (3611, 314, '_image_320', 'field_53d92cee86af7'); 
INSERT INTO `wp_postmeta` VALUES (3612, 314, 'image_320_rollover', '306'); 
INSERT INTO `wp_postmeta` VALUES (3613, 314, '_image_320_rollover', 'field_53d92cf686af8'); 
INSERT INTO `wp_postmeta` VALUES (3614, 315, 'vision_0_title', '282'); 
INSERT INTO `wp_postmeta` VALUES (3615, 315, '_vision_0_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3616, 315, 'vision_0_title_rollover', '289'); 
INSERT INTO `wp_postmeta` VALUES (3617, 315, '_vision_0_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3618, 315, 'vision_0_text', '309'); 
INSERT INTO `wp_postmeta` VALUES (3619, 315, '_vision_0_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3620, 315, 'vision_1_title', '284'); 
INSERT INTO `wp_postmeta` VALUES (3621, 315, '_vision_1_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3622, 315, 'vision_1_title_rollover', '308'); 
INSERT INTO `wp_postmeta` VALUES (3623, 315, '_vision_1_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3624, 315, 'vision_1_text', '291'); 
INSERT INTO `wp_postmeta` VALUES (3625, 315, '_vision_1_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3626, 315, 'vision_2_title', '288'); 
INSERT INTO `wp_postmeta` VALUES (3627, 315, '_vision_2_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3628, 315, 'vision_2_title_rollover', '281'); 
INSERT INTO `wp_postmeta` VALUES (3629, 315, '_vision_2_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3630, 315, 'vision_2_text', '287'); 
INSERT INTO `wp_postmeta` VALUES (3631, 315, '_vision_2_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3632, 315, 'vision_3_title', '312'); 
INSERT INTO `wp_postmeta` VALUES (3633, 315, '_vision_3_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3634, 315, 'vision_3_title_rollover', '300'); 
INSERT INTO `wp_postmeta` VALUES (3635, 315, '_vision_3_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3636, 315, 'vision_3_text', '296'); 
INSERT INTO `wp_postmeta` VALUES (3637, 315, '_vision_3_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3638, 315, 'vision_4_title', '286'); 
INSERT INTO `wp_postmeta` VALUES (3639, 315, '_vision_4_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3640, 315, 'vision_4_title_rollover', '285'); 
INSERT INTO `wp_postmeta` VALUES (3641, 315, '_vision_4_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3642, 315, 'vision_4_text', '305'); 
INSERT INTO `wp_postmeta` VALUES (3643, 315, '_vision_4_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3644, 315, 'vision_5_title', '294'); 
INSERT INTO `wp_postmeta` VALUES (3645, 315, '_vision_5_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3646, 315, 'vision_5_title_rollover', '283'); 
INSERT INTO `wp_postmeta` VALUES (3647, 315, '_vision_5_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3648, 315, 'vision_5_text', '303'); 
INSERT INTO `wp_postmeta` VALUES (3649, 315, '_vision_5_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3650, 315, 'vision', '6'); 
INSERT INTO `wp_postmeta` VALUES (3651, 315, '_vision', 'field_53d9a15cbd306'); 
INSERT INTO `wp_postmeta` VALUES (3652, 9, 'vision_0_title', '852'); 
INSERT INTO `wp_postmeta` VALUES (3653, 9, '_vision_0_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3654, 9, 'vision_0_title_rollover', '289'); 
INSERT INTO `wp_postmeta` VALUES (3655, 9, '_vision_0_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3656, 9, 'vision_0_text', '840'); 
INSERT INTO `wp_postmeta` VALUES (3657, 9, '_vision_0_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3658, 9, 'vision_1_title', '651'); 
INSERT INTO `wp_postmeta` VALUES (3659, 9, '_vision_1_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3660, 9, 'vision_1_title_rollover', '308'); 
INSERT INTO `wp_postmeta` VALUES (3661, 9, '_vision_1_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3662, 9, 'vision_1_text', '841'); 
INSERT INTO `wp_postmeta` VALUES (3663, 9, '_vision_1_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3664, 9, 'vision_2_title', '653'); 
INSERT INTO `wp_postmeta` VALUES (3665, 9, '_vision_2_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3666, 9, 'vision_2_title_rollover', '281'); 
INSERT INTO `wp_postmeta` VALUES (3667, 9, '_vision_2_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3668, 9, 'vision_2_text', '842'); 
INSERT INTO `wp_postmeta` VALUES (3669, 9, '_vision_2_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3670, 9, 'vision_3_title', '848'); 
INSERT INTO `wp_postmeta` VALUES (3671, 9, '_vision_3_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3672, 9, 'vision_3_title_rollover', '300'); 
INSERT INTO `wp_postmeta` VALUES (3673, 9, '_vision_3_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3674, 9, 'vision_3_text', '843'); 
INSERT INTO `wp_postmeta` VALUES (3675, 9, '_vision_3_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3676, 9, 'vision_4_title', '849'); 
INSERT INTO `wp_postmeta` VALUES (3677, 9, '_vision_4_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3678, 9, 'vision_4_title_rollover', '285'); 
INSERT INTO `wp_postmeta` VALUES (3679, 9, '_vision_4_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3680, 9, 'vision_4_text', '844'); 
INSERT INTO `wp_postmeta` VALUES (3681, 9, '_vision_4_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3682, 9, 'vision_5_title', '659'); 
INSERT INTO `wp_postmeta` VALUES (3683, 9, '_vision_5_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3684, 9, 'vision_5_title_rollover', '283'); 
INSERT INTO `wp_postmeta` VALUES (3685, 9, '_vision_5_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3686, 9, 'vision_5_text', '845'); 
INSERT INTO `wp_postmeta` VALUES (3687, 9, '_vision_5_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3688, 9, 'vision', '6'); 
INSERT INTO `wp_postmeta` VALUES (3689, 9, '_vision', 'field_53d9a15cbd306'); 
INSERT INTO `wp_postmeta` VALUES (3690, 250, '_edit_lock', '1425609752:1'); 
INSERT INTO `wp_postmeta` VALUES (6620, 473, '_logos', 'field_53ffb2ef15ceb'); 
INSERT INTO `wp_postmeta` VALUES (3693, 316, 'vision_0_title', '282'); 
INSERT INTO `wp_postmeta` VALUES (3694, 316, '_vision_0_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3695, 316, 'vision_0_title_rollover', '289'); 
INSERT INTO `wp_postmeta` VALUES (3696, 316, '_vision_0_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3697, 316, 'vision_0_text', '309'); 
INSERT INTO `wp_postmeta` VALUES (3698, 316, '_vision_0_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3699, 316, 'vision_1_title', '284'); 
INSERT INTO `wp_postmeta` VALUES (3700, 316, '_vision_1_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3701, 316, 'vision_1_title_rollover', '308'); 
INSERT INTO `wp_postmeta` VALUES (3702, 316, '_vision_1_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3703, 316, 'vision_1_text', '291'); 
INSERT INTO `wp_postmeta` VALUES (3704, 316, '_vision_1_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3705, 316, 'vision_2_title', '288'); 
INSERT INTO `wp_postmeta` VALUES (3706, 316, '_vision_2_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3707, 316, 'vision_2_title_rollover', '281'); 
INSERT INTO `wp_postmeta` VALUES (3708, 316, '_vision_2_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3709, 316, 'vision_2_text', '287'); 
INSERT INTO `wp_postmeta` VALUES (3710, 316, '_vision_2_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3711, 316, 'vision_3_title', '312'); 
INSERT INTO `wp_postmeta` VALUES (3712, 316, '_vision_3_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3713, 316, 'vision_3_title_rollover', '300'); 
INSERT INTO `wp_postmeta` VALUES (3714, 316, '_vision_3_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3715, 316, 'vision_3_text', '296'); 
INSERT INTO `wp_postmeta` VALUES (3716, 316, '_vision_3_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3717, 316, 'vision_4_title', '286'); 
INSERT INTO `wp_postmeta` VALUES (3718, 316, '_vision_4_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3719, 316, 'vision_4_title_rollover', '285'); 
INSERT INTO `wp_postmeta` VALUES (3720, 316, '_vision_4_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3721, 316, 'vision_4_text', '305'); 
INSERT INTO `wp_postmeta` VALUES (3722, 316, '_vision_4_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3723, 316, 'vision_5_title', '294'); 
INSERT INTO `wp_postmeta` VALUES (3724, 316, '_vision_5_title', 'field_53d9a19cbd307'); 
INSERT INTO `wp_postmeta` VALUES (3725, 316, 'vision_5_title_rollover', '283'); 
INSERT INTO `wp_postmeta` VALUES (3726, 316, '_vision_5_title_rollover', 'field_53d9a1c4bd308'); 
INSERT INTO `wp_postmeta` VALUES (3727, 316, 'vision_5_text', '303'); 
INSERT INTO `wp_postmeta` VALUES (3728, 316, '_vision_5_text', 'field_53d9a1e2bd309'); 
INSERT INTO `wp_postmeta` VALUES (3729, 316, 'vision', '6'); 
INSERT INTO `wp_postmeta` VALUES (3730, 316, '_vision', 'field_53d9a15cbd306'); 
INSERT INTO `wp_postmeta` VALUES (3731, 316, 'image_1080', '301'); 
INSERT INTO `wp_postmeta` VALUES (3732, 316, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3733, 316, 'image_1024', '301'); 
INSERT INTO `wp_postmeta` VALUES (3734, 316, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3735, 316, 'image_768', '301'); 
INSERT INTO `wp_postmeta` VALUES (3736, 316, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3737, 316, 'image_480', '301'); 
INSERT INTO `wp_postmeta` VALUES (3738, 316, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3739, 316, 'image_320', '301'); 
INSERT INTO `wp_postmeta` VALUES (3740, 316, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3741, 9, 'image_1080', '455'); 
INSERT INTO `wp_postmeta` VALUES (3742, 9, '_image_1080', 'field_53d9028752f1b'); 
INSERT INTO `wp_postmeta` VALUES (3743, 9, 'image_1024', '301'); 
INSERT INTO `wp_postmeta` VALUES (3744, 9, '_image_1024', 'field_53d902f252f1c'); 
INSERT INTO `wp_postmeta` VALUES (3745, 9, 'image_768', '301'); 
INSERT INTO `wp_postmeta` VALUES (3746, 9, '_image_768', 'field_53d9030152f1d'); 
INSERT INTO `wp_postmeta` VALUES (3747, 9, 'image_480', '301'); 
INSERT INTO `wp_postmeta` VALUES (3748, 9, '_image_480', 'field_53d9032c52f1e'); 
INSERT INTO `wp_postmeta` VALUES (3749, 9, 'image_320', '301'); 
INSERT INTO `wp_postmeta` VALUES (3750, 9, '_image_320', 'field_53d9034952f1f'); 
INSERT INTO `wp_postmeta` VALUES (3751, 279, '_edit_lock', '1431106340:1'); 
INSERT INTO `wp_postmeta` VALUES (43764, 1541, '_wp_attached_file', '2014/06/contact_280.jpg'); 
INSERT INTO `wp_postmeta` VALUES (62579, 1871, 'block_photos_legende_1_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62578, 1871, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62577, 1871, 'block_photos_legende_1_subtitle', '• Bringing some elegance and a contemporary touch to the  giftbox, contrasting with the brand’s historical features.\r\n> The giftbox dimensions have been amended with a side opening and elegant fasteners. Each box is matching the corresponding label, with the contemporary outline of the bottle contrasting with the traditional champagne features.\r\n> Frederic Panaïotis, Ruinart chef de caves says: “We are really pleased with the new packaging for the Dom Ruinart Blanc de Blancs. The lighter and softer labels are more illustrative of the elegant Chardonnay style and support Dom Ruinart’s positioning as the ultimate expression of Blanc de Blancs.”'); 
INSERT INTO `wp_postmeta` VALUES (62576, 1871, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (62575, 1871, 'block_photos_legende_1_title', 'Dom Ruinart Blanc de Blancs and Rosé giftboxes. 2014'); 
INSERT INTO `wp_postmeta` VALUES (62574, 1871, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (62573, 1871, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (62572, 1871, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (62571, 1871, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62570, 1871, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (62569, 1871, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (3861, 326, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:663;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_01-300x226.png";s:5:"width";i:300;s:6:"height";i:226;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_01-663x372.png";s:5:"width";i:663;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3804, 321, '_wp_attached_file', '2014/07/fussigny_xo02.png'); 
INSERT INTO `wp_postmeta` VALUES (3805, 321, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:560;s:6:"height";i:500;s:4:"file";s:25:"2014/07/fussigny_xo02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"fussigny_xo02-300x267.png";s:5:"width";i:300;s:6:"height";i:267;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:25:"fussigny_xo02-560x372.png";s:5:"width";i:560;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3835, 323, '_wp_attached_file', '2014/07/cointreau_01.png'); 
INSERT INTO `wp_postmeta` VALUES (3807, 322, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3808, 322, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3809, 322, 'block_photos_legende_0_photo_l', '75'); 
INSERT INTO `wp_postmeta` VALUES (3810, 322, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3811, 322, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3812, 322, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3813, 322, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2001'); 
INSERT INTO `wp_postmeta` VALUES (3814, 322, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3815, 322, 'block_photos_legende_0_subtitle', 'Nous avons totalement remodelé le visage du cognac A. de Fussigny, sur demande de l’agence Farnham. Les couleurs identitaires contemporaines que la marque s’ est appropriées furent une base de travail intéressante pour générer des signes entre tradition et modernité. Nous avons dessiné le logo, composé d’un caractère contemporain aux formes masculines, et d’un animal imaginaire, mi-lion, mi-salamandre, emblème qui vient couronner la marque à la manière d’un blason. L’enjeu : Faire d’une enseigne de petit producteur local de Cognac, une marque internationale à l’esprit contemporain et masculin. '); 
INSERT INTO `wp_postmeta` VALUES (3816, 322, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3817, 322, 'block_photos_legende_1_photo_l', '76'); 
INSERT INTO `wp_postmeta` VALUES (3818, 322, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3819, 322, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3820, 322, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3821, 322, 'block_photos_legende_1_title', 'Logo placing. 2001'); 
INSERT INTO `wp_postmeta` VALUES (3822, 322, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3823, 322, 'block_photos_legende_1_subtitle', 'Les signes sont travaillés de manière synthétique pour s’adapter aux modes de reproduction utilisés, notamment la dorure, pour les déclinaisons de la marque sur les bouteilles et étuis.'); 
INSERT INTO `wp_postmeta` VALUES (3824, 322, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3825, 322, 'block_photos_legende_2_photo_l', '320'); 
INSERT INTO `wp_postmeta` VALUES (3826, 322, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3827, 322, 'block_photos_legende_2_photo_r', '321'); 
INSERT INTO `wp_postmeta` VALUES (3828, 322, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3829, 322, 'block_photos_legende_2_title', 'à écrire'); 
INSERT INTO `wp_postmeta` VALUES (3830, 322, '_block_photos_legende_2_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3831, 322, 'block_photos_legende_2_subtitle', ''); 
INSERT INTO `wp_postmeta` VALUES (3832, 322, '_block_photos_legende_2_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3833, 322, 'block_photos_legende', '3'); 
INSERT INTO `wp_postmeta` VALUES (3834, 322, '_block_photos_legende', 'field_538b9de882bff'); 
INSERT INTO `wp_postmeta` VALUES (3836, 323, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:500;s:6:"height";i:500;s:4:"file";s:24:"2014/07/cointreau_01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"cointreau_01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"cointreau_01-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"cointreau_01-500x372.png";s:5:"width";i:500;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3837, 324, '_wp_attached_file', '2014/07/cointreau_02.png'); 
INSERT INTO `wp_postmeta` VALUES (3838, 324, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:561;s:6:"height";i:500;s:4:"file";s:24:"2014/07/cointreau_02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"cointreau_02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:24:"cointreau_02-300x267.png";s:5:"width";i:300;s:6:"height";i:267;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"cointreau_02-561x372.png";s:5:"width";i:561;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3860, 326, '_wp_attached_file', '2014/07/dp_01.png'); 
INSERT INTO `wp_postmeta` VALUES (62568, 1871, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (62567, 1871, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (62566, 1871, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (62565, 1871, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (62564, 1871, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (62562, 1871, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (62563, 1871, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (62561, 1871, 'block_photos_legende_1_photo_l', '1132'); 
INSERT INTO `wp_postmeta` VALUES (62560, 1871, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (62559, 1871, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (62558, 1871, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (62557, 1871, 'block_photos_legende_0_subtitle', '• Expressing the brand heritage of the oldest of the great champagne houses.'); 
INSERT INTO `wp_postmeta` VALUES (62556, 1871, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3862, 327, '_wp_attached_file', '2014/07/dp_02.png'); 
INSERT INTO `wp_postmeta` VALUES (3863, 327, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:397;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_02-238x300.png";s:5:"width";i:238;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_02-397x372.png";s:5:"width";i:397;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3864, 328, '_wp_attached_file', '2014/07/dp_03.png'); 
INSERT INTO `wp_postmeta` VALUES (3865, 328, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:540;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_03.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_03-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_03-300x277.png";s:5:"width";i:300;s:6:"height";i:277;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_03-540x372.png";s:5:"width";i:540;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3866, 329, '_wp_attached_file', '2014/07/dp_04.png'); 
INSERT INTO `wp_postmeta` VALUES (3867, 329, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:540;s:6:"height";i:500;s:4:"file";s:17:"2014/07/dp_04.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"dp_04-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:17:"dp_04-300x277.png";s:5:"width";i:300;s:6:"height";i:277;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"dp_04-540x372.png";s:5:"width";i:540;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3905, 331, '_wp_attached_file', '2014/06/DR01.png'); 
INSERT INTO `wp_postmeta` VALUES (66326, 1916, '_block_photos_legende_2_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66325, 1916, 'block_photos_legende_2_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66324, 1916, '_block_photos_legende_2_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66323, 1916, 'block_photos_legende_2_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66322, 1916, '_block_photos_legende_2_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66317, 1916, 'block_photos_legende_2_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (66318, 1916, '_block_photos_legende_2_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66319, 1916, 'block_photos_legende_2_photo_r', '353'); 
INSERT INTO `wp_postmeta` VALUES (66320, 1916, '_block_photos_legende_2_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66321, 1916, 'block_photos_legende_2_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66316, 1916, '_block_photos_legende_2_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66315, 1916, 'block_photos_legende_2_photo_l', '352'); 
INSERT INTO `wp_postmeta` VALUES (66314, 1916, '_block_photos_legende_1_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66313, 1916, 'block_photos_legende_1_before-after', 'true'); 
INSERT INTO `wp_postmeta` VALUES (66312, 1916, '_block_photos_legende_1_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66310, 1916, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (66311, 1916, 'block_photos_legende_1_subtitle', '> Pour donner du relief à la marque, nous avons puisé dans son histoire et réinstallé comme identité visuelle un blason utilisé alors pour le marquage des fûts. \r\nLes lions se sont redressés, les armes sont mises en avant et une nouvelle devise vient orner le blason.'); 
INSERT INTO `wp_postmeta` VALUES (66309, 1916, 'block_photos_legende_1_title', 'Évolution des signes'); 
INSERT INTO `wp_postmeta` VALUES (66308, 1916, '_block_photos_legende_1_photo_gauche_iphone_v', 'field_551570dbae088'); 
INSERT INTO `wp_postmeta` VALUES (66307, 1916, 'block_photos_legende_1_photo_gauche_iphone_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66306, 1916, '_block_photos_legende_1_photo_gauche_iphone_h', 'field_55157097ae085'); 
INSERT INTO `wp_postmeta` VALUES (66305, 1916, 'block_photos_legende_1_photo_gauche_iphone_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66301, 1916, 'block_photos_legende_1_photo_gauche_ipad_h', ''); 
INSERT INTO `wp_postmeta` VALUES (66302, 1916, '_block_photos_legende_1_photo_gauche_ipad_h', 'field_55156fe993680'); 
INSERT INTO `wp_postmeta` VALUES (66303, 1916, 'block_photos_legende_1_photo_gauche_ipad_v', ''); 
INSERT INTO `wp_postmeta` VALUES (66304, 1916, '_block_photos_legende_1_photo_gauche_ipad_v', 'field_5515704193683'); 
INSERT INTO `wp_postmeta` VALUES (66300, 1916, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (66299, 1916, 'block_photos_legende_1_photo_r', '1183'); 
INSERT INTO `wp_postmeta` VALUES (66298, 1916, '_block_photos_legende_1_photo_m', 'field_53ece0b878c24'); 
INSERT INTO `wp_postmeta` VALUES (66297, 1916, 'block_photos_legende_1_photo_m', ''); 
INSERT INTO `wp_postmeta` VALUES (66296, 1916, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (66295, 1916, 'block_photos_legende_1_photo_l', '1182'); 
INSERT INTO `wp_postmeta` VALUES (66293, 1916, 'block_photos_legende_0_before-after', 'false'); 
INSERT INTO `wp_postmeta` VALUES (66294, 1916, '_block_photos_legende_0_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (66292, 1916, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (66291, 1916, 'block_photos_legende_0_subtitle', '• Bringing its full nobility to the Chateau de Pommard estate.\r\n'); 
INSERT INTO `wp_postmeta` VALUES (64898, 1899, '_block_photos_legende_2_before-after', 'field_53e4df62543ef'); 
INSERT INTO `wp_postmeta` VALUES (3906, 331, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:530;s:6:"height";i:500;s:4:"file";s:16:"2014/06/DR01.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"DR01-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"DR01-300x283.png";s:5:"width";i:300;s:6:"height";i:283;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"DR01-530x372.png";s:5:"width";i:530;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3907, 332, '_wp_attached_file', '2014/06/DR02.png'); 
INSERT INTO `wp_postmeta` VALUES (3908, 332, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:530;s:6:"height";i:500;s:4:"file";s:16:"2014/06/DR02.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"DR02-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"DR02-300x283.png";s:5:"width";i:300;s:6:"height";i:283;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"DR02-530x372.png";s:5:"width";i:530;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3909, 333, '_wp_attached_file', '2014/06/DR03.png'); 
INSERT INTO `wp_postmeta` VALUES (3910, 333, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:530;s:6:"height";i:500;s:4:"file";s:16:"2014/06/DR03.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"DR03-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"DR03-300x283.png";s:5:"width";i:300;s:6:"height";i:283;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"DR03-530x372.png";s:5:"width";i:530;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3911, 334, '_wp_attached_file', '2014/06/DR04.png'); 
INSERT INTO `wp_postmeta` VALUES (3912, 334, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:530;s:6:"height";i:500;s:4:"file";s:16:"2014/06/DR04.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"DR04-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:16:"DR04-300x283.png";s:5:"width";i:300;s:6:"height";i:283;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:16:"DR04-530x372.png";s:5:"width";i:530;s:6:"height";i:372;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:10:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";}}'); 
INSERT INTO `wp_postmeta` VALUES (3958, 336, '_wp_attached_file', '2014/07/lejay01.png'); 
INSERT INTO `wp_postmeta` VALUES (3914, 335, 'subtitle_name', 'visual identity & packaging'); 
INSERT INTO `wp_postmeta` VALUES (3915, 335, '_subtitle_name', 'field_538ba0e4f295f'); 
INSERT INTO `wp_postmeta` VALUES (3916, 335, 'block_photos_legende_0_photo_l', '70'); 
INSERT INTO `wp_postmeta` VALUES (3917, 335, '_block_photos_legende_0_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3918, 335, 'block_photos_legende_0_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3919, 335, '_block_photos_legende_0_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3920, 335, 'block_photos_legende_0_title', 'Logo design, drawing and lettering. 2013'); 
INSERT INTO `wp_postmeta` VALUES (3921, 335, '_block_photos_legende_0_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3922, 335, 'block_photos_legende_0_subtitle', 'L’identité des cuvées Dom Ruinart reflète le patrimoine et la culture de la plus ancienne maison de champagne.'); 
INSERT INTO `wp_postmeta` VALUES (3923, 335, '_block_photos_legende_0_subtitle', 'field_538b9ebe82c03'); 
INSERT INTO `wp_postmeta` VALUES (3924, 335, 'block_photos_legende_1_photo_l', '226'); 
INSERT INTO `wp_postmeta` VALUES (3925, 335, '_block_photos_legende_1_photo_l', 'field_538b9e4d82c00'); 
INSERT INTO `wp_postmeta` VALUES (3926, 335, 'block_photos_legende_1_photo_r', ''); 
INSERT INTO `wp_postmeta` VALUES (3927, 335, '_block_photos_legende_1_photo_r', 'field_538b9e7e82c01'); 
INSERT INTO `wp_postmeta` VALUES (3928, 335, 'block_photos_legende_1_title', ''); 
INSERT INTO `wp_postmeta` VALUES (3929, 335, '_block_photos_legende_1_title', 'field_538b9ea782c02'); 
INSERT INTO `wp_postmeta` VALUES (3930, 335, 'block_photos_legende_1_subtitle', ' Le volume du coffret a été rationnalisé avec une ouverture latérale et un système de fermeture élégant d’attaches parisiennes. '); 
INSER