/*jshint eqeqeq:false*/
/*global $:false, jQuery:false, box:false, _gaq:false, FB:false*/
var gapi, twttr;
box.getJDoc().ready(function() {
    var oL10nGeneric = box.get('l10n:generic'),
        oL10nErrors = box.get('l10n:error'),

        nTimerPopinFavLib,
        nTimerPopinTips,
        nItemTotal,
        sItemType,
        
        oPopin = box.get('ui').create('popin.generic', {
            maskHtml: '<div class="popin-mask"></div>',
            loaderHtml: '<div class="popin-loader">' + oL10nGeneric.loading + '</div>',
            preloadImage: true
        }),
        
        sErrorHtml = (
            '<div id="popin-error" class="popin popin-ysl">' +
                '<div class="popin-header">' +
                    '<a href="#" class="popin-close" data-box="label=ui:popin.generic;action=close">' + oL10nGeneric.close + '</a>' +
                    '<h2>{$title}</h2>' +
                '</div>' +
                
                '<div class="popin-core">' +
                    '<p>' + oL10nErrors.apologies + '</p>' +
                '</div>' +
                
                '<div class="popin-footer"></div>' +
            '</div>'
        ),
        
        getErrorHtml = function(sTitle) {
            return sErrorHtml.replace('{$title}', oL10nErrors[sTitle]);
        };
    
    oPopin.addToCache('error-generic', getErrorHtml('loading'));

    box.get('ui').create('popin.fav-lib');
    box.get('ui').create('popin.tips');
    
    function isFB() {
        return typeof FB === 'object' && !!FB;
    }

    function closeShareServices() {
        $('div.popin-services-share-content').removeClass('on').slideUp(function() {
            $(this).next().unbind('click').remove();
        });
    }
    
    function createSlideshow() {
        var $popin = $('#popin-slideshow'),
            $slideshow = $popin.find('div.slideshow'),
            oCom;
        if($slideshow.length) {
            oCom = box.get('ysl').create('slideshow.editorial', {
                rootElm: $slideshow
            });
            
            var nStart = oCom.contentElm.height(),
                nTop = parseInt($popin.css('top'), 10),
                nPopinHeight = $popin[0].offsetHeight,
                nSecurity = 20, // to avoid 1px scroll for example
                nMaxHeight = box.getJWin().height() - $popin.find('div.popin-header').height() - (oCom.rootElm.outerHeight() - oCom.rootElm.height()) - nSecurity;
            
            box.subscribe(
                {
                    name: 'requestheight>ysl:slideshow.editorial',
                    handler: function(oEvt) {
                        var oImgElm = oEvt.source.nextImgDatas.img,
                            nHeight = oImgElm.height,
                            nDescHeight = oEvt.source.description.totalHeight;
                        if(nHeight + nDescHeight > nMaxHeight) {
                            oImgElm.height = nMaxHeight - nDescHeight;
                            oImgElm.width *= (nMaxHeight - nDescHeight) / nHeight;
                        }
                    }
                }, {
                    name: 'changeheight>ysl:slideshow.editorial',
                    handler: function(oEvt) {
                        var nNewPopinHeight = $popin[0].offsetHeight;
                        if(nNewPopinHeight !== nPopinHeight) {
                            $popin.css('top', (nTop - (nNewPopinHeight - nPopinHeight) / 2) + 'px');
                            nNewPopinHeight = nPopinHeight;
                        }
                    }
                }
            );
        }
    }

    function clickOnMaskToClosePopin() {
        var sBoxData = this.getAttribute('data-box');
        if(!sBoxData || sBoxData.indexOf('close=none') == -1) {
            box.get('ui:popin.generic').close();
        }
    }
    
    box.subscribe(
        // xhr response treatment
        {
            name: [
                'response>ui:popin-xhr.generic',
                'response>ui:popin-xhr.fav-lib'
            ],
            handler: function(oEvt) {
                oEvt.preventDefault();
                var uResponse = oEvt.data.response;
                if(typeof uResponse == 'string' && uResponse) {
                    oEvt.source.done('success', uResponse);
                } else if(box.isObject(uResponse)) {
                    if(uResponse.action == 'URL_REDIRECT' && uResponse.data.url) {
                        box.getWin().location.href = uResponse.data.url;
                    }
                    if('total' in uResponse.data && 'type' in uResponse.data) {
                        nItemTotal = uResponse.data.total;
                        sItemType = uResponse.data.type;
                    }
                    if(uResponse.data.html) {
                        oEvt.source.done('success', uResponse.data.html);
                    } else {
                        oEvt.source.done('error', 'generic');
                    }
                } else {
                    oEvt.source.done('error', 'generic');
                }
            }
        },

        // moodboard / search push click
        {
            name: 'confirmopening>ui:popin.generic',
            handler: function(oEvt) {
                var oData = oEvt.source.pending,
                    sUrl = oData.url;
                if(oData.mbPushId && sUrl) {
                    if(sUrl.indexOf('?') > -1) {
                        sUrl += '&mbPushId=' + oData.mbPushId;
                    } else {
                        sUrl += '?mbPushId=' + oData.mbPushId;
                    }
                    oData.url = sUrl;
                }
            }
        },

        // generic positioning and animations
        {
            name: 'insert>ui:popin.generic',
            handler: function(oEvt) {
                oEvt.source.setPosition({ self: 'bc', to: 'tc' }, 'viewport');
                var oPageScroll = box.get('ysl:page-scroll.moodboard');
                if(oPageScroll) {
                    oPageScroll.disableScrolling();
                }
            }
        }, {
            name: 'beforeopen>ui:popin.generic',
            handler: function(oEvt) {
                oEvt.preventDefault();
                var oPositions = oEvt.source.getPosition({ self: 'cc', to: 'cc' }, 'viewport'),
                    nOffsetTop = box.getJWin().scrollTop();
                if(oPositions.top < nOffsetTop) {
                    oPositions.top = nOffsetTop;
                }
                oEvt.source.animate({ top: oPositions.top, left: oPositions.left }, 600);
            }
        }, {
            name: 'beforeclose>ui:popin.generic',
            handler: function(oEvt) {
                oEvt.preventDefault();
                var oPositions = oEvt.source.getPosition({ self: 'bc', to: 'tc' }, 'viewport');
                oEvt.source.animate({ top: oPositions.top, left: oPositions.left }, 500);
            }
        }, {
            name: 'open>ui:popin.generic',
            handler: function(oEvt) {
                oEvt.preventDefault();
                var $popin = oEvt.source.rootElm,
                    $services = $popin.find('.popin-services'),
                    $fb = $popin.find('.popin-services-facebook'),
                    $share = $popin.find('.popin-services-share-content'),
                    sTag = $popin.attr('data-ga');
                if($services.length > 0) {
                    box.get('ui').create('tooltip.popin-share', {
                        rootHtml: '<div class="popin-tooltip"></div>',
                        srcElm: $services.find('> li:not(.popin-services-facebook) > a'),
                        position: 'bc',
                        delay: 500,
                        offsetBottom: 1
                    });
                }
                if(isFB() && $fb.find('.fb-like').length) {
                    FB.XFBML.parse($fb[0]);
                }
                if($share.length && gapi && twttr) {
                    $share.appendTo($popin.find('.popin-core'));
                    gapi.plusone.go($share[0]);
                    twttr.widgets.load();
                }
                if(sTag) {
                    _gaq.push([ '_trackPageview', sTag ]);
                }
            }
        }, {
            name: 'close>ui:popin.generic',
            handler: function() {
                box.get('ui').destroy('tooltip.popin-share');
                var oPageScroll = box.get('ysl:page-scroll.moodboard');
                if(oPageScroll) {
                    oPageScroll.enableScrolling();
                }
            }
        }, {
            name: 'beforeopen>ui:popin-mask.generic',
            handler: function(oEvt) {
                oEvt.preventDefault();
                oEvt.source.setStyles({ opacity: 0 }).animate({ opacity: 0.9 }, 300);
            }
        }, {
            name: 'open>ui:popin-mask.generic',
            handler: function(oEvt) {
                oEvt.source.rootElm.click(clickOnMaskToClosePopin);
            }
        }, {
            name: 'beforeclose>ui:popin-mask.generic',
            handler: function(oEvt) {
                oEvt.preventDefault();
                oEvt.source.rootElm.unbind('click');
                oEvt.source.animate({ opacity: 0 }, 300);
            }
        }, {
            name: 'beforeopen>ui:popin-loader.generic',
            handler: function(oEvt) {
                oEvt.preventDefault();
                oEvt.source.setStyles({ opacity: 0 }).animate({ opacity: 1 }, 200);
            }
        }, {
            name: 'beforeclose>ui:popin-loader.generic',
            handler: function(oEvt) {
                oEvt.preventDefault();
                oEvt.source.animate({ opacity: 0 }, 200);
            }
        },

        // favorites / library positioning and animations
        {
            name: 'insert>ui:popin.fav-lib',
            handler: function(oEvt) {
                var oParentElm = box.get('ui:popin.fav-lib').current.element.parentNode,
                    oPos = oEvt.source.setStyles({ opacity: 0 }).getPosition({ self: 'tr', to: 'br', offsetTop: 10 }, oParentElm);
                oEvt.source.setStyles({ top: oPos.top + 3, left: oPos.left });
            }
        }, {
            name: 'open>ui:popin.fav-lib',
            handler: function() {
                if(sItemType && !isNaN(nItemTotal)) {
                    $('#nav-nb-' + sItemType).html(nItemTotal);
                }
                nTimerPopinFavLib = box.getWin().setTimeout(function() {
                    box.get('ui:popin.fav-lib').close();
                }, 2500);
            }
        }, {
            name: 'beforeopen>ui:popin.fav-lib',
            handler: function(oEvt) {
                oEvt.preventDefault();
                oEvt.source.animate({ opacity: 1 }, 600);
            }
        }, {
            name: 'beforeclose>ui:popin.fav-lib',
            handler: function(oEvt) {
                nItemTotal = sItemType = null;
                box.getWin().clearTimeout(nTimerPopinFavLib);
                oEvt.preventDefault();
                oEvt.source.animate({ opacity: 0 }, 600);
            }
        },

        // tips
        {
            name: 'insert>ui:popin.tips',
            handler: function(oEvt) {
                oEvt.source.rootElm.css('opacity', 0);
            }
        }, {
            name: 'open>ui:popin.tips',
            handler: function() {
                nTimerPopinTips = box.getWin().setTimeout(function() {
                    box.get('ui:popin.tips').close();
                }, 5000);
            }
        }, {
            name: 'beforeopen>ui:popin.tips',
            handler: function(oEvt) {
                oEvt.preventDefault();
                oEvt.source.animate({ opacity: 1 }, 600);
            }
        }, {
            name: 'beforeclose>ui:popin.tips',
            handler: function(oEvt) {
                box.getWin().clearTimeout(nTimerPopinTips);
                oEvt.preventDefault();
                oEvt.source.animate({ opacity: 0 }, 600);
            }
        },
        
        // specific rules
        {
            name: 'insert>ui:popin.generic.editorial',
            handler: function(oEvt) {
                var $scrollable = $('#popin-editorial div.scrollable');
                if($scrollable.length) {
                    box.get('ui').create('scrollable.editorial', {
                        rootElm: '#popin-editorial div.scrollable',
                        bar: true,
                        insertMethod: 'appendTo',
                        insertTarget: oEvt.source.rootElm
                    });
                }
                
            }
        }, {
            name: 'open>ui:popin.generic.editorial',
            handler: function() {
                // force a new compute on scroll
                // Firefox doesn't contain margin on first compute, for some reason
                var oScroll = box.get('ui:scrollable.editorial');
                if(oScroll) {
                    oScroll.compute();
                }
                createSlideshow();
            }
        }, {
            name: 'close>ui:popin.generic.editorial',
            handler: function() {
                box.get('ui').destroy('scrollable.editorial');
                box.get('ysl').destroy('slideshow.editorial');
                box.unsubscribe(
                    'requestheight>ysl:slideshow.editorial',
                    'changeheight>ysl:slideshow.editorial'
                );
            }
        }, {
            name: 'open>ui:popin.generic.slideshow',
            handler: createSlideshow
        }, {
            name: 'close>ui:popin.generic.slideshow',
            handler: function() {
                box.get('ysl').destroy('slideshow.editorial');
                box.unsubscribe(
                    'requestheight>ysl:slideshow.editorial',
                    'changeheight>ysl:slideshow.editorial'
                );
            }
        }, {
            name: 'open>ui:popin.generic.video',
            handler: function() {
                var $video = $('#popin-video-container'),
                    sUrl = $video.data('url') + '&wmode=transparent';
                $video.html('<iframe width="705" height="388" src="' + sUrl + '" frameborder="0" allowfullscreen></iframe>');
            }
        }, {
            name: 'open>ui:popin.generic.audio',
            handler: function() {
                var oL10nPlayer = box.get('l10n:player');
                box.get('ysl').create('audio.popin-audio', {
                    rootElm: $('#popin-audio-content .popin-audio-player'),
                    htmlLoader : '<span class="audio-player-loader">' + oL10nGeneric.loading + '</span>',
                    labelPlay: oL10nPlayer.play,
                    labelPause: oL10nPlayer.pause,
                    urlFlash: oL10nPlayer.urlFlash
                });
            }
        }, {
            name: 'close>ui:popin.generic.audio',
            handler: function() {
                box.get('ysl').destroy('audio.popin-audio');
            }
        },

        // Tooltips
        {
            name: 'requestcontent>ui:tooltip.popin-share',
            handler: function(oEvt){
                var $src = oEvt.source.datas.srcElm;
                if(!$src.hasClass('nav-no-tooltip') && !$src.hasClass('on')) {
                    oEvt.source.setContent($src.html());
                }
            }
        }, {
            name: 'insert>ui:tooltip.popin-share',
            handler: function(oEvt) {
                oEvt.source.rootElm.css('opacity', '0');
            }
        }, {
            name: 'beforeopen>ui:tooltip.popin-share',
            handler: function(oEvt) {
                oEvt.source.animate({ opacity: 1 }, 300);
            }
        }, {
            name: 'beforeclose>ui:tooltip.popin-share',
            handler: function(oEvt) {
                oEvt.source.animate({ opacity: 0 }, 300);
            }
        },
        // Popins Toolbar
        {
            name: 'click>popin-services-share',
            handler: function(oEvt) {
                oEvt.data.originalEvent.preventDefault();
                var $popinCore = box.get('ui:popin.generic').popin.rootElm.find('.popin-core'),
                    $shareContent = $popinCore.find('.popin-services-share-content');
                if(!$shareContent.hasClass('on')) {
                    $('<div class="popin-services-share-content-mask"></div>').appendTo($popinCore).click(closeShareServices);
                    $shareContent.addClass('on').slideDown();
                } else {
                    closeShareServices();
                }
            }
        }
    );
});