/*global box:false*/
box.store('ysl').addConfig('paginate', {
    itemSelector: 'li',
    itemsPerPage: 10,
    htmlContent: '<div class="paginate-content"></div>',
    htmlNav: '<div class="paginate-nav"><ul>{$pages}</ul></div>',
    htmlNavPage: '<li><a href="#"{$data}>{$page}</a></li>',
    htmlNavFirst: '<li><a href="#"{$data}>&lt;&lt;</a></li>',
    htmlNavLast: '<li><a href="#"{$data}>&gt;&gt;</a></li>',
    htmlNavPrev: '<li><a href="#"{$data}>&lt;</a></li>',
    htmlNavNext: '<li><a href="#"{$data}>&gt;</a></li>',
    clsActive: 'page-on',
    clsFirst: 'paginate-first',
    clsLast: 'paginate-last'
}).addConstructor('paginate', function($, box) {
    var getWithBoxData, getNavHtml, checkClick, manageClick,
        oProto;
    
    getWithBoxData = function(sHtml, sName, sAction) {
        var sData = ' data-box="label=' + sName +';action=' + sAction + '"';
        return sHtml.replace('{$data}', sData);
    };

    getNavHtml = function(oCom) {
        var oCfg = oCom.cfg,
            sItem = oCfg.htmlNavPage,
            sName = oCom.boxGetName(),
            sHtml = '',
            i = 0,
            l = oCom.pages;
        if(oCom.firstLastBtn) {
            sHtml += getWithBoxData(oCfg.htmlNavFirst, sName, 'first');
        }
        if(oCom.prevNextBtn) {
            sHtml += getWithBoxData(oCfg.htmlNavPrev, sName, 'previous');
        }
        while(++i <= l) {
            sHtml += getWithBoxData(sItem, sName, i).replace('{$page}', i);
        }
        if(oCom.prevNextBtn) {
            sHtml += getWithBoxData(oCfg.htmlNavNext, sName, 'next');
        }
        if(oCom.firstLastBtn) {
            sHtml += getWithBoxData(oCfg.htmlNavLast, sName, 'last');
        }
        return oCfg.htmlNav.replace('{$pages}', sHtml);
    };
    
    checkClick = function(oElm) {
        return oElm.tagName === 'A';
    };
    
    manageClick = function(oEvt) {
        var oData = oEvt.data,
            sAction = oData.action;
        oData.originalEvent.preventDefault();
        if(typeof this[sAction] === 'function') {
            this[sAction]();
        } else {
            this.go(parseInt(sAction, 10));
        }
    };
    
    oProto = {
        boxConfigure: function(oDefaultCfg, oDatas) {
            if(typeof oDatas.itemSelector && oDatas.itemSelector) {
                oDefaultCfg.itemSelector = oDatas.itemSelector;
            }
            if(!isNaN(oDatas.itemsPerPage) && oDatas.itemsPerPage >= 1) {
                oDefaultCfg.itemsPerPage = parseInt(oDatas.itemsPerPage, 10);
            }
            if(typeof oDatas.htmlContent === 'string' && oDatas.htmlContent) {
                oDefaultCfg.htmlContent = oDatas.htmlContent;
            }
            if(typeof oDatas.htmlNav === 'string' && oDatas.htmlNav.indexOf('{$pages}') > -1) {
                oDefaultCfg.htmlNav = oDatas.htmlNav;
            }
            if(
                typeof oDatas.htmlNavPage === 'string' &&
                oDatas.htmlNavPage.indexOf('{$data}') > -1 &&
                oDatas.htmlNavPage.indexOf('{$page}') > -1
            ) {
                oDefaultCfg.htmlNavPage = oDatas.htmlNavPage;
            }
            if(typeof oDatas.htmlNavFirst === 'string' && oDatas.htmlNavFirst.indexOf('{$data}') > -1) {
                oDefaultCfg.htmlNavFirst = oDatas.htmlNavFirst;
            }
            if(typeof oDatas.htmlNavLast === 'string' && oDatas.htmlNavLast.indexOf('{$data}') > -1) {
                oDefaultCfg.htmlNavLast = oDatas.htmlNavLast;
            }
            if(typeof oDatas.htmlNavPrev === 'string' && oDatas.htmlNavPrev.indexOf('{$data}') > -1) {
                oDefaultCfg.htmlNavPrev = oDatas.htmlNavPrev;
            }
            if(typeof oDatas.htmlNavNext === 'string' && oDatas.htmlNavNext.indexOf('{$data}') > -1) {
                oDefaultCfg.htmlNavNext = oDatas.htmlNavNext;
            }
            if(typeof oDatas.clsActive === 'string' && oDatas.clsActive) {
                oDefaultCfg.clsActive = oDatas.clsActive;
            }
            if(typeof oDatas.clsInactive === 'string' && oDatas.clsInactive) {
                oDefaultCfg.clsInactive = oDatas.clsInactive;
            }
            this.cfg = oDefaultCfg;
        },
        
        boxCreate: function(oDatas) {
            var oCom = this,
                oCfg = oCom.cfg;
            
            oCom.init = true;
            oCom.firstLastBtn = oDatas.firstLastBtn === true;
            oCom.prevNextBtn = oDatas.prevNextBtn === true;
            oCom.rootElm = $(oDatas.rootElm);
            oCom.datas = [];
            oCom.rootElm.find(oCfg.itemSelector).each(function(i, oElm) {
                oCom.datas.push($(oElm).boxOuterHTML());
            });
            oCom.pages = Math.ceil(oCom.datas.length / oCfg.itemsPerPage);
            if(oCom.pages > 1) {
                oCom.wrapperElm = $(oCfg.htmlContent + getNavHtml(oCom)).insertAfter(oCom.rootElm);
                oCom.rootElm.remove();
                box.subscribe({
                    name: 'click@box>' + oCom.boxGetName(),
                    context: oCom,
                    handler: manageClick
                });
                box.get('util:delegate-click').start();
                oCom.boxPublish('ready');
                oCom.go(1);
            } else {
                oCom.wrapperElm = $(oCfg.htmlContent).insertAfter(oCom.rootElm);
                oCom.rootElm.appendTo(oCom.wrapperElm);
                oCom.boxPublish('onepage');
            }
        },
        
        boxDestroy: function() {
            if(this.pages > 1) {
                box.unsubscribe('click@box>' + this.boxGetName());
            }
        },
        
        go: function(nIndex) {
            if(!isNaN(nIndex) && nIndex >= 1 && nIndex <= this.pages && nIndex !== this.current) {
                var nItemsPerPage = this.cfg.itemsPerPage,
                    nStart = (nIndex - 1) * nItemsPerPage,
                    nEnd = nIndex * nItemsPerPage,
                    oCfg = this.cfg;
                this.rootElm.html(this.datas.slice(nStart, nEnd).join('')).appendTo(this.wrapperElm.eq(0));
                this.wrapperElm.eq(1).find('a.' + oCfg.clsActive).removeClass(oCfg.clsActive);
                this.wrapperElm.eq(1).find('a[data-box$="action=' + nIndex + '"]').addClass(oCfg.clsActive);
                this.wrapperElm.eq(1).removeClass(oCfg.clsFirst).removeClass(oCfg.clsLast);
                if(nIndex === 1) {
                    this.wrapperElm.eq(1).addClass(oCfg.clsFirst);
                } else if(nIndex === this.pages) {
                    this.wrapperElm.eq(1).addClass(oCfg.clsLast);
                }
                this.current = nIndex;
                this.boxPublish('change', { init: this.init });
                this.init = false;
            }
        },
        
        first: function() {
            if(this.current !== 1) {
                this.go(1);
            }
        },
        
        last: function() {
            if(this.current !== this.pages) {
                this.go(this.pages);
            }
        },
        
        previous: function() {
            this.go(this.current - 1);
        },
        
        next: function() {
            this.go(this.current + 1);
        }
    };
    
    return box.get('util:component').create({
        extend: oProto
    });
});