/*jshint eqeqeq:false, strict:false*/
/*global $:false, jQuery:false, swfobject:false, box:false*/
box.store('ysl').addConfig('audio', {
    clsContent: 'audio-player-controls',
    clsPlay: 'audio-player-play',
    clsPause: 'audio-player-pause',
    clsFlash: 'audio-player-flash',
    htmlFlash: '<div id="{$clsFlash}"></div>',
    htmlContent: '<div class="{$clsContent}"></div>',
    htmlPlay: '<button class="{$clsPlay}">Play</button>',    
    htmlLoader : '<span class="audio-player-loader"></span>',
    htmlPlaybar : '<div class="audio-player-playbar"></div>',
    htmlPlaybarTimer : '<span class="audio-player-timer"><span class="audio-player-current">0:00</span> / <span class="audio-player-duration">0:00</span></span>'
}).addConstructor('audio', function ($, box) {
    document.createElement('audio'); // for IE
    
    var secondsToMinutes,
        oProto;
        
    secondsToMinutes = function (nTotalSeconds) {
        var nMinutes = Math.floor(nTotalSeconds / 60),
            nSeconds = Math.floor(nTotalSeconds - nMinutes * 60);
        //if (nMinutes < 10) { nMinutes = '0'+nMinutes; }

        if (nSeconds < 10) {
            nSeconds = '0' + nSeconds;
        }
        var nTotalMinutes = nMinutes + ':' + nSeconds;
        return nTotalMinutes;
    };
    
    oProto = {
        boxConfigure: function (oDefaultCfg, oDatas) {
            if(oDatas.htmlLoader) {
                oDefaultCfg.htmlLoader = oDatas.htmlLoader;
            }
            if(oDatas.labelPlay) {
                oDefaultCfg.labelPlay = oDatas.labelPlay;
            }
            if(oDatas.labelPause) {
                oDefaultCfg.labelPause = oDatas.labelPause;
            }
            if(oDatas.urlFlash) {
                oDefaultCfg.urlFlash = oDatas.urlFlash;
            }
            this.cfg = oDefaultCfg;
        },
        boxCreate: function (oDatas) {
            var oThis = this,
                oCfg = this.cfg,
                reCanPlay = /^(?:yes|maybe)$/,
                sUA = navigator.userAgent;

            this.rootElm = $(oDatas.rootElm);
            this.audioElm = this.rootElm.find('audio');

            if(box.areHostMethods(this.audioElm[0], 'play', 'pause', 'canPlayType') && reCanPlay.test(this.audioElm[0].canPlayType('audio/mpeg'))) {
                this.rootElm.append(oCfg.htmlLoader);
                
                if(sUA.match(/iPad/)) {
                    oThis.displayControls(true);
                } else if(this.audioElm[0].duration > 0) {
                    oThis.displayControls(false);
                } else {
                    this.audioElm.bind('loadedmetadata', function () {
                        oThis.displayControls(false);
                    });
                }
            } else {
                this.displayFlash();
            }
        },
        boxDestroy: function() {
            this.pause();
            if(this.flashElm) {
                this.flashElm.remove();
            }
        },
        displayControls: function (bWaitForClick) {
            if(this.rendered) {
                return;
            }
            var $rootElm = this.rootElm,
                oThis = this,
                oCfg = this.cfg,
                nDuration = Math.round(oThis.audioElm[0].duration * 100) / 100;
            
            this.nDuration = nDuration;
            
            $rootElm.find('.audio-player-loader').remove();
            
            // Create Button Play/Pause
            $rootElm.prepend(oCfg.htmlContent.replace('{$clsContent}', oCfg.clsContent));
            $rootElm.find('.' + oCfg.clsContent).append(oCfg.htmlPlay.replace('{$clsPlay}', oCfg.clsPlay));
                
            // Listen play/pause button
            $rootElm.find('.' + oCfg.clsContent + ' button').click(function(e) {
                if ($(this).attr('class') === oCfg.clsPlay) {
                    oThis.play();
                    
                    if(!oThis.compControls) {
                        $rootElm.find('.' + oCfg.clsContent).append(oCfg.htmlLoader);
                        setTimeout(function(){
                            oThis.nDuration = Math.round(oThis.audioElm[0].duration * 100) / 100;
                            $rootElm.find('.audio-player-loader').remove();
                            if(oThis.nDuration > 0) {
                                oThis.displayCompControls();
                            }
                        }, 500);
                    }
                } else {
                    oThis.pause();
                }
            });
            
            if(nDuration > 0){
                oThis.displayCompControls();
            }

            //Listen timeupdate
            oThis.audioElm.bind('timeupdate', function () {
                if(oThis.compControls){
                    var nCurrentTime = Math.round(oThis.audioElm[0].currentTime * 100) / 100;
                    oThis.goToTime(nCurrentTime, true);
                }
            });
            // Listen the end of the video
            oThis.audioElm.bind('ended', function () {
                $rootElm.find('button').removeClass(oCfg.clsPause).addClass(oCfg.clsPlay);
                oThis.audioElm[0].pause();
            });
            
            this.mode = 'native';
            this.rendered = true;
        },
        displayCompControls: function () {
            var $rootElm = this.rootElm,
                oThis = this,
                oCfg = this.cfg,
                nDuration = this.nDuration,
                nDurationMinutes = secondsToMinutes(nDuration);
                
            // Create Playbar
            $rootElm.find('.' + oCfg.clsContent).append(oCfg.htmlPlaybar);
            $rootElm.find('.audio-player-playbar').append(oCfg.htmlPlaybarTimer);
            $rootElm.find('.audio-player-duration').html(nDurationMinutes);

            var oSlider = box.get('ui').create('slider.playbar-' + oThis.id, {
                targetElm: $rootElm.find('.audio-player-playbar'),
                min: 0,
                max: nDuration || 60,
                step: 0.01,
                altStep: 0.1
            });

            box.subscribe({
                name: 'clickrail>ui:slider.playbar-'+oThis.id,
                handler: function (oEvt) {
                    var nTime = oEvt.source.unit * oEvt.data.left,
                        sFormatTime = secondsToMinutes(nTime);
                    oThis.audioElm[0].currentTime = nTime;
                    oThis.play();
                }
            });
            
            this.compControls = true;
        },
        displayFlash: function () {
            if(this.rendered) {
                return;
            }

            this.audioElm.parent().append(this.cfg.htmlFlash.replace('{$clsFlash}', this.cfg.clsFlash));
            
            var flashvars = { musicPath : this.audioElm.attr('src') },
                params = { menu: "false", allowFullScreen: "true", wmode: "opaque" },
                attributes = { id: "flash-player-" + this.id };
            
            swfobject.embedSWF(this.cfg.urlFlash, this.cfg.clsFlash, "127", "85", "9.0.0", "", flashvars, params, attributes);
            
            this.flashId = '#flash-player-' + this.id;
            this.flashElm = $(this.flashId);
            this.mode = 'flash';
            this.rendered = true;
        },
        play: function () {
            var oCfg = this.cfg,
                $rootElm = $(this.rootElm),
                oThis = this;
            
            if (this.mode === 'native') {
                this.rootElm
                    .find('.' + oCfg.clsContent + ' button')
                        .removeClass(oCfg.clsPlay)
                        .addClass(oCfg.clsPause)
                        .html(oCfg.labelPause);
                this.audioElm[0].play();
            } else if (this.mode === 'flash') {
                if (this.loaded) {
                    $(this.flashId)[0].resumeMedia(1);
                } else {
                    $(this.flashId)[0].playMedia(this.audioElm.attr('src'), 0, 1, 1);
                    this.loaded = true;
                }
            }            
        },
        pause: function () {
            var oCfg = this.cfg,
                $rootElm = $(this.rootElm),
                $playPauseBtn = $rootElm.find('.' + oCfg.clsContent + ' button');

            if (this.mode === 'native') {
                $playPauseBtn.removeClass(oCfg.clsPause)
                             .addClass(oCfg.clsPlay)
                             .html(oCfg.labelPlay);
                this.audioElm[0].pause();
            } else if (this.mode === 'flash') {
                try {
                    // for IE7 at least, when media has not been playing at all
                    this.flashElm[0].pauseMedia();
                } catch(oErr) {}
            }
        },
        goToTime: function (nCurrentTime, currentlyPlaying) {
            var $rootElm = $(this.rootElm),
                sCurrentTime = secondsToMinutes(nCurrentTime);
            
            if (this.mode === 'native') {
                if (!currentlyPlaying) {
                    this.audioElm[0].currentTime = nCurrentTime;
                }
                box.get('ui:slider.playbar-' + this.id).setValue(nCurrentTime);
                $rootElm.find('.audio-player-current').html(sCurrentTime);

            } else {
                $(this.flashId)[0].seekMedia(nCurrentTime * 1000, 1);
            }
        }
    };

    return box.get('util:component').create({
        extend: oProto
    });
});